import{s as bl,n as Bl,o as Cl}from"../chunks/scheduler.56730f09.js";import{S as _l,i as Zl,g as n,s as a,r as c,A as kl,h as M,f as e,c as p,j as hl,u as o,x as i,k as Il,y as Vl,a as t,v as r,d as y,t as j,w as d}from"../chunks/index.1f144517.js";import{C as J}from"../chunks/CodeBlock.738eeccb.js";import{H as Ss}from"../chunks/Heading.57d46534.js";function Al(Ps){let T,ps,ts,ns,w,Ms,m,Ls='이 가이드에서는 사용자 정의 파이프라인을 어떻게 생성하고 <a href="https://hf.co/models" rel="nofollow">허브</a>에 공유하거나 🤗 Transformers 라이브러리에 추가하는 방법을 살펴보겠습니다.',is,u,Ks=`먼저 파이프라인이 수용할 수 있는 원시 입력을 결정해야 합니다.
문자열, 원시 바이트, 딕셔너리 또는 가장 원하는 입력일 가능성이 높은 것이면 무엇이든 가능합니다.
이 입력을 가능한 한 순수한 Python 형식으로 유지해야 (JSON을 통해 다른 언어와도) 호환성이 좋아집니다.
이것이 전처리(<code>preprocess</code>) 파이프라인의 입력(<code>inputs</code>)이 될 것입니다.`,cs,U,Ds=`그런 다음 <code>outputs</code>를 정의하세요.
<code>inputs</code>와 같은 정책을 따르고, 간단할수록 좋습니다.
이것이 후처리(<code>postprocess</code>) 메소드의 출력이 될 것입니다.`,os,f,Os="먼저 4개의 메소드(<code>preprocess</code>, <code>_forward</code>, <code>postprocess</code> 및 <code>_sanitize_parameters</code>)를 구현하기 위해 기본 클래스 <code>Pipeline</code>을 상속하여 시작합니다.",rs,h,ys,I,sl="이 분할 구조는 CPU/GPU에 대한 비교적 원활한 지원을 제공하는 동시에, 다른 스레드에서 CPU에 대한 사전/사후 처리를 수행할 수 있게 지원하는 것입니다.",js,b,ll=`<code>preprocess</code>는 원래 정의된 입력을 가져와 모델에 공급할 수 있는 형식으로 변환합니다.
더 많은 정보를 포함할 수 있으며 일반적으로 <code>Dict</code> 형태입니다.`,ds,B,el=`<code>_forward</code>는 구현 세부 사항이며 직접 호출할 수 없습니다.
<code>forward</code>는 예상 장치에서 모든 것이 작동하는지 확인하기 위한 안전장치가 포함되어 있어 선호되는 호출 메소드입니다.
실제 모델과 관련된 것은 <code>_forward</code> 메소드에 속하며, 나머지는 전처리/후처리 과정에 있습니다.`,Js,C,tl="<code>postprocess</code> 메소드는 <code>_forward</code>의 출력을 가져와 이전에 결정한 최종 출력 형식으로 변환합니다.",Ts,_,al="<code>_sanitize_parameters</code>는 초기화 시간에 <code>pipeline(...., maybe_arg=4)</code>이나 호출 시간에 <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>과 같이, 사용자가 원하는 경우 언제든지 매개변수를 전달할 수 있도록 허용합니다.",ws,Z,pl=`<code>_sanitize_parameters</code>의 반환 값은 <code>preprocess</code>, <code>_forward</code>, <code>postprocess</code>에 직접 전달되는 3개의 kwargs 딕셔너리입니다.
호출자가 추가 매개변수로 호출하지 않았다면 아무것도 채우지 마십시오.
이렇게 하면 항상 더 “자연스러운” 함수 정의의 기본 인수를 유지할 수 있습니다.`,ms,k,nl="분류 작업에서 <code>top_k</code> 매개변수가 대표적인 예입니다.",us,V,Us,A,Ml="이를 달성하기 위해 우리는 <code>postprocess</code> 메소드를 기본 매개변수인 <code>5</code>로 업데이트하고 <code>_sanitize_parameters</code>를 수정하여 이 새 매개변수를 허용합니다.",fs,R,hs,G,il=`입/출력을 가능한 한 간단하고 완전히 JSON 직렬화 가능한 형식으로 유지하려고 노력하십시오.
이렇게 하면 사용자가 새로운 종류의 개체를 이해하지 않고도 파이프라인을 쉽게 사용할 수 있습니다.
또한 사용 용이성을 위해 여러 가지 유형의 인수(오디오 파일은 파일 이름, URL 또는 순수한 바이트일 수 있음)를 지원하는 것이 비교적 일반적입니다.`,Is,W,bs,g,cl="<code>new-task</code>를 지원되는 작업 목록에 등록하려면 <code>PIPELINE_REGISTRY</code>에 추가해야 합니다:",Bs,H,Cs,N,ol="원하는 경우 기본 모델을 지정할 수 있으며, 이 경우 특정 개정(분기 이름 또는 커밋 해시일 수 있음, 여기서는 “abcdef”)과 타입을 함께 가져와야 합니다:",_s,E,Zs,X,ks,q,rl=`Hub에 사용자 정의 파이프라인을 공유하려면 <code>Pipeline</code> 하위 클래스의 사용자 정의 코드를 Python 파일에 저장하기만 하면 됩니다.
예를 들어, 다음과 같이 문장 쌍 분류를 위한 사용자 정의 파이프라인을 사용한다고 가정해 보겠습니다:`,Vs,v,As,$,yl=`구현은 프레임워크에 구애받지 않으며, PyTorch와 TensorFlow 모델에 대해 작동합니다.
이를 <code>pair_classification.py</code>라는 파일에 저장한 경우, 다음과 같이 가져오고 등록할 수 있습니다:`,Rs,z,Gs,Q,jl=`이 작업이 완료되면 사전훈련된 모델과 함께 사용할 수 있습니다.
예를 들어, <code>sgugger/finetuned-bert-mrpc</code>은 MRPC 데이터 세트에서 미세 조정되어 문장 쌍을 패러프레이즈인지 아닌지를 분류합니다.`,Ws,F,gs,x,dl="그런 다음 <code>Repository</code>의 <code>save_pretrained</code> 메소드를 사용하여 허브에 공유할 수 있습니다:",Hs,Y,Ns,S,Jl=`이렇게 하면 “test-dynamic-pipeline” 폴더 내에 <code>PairClassificationPipeline</code>을 정의한 파일이 복사되며, 파이프라인의 모델과 토크나이저도 저장한 후, <code>{your_username}/test-dynamic-pipeline</code> 저장소에 있는 모든 것을 푸시합니다.
이후에는 <code>trust_remote_code=True</code> 옵션만 제공하면 누구나 사용할 수 있습니다.`,Es,P,Xs,L,qs,K,Tl="🤗 Transformers에 사용자 정의 파이프라인을 기여하려면, <code>pipelines</code> 하위 모듈에 사용자 정의 파이프라인 코드와 함께 새 모듈을 추가한 다음, <code>pipelines/__init__.py</code>에서 정의된 작업 목록에 추가해야 합니다.",vs,D,wl=`그런 다음 테스트를 추가해야 합니다.
<code>tests/test_pipelines_MY_PIPELINE.py</code>라는 새 파일을 만들고 다른 테스트와 예제를 함께 작성합니다.`,$s,O,ml="<code>run_pipeline_test</code> 함수는 매우 일반적이며, <code>model_mapping</code> 및 <code>tf_model_mapping</code>에서 정의된 가능한 모든 아키텍처의 작은 무작위 모델에서 실행됩니다.",zs,ss,ul=`이는 향후 호환성을 테스트하는 데 매우 중요하며, 누군가 <code>XXXForQuestionAnswering</code>을 위한 새 모델을 추가하면 파이프라인 테스트가 해당 모델에서 실행을 시도한다는 의미입니다.
모델이 무작위이기 때문에 실제 값을 확인하는 것은 불가능하므로, 단순히 파이프라인 출력 <code>TYPE</code>과 일치시키기 위한 도우미 <code>ANY</code>가 있습니다.`,Qs,ls,Ul="또한 2개(이상적으로는 4개)의 테스트를 구현해야 합니다.",Fs,es,fl=`<li><code>test_small_model_pt</code>: 이 파이프라인에 대한 작은 모델 1개를 정의(결과가 의미 없어도 상관없음)하고 파이프라인 출력을 테스트합니다.
결과는 <code>test_small_model_tf</code>와 동일해야 합니다.</li> <li><code>test_small_model_tf</code>: 이 파이프라인에 대한 작은 모델 1개를 정의(결과가 의미 없어도 상관없음)하고 파이프라인 출력을 테스트합니다.
결과는 <code>test_small_model_pt</code>와 동일해야 합니다.</li> <li><code>test_large_model_pt</code>(<code>선택사항</code>): 결과가 의미 있을 것으로 예상되는 실제 파이프라인에서 파이프라인을 테스트합니다.
이러한 테스트는 속도가 느리므로 이를 표시해야 합니다.
여기서의 목표는 파이프라인을 보여주고 향후 릴리즈에서의 변화가 없는지 확인하는 것입니다.</li> <li><code>test_large_model_tf</code>(<code>선택사항</code>): 결과가 의미 있을 것으로 예상되는 실제 파이프라인에서 파이프라인을 테스트합니다.
이러한 테스트는 속도가 느리므로 이를 표시해야 합니다.
여기서의 목표는 파이프라인을 보여주고 향후 릴리즈에서의 변화가 없는지 확인하는 것입니다.</li>`,xs,as,Ys;return w=new Ss({props:{title:"어떻게 사용자 정의 파이프라인을 생성하나요?",local:"how-to-create-a-custom-pipeline",headingTag:"h1"}}),h=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),V=new J({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),R=new J({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjB0b3BfayVFQiVBNSVCQyUyMCVFQyVCMiU5OCVFQiVBNiVBQyVFRCU5NSU5OCVFQiU4QSU5NCUyMCVFQiVBMSU5QyVFQyVBNyU4MSUyMCVFQyVCNiU5NCVFQSVCMCU4MCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJlc3RfY2xhc3MlMEElMEElMEFkZWYlMjBfc2FuaXRpemVfcGFyYW1ldGVycyhzZWxmJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19rd2FyZ3MlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBpZiUyMCUyMm1heWJlX2FyZyUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19rd2FyZ3MlNUIlMjJtYXliZV9hcmclMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJtYXliZV9hcmclMjIlNUQlMEElMEElMjAlMjAlMjAlMjBwb3N0cHJvY2Vzc19rd2FyZ3MlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBpZiUyMCUyMnRvcF9rJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwb3N0cHJvY2Vzc19rd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMnRvcF9rJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcHJlcHJvY2Vzc19rd2FyZ3MlMkMlMjAlN0IlN0QlMkMlMjBwb3N0cHJvY2Vzc19rd2FyZ3M=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># top_k를 처리하는 로직 추가</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),W=new Ss({props:{title:"지원되는 작업 목록에 추가하기",local:"adding-it-to-the-list-of-supported-tasks",headingTag:"h2"}}),H=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),E=new J({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjAlRUQlOTglODQlRUMlOUUlQUMlMjAlRUMlQTclODAlRUMlOUIlOTAlMjAlRUMlOUMlQTAlRUQlOTglOTUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># 현재 지원 유형: text, audio, image, multimodal</span>
)`,wrap:!1}}),X=new Ss({props:{title:"Hub에 파이프라인 공유하기",local:"share-your-pipeline-on-the-hub",headingTag:"h2"}}),v=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),z=new J({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),F=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),Y=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEElMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeSglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiklMEFjbGFzc2lmaWVyLnNhdmVfcHJldHJhaW5lZCglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIpJTBBcmVwby5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository

repo = Repository(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>, clone_from=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>)
classifier.save_pretrained(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)
repo.push_to_hub()`,wrap:!1}}),P=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new Ss({props:{title:"🤗 Transformers에 파이프라인 추가하기",local:"add-the-pipeline-to-transformers",headingTag:"h2"}}),{c(){T=n("meta"),ps=a(),ts=n("p"),ns=a(),c(w.$$.fragment),Ms=a(),m=n("p"),m.innerHTML=Ls,is=a(),u=n("p"),u.innerHTML=Ks,cs=a(),U=n("p"),U.innerHTML=Ds,os=a(),f=n("p"),f.innerHTML=Os,rs=a(),c(h.$$.fragment),ys=a(),I=n("p"),I.textContent=sl,js=a(),b=n("p"),b.innerHTML=ll,ds=a(),B=n("p"),B.innerHTML=el,Js=a(),C=n("p"),C.innerHTML=tl,Ts=a(),_=n("p"),_.innerHTML=al,ws=a(),Z=n("p"),Z.innerHTML=pl,ms=a(),k=n("p"),k.innerHTML=nl,us=a(),c(V.$$.fragment),Us=a(),A=n("p"),A.innerHTML=Ml,fs=a(),c(R.$$.fragment),hs=a(),G=n("p"),G.textContent=il,Is=a(),c(W.$$.fragment),bs=a(),g=n("p"),g.innerHTML=cl,Bs=a(),c(H.$$.fragment),Cs=a(),N=n("p"),N.textContent=ol,_s=a(),c(E.$$.fragment),Zs=a(),c(X.$$.fragment),ks=a(),q=n("p"),q.innerHTML=rl,Vs=a(),c(v.$$.fragment),As=a(),$=n("p"),$.innerHTML=yl,Rs=a(),c(z.$$.fragment),Gs=a(),Q=n("p"),Q.innerHTML=jl,Ws=a(),c(F.$$.fragment),gs=a(),x=n("p"),x.innerHTML=dl,Hs=a(),c(Y.$$.fragment),Ns=a(),S=n("p"),S.innerHTML=Jl,Es=a(),c(P.$$.fragment),Xs=a(),c(L.$$.fragment),qs=a(),K=n("p"),K.innerHTML=Tl,vs=a(),D=n("p"),D.innerHTML=wl,$s=a(),O=n("p"),O.innerHTML=ml,zs=a(),ss=n("p"),ss.innerHTML=ul,Qs=a(),ls=n("p"),ls.textContent=Ul,Fs=a(),es=n("ul"),es.innerHTML=fl,xs=a(),as=n("p"),this.h()},l(s){const l=kl("svelte-u9bgzb",document.head);T=M(l,"META",{name:!0,content:!0}),l.forEach(e),ps=p(s),ts=M(s,"P",{}),hl(ts).forEach(e),ns=p(s),o(w.$$.fragment,s),Ms=p(s),m=M(s,"P",{"data-svelte-h":!0}),i(m)!=="svelte-1fzm5o3"&&(m.innerHTML=Ls),is=p(s),u=M(s,"P",{"data-svelte-h":!0}),i(u)!=="svelte-6ogr6z"&&(u.innerHTML=Ks),cs=p(s),U=M(s,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1r1v4v7"&&(U.innerHTML=Ds),os=p(s),f=M(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1u9gwbf"&&(f.innerHTML=Os),rs=p(s),o(h.$$.fragment,s),ys=p(s),I=M(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-rv0lg4"&&(I.textContent=sl),js=p(s),b=M(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-fwn4og"&&(b.innerHTML=ll),ds=p(s),B=M(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-tcs7ux"&&(B.innerHTML=el),Js=p(s),C=M(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1a54d54"&&(C.innerHTML=tl),Ts=p(s),_=M(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-ufagsr"&&(_.innerHTML=al),ws=p(s),Z=M(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-j02rys"&&(Z.innerHTML=pl),ms=p(s),k=M(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1n2acw"&&(k.innerHTML=nl),us=p(s),o(V.$$.fragment,s),Us=p(s),A=M(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1d0sxb1"&&(A.innerHTML=Ml),fs=p(s),o(R.$$.fragment,s),hs=p(s),G=M(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1k45o3o"&&(G.textContent=il),Is=p(s),o(W.$$.fragment,s),bs=p(s),g=M(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1ty0isp"&&(g.innerHTML=cl),Bs=p(s),o(H.$$.fragment,s),Cs=p(s),N=M(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-ct19sw"&&(N.textContent=ol),_s=p(s),o(E.$$.fragment,s),Zs=p(s),o(X.$$.fragment,s),ks=p(s),q=M(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-56khl3"&&(q.innerHTML=rl),Vs=p(s),o(v.$$.fragment,s),As=p(s),$=M(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1d1jvf5"&&($.innerHTML=yl),Rs=p(s),o(z.$$.fragment,s),Gs=p(s),Q=M(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1vdr0z9"&&(Q.innerHTML=jl),Ws=p(s),o(F.$$.fragment,s),gs=p(s),x=M(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-fd2kff"&&(x.innerHTML=dl),Hs=p(s),o(Y.$$.fragment,s),Ns=p(s),S=M(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1yjhf56"&&(S.innerHTML=Jl),Es=p(s),o(P.$$.fragment,s),Xs=p(s),o(L.$$.fragment,s),qs=p(s),K=M(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-52sri7"&&(K.innerHTML=Tl),vs=p(s),D=M(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-5f0sxq"&&(D.innerHTML=wl),$s=p(s),O=M(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-yv6zf4"&&(O.innerHTML=ml),zs=p(s),ss=M(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-15fh04w"&&(ss.innerHTML=ul),Qs=p(s),ls=M(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-e68emk"&&(ls.textContent=Ul),Fs=p(s),es=M(s,"UL",{"data-svelte-h":!0}),i(es)!=="svelte-1wfarmi"&&(es.innerHTML=fl),xs=p(s),as=M(s,"P",{}),hl(as).forEach(e),this.h()},h(){Il(T,"name","hf:doc:metadata"),Il(T,"content",Rl)},m(s,l){Vl(document.head,T),t(s,ps,l),t(s,ts,l),t(s,ns,l),r(w,s,l),t(s,Ms,l),t(s,m,l),t(s,is,l),t(s,u,l),t(s,cs,l),t(s,U,l),t(s,os,l),t(s,f,l),t(s,rs,l),r(h,s,l),t(s,ys,l),t(s,I,l),t(s,js,l),t(s,b,l),t(s,ds,l),t(s,B,l),t(s,Js,l),t(s,C,l),t(s,Ts,l),t(s,_,l),t(s,ws,l),t(s,Z,l),t(s,ms,l),t(s,k,l),t(s,us,l),r(V,s,l),t(s,Us,l),t(s,A,l),t(s,fs,l),r(R,s,l),t(s,hs,l),t(s,G,l),t(s,Is,l),r(W,s,l),t(s,bs,l),t(s,g,l),t(s,Bs,l),r(H,s,l),t(s,Cs,l),t(s,N,l),t(s,_s,l),r(E,s,l),t(s,Zs,l),r(X,s,l),t(s,ks,l),t(s,q,l),t(s,Vs,l),r(v,s,l),t(s,As,l),t(s,$,l),t(s,Rs,l),r(z,s,l),t(s,Gs,l),t(s,Q,l),t(s,Ws,l),r(F,s,l),t(s,gs,l),t(s,x,l),t(s,Hs,l),r(Y,s,l),t(s,Ns,l),t(s,S,l),t(s,Es,l),r(P,s,l),t(s,Xs,l),r(L,s,l),t(s,qs,l),t(s,K,l),t(s,vs,l),t(s,D,l),t(s,$s,l),t(s,O,l),t(s,zs,l),t(s,ss,l),t(s,Qs,l),t(s,ls,l),t(s,Fs,l),t(s,es,l),t(s,xs,l),t(s,as,l),Ys=!0},p:Bl,i(s){Ys||(y(w.$$.fragment,s),y(h.$$.fragment,s),y(V.$$.fragment,s),y(R.$$.fragment,s),y(W.$$.fragment,s),y(H.$$.fragment,s),y(E.$$.fragment,s),y(X.$$.fragment,s),y(v.$$.fragment,s),y(z.$$.fragment,s),y(F.$$.fragment,s),y(Y.$$.fragment,s),y(P.$$.fragment,s),y(L.$$.fragment,s),Ys=!0)},o(s){j(w.$$.fragment,s),j(h.$$.fragment,s),j(V.$$.fragment,s),j(R.$$.fragment,s),j(W.$$.fragment,s),j(H.$$.fragment,s),j(E.$$.fragment,s),j(X.$$.fragment,s),j(v.$$.fragment,s),j(z.$$.fragment,s),j(F.$$.fragment,s),j(Y.$$.fragment,s),j(P.$$.fragment,s),j(L.$$.fragment,s),Ys=!1},d(s){s&&(e(ps),e(ts),e(ns),e(Ms),e(m),e(is),e(u),e(cs),e(U),e(os),e(f),e(rs),e(ys),e(I),e(js),e(b),e(ds),e(B),e(Js),e(C),e(Ts),e(_),e(ws),e(Z),e(ms),e(k),e(us),e(Us),e(A),e(fs),e(hs),e(G),e(Is),e(bs),e(g),e(Bs),e(Cs),e(N),e(_s),e(Zs),e(ks),e(q),e(Vs),e(As),e($),e(Rs),e(Gs),e(Q),e(Ws),e(gs),e(x),e(Hs),e(Ns),e(S),e(Es),e(Xs),e(qs),e(K),e(vs),e(D),e($s),e(O),e(zs),e(ss),e(Qs),e(ls),e(Fs),e(es),e(xs),e(as)),e(T),d(w,s),d(h,s),d(V,s),d(R,s),d(W,s),d(H,s),d(E,s),d(X,s),d(v,s),d(z,s),d(F,s),d(Y,s),d(P,s),d(L,s)}}}const Rl='{"title":"어떻게 사용자 정의 파이프라인을 생성하나요?","local":"how-to-create-a-custom-pipeline","sections":[{"title":"지원되는 작업 목록에 추가하기","local":"adding-it-to-the-list-of-supported-tasks","sections":[],"depth":2},{"title":"Hub에 파이프라인 공유하기","local":"share-your-pipeline-on-the-hub","sections":[],"depth":2},{"title":"🤗 Transformers에 파이프라인 추가하기","local":"add-the-pipeline-to-transformers","sections":[],"depth":2}],"depth":1}';function Gl(Ps){return Cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends _l{constructor(T){super(),Zl(this,T,Gl,Al,bl,{})}}export{El as component};
