import{s as fr,o as gr,n as Hl}from"../chunks/scheduler.36a0863c.js";import{S as yr,i as br,g as l,s as r,u as m,A as Mr,h as n,f as t,c as o,j as c,v as h,y as d,k as p,o as i,a as s,w as u,d as f,t as g,x as y}from"../chunks/index.d0f7a4c4.js";import{T as Fl}from"../chunks/Tip.4c7d7eb1.js";import{Y as Ml}from"../chunks/Youtube.d15bb502.js";import{I as v}from"../chunks/IconCopyLink.bc5fad79.js";import{C as M}from"../chunks/CodeBlock.69433f87.js";import{D as wr}from"../chunks/DocNotebookDropdown.df566a23.js";function vr(F){let b,j=`Verás una advertencia acerca de que algunos de los pesos pre-entrenados no están siendo utilizados y que algunos pesos están siendo inicializados al azar. No te preocupes, esto es completamente normal.
El head/cabezal pre-entrenado del modelo BERT se descarta y se sustituye por un head de clasificación inicializado aleatoriamente. Puedes aplicar fine-tuning a este nuevo head del modelo en tu tarea de clasificación de secuencias haciendo transfer learning del modelo pre-entrenado.`;return{c(){b=l("p"),b.textContent=j},l(w){b=n(w,"P",{"data-svelte-h":!0}),d(b)!=="svelte-gf8b5f"&&(b.textContent=j)},m(w,$){s(w,b,$)},p:Hl,d(w){w&&t(b)}}}function jr(F){let b,j="<code>Trainer</code> utiliza <code>DataCollatorWithPadding</code> por defecto por lo que no es necesario especificar explícitamente un intercalador de datos (data collator, en inglés).";return{c(){b=l("p"),b.innerHTML=j},l(w){b=n(w,"P",{"data-svelte-h":!0}),d(b)!=="svelte-zlpg6n"&&(b.innerHTML=j)},m(w,$){s(w,b,$)},p:Hl,d(w){w&&t(b)}}}function $r(F){let b,j='Consigue acceso gratuito a una GPU en la nube si es que no tienes este recurso de forma local con un notebook alojado en <a href="https://colab.research.google.com/" rel="nofollow">Colaboratory</a> o <a href="https://studiolab.sagemaker.aws/" rel="nofollow">SageMaker StudioLab</a>.';return{c(){b=l("p"),b.innerHTML=j},l(w){b=n(w,"P",{"data-svelte-h":!0}),d(b)!=="svelte-tbi2js"&&(b.innerHTML=j)},m(w,$){s(w,b,$)},p:Hl,d(w){w&&t(b)}}}function Tr(F){let b,j,w,$,J,H,na,ne,wl,Wt,Nl="Fine-tuning a un modelo pre-entrenado",$a,re,Ta,oe,Al="El uso de un modelo pre-entrenado tiene importantes ventajas. Reduce los costos de computación, la huella de carbono y te permite utilizar modelos de última generación sin tener que entrenar uno desde cero.",Ja,ie,Yl="<li>Fine-tuning a un modelo pre-entrenado con 🤗 Transformers <code>Trainer</code>.</li> <li>Fine-tuning a un modelo pre-entrenado en TensorFlow con Keras.</li> <li>Fine-tuning a un modelo pre-entrenado en PyTorch nativo.</li>",_a,zt,ka,_,N,ra,pe,vl,Et,Vl="Prepara un dataset",Ca,ce,Za,de,ql="Antes de aplicar fine-tuning a un modelo pre-entrenado, descarga un dataset y prepáralo para el entrenamiento. El tutorial anterior nos enseñó cómo procesar los datos para el entrenamiento, y ahora es la oportunidad de poner a prueba estas habilidades.",Ua,me,Sl='Comienza cargando el dataset de <a href="https://huggingface.co/datasets/yelp_review_full" rel="nofollow">Yelp Reviews</a>:',xa,he,Ia,ue,Pl="Como ya sabes, necesitas un tokenizador para procesar el texto e incluir una estrategia para el padding y el truncamiento para manejar cualquier longitud de secuencia variable. Para procesar tu dataset en un solo paso, utiliza el método de 🤗 Datasets map para aplicar una función de preprocesamiento sobre todo el dataset:",Ra,fe,Ga,ge,Ll="Si lo deseas, puedes crear un subconjunto más pequeño del dataset completo para aplicarle fine-tuning y así reducir el tiempo.",Wa,ye,za,Xt,Ea,k,A,oa,be,jl,Bt,Ql="Fine-tuning con <code>Trainer</code>",Xa,Me,Ba,we,Dl="🤗 Transformers proporciona una clase <code>Trainer</code> optimizada para el entrenamiento de modelos de 🤗 Transformers, haciendo más fácil el inicio del entrenamiento sin necesidad de escribir manualmente tu propio ciclo. La API del <code>Trainer</code> soporta una amplia gama de opciones de entrenamiento y características como el logging, el gradient accumulation y el mixed precision.",Fa,ve,Kl='Comienza cargando tu modelo y especifica el número de labels previstas. A partir del <a href="https://huggingface.co/datasets/yelp_review_full#data-fields" rel="nofollow">Card Dataset</a> de Yelp Review, que como ya sabemos tiene 5 labels:',Ha,je,Na,Y,Aa,C,V,ia,$e,$l,Ft,Ol="Hiperparámetros de entrenamiento",Ya,Te,en='A continuación, crea una clase <code>TrainingArguments</code> que contenga todos los hiperparámetros que puedes ajustar así como los indicadores para activar las diferentes opciones de entrenamiento. Para este tutorial puedes empezar con los <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">hiperparámetros</a> de entrenamiento por defecto, pero siéntete libre de experimentar con ellos para encontrar tu configuración óptima.',Va,Je,tn="Especifica dónde vas a guardar los checkpoints de tu entrenamiento:",qa,_e,Sa,Z,q,pa,ke,Tl,Ht,an="Métricas",Pa,Ce,sn='El <code>Trainer</code> no evalúa automáticamente el rendimiento del modelo durante el entrenamiento. Tendrás que pasarle a <code>Trainer</code> una función para calcular y hacer un reporte de las métricas. La biblioteca de 🤗 Datasets proporciona una función de <a href="https://huggingface.co/metrics/accuracy" rel="nofollow"><code>accuracy</code></a> simple que puedes cargar con la función <code>load_metric</code> (ver este <a href="https://huggingface.co/docs/datasets/metrics.html" rel="nofollow">tutorial</a> para más información):',La,Ze,Qa,Ue,ln="Define la función <code>compute</code> en <code>metric</code> para calcular el accuracy de tus predicciones. Antes de pasar tus predicciones a <code>compute</code>, necesitas convertir las predicciones a logits (recuerda que todos los modelos de 🤗 Transformers devuelven logits).",Da,xe,Ka,Ie,nn="Si quieres controlar tus métricas de evaluación durante el fine-tuning, especifica el parámetro <code>evaluation_strategy</code> en tus argumentos de entrenamiento para que el modelo tenga en cuenta la métrica de evaluación al final de cada época:",Oa,Re,es,U,S,ca,Ge,Jl,Nt,rn="Trainer",ts,We,on="Crea un objeto <code>Trainer</code> con tu modelo, argumentos de entrenamiento, datasets de entrenamiento y de prueba, y tu función de evaluación:",as,ze,ss,Ee,pn="A continuación, aplica fine-tuning a tu modelo llamando <code>train()</code>:",ls,Xe,ns,At,rs,x,P,da,Be,_l,Yt,cn="Fine-tuning con Keras",os,Fe,is,He,dn="Los modelos de 🤗 Transformers también permiten realizar el entrenamiento en TensorFlow con la API de Keras. Solo es necesario hacer algunos cambios antes de hacer fine-tuning.",ps,I,L,ma,Ne,kl,Vt,mn="Convierte el dataset al formato de TensorFlow",cs,Ae,hn="El <code>DefaultDataCollator</code> junta los tensores en un batch para que el modelo se entrene en él. Asegúrate de especificar <code>return_tensors</code> para devolver los tensores de TensorFlow:",ds,Ye,ms,Q,hs,Ve,un='A continuación, convierte los datasets tokenizados en datasets de TensorFlow con el método <a href="https://huggingface.co/docs/datasets/package_reference/main_classes.html#datasets.Dataset.to_tf_dataset" rel="nofollow"><code>to_tf_dataset</code></a>. Especifica tus entradas en <code>columns</code> y tu etiqueta en <code>label_cols</code>:',us,qe,fs,R,D,ha,Se,Cl,qt,fn="Compila y ajusta",gs,Pe,gn="Carguemos un modelo TensorFlow con el número esperado de labels:",ys,Le,bs,Qe,yn='A continuación, compila y aplica fine-tuning a tu modelo con <a href="https://keras.io/api/models/model_training_apis/" rel="nofollow"><code>fit</code></a> como lo harías con cualquier otro modelo de Keras:',Ms,De,ws,St,vs,G,K,ua,Ke,Zl,Pt,bn="Fine-tune en PyTorch nativo",js,Oe,$s,et,Mn="El <code>Trainer</code> se encarga del ciclo de entrenamiento y permite aplicar fine-tuning a un modelo en una sola línea de código. Para los que prefieran escribir su propio ciclo de entrenamiento, también pueden aplicar fine-tuning a un modelo de 🤗 Transformers en PyTorch nativo.",Ts,tt,wn="En este punto, es posible que necesites reiniciar tu notebook o ejecutar el siguiente código para liberar algo de memoria:",Js,at,_s,st,vn="A continuación, haremos un post-procesamiento manual al <code>tokenized_dataset</code> y así prepararlo para el entrenamiento.",ks,T,lt,Lt,jn="Elimina la columna de <code>text</code> porque el modelo no acepta texto en crudo como entrada:",Ul,nt,xl,rt,Qt,$n="Cambia el nombre de la columna de <code>label</code> a <code>labels</code> porque el modelo espera que el argumento se llame <code>labels</code>:",Il,ot,Rl,it,Dt,Tn="Establece el formato del dataset para devolver tensores PyTorch en lugar de listas:",Gl,pt,Cs,ct,Jn="A continuación, crea un subconjunto más pequeño del dataset como se ha mostrado anteriormente para acelerar el fine-tuning:",Zs,dt,Us,W,O,fa,mt,Wl,Kt,_n="DataLoader",xs,ht,kn="Crea un <code>DataLoader</code> para tus datasets de entrenamiento y de prueba para poder iterar sobre batches de datos:",Is,ut,Rs,ft,Cn="Carga tu modelo con el número de labels previstas:",Gs,gt,Ws,z,ee,ga,yt,zl,Ot,Zn="Optimiza y programa el learning rate",zs,bt,Un='Crea un optimizador y el learning rate para aplicar fine-tuning al modelo. Vamos a utilizar el optimizador <a href="https://pytorch.org/docs/stable/generated/torch.optim.AdamW.html" rel="nofollow"><code>AdamW</code></a> de PyTorch:',Es,Mt,Xs,wt,xn="Crea el learning rate desde el <code>Trainer</code>:",Bs,vt,Fs,jt,In="Por último, especifica el <code>device</code> o entorno de ejecución para utilizar una GPU si tienes acceso a una. De lo contrario, el entrenamiento en una CPU puede llevarte varias horas en lugar de un par de minutos.",Hs,$t,Ns,te,As,Tt,Rn="Genial, ¡ahora podemos entrenar! 🥳",Ys,E,ae,ya,Jt,El,ea,Gn="Ciclo de entrenamiento",Vs,_t,Wn='Para hacer un seguimiento al progreso del entrenamiento, utiliza la biblioteca <a href="https://tqdm.github.io/" rel="nofollow">tqdm</a> para añadir una barra de progreso sobre el número de pasos de entrenamiento:',qs,kt,Ss,X,se,ba,Ct,Xl,ta,zn="Métricas",Ps,Zt,En='De la misma manera que necesitas añadir una función de evaluación al <code>Trainer</code>, necesitas hacer lo mismo cuando escribas tu propio ciclo de entrenamiento. Pero en lugar de calcular y reportar la métrica al final de cada época, esta vez acumularás todos los batches con <a href="https://huggingface.co/docs/datasets/package_reference/main_classes.html?highlight=add_batch#datasets.Metric.add_batch" rel="nofollow"><code>add_batch</code></a> y calcularás la métrica al final.',Ls,Ut,Qs,aa,Ds,B,le,Ma,xt,Bl,sa,Xn="Recursos adicionales",Ks,It,Bn="Para más ejemplos de fine-tuning consulta:",Os,Rt,Fn=`<li><p><a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">🤗 Transformers Examples</a> incluye scripts
para entrenar tareas comunes de NLP en PyTorch y TensorFlow.</p></li> <li><p><a href="notebooks">🤗 Transformers Notebooks</a> contiene varios notebooks sobre cómo aplicar fine-tuning a un modelo para tareas específicas en PyTorch y TensorFlow.</p></li>`,el,wa,tl;return ne=new v({}),re=new wr({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/tensorflow/training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/tensorflow/training.ipynb"}]}}),pe=new v({}),ce=new Ml({props:{id:"_BZearw7f0w"}}),he=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ5ZWxwX3Jldmlld19mdWxsJTIyKSUwQWRhdGFzZXQlNUIxMDAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;yelp_review_full&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">100</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My expectations for McDonalds are t rarely high. But for one to still fail so spectacularly...that takes something special!\\\\nThe cashier took my friends\\&#x27;s order, then promptly ignored me. I had to force myself in front of a cashier who opened his register to wait on the person BEHIND me. I waited over five minutes for a gigantic order that included precisely one kid\\&#x27;s meal. After watching two people who ordered after me be handed their food, I asked where mine was. The manager started yelling at the cashiers for \\\\&quot;serving off their orders\\\\&quot; when they didn\\&#x27;t have their food. But neither cashier was anywhere near those controls, and the manager was the one serving food to customers and clearing the boards.\\\\nThe manager was rude when giving me my order. She didn\\&#x27;t make sure that I had everything ON MY RECEIPT, and never even had the decency to apologize that I felt I was getting poor service.\\\\nI\\&#x27;ve eaten at various McDonalds restaurants for over 30 years. I\\&#x27;ve worked at more than one location. I expect bad days, bad moods, and the occasional mistake. But I have yet to have a decent experience at this store. It will remain a place I avoid unless someone in my party needs to avoid illness from low blood sugar. Perhaps I should go back to the racially biased service of Steak n Shake instead!&#x27;</span>}`}}),fe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTBBZGVmJTIwdG9rZW5pemVfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJTIydGV4dCUyMiU1RCUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAodG9rZW5pemVfZnVuY3Rpb24lMkMlMjBiYXRjaGVkJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = dataset.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)`}}),ye=new M({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`}}),be=new v({}),Me=new Ml({props:{id:"nvBXf7s7vTI"}}),je=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`}}),Y=new Fl({props:{$$slots:{default:[vr]},$$scope:{ctx:F}}}),$e=new v({}),_e=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG91dHB1dF9kaXIlM0QlMjJ0ZXN0X3RyYWluZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>)`}}),ke=new v({}),Ze=new M({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9tZXRyaWMlMEElMEFtZXRyaWMlMjAlM0QlMjBsb2FkX21ldHJpYyglMjJhY2N1cmFjeSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_metric

<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)`}}),xe=new M({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG5wLmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    logits, labels = eval_pred
<span class="hljs-meta">... </span>    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`}}),Re=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG91dHB1dF9kaXIlM0QlMjJ0ZXN0X3RyYWluZXIlMjIlMkMlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)`}}),Ge=new v({}),ze=new M({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHNtYWxsX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)`}}),Xe=new M({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()'}}),Be=new v({}),Fe=new Ml({props:{id:"rnTGBy2ax1c"}}),Ne=new v({}),Ye=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcihyZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator(return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)`}}),Q=new Fl({props:{$$slots:{default:[jr]},$$scope:{ctx:F}}}),qe=new M({props:{code:"dGZfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNtYWxsX3RyYWluX2RhdGFzZXQudG9fdGZfZGF0YXNldCglMEElMjAlMjAlMjAlMjBjb2x1bW5zJTNEJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX2NvbHMlM0QlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMEEpJTBBJTBBdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTIwJTNEJTIwc21hbGxfZXZhbF9kYXRhc2V0LnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTJDJTIwJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9jb2xzJTNEJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_dataset = small_train_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=<span class="hljs-string">&quot;labels&quot;</span>,
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_validation_dataset = small_eval_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=<span class="hljs-string">&quot;labels&quot;</span>,
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)`}}),Se=new v({}),Le=new M({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`}}),De=new M({props:{code:"bW9kZWwuY29tcGlsZSglMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0R0Zi5rZXJhcy5vcHRpbWl6ZXJzLkFkYW0obGVhcm5pbmdfcmF0ZSUzRDVlLTUpJTJDJTBBJTIwJTIwJTIwJTIwbG9zcyUzRHRmLmtlcmFzLmxvc3Nlcy5TcGFyc2VDYXRlZ29yaWNhbENyb3NzZW50cm9weShmcm9tX2xvZ2l0cyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljcyUzRHRmLm1ldHJpY3MuU3BhcnNlQ2F0ZWdvcmljYWxBY2N1cmFjeSgpJTJDJTBBKSUwQSUwQW1vZGVsLmZpdCh0Zl90cmFpbl9kYXRhc2V0JTJDJTIwdmFsaWRhdGlvbl9kYXRhJTNEdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTJDJTIwZXBvY2hzJTNEMyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(
<span class="hljs-meta">... </span>    optimizer=tf.keras.optimizers.Adam(learning_rate=<span class="hljs-number">5e-5</span>),
<span class="hljs-meta">... </span>    loss=tf.keras.losses.SparseCategoricalCrossentropy(from_logits=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>    metrics=tf.metrics.SparseCategoricalAccuracy(),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(tf_train_dataset, validation_data=tf_validation_dataset, epochs=<span class="hljs-number">3</span>)`}}),Ke=new v({}),Oe=new Ml({props:{id:"Dh9CL8fyG80"}}),at=new M({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBweXRvcmNoX21vZGVsJTBBZGVsJTIwdHJhaW5lciUwQXRvcmNoLmN1ZGEuZW1wdHlfY2FjaGUoKQ==",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pytorch_model
<span class="hljs-keyword">del</span> trainer
torch.cuda.empty_cache()`}}),nt=new M({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnRleHQlMjIlNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;text&quot;</span>])'}}),ot=new M({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)'}}),pt=new M({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzLnNldF9mb3JtYXQoJTIydG9yY2glMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)'}}),dt=new M({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`}}),mt=new v({}),ut=new M({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoc21hbGxfdHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRDgpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = DataLoader(small_train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_dataloader = DataLoader(small_eval_dataset, batch_size=<span class="hljs-number">8</span>)`}}),gt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`}}),yt=new v({}),Mt=new M({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`}}),vt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIybGluZWFyJTIyJTJDJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTIwbnVtX3dhcm11cF9zdGVwcyUzRDAlMkMlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0RudW1fdHJhaW5pbmdfc3RlcHMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_scheduler(
<span class="hljs-meta">... </span>    name=<span class="hljs-string">&quot;linear&quot;</span>, optimizer=optimizer, num_warmup_steps=<span class="hljs-number">0</span>, num_training_steps=num_training_steps
<span class="hljs-meta">... </span>)`}}),$t=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`}}),te=new Fl({props:{$$slots:{default:[$r]},$$scope:{ctx:F}}}),Jt=new v({}),kt=new M({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

<span class="hljs-meta">&gt;&gt;&gt; </span>model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        loss.backward()

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`}}),Ct=new v({}),Ut=new M({props:{code:"bWV0cmljJTIwJTNEJTIwbG9hZF9tZXRyaWMoJTIyYWNjdXJhY3klMjIpJTBBbW9kZWwuZXZhbCgpJTBBZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTIwJTIwJTIwJTIwbWV0cmljLmFkZF9iYXRjaChwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEKSUwQSUwQW1ldHJpYy5jb21wdXRlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
<span class="hljs-meta">... </span>    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model(**batch)

<span class="hljs-meta">... </span>    logits = outputs.logits
<span class="hljs-meta">... </span>    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>metric.compute()`}}),xt=new v({}),{c(){b=l("meta"),j=r(),w=l("p"),$=r(),J=l("h1"),H=l("a"),na=l("span"),m(ne.$$.fragment),wl=r(),Wt=l("span"),Wt.textContent=Nl,$a=r(),m(re.$$.fragment),Ta=r(),oe=l("p"),oe.textContent=Al,Ja=r(),ie=l("ul"),ie.innerHTML=Yl,_a=r(),zt=l("a"),ka=r(),_=l("h2"),N=l("a"),ra=l("span"),m(pe.$$.fragment),vl=r(),Et=l("span"),Et.textContent=Vl,Ca=r(),m(ce.$$.fragment),Za=r(),de=l("p"),de.textContent=ql,Ua=r(),me=l("p"),me.innerHTML=Sl,xa=r(),m(he.$$.fragment),Ia=r(),ue=l("p"),ue.textContent=Pl,Ra=r(),m(fe.$$.fragment),Ga=r(),ge=l("p"),ge.textContent=Ll,Wa=r(),m(ye.$$.fragment),za=r(),Xt=l("a"),Ea=r(),k=l("h2"),A=l("a"),oa=l("span"),m(be.$$.fragment),jl=r(),Bt=l("span"),Bt.innerHTML=Ql,Xa=r(),m(Me.$$.fragment),Ba=r(),we=l("p"),we.innerHTML=Dl,Fa=r(),ve=l("p"),ve.innerHTML=Kl,Ha=r(),m(je.$$.fragment),Na=r(),m(Y.$$.fragment),Aa=r(),C=l("h3"),V=l("a"),ia=l("span"),m($e.$$.fragment),$l=r(),Ft=l("span"),Ft.textContent=Ol,Ya=r(),Te=l("p"),Te.innerHTML=en,Va=r(),Je=l("p"),Je.textContent=tn,qa=r(),m(_e.$$.fragment),Sa=r(),Z=l("h3"),q=l("a"),pa=l("span"),m(ke.$$.fragment),Tl=r(),Ht=l("span"),Ht.textContent=an,Pa=r(),Ce=l("p"),Ce.innerHTML=sn,La=r(),m(Ze.$$.fragment),Qa=r(),Ue=l("p"),Ue.innerHTML=ln,Da=r(),m(xe.$$.fragment),Ka=r(),Ie=l("p"),Ie.innerHTML=nn,Oa=r(),m(Re.$$.fragment),es=r(),U=l("h3"),S=l("a"),ca=l("span"),m(Ge.$$.fragment),Jl=r(),Nt=l("span"),Nt.textContent=rn,ts=r(),We=l("p"),We.innerHTML=on,as=r(),m(ze.$$.fragment),ss=r(),Ee=l("p"),Ee.innerHTML=pn,ls=r(),m(Xe.$$.fragment),ns=r(),At=l("a"),rs=r(),x=l("h2"),P=l("a"),da=l("span"),m(Be.$$.fragment),_l=r(),Yt=l("span"),Yt.textContent=cn,os=r(),m(Fe.$$.fragment),is=r(),He=l("p"),He.textContent=dn,ps=r(),I=l("h3"),L=l("a"),ma=l("span"),m(Ne.$$.fragment),kl=r(),Vt=l("span"),Vt.textContent=mn,cs=r(),Ae=l("p"),Ae.innerHTML=hn,ds=r(),m(Ye.$$.fragment),ms=r(),m(Q.$$.fragment),hs=r(),Ve=l("p"),Ve.innerHTML=un,us=r(),m(qe.$$.fragment),fs=r(),R=l("h3"),D=l("a"),ha=l("span"),m(Se.$$.fragment),Cl=r(),qt=l("span"),qt.textContent=fn,gs=r(),Pe=l("p"),Pe.textContent=gn,ys=r(),m(Le.$$.fragment),bs=r(),Qe=l("p"),Qe.innerHTML=yn,Ms=r(),m(De.$$.fragment),ws=r(),St=l("a"),vs=r(),G=l("h2"),K=l("a"),ua=l("span"),m(Ke.$$.fragment),Zl=r(),Pt=l("span"),Pt.textContent=bn,js=r(),m(Oe.$$.fragment),$s=r(),et=l("p"),et.innerHTML=Mn,Ts=r(),tt=l("p"),tt.textContent=wn,Js=r(),m(at.$$.fragment),_s=r(),st=l("p"),st.innerHTML=vn,ks=r(),T=l("ol"),lt=l("li"),Lt=l("p"),Lt.innerHTML=jn,Ul=r(),m(nt.$$.fragment),xl=r(),rt=l("li"),Qt=l("p"),Qt.innerHTML=$n,Il=r(),m(ot.$$.fragment),Rl=r(),it=l("li"),Dt=l("p"),Dt.textContent=Tn,Gl=r(),m(pt.$$.fragment),Cs=r(),ct=l("p"),ct.textContent=Jn,Zs=r(),m(dt.$$.fragment),Us=r(),W=l("h3"),O=l("a"),fa=l("span"),m(mt.$$.fragment),Wl=r(),Kt=l("span"),Kt.textContent=_n,xs=r(),ht=l("p"),ht.innerHTML=kn,Is=r(),m(ut.$$.fragment),Rs=r(),ft=l("p"),ft.textContent=Cn,Gs=r(),m(gt.$$.fragment),Ws=r(),z=l("h3"),ee=l("a"),ga=l("span"),m(yt.$$.fragment),zl=r(),Ot=l("span"),Ot.textContent=Zn,zs=r(),bt=l("p"),bt.innerHTML=Un,Es=r(),m(Mt.$$.fragment),Xs=r(),wt=l("p"),wt.innerHTML=xn,Bs=r(),m(vt.$$.fragment),Fs=r(),jt=l("p"),jt.innerHTML=In,Hs=r(),m($t.$$.fragment),Ns=r(),m(te.$$.fragment),As=r(),Tt=l("p"),Tt.textContent=Rn,Ys=r(),E=l("h3"),ae=l("a"),ya=l("span"),m(Jt.$$.fragment),El=r(),ea=l("span"),ea.textContent=Gn,Vs=r(),_t=l("p"),_t.innerHTML=Wn,qs=r(),m(kt.$$.fragment),Ss=r(),X=l("h3"),se=l("a"),ba=l("span"),m(Ct.$$.fragment),Xl=r(),ta=l("span"),ta.textContent=zn,Ps=r(),Zt=l("p"),Zt.innerHTML=En,Ls=r(),m(Ut.$$.fragment),Qs=r(),aa=l("a"),Ds=r(),B=l("h2"),le=l("a"),Ma=l("span"),m(xt.$$.fragment),Bl=r(),sa=l("span"),sa.textContent=Xn,Ks=r(),It=l("p"),It.textContent=Bn,Os=r(),Rt=l("ul"),Rt.innerHTML=Fn,el=r(),wa=l("p"),this.h()},l(e){const a=Mr("svelte-1phssyn",document.head);b=n(a,"META",{name:!0,content:!0}),a.forEach(t),j=o(e),w=n(e,"P",{}),c(w).forEach(t),$=o(e),J=n(e,"H1",{class:!0});var Gt=c(J);H=n(Gt,"A",{id:!0,class:!0,href:!0});var va=c(H);na=n(va,"SPAN",{});var ja=c(na);h(ne.$$.fragment,ja),ja.forEach(t),va.forEach(t),wl=o(Gt),Wt=n(Gt,"SPAN",{"data-svelte-h":!0}),d(Wt)!=="svelte-1wi01pd"&&(Wt.textContent=Nl),Gt.forEach(t),$a=o(e),h(re.$$.fragment,e),Ta=o(e),oe=n(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1buid90"&&(oe.textContent=Al),Ja=o(e),ie=n(e,"UL",{"data-svelte-h":!0}),d(ie)!=="svelte-ig3005"&&(ie.innerHTML=Yl),_a=o(e),zt=n(e,"A",{id:!0}),c(zt).forEach(t),ka=o(e),_=n(e,"H2",{class:!0});var al=c(_);N=n(al,"A",{id:!0,class:!0,href:!0});var Hn=c(N);ra=n(Hn,"SPAN",{});var Nn=c(ra);h(pe.$$.fragment,Nn),Nn.forEach(t),Hn.forEach(t),vl=o(al),Et=n(al,"SPAN",{"data-svelte-h":!0}),d(Et)!=="svelte-scnq2v"&&(Et.textContent=Vl),al.forEach(t),Ca=o(e),h(ce.$$.fragment,e),Za=o(e),de=n(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-w3kxlj"&&(de.textContent=ql),Ua=o(e),me=n(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1tawjjo"&&(me.innerHTML=Sl),xa=o(e),h(he.$$.fragment,e),Ia=o(e),ue=n(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-67e30w"&&(ue.textContent=Pl),Ra=o(e),h(fe.$$.fragment,e),Ga=o(e),ge=n(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-s4lbad"&&(ge.textContent=Ll),Wa=o(e),h(ye.$$.fragment,e),za=o(e),Xt=n(e,"A",{id:!0}),c(Xt).forEach(t),Ea=o(e),k=n(e,"H2",{class:!0});var sl=c(k);A=n(sl,"A",{id:!0,class:!0,href:!0});var An=c(A);oa=n(An,"SPAN",{});var Yn=c(oa);h(be.$$.fragment,Yn),Yn.forEach(t),An.forEach(t),jl=o(sl),Bt=n(sl,"SPAN",{"data-svelte-h":!0}),d(Bt)!=="svelte-8pl0dr"&&(Bt.innerHTML=Ql),sl.forEach(t),Xa=o(e),h(Me.$$.fragment,e),Ba=o(e),we=n(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-voi579"&&(we.innerHTML=Dl),Fa=o(e),ve=n(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-aja07e"&&(ve.innerHTML=Kl),Ha=o(e),h(je.$$.fragment,e),Na=o(e),h(Y.$$.fragment,e),Aa=o(e),C=n(e,"H3",{class:!0});var ll=c(C);V=n(ll,"A",{id:!0,class:!0,href:!0});var Vn=c(V);ia=n(Vn,"SPAN",{});var qn=c(ia);h($e.$$.fragment,qn),qn.forEach(t),Vn.forEach(t),$l=o(ll),Ft=n(ll,"SPAN",{"data-svelte-h":!0}),d(Ft)!=="svelte-d8jnq5"&&(Ft.textContent=Ol),ll.forEach(t),Ya=o(e),Te=n(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-k49oxq"&&(Te.innerHTML=en),Va=o(e),Je=n(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-qk98nd"&&(Je.textContent=tn),qa=o(e),h(_e.$$.fragment,e),Sa=o(e),Z=n(e,"H3",{class:!0});var nl=c(Z);q=n(nl,"A",{id:!0,class:!0,href:!0});var Sn=c(q);pa=n(Sn,"SPAN",{});var Pn=c(pa);h(ke.$$.fragment,Pn),Pn.forEach(t),Sn.forEach(t),Tl=o(nl),Ht=n(nl,"SPAN",{"data-svelte-h":!0}),d(Ht)!=="svelte-1ok7mdh"&&(Ht.textContent=an),nl.forEach(t),Pa=o(e),Ce=n(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-ezw8i9"&&(Ce.innerHTML=sn),La=o(e),h(Ze.$$.fragment,e),Qa=o(e),Ue=n(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1o2d1nd"&&(Ue.innerHTML=ln),Da=o(e),h(xe.$$.fragment,e),Ka=o(e),Ie=n(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-10xx8r2"&&(Ie.innerHTML=nn),Oa=o(e),h(Re.$$.fragment,e),es=o(e),U=n(e,"H3",{class:!0});var rl=c(U);S=n(rl,"A",{id:!0,class:!0,href:!0});var Ln=c(S);ca=n(Ln,"SPAN",{});var Qn=c(ca);h(Ge.$$.fragment,Qn),Qn.forEach(t),Ln.forEach(t),Jl=o(rl),Nt=n(rl,"SPAN",{"data-svelte-h":!0}),d(Nt)!=="svelte-1db8bfa"&&(Nt.textContent=rn),rl.forEach(t),ts=o(e),We=n(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-hqyfsb"&&(We.innerHTML=on),as=o(e),h(ze.$$.fragment,e),ss=o(e),Ee=n(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1kgdd01"&&(Ee.innerHTML=pn),ls=o(e),h(Xe.$$.fragment,e),ns=o(e),At=n(e,"A",{id:!0}),c(At).forEach(t),rs=o(e),x=n(e,"H2",{class:!0});var ol=c(x);P=n(ol,"A",{id:!0,class:!0,href:!0});var Dn=c(P);da=n(Dn,"SPAN",{});var Kn=c(da);h(Be.$$.fragment,Kn),Kn.forEach(t),Dn.forEach(t),_l=o(ol),Yt=n(ol,"SPAN",{"data-svelte-h":!0}),d(Yt)!=="svelte-1uizl8f"&&(Yt.textContent=cn),ol.forEach(t),os=o(e),h(Fe.$$.fragment,e),is=o(e),He=n(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-7ow6xu"&&(He.textContent=dn),ps=o(e),I=n(e,"H3",{class:!0});var il=c(I);L=n(il,"A",{id:!0,class:!0,href:!0});var On=c(L);ma=n(On,"SPAN",{});var er=c(ma);h(Ne.$$.fragment,er),er.forEach(t),On.forEach(t),kl=o(il),Vt=n(il,"SPAN",{"data-svelte-h":!0}),d(Vt)!=="svelte-ev1aww"&&(Vt.textContent=mn),il.forEach(t),cs=o(e),Ae=n(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1o5ba62"&&(Ae.innerHTML=hn),ds=o(e),h(Ye.$$.fragment,e),ms=o(e),h(Q.$$.fragment,e),hs=o(e),Ve=n(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-4xrib6"&&(Ve.innerHTML=un),us=o(e),h(qe.$$.fragment,e),fs=o(e),R=n(e,"H3",{class:!0});var pl=c(R);D=n(pl,"A",{id:!0,class:!0,href:!0});var tr=c(D);ha=n(tr,"SPAN",{});var ar=c(ha);h(Se.$$.fragment,ar),ar.forEach(t),tr.forEach(t),Cl=o(pl),qt=n(pl,"SPAN",{"data-svelte-h":!0}),d(qt)!=="svelte-158bffn"&&(qt.textContent=fn),pl.forEach(t),gs=o(e),Pe=n(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-nyxf5n"&&(Pe.textContent=gn),ys=o(e),h(Le.$$.fragment,e),bs=o(e),Qe=n(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1k8sz6c"&&(Qe.innerHTML=yn),Ms=o(e),h(De.$$.fragment,e),ws=o(e),St=n(e,"A",{id:!0}),c(St).forEach(t),vs=o(e),G=n(e,"H2",{class:!0});var cl=c(G);K=n(cl,"A",{id:!0,class:!0,href:!0});var sr=c(K);ua=n(sr,"SPAN",{});var lr=c(ua);h(Ke.$$.fragment,lr),lr.forEach(t),sr.forEach(t),Zl=o(cl),Pt=n(cl,"SPAN",{"data-svelte-h":!0}),d(Pt)!=="svelte-1bzv9zz"&&(Pt.textContent=bn),cl.forEach(t),js=o(e),h(Oe.$$.fragment,e),$s=o(e),et=n(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-1e5fids"&&(et.innerHTML=Mn),Ts=o(e),tt=n(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-izthtk"&&(tt.textContent=wn),Js=o(e),h(at.$$.fragment,e),_s=o(e),st=n(e,"P",{"data-svelte-h":!0}),d(st)!=="svelte-k4uz55"&&(st.innerHTML=vn),ks=o(e),T=n(e,"OL",{});var la=c(T);lt=n(la,"LI",{});var dl=c(lt);Lt=n(dl,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-zx6r95"&&(Lt.innerHTML=jn),Ul=o(dl),h(nt.$$.fragment,dl),dl.forEach(t),xl=o(la),rt=n(la,"LI",{});var ml=c(rt);Qt=n(ml,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-kqcj8b"&&(Qt.innerHTML=$n),Il=o(ml),h(ot.$$.fragment,ml),ml.forEach(t),Rl=o(la),it=n(la,"LI",{});var hl=c(it);Dt=n(hl,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-1836e76"&&(Dt.textContent=Tn),Gl=o(hl),h(pt.$$.fragment,hl),hl.forEach(t),la.forEach(t),Cs=o(e),ct=n(e,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1aawh5m"&&(ct.textContent=Jn),Zs=o(e),h(dt.$$.fragment,e),Us=o(e),W=n(e,"H3",{class:!0});var ul=c(W);O=n(ul,"A",{id:!0,class:!0,href:!0});var nr=c(O);fa=n(nr,"SPAN",{});var rr=c(fa);h(mt.$$.fragment,rr),rr.forEach(t),nr.forEach(t),Wl=o(ul),Kt=n(ul,"SPAN",{"data-svelte-h":!0}),d(Kt)!=="svelte-19b0x1w"&&(Kt.textContent=_n),ul.forEach(t),xs=o(e),ht=n(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-c0jmc2"&&(ht.innerHTML=kn),Is=o(e),h(ut.$$.fragment,e),Rs=o(e),ft=n(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1ed0x50"&&(ft.textContent=Cn),Gs=o(e),h(gt.$$.fragment,e),Ws=o(e),z=n(e,"H3",{class:!0});var fl=c(z);ee=n(fl,"A",{id:!0,class:!0,href:!0});var or=c(ee);ga=n(or,"SPAN",{});var ir=c(ga);h(yt.$$.fragment,ir),ir.forEach(t),or.forEach(t),zl=o(fl),Ot=n(fl,"SPAN",{"data-svelte-h":!0}),d(Ot)!=="svelte-mqgqu9"&&(Ot.textContent=Zn),fl.forEach(t),zs=o(e),bt=n(e,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-l209jc"&&(bt.innerHTML=Un),Es=o(e),h(Mt.$$.fragment,e),Xs=o(e),wt=n(e,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-nkntum"&&(wt.innerHTML=xn),Bs=o(e),h(vt.$$.fragment,e),Fs=o(e),jt=n(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-1ni7zw3"&&(jt.innerHTML=In),Hs=o(e),h($t.$$.fragment,e),Ns=o(e),h(te.$$.fragment,e),As=o(e),Tt=n(e,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-1z11csw"&&(Tt.textContent=Rn),Ys=o(e),E=n(e,"H3",{class:!0});var gl=c(E);ae=n(gl,"A",{id:!0,class:!0,href:!0});var pr=c(ae);ya=n(pr,"SPAN",{});var cr=c(ya);h(Jt.$$.fragment,cr),cr.forEach(t),pr.forEach(t),El=o(gl),ea=n(gl,"SPAN",{"data-svelte-h":!0}),d(ea)!=="svelte-19pwz8b"&&(ea.textContent=Gn),gl.forEach(t),Vs=o(e),_t=n(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-102z8xq"&&(_t.innerHTML=Wn),qs=o(e),h(kt.$$.fragment,e),Ss=o(e),X=n(e,"H3",{class:!0});var yl=c(X);se=n(yl,"A",{id:!0,class:!0,href:!0});var dr=c(se);ba=n(dr,"SPAN",{});var mr=c(ba);h(Ct.$$.fragment,mr),mr.forEach(t),dr.forEach(t),Xl=o(yl),ta=n(yl,"SPAN",{"data-svelte-h":!0}),d(ta)!=="svelte-1ok7mdh"&&(ta.textContent=zn),yl.forEach(t),Ps=o(e),Zt=n(e,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-190kgch"&&(Zt.innerHTML=En),Ls=o(e),h(Ut.$$.fragment,e),Qs=o(e),aa=n(e,"A",{id:!0}),c(aa).forEach(t),Ds=o(e),B=n(e,"H2",{class:!0});var bl=c(B);le=n(bl,"A",{id:!0,class:!0,href:!0});var hr=c(le);Ma=n(hr,"SPAN",{});var ur=c(Ma);h(xt.$$.fragment,ur),ur.forEach(t),hr.forEach(t),Bl=o(bl),sa=n(bl,"SPAN",{"data-svelte-h":!0}),d(sa)!=="svelte-1a8fiad"&&(sa.textContent=Xn),bl.forEach(t),Ks=o(e),It=n(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-p06dg2"&&(It.textContent=Bn),Os=o(e),Rt=n(e,"UL",{"data-svelte-h":!0}),d(Rt)!=="svelte-hy4ewn"&&(Rt.innerHTML=Fn),el=o(e),wa=n(e,"P",{}),c(wa).forEach(t),this.h()},h(){p(b,"name","hf:doc:metadata"),p(b,"content",JSON.stringify(Jr)),p(H,"id","finetuning-a-un-modelo-preentrenado"),p(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(H,"href","#finetuning-a-un-modelo-preentrenado"),p(J,"class","relative group"),p(zt,"id","data-processing"),p(N,"id","prepara-un-dataset"),p(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(N,"href","#prepara-un-dataset"),p(_,"class","relative group"),p(Xt,"id","trainer"),p(A,"id","finetuning-con-trainer"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#finetuning-con-trainer"),p(k,"class","relative group"),p(V,"id","hiperparmetros-de-entrenamiento"),p(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(V,"href","#hiperparmetros-de-entrenamiento"),p(C,"class","relative group"),p(q,"id","mtricas"),p(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(q,"href","#mtricas"),p(Z,"class","relative group"),p(S,"id","trainer"),p(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(S,"href","#trainer"),p(U,"class","relative group"),p(At,"id","keras"),p(P,"id","finetuning-con-keras"),p(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(P,"href","#finetuning-con-keras"),p(x,"class","relative group"),p(L,"id","convierte-el-dataset-al-formato-de-tensorflow"),p(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(L,"href","#convierte-el-dataset-al-formato-de-tensorflow"),p(I,"class","relative group"),p(D,"id","compila-y-ajusta"),p(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(D,"href","#compila-y-ajusta"),p(R,"class","relative group"),p(St,"id","pytorch_native"),p(K,"id","finetune-en-pytorch-nativo"),p(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(K,"href","#finetune-en-pytorch-nativo"),p(G,"class","relative group"),p(O,"id","dataloader"),p(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(O,"href","#dataloader"),p(W,"class","relative group"),p(ee,"id","optimiza-y-programa-el-learning-rate"),p(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ee,"href","#optimiza-y-programa-el-learning-rate"),p(z,"class","relative group"),p(ae,"id","ciclo-de-entrenamiento"),p(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ae,"href","#ciclo-de-entrenamiento"),p(E,"class","relative group"),p(se,"id","mtricas"),p(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(se,"href","#mtricas"),p(X,"class","relative group"),p(aa,"id","additional-resources"),p(le,"id","recursos-adicionales"),p(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(le,"href","#recursos-adicionales"),p(B,"class","relative group")},m(e,a){i(document.head,b),s(e,j,a),s(e,w,a),s(e,$,a),s(e,J,a),i(J,H),i(H,na),u(ne,na,null),i(J,wl),i(J,Wt),s(e,$a,a),u(re,e,a),s(e,Ta,a),s(e,oe,a),s(e,Ja,a),s(e,ie,a),s(e,_a,a),s(e,zt,a),s(e,ka,a),s(e,_,a),i(_,N),i(N,ra),u(pe,ra,null),i(_,vl),i(_,Et),s(e,Ca,a),u(ce,e,a),s(e,Za,a),s(e,de,a),s(e,Ua,a),s(e,me,a),s(e,xa,a),u(he,e,a),s(e,Ia,a),s(e,ue,a),s(e,Ra,a),u(fe,e,a),s(e,Ga,a),s(e,ge,a),s(e,Wa,a),u(ye,e,a),s(e,za,a),s(e,Xt,a),s(e,Ea,a),s(e,k,a),i(k,A),i(A,oa),u(be,oa,null),i(k,jl),i(k,Bt),s(e,Xa,a),u(Me,e,a),s(e,Ba,a),s(e,we,a),s(e,Fa,a),s(e,ve,a),s(e,Ha,a),u(je,e,a),s(e,Na,a),u(Y,e,a),s(e,Aa,a),s(e,C,a),i(C,V),i(V,ia),u($e,ia,null),i(C,$l),i(C,Ft),s(e,Ya,a),s(e,Te,a),s(e,Va,a),s(e,Je,a),s(e,qa,a),u(_e,e,a),s(e,Sa,a),s(e,Z,a),i(Z,q),i(q,pa),u(ke,pa,null),i(Z,Tl),i(Z,Ht),s(e,Pa,a),s(e,Ce,a),s(e,La,a),u(Ze,e,a),s(e,Qa,a),s(e,Ue,a),s(e,Da,a),u(xe,e,a),s(e,Ka,a),s(e,Ie,a),s(e,Oa,a),u(Re,e,a),s(e,es,a),s(e,U,a),i(U,S),i(S,ca),u(Ge,ca,null),i(U,Jl),i(U,Nt),s(e,ts,a),s(e,We,a),s(e,as,a),u(ze,e,a),s(e,ss,a),s(e,Ee,a),s(e,ls,a),u(Xe,e,a),s(e,ns,a),s(e,At,a),s(e,rs,a),s(e,x,a),i(x,P),i(P,da),u(Be,da,null),i(x,_l),i(x,Yt),s(e,os,a),u(Fe,e,a),s(e,is,a),s(e,He,a),s(e,ps,a),s(e,I,a),i(I,L),i(L,ma),u(Ne,ma,null),i(I,kl),i(I,Vt),s(e,cs,a),s(e,Ae,a),s(e,ds,a),u(Ye,e,a),s(e,ms,a),u(Q,e,a),s(e,hs,a),s(e,Ve,a),s(e,us,a),u(qe,e,a),s(e,fs,a),s(e,R,a),i(R,D),i(D,ha),u(Se,ha,null),i(R,Cl),i(R,qt),s(e,gs,a),s(e,Pe,a),s(e,ys,a),u(Le,e,a),s(e,bs,a),s(e,Qe,a),s(e,Ms,a),u(De,e,a),s(e,ws,a),s(e,St,a),s(e,vs,a),s(e,G,a),i(G,K),i(K,ua),u(Ke,ua,null),i(G,Zl),i(G,Pt),s(e,js,a),u(Oe,e,a),s(e,$s,a),s(e,et,a),s(e,Ts,a),s(e,tt,a),s(e,Js,a),u(at,e,a),s(e,_s,a),s(e,st,a),s(e,ks,a),s(e,T,a),i(T,lt),i(lt,Lt),i(lt,Ul),u(nt,lt,null),i(T,xl),i(T,rt),i(rt,Qt),i(rt,Il),u(ot,rt,null),i(T,Rl),i(T,it),i(it,Dt),i(it,Gl),u(pt,it,null),s(e,Cs,a),s(e,ct,a),s(e,Zs,a),u(dt,e,a),s(e,Us,a),s(e,W,a),i(W,O),i(O,fa),u(mt,fa,null),i(W,Wl),i(W,Kt),s(e,xs,a),s(e,ht,a),s(e,Is,a),u(ut,e,a),s(e,Rs,a),s(e,ft,a),s(e,Gs,a),u(gt,e,a),s(e,Ws,a),s(e,z,a),i(z,ee),i(ee,ga),u(yt,ga,null),i(z,zl),i(z,Ot),s(e,zs,a),s(e,bt,a),s(e,Es,a),u(Mt,e,a),s(e,Xs,a),s(e,wt,a),s(e,Bs,a),u(vt,e,a),s(e,Fs,a),s(e,jt,a),s(e,Hs,a),u($t,e,a),s(e,Ns,a),u(te,e,a),s(e,As,a),s(e,Tt,a),s(e,Ys,a),s(e,E,a),i(E,ae),i(ae,ya),u(Jt,ya,null),i(E,El),i(E,ea),s(e,Vs,a),s(e,_t,a),s(e,qs,a),u(kt,e,a),s(e,Ss,a),s(e,X,a),i(X,se),i(se,ba),u(Ct,ba,null),i(X,Xl),i(X,ta),s(e,Ps,a),s(e,Zt,a),s(e,Ls,a),u(Ut,e,a),s(e,Qs,a),s(e,aa,a),s(e,Ds,a),s(e,B,a),i(B,le),i(le,Ma),u(xt,Ma,null),i(B,Bl),i(B,sa),s(e,Ks,a),s(e,It,a),s(e,Os,a),s(e,Rt,a),s(e,el,a),s(e,wa,a),tl=!0},p(e,[a]){const Gt={};a&2&&(Gt.$$scope={dirty:a,ctx:e}),Y.$set(Gt);const va={};a&2&&(va.$$scope={dirty:a,ctx:e}),Q.$set(va);const ja={};a&2&&(ja.$$scope={dirty:a,ctx:e}),te.$set(ja)},i(e){tl||(f(ne.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(ce.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(ye.$$.fragment,e),f(be.$$.fragment,e),f(Me.$$.fragment,e),f(je.$$.fragment,e),f(Y.$$.fragment,e),f($e.$$.fragment,e),f(_e.$$.fragment,e),f(ke.$$.fragment,e),f(Ze.$$.fragment,e),f(xe.$$.fragment,e),f(Re.$$.fragment,e),f(Ge.$$.fragment,e),f(ze.$$.fragment,e),f(Xe.$$.fragment,e),f(Be.$$.fragment,e),f(Fe.$$.fragment,e),f(Ne.$$.fragment,e),f(Ye.$$.fragment,e),f(Q.$$.fragment,e),f(qe.$$.fragment,e),f(Se.$$.fragment,e),f(Le.$$.fragment,e),f(De.$$.fragment,e),f(Ke.$$.fragment,e),f(Oe.$$.fragment,e),f(at.$$.fragment,e),f(nt.$$.fragment,e),f(ot.$$.fragment,e),f(pt.$$.fragment,e),f(dt.$$.fragment,e),f(mt.$$.fragment,e),f(ut.$$.fragment,e),f(gt.$$.fragment,e),f(yt.$$.fragment,e),f(Mt.$$.fragment,e),f(vt.$$.fragment,e),f($t.$$.fragment,e),f(te.$$.fragment,e),f(Jt.$$.fragment,e),f(kt.$$.fragment,e),f(Ct.$$.fragment,e),f(Ut.$$.fragment,e),f(xt.$$.fragment,e),tl=!0)},o(e){g(ne.$$.fragment,e),g(re.$$.fragment,e),g(pe.$$.fragment,e),g(ce.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(je.$$.fragment,e),g(Y.$$.fragment,e),g($e.$$.fragment,e),g(_e.$$.fragment,e),g(ke.$$.fragment,e),g(Ze.$$.fragment,e),g(xe.$$.fragment,e),g(Re.$$.fragment,e),g(Ge.$$.fragment,e),g(ze.$$.fragment,e),g(Xe.$$.fragment,e),g(Be.$$.fragment,e),g(Fe.$$.fragment,e),g(Ne.$$.fragment,e),g(Ye.$$.fragment,e),g(Q.$$.fragment,e),g(qe.$$.fragment,e),g(Se.$$.fragment,e),g(Le.$$.fragment,e),g(De.$$.fragment,e),g(Ke.$$.fragment,e),g(Oe.$$.fragment,e),g(at.$$.fragment,e),g(nt.$$.fragment,e),g(ot.$$.fragment,e),g(pt.$$.fragment,e),g(dt.$$.fragment,e),g(mt.$$.fragment,e),g(ut.$$.fragment,e),g(gt.$$.fragment,e),g(yt.$$.fragment,e),g(Mt.$$.fragment,e),g(vt.$$.fragment,e),g($t.$$.fragment,e),g(te.$$.fragment,e),g(Jt.$$.fragment,e),g(kt.$$.fragment,e),g(Ct.$$.fragment,e),g(Ut.$$.fragment,e),g(xt.$$.fragment,e),tl=!1},d(e){e&&(t(j),t(w),t($),t(J),t($a),t(Ta),t(oe),t(Ja),t(ie),t(_a),t(zt),t(ka),t(_),t(Ca),t(Za),t(de),t(Ua),t(me),t(xa),t(Ia),t(ue),t(Ra),t(Ga),t(ge),t(Wa),t(za),t(Xt),t(Ea),t(k),t(Xa),t(Ba),t(we),t(Fa),t(ve),t(Ha),t(Na),t(Aa),t(C),t(Ya),t(Te),t(Va),t(Je),t(qa),t(Sa),t(Z),t(Pa),t(Ce),t(La),t(Qa),t(Ue),t(Da),t(Ka),t(Ie),t(Oa),t(es),t(U),t(ts),t(We),t(as),t(ss),t(Ee),t(ls),t(ns),t(At),t(rs),t(x),t(os),t(is),t(He),t(ps),t(I),t(cs),t(Ae),t(ds),t(ms),t(hs),t(Ve),t(us),t(fs),t(R),t(gs),t(Pe),t(ys),t(bs),t(Qe),t(Ms),t(ws),t(St),t(vs),t(G),t(js),t($s),t(et),t(Ts),t(tt),t(Js),t(_s),t(st),t(ks),t(T),t(Cs),t(ct),t(Zs),t(Us),t(W),t(xs),t(ht),t(Is),t(Rs),t(ft),t(Gs),t(Ws),t(z),t(zs),t(bt),t(Es),t(Xs),t(wt),t(Bs),t(Fs),t(jt),t(Hs),t(Ns),t(As),t(Tt),t(Ys),t(E),t(Vs),t(_t),t(qs),t(Ss),t(X),t(Ps),t(Zt),t(Ls),t(Qs),t(aa),t(Ds),t(B),t(Ks),t(It),t(Os),t(Rt),t(el),t(wa)),t(b),y(ne),y(re,e),y(pe),y(ce,e),y(he,e),y(fe,e),y(ye,e),y(be),y(Me,e),y(je,e),y(Y,e),y($e),y(_e,e),y(ke),y(Ze,e),y(xe,e),y(Re,e),y(Ge),y(ze,e),y(Xe,e),y(Be),y(Fe,e),y(Ne),y(Ye,e),y(Q,e),y(qe,e),y(Se),y(Le,e),y(De,e),y(Ke),y(Oe,e),y(at,e),y(nt),y(ot),y(pt),y(dt,e),y(mt),y(ut,e),y(gt,e),y(yt),y(Mt,e),y(vt,e),y($t,e),y(te,e),y(Jt),y(kt,e),y(Ct),y(Ut,e),y(xt)}}}const Jr={local:"finetuning-a-un-modelo-preentrenado",sections:[{local:"prepara-un-dataset",title:"Prepara un dataset"},{local:"finetuning-con-trainer",sections:[{local:"hiperparmetros-de-entrenamiento",title:"Hiperparámetros de entrenamiento"},{local:"mtricas",title:"Métricas"},{local:"trainer",title:"Trainer"}],title:"Fine-tuning con `Trainer`"},{local:"finetuning-con-keras",sections:[{local:"convierte-el-dataset-al-formato-de-tensorflow",title:"Convierte el dataset al formato de TensorFlow"},{local:"compila-y-ajusta",title:"Compila y ajusta"}],title:"Fine-tuning con Keras"},{local:"finetune-en-pytorch-nativo",sections:[{local:"dataloader",title:"DataLoader"},{local:"optimiza-y-programa-el-learning-rate",title:"Optimiza y programa el learning rate"},{local:"ciclo-de-entrenamiento",title:"Ciclo de entrenamiento"},{local:"mtricas",title:"Métricas"}],title:"Fine-tune en PyTorch nativo"},{local:"recursos-adicionales",title:"Recursos adicionales"}],title:"Fine-tuning a un modelo pre-entrenado"};function _r(F){return gr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gr extends yr{constructor(b){super(),br(this,b,_r,Tr,fr,{})}}export{Gr as component};
