import{s as kr,o as Sr,n as jt}from"../chunks/scheduler.9bc65507.js";import{S as xr,i as Cr,g as n,s,u as _,A as $r,h as r,f as o,c as a,j as m,v as g,y as p,k as h,o as t,a as d,w as T,d as w,t as v,x as y}from"../chunks/index.78c82d43.js";import{T as Tn}from"../chunks/Tip.87d55b76.js";import{D as R}from"../chunks/Docstring.f3d04bd2.js";import{C as vn}from"../chunks/CodeBlock.48618ec2.js";import{I as D}from"../chunks/IconCopyLink.bedaa44d.js";import{E as wn}from"../chunks/ExampleCodeBlock.872b014d.js";function zr(z){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=n("p"),l.innerHTML=M},l(u){l=r(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(u,f){d(u,l,f)},p:jt,d(u){u&&o(l)}}}function Fr(z){let l,M="Example:",u,f,b;return f=new vn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnN3aXRjaC1iYXNlLTglMjIpJTBBbW9kZWwlMjAlM0QlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGc3dpdGNoLWJhc2UtOCUyMiklMEElMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIyU3R1ZGllcyUyMGhhdmUlMjBiZWVuJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMjJTdHVkaWVzJTIwc2hvdyUyMHRoYXQlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBJTBBJTIzJTIwcHJlcHJvY2VzcyUzQSUyMFByZXBlbmQlMjBkZWNvZGVyX2lucHV0X2lkcyUyMHdpdGglMjBzdGFydCUyMHRva2VuJTIwd2hpY2glMjBpcyUyMHBhZCUyMHRva2VuJTIwZm9yJTIwU3dpdGNoVHJhbnNmb3JtZXJzTW9kZWwuJTBBJTIzJTIwVGhpcyUyMGlzJTIwbm90JTIwbmVlZGVkJTIwZm9yJTIwdG9yY2gncyUyMFN3aXRjaFRyYW5zZm9ybWVyc0ZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyMGFzJTIwaXQlMjBkb2VzJTIwdGhpcyUyMGludGVybmFsbHklMjB1c2luZyUyMGxhYmVscyUyMGFyZy4lMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMG1vZGVsLl9zaGlmdF9yaWdodChkZWNvZGVyX2lucHV0X2lkcyklMEElMEElMjMlMjBmb3J3YXJkJTIwcGFzcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGRlY29kZXJfaW5wdXRfaWRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SwitchTransformersModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwitchTransformersModel.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(<span class="hljs-string">&quot;Studies show that&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># preprocess: Prepend decoder_input_ids with start token which is pad token for SwitchTransformersModel.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is not needed for torch&#x27;s SwitchTransformersForConditionalGeneration as it does this internally using labels arg.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = model._shift_right(decoder_input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){l=n("p"),l.textContent=M,u=s(),_(f.$$.fragment)},l(c){l=r(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=M),u=a(c),g(f.$$.fragment,c)},m(c,k){d(c,l,k),d(c,u,k),T(f,c,k),b=!0},p:jt,i(c){b||(w(f.$$.fragment,c),b=!0)},o(c){v(f.$$.fragment,c),b=!1},d(c){c&&(o(l),o(u)),y(f,c)}}}function jr(z){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=n("p"),l.innerHTML=M},l(u){l=r(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(u,f){d(u,l,f)},p:jt,d(u){u&&o(l)}}}function Hr(z){let l,M="Examples:",u,f,b;return f=new vn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpdGNoVHJhbnNmb3JtZXJzRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQSUwQSUyMyUyMHRyYWluaW5nJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMCUzQ2V4dHJhX2lkXzAlM0UlMjB3YWxrcyUyMGluJTIwJTNDZXh0cmFfaWRfMSUzRSUyMHBhcmslMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEFsYWJlbHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyJTNDZXh0cmFfaWRfMCUzRSUyMGN1dGUlMjBkb2clMjAlM0NleHRyYV9pZF8xJTNFJTIwdGhlJTIwJTNDZXh0cmFfaWRfMiUzRSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBJTIzJTIwaW5mZXJlbmNlJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMnN1bW1hcml6ZSUzQSUyMHN0dWRpZXMlMjBoYXZlJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzKSUwQSUyMyUyMC4lMjBUbyUyQyUyMGxldCVFMiU4MCU5OXMlMjBzYXklMjB5b3UlMjBoYXZlJTIwYSUyMGRvZy4lMjBUbyUyMHN1bW1hcml6ZSUzQSUwQSUyMyUyMFNpbmNlJTIwdGhlJTIwbW9kZWwlMjBoYXMlMjBiZWVuJTIwdHJhaW5lZCUyMG9uJTIwTUxNJTJDJTIwdGhpcyUyMHdpbGwlMjBvdXRwdXQlMjBnaWJiZXJpc2g=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SwitchTransformersForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwitchTransformersForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;The &lt;extra_id_0&gt; walks in &lt;extra_id_1&gt; park&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;&lt;extra_id_0&gt; cute dog &lt;extra_id_1&gt; the &lt;extra_id_2&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;summarize: studies have shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># . To, let’s say you have a dog. To summarize:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since the model has been trained on MLM, this will output gibberish</span>`}}),{c(){l=n("p"),l.textContent=M,u=s(),_(f.$$.fragment)},l(c){l=r(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-kvfsh7"&&(l.textContent=M),u=a(c),g(f.$$.fragment,c)},m(c,k){d(c,l,k),d(c,u,k),T(f,c,k),b=!0},p:jt,i(c){b||(w(f.$$.fragment,c),b=!0)},o(c){v(f.$$.fragment,c),b=!1},d(c){c&&(o(l),o(u)),y(f,c)}}}function Ur(z){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=n("p"),l.innerHTML=M},l(u){l=r(u,"P",{"data-svelte-h":!0}),p(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(u,f){d(u,l,f)},p:jt,d(u){u&&o(l)}}}function Jr(z){let l,M="Example:",u,f,b;return f=new vn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNFbmNvZGVyTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpdGNoVHJhbnNmb3JtZXJzRW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJTdHVkaWVzJTIwaGF2ZSUyMGJlZW4lMjBzaG93biUyMHRoYXQlMjBvd25pbmclMjBhJTIwZG9nJTIwaXMlMjBnb29kJTIwZm9yJTIweW91JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkuaW5wdXRfaWRzJTIwJTIwJTIzJTIwQmF0Y2glMjBzaXplJTIwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMpJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SwitchTransformersEncoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwitchTransformersEncoderModel.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){l=n("p"),l.textContent=M,u=s(),_(f.$$.fragment)},l(c){l=r(c,"P",{"data-svelte-h":!0}),p(l)!=="svelte-11lpom8"&&(l.textContent=M),u=a(c),g(f.$$.fragment,c)},m(c,k){d(c,l,k),d(c,u,k),T(f,c,k),b=!0},p:jt,i(c){b||(w(f.$$.fragment,c),b=!0)},o(c){v(f.$$.fragment,c),b=!1},d(c){c&&(o(l),o(u)),y(f,c)}}}function Er(z){let l,M,u,f,b,c,k,_e,ko,Ve,yn="SwitchTransformers",Bt,G,Y,Ht,ge,So,Xe,bn="Overview",At,Te,Mn='The SwitchTransformers model was proposed in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with Simple and Efficient Sparsity</a> by William Fedus, Barret Zoph, Noam Shazeer.',Vt,we,kn=`The Switch Transformer model uses a sparse T5 encoder-decoder architecture, where the MLP are replaced by a Mixture of Experts (MoE). A routing mechanism (top 1 in this case) associates each token to one of the expert, where each expert is a dense MLP. While switch transformers have a lot more weights than their equivalent dense models, the sparsity allows better scaling and better finetuning performance at scale.
During a forward pass, only a fraction of the weights are used. The routing mechanism allows the model to select relevant weights on the fly which increases the model capacity without increasing the number of operations.`,Xt,ve,Sn="The abstract from the paper is the following:",Ot,ye,xn="<em>In deep learning, models typically reuse the same parameters for all inputs. Mixture of Experts (MoE) defies this and instead selects different parameters for each incoming example. The result is a sparsely-activated model — with outrageous numbers of parameters — but a constant computational cost. However, despite several notable successes of MoE, widespread adoption has been hindered by complexity, communication costs and training instability — we address these with the Switch Transformer. We simplify the MoE routing algorithm and design intuitive improved models with reduced communication and computational costs. Our proposed training techniques help wrangle the instabilities and we show large sparse models may be trained, for the first time, with lower precision (bfloat16) formats. We design models based off T5-Base and T5-Large to obtain up to 7x increases in pre-training speed with the same computational resources. These improvements extend into multilingual settings where we measure gains over the mT5-Base version across all 101 languages. Finally, we advance the current scale of language models by pre-training up to trillion parameter models on the “Colossal Clean Crawled Corpus” and achieve a 4x speedup over the T5-XXL model.</em>",Dt,be,Cn="Tips:",Yt,Me,$n='<li>SwitchTransformers uses the <a href="/docs/transformers/v4.33.3/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a>, which can be loaded directly from each model’s repository.</li> <li>The released weights are pretrained on English <a href="https://moon-ci-docs.huggingface.co/docs/transformers/pr_19323/en/glossary#general-terms" rel="nofollow">Masked Language Modeling</a> task, and should be finetuned.</li>',Qt,ke,zn=`This model was contributed by <a href="https://huggingface.co/ybelkada" rel="nofollow">Younes Belkada</a> and <a href="https://huggingface.co/ArtZucker" rel="nofollow">Arthur Zucker</a> .
The original code can be found <a href="https://github.com/google/flaxformer/tree/main/flaxformer/architectures/moe" rel="nofollow">here</a>.`,Kt,P,Q,Ut,Se,xo,Oe,Fn="Resources",eo,xe,jn='<li><a href="../tasks/translation">Translation task guide</a></li> <li><a href="../tasks/summarization">Summarization task guide</a></li>',to,L,K,Jt,Ce,Co,De,Hn="SwitchTransformersConfig",oo,q,$e,$o,Ye,Un=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a>. It is used to
instantiate a SwitchTransformers model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the
SwitchTransformers <a href="https://huggingface.co/google/switch-base-8" rel="nofollow">google/switch-base-8</a> architecture.`,zo,Qe,Jn=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,no,B,ee,Et,ze,Fo,Ke,En="SwitchTransformersTop1Router",ro,$,Fe,jo,et,In="Router using tokens choose top-1 experts assignment.",Ho,tt,Rn=`This router uses the same mechanism as in Switch Transformer (<a href="https://arxiv.org/abs/2101.03961" rel="nofollow">https://arxiv.org/abs/2101.03961</a>) and V-MoE
(<a href="https://arxiv.org/abs/2106.05974" rel="nofollow">https://arxiv.org/abs/2106.05974</a>): tokens choose their top experts. Items are sorted by router_probs and then
routed to their choice of expert until the expert’s expert_capacity is reached. <strong>There is no guarantee that each
token is processed by an expert</strong>, or that each expert receives at least one token.`,Uo,te,je,Jo,ot,qn="Computes router probabilities from input hidden states.",Eo,N,He,Io,nt,Zn=`Generic forward function for every Router class. Each Router expects to have the same input hidden states
(<code>hidden_states</code>) corresponding to the hidden states for each token, the <code>expert_capacity</code> corresponding to the
number of tokens the Router will send to each expert, some Routers can send up to few tokens to each expert.`,Ro,rt,Nn=`Each Router works as the following: it expects the hidden states for each token, gets the <code>router_probs</code> and
<code>router_logits</code> from the <code>router_weights</code>. This will assign for each token, the raw probability to be assigned
to an expert. Then each Router class will have to define its own <code>_compute_routing_instructions</code>.`,so,A,oe,It,Ue,qo,st,Wn="SwitchTransformersSparseMLP",ao,Z,Je,Zo,at,Gn="Implementation of the Switch Transformers Sparse MLP module.",No,F,Ee,Wo,it,Pn="Hold on, this will be slightly tricky to understand In the correct order, a MoE layer does the following:",Go,dt,Ln=`1- Gets the <code>router_mask</code> from the router. The shape of the mask is <code>(batch_size, sequence_length, num_expert)</code>
and corresponds to the argmax of the <code>router_probs</code>. The probabilities are needed in the computation of the
hidden states : they are broadcasted to the hidden states values (can be interpreted as a scaling factor).`,Po,lt,Bn=`2- Dispatch the tokens to its associated experts. We do a classic for loop over the experts and assign for each
expert the corresponding hidden states.`,io,V,ne,Rt,Ie,Lo,ct,An="SwitchTransformersModel",lo,S,Re,Bo,ht,Vn="The bare SWITCH_TRANSFORMERS Model transformer outputting raw hidden-states without any specific head on top.",Ao,pt,Xn=`The SWITCH_TRANSFORMERS model was proposed in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with
Simple and Efficient Sparsity</a> by <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Fedus%2C+W" rel="nofollow">William
Fedus</a>, <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Zoph%2C+B" rel="nofollow">Barret
Zoph</a>, and <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Shazeer%2C+N" rel="nofollow">Noam
Shazeer</a>. It’s an encoder-decoder T5-like model
with sparse Feed Forward that stands for Mixture of Experts (MoE) architecture.`,Vo,mt,On=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xo,ut,Dn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Oo,j,qe,Do,ft,Yn='The <a href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a> forward method, overrides the <code>__call__</code> special method.',Yo,re,Qo,se,co,X,ae,qt,Ze,Ko,_t,Qn="SwitchTransformersForConditionalGeneration",ho,x,Ne,en,gt,Kn="SWITCH_TRANSFORMERS Model with a <code>language modeling</code> head on top.",tn,Tt,er=`The SWITCH_TRANSFORMERS model was proposed in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with
Simple and Efficient Sparsity</a> by <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Fedus%2C+W" rel="nofollow">William
Fedus</a>, <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Zoph%2C+B" rel="nofollow">Barret
Zoph</a>, and <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Shazeer%2C+N" rel="nofollow">Noam
Shazeer</a>. It’s an encoder-decoder T5-like model
with sparse Feed Forward that stands for Mixture of Experts (MoE) architecture.`,on,wt,tr=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,nn,vt,or=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,rn,H,We,sn,yt,nr='The <a href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',an,ie,dn,de,po,O,le,Zt,Ge,ln,bt,rr="SwitchTransformersEncoderModel",mo,C,Pe,cn,Mt,sr="The bare SWITCH_TRANSFORMERS Model transformer outputting encoder’s raw hidden-states without any specific head on top.",hn,kt,ar=`The SWITCH_TRANSFORMERS model was proposed in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with
Simple and Efficient Sparsity</a> by <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Fedus%2C+W" rel="nofollow">William
Fedus</a>, <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Zoph%2C+B" rel="nofollow">Barret
Zoph</a>, and <a href="https://arxiv.org/search/cs?searchtype=author&amp;query=Shazeer%2C+N" rel="nofollow">Noam
Shazeer</a>. It’s an encoder-decoder T5-like model
with sparse Feed Forward that stands for Mixture of Experts (MoE) architecture.`,pn,St,ir=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,mn,xt,dr=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,un,U,Le,fn,Ct,lr='The <a href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersEncoderModel">SwitchTransformersEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',_n,ce,gn,he,uo,Nt,fo;return _e=new D({}),ge=new D({}),Se=new D({}),Ce=new D({}),$e=new R({props:{name:"class transformers.SwitchTransformersConfig",anchor:"transformers.SwitchTransformersConfig",parameters:[{name:"vocab_size",val:" = 32128"},{name:"d_model",val:" = 768"},{name:"d_kv",val:" = 64"},{name:"d_ff",val:" = 2048"},{name:"expert_capacity",val:" = 64"},{name:"num_layers",val:" = 12"},{name:"num_sparse_encoder_layers",val:" = 3"},{name:"num_decoder_layers",val:" = 12"},{name:"num_sparse_decoder_layers",val:" = 3"},{name:"num_heads",val:" = 12"},{name:"num_experts",val:" = 8"},{name:"router_bias",val:" = False"},{name:"router_jitter_noise",val:" = 0.01"},{name:"router_dtype",val:" = 'float32'"},{name:"router_ignore_padding_tokens",val:" = False"},{name:"relative_attention_num_buckets",val:" = 32"},{name:"relative_attention_max_distance",val:" = 128"},{name:"dropout_rate",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-06"},{name:"router_z_loss_coef",val:" = 0.001"},{name:"router_aux_loss_coef",val:" = 0.001"},{name:"initializer_factor",val:" = 1.0"},{name:"dense_act_fn",val:" = 'relu'"},{name:"is_encoder_decoder",val:" = True"},{name:"add_router_probs",val:" = False"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SwitchTransformersConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32128) &#x2014;
Vocabulary size of the SwitchTransformers model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a>.`,name:"vocab_size"},{anchor:"transformers.SwitchTransformersConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Size of the encoder layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.SwitchTransformersConfig.d_kv",description:`<strong>d_kv</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the key, query, value projections per attention head. <code>d_kv</code> has to be equal to <code>d_model // num_heads</code>.`,name:"d_kv"},{anchor:"transformers.SwitchTransformersConfig.d_ff",description:`<strong>d_ff</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Size of the intermediate feed forward layer in each <code>SwitchTransformersBlock</code>.`,name:"d_ff"},{anchor:"transformers.SwitchTransformersConfig.expert_capacity",description:`<strong>expert_capacity</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of tokens that can be stored in each expert. If set to 1, the model will behave like a regular
Transformer.`,name:"expert_capacity"},{anchor:"transformers.SwitchTransformersConfig.num_layers",description:`<strong>num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of dense hidden layers in the Transformer encoder layer.`,name:"num_layers"},{anchor:"transformers.SwitchTransformersConfig.num_sparse_encoder_layers",description:`<strong>num_sparse_encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of sparse (MoE) dense hidden layers in the Transformer encoder layer.`,name:"num_sparse_encoder_layers"},{anchor:"transformers.SwitchTransformersConfig.num_decoder_layers",description:`<strong>num_decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer decoder. Will use the same value as <code>num_layers</code> if not set.`,name:"num_decoder_layers"},{anchor:"transformers.SwitchTransformersConfig.num_sparse_decoder_layers",description:`<strong>num_sparse_decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of sparse (MoE) dense hidden layers in the Transformer decoder layer.`,name:"num_sparse_decoder_layers"},{anchor:"transformers.SwitchTransformersConfig.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.SwitchTransformersConfig.num_experts",description:`<strong>num_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of experts for each SwitchTransformer layer.`,name:"num_experts"},{anchor:"transformers.SwitchTransformersConfig.router_type",description:"<strong>router_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;tokens_masked&quot;</code>) &#x2014;\nRouter type - choose between <code>&quot;tokens_masked&quot;, </code>&#x201C;tokens_scatter&#x201D;<code>and</code>&#x201C;experts_masked&#x201D;`.",name:"router_type"},{anchor:"transformers.SwitchTransformersConfig.router_bias",description:`<strong>router_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the router.`,name:"router_bias"},{anchor:"transformers.SwitchTransformersConfig.router_jitter_noise",description:`<strong>router_jitter_noise</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Amount of noise to add to the router.`,name:"router_jitter_noise"},{anchor:"transformers.SwitchTransformersConfig.router_dtype",description:`<strong>router_dtype</strong> (<code>str</code>, <em>optional</em>, default to <code>&quot;float32&quot;</code>) &#x2014;
The <code>dtype</code> used for the routers. It is preferable to keep the <code>dtype</code> to <code>&quot;float32&quot;</code> as specified in the
<em>selective precision</em> discussion in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">the paper</a>.`,name:"router_dtype"},{anchor:"transformers.SwitchTransformersConfig.router_ignore_padding_tokens",description:`<strong>router_ignore_padding_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to ignore padding tokens when routing.`,name:"router_ignore_padding_tokens"},{anchor:"transformers.SwitchTransformersConfig.relative_attention_num_buckets",description:`<strong>relative_attention_num_buckets</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of buckets to use for each attention layer.`,name:"relative_attention_num_buckets"},{anchor:"transformers.SwitchTransformersConfig.relative_attention_max_distance",description:`<strong>relative_attention_max_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The maximum distance of the longer sequences for the bucket separation.`,name:"relative_attention_max_distance"},{anchor:"transformers.SwitchTransformersConfig.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The ratio for all dropout layers.`,name:"dropout_rate"},{anchor:"transformers.SwitchTransformersConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SwitchTransformersConfig.router_z_loss_coef",description:`<strong>router_z_loss_coef</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
The z loss factor for the total loss.`,name:"router_z_loss_coef"},{anchor:"transformers.SwitchTransformersConfig.router_aux_loss_coef",description:`<strong>router_aux_loss_coef</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
The aux loss factor for the total loss.`,name:"router_aux_loss_coef"},{anchor:"transformers.SwitchTransformersConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.SwitchTransformersConfig.feed_forward_proj",description:`<strong>feed_forward_proj</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
Type of feed forward layer to be used. Should be one of <code>&quot;relu&quot;</code> or <code>&quot;gated-gelu&quot;</code>. SwitchTransformersv1.1
uses the <code>&quot;gated-gelu&quot;</code> feed forward projection. Original SwitchTransformers uses <code>&quot;relu&quot;</code>.`,name:"feed_forward_proj"},{anchor:"transformers.SwitchTransformersConfig.add_router_probs",description:`<strong>add_router_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to output router probabilities to compute router auxiliary loss.`,name:"add_router_probs"},{anchor:"transformers.SwitchTransformersConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/configuration_switch_transformers.py#L27"}}),ze=new D({}),Fe=new R({props:{name:"class transformers.SwitchTransformersTop1Router",anchor:"transformers.SwitchTransformersTop1Router",parameters:[{name:"config",val:": SwitchTransformersConfig"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L131"}}),je=new R({props:{name:"_compute_router_probabilities",anchor:"transformers.SwitchTransformersTop1Router._compute_router_probabilities",parameters:[{name:"hidden_states",val:": Tensor"}],parametersDescription:[{anchor:"transformers.SwitchTransformersTop1Router._compute_router_probabilities.hidden_states",description:`<strong>hidden_states</strong> (<code>torch.Tensor</code>) &#x2014;
(batch_size, sequence_length, hidden_dim) from which router probabilities are computed.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L151",returnDescription:`
<p>Tensor of shape (batch_size, sequence_length, num_experts) corresponding to the probabilities for each
token and expert. Used for routing tokens to experts.
router_logits (<code>torch.Tensor</code>):
Logits tensor of shape (batch_size, sequence_length, num_experts) corresponding to raw router logits.
This is used later for computing router z-loss.</p>
`,returnType:`
<p>router_probabilities (<code>torch.Tensor</code>)</p>
`}}),He=new R({props:{name:"forward",anchor:"transformers.SwitchTransformersTop1Router.forward",parameters:[{name:"hidden_states",val:": Tensor"}],parametersDescription:[{anchor:"transformers.SwitchTransformersTop1Router.forward.hidden_states",description:`<strong>hidden_states</strong> (<code>torch.Tensor</code>)  &#x2014;
[num_groups, tokens_per_group, hidden_dim] inputs to send to experts.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L201",returnDescription:`
<p>Tuple[<code>torch.Tensor</code>, <code>torch.Tensor</code>, <code>torch.Tensor</code>] Tuple containing the expert index, the router probs
and the router logits. The router probabilities and logits are required to compute the loss.</p>
`}}),Ue=new D({}),Je=new R({props:{name:"class transformers.SwitchTransformersSparseMLP",anchor:"transformers.SwitchTransformersSparseMLP",parameters:[{name:"config",val:": SwitchTransformersConfig"},{name:"expert_class",val:": Module = <class 'transformers.models.switch_transformers.modeling_switch_transformers.SwitchTransformersDenseActDense'>"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L285"}}),Ee=new R({props:{name:"forward",anchor:"transformers.SwitchTransformersSparseMLP.forward",parameters:[{name:"hidden_states",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L300"}}),Ie=new D({}),Re=new R({props:{name:"class transformers.SwitchTransformersModel",anchor:"transformers.SwitchTransformersModel",parameters:[{name:"config",val:": SwitchTransformersConfig"}],parametersDescription:[{anchor:"transformers.SwitchTransformersModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1310"}}),qe=new R({props:{name:"forward",anchor:"transformers.SwitchTransformersModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwitchTransformersModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. SWITCH_TRANSFORMERS is a model with relative position
embeddings so you should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"input_ids"},{anchor:"transformers.SwitchTransformersModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>SWITCH_TRANSFORMERS uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.SwitchTransformersModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.SwitchTransformersModel.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.SwitchTransformersModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.SwitchTransformersModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SwitchTransformersModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.SwitchTransformersModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.SwitchTransformersModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwitchTransformersModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwitchTransformersModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.SwitchTransformersModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1356",returnDescription:`
<p>A <code>transformers.modeling_outputs.Seq2SeqMoEModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig"
>SwitchTransformersConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>decoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the decoder model, useful to compute the auxiliary loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>encoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the encoder model, useful to compute the auxiliary loss and the z_loss for the sparse
modules.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_outputs.Seq2SeqMoEModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new Tn({props:{$$slots:{default:[zr]},$$scope:{ctx:z}}}),se=new wn({props:{anchor:"transformers.SwitchTransformersModel.forward.example",$$slots:{default:[Fr]},$$scope:{ctx:z}}}),Ze=new D({}),Ne=new R({props:{name:"class transformers.SwitchTransformersForConditionalGeneration",anchor:"transformers.SwitchTransformersForConditionalGeneration",parameters:[{name:"config",val:": SwitchTransformersConfig"}],parametersDescription:[{anchor:"transformers.SwitchTransformersForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1478"}}),We=new R({props:{name:"forward",anchor:"transformers.SwitchTransformersForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. SWITCH_TRANSFORMERS is a model with relative position
embeddings so you should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"input_ids"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>SWITCH_TRANSFORMERS uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1530",returnDescription:`
<p>A <code>transformers.modeling_outputs.Seq2SeqMoEOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig"
>SwitchTransformersConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>decoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the decoder model, useful to compute the auxiliary loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>encoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the encoder model, useful to compute the auxiliary loss and z_loss for Mixture of Experts
models.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_outputs.Seq2SeqMoEOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new Tn({props:{$$slots:{default:[jr]},$$scope:{ctx:z}}}),de=new wn({props:{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.example",$$slots:{default:[Hr]},$$scope:{ctx:z}}}),Ge=new D({}),Pe=new R({props:{name:"class transformers.SwitchTransformersEncoderModel",anchor:"transformers.SwitchTransformersEncoderModel",parameters:[{name:"config",val:": SwitchTransformersConfig"}],parametersDescription:[{anchor:"transformers.SwitchTransformersEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1786"}}),Le=new R({props:{name:"forward",anchor:"transformers.SwitchTransformersEncoderModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwitchTransformersEncoderModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. SWITCH_TRANSFORMERS is a model with relative position
embeddings so you should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"input_ids"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1822",returnDescription:`
<p>A <code>transformers.modeling_outputs.MoEModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig"
>SwitchTransformersConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>router_probs</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_probs=True</code> and <code>config.add_router_probs=True</code> is passed or when <code>config.output_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Raw router probabilities that are computed by MoE routers, these terms are used to compute the auxiliary
loss and the z_loss for Mixture of Experts models.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_outputs.MoEModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ce=new Tn({props:{$$slots:{default:[Ur]},$$scope:{ctx:z}}}),he=new wn({props:{anchor:"transformers.SwitchTransformersEncoderModel.forward.example",$$slots:{default:[Jr]},$$scope:{ctx:z}}}),{c(){l=n("meta"),M=s(),u=n("p"),f=s(),b=n("h1"),c=n("a"),k=n("span"),_(_e.$$.fragment),ko=s(),Ve=n("span"),Ve.textContent=yn,Bt=s(),G=n("h2"),Y=n("a"),Ht=n("span"),_(ge.$$.fragment),So=s(),Xe=n("span"),Xe.textContent=bn,At=s(),Te=n("p"),Te.innerHTML=Mn,Vt=s(),we=n("p"),we.textContent=kn,Xt=s(),ve=n("p"),ve.textContent=Sn,Ot=s(),ye=n("p"),ye.innerHTML=xn,Dt=s(),be=n("p"),be.textContent=Cn,Yt=s(),Me=n("ul"),Me.innerHTML=$n,Qt=s(),ke=n("p"),ke.innerHTML=zn,Kt=s(),P=n("h2"),Q=n("a"),Ut=n("span"),_(Se.$$.fragment),xo=s(),Oe=n("span"),Oe.textContent=Fn,eo=s(),xe=n("ul"),xe.innerHTML=jn,to=s(),L=n("h2"),K=n("a"),Jt=n("span"),_(Ce.$$.fragment),Co=s(),De=n("span"),De.textContent=Hn,oo=s(),q=n("div"),_($e.$$.fragment),$o=s(),Ye=n("p"),Ye.innerHTML=Un,zo=s(),Qe=n("p"),Qe.innerHTML=Jn,no=s(),B=n("h2"),ee=n("a"),Et=n("span"),_(ze.$$.fragment),Fo=s(),Ke=n("span"),Ke.textContent=En,ro=s(),$=n("div"),_(Fe.$$.fragment),jo=s(),et=n("p"),et.textContent=In,Ho=s(),tt=n("p"),tt.innerHTML=Rn,Uo=s(),te=n("div"),_(je.$$.fragment),Jo=s(),ot=n("p"),ot.textContent=qn,Eo=s(),N=n("div"),_(He.$$.fragment),Io=s(),nt=n("p"),nt.innerHTML=Zn,Ro=s(),rt=n("p"),rt.innerHTML=Nn,so=s(),A=n("h2"),oe=n("a"),It=n("span"),_(Ue.$$.fragment),qo=s(),st=n("span"),st.textContent=Wn,ao=s(),Z=n("div"),_(Je.$$.fragment),Zo=s(),at=n("p"),at.textContent=Gn,No=s(),F=n("div"),_(Ee.$$.fragment),Wo=s(),it=n("p"),it.textContent=Pn,Go=s(),dt=n("p"),dt.innerHTML=Ln,Po=s(),lt=n("p"),lt.textContent=Bn,io=s(),V=n("h2"),ne=n("a"),Rt=n("span"),_(Ie.$$.fragment),Lo=s(),ct=n("span"),ct.textContent=An,lo=s(),S=n("div"),_(Re.$$.fragment),Bo=s(),ht=n("p"),ht.textContent=Vn,Ao=s(),pt=n("p"),pt.innerHTML=Xn,Vo=s(),mt=n("p"),mt.innerHTML=On,Xo=s(),ut=n("p"),ut.innerHTML=Dn,Oo=s(),j=n("div"),_(qe.$$.fragment),Do=s(),ft=n("p"),ft.innerHTML=Yn,Yo=s(),_(re.$$.fragment),Qo=s(),_(se.$$.fragment),co=s(),X=n("h2"),ae=n("a"),qt=n("span"),_(Ze.$$.fragment),Ko=s(),_t=n("span"),_t.textContent=Qn,ho=s(),x=n("div"),_(Ne.$$.fragment),en=s(),gt=n("p"),gt.innerHTML=Kn,tn=s(),Tt=n("p"),Tt.innerHTML=er,on=s(),wt=n("p"),wt.innerHTML=tr,nn=s(),vt=n("p"),vt.innerHTML=or,rn=s(),H=n("div"),_(We.$$.fragment),sn=s(),yt=n("p"),yt.innerHTML=nr,an=s(),_(ie.$$.fragment),dn=s(),_(de.$$.fragment),po=s(),O=n("h2"),le=n("a"),Zt=n("span"),_(Ge.$$.fragment),ln=s(),bt=n("span"),bt.textContent=rr,mo=s(),C=n("div"),_(Pe.$$.fragment),cn=s(),Mt=n("p"),Mt.textContent=sr,hn=s(),kt=n("p"),kt.innerHTML=ar,pn=s(),St=n("p"),St.innerHTML=ir,mn=s(),xt=n("p"),xt.innerHTML=dr,un=s(),U=n("div"),_(Le.$$.fragment),fn=s(),Ct=n("p"),Ct.innerHTML=lr,_n=s(),_(ce.$$.fragment),gn=s(),_(he.$$.fragment),uo=s(),Nt=n("p"),this.h()},l(e){const i=$r("svelte-1phssyn",document.head);l=r(i,"META",{name:!0,content:!0}),i.forEach(o),M=a(e),u=r(e,"P",{}),m(u).forEach(o),f=a(e),b=r(e,"H1",{class:!0});var Be=m(b);c=r(Be,"A",{id:!0,class:!0,href:!0});var Wt=m(c);k=r(Wt,"SPAN",{});var Gt=m(k);g(_e.$$.fragment,Gt),Gt.forEach(o),Wt.forEach(o),ko=a(Be),Ve=r(Be,"SPAN",{"data-svelte-h":!0}),p(Ve)!=="svelte-shfii5"&&(Ve.textContent=yn),Be.forEach(o),Bt=a(e),G=r(e,"H2",{class:!0});var Ae=m(G);Y=r(Ae,"A",{id:!0,class:!0,href:!0});var Pt=m(Y);Ht=r(Pt,"SPAN",{});var Lt=m(Ht);g(ge.$$.fragment,Lt),Lt.forEach(o),Pt.forEach(o),So=a(Ae),Xe=r(Ae,"SPAN",{"data-svelte-h":!0}),p(Xe)!=="svelte-1jsw1pg"&&(Xe.textContent=bn),Ae.forEach(o),At=a(e),Te=r(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-qxeocr"&&(Te.innerHTML=Mn),Vt=a(e),we=r(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1klyz3l"&&(we.textContent=kn),Xt=a(e),ve=r(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-vfdo9a"&&(ve.textContent=Sn),Ot=a(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-ev6w2b"&&(ye.innerHTML=xn),Dt=a(e),be=r(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-axv494"&&(be.textContent=Cn),Yt=a(e),Me=r(e,"UL",{"data-svelte-h":!0}),p(Me)!=="svelte-1hxwrlj"&&(Me.innerHTML=$n),Qt=a(e),ke=r(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-ta9wfs"&&(ke.innerHTML=zn),Kt=a(e),P=r(e,"H2",{class:!0});var _o=m(P);Q=r(_o,"A",{id:!0,class:!0,href:!0});var cr=m(Q);Ut=r(cr,"SPAN",{});var hr=m(Ut);g(Se.$$.fragment,hr),hr.forEach(o),cr.forEach(o),xo=a(_o),Oe=r(_o,"SPAN",{"data-svelte-h":!0}),p(Oe)!=="svelte-w4zzv6"&&(Oe.textContent=Fn),_o.forEach(o),eo=a(e),xe=r(e,"UL",{"data-svelte-h":!0}),p(xe)!=="svelte-6ej6p2"&&(xe.innerHTML=jn),to=a(e),L=r(e,"H2",{class:!0});var go=m(L);K=r(go,"A",{id:!0,class:!0,href:!0});var pr=m(K);Jt=r(pr,"SPAN",{});var mr=m(Jt);g(Ce.$$.fragment,mr),mr.forEach(o),pr.forEach(o),Co=a(go),De=r(go,"SPAN",{"data-svelte-h":!0}),p(De)!=="svelte-emuqx3"&&(De.textContent=Hn),go.forEach(o),oo=a(e),q=r(e,"DIV",{class:!0});var $t=m(q);g($e.$$.fragment,$t),$o=a($t),Ye=r($t,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-16j756k"&&(Ye.innerHTML=Un),zo=a($t),Qe=r($t,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-cfh5wl"&&(Qe.innerHTML=Jn),$t.forEach(o),no=a(e),B=r(e,"H2",{class:!0});var To=m(B);ee=r(To,"A",{id:!0,class:!0,href:!0});var ur=m(ee);Et=r(ur,"SPAN",{});var fr=m(Et);g(ze.$$.fragment,fr),fr.forEach(o),ur.forEach(o),Fo=a(To),Ke=r(To,"SPAN",{"data-svelte-h":!0}),p(Ke)!=="svelte-i0jrl0"&&(Ke.textContent=En),To.forEach(o),ro=a(e),$=r(e,"DIV",{class:!0});var W=m($);g(Fe.$$.fragment,W),jo=a(W),et=r(W,"P",{"data-svelte-h":!0}),p(et)!=="svelte-12fm05d"&&(et.textContent=In),Ho=a(W),tt=r(W,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-14tpjgc"&&(tt.innerHTML=Rn),Uo=a(W),te=r(W,"DIV",{class:!0});var wo=m(te);g(je.$$.fragment,wo),Jo=a(wo),ot=r(wo,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-jnjz7k"&&(ot.textContent=qn),wo.forEach(o),Eo=a(W),N=r(W,"DIV",{class:!0});var zt=m(N);g(He.$$.fragment,zt),Io=a(zt),nt=r(zt,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-wi3ols"&&(nt.innerHTML=Zn),Ro=a(zt),rt=r(zt,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-1xte4m0"&&(rt.innerHTML=Nn),zt.forEach(o),W.forEach(o),so=a(e),A=r(e,"H2",{class:!0});var vo=m(A);oe=r(vo,"A",{id:!0,class:!0,href:!0});var _r=m(oe);It=r(_r,"SPAN",{});var gr=m(It);g(Ue.$$.fragment,gr),gr.forEach(o),_r.forEach(o),qo=a(vo),st=r(vo,"SPAN",{"data-svelte-h":!0}),p(st)!=="svelte-cr3ljo"&&(st.textContent=Wn),vo.forEach(o),ao=a(e),Z=r(e,"DIV",{class:!0});var Ft=m(Z);g(Je.$$.fragment,Ft),Zo=a(Ft),at=r(Ft,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1avy50b"&&(at.textContent=Gn),No=a(Ft),F=r(Ft,"DIV",{class:!0});var pe=m(F);g(Ee.$$.fragment,pe),Wo=a(pe),it=r(pe,"P",{"data-svelte-h":!0}),p(it)!=="svelte-a1z96i"&&(it.textContent=Pn),Go=a(pe),dt=r(pe,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-1mybtpr"&&(dt.innerHTML=Ln),Po=a(pe),lt=r(pe,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1n21hyz"&&(lt.textContent=Bn),pe.forEach(o),Ft.forEach(o),io=a(e),V=r(e,"H2",{class:!0});var yo=m(V);ne=r(yo,"A",{id:!0,class:!0,href:!0});var Tr=m(ne);Rt=r(Tr,"SPAN",{});var wr=m(Rt);g(Ie.$$.fragment,wr),wr.forEach(o),Tr.forEach(o),Lo=a(yo),ct=r(yo,"SPAN",{"data-svelte-h":!0}),p(ct)!=="svelte-2esuo6"&&(ct.textContent=An),yo.forEach(o),lo=a(e),S=r(e,"DIV",{class:!0});var J=m(S);g(Re.$$.fragment,J),Bo=a(J),ht=r(J,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1r3vbx8"&&(ht.textContent=Vn),Ao=a(J),pt=r(J,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1kjq2n1"&&(pt.innerHTML=Xn),Vo=a(J),mt=r(J,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-ev63c"&&(mt.innerHTML=On),Xo=a(J),ut=r(J,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-hswkmf"&&(ut.innerHTML=Dn),Oo=a(J),j=r(J,"DIV",{class:!0});var me=m(j);g(qe.$$.fragment,me),Do=a(me),ft=r(me,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-1ctc1va"&&(ft.innerHTML=Yn),Yo=a(me),g(re.$$.fragment,me),Qo=a(me),g(se.$$.fragment,me),me.forEach(o),J.forEach(o),co=a(e),X=r(e,"H2",{class:!0});var bo=m(X);ae=r(bo,"A",{id:!0,class:!0,href:!0});var vr=m(ae);qt=r(vr,"SPAN",{});var yr=m(qt);g(Ze.$$.fragment,yr),yr.forEach(o),vr.forEach(o),Ko=a(bo),_t=r(bo,"SPAN",{"data-svelte-h":!0}),p(_t)!=="svelte-vwcsmc"&&(_t.textContent=Qn),bo.forEach(o),ho=a(e),x=r(e,"DIV",{class:!0});var E=m(x);g(Ne.$$.fragment,E),en=a(E),gt=r(E,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-yohvjb"&&(gt.innerHTML=Kn),tn=a(E),Tt=r(E,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-1kjq2n1"&&(Tt.innerHTML=er),on=a(E),wt=r(E,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-ev63c"&&(wt.innerHTML=tr),nn=a(E),vt=r(E,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-hswkmf"&&(vt.innerHTML=or),rn=a(E),H=r(E,"DIV",{class:!0});var ue=m(H);g(We.$$.fragment,ue),sn=a(ue),yt=r(ue,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-1bsemx8"&&(yt.innerHTML=nr),an=a(ue),g(ie.$$.fragment,ue),dn=a(ue),g(de.$$.fragment,ue),ue.forEach(o),E.forEach(o),po=a(e),O=r(e,"H2",{class:!0});var Mo=m(O);le=r(Mo,"A",{id:!0,class:!0,href:!0});var br=m(le);Zt=r(br,"SPAN",{});var Mr=m(Zt);g(Ge.$$.fragment,Mr),Mr.forEach(o),br.forEach(o),ln=a(Mo),bt=r(Mo,"SPAN",{"data-svelte-h":!0}),p(bt)!=="svelte-azq3ku"&&(bt.textContent=rr),Mo.forEach(o),mo=a(e),C=r(e,"DIV",{class:!0});var I=m(C);g(Pe.$$.fragment,I),cn=a(I),Mt=r(I,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1ip3xuw"&&(Mt.textContent=sr),hn=a(I),kt=r(I,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-1kjq2n1"&&(kt.innerHTML=ar),pn=a(I),St=r(I,"P",{"data-svelte-h":!0}),p(St)!=="svelte-ev63c"&&(St.innerHTML=ir),mn=a(I),xt=r(I,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-hswkmf"&&(xt.innerHTML=dr),un=a(I),U=r(I,"DIV",{class:!0});var fe=m(U);g(Le.$$.fragment,fe),fn=a(fe),Ct=r(fe,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-c8291c"&&(Ct.innerHTML=lr),_n=a(fe),g(ce.$$.fragment,fe),gn=a(fe),g(he.$$.fragment,fe),fe.forEach(o),I.forEach(o),uo=a(e),Nt=r(e,"P",{}),m(Nt).forEach(o),this.h()},h(){h(l,"name","hf:doc:metadata"),h(l,"content",JSON.stringify(Ir)),h(c,"id","switchtransformers"),h(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(c,"href","#switchtransformers"),h(b,"class","relative group"),h(Y,"id","overview"),h(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Y,"href","#overview"),h(G,"class","relative group"),h(Q,"id","resources"),h(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Q,"href","#resources"),h(P,"class","relative group"),h(K,"id","transformers.SwitchTransformersConfig"),h(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(K,"href","#transformers.SwitchTransformersConfig"),h(L,"class","relative group"),h(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ee,"id","transformers.SwitchTransformersTop1Router"),h(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ee,"href","#transformers.SwitchTransformersTop1Router"),h(B,"class","relative group"),h(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(oe,"id","transformers.SwitchTransformersSparseMLP"),h(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(oe,"href","#transformers.SwitchTransformersSparseMLP"),h(A,"class","relative group"),h(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ne,"id","transformers.SwitchTransformersModel"),h(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ne,"href","#transformers.SwitchTransformersModel"),h(V,"class","relative group"),h(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(ae,"id","transformers.SwitchTransformersForConditionalGeneration"),h(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(ae,"href","#transformers.SwitchTransformersForConditionalGeneration"),h(X,"class","relative group"),h(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(le,"id","transformers.SwitchTransformersEncoderModel"),h(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(le,"href","#transformers.SwitchTransformersEncoderModel"),h(O,"class","relative group"),h(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,l),d(e,M,i),d(e,u,i),d(e,f,i),d(e,b,i),t(b,c),t(c,k),T(_e,k,null),t(b,ko),t(b,Ve),d(e,Bt,i),d(e,G,i),t(G,Y),t(Y,Ht),T(ge,Ht,null),t(G,So),t(G,Xe),d(e,At,i),d(e,Te,i),d(e,Vt,i),d(e,we,i),d(e,Xt,i),d(e,ve,i),d(e,Ot,i),d(e,ye,i),d(e,Dt,i),d(e,be,i),d(e,Yt,i),d(e,Me,i),d(e,Qt,i),d(e,ke,i),d(e,Kt,i),d(e,P,i),t(P,Q),t(Q,Ut),T(Se,Ut,null),t(P,xo),t(P,Oe),d(e,eo,i),d(e,xe,i),d(e,to,i),d(e,L,i),t(L,K),t(K,Jt),T(Ce,Jt,null),t(L,Co),t(L,De),d(e,oo,i),d(e,q,i),T($e,q,null),t(q,$o),t(q,Ye),t(q,zo),t(q,Qe),d(e,no,i),d(e,B,i),t(B,ee),t(ee,Et),T(ze,Et,null),t(B,Fo),t(B,Ke),d(e,ro,i),d(e,$,i),T(Fe,$,null),t($,jo),t($,et),t($,Ho),t($,tt),t($,Uo),t($,te),T(je,te,null),t(te,Jo),t(te,ot),t($,Eo),t($,N),T(He,N,null),t(N,Io),t(N,nt),t(N,Ro),t(N,rt),d(e,so,i),d(e,A,i),t(A,oe),t(oe,It),T(Ue,It,null),t(A,qo),t(A,st),d(e,ao,i),d(e,Z,i),T(Je,Z,null),t(Z,Zo),t(Z,at),t(Z,No),t(Z,F),T(Ee,F,null),t(F,Wo),t(F,it),t(F,Go),t(F,dt),t(F,Po),t(F,lt),d(e,io,i),d(e,V,i),t(V,ne),t(ne,Rt),T(Ie,Rt,null),t(V,Lo),t(V,ct),d(e,lo,i),d(e,S,i),T(Re,S,null),t(S,Bo),t(S,ht),t(S,Ao),t(S,pt),t(S,Vo),t(S,mt),t(S,Xo),t(S,ut),t(S,Oo),t(S,j),T(qe,j,null),t(j,Do),t(j,ft),t(j,Yo),T(re,j,null),t(j,Qo),T(se,j,null),d(e,co,i),d(e,X,i),t(X,ae),t(ae,qt),T(Ze,qt,null),t(X,Ko),t(X,_t),d(e,ho,i),d(e,x,i),T(Ne,x,null),t(x,en),t(x,gt),t(x,tn),t(x,Tt),t(x,on),t(x,wt),t(x,nn),t(x,vt),t(x,rn),t(x,H),T(We,H,null),t(H,sn),t(H,yt),t(H,an),T(ie,H,null),t(H,dn),T(de,H,null),d(e,po,i),d(e,O,i),t(O,le),t(le,Zt),T(Ge,Zt,null),t(O,ln),t(O,bt),d(e,mo,i),d(e,C,i),T(Pe,C,null),t(C,cn),t(C,Mt),t(C,hn),t(C,kt),t(C,pn),t(C,St),t(C,mn),t(C,xt),t(C,un),t(C,U),T(Le,U,null),t(U,fn),t(U,Ct),t(U,_n),T(ce,U,null),t(U,gn),T(he,U,null),d(e,uo,i),d(e,Nt,i),fo=!0},p(e,[i]){const Be={};i&2&&(Be.$$scope={dirty:i,ctx:e}),re.$set(Be);const Wt={};i&2&&(Wt.$$scope={dirty:i,ctx:e}),se.$set(Wt);const Gt={};i&2&&(Gt.$$scope={dirty:i,ctx:e}),ie.$set(Gt);const Ae={};i&2&&(Ae.$$scope={dirty:i,ctx:e}),de.$set(Ae);const Pt={};i&2&&(Pt.$$scope={dirty:i,ctx:e}),ce.$set(Pt);const Lt={};i&2&&(Lt.$$scope={dirty:i,ctx:e}),he.$set(Lt)},i(e){fo||(w(_e.$$.fragment,e),w(ge.$$.fragment,e),w(Se.$$.fragment,e),w(Ce.$$.fragment,e),w($e.$$.fragment,e),w(ze.$$.fragment,e),w(Fe.$$.fragment,e),w(je.$$.fragment,e),w(He.$$.fragment,e),w(Ue.$$.fragment,e),w(Je.$$.fragment,e),w(Ee.$$.fragment,e),w(Ie.$$.fragment,e),w(Re.$$.fragment,e),w(qe.$$.fragment,e),w(re.$$.fragment,e),w(se.$$.fragment,e),w(Ze.$$.fragment,e),w(Ne.$$.fragment,e),w(We.$$.fragment,e),w(ie.$$.fragment,e),w(de.$$.fragment,e),w(Ge.$$.fragment,e),w(Pe.$$.fragment,e),w(Le.$$.fragment,e),w(ce.$$.fragment,e),w(he.$$.fragment,e),fo=!0)},o(e){v(_e.$$.fragment,e),v(ge.$$.fragment,e),v(Se.$$.fragment,e),v(Ce.$$.fragment,e),v($e.$$.fragment,e),v(ze.$$.fragment,e),v(Fe.$$.fragment,e),v(je.$$.fragment,e),v(He.$$.fragment,e),v(Ue.$$.fragment,e),v(Je.$$.fragment,e),v(Ee.$$.fragment,e),v(Ie.$$.fragment,e),v(Re.$$.fragment,e),v(qe.$$.fragment,e),v(re.$$.fragment,e),v(se.$$.fragment,e),v(Ze.$$.fragment,e),v(Ne.$$.fragment,e),v(We.$$.fragment,e),v(ie.$$.fragment,e),v(de.$$.fragment,e),v(Ge.$$.fragment,e),v(Pe.$$.fragment,e),v(Le.$$.fragment,e),v(ce.$$.fragment,e),v(he.$$.fragment,e),fo=!1},d(e){e&&(o(M),o(u),o(f),o(b),o(Bt),o(G),o(At),o(Te),o(Vt),o(we),o(Xt),o(ve),o(Ot),o(ye),o(Dt),o(be),o(Yt),o(Me),o(Qt),o(ke),o(Kt),o(P),o(eo),o(xe),o(to),o(L),o(oo),o(q),o(no),o(B),o(ro),o($),o(so),o(A),o(ao),o(Z),o(io),o(V),o(lo),o(S),o(co),o(X),o(ho),o(x),o(po),o(O),o(mo),o(C),o(uo),o(Nt)),o(l),y(_e),y(ge),y(Se),y(Ce),y($e),y(ze),y(Fe),y(je),y(He),y(Ue),y(Je),y(Ee),y(Ie),y(Re),y(qe),y(re),y(se),y(Ze),y(Ne),y(We),y(ie),y(de),y(Ge),y(Pe),y(Le),y(ce),y(he)}}}const Ir={local:"switchtransformers",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.SwitchTransformersConfig",title:"SwitchTransformersConfig"},{local:"transformers.SwitchTransformersTop1Router",title:"SwitchTransformersTop1Router"},{local:"transformers.SwitchTransformersSparseMLP",title:"SwitchTransformersSparseMLP"},{local:"transformers.SwitchTransformersModel",title:"SwitchTransformersModel"},{local:"transformers.SwitchTransformersForConditionalGeneration",title:"SwitchTransformersForConditionalGeneration"},{local:"transformers.SwitchTransformersEncoderModel",title:"SwitchTransformersEncoderModel"}],title:"SwitchTransformers"};function Rr(z){return Sr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Br extends xr{constructor(l){super(),Cr(this,l,Rr,Er,kr,{})}}export{Br as component};
