import{s as Is,n as Zs,o as xs}from"../chunks/scheduler.85c25b89.js";import{S as Ws,i as Ns,g as p,s as e,r as m,A as Gs,h as i,f as l,c as n,j as $s,u as o,x as c,k as Cs,y as Bs,a,v as r,d as h,t as M,w as j}from"../chunks/index.c9bcf812.js";import{C as X}from"../chunks/CodeBlock.94efc595.js";import{H as R}from"../chunks/Heading.3c6e5b17.js";function ks(Ms){let g,Y,Q,A,d,H,w,js='<strong>Xception</strong> is a convolutional neural network architecture that relies solely on <a href="https://paperswithcode.com/method/depthwise-separable-convolution" rel="nofollow">depthwise separable convolution layers</a>.',S,J,gs='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',z,y,F,T,ds="To load a pretrained model:",L,u,D,f,ws="To load and preprocess the image:",P,b,q,U,Js="To get the model predictions:",K,$,O,C,ys="To get the top-5 predictions class names:",ss,I,ts,Z,Ts="Replace the model name with the variant you want to use, e.g. <code>xception</code>. You can find the IDs in the model summaries at the top of this page.",ls,x,us='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,W,es,N,fs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ns,G,ps,B,bs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,is,k,ms,v,Us='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',os,E,cs,_,rs,V,hs;return d=new R({props:{title:"Xception",local:"xception",headingTag:"h1"}}),y=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3hjZXB0aW9uJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;xception&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgneGNlcHRpb24nJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;xception&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),k=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),_=new X({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZaYWdvcnV5a29LMTYlMkMlMEElNDBtaXNjJTdCY2hvbGxldDIwMTd4Y2VwdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCWGNlcHRpb24lM0ElMjBEZWVwJTIwTGVhcm5pbmclMjB3aXRoJTIwRGVwdGh3aXNlJTIwU2VwYXJhYmxlJTIwQ29udm9sdXRpb25zJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRnJhbiVDMyVBN29pcyUyMENob2xsZXQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE2MTAuMDIzNTclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="hljs-variable">@article</span>{<span class="hljs-variable constant_">DBLP</span><span class="hljs-symbol">:journals/corr/ZagoruykoK16</span>,
<span class="hljs-variable">@misc</span>{chollet2017xception,
      title={<span class="hljs-title class_">Xception</span>: <span class="hljs-title class_">Deep</span> <span class="hljs-title class_">Learning</span> with <span class="hljs-title class_">Depthwise</span> <span class="hljs-title class_">Separable</span> <span class="hljs-title class_">Convolutions</span>}, 
      author={<span class="hljs-title class_">Fran</span>çois <span class="hljs-title class_">Chollet</span>},
      year={<span class="hljs-number">2017</span>},
      eprint={<span class="hljs-number">1610.02357</span>},
      archivePrefix={arXiv},
      primaryClass={cs.<span class="hljs-variable constant_">CV</span>}
}`,wrap:!1}}),{c(){g=p("meta"),Y=e(),Q=p("p"),A=e(),m(d.$$.fragment),H=e(),w=p("p"),w.innerHTML=js,S=e(),J=p("p"),J.innerHTML=gs,z=e(),m(y.$$.fragment),F=e(),T=p("p"),T.textContent=ds,L=e(),m(u.$$.fragment),D=e(),f=p("p"),f.textContent=ws,P=e(),m(b.$$.fragment),q=e(),U=p("p"),U.textContent=Js,K=e(),m($.$$.fragment),O=e(),C=p("p"),C.textContent=ys,ss=e(),m(I.$$.fragment),ts=e(),Z=p("p"),Z.innerHTML=Ts,ls=e(),x=p("p"),x.innerHTML=us,as=e(),m(W.$$.fragment),es=e(),N=p("p"),N.textContent=fs,ns=e(),m(G.$$.fragment),ps=e(),B=p("p"),B.innerHTML=bs,is=e(),m(k.$$.fragment),ms=e(),v=p("p"),v.innerHTML=Us,os=e(),m(E.$$.fragment),cs=e(),m(_.$$.fragment),rs=e(),V=p("p"),this.h()},l(s){const t=Gs("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(l),Y=n(s),Q=i(s,"P",{}),$s(Q).forEach(l),A=n(s),o(d.$$.fragment,s),H=n(s),w=i(s,"P",{"data-svelte-h":!0}),c(w)!=="svelte-s14d2h"&&(w.innerHTML=js),S=n(s),J=i(s,"P",{"data-svelte-h":!0}),c(J)!=="svelte-1nh6o5x"&&(J.innerHTML=gs),z=n(s),o(y.$$.fragment,s),F=n(s),T=i(s,"P",{"data-svelte-h":!0}),c(T)!=="svelte-18ywhxh"&&(T.textContent=ds),L=n(s),o(u.$$.fragment,s),D=n(s),f=i(s,"P",{"data-svelte-h":!0}),c(f)!=="svelte-1c2ipa8"&&(f.textContent=ws),P=n(s),o(b.$$.fragment,s),q=n(s),U=i(s,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1n9qsq1"&&(U.textContent=Js),K=n(s),o($.$$.fragment,s),O=n(s),C=i(s,"P",{"data-svelte-h":!0}),c(C)!=="svelte-19cnvx1"&&(C.textContent=ys),ss=n(s),o(I.$$.fragment,s),ts=n(s),Z=i(s,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-11ggpx2"&&(Z.innerHTML=Ts),ls=n(s),x=i(s,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1wmi3ea"&&(x.innerHTML=us),as=n(s),o(W.$$.fragment,s),es=n(s),N=i(s,"P",{"data-svelte-h":!0}),c(N)!=="svelte-9sr7nh"&&(N.textContent=fs),ns=n(s),o(G.$$.fragment,s),ps=n(s),B=i(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1kguc51"&&(B.innerHTML=bs),is=n(s),o(k.$$.fragment,s),ms=n(s),v=i(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1n0coha"&&(v.innerHTML=Us),os=n(s),o(E.$$.fragment,s),cs=n(s),o(_.$$.fragment,s),rs=n(s),V=i(s,"P",{}),$s(V).forEach(l),this.h()},h(){Cs(g,"name","hf:doc:metadata"),Cs(g,"content",vs)},m(s,t){Bs(document.head,g),a(s,Y,t),a(s,Q,t),a(s,A,t),r(d,s,t),a(s,H,t),a(s,w,t),a(s,S,t),a(s,J,t),a(s,z,t),r(y,s,t),a(s,F,t),a(s,T,t),a(s,L,t),r(u,s,t),a(s,D,t),a(s,f,t),a(s,P,t),r(b,s,t),a(s,q,t),a(s,U,t),a(s,K,t),r($,s,t),a(s,O,t),a(s,C,t),a(s,ss,t),r(I,s,t),a(s,ts,t),a(s,Z,t),a(s,ls,t),a(s,x,t),a(s,as,t),r(W,s,t),a(s,es,t),a(s,N,t),a(s,ns,t),r(G,s,t),a(s,ps,t),a(s,B,t),a(s,is,t),r(k,s,t),a(s,ms,t),a(s,v,t),a(s,os,t),r(E,s,t),a(s,cs,t),r(_,s,t),a(s,rs,t),a(s,V,t),hs=!0},p:Zs,i(s){hs||(h(d.$$.fragment,s),h(y.$$.fragment,s),h(u.$$.fragment,s),h(b.$$.fragment,s),h($.$$.fragment,s),h(I.$$.fragment,s),h(W.$$.fragment,s),h(G.$$.fragment,s),h(k.$$.fragment,s),h(E.$$.fragment,s),h(_.$$.fragment,s),hs=!0)},o(s){M(d.$$.fragment,s),M(y.$$.fragment,s),M(u.$$.fragment,s),M(b.$$.fragment,s),M($.$$.fragment,s),M(I.$$.fragment,s),M(W.$$.fragment,s),M(G.$$.fragment,s),M(k.$$.fragment,s),M(E.$$.fragment,s),M(_.$$.fragment,s),hs=!1},d(s){s&&(l(Y),l(Q),l(A),l(H),l(w),l(S),l(J),l(z),l(F),l(T),l(L),l(D),l(f),l(P),l(q),l(U),l(K),l(O),l(C),l(ss),l(ts),l(Z),l(ls),l(x),l(as),l(es),l(N),l(ns),l(ps),l(B),l(is),l(ms),l(v),l(os),l(cs),l(rs),l(V)),l(g),j(d,s),j(y,s),j(u,s),j(b,s),j($,s),j(I,s),j(W,s),j(G,s),j(k,s),j(E,s),j(_,s)}}}const vs='{"title":"Xception","local":"xception","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Es(Ms){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends Ws{constructor(g){super(),Ns(this,g,Es,ks,Is,{})}}export{Rs as component};
