import{s as $t,n as Wt,o as Zt}from"../chunks/scheduler.85c25b89.js";import{S as kt,i as Gt,g as p,s as a,r as i,A as xt,h as m,f as e,c as n,j as It,u as o,x as c,k as Ct,y as Bt,a as l,v as r,d as h,t as M,w as d}from"../chunks/index.c9bcf812.js";import{C as V}from"../chunks/CodeBlock.94efc595.js";import{H as R}from"../chunks/Heading.3c6e5b17.js";function Nt(Mt){let y,S,_,Y,g,H,w,dt='A <strong>SENet</strong> is a convolutional neural network architecture that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',z,J,yt='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',F,j,A,u,gt="To load a pretrained model:",L,T,q,f,wt="To load and preprocess the image:",D,b,P,U,Jt="To get the model predictions:",K,I,O,C,jt="To get the top-5 predictions class names:",tt,$,st,W,ut="Replace the model name with the variant you want to use, e.g. <code>gluon_senet154</code>. You can find the IDs in the model summaries at the top of this page.",et,Z,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,k,at,G,ft="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",nt,x,pt,B,bt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,N,it,E,Ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ot,Q,ct,v,rt,X,ht;return g=new R({props:{title:"(Gluon) SENet",local:"gluon-senet",headingTag:"h1"}}),j=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3NlbmV0MTU0JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_senet154&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),x=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25fc2VuZXQxNTQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_senet154&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new V({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){y=p("meta"),S=a(),_=p("p"),Y=a(),i(g.$$.fragment),H=a(),w=p("p"),w.innerHTML=dt,z=a(),J=p("p"),J.innerHTML=yt,F=a(),i(j.$$.fragment),A=a(),u=p("p"),u.textContent=gt,L=a(),i(T.$$.fragment),q=a(),f=p("p"),f.textContent=wt,D=a(),i(b.$$.fragment),P=a(),U=p("p"),U.textContent=Jt,K=a(),i(I.$$.fragment),O=a(),C=p("p"),C.textContent=jt,tt=a(),i($.$$.fragment),st=a(),W=p("p"),W.innerHTML=ut,et=a(),Z=p("p"),Z.innerHTML=Tt,lt=a(),i(k.$$.fragment),at=a(),G=p("p"),G.textContent=ft,nt=a(),i(x.$$.fragment),pt=a(),B=p("p"),B.innerHTML=bt,mt=a(),i(N.$$.fragment),it=a(),E=p("p"),E.innerHTML=Ut,ot=a(),i(Q.$$.fragment),ct=a(),i(v.$$.fragment),rt=a(),X=p("p"),this.h()},l(t){const s=xt("svelte-u9bgzb",document.head);y=m(s,"META",{name:!0,content:!0}),s.forEach(e),S=n(t),_=m(t,"P",{}),It(_).forEach(e),Y=n(t),o(g.$$.fragment,t),H=n(t),w=m(t,"P",{"data-svelte-h":!0}),c(w)!=="svelte-71ax7y"&&(w.innerHTML=dt),z=n(t),J=m(t,"P",{"data-svelte-h":!0}),c(J)!=="svelte-1vag5uc"&&(J.innerHTML=yt),F=n(t),o(j.$$.fragment,t),A=n(t),u=m(t,"P",{"data-svelte-h":!0}),c(u)!=="svelte-18ywhxh"&&(u.textContent=gt),L=n(t),o(T.$$.fragment,t),q=n(t),f=m(t,"P",{"data-svelte-h":!0}),c(f)!=="svelte-1c2ipa8"&&(f.textContent=wt),D=n(t),o(b.$$.fragment,t),P=n(t),U=m(t,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1n9qsq1"&&(U.textContent=Jt),K=n(t),o(I.$$.fragment,t),O=n(t),C=m(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-19cnvx1"&&(C.textContent=jt),tt=n(t),o($.$$.fragment,t),st=n(t),W=m(t,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1w6f7ut"&&(W.innerHTML=ut),et=n(t),Z=m(t,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=Tt),lt=n(t),o(k.$$.fragment,t),at=n(t),G=m(t,"P",{"data-svelte-h":!0}),c(G)!=="svelte-9sr7nh"&&(G.textContent=ft),nt=n(t),o(x.$$.fragment,t),pt=n(t),B=m(t,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1kguc51"&&(B.innerHTML=bt),mt=n(t),o(N.$$.fragment,t),it=n(t),E=m(t,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1n0coha"&&(E.innerHTML=Ut),ot=n(t),o(Q.$$.fragment,t),ct=n(t),o(v.$$.fragment,t),rt=n(t),X=m(t,"P",{}),It(X).forEach(e),this.h()},h(){Ct(y,"name","hf:doc:metadata"),Ct(y,"content",Et)},m(t,s){Bt(document.head,y),l(t,S,s),l(t,_,s),l(t,Y,s),r(g,t,s),l(t,H,s),l(t,w,s),l(t,z,s),l(t,J,s),l(t,F,s),r(j,t,s),l(t,A,s),l(t,u,s),l(t,L,s),r(T,t,s),l(t,q,s),l(t,f,s),l(t,D,s),r(b,t,s),l(t,P,s),l(t,U,s),l(t,K,s),r(I,t,s),l(t,O,s),l(t,C,s),l(t,tt,s),r($,t,s),l(t,st,s),l(t,W,s),l(t,et,s),l(t,Z,s),l(t,lt,s),r(k,t,s),l(t,at,s),l(t,G,s),l(t,nt,s),r(x,t,s),l(t,pt,s),l(t,B,s),l(t,mt,s),r(N,t,s),l(t,it,s),l(t,E,s),l(t,ot,s),r(Q,t,s),l(t,ct,s),r(v,t,s),l(t,rt,s),l(t,X,s),ht=!0},p:Wt,i(t){ht||(h(g.$$.fragment,t),h(j.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h(I.$$.fragment,t),h($.$$.fragment,t),h(k.$$.fragment,t),h(x.$$.fragment,t),h(N.$$.fragment,t),h(Q.$$.fragment,t),h(v.$$.fragment,t),ht=!0)},o(t){M(g.$$.fragment,t),M(j.$$.fragment,t),M(T.$$.fragment,t),M(b.$$.fragment,t),M(I.$$.fragment,t),M($.$$.fragment,t),M(k.$$.fragment,t),M(x.$$.fragment,t),M(N.$$.fragment,t),M(Q.$$.fragment,t),M(v.$$.fragment,t),ht=!1},d(t){t&&(e(S),e(_),e(Y),e(H),e(w),e(z),e(J),e(F),e(A),e(u),e(L),e(q),e(f),e(D),e(P),e(U),e(K),e(O),e(C),e(tt),e(st),e(W),e(et),e(Z),e(lt),e(at),e(G),e(nt),e(pt),e(B),e(mt),e(it),e(E),e(ot),e(ct),e(rt),e(X)),e(y),d(g,t),d(j,t),d(T,t),d(b,t),d(I,t),d($,t),d(k,t),d(x,t),d(N,t),d(Q,t),d(v,t)}}}const Et='{"title":"(Gluon) SENet","local":"gluon-senet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qt(Mt){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends kt{constructor(y){super(),Gt(this,y,Qt,Nt,$t,{})}}export{Rt as component};
