import{s as Wl,n as $l,o as Al}from"../chunks/scheduler.85c25b89.js";import{S as Bl,i as Nl,g as p,s as e,r as i,A as Ql,h as m,f as t,c as n,j as Zl,u as M,x as j,k as kl,y as xl,a,v as o,d as r,t as c,w as h}from"../chunks/index.c9bcf812.js";import{C as v}from"../chunks/CodeBlock.94efc595.js";import{H as Y}from"../chunks/Heading.3c6e5b17.js";function Rl(yl){let y,X,V,z,J,S,g,Jl='<strong>DenseNet</strong> is a type of convolutional neural network that utilises dense connections between layers, through <a href="http://www.paperswithcode.com/method/dense-block" rel="nofollow">Dense Blocks</a>, where we connect <em>all layers</em> (with matching feature-map sizes) directly with each other. To preserve the feed-forward nature, each layer obtains additional inputs from all preceding layers and passes on its own feature-maps to all subsequent layers.',_,w,gl='The <strong>DenseNet Blur</strong> variant in this collection by Ross Wightman employs <a href="http://www.paperswithcode.com/method/blur-pooling" rel="nofollow">Blur Pooling</a>',F,d,D,T,wl="To load a pretrained model:",L,b,P,u,dl="To load and preprocess the image:",q,U,K,f,Tl="To get the model predictions:",O,C,ll,I,bl="To get the top-5 predictions class names:",sl,Z,tl,k,ul="Replace the model name with the variant you want to use, e.g. <code>densenet121</code>. You can find the IDs in the model summaries at the top of this page.",al,W,Ul='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',el,$,nl,A,fl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pl,B,ml,N,Cl=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,il,Q,Ml,x,Il='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ol,R,rl,E,cl,G,hl,H,jl;return J=new Y({props:{title:"DenseNet",local:"densenet",headingTag:"h1"}}),d=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RlbnNlbmV0MTIxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),$=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZGVuc2VuZXQxMjEnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),Q=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),R=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new v({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIdWFuZ0xXMTZhJTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCR2FvJTIwSHVhbmclMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBaaHVhbmclMjBMaXUlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBLaWxpYW4lMjBRLiUyMFdlaW5iZXJnZXIlN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QkRlbnNlbHklMjBDb25uZWN0ZWQlMjBDb252b2x1dGlvbmFsJTIwTmV0d29ya3MlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE2MDguMDY5OTMlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNiU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNjA4LjA2OTkzJTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTYwOC4wNjk5MyU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3Qk1vbiUyQyUyMDEwJTIwU2VwJTIwMjAxOCUyMDE1JTNBNDklM0EzMiUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSHVhbmdMVzE2YS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HuangLW16a,
  author    = {Gao Huang and
               Zhuang Liu and
               Kilian Q. Weinberger},
  title     = {Densely Connected Convolutional Networks},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1608.06993</span>},
  year      = {<span class="hljs-number">2016</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1608.06993</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1608.06993</span>},
  timestamp = {Mon, <span class="hljs-number">10</span> Sep <span class="hljs-number">2018</span> <span class="hljs-number">15</span>:<span class="hljs-number">49</span>:<span class="hljs-number">32</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HuangLW16a.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),G=new v({props:{code:"JTQwbWlzYyU3QnJ3MjAxOXRpbW0lMkMlMEElMjAlMjBhdXRob3IlMjAlM0QlMjAlN0JSb3NzJTIwV2lnaHRtYW4lN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUzRCUyMCU3QlB5VG9yY2glMjBJbWFnZSUyME1vZGVscyU3RCUyQyUwQSUyMCUyMHllYXIlMjAlM0QlMjAlN0IyMDE5JTdEJTJDJTBBJTIwJTIwcHVibGlzaGVyJTIwJTNEJTIwJTdCR2l0SHViJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUzRCUyMCU3QkdpdEh1YiUyMHJlcG9zaXRvcnklN0QlMkMlMEElMjAlMjBkb2klMjAlM0QlMjAlN0IxMC41MjgxJTJGemVub2RvLjQ0MTQ4NjElN0QlMkMlMEElMjAlMjBob3dwdWJsaXNoZWQlMjAlM0QlMjAlN0IlNUN1cmwlN0JodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZyd2lnaHRtYW4lMkZweXRvcmNoLWltYWdlLW1vZGVscyU3RCU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{rw2019timm,
  author = {Ross Wightman}</span><span class="language-xml">,
  title = </span><span class="hljs-template-variable">{PyTorch Image Models}</span><span class="language-xml">,
  year = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  publisher = </span><span class="hljs-template-variable">{GitHub}</span><span class="language-xml">,
  journal = </span><span class="hljs-template-variable">{GitHub repository}</span><span class="language-xml">,
  doi = </span><span class="hljs-template-variable">{10.5281/zenodo.4414861}</span><span class="language-xml">,
  howpublished = </span><span class="hljs-template-variable">{\\url{https://github.com/rwightman/pytorch-image-models}</span><span class="language-xml">}
}</span>`,wrap:!1}}),{c(){y=p("meta"),X=e(),V=p("p"),z=e(),i(J.$$.fragment),S=e(),g=p("p"),g.innerHTML=Jl,_=e(),w=p("p"),w.innerHTML=gl,F=e(),i(d.$$.fragment),D=e(),T=p("p"),T.textContent=wl,L=e(),i(b.$$.fragment),P=e(),u=p("p"),u.textContent=dl,q=e(),i(U.$$.fragment),K=e(),f=p("p"),f.textContent=Tl,O=e(),i(C.$$.fragment),ll=e(),I=p("p"),I.textContent=bl,sl=e(),i(Z.$$.fragment),tl=e(),k=p("p"),k.innerHTML=ul,al=e(),W=p("p"),W.innerHTML=Ul,el=e(),i($.$$.fragment),nl=e(),A=p("p"),A.textContent=fl,pl=e(),i(B.$$.fragment),ml=e(),N=p("p"),N.innerHTML=Cl,il=e(),i(Q.$$.fragment),Ml=e(),x=p("p"),x.innerHTML=Il,ol=e(),i(R.$$.fragment),rl=e(),i(E.$$.fragment),cl=e(),i(G.$$.fragment),hl=e(),H=p("p"),this.h()},l(l){const s=Ql("svelte-u9bgzb",document.head);y=m(s,"META",{name:!0,content:!0}),s.forEach(t),X=n(l),V=m(l,"P",{}),Zl(V).forEach(t),z=n(l),M(J.$$.fragment,l),S=n(l),g=m(l,"P",{"data-svelte-h":!0}),j(g)!=="svelte-49zh7b"&&(g.innerHTML=Jl),_=n(l),w=m(l,"P",{"data-svelte-h":!0}),j(w)!=="svelte-5gcm94"&&(w.innerHTML=gl),F=n(l),M(d.$$.fragment,l),D=n(l),T=m(l,"P",{"data-svelte-h":!0}),j(T)!=="svelte-18ywhxh"&&(T.textContent=wl),L=n(l),M(b.$$.fragment,l),P=n(l),u=m(l,"P",{"data-svelte-h":!0}),j(u)!=="svelte-1c2ipa8"&&(u.textContent=dl),q=n(l),M(U.$$.fragment,l),K=n(l),f=m(l,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1n9qsq1"&&(f.textContent=Tl),O=n(l),M(C.$$.fragment,l),ll=n(l),I=m(l,"P",{"data-svelte-h":!0}),j(I)!=="svelte-19cnvx1"&&(I.textContent=bl),sl=n(l),M(Z.$$.fragment,l),tl=n(l),k=m(l,"P",{"data-svelte-h":!0}),j(k)!=="svelte-1bbpuw6"&&(k.innerHTML=ul),al=n(l),W=m(l,"P",{"data-svelte-h":!0}),j(W)!=="svelte-1wmi3ea"&&(W.innerHTML=Ul),el=n(l),M($.$$.fragment,l),nl=n(l),A=m(l,"P",{"data-svelte-h":!0}),j(A)!=="svelte-9sr7nh"&&(A.textContent=fl),pl=n(l),M(B.$$.fragment,l),ml=n(l),N=m(l,"P",{"data-svelte-h":!0}),j(N)!=="svelte-1kguc51"&&(N.innerHTML=Cl),il=n(l),M(Q.$$.fragment,l),Ml=n(l),x=m(l,"P",{"data-svelte-h":!0}),j(x)!=="svelte-1n0coha"&&(x.innerHTML=Il),ol=n(l),M(R.$$.fragment,l),rl=n(l),M(E.$$.fragment,l),cl=n(l),M(G.$$.fragment,l),hl=n(l),H=m(l,"P",{}),Zl(H).forEach(t),this.h()},h(){kl(y,"name","hf:doc:metadata"),kl(y,"content",El)},m(l,s){xl(document.head,y),a(l,X,s),a(l,V,s),a(l,z,s),o(J,l,s),a(l,S,s),a(l,g,s),a(l,_,s),a(l,w,s),a(l,F,s),o(d,l,s),a(l,D,s),a(l,T,s),a(l,L,s),o(b,l,s),a(l,P,s),a(l,u,s),a(l,q,s),o(U,l,s),a(l,K,s),a(l,f,s),a(l,O,s),o(C,l,s),a(l,ll,s),a(l,I,s),a(l,sl,s),o(Z,l,s),a(l,tl,s),a(l,k,s),a(l,al,s),a(l,W,s),a(l,el,s),o($,l,s),a(l,nl,s),a(l,A,s),a(l,pl,s),o(B,l,s),a(l,ml,s),a(l,N,s),a(l,il,s),o(Q,l,s),a(l,Ml,s),a(l,x,s),a(l,ol,s),o(R,l,s),a(l,rl,s),o(E,l,s),a(l,cl,s),o(G,l,s),a(l,hl,s),a(l,H,s),jl=!0},p:$l,i(l){jl||(r(J.$$.fragment,l),r(d.$$.fragment,l),r(b.$$.fragment,l),r(U.$$.fragment,l),r(C.$$.fragment,l),r(Z.$$.fragment,l),r($.$$.fragment,l),r(B.$$.fragment,l),r(Q.$$.fragment,l),r(R.$$.fragment,l),r(E.$$.fragment,l),r(G.$$.fragment,l),jl=!0)},o(l){c(J.$$.fragment,l),c(d.$$.fragment,l),c(b.$$.fragment,l),c(U.$$.fragment,l),c(C.$$.fragment,l),c(Z.$$.fragment,l),c($.$$.fragment,l),c(B.$$.fragment,l),c(Q.$$.fragment,l),c(R.$$.fragment,l),c(E.$$.fragment,l),c(G.$$.fragment,l),jl=!1},d(l){l&&(t(X),t(V),t(z),t(S),t(g),t(_),t(w),t(F),t(D),t(T),t(L),t(P),t(u),t(q),t(K),t(f),t(O),t(ll),t(I),t(sl),t(tl),t(k),t(al),t(W),t(el),t(nl),t(A),t(pl),t(ml),t(N),t(il),t(Ml),t(x),t(ol),t(rl),t(cl),t(hl),t(H)),t(y),h(J,l),h(d,l),h(b,l),h(U,l),h(C,l),h(Z,l),h($,l),h(B,l),h(Q,l),h(R,l),h(E,l),h(G,l)}}}const El='{"title":"DenseNet","local":"densenet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Gl(yl){return Al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xl extends Bl{constructor(y){super(),Nl(this,y,Gl,Rl,Wl,{})}}export{Xl as component};
