import{s as Re,n as Le,o as Xe}from"../chunks/scheduler.362310b7.js";import{S as Pe,i as Fe,g as i,s as l,r as p,A as De,h as r,f as t,c as a,j as ze,u as c,x as o,k as X,y as Oe,a as n,v as h,d as M,t as y,w as m}from"../chunks/index.57dfc70d.js";import{C as P}from"../chunks/CodeBlock.5d40996c.js";import{H as z,E as Ke}from"../chunks/getInferenceSnippets.9a9f9361.js";function es($e){let u,F,R,D,T,O,J,K,g,Se="Token streaming is the mode in which the server returns the tokens one by one as the model generates them. This enables showing progressive generations to the user rather than waiting for the whole generation. Streaming is an essential aspect of the end-user experience as it reduces latency, one of the most critical aspects of a smooth experience.",ee,U,ke='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/streaming-generation-visual_360.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/streaming-generation-visual-dark_360.gif"/>',se,j,Ee="With token streaming, the server can start returning the tokens one by one before having to generate the whole response. Users can have a sense of the generation’s quality before the end of the generation. This has different positive effects:",te,f,Be="<li>Users can get results orders of magnitude earlier for extremely long queries.</li> <li>Seeing something in progress allows users to stop the generation if it’s not going in the direction they expect.</li> <li>Perceived latency is lower when results are shown in the early stages.</li> <li>When used in conversational UIs, the experience feels more natural.</li>",ne,C,Qe="For example, a system can generate 100 tokens per second. If the system generates 1000 tokens, with the non-streaming setup, users need to wait 10 seconds to get results. On the other hand, with the streaming setup, users get initial results immediately, and although end-to-end latency will be the same, they can see half of the generation after five seconds. Below you can see an interactive demo that shows non-streaming vs streaming side-by-side. Click <strong>generate</strong> below.",le,d,qe='<iframe src="https://osanseviero-streaming-vs-non-streaming.hf.space?__theme=light" width="850" height="350"></iframe>',ae,w,We='<iframe src="https://osanseviero-streaming-vs-non-streaming.hf.space?__theme=dark" width="850" height="350"></iframe>',ie,I,re,b,oe,v,Ze="To stream tokens with <code>InferenceClient</code>, simply pass <code>stream=True</code> and iterate over the response.",pe,$,ce,S,xe="The <code>huggingface_hub</code> library also comes with an <code>AsyncInferenceClient</code> in case you need to handle the requests concurrently.",he,k,Me,E,ye,B,Ge="To use the OpenAI Chat Completions compatible Messages API <code>v1/chat/completions</code> endpoint with curl, you can add the <code>-N</code> flag, which disables curl default buffering and shows data as it arrives from the server",me,Q,ue,q,Ue,W,Ne="First, we need to install the <code>@huggingface/inference</code> library.",de,Z,we,x,He="Whether you use Inference Providers (our serverless API), or Inference Endpoints, you can call <code>InferenceClient</code>.",Te,G,Je,N,ge,H,Ve="Under the hood, TGI uses Server-Sent Events (SSE). In an SSE Setup, a client sends a request with the data, opening an HTTP connection and subscribing to updates. Afterward, the server sends data to the client. There is no need for further requests; the server will keep sending the data. SSEs are unidirectional, meaning the client does not send other requests to the server. SSE sends data over HTTP, making it easy to use.",je,V,_e="SSEs are different than:",fe,_,Ye="<li>Polling: where the client keeps calling the server to get data. This means that the server might return empty responses and cause overhead.</li> <li>Webhooks: where there is a bi-directional connection. The server can send information to the client, but the client can also send data to the server after the first request. Webhooks are more complex to operate as they don’t only use HTTP.</li>",Ce,Y,Ae="If there are too many requests at the same time, TGI returns an HTTP Error with an <code>overloaded</code> error type (<code>huggingface_hub</code> returns <code>OverloadedError</code>). This allows the client to manage the overloaded server (e.g., it could display a busy error to the user or retry with a new request). To configure the maximum number of concurrent requests, you can specify <code>--max_concurrent_requests</code>, allowing clients to handle backpressure.",Ie,A,be,L,ve;return T=new z({props:{title:"Streaming",local:"streaming",headingTag:"h1"}}),J=new z({props:{title:"What is Streaming?",local:"what-is-streaming",headingTag:"h2"}}),I=new z({props:{title:"How to use Streaming?",local:"how-to-use-streaming",headingTag:"h2"}}),b=new z({props:{title:"Streaming with Python",local:"streaming-with-python",headingTag:"h3"}}),$=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDgwJTIyKSUwQW91dHB1dCUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KSUwQSUwQSUyMyUyMDElMEElMjMlMjAyJTBBJTIzJTIwMyUwQSUyMyUyMDQlMEElMjMlMjA1JTBBJTIzJTIwNiUwQSUyMyUyMDclMEElMjMlMjA4JTBBJTIzJTIwOSUwQSUyMyUyMDEw",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(base_url=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)

<span class="hljs-comment"># 1</span>
<span class="hljs-comment"># 2</span>
<span class="hljs-comment"># 3</span>
<span class="hljs-comment"># 4</span>
<span class="hljs-comment"># 5</span>
<span class="hljs-comment"># 6</span>
<span class="hljs-comment"># 7</span>
<span class="hljs-comment"># 8</span>
<span class="hljs-comment"># 9</span>
<span class="hljs-comment"># 10</span>`,wrap:!1}}),k=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODA4MCUyMiklMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMHN0cmVhbSUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU2F5JTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZm9yJTIwY2h1bmslMjBpbiUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMjBvciUyMCUyMiUyMiUyQyUyMGVuZCUzRCUyMiUyMiklMEElMEFhc3luY2lvLnJ1bihtYWluKCkpJTBBJTBBJTIzJTIwVGhpcyUwQSUyMyUyMGlzJTBBJTIzJTIwYSUwQSUyMyUyMHRlc3QlMEElMjMu",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

client = AsyncInferenceClient(base_url=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    stream = <span class="hljs-keyword">await</span> client.chat.completions.create(
        messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Say this is a test&quot;</span>}],
        stream=<span class="hljs-literal">True</span>,
    )
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> stream:
        <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;&quot;</span>, end=<span class="hljs-string">&quot;&quot;</span>)

asyncio.run(main())

<span class="hljs-comment"># This</span>
<span class="hljs-comment"># is</span>
<span class="hljs-comment"># a</span>
<span class="hljs-comment"># test</span>
<span class="hljs-comment">#.</span>`,wrap:!1}}),E=new z({props:{title:"Streaming with cURL",local:"streaming-with-curl",headingTag:"h3"}}),Q=new P({props:{code:"Y3VybCUyMGxvY2FsaG9zdCUzQTgwODAlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMjAlMEElN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJw==",highlighted:`curl localhost:<span class="hljs-number">8080</span>/v1/chat/completions \\
    -X POST \\
    -d &#x27;{
  <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
  <span class="hljs-string">&quot;messages&quot;</span>: [
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>
    },
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>
    }
  ],
  <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">true</span>,
  <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">20</span>
}&#x27; \\
    -H <span class="hljs-symbol">&#x27;Content</span>-<span class="hljs-keyword">Type</span>: application/json&#x27;`,wrap:!1}}),q=new z({props:{title:"Streaming with JavaScript",local:"streaming-with-javascript",headingTag:"h3"}}),Z=new P({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:"npm install @huggingface/inference",wrap:!1}}),G=new P({props:{code:"aW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCclNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSclM0IlMEElMEFjb25zdCUyMGNsaWVudCUyMCUzRCUyMG5ldyUyMEluZmVyZW5jZUNsaWVudCgnaGZfWU9VUl9UT0tFTiclMkMlMjAlN0IlMjBlbmRwb2ludFVybCUzQSUyMCdodHRwcyUzQSUyRiUyRllPVVJfRU5EUE9JTlQuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJyUyMCU3RCklM0IlMEElMEElMkYlMkYlMjBwcm9tcHQlMEFjb25zdCUyMHByb21wdCUyMCUzRCUyMCdXaGF0JTIwY2FuJTIweW91JTIwZG8lMjBpbiUyME51cmVtYmVyZyUyQyUyMEdlcm1hbnklM0YlMjBHaXZlJTIwbWUlMjAzJTIwVGlwcyclM0IlMEElMEFjb25zdCUyMHN0cmVhbSUyMCUzRCUyMGNsaWVudC50ZXh0R2VuZXJhdGlvblN0cmVhbSglN0IlMjBpbnB1dHMlM0ElMjBwcm9tcHQlMjAlN0QpJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjByJTIwb2YlMjBzdHJlYW0pJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIweWllbGQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUyMCUyMHByb2Nlc3Muc3Rkb3V0LndyaXRlKHIudG9rZW4udGV4dCklM0IlMEElN0Q=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>;

<span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-string">&#x27;hf_YOUR_TOKEN&#x27;</span>, { <span class="hljs-attr">endpointUrl</span>: <span class="hljs-string">&#x27;https://YOUR_ENDPOINT.endpoints.huggingface.cloud&#x27;</span> });

<span class="hljs-comment">// prompt</span>
<span class="hljs-keyword">const</span> prompt = <span class="hljs-string">&#x27;What can you do in Nuremberg, Germany? Give me 3 Tips&#x27;</span>;

<span class="hljs-keyword">const</span> stream = client.<span class="hljs-title function_">textGenerationStream</span>({ <span class="hljs-attr">inputs</span>: prompt });
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> r <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-comment">// yield the generated token</span>
  process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(r.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>);
}`,wrap:!1}}),N=new z({props:{title:"How does Streaming work under the hood?",local:"how-does-streaming-work-under-the-hood",headingTag:"h2"}}),A=new Ke({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/conceptual/streaming.md"}}),{c(){u=i("meta"),F=l(),R=i("p"),D=l(),p(T.$$.fragment),O=l(),p(J.$$.fragment),K=l(),g=i("p"),g.textContent=Se,ee=l(),U=i("div"),U.innerHTML=ke,se=l(),j=i("p"),j.textContent=Ee,te=l(),f=i("ul"),f.innerHTML=Be,ne=l(),C=i("p"),C.innerHTML=Qe,le=l(),d=i("div"),d.innerHTML=qe,ae=l(),w=i("div"),w.innerHTML=We,ie=l(),p(I.$$.fragment),re=l(),p(b.$$.fragment),oe=l(),v=i("p"),v.innerHTML=Ze,pe=l(),p($.$$.fragment),ce=l(),S=i("p"),S.innerHTML=xe,he=l(),p(k.$$.fragment),Me=l(),p(E.$$.fragment),ye=l(),B=i("p"),B.innerHTML=Ge,me=l(),p(Q.$$.fragment),ue=l(),p(q.$$.fragment),Ue=l(),W=i("p"),W.innerHTML=Ne,de=l(),p(Z.$$.fragment),we=l(),x=i("p"),x.innerHTML=He,Te=l(),p(G.$$.fragment),Je=l(),p(N.$$.fragment),ge=l(),H=i("p"),H.textContent=Ve,je=l(),V=i("p"),V.textContent=_e,fe=l(),_=i("ul"),_.innerHTML=Ye,Ce=l(),Y=i("p"),Y.innerHTML=Ae,Ie=l(),p(A.$$.fragment),be=l(),L=i("p"),this.h()},l(e){const s=De("svelte-u9bgzb",document.head);u=r(s,"META",{name:!0,content:!0}),s.forEach(t),F=a(e),R=r(e,"P",{}),ze(R).forEach(t),D=a(e),c(T.$$.fragment,e),O=a(e),c(J.$$.fragment,e),K=a(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-18otp1w"&&(g.textContent=Se),ee=a(e),U=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1mls61x"&&(U.innerHTML=ke),se=a(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1i4w8o9"&&(j.textContent=Ee),te=a(e),f=r(e,"UL",{"data-svelte-h":!0}),o(f)!=="svelte-1sljm14"&&(f.innerHTML=Be),ne=a(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-doyuuq"&&(C.innerHTML=Qe),le=a(e),d=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(d)!=="svelte-7ia471"&&(d.innerHTML=qe),ae=a(e),w=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1wj2bw6"&&(w.innerHTML=We),ie=a(e),c(I.$$.fragment,e),re=a(e),c(b.$$.fragment,e),oe=a(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-16qpzge"&&(v.innerHTML=Ze),pe=a(e),c($.$$.fragment,e),ce=a(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1nblluv"&&(S.innerHTML=xe),he=a(e),c(k.$$.fragment,e),Me=a(e),c(E.$$.fragment,e),ye=a(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-foca00"&&(B.innerHTML=Ge),me=a(e),c(Q.$$.fragment,e),ue=a(e),c(q.$$.fragment,e),Ue=a(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1qcvblx"&&(W.innerHTML=Ne),de=a(e),c(Z.$$.fragment,e),we=a(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1jcra9t"&&(x.innerHTML=He),Te=a(e),c(G.$$.fragment,e),Je=a(e),c(N.$$.fragment,e),ge=a(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1wghvdx"&&(H.textContent=Ve),je=a(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-m95rqi"&&(V.textContent=_e),fe=a(e),_=r(e,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-1vpfo5b"&&(_.innerHTML=Ye),Ce=a(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-jbqwxg"&&(Y.innerHTML=Ae),Ie=a(e),c(A.$$.fragment,e),be=a(e),L=r(e,"P",{}),ze(L).forEach(t),this.h()},h(){X(u,"name","hf:doc:metadata"),X(u,"content",ss),X(U,"class","flex justify-center"),X(d,"class","block dark:hidden"),X(w,"class","hidden dark:block")},m(e,s){Oe(document.head,u),n(e,F,s),n(e,R,s),n(e,D,s),h(T,e,s),n(e,O,s),h(J,e,s),n(e,K,s),n(e,g,s),n(e,ee,s),n(e,U,s),n(e,se,s),n(e,j,s),n(e,te,s),n(e,f,s),n(e,ne,s),n(e,C,s),n(e,le,s),n(e,d,s),n(e,ae,s),n(e,w,s),n(e,ie,s),h(I,e,s),n(e,re,s),h(b,e,s),n(e,oe,s),n(e,v,s),n(e,pe,s),h($,e,s),n(e,ce,s),n(e,S,s),n(e,he,s),h(k,e,s),n(e,Me,s),h(E,e,s),n(e,ye,s),n(e,B,s),n(e,me,s),h(Q,e,s),n(e,ue,s),h(q,e,s),n(e,Ue,s),n(e,W,s),n(e,de,s),h(Z,e,s),n(e,we,s),n(e,x,s),n(e,Te,s),h(G,e,s),n(e,Je,s),h(N,e,s),n(e,ge,s),n(e,H,s),n(e,je,s),n(e,V,s),n(e,fe,s),n(e,_,s),n(e,Ce,s),n(e,Y,s),n(e,Ie,s),h(A,e,s),n(e,be,s),n(e,L,s),ve=!0},p:Le,i(e){ve||(M(T.$$.fragment,e),M(J.$$.fragment,e),M(I.$$.fragment,e),M(b.$$.fragment,e),M($.$$.fragment,e),M(k.$$.fragment,e),M(E.$$.fragment,e),M(Q.$$.fragment,e),M(q.$$.fragment,e),M(Z.$$.fragment,e),M(G.$$.fragment,e),M(N.$$.fragment,e),M(A.$$.fragment,e),ve=!0)},o(e){y(T.$$.fragment,e),y(J.$$.fragment,e),y(I.$$.fragment,e),y(b.$$.fragment,e),y($.$$.fragment,e),y(k.$$.fragment,e),y(E.$$.fragment,e),y(Q.$$.fragment,e),y(q.$$.fragment,e),y(Z.$$.fragment,e),y(G.$$.fragment,e),y(N.$$.fragment,e),y(A.$$.fragment,e),ve=!1},d(e){e&&(t(F),t(R),t(D),t(O),t(K),t(g),t(ee),t(U),t(se),t(j),t(te),t(f),t(ne),t(C),t(le),t(d),t(ae),t(w),t(ie),t(re),t(oe),t(v),t(pe),t(ce),t(S),t(he),t(Me),t(ye),t(B),t(me),t(ue),t(Ue),t(W),t(de),t(we),t(x),t(Te),t(Je),t(ge),t(H),t(je),t(V),t(fe),t(_),t(Ce),t(Y),t(Ie),t(be),t(L)),t(u),m(T,e),m(J,e),m(I,e),m(b,e),m($,e),m(k,e),m(E,e),m(Q,e),m(q,e),m(Z,e),m(G,e),m(N,e),m(A,e)}}}const ss='{"title":"Streaming","local":"streaming","sections":[{"title":"What is Streaming?","local":"what-is-streaming","sections":[],"depth":2},{"title":"How to use Streaming?","local":"how-to-use-streaming","sections":[{"title":"Streaming with Python","local":"streaming-with-python","sections":[],"depth":3},{"title":"Streaming with cURL","local":"streaming-with-curl","sections":[],"depth":3},{"title":"Streaming with JavaScript","local":"streaming-with-javascript","sections":[],"depth":3}],"depth":2},{"title":"How does Streaming work under the hood?","local":"how-does-streaming-work-under-the-hood","sections":[],"depth":2}],"depth":1}';function ts($e){return Xe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rs extends Pe{constructor(u){super(),Fe(this,u,ts,es,Re,{})}}export{rs as component};
