import{s as _d,n as fd,o as bd}from"../chunks/scheduler.b108d059.js";import{S as Td,i as gd,g as a,s as o,r as p,A as xd,h as d,f as r,c as l,j as f,u as n,x as c,k as i,y as yd,a as s,v as m,d as u,t as h,w as _}from"../chunks/index.008de539.js";import{C as Nl}from"../chunks/CodeBlock.3968c746.js";import{H as b}from"../chunks/Heading.88bfeb84.js";function vd(Gl){let T,er,Kt,tr,g,rr,x,sr,y,Zl="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",or,v,Ql="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",lr,M,ar,$,Xl='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(urls)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..post_process_object_detection"><code>~post_process_object_detection(outputs)</code></a> ⇒ <code>Array.&lt;Object&gt;</code><ul><li><a href="#module_processors..post_process_object_detection..box"><code>~box</code></a> : <code>Array.&lt;number&gt;</code></li></ul></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',dr,cr,ir,w,pr,E,nr,J,Vl="Base class for feature extractors.",mr,j,Yl='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',ur,hr,_r,C,fr,P,br,k,ql="Constructs a new FeatureExtractor instance.",Tr,H,Sl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",gr,xr,yr,I,vr,F,Mr,L,Kl="Feature extractor for image models.",$r,A,Ol='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',wr,R,ea='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',Er,Jr,jr,U,Cr,z,Pr,D,ta="Constructs a new ImageFeatureExtractor instance.",kr,B,ra="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code></td><td><p>The size to resize the image to.</p></td></tr></tbody>",Hr,Ir,Fr,W,Lr,N,Ar,G,sa=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,Rr,Z,oa='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',Ur,Q,la="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",zr,Dr,Br,X,Wr,V,Nr,Y,aa="Preprocesses the given image.",Gr,q,da='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',Zr,S,ca="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td></tr></tbody>",Qr,Xr,Vr,K,Yr,O,qr,ee,ia=`Calls the feature extraction process on an array of image
URLs, preprocesses each image, and concatenates the resulting
features into a single Tensor.`,Sr,te,pa='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',Kr,re,na="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td><p>The URL(s) of the image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",Or,es,ts,se,rs,oe,ss,le,ma="Detr Feature Extractor.",os,ae,ua='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',ls,de,ha='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(urls)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li>',as,ds,cs,ce,is,ie,ps,pe,_a=`Calls the feature extraction process on an array of image URLs, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,ns,ne,fa='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',ms,me,ba="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urls</td><td><code>Array.&lt;any&gt;</code></td><td><p>The URL(s) of the image(s) to extract features from.</p></td></tr></tbody>",us,hs,_s,ue,fs,he,bs,_e,Ta='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Ts,gs,xs,fe,ys,be,vs,Te,ga="Binarize the given masks using <code>object_mask_threshold</code>, it returns the associated values of <code>masks</code>, <code>scores</code> and <code>labels</code>.",Ms,ge,xa='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The binarized masks, the scores, and the labels.',$s,xe,ya="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>class_logits</td><td><code>Tensor</code></td><td><p>The class logits.</p></td> </tr><tr><td>mask_logits</td><td><code>Tensor</code></td><td><p>The mask logits.</p></td> </tr><tr><td>object_mask_threshold</td><td><code>number</code></td><td><p>A number between 0 and 1 used to binarize the masks.</p></td> </tr><tr><td>num_labels</td><td><code>number</code></td><td><p>The number of labels.</p></td></tr></tbody>",ws,Es,Js,ye,js,ve,Cs,Me,va="Checks whether the segment is valid or not.",Ps,$e,Ma='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - Whether the segment is valid or not, and the indices of the valid labels.',ks,we,$a="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_labels</td><td><code>Int32Array</code></td><td></td><td><p>Labels for each pixel in the mask.</p></td> </tr><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>Probabilities for each pixel in the masks.</p></td> </tr><tr><td>k</td><td><code>number</code></td><td></td><td><p>The class id of the segment.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold.</p></td></tr></tbody>",Hs,Is,Fs,Ee,Ls,Je,As,je,wa="Computes the segments.",Rs,Ce,Ea='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The computed segments.',Us,Pe,Ja="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>The mask probabilities.</p></td> </tr><tr><td>pred_scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted scores.</p></td> </tr><tr><td>pred_labels</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted labels.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td></td><td><p>The overlap mask area threshold.</p></td> </tr><tr><td>label_ids_to_fuse</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The label ids to fuse.</p></td> </tr><tr><td>target_size</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>The target size of the image.</p></td></tr></tbody>",zs,Ds,Bs,ke,Ws,He,Ns,Ie,ja="Post-process the model output to generate the final panoptic segmentation.",Gs,Fe,Ca='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Zs,Le,Pa="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",Qs,Xs,Vs,Ae,Ys,Re,qs,Ue,ka="Represents a Processor that extracts features from an input.",Ss,ze,Ha='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Ks,De,Ia='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Os,eo,to,Be,ro,We,so,Ne,Fa="Creates a new Processor with the given feature extractor.",oo,Ge,La="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",lo,ao,co,Ze,io,Qe,po,Xe,Aa="Calls the feature_extractor function with the given input.",no,Ve,Ra='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',mo,Ye,Ua="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",uo,ho,_o,qe,fo,Se,bo,Ke,za="Represents a WhisperProcessor that extracts features from an audio input.",To,Oe,Da='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',go,xo,yo,et,vo,tt,Mo,rt,Ba="Calls the feature_extractor function with the given audio input.",$o,st,Wa='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',wo,ot,Na="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",Eo,Jo,jo,lt,Co,at,Po,dt,Ga=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,ko,ct,Za="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",Ho,it,Io,pt,Qa="<strong>Example:</strong> Run an image through a processor.",Fo,nt,Lo,mt,Xa='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',Ao,Ro,Uo,ut,zo,ht,Do,_t,Va="Instantiate one of the processor classes of the library from a pretrained model.",Bo,ft,Ya=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,Wo,bt,qa='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',No,Tt,Sa=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,Go,Zo,Qo,gt,Xo,xt,Vo,yt,Ka="Converts bounding boxes from center format to corners format.",Yo,vt,Oa='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',qo,Mt,ed="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",So,Ko,Oo,$t,el,wt,tl,Et,td="Post-processes the outputs of the model (for object detection).",rl,Jt,rd='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Object&gt;</code> - An array of objects containing the post-processed outputs.',sl,jt,sd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>Object</code></td><td><p>The outputs of the model that must be post-processed</p></td> </tr><tr><td>outputs.logits</td><td><code>Tensor</code></td><td><p>The logits</p></td> </tr><tr><td>outputs.pred_boxes</td><td><code>Tensor</code></td><td><p>The predicted boxes.</p></td></tr></tbody>",ol,ll,al,Ct,dl,Pt,cl,kt,od='<strong>Kind</strong>: inner property of <a href="#module_processors..post_process_object_detection"><code>post_process_object_detection</code></a>',il,pl,nl,Ht,ml,It,ul,Ft,ld=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,hl,Lt,ad='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',_l,fl,bl,At,Tl,Rt,gl,Ut,dd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',xl,zt,cd="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",yl,vl,Ml,Dt,$l,Bt,wl,Wt,id='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',El,Nt,pd="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",Jl,jl,Cl,Gt,Pl,Zt,kl,Qt,nd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Hl,Xt,md="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",Il,Fl,Ll,Vt,Al,Yt,Rl,qt,ud='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Ul,St,hd="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>input_points</td><td><code>Tensor</code></td></tr></tbody>",zl,Dl,Bl,Ot,Wl;return x=new b({props:{title:"processors",local:"processors",headingTag:"h1"}}),M=new Nl({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBwcm9jZXNzb3IlMjAlM0QlMjBhd2FpdCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCdvcGVuYWklMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQiUwQWxldCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWxldCUyMCU3QiUyMGlucHV0X2ZlYXR1cmVzJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoYXVkaW8pJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSgyNDAwMDApJTIwJTVCMC40NzUyOTg0NjQyOTgyNDgzJTJDJTIwMC41NTk3MjU4ODA2MjI4NjM4JTJDJTIwMC41NjQzNDE2NjQzMTQyNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwODAlMkMlMjAzMDAwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwdHlwZSUzQSUyMCdmbG9hdDMyJyUyQyUwQSUyRiUyRiUyMCUyMCUyMHNpemUlM0ElMjAyNDAwMDAlMkMlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new b({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),P=new b({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),F=new b({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),z=new b({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),N=new b({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),V=new b({props:{title:"imageFeatureExtractor.preprocess(image) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage--code-promise--preprocessedimage--code",headingTag:"h3"}}),O=new b({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),oe=new b({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),ie=new b({props:{title:"detrFeatureExtractor._call(urls) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallurls--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),he=new b({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>",local:"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code",headingTag:"h3"}}),be=new b({props:{title:"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>",local:"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code",headingTag:"h3"}}),ve=new b({props:{title:"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>",local:"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code",headingTag:"h3"}}),Je=new b({props:{title:"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>",local:"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code",headingTag:"h3"}}),He=new b({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h3"}}),Re=new b({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),We=new b({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),Qe=new b({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),Se=new b({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),tt=new b({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),at=new b({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),it=new Nl({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),nt=new Nl({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),ht=new b({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),xt=new b({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),wt=new b({props:{title:"processors~post_process_object_detection(outputs) ⇒ <code> Array. < Object > </code>",local:"processorspostprocessobjectdetectionoutputs--code-array--object--code",headingTag:"h2"}}),Pt=new b({props:{title:"post_process_object_detection~box : <code> Array. < number > </code>",local:"postprocessobjectdetectionbox--code-array--number--code",headingTag:"h3"}}),It=new b({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),Rt=new b({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),Bt=new b({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),Zt=new b({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),Yt=new b({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),{c(){T=a("meta"),er=o(),Kt=a("p"),tr=o(),g=a("a"),rr=o(),p(x.$$.fragment),sr=o(),y=a("p"),y.textContent=Zl,or=o(),v=a("p"),v.innerHTML=Ql,lr=o(),p(M.$$.fragment),ar=o(),$=a("ul"),$.innerHTML=Xl,dr=o(),cr=a("hr"),ir=o(),w=a("a"),pr=o(),p(E.$$.fragment),nr=o(),J=a("p"),J.textContent=Vl,mr=o(),j=a("p"),j.innerHTML=Yl,ur=o(),hr=a("hr"),_r=o(),C=a("a"),fr=o(),p(P.$$.fragment),br=o(),k=a("p"),k.textContent=ql,Tr=o(),H=a("table"),H.innerHTML=Sl,gr=o(),xr=a("hr"),yr=o(),I=a("a"),vr=o(),p(F.$$.fragment),Mr=o(),L=a("p"),L.textContent=Kl,$r=o(),A=a("p"),A.innerHTML=Ol,wr=o(),R=a("ul"),R.innerHTML=ea,Er=o(),Jr=a("hr"),jr=o(),U=a("a"),Cr=o(),p(z.$$.fragment),Pr=o(),D=a("p"),D.textContent=ta,kr=o(),B=a("table"),B.innerHTML=ra,Hr=o(),Ir=a("hr"),Fr=o(),W=a("a"),Lr=o(),p(N.$$.fragment),Ar=o(),G=a("p"),G.textContent=sa,Rr=o(),Z=a("p"),Z.innerHTML=oa,Ur=o(),Q=a("table"),Q.innerHTML=la,zr=o(),Dr=a("hr"),Br=o(),X=a("a"),Wr=o(),p(V.$$.fragment),Nr=o(),Y=a("p"),Y.textContent=aa,Gr=o(),q=a("p"),q.innerHTML=da,Zr=o(),S=a("table"),S.innerHTML=ca,Qr=o(),Xr=a("hr"),Vr=o(),K=a("a"),Yr=o(),p(O.$$.fragment),qr=o(),ee=a("p"),ee.textContent=ia,Sr=o(),te=a("p"),te.innerHTML=pa,Kr=o(),re=a("table"),re.innerHTML=na,Or=o(),es=a("hr"),ts=o(),se=a("a"),rs=o(),p(oe.$$.fragment),ss=o(),le=a("p"),le.textContent=ma,os=o(),ae=a("p"),ae.innerHTML=ua,ls=o(),de=a("ul"),de.innerHTML=ha,as=o(),ds=a("hr"),cs=o(),ce=a("a"),is=o(),p(ie.$$.fragment),ps=o(),pe=a("p"),pe.textContent=_a,ns=o(),ne=a("p"),ne.innerHTML=fa,ms=o(),me=a("table"),me.innerHTML=ba,us=o(),hs=a("hr"),_s=o(),ue=a("a"),fs=o(),p(he.$$.fragment),bs=o(),_e=a("p"),_e.innerHTML=Ta,Ts=o(),gs=a("hr"),xs=o(),fe=a("a"),ys=o(),p(be.$$.fragment),vs=o(),Te=a("p"),Te.innerHTML=ga,Ms=o(),ge=a("p"),ge.innerHTML=xa,$s=o(),xe=a("table"),xe.innerHTML=ya,ws=o(),Es=a("hr"),Js=o(),ye=a("a"),js=o(),p(ve.$$.fragment),Cs=o(),Me=a("p"),Me.textContent=va,Ps=o(),$e=a("p"),$e.innerHTML=Ma,ks=o(),we=a("table"),we.innerHTML=$a,Hs=o(),Is=a("hr"),Fs=o(),Ee=a("a"),Ls=o(),p(Je.$$.fragment),As=o(),je=a("p"),je.textContent=wa,Rs=o(),Ce=a("p"),Ce.innerHTML=Ea,Us=o(),Pe=a("table"),Pe.innerHTML=Ja,zs=o(),Ds=a("hr"),Bs=o(),ke=a("a"),Ws=o(),p(He.$$.fragment),Ns=o(),Ie=a("p"),Ie.textContent=ja,Gs=o(),Fe=a("p"),Fe.innerHTML=Ca,Zs=o(),Le=a("table"),Le.innerHTML=Pa,Qs=o(),Xs=a("hr"),Vs=o(),Ae=a("a"),Ys=o(),p(Re.$$.fragment),qs=o(),Ue=a("p"),Ue.textContent=ka,Ss=o(),ze=a("p"),ze.innerHTML=Ha,Ks=o(),De=a("ul"),De.innerHTML=Ia,Os=o(),eo=a("hr"),to=o(),Be=a("a"),ro=o(),p(We.$$.fragment),so=o(),Ne=a("p"),Ne.textContent=Fa,oo=o(),Ge=a("table"),Ge.innerHTML=La,lo=o(),ao=a("hr"),co=o(),Ze=a("a"),io=o(),p(Qe.$$.fragment),po=o(),Xe=a("p"),Xe.textContent=Aa,no=o(),Ve=a("p"),Ve.innerHTML=Ra,mo=o(),Ye=a("table"),Ye.innerHTML=Ua,uo=o(),ho=a("hr"),_o=o(),qe=a("a"),fo=o(),p(Se.$$.fragment),bo=o(),Ke=a("p"),Ke.textContent=za,To=o(),Oe=a("p"),Oe.innerHTML=Da,go=o(),xo=a("hr"),yo=o(),et=a("a"),vo=o(),p(tt.$$.fragment),Mo=o(),rt=a("p"),rt.textContent=Ba,$o=o(),st=a("p"),st.innerHTML=Wa,wo=o(),ot=a("table"),ot.innerHTML=Na,Eo=o(),Jo=a("hr"),jo=o(),lt=a("a"),Co=o(),p(at.$$.fragment),Po=o(),dt=a("p"),dt.innerHTML=Ga,ko=o(),ct=a("p"),ct.innerHTML=Za,Ho=o(),p(it.$$.fragment),Io=o(),pt=a("p"),pt.innerHTML=Qa,Fo=o(),p(nt.$$.fragment),Lo=o(),mt=a("p"),mt.innerHTML=Xa,Ao=o(),Ro=a("hr"),Uo=o(),ut=a("a"),zo=o(),p(ht.$$.fragment),Do=o(),_t=a("p"),_t.textContent=Va,Bo=o(),ft=a("p"),ft.innerHTML=Ya,Wo=o(),bt=a("p"),bt.innerHTML=qa,No=o(),Tt=a("table"),Tt.innerHTML=Sa,Go=o(),Zo=a("hr"),Qo=o(),gt=a("a"),Xo=o(),p(xt.$$.fragment),Vo=o(),yt=a("p"),yt.textContent=Ka,Yo=o(),vt=a("p"),vt.innerHTML=Oa,qo=o(),Mt=a("table"),Mt.innerHTML=ed,So=o(),Ko=a("hr"),Oo=o(),$t=a("a"),el=o(),p(wt.$$.fragment),tl=o(),Et=a("p"),Et.textContent=td,rl=o(),Jt=a("p"),Jt.innerHTML=rd,sl=o(),jt=a("table"),jt.innerHTML=sd,ol=o(),ll=a("hr"),al=o(),Ct=a("a"),dl=o(),p(Pt.$$.fragment),cl=o(),kt=a("p"),kt.innerHTML=od,il=o(),pl=a("hr"),nl=o(),Ht=a("a"),ml=o(),p(It.$$.fragment),ul=o(),Ft=a("p"),Ft.textContent=ld,hl=o(),Lt=a("p"),Lt.innerHTML=ad,_l=o(),fl=a("hr"),bl=o(),At=a("a"),Tl=o(),p(Rt.$$.fragment),gl=o(),Ut=a("p"),Ut.innerHTML=dd,xl=o(),zt=a("table"),zt.innerHTML=cd,yl=o(),vl=a("hr"),Ml=o(),Dt=a("a"),$l=o(),p(Bt.$$.fragment),wl=o(),Wt=a("p"),Wt.innerHTML=id,El=o(),Nt=a("table"),Nt.innerHTML=pd,Jl=o(),jl=a("hr"),Cl=o(),Gt=a("a"),Pl=o(),p(Zt.$$.fragment),kl=o(),Qt=a("p"),Qt.innerHTML=nd,Hl=o(),Xt=a("table"),Xt.innerHTML=md,Il=o(),Fl=a("hr"),Ll=o(),Vt=a("a"),Al=o(),p(Yt.$$.fragment),Rl=o(),qt=a("p"),qt.innerHTML=ud,Ul=o(),St=a("table"),St.innerHTML=hd,zl=o(),Dl=a("hr"),Bl=o(),Ot=a("p"),this.h()},l(e){const t=xd("svelte-u9bgzb",document.head);T=d(t,"META",{name:!0,content:!0}),t.forEach(r),er=l(e),Kt=d(e,"P",{}),f(Kt).forEach(r),tr=l(e),g=d(e,"A",{id:!0,class:!0}),f(g).forEach(r),rr=l(e),n(x.$$.fragment,e),sr=l(e),y=d(e,"P",{"data-svelte-h":!0}),c(y)!=="svelte-w0rx8m"&&(y.textContent=Zl),or=l(e),v=d(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1olsie5"&&(v.innerHTML=Ql),lr=l(e),n(M.$$.fragment,e),ar=l(e),$=d(e,"UL",{"data-svelte-h":!0}),c($)!=="svelte-12ooed7"&&($.innerHTML=Xl),dr=l(e),cr=d(e,"HR",{}),ir=l(e),w=d(e,"A",{id:!0,class:!0}),f(w).forEach(r),pr=l(e),n(E.$$.fragment,e),nr=l(e),J=d(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-14r3pvv"&&(J.textContent=Vl),mr=l(e),j=d(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-fac4cj"&&(j.innerHTML=Yl),ur=l(e),hr=d(e,"HR",{}),_r=l(e),C=d(e,"A",{id:!0,class:!0}),f(C).forEach(r),fr=l(e),n(P.$$.fragment,e),br=l(e),k=d(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-k3m2wg"&&(k.textContent=ql),Tr=l(e),H=d(e,"TABLE",{"data-svelte-h":!0}),c(H)!=="svelte-rd7ds7"&&(H.innerHTML=Sl),gr=l(e),xr=d(e,"HR",{}),yr=l(e),I=d(e,"A",{id:!0,class:!0}),f(I).forEach(r),vr=l(e),n(F.$$.fragment,e),Mr=l(e),L=d(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-8k8cys"&&(L.textContent=Kl),$r=l(e),A=d(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-18p52n5"&&(A.innerHTML=Ol),wr=l(e),R=d(e,"UL",{"data-svelte-h":!0}),c(R)!=="svelte-1b1lvbt"&&(R.innerHTML=ea),Er=l(e),Jr=d(e,"HR",{}),jr=l(e),U=d(e,"A",{id:!0,class:!0}),f(U).forEach(r),Cr=l(e),n(z.$$.fragment,e),Pr=l(e),D=d(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1mp2vol"&&(D.textContent=ta),kr=l(e),B=d(e,"TABLE",{"data-svelte-h":!0}),c(B)!=="svelte-eb9kev"&&(B.innerHTML=ra),Hr=l(e),Ir=d(e,"HR",{}),Fr=l(e),W=d(e,"A",{id:!0,class:!0}),f(W).forEach(r),Lr=l(e),n(N.$$.fragment,e),Ar=l(e),G=d(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1q6eyx4"&&(G.textContent=sa),Rr=l(e),Z=d(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-ar7q77"&&(Z.innerHTML=oa),Ur=l(e),Q=d(e,"TABLE",{"data-svelte-h":!0}),c(Q)!=="svelte-klyf4z"&&(Q.innerHTML=la),zr=l(e),Dr=d(e,"HR",{}),Br=l(e),X=d(e,"A",{id:!0,class:!0}),f(X).forEach(r),Wr=l(e),n(V.$$.fragment,e),Nr=l(e),Y=d(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-10g8wi9"&&(Y.textContent=aa),Gr=l(e),q=d(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-cd20o3"&&(q.innerHTML=da),Zr=l(e),S=d(e,"TABLE",{"data-svelte-h":!0}),c(S)!=="svelte-nvuziu"&&(S.innerHTML=ca),Qr=l(e),Xr=d(e,"HR",{}),Vr=l(e),K=d(e,"A",{id:!0,class:!0}),f(K).forEach(r),Yr=l(e),n(O.$$.fragment,e),qr=l(e),ee=d(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1ljq1px"&&(ee.textContent=ia),Sr=l(e),te=d(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-1pa0uk8"&&(te.innerHTML=pa),Kr=l(e),re=d(e,"TABLE",{"data-svelte-h":!0}),c(re)!=="svelte-74khbv"&&(re.innerHTML=na),Or=l(e),es=d(e,"HR",{}),ts=l(e),se=d(e,"A",{id:!0,class:!0}),f(se).forEach(r),rs=l(e),n(oe.$$.fragment,e),ss=l(e),le=d(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-y1gxwn"&&(le.textContent=ma),os=l(e),ae=d(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-1xz91ac"&&(ae.innerHTML=ua),ls=l(e),de=d(e,"UL",{"data-svelte-h":!0}),c(de)!=="svelte-1ezq2y6"&&(de.innerHTML=ha),as=l(e),ds=d(e,"HR",{}),cs=l(e),ce=d(e,"A",{id:!0,class:!0}),f(ce).forEach(r),is=l(e),n(ie.$$.fragment,e),ps=l(e),pe=d(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1qlqxsv"&&(pe.textContent=_a),ns=l(e),ne=d(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-6tjpr7"&&(ne.innerHTML=fa),ms=l(e),me=d(e,"TABLE",{"data-svelte-h":!0}),c(me)!=="svelte-1hxx2o3"&&(me.innerHTML=ba),us=l(e),hs=d(e,"HR",{}),_s=l(e),ue=d(e,"A",{id:!0,class:!0}),f(ue).forEach(r),fs=l(e),n(he.$$.fragment,e),bs=l(e),_e=d(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-j2v54d"&&(_e.innerHTML=Ta),Ts=l(e),gs=d(e,"HR",{}),xs=l(e),fe=d(e,"A",{id:!0,class:!0}),f(fe).forEach(r),ys=l(e),n(be.$$.fragment,e),vs=l(e),Te=d(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-75c7d5"&&(Te.innerHTML=ga),Ms=l(e),ge=d(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-o8p6wm"&&(ge.innerHTML=xa),$s=l(e),xe=d(e,"TABLE",{"data-svelte-h":!0}),c(xe)!=="svelte-yqya7v"&&(xe.innerHTML=ya),ws=l(e),Es=d(e,"HR",{}),Js=l(e),ye=d(e,"A",{id:!0,class:!0}),f(ye).forEach(r),js=l(e),n(ve.$$.fragment,e),Cs=l(e),Me=d(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-gl8gb6"&&(Me.textContent=va),Ps=l(e),$e=d(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1qxvzd2"&&($e.innerHTML=Ma),ks=l(e),we=d(e,"TABLE",{"data-svelte-h":!0}),c(we)!=="svelte-1f7z42u"&&(we.innerHTML=$a),Hs=l(e),Is=d(e,"HR",{}),Fs=l(e),Ee=d(e,"A",{id:!0,class:!0}),f(Ee).forEach(r),Ls=l(e),n(Je.$$.fragment,e),As=l(e),je=d(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-7vs1p7"&&(je.textContent=wa),Rs=l(e),Ce=d(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-15rcpil"&&(Ce.innerHTML=Ea),Us=l(e),Pe=d(e,"TABLE",{"data-svelte-h":!0}),c(Pe)!=="svelte-3xdz32"&&(Pe.innerHTML=Ja),zs=l(e),Ds=d(e,"HR",{}),Bs=l(e),ke=d(e,"A",{id:!0,class:!0}),f(ke).forEach(r),Ws=l(e),n(He.$$.fragment,e),Ns=l(e),Ie=d(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-frdp8m"&&(Ie.textContent=ja),Gs=l(e),Fe=d(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-j2v54d"&&(Fe.innerHTML=Ca),Zs=l(e),Le=d(e,"TABLE",{"data-svelte-h":!0}),c(Le)!=="svelte-11rkhka"&&(Le.innerHTML=Pa),Qs=l(e),Xs=d(e,"HR",{}),Vs=l(e),Ae=d(e,"A",{id:!0,class:!0}),f(Ae).forEach(r),Ys=l(e),n(Re.$$.fragment,e),qs=l(e),Ue=d(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-o9f953"&&(Ue.textContent=ka),Ss=l(e),ze=d(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-fac4cj"&&(ze.innerHTML=Ha),Ks=l(e),De=d(e,"UL",{"data-svelte-h":!0}),c(De)!=="svelte-1v579im"&&(De.innerHTML=Ia),Os=l(e),eo=d(e,"HR",{}),to=l(e),Be=d(e,"A",{id:!0,class:!0}),f(Be).forEach(r),ro=l(e),n(We.$$.fragment,e),so=l(e),Ne=d(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-1naom0u"&&(Ne.textContent=Fa),oo=l(e),Ge=d(e,"TABLE",{"data-svelte-h":!0}),c(Ge)!=="svelte-ilxs6c"&&(Ge.innerHTML=La),lo=l(e),ao=d(e,"HR",{}),co=l(e),Ze=d(e,"A",{id:!0,class:!0}),f(Ze).forEach(r),io=l(e),n(Qe.$$.fragment,e),po=l(e),Xe=d(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-zbbm3j"&&(Xe.textContent=Aa),no=l(e),Ve=d(e,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-kflsb2"&&(Ve.innerHTML=Ra),mo=l(e),Ye=d(e,"TABLE",{"data-svelte-h":!0}),c(Ye)!=="svelte-pm1u9z"&&(Ye.innerHTML=Ua),uo=l(e),ho=d(e,"HR",{}),_o=l(e),qe=d(e,"A",{id:!0,class:!0}),f(qe).forEach(r),fo=l(e),n(Se.$$.fragment,e),bo=l(e),Ke=d(e,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-17pib55"&&(Ke.textContent=za),To=l(e),Oe=d(e,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-1ljhyyr"&&(Oe.innerHTML=Da),go=l(e),xo=d(e,"HR",{}),yo=l(e),et=d(e,"A",{id:!0,class:!0}),f(et).forEach(r),vo=l(e),n(tt.$$.fragment,e),Mo=l(e),rt=d(e,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-r5x3fh"&&(rt.textContent=Ba),$o=l(e),st=d(e,"P",{"data-svelte-h":!0}),c(st)!=="svelte-1vpvonk"&&(st.innerHTML=Wa),wo=l(e),ot=d(e,"TABLE",{"data-svelte-h":!0}),c(ot)!=="svelte-nv3lon"&&(ot.innerHTML=Na),Eo=l(e),Jo=d(e,"HR",{}),jo=l(e),lt=d(e,"A",{id:!0,class:!0}),f(lt).forEach(r),Co=l(e),n(at.$$.fragment,e),Po=l(e),dt=d(e,"P",{"data-svelte-h":!0}),c(dt)!=="svelte-62dsf9"&&(dt.innerHTML=Ga),ko=l(e),ct=d(e,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-11vd43e"&&(ct.innerHTML=Za),Ho=l(e),n(it.$$.fragment,e),Io=l(e),pt=d(e,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-c0cgha"&&(pt.innerHTML=Qa),Fo=l(e),n(nt.$$.fragment,e),Lo=l(e),mt=d(e,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-wmyz1o"&&(mt.innerHTML=Xa),Ao=l(e),Ro=d(e,"HR",{}),Uo=l(e),ut=d(e,"A",{id:!0,class:!0}),f(ut).forEach(r),zo=l(e),n(ht.$$.fragment,e),Do=l(e),_t=d(e,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-jwfdp9"&&(_t.textContent=Va),Bo=l(e),ft=d(e,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-t85gxq"&&(ft.innerHTML=Ya),Wo=l(e),bt=d(e,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-y7m8db"&&(bt.innerHTML=qa),No=l(e),Tt=d(e,"TABLE",{"data-svelte-h":!0}),c(Tt)!=="svelte-1oj79mt"&&(Tt.innerHTML=Sa),Go=l(e),Zo=d(e,"HR",{}),Qo=l(e),gt=d(e,"A",{id:!0,class:!0}),f(gt).forEach(r),Xo=l(e),n(xt.$$.fragment,e),Vo=l(e),yt=d(e,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-kjzox5"&&(yt.textContent=Ka),Yo=l(e),vt=d(e,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-19qboln"&&(vt.innerHTML=Oa),qo=l(e),Mt=d(e,"TABLE",{"data-svelte-h":!0}),c(Mt)!=="svelte-1bv5sxq"&&(Mt.innerHTML=ed),So=l(e),Ko=d(e,"HR",{}),Oo=l(e),$t=d(e,"A",{id:!0,class:!0}),f($t).forEach(r),el=l(e),n(wt.$$.fragment,e),tl=l(e),Et=d(e,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-16rftxc"&&(Et.textContent=td),rl=l(e),Jt=d(e,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-1tnxmuc"&&(Jt.innerHTML=rd),sl=l(e),jt=d(e,"TABLE",{"data-svelte-h":!0}),c(jt)!=="svelte-16qfwhw"&&(jt.innerHTML=sd),ol=l(e),ll=d(e,"HR",{}),al=l(e),Ct=d(e,"A",{id:!0,class:!0}),f(Ct).forEach(r),dl=l(e),n(Pt.$$.fragment,e),cl=l(e),kt=d(e,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-164871i"&&(kt.innerHTML=od),il=l(e),pl=d(e,"HR",{}),nl=l(e),Ht=d(e,"A",{id:!0,class:!0}),f(Ht).forEach(r),ml=l(e),n(It.$$.fragment,e),ul=l(e),Ft=d(e,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-2u8xbp"&&(Ft.textContent=ld),hl=l(e),Lt=d(e,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-3xndnt"&&(Lt.innerHTML=ad),_l=l(e),fl=d(e,"HR",{}),bl=l(e),At=d(e,"A",{id:!0,class:!0}),f(At).forEach(r),Tl=l(e),n(Rt.$$.fragment,e),gl=l(e),Ut=d(e,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-cy5pwv"&&(Ut.innerHTML=dd),xl=l(e),zt=d(e,"TABLE",{"data-svelte-h":!0}),c(zt)!=="svelte-1dyar84"&&(zt.innerHTML=cd),yl=l(e),vl=d(e,"HR",{}),Ml=l(e),Dt=d(e,"A",{id:!0,class:!0}),f(Dt).forEach(r),$l=l(e),n(Bt.$$.fragment,e),wl=l(e),Wt=d(e,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-cy5pwv"&&(Wt.innerHTML=id),El=l(e),Nt=d(e,"TABLE",{"data-svelte-h":!0}),c(Nt)!=="svelte-1cnys15"&&(Nt.innerHTML=pd),Jl=l(e),jl=d(e,"HR",{}),Cl=l(e),Gt=d(e,"A",{id:!0,class:!0}),f(Gt).forEach(r),Pl=l(e),n(Zt.$$.fragment,e),kl=l(e),Qt=d(e,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-cy5pwv"&&(Qt.innerHTML=nd),Hl=l(e),Xt=d(e,"TABLE",{"data-svelte-h":!0}),c(Xt)!=="svelte-179cln2"&&(Xt.innerHTML=md),Il=l(e),Fl=d(e,"HR",{}),Ll=l(e),Vt=d(e,"A",{id:!0,class:!0}),f(Vt).forEach(r),Al=l(e),n(Yt.$$.fragment,e),Rl=l(e),qt=d(e,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-cy5pwv"&&(qt.innerHTML=ud),Ul=l(e),St=d(e,"TABLE",{"data-svelte-h":!0}),c(St)!=="svelte-1btb1vt"&&(St.innerHTML=hd),zl=l(e),Dl=d(e,"HR",{}),Bl=l(e),Ot=d(e,"P",{}),f(Ot).forEach(r),this.h()},h(){i(T,"name","hf:doc:metadata"),i(T,"content",Md),i(g,"id","module_processors"),i(g,"class","group"),i(w,"id","module_processors.FeatureExtractor"),i(w,"class","group"),i(C,"id","new_module_processors.FeatureExtractor_new"),i(C,"class","group"),i(I,"id","module_processors.ImageFeatureExtractor"),i(I,"class","group"),i(U,"id","new_module_processors.ImageFeatureExtractor_new"),i(U,"class","group"),i(W,"id","module_processors.ImageFeatureExtractor+thumbnail"),i(W,"class","group"),i(X,"id","module_processors.ImageFeatureExtractor+preprocess"),i(X,"class","group"),i(K,"id","module_processors.ImageFeatureExtractor+_call"),i(K,"class","group"),i(se,"id","module_processors.DetrFeatureExtractor"),i(se,"class","group"),i(ce,"id","module_processors.DetrFeatureExtractor+_call"),i(ce,"class","group"),i(ue,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),i(ue,"class","group"),i(fe,"id","module_processors.DetrFeatureExtractor+remove_low_and_no_objects"),i(fe,"class","group"),i(ye,"id","module_processors.DetrFeatureExtractor+check_segment_validity"),i(ye,"class","group"),i(Ee,"id","module_processors.DetrFeatureExtractor+compute_segments"),i(Ee,"class","group"),i(ke,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),i(ke,"class","group"),i(Ae,"id","module_processors.Processor"),i(Ae,"class","group"),i(Be,"id","new_module_processors.Processor_new"),i(Be,"class","group"),i(Ze,"id","module_processors.Processor+_call"),i(Ze,"class","group"),i(qe,"id","module_processors.WhisperProcessor"),i(qe,"class","group"),i(et,"id","module_processors.WhisperProcessor+_call"),i(et,"class","group"),i(lt,"id","module_processors.AutoProcessor"),i(lt,"class","group"),i(ut,"id","module_processors.AutoProcessor.from_pretrained"),i(ut,"class","group"),i(gt,"id","module_processors..center_to_corners_format"),i(gt,"class","group"),i($t,"id","module_processors..post_process_object_detection"),i($t,"class","group"),i(Ct,"id","module_processors..post_process_object_detection..box"),i(Ct,"class","group"),i(Ht,"id","module_processors..HeightWidth"),i(Ht,"class","group"),i(At,"id","module_processors..ImageFeatureExtractorResult"),i(At,"class","group"),i(Dt,"id","module_processors..PreprocessedImage"),i(Dt,"class","group"),i(Gt,"id","module_processors..DetrFeatureExtractorResult"),i(Gt,"class","group"),i(Vt,"id","module_processors..SamImageProcessorResult"),i(Vt,"class","group")},m(e,t){yd(document.head,T),s(e,er,t),s(e,Kt,t),s(e,tr,t),s(e,g,t),s(e,rr,t),m(x,e,t),s(e,sr,t),s(e,y,t),s(e,or,t),s(e,v,t),s(e,lr,t),m(M,e,t),s(e,ar,t),s(e,$,t),s(e,dr,t),s(e,cr,t),s(e,ir,t),s(e,w,t),s(e,pr,t),m(E,e,t),s(e,nr,t),s(e,J,t),s(e,mr,t),s(e,j,t),s(e,ur,t),s(e,hr,t),s(e,_r,t),s(e,C,t),s(e,fr,t),m(P,e,t),s(e,br,t),s(e,k,t),s(e,Tr,t),s(e,H,t),s(e,gr,t),s(e,xr,t),s(e,yr,t),s(e,I,t),s(e,vr,t),m(F,e,t),s(e,Mr,t),s(e,L,t),s(e,$r,t),s(e,A,t),s(e,wr,t),s(e,R,t),s(e,Er,t),s(e,Jr,t),s(e,jr,t),s(e,U,t),s(e,Cr,t),m(z,e,t),s(e,Pr,t),s(e,D,t),s(e,kr,t),s(e,B,t),s(e,Hr,t),s(e,Ir,t),s(e,Fr,t),s(e,W,t),s(e,Lr,t),m(N,e,t),s(e,Ar,t),s(e,G,t),s(e,Rr,t),s(e,Z,t),s(e,Ur,t),s(e,Q,t),s(e,zr,t),s(e,Dr,t),s(e,Br,t),s(e,X,t),s(e,Wr,t),m(V,e,t),s(e,Nr,t),s(e,Y,t),s(e,Gr,t),s(e,q,t),s(e,Zr,t),s(e,S,t),s(e,Qr,t),s(e,Xr,t),s(e,Vr,t),s(e,K,t),s(e,Yr,t),m(O,e,t),s(e,qr,t),s(e,ee,t),s(e,Sr,t),s(e,te,t),s(e,Kr,t),s(e,re,t),s(e,Or,t),s(e,es,t),s(e,ts,t),s(e,se,t),s(e,rs,t),m(oe,e,t),s(e,ss,t),s(e,le,t),s(e,os,t),s(e,ae,t),s(e,ls,t),s(e,de,t),s(e,as,t),s(e,ds,t),s(e,cs,t),s(e,ce,t),s(e,is,t),m(ie,e,t),s(e,ps,t),s(e,pe,t),s(e,ns,t),s(e,ne,t),s(e,ms,t),s(e,me,t),s(e,us,t),s(e,hs,t),s(e,_s,t),s(e,ue,t),s(e,fs,t),m(he,e,t),s(e,bs,t),s(e,_e,t),s(e,Ts,t),s(e,gs,t),s(e,xs,t),s(e,fe,t),s(e,ys,t),m(be,e,t),s(e,vs,t),s(e,Te,t),s(e,Ms,t),s(e,ge,t),s(e,$s,t),s(e,xe,t),s(e,ws,t),s(e,Es,t),s(e,Js,t),s(e,ye,t),s(e,js,t),m(ve,e,t),s(e,Cs,t),s(e,Me,t),s(e,Ps,t),s(e,$e,t),s(e,ks,t),s(e,we,t),s(e,Hs,t),s(e,Is,t),s(e,Fs,t),s(e,Ee,t),s(e,Ls,t),m(Je,e,t),s(e,As,t),s(e,je,t),s(e,Rs,t),s(e,Ce,t),s(e,Us,t),s(e,Pe,t),s(e,zs,t),s(e,Ds,t),s(e,Bs,t),s(e,ke,t),s(e,Ws,t),m(He,e,t),s(e,Ns,t),s(e,Ie,t),s(e,Gs,t),s(e,Fe,t),s(e,Zs,t),s(e,Le,t),s(e,Qs,t),s(e,Xs,t),s(e,Vs,t),s(e,Ae,t),s(e,Ys,t),m(Re,e,t),s(e,qs,t),s(e,Ue,t),s(e,Ss,t),s(e,ze,t),s(e,Ks,t),s(e,De,t),s(e,Os,t),s(e,eo,t),s(e,to,t),s(e,Be,t),s(e,ro,t),m(We,e,t),s(e,so,t),s(e,Ne,t),s(e,oo,t),s(e,Ge,t),s(e,lo,t),s(e,ao,t),s(e,co,t),s(e,Ze,t),s(e,io,t),m(Qe,e,t),s(e,po,t),s(e,Xe,t),s(e,no,t),s(e,Ve,t),s(e,mo,t),s(e,Ye,t),s(e,uo,t),s(e,ho,t),s(e,_o,t),s(e,qe,t),s(e,fo,t),m(Se,e,t),s(e,bo,t),s(e,Ke,t),s(e,To,t),s(e,Oe,t),s(e,go,t),s(e,xo,t),s(e,yo,t),s(e,et,t),s(e,vo,t),m(tt,e,t),s(e,Mo,t),s(e,rt,t),s(e,$o,t),s(e,st,t),s(e,wo,t),s(e,ot,t),s(e,Eo,t),s(e,Jo,t),s(e,jo,t),s(e,lt,t),s(e,Co,t),m(at,e,t),s(e,Po,t),s(e,dt,t),s(e,ko,t),s(e,ct,t),s(e,Ho,t),m(it,e,t),s(e,Io,t),s(e,pt,t),s(e,Fo,t),m(nt,e,t),s(e,Lo,t),s(e,mt,t),s(e,Ao,t),s(e,Ro,t),s(e,Uo,t),s(e,ut,t),s(e,zo,t),m(ht,e,t),s(e,Do,t),s(e,_t,t),s(e,Bo,t),s(e,ft,t),s(e,Wo,t),s(e,bt,t),s(e,No,t),s(e,Tt,t),s(e,Go,t),s(e,Zo,t),s(e,Qo,t),s(e,gt,t),s(e,Xo,t),m(xt,e,t),s(e,Vo,t),s(e,yt,t),s(e,Yo,t),s(e,vt,t),s(e,qo,t),s(e,Mt,t),s(e,So,t),s(e,Ko,t),s(e,Oo,t),s(e,$t,t),s(e,el,t),m(wt,e,t),s(e,tl,t),s(e,Et,t),s(e,rl,t),s(e,Jt,t),s(e,sl,t),s(e,jt,t),s(e,ol,t),s(e,ll,t),s(e,al,t),s(e,Ct,t),s(e,dl,t),m(Pt,e,t),s(e,cl,t),s(e,kt,t),s(e,il,t),s(e,pl,t),s(e,nl,t),s(e,Ht,t),s(e,ml,t),m(It,e,t),s(e,ul,t),s(e,Ft,t),s(e,hl,t),s(e,Lt,t),s(e,_l,t),s(e,fl,t),s(e,bl,t),s(e,At,t),s(e,Tl,t),m(Rt,e,t),s(e,gl,t),s(e,Ut,t),s(e,xl,t),s(e,zt,t),s(e,yl,t),s(e,vl,t),s(e,Ml,t),s(e,Dt,t),s(e,$l,t),m(Bt,e,t),s(e,wl,t),s(e,Wt,t),s(e,El,t),s(e,Nt,t),s(e,Jl,t),s(e,jl,t),s(e,Cl,t),s(e,Gt,t),s(e,Pl,t),m(Zt,e,t),s(e,kl,t),s(e,Qt,t),s(e,Hl,t),s(e,Xt,t),s(e,Il,t),s(e,Fl,t),s(e,Ll,t),s(e,Vt,t),s(e,Al,t),m(Yt,e,t),s(e,Rl,t),s(e,qt,t),s(e,Ul,t),s(e,St,t),s(e,zl,t),s(e,Dl,t),s(e,Bl,t),s(e,Ot,t),Wl=!0},p:fd,i(e){Wl||(u(x.$$.fragment,e),u(M.$$.fragment,e),u(E.$$.fragment,e),u(P.$$.fragment,e),u(F.$$.fragment,e),u(z.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(O.$$.fragment,e),u(oe.$$.fragment,e),u(ie.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(ve.$$.fragment,e),u(Je.$$.fragment,e),u(He.$$.fragment,e),u(Re.$$.fragment,e),u(We.$$.fragment,e),u(Qe.$$.fragment,e),u(Se.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(it.$$.fragment,e),u(nt.$$.fragment,e),u(ht.$$.fragment,e),u(xt.$$.fragment,e),u(wt.$$.fragment,e),u(Pt.$$.fragment,e),u(It.$$.fragment,e),u(Rt.$$.fragment,e),u(Bt.$$.fragment,e),u(Zt.$$.fragment,e),u(Yt.$$.fragment,e),Wl=!0)},o(e){h(x.$$.fragment,e),h(M.$$.fragment,e),h(E.$$.fragment,e),h(P.$$.fragment,e),h(F.$$.fragment,e),h(z.$$.fragment,e),h(N.$$.fragment,e),h(V.$$.fragment,e),h(O.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(he.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(Je.$$.fragment,e),h(He.$$.fragment,e),h(Re.$$.fragment,e),h(We.$$.fragment,e),h(Qe.$$.fragment,e),h(Se.$$.fragment,e),h(tt.$$.fragment,e),h(at.$$.fragment,e),h(it.$$.fragment,e),h(nt.$$.fragment,e),h(ht.$$.fragment,e),h(xt.$$.fragment,e),h(wt.$$.fragment,e),h(Pt.$$.fragment,e),h(It.$$.fragment,e),h(Rt.$$.fragment,e),h(Bt.$$.fragment,e),h(Zt.$$.fragment,e),h(Yt.$$.fragment,e),Wl=!1},d(e){e&&(r(er),r(Kt),r(tr),r(g),r(rr),r(sr),r(y),r(or),r(v),r(lr),r(ar),r($),r(dr),r(cr),r(ir),r(w),r(pr),r(nr),r(J),r(mr),r(j),r(ur),r(hr),r(_r),r(C),r(fr),r(br),r(k),r(Tr),r(H),r(gr),r(xr),r(yr),r(I),r(vr),r(Mr),r(L),r($r),r(A),r(wr),r(R),r(Er),r(Jr),r(jr),r(U),r(Cr),r(Pr),r(D),r(kr),r(B),r(Hr),r(Ir),r(Fr),r(W),r(Lr),r(Ar),r(G),r(Rr),r(Z),r(Ur),r(Q),r(zr),r(Dr),r(Br),r(X),r(Wr),r(Nr),r(Y),r(Gr),r(q),r(Zr),r(S),r(Qr),r(Xr),r(Vr),r(K),r(Yr),r(qr),r(ee),r(Sr),r(te),r(Kr),r(re),r(Or),r(es),r(ts),r(se),r(rs),r(ss),r(le),r(os),r(ae),r(ls),r(de),r(as),r(ds),r(cs),r(ce),r(is),r(ps),r(pe),r(ns),r(ne),r(ms),r(me),r(us),r(hs),r(_s),r(ue),r(fs),r(bs),r(_e),r(Ts),r(gs),r(xs),r(fe),r(ys),r(vs),r(Te),r(Ms),r(ge),r($s),r(xe),r(ws),r(Es),r(Js),r(ye),r(js),r(Cs),r(Me),r(Ps),r($e),r(ks),r(we),r(Hs),r(Is),r(Fs),r(Ee),r(Ls),r(As),r(je),r(Rs),r(Ce),r(Us),r(Pe),r(zs),r(Ds),r(Bs),r(ke),r(Ws),r(Ns),r(Ie),r(Gs),r(Fe),r(Zs),r(Le),r(Qs),r(Xs),r(Vs),r(Ae),r(Ys),r(qs),r(Ue),r(Ss),r(ze),r(Ks),r(De),r(Os),r(eo),r(to),r(Be),r(ro),r(so),r(Ne),r(oo),r(Ge),r(lo),r(ao),r(co),r(Ze),r(io),r(po),r(Xe),r(no),r(Ve),r(mo),r(Ye),r(uo),r(ho),r(_o),r(qe),r(fo),r(bo),r(Ke),r(To),r(Oe),r(go),r(xo),r(yo),r(et),r(vo),r(Mo),r(rt),r($o),r(st),r(wo),r(ot),r(Eo),r(Jo),r(jo),r(lt),r(Co),r(Po),r(dt),r(ko),r(ct),r(Ho),r(Io),r(pt),r(Fo),r(Lo),r(mt),r(Ao),r(Ro),r(Uo),r(ut),r(zo),r(Do),r(_t),r(Bo),r(ft),r(Wo),r(bt),r(No),r(Tt),r(Go),r(Zo),r(Qo),r(gt),r(Xo),r(Vo),r(yt),r(Yo),r(vt),r(qo),r(Mt),r(So),r(Ko),r(Oo),r($t),r(el),r(tl),r(Et),r(rl),r(Jt),r(sl),r(jt),r(ol),r(ll),r(al),r(Ct),r(dl),r(cl),r(kt),r(il),r(pl),r(nl),r(Ht),r(ml),r(ul),r(Ft),r(hl),r(Lt),r(_l),r(fl),r(bl),r(At),r(Tl),r(gl),r(Ut),r(xl),r(zt),r(yl),r(vl),r(Ml),r(Dt),r($l),r(wl),r(Wt),r(El),r(Nt),r(Jl),r(jl),r(Cl),r(Gt),r(Pl),r(kl),r(Qt),r(Hl),r(Xt),r(Il),r(Fl),r(Ll),r(Vt),r(Al),r(Rl),r(qt),r(Ul),r(St),r(zl),r(Dl),r(Bl),r(Ot)),r(T),_(x,e),_(M,e),_(E,e),_(P,e),_(F,e),_(z,e),_(N,e),_(V,e),_(O,e),_(oe,e),_(ie,e),_(he,e),_(be,e),_(ve,e),_(Je,e),_(He,e),_(Re,e),_(We,e),_(Qe,e),_(Se,e),_(tt,e),_(at,e),_(it,e),_(nt,e),_(ht,e),_(xt,e),_(wt,e),_(Pt,e),_(It,e),_(Rt,e),_(Bt,e),_(Zt,e),_(Yt,e)}}}const Md='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(urls) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallurls--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>","local":"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code","sections":[],"depth":3},{"title":"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>","local":"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>","local":"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>","local":"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~post_process_object_detection(outputs) ⇒ <code> Array. < Object > </code>","local":"processorspostprocessobjectdetectionoutputs--code-array--object--code","sections":[{"title":"post_process_object_detection~box : <code> Array. < number > </code>","local":"postprocessobjectdetectionbox--code-array--number--code","sections":[],"depth":3}],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function $d(Gl){return bd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cd extends Td{constructor(T){super(),gd(this,T,$d,vd,_d,{})}}export{Cd as component};
