import{s as ct,n as ut,o as ft}from"../chunks/scheduler.9991993c.js";import{S as dt,i as Mt,g as o,s as n,r as i,A as Tt,h as p,f as l,c as a,j as it,u as m,x as r,k as mt,y as yt,a as s,v as c,d as u,t as f,w as d}from"../chunks/index.7fc9a5e7.js";import{C as T}from"../chunks/CodeBlock.e11cba92.js";import{D as wt}from"../chunks/DocNotebookDropdown.a0cb4c0f.js";import{H as te}from"../chunks/Heading.e3de321f.js";function Jt(Le){let M,le,O,se,y,ne,w,ae,J,Ee='加速线性代数，也称为XLA，是一个用于加速TensorFlow模型运行时间的编译器。从<a href="https://www.tensorflow.org/xla" rel="nofollow">官方文档</a>中可以看到：',oe,b,Ye="XLA（加速线性代数）是一种针对线性代数的特定领域编译器，可以在可能不需要更改源代码的情况下加速TensorFlow模型。",pe,h,He='在TensorFlow中使用XLA非常简单——它包含在<code>tensorflow</code>库中，并且可以使用任何图创建函数中的<code>jit_compile</code>参数来触发，例如<a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>。在使用Keras方法如<code>fit()</code>和<code>predict()</code>时，只需将<code>jit_compile</code>参数传递给<code>model.compile()</code>即可启用XLA。然而，XLA不仅限于这些方法 - 它还可以用于加速任何任意的<code>tf.function</code>。',re,U,Ne='在🤗 Transformers中，几个TensorFlow方法已经被重写为与XLA兼容，包括<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>、<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>和<a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>等文本生成模型，以及<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>等语音处理模型。',ie,g,Qe="虽然确切的加速倍数很大程度上取决于模型，但对于🤗 Transformers中的TensorFlow文本生成模型，我们注意到速度提高了约100倍。本文档将解释如何在这些模型上使用XLA获得最大的性能。如果您有兴趣了解更多关于基准测试和我们在XLA集成背后的设计哲学的信息，我们还将提供额外的资源链接。",me,j,ce,Z,qe="让我们考虑以下TensorFlow 中的模型：",ue,_,fe,X,Ae="上述模型接受维度为 <code>(10,)</code> 的输入。我们可以像下面这样使用模型进行前向传播：",de,k,Me,G,Se="为了使用 XLA 编译的函数运行前向传播，我们需要执行以下操作：",Te,R,ye,I,Pe="<code>model</code>的默认<code>call()</code>函数用于编译XLA图。但如果你想将其他模型函数编译成XLA，也是可以的，如下所示：",we,W,Je,V,be,F,De="要在🤗 Transformers中启用XLA加速生成，您需要安装最新版本的<code>transformers</code>。您可以通过运行以下命令来安装它：",he,$,Ue,C,Ke="然后您可以运行以下代码：",ge,v,je,x,Oe="正如您所注意到的，在<code>generate()</code>上启用XLA只需要一行代码。其余部分代码保持不变。然而，上面的代码片段中有一些与XLA相关的注意事项。您需要了解这些注意事项，以充分利用XLA可能带来的性能提升。我们将在下面的部分讨论这些内容。",Ze,B,_e,z,et='当您首次执行启用XLA的函数（如上面的<code>xla_generate()</code>）时，它将在内部尝试推断计算图，这是一个耗时的过程。这个过程被称为<a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“tracing”</a>。',Xe,L,tt="您可能会注意到生成时间并不快。连续调用<code>xla_generate()</code>（或任何其他启用了XLA的函数）不需要再次推断计算图，只要函数的输入与最初构建计算图时的形状相匹配。对于具有固定输入形状的模态（例如图像），这不是问题，但如果您正在处理具有可变输入形状的模态（例如文本），则必须注意。",ke,E,lt="为了确保<code>xla_generate()</code>始终使用相同的输入形状，您可以在调用<code>tokenizer</code>时指定<code>padding</code>参数。",Ge,Y,Re,H,st="通过这种方式，您可以确保<code>xla_generate()</code>的输入始终具有它跟踪的形状，从而加速生成时间。您可以使用以下代码来验证这一点：",Ie,N,We,Q,nt="在Tesla T4 GPU上，您可以期望如下的输出：",Ve,q,Fe,A,at="第一次调用<code>xla_generate()</code>会因为<code>tracing</code>而耗时，但后续的调用会快得多。请注意，任何时候对生成选项的更改都会触发重新<code>tracing</code>，从而导致生成时间减慢。",$e,S,ot="在本文档中，我们没有涵盖🤗 Transformers提供的所有文本生成选项。我们鼓励您阅读文档以了解高级用例。",Ce,P,ve,D,pt="以下是一些附加资源，如果您想深入了解在🤗 Transformers和其他库下使用XLA：",xe,K,rt='<li><p><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">这个Colab Notebook</a> 提供了一个互动演示，让您可以尝试使用XLA兼容的编码器-解码器（例如<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>）和仅解码器（例如<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>）文本生成模型。</p></li> <li><p><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">这篇博客文章</a> 提供了XLA兼容模型的比较基准概述，以及关于在TensorFlow中使用XLA的友好介绍。</p></li> <li><p><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">这篇博客文章</a> 讨论了我们在🤗 Transformers中为TensorFlow模型添加XLA支持的设计理念。</p></li> <li><p>推荐用于更多学习XLA和TensorFlow图的资源：</p> <ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA：面向机器学习的优化编译器</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">图和tf.function简介</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow">使用tf.function获得更好的性能</a></li></ul></li>',Be,ee,ze;return y=new te({props:{title:"用于 TensorFlow 模型的 XLA 集成",local:"用于-tensorflow-模型的-xla-集成",headingTag:"h1"}}),w=new wt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/tf_xla.ipynb"}]}}),j=new te({props:{title:"使用 XLA 运行 TensorFlow 函数",local:"使用-xla-运行-tensorflow-函数",headingTag:"h2"}}),_=new T({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`,wrap:!1}}),k=new T({props:{code:"JTIzJTIwR2VuZXJhdGUlMjByYW5kb20lMjBpbnB1dHMlMjBmb3IlMjB0aGUlMjBtb2RlbC4lMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFpbnB1dF92ZWN0b3JfZGltJTIwJTNEJTIwMTAlMEFyYW5kb21faW5wdXRzJTIwJTNEJTIwdGYucmFuZG9tLm5vcm1hbCgoYmF0Y2hfc2l6ZSUyQyUyMGlucHV0X3ZlY3Rvcl9kaW0pKSUwQSUwQSUyMyUyMFJ1biUyMGElMjBmb3J3YXJkJTIwcGFzcy4lMEFfJTIwJTNEJTIwbW9kZWwocmFuZG9tX2lucHV0cyk=",highlighted:`<span class="hljs-comment"># Generate random inputs for the model.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># Run a forward pass.</span>
_ = model(random_inputs)`,wrap:!1}}),R=new T({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`,wrap:!1}}),W=new T({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),V=new te({props:{title:"在🤗 Transformers库中使用XLA运行TensorFlow文本生成模型",local:"在-transformers库中使用xla运行tensorflow文本生成模型",headingTag:"h2"}}),$=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade",wrap:!1}}),v=new T({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBXaWxsJTIwZXJyb3IlMjBpZiUyMHRoZSUyMG1pbmltYWwlMjB2ZXJzaW9uJTIwb2YlMjBUcmFuc2Zvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZC4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnV0aWxzJTIwaW1wb3J0JTIwY2hlY2tfbWluX3ZlcnNpb24lMEElMEFjaGVja19taW5fdmVyc2lvbiglMjI0LjIxLjAlMjIpJTBBJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQSUyMyUyME9uZSUyMGxpbmUlMjB0byUyMGNyZWF0ZSUyMGFuJTIwWExBJTIwZ2VuZXJhdGlvbiUyMGZ1bmN0aW9uJTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMiklMEElMjMlMjBHZW5lcmF0ZWQlMjAtLSUyMFRlbnNvckZsb3clMjBpcyUyMGFuJTIwb3Blbi1zb3VyY2UlMkMlMjBvcGVuLXNvdXJjZSUyQyUyMGRpc3RyaWJ1dGVkLXNvdXJjZSUyMGFwcGxpY2F0aW9uJTIwJTIzJTIwZnJhbWV3b3JrJTIwZm9yJTIwdGhl",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># Will error if the minimal version of Transformers is not installed.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># One line to create an XLA generation function</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`,wrap:!1}}),B=new te({props:{title:"需要关注的注意事项",local:"需要关注的注意事项",headingTag:"h2"}}),Y=new T({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBaW5wdXRfc3RyaW5nJTIwJTNEJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTVEJTBBJTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBJTIzJTIwSGVyZSUyQyUyMHdlJTIwY2FsbCUyMHRoZSUyMHRva2VuaXplciUyMHdpdGglMjBwYWRkaW5nJTIwb3B0aW9ucy4lMEF0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEFkZWNvZGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZiUyMkdlbmVyYXRlZCUyMC0tJTIwJTdCZGVjb2RlZF90ZXh0JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Here, we call the tokenizer with padding options.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),N=new T({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQWZvciUyMGlucHV0X3N0cmluZyUyMGluJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTJDJTIwJTIyVGVuc29yRmxvdyUyMGlzJTIwYSUyMiUyQyUyMCUyMlRGTGl0ZSUyMGlzJTIwYSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9zdHJpbmclMkMlMjBwYWRfdG9fbXVsdGlwbGVfb2YlM0Q4JTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUyMCUyMCUyMCUyMHN0YXJ0JTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEElMjAlMjAlMjAlMjBlbmQlMjAlM0QlMjB0aW1lLnRpbWVfbnMoKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJFeGVjdXRpb24lMjB0aW1lJTIwLS0lMjAlN0IoZW5kJTIwLSUyMHN0YXJ0KSUyMCUyRiUyMDFlNiUzQS4xZiU3RCUyMG1zJTVDbiUyMik=",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`,wrap:!1}}),q=new T({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`,wrap:!1}}),P=new te({props:{title:"附加资源",local:"附加资源",headingTag:"h2"}}),{c(){M=o("meta"),le=n(),O=o("p"),se=n(),i(y.$$.fragment),ne=n(),i(w.$$.fragment),ae=n(),J=o("p"),J.innerHTML=Ee,oe=n(),b=o("p"),b.textContent=Ye,pe=n(),h=o("p"),h.innerHTML=He,re=n(),U=o("p"),U.innerHTML=Ne,ie=n(),g=o("p"),g.textContent=Qe,me=n(),i(j.$$.fragment),ce=n(),Z=o("p"),Z.textContent=qe,ue=n(),i(_.$$.fragment),fe=n(),X=o("p"),X.innerHTML=Ae,de=n(),i(k.$$.fragment),Me=n(),G=o("p"),G.textContent=Se,Te=n(),i(R.$$.fragment),ye=n(),I=o("p"),I.innerHTML=Pe,we=n(),i(W.$$.fragment),Je=n(),i(V.$$.fragment),be=n(),F=o("p"),F.innerHTML=De,he=n(),i($.$$.fragment),Ue=n(),C=o("p"),C.textContent=Ke,ge=n(),i(v.$$.fragment),je=n(),x=o("p"),x.innerHTML=Oe,Ze=n(),i(B.$$.fragment),_e=n(),z=o("p"),z.innerHTML=et,Xe=n(),L=o("p"),L.innerHTML=tt,ke=n(),E=o("p"),E.innerHTML=lt,Ge=n(),i(Y.$$.fragment),Re=n(),H=o("p"),H.innerHTML=st,Ie=n(),i(N.$$.fragment),We=n(),Q=o("p"),Q.textContent=nt,Ve=n(),i(q.$$.fragment),Fe=n(),A=o("p"),A.innerHTML=at,$e=n(),S=o("p"),S.textContent=ot,Ce=n(),i(P.$$.fragment),ve=n(),D=o("p"),D.textContent=pt,xe=n(),K=o("ul"),K.innerHTML=rt,Be=n(),ee=o("p"),this.h()},l(e){const t=Tt("svelte-u9bgzb",document.head);M=p(t,"META",{name:!0,content:!0}),t.forEach(l),le=a(e),O=p(e,"P",{}),it(O).forEach(l),se=a(e),m(y.$$.fragment,e),ne=a(e),m(w.$$.fragment,e),ae=a(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1ab31dt"&&(J.innerHTML=Ee),oe=a(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1pvm1ip"&&(b.textContent=Ye),pe=a(e),h=p(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-r8rbc5"&&(h.innerHTML=He),re=a(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-p7rlbq"&&(U.innerHTML=Ne),ie=a(e),g=p(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1xuz7ym"&&(g.textContent=Qe),me=a(e),m(j.$$.fragment,e),ce=a(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1vn6z9m"&&(Z.textContent=qe),ue=a(e),m(_.$$.fragment,e),fe=a(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-edbqcr"&&(X.innerHTML=Ae),de=a(e),m(k.$$.fragment,e),Me=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1567hs3"&&(G.textContent=Se),Te=a(e),m(R.$$.fragment,e),ye=a(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1d2xanc"&&(I.innerHTML=Pe),we=a(e),m(W.$$.fragment,e),Je=a(e),m(V.$$.fragment,e),be=a(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1jrv2bf"&&(F.innerHTML=De),he=a(e),m($.$$.fragment,e),Ue=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1xbae7q"&&(C.textContent=Ke),ge=a(e),m(v.$$.fragment,e),je=a(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-k1gawp"&&(x.innerHTML=Oe),Ze=a(e),m(B.$$.fragment,e),_e=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ccko4b"&&(z.innerHTML=et),Xe=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1eerun3"&&(L.innerHTML=tt),ke=a(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-nx5jow"&&(E.innerHTML=lt),Ge=a(e),m(Y.$$.fragment,e),Re=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-a0s1z1"&&(H.innerHTML=st),Ie=a(e),m(N.$$.fragment,e),We=a(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-15o96gl"&&(Q.textContent=nt),Ve=a(e),m(q.$$.fragment,e),Fe=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ctf36t"&&(A.innerHTML=at),$e=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1qb1iwp"&&(S.textContent=ot),Ce=a(e),m(P.$$.fragment,e),ve=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-nhayyz"&&(D.textContent=pt),xe=a(e),K=p(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-11ijxsh"&&(K.innerHTML=rt),Be=a(e),ee=p(e,"P",{}),it(ee).forEach(l),this.h()},h(){mt(M,"name","hf:doc:metadata"),mt(M,"content",bt)},m(e,t){yt(document.head,M),s(e,le,t),s(e,O,t),s(e,se,t),c(y,e,t),s(e,ne,t),c(w,e,t),s(e,ae,t),s(e,J,t),s(e,oe,t),s(e,b,t),s(e,pe,t),s(e,h,t),s(e,re,t),s(e,U,t),s(e,ie,t),s(e,g,t),s(e,me,t),c(j,e,t),s(e,ce,t),s(e,Z,t),s(e,ue,t),c(_,e,t),s(e,fe,t),s(e,X,t),s(e,de,t),c(k,e,t),s(e,Me,t),s(e,G,t),s(e,Te,t),c(R,e,t),s(e,ye,t),s(e,I,t),s(e,we,t),c(W,e,t),s(e,Je,t),c(V,e,t),s(e,be,t),s(e,F,t),s(e,he,t),c($,e,t),s(e,Ue,t),s(e,C,t),s(e,ge,t),c(v,e,t),s(e,je,t),s(e,x,t),s(e,Ze,t),c(B,e,t),s(e,_e,t),s(e,z,t),s(e,Xe,t),s(e,L,t),s(e,ke,t),s(e,E,t),s(e,Ge,t),c(Y,e,t),s(e,Re,t),s(e,H,t),s(e,Ie,t),c(N,e,t),s(e,We,t),s(e,Q,t),s(e,Ve,t),c(q,e,t),s(e,Fe,t),s(e,A,t),s(e,$e,t),s(e,S,t),s(e,Ce,t),c(P,e,t),s(e,ve,t),s(e,D,t),s(e,xe,t),s(e,K,t),s(e,Be,t),s(e,ee,t),ze=!0},p:ut,i(e){ze||(u(y.$$.fragment,e),u(w.$$.fragment,e),u(j.$$.fragment,e),u(_.$$.fragment,e),u(k.$$.fragment,e),u(R.$$.fragment,e),u(W.$$.fragment,e),u(V.$$.fragment,e),u($.$$.fragment,e),u(v.$$.fragment,e),u(B.$$.fragment,e),u(Y.$$.fragment,e),u(N.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),ze=!0)},o(e){f(y.$$.fragment,e),f(w.$$.fragment,e),f(j.$$.fragment,e),f(_.$$.fragment,e),f(k.$$.fragment,e),f(R.$$.fragment,e),f(W.$$.fragment,e),f(V.$$.fragment,e),f($.$$.fragment,e),f(v.$$.fragment,e),f(B.$$.fragment,e),f(Y.$$.fragment,e),f(N.$$.fragment,e),f(q.$$.fragment,e),f(P.$$.fragment,e),ze=!1},d(e){e&&(l(le),l(O),l(se),l(ne),l(ae),l(J),l(oe),l(b),l(pe),l(h),l(re),l(U),l(ie),l(g),l(me),l(ce),l(Z),l(ue),l(fe),l(X),l(de),l(Me),l(G),l(Te),l(ye),l(I),l(we),l(Je),l(be),l(F),l(he),l(Ue),l(C),l(ge),l(je),l(x),l(Ze),l(_e),l(z),l(Xe),l(L),l(ke),l(E),l(Ge),l(Re),l(H),l(Ie),l(We),l(Q),l(Ve),l(Fe),l(A),l($e),l(S),l(Ce),l(ve),l(D),l(xe),l(K),l(Be),l(ee)),l(M),d(y,e),d(w,e),d(j,e),d(_,e),d(k,e),d(R,e),d(W,e),d(V,e),d($,e),d(v,e),d(B,e),d(Y,e),d(N,e),d(q,e),d(P,e)}}}const bt='{"title":"用于 TensorFlow 模型的 XLA 集成","local":"用于-tensorflow-模型的-xla-集成","sections":[{"title":"使用 XLA 运行 TensorFlow 函数","local":"使用-xla-运行-tensorflow-函数","sections":[],"depth":2},{"title":"在🤗 Transformers库中使用XLA运行TensorFlow文本生成模型","local":"在-transformers库中使用xla运行tensorflow文本生成模型","sections":[],"depth":2},{"title":"需要关注的注意事项","local":"需要关注的注意事项","sections":[],"depth":2},{"title":"附加资源","local":"附加资源","sections":[],"depth":2}],"depth":1}';function ht(Le){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends dt{constructor(M){super(),Mt(this,M,ht,Jt,ct,{})}}export{Xt as component};
