import{s as k1,o as A1,n as g1}from"../chunks/scheduler.9bc65507.js";import{S as V1,i as X1,g as s,s as n,r as f,A as F1,h as a,f as l,c as p,j as Q1,u as M,x as P,k as Z1,y as z1,a as i,v as x,d as u,t as T,w as m}from"../chunks/index.707bf1b6.js";import{T as W1}from"../chunks/Tip.c2ecdbf4.js";import{C as $l}from"../chunks/CodeBlock.54a9f38d.js";import{H as C}from"../chunks/Heading.342b1fa6.js";function O1(cl){let v,U='<strong>注意</strong>: <a href="perf_train_gpu_one">単一GPUセクション</a> で紹介された多くの戦略（混合精度トレーニングや勾配蓄積など）は一般的であり、モデルのトレーニングに一般的に適用されます。したがって、マルチGPUやCPUトレーニングなどの次のセクションに入る前に、それを確認してください。';return{c(){v=s("p"),v.innerHTML=U},l(o){v=a(o,"P",{"data-svelte-h":!0}),P(v)!=="svelte-178vvsa"&&(v.innerHTML=U)},m(o,jl){i(o,v,jl)},p:g1,d(o){o&&l(v)}}}function Y1(cl){let v,U,o,jl,w,Sl,L,Fp="単一のGPUでのトレーニングが遅すぎる場合や、モデルの重みが単一のGPUのメモリに収まらない場合、複数のGPUを使用したセットアップが必要となります。単一のGPUから複数のGPUへの切り替えには、ワークロードを分散するためのある種の並列処理が必要です。データ、テンソル、またはパイプラインの並列処理など、さまざまな並列処理技術があります。ただし、すべてに適した一つの解決策は存在せず、最適な設定は使用するハードウェアに依存します。この記事は、おそらく他のフレームワークにも適用される主要な概念に焦点を当てつつ、PyTorchベースの実装に焦点を当てています。",Nl,r,Il,_,zp="まず、さまざまな1D並列処理技術とその利点および欠点について詳しく説明し、それらを2Dおよび3D並列処理に組み合わせてさらに高速なトレーニングを実現し、より大きなモデルをサポートする方法を検討します。さまざまな他の強力な代替手法も紹介されます。",El,h,Rl,d,Wp="以下は、この文書で後で詳しく説明される主要な概念の簡単な説明です。",Bl,y,Op="<li><strong>DataParallel (DP)</strong> - 同じセットアップが複数回複製され、各セットアップにデータのスライスが供給されます。処理は並行して行われ、各セットアップはトレーニングステップの最後に同期されます。</li> <li><strong>TensorParallel (TP)</strong> - 各テンソルは複数のチャンクに分割され、単一のGPUにテンソル全体が存在するのではなく、テンソルの各シャードが指定されたGPUに存在します。処理中に、各シャードは別々に並行して処理され、異なるGPUで同期され、ステップの最後に結果が同期されます。これは水平並列処理と呼ばれるもので、分割は水平レベルで行われます。</li> <li><strong>PipelineParallel (PP)</strong> - モデルは垂直（レイヤーレベル）に複数のGPUに分割され、モデルの単一または複数のレイヤーが単一のGPUに配置されます。各GPUはパイプラインの異なるステージを並行して処理し、バッチの小さなチャンクで作業します。</li> <li><strong>Zero Redundancy Optimizer (ZeRO)</strong> - TPといくらか似たようなテンソルのシャーディングを実行しますが、前向きまたは後向きの計算のためにテンソル全体が再構築されるため、モデルを変更する必要はありません。また、GPUメモリが制限されている場合に補償するためのさまざまなオフロード技術をサポートします。</li> <li><strong>Sharded DDP</strong> - Sharded DDPは、さまざまなZeRO実装で使用される基本的なZeROコンセプトの別名です。</li>",Ql,D,Yp="各コンセプトの詳細に深入りする前に、大規模なインフラストラクチャで大規模なモデルをトレーニングする際の大まかな決定プロセスを見てみましょう。",Zl,J,kl,G,qp="<strong>⇨ シングルノード / マルチGPU</strong>",Al,b,Kp="<li><p>モデルが単一のGPUに収まる場合：</p> <ol><li>DDP - 分散データ並列</li> <li>ZeRO - 状況と使用される構成に応じて速いかどうかが異なります</li></ol></li> <li><p>モデルが単一のGPUに収まらない場合：</p> <ol><li><p>PP</p></li> <li><p>ZeRO</p></li> <li><p>TP</p> <p>非常に高速なノード内接続（NVLINKまたはNVSwitchなど）があれば、これらの3つはほぼ同じ速度になるはずで、これらがない場合、PPはTPまたはZeROよりも速くなります。TPの程度も差を生じるかもしれません。特定のセットアップでの勝者を見つけるために実験することが最善です。</p> <p>TPはほとんどの場合、単一ノード内で使用されます。つまり、TPサイズ &lt;= ノードごとのGPU数です。</p></li></ol></li> <li><p>最大のレイヤーが単一のGPUに収まらない場合：</p> <ol><li>ZeROを使用しない場合 - TPを使用する必要があります。PP単独では収まらないでしょう。</li> <li>ZeROを使用する場合 - “シングルGPU”のエントリと同じものを参照してください</li></ol></li>",gl,j,ts="<strong>⇨ マルチノード / マルチGPU</strong>",Vl,H,es="<li><p>ノード間の高速接続がある場合：</p> <ol><li>ZeRO - モデルへのほとんどの変更が不要です</li> <li>PP+TP+DP - 通信が少なく、モデルへの大規模な変更が必要です</li></ol></li> <li><p>ノード間の接続が遅く、GPUメモリがまだ不足している場合：</p> <ol><li>DP+PP+TP+ZeRO-1</li></ol></li>",Xl,$,Fl,c,ls='2つのGPUを持つほとんどのユーザーは、<code>DataParallel</code>（DP）と<code>DistributedDataParallel</code>（DDP）によって提供されるトレーニング速度の向上をすでに享受しています。これらはほぼ自明に使用できるPyTorchの組み込み機能です。一般的に、すべてのモデルで動作するDDPを使用することをお勧めします。DPは一部のモデルで失敗する可能性があるためです。<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">PyTorchのドキュメンテーション</a>自体もDDPの使用を推奨しています。',zl,S,Wl,N,is="<code>DistributedDataParallel</code>（DDP）は通常、<code>DataParallel</code>（DP）よりも高速ですが、常にそうとは限りません：",Ol,I,ns="<li>DPはPythonスレッドベースですが、DDPはマルチプロセスベースです。そのため、GIL（Global Interpreter Lock）などのPythonスレッドの制約がないためです。</li> <li>一方、GPUカード間の遅い相互接続性は、DDPの場合に実際には遅い結果をもたらす可能性があります。</li>",Yl,E,ps="以下は、2つのモード間のGPU間通信の主な違いです：",ql,R,ss='<a href="https://pytorch.org/docs/master/notes/ddp.html" rel="nofollow">DDP</a>:',Kl,B,as="<li>開始時、メインプロセスはモデルをGPU 0から他のGPUに複製します。</li> <li>それから各バッチごとに:<ol><li>各GPUは各自のミニバッチのデータを直接消費します。</li> <li><code>backward</code>中、ローカル勾配が準備できると、それらはすべてのプロセスで平均化されます。</li></ol></li>",ti,Q,Ps='<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">DP</a>:',ei,Z,fs="各バッチごとに:",li,k,Ms="<li>GPU 0はデータバッチを読み取り、それから各GPUにミニバッチを送信します。</li> <li>GPU 0から各GPUに最新のモデルを複製します。</li> <li><code>forward</code>を実行し、各GPUからGPU 0に出力を送信し、損失を計算します。</li> <li>GPU 0からすべてのGPUに損失を分散し、<code>backward</code>を実行します。</li> <li>各GPUからGPU 0に勾配を送信し、それらを平均化します。</li>",ii,A,xs="DDPはバッチごとに行う通信は勾配の送信のみであり、一方、DPはバッチごとに5つの異なるデータ交換を行います。",ni,g,us='DPはプロセス内でデータをPythonスレッドを介してコピーしますが、DDPは<a href="https://pytorch.org/docs/master/distributed.html" rel="nofollow">torch.distributed</a>を介してデータをコピーします。',pi,V,Ts="DPではGPU 0は他のGPUよりもはるかに多くの作業を行うため、GPUの未使用率が高くなります。",si,X,ms="DDPは複数のマシン間で使用できますが、DPの場合はそうではありません。",ai,F,vs="DPとDDPの他にも違いがありますが、この議論には関係ありません。",Pi,z,Cs='これら2つのモードを深く理解したい場合、この<a href="https://www.telesens.co/2019/04/04/distributed-data-parallel-training-using-pytorch-on-aws/" rel="nofollow">記事</a>を強くお勧めします。素晴らしいダイアグラムを含み、さまざまなハードウェアでの複数のベンチマークとプロファイラの出力を示し、知っておく必要があるすべての微妙なニュアンスを説明しています。',fi,W,os="実際のベンチマークを見てみましょう：",Mi,O,rs='<thead><tr><th align="left">Type</th> <th>NVlink</th> <th align="right">Time</th></tr></thead> <tbody><tr><td align="left">2:DP</td> <td>Y</td> <td align="right">110s</td></tr> <tr><td align="left">2:DDP</td> <td>Y</td> <td align="right">101s</td></tr> <tr><td align="left">2:DDP</td> <td>N</td> <td align="right">131s</td></tr></tbody>',xi,Y,Us="解析：",ui,q,ws="ここで、DPはNVlinkを使用したDDPに比べて約10％遅く、NVlinkを使用しないDDPに比べて約15％高速であることが示されています。",Ti,K,Ls="実際の違いは、各GPUが他のGPUと同期する必要があるデータの量に依存します。同期するデータが多いほど、遅いリンクが合計の実行時間を遅くする可能性が高くなります。",mi,tt,_s="以下は完全なベンチマークコードと出力です：",vi,et,hs="<code>NCCL_P2P_DISABLE=1</code>を使用して、対応するベンチマークでNVLink機能を無効にしました。",Ci,lt,oi,it,ds="ハードウェア: 2x TITAN RTX、各24GB + 2つのNVLink（<code>nvidia-smi topo -m</code>で <code>NV2</code>）",ri,nt,ys="ソフトウェア: <code>pytorch-1.8-to-be</code> + <code>cuda-11.0</code> / <code>transformers==4.3.0.dev0</code>",Ui,pt,wi,st,Ds=`ZeROパワードデータ並列処理（ZeRO-DP）は、次の<a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">ブログ投稿</a>のダイアグラムで説明されています。
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="DeepSpeed-Image-1"/>`,Li,at,Js="これは理解が難しいかもしれませんが、実際にはこの概念は非常にシンプルです。これは通常の<code>DataParallel</code>（DP）ですが、完全なモデルパラメータ、勾配、およびオプティマイザの状態を複製する代わりに、各GPUはそれぞれのスライスのみを保存します。そして、実行時に、特定のレイヤーに必要な完全なレイヤーパラメータが必要な場合、すべてのGPUが同期して、お互いに不足している部分を提供します。それがすべてです。",_i,Pt,Gs="3つのレイヤーからなる単純なモデルを考えてみましょう。各レイヤーには3つのパラメータがあります：",hi,ft,di,Mt,bs="レイヤーLaには、重みa0、a1、およびa2があります。",yi,xt,js="3つのGPUがある場合、Sharded DDP（= Zero-DP）はモデルを3つのGPUに次のように分割します：",Di,ut,Ji,Tt,Hs="これは、典型的なディープニューラルネットワーク（DNN）のダイアグラムを想像すると、テンソル並列処理と同様の水平スライスであるようなものです。垂直スライスは、異なるGPUに完全な層グループを配置する方法です。しかし、これは単なる出発点に過ぎません。",Gi,mt,$s="これから、各GPUは通常のデータ並列処理（DP）と同様に、通常のミニバッチを受け取ります：",bi,vt,ji,Ct,cs="最初に、入力データはレイヤーLaに適用されます。",Hi,ot,Ss="GPU0に焦点を当てましょう：x0は、その前向きパスを実行するためにa0、a1、a2のパラメータが必要ですが、GPU0にはa0しかありません。GPU1からa1を、GPU2からa2を受け取り、モデルの各部分をまとめます。",$i,rt,Ns="同様に、GPU1はミニバッチx1を受け取り、a1しか持っていませんが、a0とa2のパラメータが必要です。これらはGPU0とGPU2から取得します。",ci,Ut,Is="GPU2もx2を受け取ります。a0とa1はGPU0とGPU1から受け取り、a2とともに完全なテンソルを再構築します。",Si,wt,Es="3つのGPUは完全なテンソルを再構築し、前向き計算が行われます。",Ni,Lt,Rs="計算が完了すると、不要になったデータは削除されます。計算中だけ使用され、再構築は事前にフェッチを使用して効率的に行われます。",Ii,_t,Bs="そして、このプロセス全体がレイヤーLb、次に前向きでLc、そして逆方向でLc -> Lb -> Laに対して繰り返されます。",Ei,ht,Qs="私にとって、これは効率的なグループでの重みの分散戦略のように聞こえます：",Ri,dt,Zs="<li>人Aはテントを持っています。</li> <li>人Bはストーブを持っています。</li> <li>人Cは斧を持っています。</li>",Bi,yt,ks="今、彼らは毎晩持っているものを共有し、他の人から持っていないものをもらい、朝には割り当てられたタイプのギアを詰めて旅を続けます。これがSharded DDP / Zero DPです。",Qi,Dt,As="この戦略を、各人が独自のテント、ストーブ、斧を持って運ばなければならないシンプルな戦略と比較してみてください。これがPyTorchのDataParallel（DPおよびDDP）です。",Zi,Jt,gs="このトピックの文献を読む際に、以下の類義語に出会うかもしれません：Sharded、Partitioned。",ki,Gt,Vs="ZeROがモデルの重みを分割する方法に注意を払うと、これはテンソルパラレリズムと非常に似ているように見えます。これは後で議論される垂直モデルパラレリズムとは異なり、各レイヤーの重みをパーティション/シャーディングします。",Ai,bt,Xs="Implementations:",gi,jt,Fs='<li><a href="https://www.deepspeed.ai/tutorials/zero/" rel="nofollow">DeepSpeed</a> ZeRO-DP stages 1+2+3</li> <li><a href="main_classes/trainer#trainer-integrations"><code>transformers</code> integration</a></li>',Vi,Ht,Xi,$t,zs="ナイーブモデルパラレリズム（MP）は、モデルの層を複数のGPUに分散させる方法です。このメカニズムは比較的単純で、希望する層を<code>.to()</code>メソッドを使用して特定のデバイスに切り替えるだけです。これにより、データがこれらの層を通過するたびに、データも層と同じデバイスに切り替えられ、残りの部分は変更されません。",Fi,ct,Ws="私たちはこれを「垂直MP」と呼びます。なぜなら、ほとんどのモデルがどのように描かれるかを思い出すと、層を垂直にスライスするからです。たとえば、以下の図は8層のモデルを示しています：",zi,St,Wi,Nt,Os="我々は、モデルを垂直に2つに分割し、レイヤー0から3をGPU0に配置し、レイヤー4から7をGPU1に配置しました。",Oi,It,Ys="データがレイヤー0から1、1から2、2から3に移動する間は通常のモデルと同じです。しかし、データがレイヤー3からレイヤー4に移動する必要がある場合、GPU0からGPU1への移動が発生し、通信のオーバーヘッドが発生します。参加しているGPUが同じコンピュートノード（例：同じ物理マシン）にある場合、このコピーは非常に高速ですが、異なるコンピュートノード（例：複数のマシン）にある場合、通信のオーバーヘッドは大幅に増加する可能性があります。",Yi,Et,qs="その後、レイヤー4から5、6から7までは通常のモデルと同様に動作し、7番目のレイヤーが完了すると、データをしばしばレイヤー0に戻す必要があります（またはラベルを最後のレイヤーに送信します）。これで損失を計算し、オプティマイザが作業を開始できます。",qi,Rt,Ks="問題点：",Ki,Bt,ta="<li>主な欠点、およびなぜこれを「単純な」MPと呼ぶのかは、1つを除いてすべてのGPUがどんな瞬間でもアイドル状態であることです。したがって、4つのGPUを使用する場合、単純なMPは、1つのGPUのメモリ容量を4倍にするのとほぼ同じであり、ハードウェアの残りを無視します。さらに、データのコピーのオーバーヘッドがあることを忘れてはいけません。したがって、4枚の6GBのカードは、データのコピーのオーバーヘッドがない1枚の24GBのカードと同じサイズを収容できるでしょうが、後者はトレーニングをより迅速に完了します。ただし、たとえば40GBのカードがあり、45GBのモデルを収める必要がある場合、勾配とオプティマイザの状態のためにほとんど収めることができません。</li> <li>共有の埋め込みは、GPU間でコピーする必要があるかもしれません。</li>",tn,Qt,ea="パイプライン並列処理（PP）は、ほぼ単純なMPと同じですが、GPUがアイドル状態になる問題を解決し、入力バッチをマイクロバッチに分割し、パイプラインを人工的に作成することにより、異なるGPUが計算プロセスに同時に参加できるようにします。",en,Zt,la='以下は、<a href="https://ai.googleblog.com/2019/03/introducing-gpipe-open-source-library.html" rel="nofollow">GPipe論文</a>からの図で、上部には単純なMP、下部にはPPが示されています：',ln,kt,ia='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-gpipe-bubble.png" alt="mp-pp"/>',nn,At,na="この図から、PPがGPUがアイドル状態の領域である「バブル」を少なく持つことがわかります。アイドル状態の部分は「バブル」と呼ばれます。",pn,gt,pa="図の両方の部分は、4つのGPUがパイプラインに参加している4の次元の並列性を示しています。つまり、4つのパイプステージF0、F1、F2、F3のフォワードパスがあり、逆順のバックワードパスB3、B2、B1、B0があります。",sn,Vt,sa="PPは調整する新しいハイパーパラメータを導入します。それは <code>chunks</code> で、同じパイプステージを通じて連続して送信されるデータのチャンクの数を定義します。たとえば、下の図では <code>chunks=4</code> が表示されています。GPU0はチャンク0、1、2、3（F0,0、F0,1、F0,2、F0,3）で同じフォワードパスを実行し、他のGPUが作業を開始し始めるのを待ってから、GPU0はチャンク3、2、1、0（B0,3、B0,2、B0,1、B0,0）で逆順パスを実行します。",an,Xt,aa="注意すべきは、概念的にはこれが勾配蓄積ステップ（GAS）と同じコンセプトであることです。PyTorchは <code>chunks</code> を使用し、DeepSpeedは同じハイパーパラメータをGASと呼びます。",Pn,Ft,Pa="<code>chunks</code> の導入により、PPはマイクロバッチ（MBS）の概念を導入します。DPはグローバルデータバッチサイズをミニバッチに分割します。したがって、DPの次数が4で、グローバルバッチサイズが1024の場合、4つのミニバッチ（それぞれ256）に分割されます（1024/4）。そして、<code>chunks</code>（またはGAS）の数が32である場合、マイクロバッチサイズは8になります（256/32）。各パイプラインステージは1つのマイクロバッチで作業します。",fn,zt,fa="DP + PPセットアップのグローバルバッチサイズを計算するには、<code>mbs*chunks*dp_degree</code>（<code>8*32*4=1024</code>）を行います。",Mn,Wt,Ma="図に戻りましょう。",xn,Ot,xa="<code>chunks=1</code> であれば、非効率な単純なMPになります。非常に大きな <code>chunks</code> 値を使用すると、非常に小さなマイクロバッチサイズになり、効率があまり高くないかもしれません。したがって、GPUの効率的な利用を最大化する値を見つけるために実験する必要があります。これは、バブルのサイズを最小限にすることに対応する、すべての参加GPUにわたる高い並行GPU利用を可能にするためです。",un,Yt,ua="2つのソリューショングループがあります。従来のパイプラインAPIソリューションと、ユーザーのモデルを大幅に変更する必要があるより現代的なソリューションです。",Tn,qt,Ta="従来のパイプラインAPIソリューション：",mn,Kt,ma="<li>PyTorch</li> <li>DeepSpeed</li> <li>Megatron-LM</li>",vn,te,va="現代的なソリューション：",Cn,ee,Ca="<li>Varuna</li> <li>Sagemaker</li>",on,le,oa="従来のパイプラインAPIソリューションの問題点：",rn,ie,ra='<li>モデルをかなり変更する必要があるため、Pipelineはモジュールの通常のフローを<code>nn.Sequential</code>シーケンスに再書き込む必要があり、モデルの設計を変更することが必要です。</li> <li>現在、Pipeline APIは非常に制限的です。最初のパイプラインステージに渡されるPython変数のセットがある場合、回避策を見つける必要があります。現在、パイプラインインターフェースでは、唯一のテンソルまたはテンソルのタプルを入力と出力として要求しています。これらのテンソルはバッチサイズを最初の次元として持っている必要があります。パイプラインはミニバッチをマイクロバッチに分割します。可能な改善点については、こちらの議論が行われています：<a href="https://github.com/pytorch/pytorch/pull/50693" rel="nofollow">https://github.com/pytorch/pytorch/pull/50693</a></li> <li>パイプステージのレベルでの条件付き制御フローは不可能です。例えば、T5のようなエンコーダーデコーダーモデルは、条件付きエンコーダーステージを処理するために特別な回避策が必要です。</li> <li>各レイヤーを配置する必要があるため、1つのモデルの出力が他のモデルの入力になるようにします。</li>',Un,ne,Ua="VarunaとSageMakerとの実験はまだ行っていませんが、彼らの論文によれば、上記で述べた問題のリストを克服し、ユーザーのモデルにははるかに小さな変更しか必要としないと報告されています。",wn,pe,wa="実装：",Ln,se,La='<li><a href="https://pytorch.org/docs/stable/pipeline.html" rel="nofollow">Pytorch</a> (initial support in pytorch-1.8, and progressively getting improved in 1.9 and more so in 1.10). Some <a href="https://github.com/pytorch/pytorch/blob/master/benchmarks/distributed/pipeline/pipe.py" rel="nofollow">examples</a></li> <li><a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation - no API.</li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> - この実装は、Hugging Face Transformersに基づいています。</li>',_n,ae,_a="🤗 Transformersのステータス: この執筆時点では、いずれのモデルも完全なPP（パイプライン並列処理）をサポートしていません。GPT2モデルとT5モデルは単純なMP（モデル並列処理）サポートを持っています。主な障害は、モデルを<code>nn.Sequential</code>に変換できず、すべての入力がテンソルである必要があることです。現在のモデルには、変換を非常に複雑にする多くの機能が含まれており、これらを削除する必要があります。",hn,Pe,ha="他のアプローチ：",dn,fe,da='DeepSpeed、Varuna、およびSageMakerは、<a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-parallel-core-features.html" rel="nofollow">交互にパイプラインを実行</a>するコンセプトを使用しています。ここでは、バックワードパスを優先させてバブル（アイドル時間）をさらに最小限に抑えます。',yn,Me,ya="Varunaは、最適なスケジュールを発見するためにシミュレーションを使用してスケジュールをさらに改善しようとします。",Dn,xe,Da="OSLOは、<code>nn.Sequential</code>の変換なしでTransformersに基づくパイプライン並列処理を実装しています。",Jn,ue,Gn,Te,Ja="テンソル並列処理では、各GPUがテンソルのスライスのみを処理し、全体が必要な操作のためにのみ完全なテンソルを集約します。",bn,me,Ga='このセクションでは、<a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>論文からのコンセプトと図を使用します：<a href="https://arxiv.org/abs/2104.04473" rel="nofollow">GPUクラスタでの効率的な大規模言語モデルトレーニング</a>。',jn,ve,ba="どのトランスフォーマの主要な構築要素は、完全に接続された<code>nn.Linear</code>に続く非線形アクティベーション<code>GeLU</code>です。",Hn,Ce,ja="Megatronの論文の表記法に従って、行列の乗算部分を<code>Y = GeLU(XA)</code>と書くことができます。ここで、<code>X</code>と<code>Y</code>は入力ベクトルと出力ベクトルで、<code>A</code>は重み行列です。",$n,oe,Ha=`行列の計算を行列形式で見ると、行列乗算を複数のGPUで分割できる方法が簡単に理解できます：
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_gemm.png" alt="Parallel GEMM"/>`,cn,re,$a=`重み行列<code>A</code>を<code>N</code>個のGPUに対して列ごとに分割し、並列で行列乗算<code>XA_1</code>から<code>XA_n</code>を実行すると、<code>N</code>個の出力ベクトル<code>Y_1、Y_2、...、Y_n</code>が得られ、それらを独立して<code>GeLU</code>に供給できます：
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-independent-gelu.png" alt="独立したGeLU"/>`,Sn,Ue,ca=`この原理を使用して、最後まで同期が必要ないまま、任意の深さのMLPを更新できます。Megatron-LMの著者はそのための有用なイラストを提供しています：
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_shard_processing.png" alt="並列シャード処理"/>`,Nn,we,Sa=`マルチヘッドアテンションレイヤーを並列化することはさらに簡単です。それらは既に複数の独立したヘッドを持っているため、本質的に並列です！
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_self_attention.png" alt="並列セルフアテンション"/>`,In,Le,Na="特別な考慮事項：TPには非常に高速なネットワークが必要であり、したがって1つのノードを超えてTPを実行しないことがお勧めされません。実際には、1つのノードに4つのGPUがある場合、最大のTP度数は4です。TP度数8が必要な場合は、少なくとも8つのGPUを持つノードを使用する必要があります。",En,_e,Ia=`このセクションは、元のより詳細な<a href="https://github.com/huggingface/transformers/issues/10321#issuecomment-783543530" rel="nofollow">TPの概要</a>に基づいています。
by <a href="https://github.com/anton-l" rel="nofollow">@anton-l</a>。`,Rn,he,Ea="SageMakerは、より効率的な処理のためにTPとDPを組み合わせて使用します。",Bn,de,Ra="代替名：",Qn,ye,Ba='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a>はこれを「テンソルスライシング」と呼びます。詳細は<a href="https://www.deepspeed.ai/training/#model-parallelism" rel="nofollow">DeepSpeedの特徴</a>をご覧ください。</li>',Zn,De,Qa="実装例:",kn,Je,Za='<li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>には、モデル固有の内部実装があります。</li> <li><a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a>（現時点では推論のみ）。</li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - これはAWSでのみ使用できるプロプライエタリなソリューションです。</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a>には、Transformersに基づいたテンソル並列実装があります。</li>',An,Ge,ka="🤗 Transformersの状況:",gn,be,Aa='<li>コア: まだコアには実装されていません。</li> <li>ただし、推論が必要な場合、<a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a>はほとんどのモデルに対してサポートを提供します。これがコアに実装されるまで、これを使用できます。そして、トレーニングモードもサポートされることを期待しています。</li> <li>Deepspeed-Inferenceでは、BERT、GPT-2、およびGPT-NeoモデルをCUDAカーネルベースの高速推論モードでサポートしています。詳細は<a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">こちら</a>をご覧ください。</li>',Vn,je,Xn,He,ga='DeepSpeedの<a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">パイプラインチュートリアル</a>からの次の図は、DPをPPと組み合わせる方法を示しています。',Fn,$e,Va='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero-dp-pp.png" alt="dp-pp-2d"/>',zn,ce,Xa="ここで重要なのは、DPランク0がGPU2を見えなくし、DPランク1がGPU3を見えなくすることです。DPにとって、存在するのはGPU 0 と 1 のみで、それらの2つのGPUのようにデータを供給します。GPU0はPPを使用してGPU2に一部の負荷を「秘密裏に」オフロードし、GPU1も同様にGPU3を支援に引き入れます。",Wn,Se,Fa="各次元には少なくとも2つのGPUが必要ですので、ここでは少なくとも4つのGPUが必要です。",On,Ne,za="実装例:",Yn,Ie,Wa='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',qn,Ee,Oa="🤗 Transformersの状況: まだ実装されていません",Kn,Re,tp,Be,Ya="さらに効率的なトレーニングを行うために、3Dパラレリズムを使用し、PPをTPとDPと組み合わせます。これは次の図で示されています。",ep,Qe,qa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-deepspeed-3d.png" alt="dp-pp-tp-3d"/>',lp,Ze,Ka='この図は<a href="https://www.microsoft.com/en-us/research/blog/deepspeed-extreme-scale-model-training-for-everyone/" rel="nofollow">3Dパラレリズム：兆パラメータモデルへのスケーリング</a>というブログ投稿から取得されたもので、おすすめの読み物です。',ip,ke,t1="各次元には少なくとも2つのGPUが必要ですので、ここでは少なくとも8つのGPUが必要です。",np,Ae,e1="実装例:",pp,ge,l1='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> - DeepSpeedには、さらに効率的なDPであるZeRO-DPと呼ばれるものも含まれています。</li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',sp,Ve,i1="🤗 Transformersの状況: まだ実装されていません。PPとTPがないため。",ap,Xe,Pp,Fe,n1="DeepSpeedの主要な機能の1つはZeROで、これはDPの拡張機能です。これについてはすでに「ZeROデータ並列化」で説明されています。通常、これは単独で動作する機能で、PPやTPは必要ありません。しかし、PPとTPと組み合わせることもできます。",fp,ze,p1="ZeRO-DPがPPと組み合わされる場合、通常はZeROステージ1（オプティマイザーシャーディング）のみが有効になります。",Mp,We,s1="ZeROステージ2（勾配シャーディング）をパイプライン並列化と組み合わせて使用する理論的な可能性はありますが、性能に悪影響を及ぼします。各マイクロバッチごとに勾配をシャーディングする前に、勾配を集約するための追加のリダクションスキャッター集計が必要で、通信オーバーヘッドが発生する可能性があります。パイプライン並列化の性質上、小さなマイクロバッチが使用され、計算の集中度（マイクロバッチサイズ）をバランスにかけ、パイプラインバブル（マイクロバッチ数）を最小限に抑えることに焦点が当てられています。したがって、これらの通信コストは影響を及ぼすでしょう。",xp,Oe,a1="さらに、PPには通常よりも少ない層が含まれており、メモリの節約はそれほど大きくありません。PPは既に勾配サイズを「1/PP」に削減するため、勾配シャーディングの節約は純粋なDPよりもはるかに重要ではありません。",up,Ye,P1="ZeROステージ3も同様の理由で適していません - より多くのノード間通信が必要です。",Tp,qe,f1="そして、ZeROを持っているので、もう一つの利点はZeRO-Offloadです。これはステージ1オプティマイザーステートをCPUにオフロードできます。",mp,Ke,M1="実装例:",vp,tl,x1='<li><a href="https://github.com/microsoft/Megatron-DeepSpeed" rel="nofollow">Megatron-DeepSpeed</a>と<a href="https://github.com/bigscience-workshop/Megatron-DeepSpeed" rel="nofollow">BigScienceからのMegatron-Deepspeed</a>は、前者のリポジトリのフォークです。</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Cp,el,u1="重要な論文:",op,ll,T1='<li><a href="https://arxiv.org/abs/2201.11990" rel="nofollow">DeepSpeedとMegatronを使用したMegatron-Turing NLG 530Bのトレーニング</a></li>',rp,il,m1="🤗 Transformersの状況: まだ実装されていません。PPとTPがないため。",Up,nl,wp,pl,v1='<a href="https://github.com/flexflow/FlexFlow" rel="nofollow">FlexFlow</a>は、わずかに異なるアプローチで並列化の問題を解決します。',Lp,sl,C1='論文: <a href="https://arxiv.org/abs/1807.05358" rel="nofollow">Zhihao Jia、Matei Zaharia、Alex Aikenによる “Deep Neural Networksのデータとモデルの並列化を超えて”</a>',_p,al,o1="FlexFlowは、サンプル-オペレータ-属性-パラメータの4D並列化を行います。",hp,Pl,r1="<li>サンプル = データ並列化（サンプル単位の並列化）</li> <li>オペレータ = 単一の操作をいくつかのサブ操作に並列化</li> <li>属性 = データ並列化（長さ方向の並列化）</li> <li>パラメータ = モデル並列化（次元に関係なく、水平または垂直）</li>",dp,fl,U1="例:",yp,Ml,w1="<li>サンプル</li>",Dp,xl,L1="シーケンス長512の10バッチを考えてみましょう。これらをサンプル次元で2つのデバイスに並列化すると、10 x 512が5 x 2 x 512になります。",Jp,ul,_1="<li>オペレータ</li>",Gp,Tl,h1="層正規化を行う場合、まずstdを計算し、次にmeanを計算し、データを正規化できます。オペレータの並列化により、stdとmeanを並列に計算できます。したがって、オペレータ次元で2つのデバイス（cuda:0、cuda:1）に並列化すると、最初に入力データを両方のデバイスにコピーし、cuda:0でstdを計算し、cuda:1でmeanを同時に計算します。",bp,ml,d1="<li>属性</li>",jp,vl,y1="10バッチの512長があります。これらを属性次元で2つのデバイスに並列化すると、10 x 512が10 x 2 x 256になります。",Hp,Cl,D1="<li>パラメータ</li>",$p,ol,J1="これはテンソルモデルの並列化または単純な層ごとのモデルの並列化と似ています。",cp,rl,G1="このフレームワークの重要性は、（1）GPU/TPU/CPU対（2）RAM/DRAM対（3）高速内部接続/低速外部接続などのリソースを取り、これらすべてをアルゴリズムによって自動的に最適化することです。どの並列化をどこで使用するかをアルゴリズム的に決定します。",Sp,Ul,b1="非常に重要な側面の1つは、FlexFlowは静的で固定のワークロードを持つモデルのために設計されており、動的な動作を持つモデルはイテレーションごとに異なる並列化戦略を好む場合があることです。",Np,wl,j1="したがって、このフレームワークの約束は非常に魅力的です。選択したクラスタで30分間のシミュレーションを実行し、この特定の環境を最適に利用するための最良の戦略を提供します。部分を追加/削除/置換すると、それに対して実行して再最適化プランを作成します。その後、トレーニングできます。異なるセットアップには独自の最適化があります。",Ip,Ll,H1='🤗 Transformersの現在の状況: まだ統合されていません。すでに<a href="https://github.com/huggingface/transformers/blob/master/src/transformers/utils/fx.py" rel="nofollow">transformers.utils.fx</a>を使用してモデルがFXトレース可能であるため、FlexFlowを動作させるために必要な手順を誰かが見つける必要があります。',Ep,_l,Rp,hl,$1="ここでは、どの並列化戦略をいつ使用するかの非常におおまかなアウトラインを示します。各リストの最初が通常よりも速いことが一般的です。",Bp,dl,c1="<strong>⇨ 単一GPU</strong>",Qp,yl,S1='<li><p>モデルが単一GPUに収まる場合：</p> <ol><li>通常の使用</li></ol></li> <li><p>モデルが単一GPUに収まらない場合：</p> <ol><li>ZeRO + CPUをオフロードし、オプションでNVMeをオフロード</li> <li>上記に加えて、最大のレイヤーが単一GPUに収まらない場合、<a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#memory-centric-tiling" rel="nofollow">Memory Centric Tiling</a>（詳細は以下参照）を有効化</li></ol></li> <li><p>最大のレイヤーが単一GPUに収まらない場合：</p> <ol><li>ZeROを使用しない場合 - TPを有効化する必要があります。なぜなら、PPだけでは収めることができないからです。</li> <li>ZeROを使用する場合は、上記の「単一GPU」のエントリと同じものを参照してください</li></ol></li>',Zp,Dl,N1="<strong>⇨ 単一ノード/マルチGPU</strong>",kp,Jl,I1="<li><p>モデルが単一GPUに収まる場合：</p> <ol><li>DDP - 分散データ並列</li> <li>ZeRO - 状況と使用される構成に依存して速いかどうかが異なることがあります</li></ol></li> <li><p>モデルが単一GPUに収まらない場合：</p> <ol><li><p>PP</p></li> <li><p>ZeRO</p></li> <li><p>TP</p> <p>非常に高速なノード内接続がNVLINKまたはNVSwitchである場合、これらのすべてはほとんど同等の性能です。これらがない場合、PPはTPまたはZeROよりも速くなります。TPの度合いも違いを生じるかもしれません。特定のセットアップで勝者を見つけるために実験するのが最善です。</p> <p>TPはほとんど常に単一ノード内で使用されます。つまり、TPサイズ &lt;= ノードあたりのGPUです。</p></li></ol></li> <li><p>最大のレイヤーが単一GPUに収まらない場合：</p> <ol><li>ZeROを使用しない場合 - TPを使用する必要があります。なぜなら、PPだけでは収めることができないからです。</li> <li>ZeROを使用する場合は、上記の「単一GPU」のエントリと同じものを参照してください</li></ol></li>",Ap,Gl,E1="<strong>⇨ マルチノード/マルチGPU</strong>",gp,bl,R1="<li><p>高速なノード間接続がある場合：</p> <ol><li>ZeRO - モデルへのほとんどの変更が不要です</li> <li>PP+TP+DP - 通信が少なく、モデルに大規模な変更が必要です</li></ol></li> <li><p>遅いノード間接続があり、GPUメモリが少ない場合：</p> <ol><li>DP+PP+TP+ZeRO-1</li></ol></li>",Vp,Hl,Xp;return w=new C({props:{title:"Efficient Training on Multiple GPUs",local:"efficient-training-on-multiple-gpus",headingTag:"h1"}}),r=new W1({props:{$$slots:{default:[O1]},$$scope:{ctx:cl}}}),h=new C({props:{title:"Concepts",local:"concepts",headingTag:"h2"}}),J=new C({props:{title:"Scalability Strategy",local:"scalability-strategy",headingTag:"h2"}}),$=new C({props:{title:"Data Parallelism",local:"data-parallelism",headingTag:"h2"}}),S=new C({props:{title:"DP vs DDP",local:"dp-vs-ddp",headingTag:"h3"}}),lt=new $l({props:{code:"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",highlighted:`
<span class="hljs-comment"># DP</span>
<span class="hljs-built_in">rm</span> -r /tmp/test-clm; CUDA_VISIBLE_DEVICES=0,1 \\
python examples/pytorch/language-modeling/run_clm.py \\
--model_name_or_path openai-community/gpt2 --dataset_name wikitext --dataset_config_name wikitext-2-raw-v1 \\
--do_train --output_dir /tmp/test-clm --per_device_train_batch_size 4 --max_steps 200

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: 110.5948, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: 1.808, <span class="hljs-string">&#x27;epoch&#x27;</span>: 0.69}

<span class="hljs-comment"># DDP w/ NVlink</span>
<span class="hljs-built_in">rm</span> -r /tmp/test-clm; CUDA_VISIBLE_DEVICES=0,1 \\
torchrun --nproc_per_node 2 examples/pytorch/language-modeling/run_clm.py \\
--model_name_or_path openai-community/gpt2 --dataset_name wikitext --dataset_config_name wikitext-2-raw-v1 \\
--do_train --output_dir /tmp/test-clm --per_device_train_batch_size 4 --max_steps 200

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: 101.9003, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: 1.963, <span class="hljs-string">&#x27;epoch&#x27;</span>: 0.69}

<span class="hljs-comment"># DDP w/o NVlink</span>
<span class="hljs-built_in">rm</span> -r /tmp/test-clm; NCCL_P2P_DISABLE=1 CUDA_VISIBLE_DEVICES=0,1 \\
torchrun --nproc_per_node 2 examples/pytorch/language-modeling/run_clm.py \\
--model_name_or_path openai-community/gpt2 --dataset_name wikitext --dataset_config_name wikitext-2-raw-v1 \\
--do_train --output_dir /tmp/test-clm --per_device_train_batch_size 4 --max_steps 200

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: 131.4367, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: 1.522, <span class="hljs-string">&#x27;epoch&#x27;</span>: 0.69}`,wrap:!1}}),pt=new C({props:{title:"ZeRO Data Parallelism",local:"zero-data-parallelism",headingTag:"h2"}}),ft=new $l({props:{code:"TGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWEwJTIwJTdDJTIwYjAlMjAlN0MlMjBjMCUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQWEyJTIwJTdDJTIwYjIlMjAlN0MlMjBjMg==",highlighted:`La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),ut=new $l({props:{code:"R1BVMCUzQSUwQUxhJTIwJTdDJTIwTGIlMjAlN0MlMjBMYyUwQS0tLSU3Qy0tLS0lN0MtLS0lMEFhMCUyMCU3QyUyMGIwJTIwJTdDJTIwYzAlMEElMEFHUFUxJTNBJTBBTGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQSUwQUdQVTIlM0ElMEFMYSUyMCU3QyUyMExiJTIwJTdDJTIwTGMlMEEtLS0lN0MtLS0tJTdDLS0tJTBBYTIlMjAlN0MlMjBiMiUyMCU3QyUyMGMy",highlighted:`GPU0:
La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0

GPU1:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1

GPU2:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),vt=new $l({props:{code:"eDAlMjAlM0QlM0UlMjBHUFUwJTBBeDElMjAlM0QlM0UlMjBHUFUxJTBBeDIlMjAlM0QlM0UlMjBHUFUy",highlighted:`<span class="hljs-attribute">x0</span> <span class="hljs-operator">=</span>&gt; GPU0
<span class="hljs-attribute">x1</span> <span class="hljs-operator">=</span>&gt; GPU1
<span class="hljs-attribute">x2</span> <span class="hljs-operator">=</span>&gt; GPU2`,wrap:!1}}),Ht=new C({props:{title:"Naive Model Parallelism (Vertical) and Pipeline Parallelism",local:"naive-model-parallelism-vertical-and-pipeline-parallelism",headingTag:"h2"}}),St=new $l({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwJTIwJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTdDJTIwJTIwMCUyMCU3QyUyMDElMjAlN0MlMjAyJTIwJTdDJTIwMyUyMCUyMCU3QyUyMCUyMCU3QyUyMCUyMDQlMjAlN0MlMjA1JTIwJTdDJTIwNiUyMCU3QyUyMDclMjAlMjAlN0MlMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMjAlMjAlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBncHUwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3B1MQ==",highlighted:`===================  ===================
|<span class="hljs-string">  0 </span>|<span class="hljs-string"> 1 </span>|<span class="hljs-string"> 2 </span>|<span class="hljs-string"> 3  </span>|<span class="hljs-string">  </span>|<span class="hljs-string">  4 </span>|<span class="hljs-string"> 5 </span>|<span class="hljs-string"> 6 </span>|<span class="hljs-string"> 7  </span>|
===================  ===================
        gpu0                 gpu1`,wrap:!1}}),ue=new C({props:{title:"Tensor Parallelism",local:"tensor-parallelism",headingTag:"h2"}}),je=new C({props:{title:"DP+PP",local:"dppp",headingTag:"h2"}}),Re=new C({props:{title:"DP+PP+TP",local:"dppptp",headingTag:"h2"}}),Xe=new C({props:{title:"ZeRO DP+PP+TP",local:"zero-dppptp",headingTag:"h2"}}),nl=new C({props:{title:"FlexFlow",local:"flexflow",headingTag:"h2"}}),_l=new C({props:{title:"Which Strategy To Use When",local:"which-strategy-to-use-when",headingTag:"h2"}}),{c(){v=s("meta"),U=n(),o=s("p"),jl=n(),f(w.$$.fragment),Sl=n(),L=s("p"),L.textContent=Fp,Nl=n(),f(r.$$.fragment),Il=n(),_=s("p"),_.textContent=zp,El=n(),f(h.$$.fragment),Rl=n(),d=s("p"),d.textContent=Wp,Bl=n(),y=s("ol"),y.innerHTML=Op,Ql=n(),D=s("p"),D.textContent=Yp,Zl=n(),f(J.$$.fragment),kl=n(),G=s("p"),G.innerHTML=qp,Al=n(),b=s("ul"),b.innerHTML=Kp,gl=n(),j=s("p"),j.innerHTML=ts,Vl=n(),H=s("ul"),H.innerHTML=es,Xl=n(),f($.$$.fragment),Fl=n(),c=s("p"),c.innerHTML=ls,zl=n(),f(S.$$.fragment),Wl=n(),N=s("p"),N.innerHTML=is,Ol=n(),I=s("ul"),I.innerHTML=ns,Yl=n(),E=s("p"),E.textContent=ps,ql=n(),R=s("p"),R.innerHTML=ss,Kl=n(),B=s("ul"),B.innerHTML=as,ti=n(),Q=s("p"),Q.innerHTML=Ps,ei=n(),Z=s("p"),Z.textContent=fs,li=n(),k=s("ol"),k.innerHTML=Ms,ii=n(),A=s("p"),A.textContent=xs,ni=n(),g=s("p"),g.innerHTML=us,pi=n(),V=s("p"),V.textContent=Ts,si=n(),X=s("p"),X.textContent=ms,ai=n(),F=s("p"),F.textContent=vs,Pi=n(),z=s("p"),z.innerHTML=Cs,fi=n(),W=s("p"),W.textContent=os,Mi=n(),O=s("table"),O.innerHTML=rs,xi=n(),Y=s("p"),Y.textContent=Us,ui=n(),q=s("p"),q.textContent=ws,Ti=n(),K=s("p"),K.textContent=Ls,mi=n(),tt=s("p"),tt.textContent=_s,vi=n(),et=s("p"),et.innerHTML=hs,Ci=n(),f(lt.$$.fragment),oi=n(),it=s("p"),it.innerHTML=ds,ri=n(),nt=s("p"),nt.innerHTML=ys,Ui=n(),f(pt.$$.fragment),wi=n(),st=s("p"),st.innerHTML=Ds,Li=n(),at=s("p"),at.innerHTML=Js,_i=n(),Pt=s("p"),Pt.textContent=Gs,hi=n(),f(ft.$$.fragment),di=n(),Mt=s("p"),Mt.textContent=bs,yi=n(),xt=s("p"),xt.textContent=js,Di=n(),f(ut.$$.fragment),Ji=n(),Tt=s("p"),Tt.textContent=Hs,Gi=n(),mt=s("p"),mt.textContent=$s,bi=n(),f(vt.$$.fragment),ji=n(),Ct=s("p"),Ct.textContent=cs,Hi=n(),ot=s("p"),ot.textContent=Ss,$i=n(),rt=s("p"),rt.textContent=Ns,ci=n(),Ut=s("p"),Ut.textContent=Is,Si=n(),wt=s("p"),wt.textContent=Es,Ni=n(),Lt=s("p"),Lt.textContent=Rs,Ii=n(),_t=s("p"),_t.textContent=Bs,Ei=n(),ht=s("p"),ht.textContent=Qs,Ri=n(),dt=s("ol"),dt.innerHTML=Zs,Bi=n(),yt=s("p"),yt.textContent=ks,Qi=n(),Dt=s("p"),Dt.textContent=As,Zi=n(),Jt=s("p"),Jt.textContent=gs,ki=n(),Gt=s("p"),Gt.textContent=Vs,Ai=n(),bt=s("p"),bt.textContent=Xs,gi=n(),jt=s("ul"),jt.innerHTML=Fs,Vi=n(),f(Ht.$$.fragment),Xi=n(),$t=s("p"),$t.innerHTML=zs,Fi=n(),ct=s("p"),ct.textContent=Ws,zi=n(),f(St.$$.fragment),Wi=n(),Nt=s("p"),Nt.textContent=Os,Oi=n(),It=s("p"),It.textContent=Ys,Yi=n(),Et=s("p"),Et.textContent=qs,qi=n(),Rt=s("p"),Rt.textContent=Ks,Ki=n(),Bt=s("ul"),Bt.innerHTML=ta,tn=n(),Qt=s("p"),Qt.textContent=ea,en=n(),Zt=s("p"),Zt.innerHTML=la,ln=n(),kt=s("p"),kt.innerHTML=ia,nn=n(),At=s("p"),At.textContent=na,pn=n(),gt=s("p"),gt.textContent=pa,sn=n(),Vt=s("p"),Vt.innerHTML=sa,an=n(),Xt=s("p"),Xt.innerHTML=aa,Pn=n(),Ft=s("p"),Ft.innerHTML=Pa,fn=n(),zt=s("p"),zt.innerHTML=fa,Mn=n(),Wt=s("p"),Wt.textContent=Ma,xn=n(),Ot=s("p"),Ot.innerHTML=xa,un=n(),Yt=s("p"),Yt.textContent=ua,Tn=n(),qt=s("p"),qt.textContent=Ta,mn=n(),Kt=s("ul"),Kt.innerHTML=ma,vn=n(),te=s("p"),te.textContent=va,Cn=n(),ee=s("ul"),ee.innerHTML=Ca,on=n(),le=s("p"),le.textContent=oa,rn=n(),ie=s("ul"),ie.innerHTML=ra,Un=n(),ne=s("p"),ne.textContent=Ua,wn=n(),pe=s("p"),pe.textContent=wa,Ln=n(),se=s("ul"),se.innerHTML=La,_n=n(),ae=s("p"),ae.innerHTML=_a,hn=n(),Pe=s("p"),Pe.textContent=ha,dn=n(),fe=s("p"),fe.innerHTML=da,yn=n(),Me=s("p"),Me.textContent=ya,Dn=n(),xe=s("p"),xe.innerHTML=Da,Jn=n(),f(ue.$$.fragment),Gn=n(),Te=s("p"),Te.textContent=Ja,bn=n(),me=s("p"),me.innerHTML=Ga,jn=n(),ve=s("p"),ve.innerHTML=ba,Hn=n(),Ce=s("p"),Ce.innerHTML=ja,$n=n(),oe=s("p"),oe.innerHTML=Ha,cn=n(),re=s("p"),re.innerHTML=$a,Sn=n(),Ue=s("p"),Ue.innerHTML=ca,Nn=n(),we=s("p"),we.innerHTML=Sa,In=n(),Le=s("p"),Le.textContent=Na,En=n(),_e=s("p"),_e.innerHTML=Ia,Rn=n(),he=s("p"),he.textContent=Ea,Bn=n(),de=s("p"),de.textContent=Ra,Qn=n(),ye=s("ul"),ye.innerHTML=Ba,Zn=n(),De=s("p"),De.textContent=Qa,kn=n(),Je=s("ul"),Je.innerHTML=Za,An=n(),Ge=s("p"),Ge.textContent=ka,gn=n(),be=s("ul"),be.innerHTML=Aa,Vn=n(),f(je.$$.fragment),Xn=n(),He=s("p"),He.innerHTML=ga,Fn=n(),$e=s("p"),$e.innerHTML=Va,zn=n(),ce=s("p"),ce.textContent=Xa,Wn=n(),Se=s("p"),Se.textContent=Fa,On=n(),Ne=s("p"),Ne.textContent=za,Yn=n(),Ie=s("ul"),Ie.innerHTML=Wa,qn=n(),Ee=s("p"),Ee.textContent=Oa,Kn=n(),f(Re.$$.fragment),tp=n(),Be=s("p"),Be.textContent=Ya,ep=n(),Qe=s("p"),Qe.innerHTML=qa,lp=n(),Ze=s("p"),Ze.innerHTML=Ka,ip=n(),ke=s("p"),ke.textContent=t1,np=n(),Ae=s("p"),Ae.textContent=e1,pp=n(),ge=s("ul"),ge.innerHTML=l1,sp=n(),Ve=s("p"),Ve.textContent=i1,ap=n(),f(Xe.$$.fragment),Pp=n(),Fe=s("p"),Fe.textContent=n1,fp=n(),ze=s("p"),ze.textContent=p1,Mp=n(),We=s("p"),We.textContent=s1,xp=n(),Oe=s("p"),Oe.textContent=a1,up=n(),Ye=s("p"),Ye.textContent=P1,Tp=n(),qe=s("p"),qe.textContent=f1,mp=n(),Ke=s("p"),Ke.textContent=M1,vp=n(),tl=s("ul"),tl.innerHTML=x1,Cp=n(),el=s("p"),el.textContent=u1,op=n(),ll=s("ul"),ll.innerHTML=T1,rp=n(),il=s("p"),il.textContent=m1,Up=n(),f(nl.$$.fragment),wp=n(),pl=s("p"),pl.innerHTML=v1,Lp=n(),sl=s("p"),sl.innerHTML=C1,_p=n(),al=s("p"),al.textContent=o1,hp=n(),Pl=s("ol"),Pl.innerHTML=r1,dp=n(),fl=s("p"),fl.textContent=U1,yp=n(),Ml=s("ul"),Ml.innerHTML=w1,Dp=n(),xl=s("p"),xl.textContent=L1,Jp=n(),ul=s("ul"),ul.innerHTML=_1,Gp=n(),Tl=s("p"),Tl.textContent=h1,bp=n(),ml=s("ul"),ml.innerHTML=d1,jp=n(),vl=s("p"),vl.textContent=y1,Hp=n(),Cl=s("ul"),Cl.innerHTML=D1,$p=n(),ol=s("p"),ol.textContent=J1,cp=n(),rl=s("p"),rl.textContent=G1,Sp=n(),Ul=s("p"),Ul.textContent=b1,Np=n(),wl=s("p"),wl.textContent=j1,Ip=n(),Ll=s("p"),Ll.innerHTML=H1,Ep=n(),f(_l.$$.fragment),Rp=n(),hl=s("p"),hl.textContent=$1,Bp=n(),dl=s("p"),dl.innerHTML=c1,Qp=n(),yl=s("ul"),yl.innerHTML=S1,Zp=n(),Dl=s("p"),Dl.innerHTML=N1,kp=n(),Jl=s("ul"),Jl.innerHTML=I1,Ap=n(),Gl=s("p"),Gl.innerHTML=E1,gp=n(),bl=s("ul"),bl.innerHTML=R1,Vp=n(),Hl=s("p"),this.h()},l(t){const e=F1("svelte-u9bgzb",document.head);v=a(e,"META",{name:!0,content:!0}),e.forEach(l),U=p(t),o=a(t,"P",{}),Q1(o).forEach(l),jl=p(t),M(w.$$.fragment,t),Sl=p(t),L=a(t,"P",{"data-svelte-h":!0}),P(L)!=="svelte-p00wl7"&&(L.textContent=Fp),Nl=p(t),M(r.$$.fragment,t),Il=p(t),_=a(t,"P",{"data-svelte-h":!0}),P(_)!=="svelte-1kh3km3"&&(_.textContent=zp),El=p(t),M(h.$$.fragment,t),Rl=p(t),d=a(t,"P",{"data-svelte-h":!0}),P(d)!=="svelte-3k4cjb"&&(d.textContent=Wp),Bl=p(t),y=a(t,"OL",{"data-svelte-h":!0}),P(y)!=="svelte-19i5an3"&&(y.innerHTML=Op),Ql=p(t),D=a(t,"P",{"data-svelte-h":!0}),P(D)!=="svelte-1axfwuf"&&(D.textContent=Yp),Zl=p(t),M(J.$$.fragment,t),kl=p(t),G=a(t,"P",{"data-svelte-h":!0}),P(G)!=="svelte-i7ves8"&&(G.innerHTML=qp),Al=p(t),b=a(t,"UL",{"data-svelte-h":!0}),P(b)!=="svelte-1xp2u7g"&&(b.innerHTML=Kp),gl=p(t),j=a(t,"P",{"data-svelte-h":!0}),P(j)!=="svelte-17lwh0r"&&(j.innerHTML=ts),Vl=p(t),H=a(t,"UL",{"data-svelte-h":!0}),P(H)!=="svelte-jug9hc"&&(H.innerHTML=es),Xl=p(t),M($.$$.fragment,t),Fl=p(t),c=a(t,"P",{"data-svelte-h":!0}),P(c)!=="svelte-5hcykd"&&(c.innerHTML=ls),zl=p(t),M(S.$$.fragment,t),Wl=p(t),N=a(t,"P",{"data-svelte-h":!0}),P(N)!=="svelte-gheqny"&&(N.innerHTML=is),Ol=p(t),I=a(t,"UL",{"data-svelte-h":!0}),P(I)!=="svelte-1lsfqcs"&&(I.innerHTML=ns),Yl=p(t),E=a(t,"P",{"data-svelte-h":!0}),P(E)!=="svelte-1pif46a"&&(E.textContent=ps),ql=p(t),R=a(t,"P",{"data-svelte-h":!0}),P(R)!=="svelte-1v8b0bi"&&(R.innerHTML=ss),Kl=p(t),B=a(t,"UL",{"data-svelte-h":!0}),P(B)!=="svelte-uzzpkk"&&(B.innerHTML=as),ti=p(t),Q=a(t,"P",{"data-svelte-h":!0}),P(Q)!=="svelte-2za96j"&&(Q.innerHTML=Ps),ei=p(t),Z=a(t,"P",{"data-svelte-h":!0}),P(Z)!=="svelte-1v6i5n3"&&(Z.textContent=fs),li=p(t),k=a(t,"OL",{"data-svelte-h":!0}),P(k)!=="svelte-vfltgt"&&(k.innerHTML=Ms),ii=p(t),A=a(t,"P",{"data-svelte-h":!0}),P(A)!=="svelte-130pc3o"&&(A.textContent=xs),ni=p(t),g=a(t,"P",{"data-svelte-h":!0}),P(g)!=="svelte-23i2i2"&&(g.innerHTML=us),pi=p(t),V=a(t,"P",{"data-svelte-h":!0}),P(V)!=="svelte-ufyyk6"&&(V.textContent=Ts),si=p(t),X=a(t,"P",{"data-svelte-h":!0}),P(X)!=="svelte-1gyvr2l"&&(X.textContent=ms),ai=p(t),F=a(t,"P",{"data-svelte-h":!0}),P(F)!=="svelte-1nvxoat"&&(F.textContent=vs),Pi=p(t),z=a(t,"P",{"data-svelte-h":!0}),P(z)!=="svelte-ndepvz"&&(z.innerHTML=Cs),fi=p(t),W=a(t,"P",{"data-svelte-h":!0}),P(W)!=="svelte-hpqigq"&&(W.textContent=os),Mi=p(t),O=a(t,"TABLE",{"data-svelte-h":!0}),P(O)!=="svelte-1glyygb"&&(O.innerHTML=rs),xi=p(t),Y=a(t,"P",{"data-svelte-h":!0}),P(Y)!=="svelte-j7a5ab"&&(Y.textContent=Us),ui=p(t),q=a(t,"P",{"data-svelte-h":!0}),P(q)!=="svelte-v4b9q2"&&(q.textContent=ws),Ti=p(t),K=a(t,"P",{"data-svelte-h":!0}),P(K)!=="svelte-117kghy"&&(K.textContent=Ls),mi=p(t),tt=a(t,"P",{"data-svelte-h":!0}),P(tt)!=="svelte-188felc"&&(tt.textContent=_s),vi=p(t),et=a(t,"P",{"data-svelte-h":!0}),P(et)!=="svelte-q5i4nx"&&(et.innerHTML=hs),Ci=p(t),M(lt.$$.fragment,t),oi=p(t),it=a(t,"P",{"data-svelte-h":!0}),P(it)!=="svelte-lu79sn"&&(it.innerHTML=ds),ri=p(t),nt=a(t,"P",{"data-svelte-h":!0}),P(nt)!=="svelte-18h87eb"&&(nt.innerHTML=ys),Ui=p(t),M(pt.$$.fragment,t),wi=p(t),st=a(t,"P",{"data-svelte-h":!0}),P(st)!=="svelte-juqsxg"&&(st.innerHTML=Ds),Li=p(t),at=a(t,"P",{"data-svelte-h":!0}),P(at)!=="svelte-1i0mdv7"&&(at.innerHTML=Js),_i=p(t),Pt=a(t,"P",{"data-svelte-h":!0}),P(Pt)!=="svelte-1wipobe"&&(Pt.textContent=Gs),hi=p(t),M(ft.$$.fragment,t),di=p(t),Mt=a(t,"P",{"data-svelte-h":!0}),P(Mt)!=="svelte-3cvmfq"&&(Mt.textContent=bs),yi=p(t),xt=a(t,"P",{"data-svelte-h":!0}),P(xt)!=="svelte-1yhjowm"&&(xt.textContent=js),Di=p(t),M(ut.$$.fragment,t),Ji=p(t),Tt=a(t,"P",{"data-svelte-h":!0}),P(Tt)!=="svelte-103bb0r"&&(Tt.textContent=Hs),Gi=p(t),mt=a(t,"P",{"data-svelte-h":!0}),P(mt)!=="svelte-12w85z6"&&(mt.textContent=$s),bi=p(t),M(vt.$$.fragment,t),ji=p(t),Ct=a(t,"P",{"data-svelte-h":!0}),P(Ct)!=="svelte-ekaxx1"&&(Ct.textContent=cs),Hi=p(t),ot=a(t,"P",{"data-svelte-h":!0}),P(ot)!=="svelte-iccih7"&&(ot.textContent=Ss),$i=p(t),rt=a(t,"P",{"data-svelte-h":!0}),P(rt)!=="svelte-7uyuw7"&&(rt.textContent=Ns),ci=p(t),Ut=a(t,"P",{"data-svelte-h":!0}),P(Ut)!=="svelte-i9uex1"&&(Ut.textContent=Is),Si=p(t),wt=a(t,"P",{"data-svelte-h":!0}),P(wt)!=="svelte-19oov4o"&&(wt.textContent=Es),Ni=p(t),Lt=a(t,"P",{"data-svelte-h":!0}),P(Lt)!=="svelte-p97sj8"&&(Lt.textContent=Rs),Ii=p(t),_t=a(t,"P",{"data-svelte-h":!0}),P(_t)!=="svelte-5ocmnf"&&(_t.textContent=Bs),Ei=p(t),ht=a(t,"P",{"data-svelte-h":!0}),P(ht)!=="svelte-1n2597e"&&(ht.textContent=Qs),Ri=p(t),dt=a(t,"OL",{"data-svelte-h":!0}),P(dt)!=="svelte-1xfpr0y"&&(dt.innerHTML=Zs),Bi=p(t),yt=a(t,"P",{"data-svelte-h":!0}),P(yt)!=="svelte-l6mji4"&&(yt.textContent=ks),Qi=p(t),Dt=a(t,"P",{"data-svelte-h":!0}),P(Dt)!=="svelte-1rje20u"&&(Dt.textContent=As),Zi=p(t),Jt=a(t,"P",{"data-svelte-h":!0}),P(Jt)!=="svelte-104xoaf"&&(Jt.textContent=gs),ki=p(t),Gt=a(t,"P",{"data-svelte-h":!0}),P(Gt)!=="svelte-1rxc69e"&&(Gt.textContent=Vs),Ai=p(t),bt=a(t,"P",{"data-svelte-h":!0}),P(bt)!=="svelte-1b2mzqh"&&(bt.textContent=Xs),gi=p(t),jt=a(t,"UL",{"data-svelte-h":!0}),P(jt)!=="svelte-1kdc4z9"&&(jt.innerHTML=Fs),Vi=p(t),M(Ht.$$.fragment,t),Xi=p(t),$t=a(t,"P",{"data-svelte-h":!0}),P($t)!=="svelte-1knls5m"&&($t.innerHTML=zs),Fi=p(t),ct=a(t,"P",{"data-svelte-h":!0}),P(ct)!=="svelte-1tk8x6l"&&(ct.textContent=Ws),zi=p(t),M(St.$$.fragment,t),Wi=p(t),Nt=a(t,"P",{"data-svelte-h":!0}),P(Nt)!=="svelte-tc8d5e"&&(Nt.textContent=Os),Oi=p(t),It=a(t,"P",{"data-svelte-h":!0}),P(It)!=="svelte-1bhur3f"&&(It.textContent=Ys),Yi=p(t),Et=a(t,"P",{"data-svelte-h":!0}),P(Et)!=="svelte-1phbvvb"&&(Et.textContent=qs),qi=p(t),Rt=a(t,"P",{"data-svelte-h":!0}),P(Rt)!=="svelte-1w5dvkg"&&(Rt.textContent=Ks),Ki=p(t),Bt=a(t,"UL",{"data-svelte-h":!0}),P(Bt)!=="svelte-1ks7vrz"&&(Bt.innerHTML=ta),tn=p(t),Qt=a(t,"P",{"data-svelte-h":!0}),P(Qt)!=="svelte-bj9kti"&&(Qt.textContent=ea),en=p(t),Zt=a(t,"P",{"data-svelte-h":!0}),P(Zt)!=="svelte-edjnsa"&&(Zt.innerHTML=la),ln=p(t),kt=a(t,"P",{"data-svelte-h":!0}),P(kt)!=="svelte-1q7hzge"&&(kt.innerHTML=ia),nn=p(t),At=a(t,"P",{"data-svelte-h":!0}),P(At)!=="svelte-8fnl63"&&(At.textContent=na),pn=p(t),gt=a(t,"P",{"data-svelte-h":!0}),P(gt)!=="svelte-1v2yyww"&&(gt.textContent=pa),sn=p(t),Vt=a(t,"P",{"data-svelte-h":!0}),P(Vt)!=="svelte-17bhy87"&&(Vt.innerHTML=sa),an=p(t),Xt=a(t,"P",{"data-svelte-h":!0}),P(Xt)!=="svelte-1n6ze23"&&(Xt.innerHTML=aa),Pn=p(t),Ft=a(t,"P",{"data-svelte-h":!0}),P(Ft)!=="svelte-2frj83"&&(Ft.innerHTML=Pa),fn=p(t),zt=a(t,"P",{"data-svelte-h":!0}),P(zt)!=="svelte-155mvto"&&(zt.innerHTML=fa),Mn=p(t),Wt=a(t,"P",{"data-svelte-h":!0}),P(Wt)!=="svelte-165iud9"&&(Wt.textContent=Ma),xn=p(t),Ot=a(t,"P",{"data-svelte-h":!0}),P(Ot)!=="svelte-1r4hea4"&&(Ot.innerHTML=xa),un=p(t),Yt=a(t,"P",{"data-svelte-h":!0}),P(Yt)!=="svelte-qga8n1"&&(Yt.textContent=ua),Tn=p(t),qt=a(t,"P",{"data-svelte-h":!0}),P(qt)!=="svelte-1r8j2il"&&(qt.textContent=Ta),mn=p(t),Kt=a(t,"UL",{"data-svelte-h":!0}),P(Kt)!=="svelte-1m54oo0"&&(Kt.innerHTML=ma),vn=p(t),te=a(t,"P",{"data-svelte-h":!0}),P(te)!=="svelte-x7onsk"&&(te.textContent=va),Cn=p(t),ee=a(t,"UL",{"data-svelte-h":!0}),P(ee)!=="svelte-n2xihd"&&(ee.innerHTML=Ca),on=p(t),le=a(t,"P",{"data-svelte-h":!0}),P(le)!=="svelte-1iww0fh"&&(le.textContent=oa),rn=p(t),ie=a(t,"UL",{"data-svelte-h":!0}),P(ie)!=="svelte-1fhhlbg"&&(ie.innerHTML=ra),Un=p(t),ne=a(t,"P",{"data-svelte-h":!0}),P(ne)!=="svelte-1by8oug"&&(ne.textContent=Ua),wn=p(t),pe=a(t,"P",{"data-svelte-h":!0}),P(pe)!=="svelte-1ddoxaq"&&(pe.textContent=wa),Ln=p(t),se=a(t,"UL",{"data-svelte-h":!0}),P(se)!=="svelte-aek6za"&&(se.innerHTML=La),_n=p(t),ae=a(t,"P",{"data-svelte-h":!0}),P(ae)!=="svelte-1gyn38w"&&(ae.innerHTML=_a),hn=p(t),Pe=a(t,"P",{"data-svelte-h":!0}),P(Pe)!=="svelte-1oz3i0j"&&(Pe.textContent=ha),dn=p(t),fe=a(t,"P",{"data-svelte-h":!0}),P(fe)!=="svelte-yyebt8"&&(fe.innerHTML=da),yn=p(t),Me=a(t,"P",{"data-svelte-h":!0}),P(Me)!=="svelte-1so65ff"&&(Me.textContent=ya),Dn=p(t),xe=a(t,"P",{"data-svelte-h":!0}),P(xe)!=="svelte-1569xz"&&(xe.innerHTML=Da),Jn=p(t),M(ue.$$.fragment,t),Gn=p(t),Te=a(t,"P",{"data-svelte-h":!0}),P(Te)!=="svelte-9pb2dz"&&(Te.textContent=Ja),bn=p(t),me=a(t,"P",{"data-svelte-h":!0}),P(me)!=="svelte-69l0ue"&&(me.innerHTML=Ga),jn=p(t),ve=a(t,"P",{"data-svelte-h":!0}),P(ve)!=="svelte-12qk9af"&&(ve.innerHTML=ba),Hn=p(t),Ce=a(t,"P",{"data-svelte-h":!0}),P(Ce)!=="svelte-1is9b6u"&&(Ce.innerHTML=ja),$n=p(t),oe=a(t,"P",{"data-svelte-h":!0}),P(oe)!=="svelte-bjqcm4"&&(oe.innerHTML=Ha),cn=p(t),re=a(t,"P",{"data-svelte-h":!0}),P(re)!=="svelte-wd2okf"&&(re.innerHTML=$a),Sn=p(t),Ue=a(t,"P",{"data-svelte-h":!0}),P(Ue)!=="svelte-17wn2am"&&(Ue.innerHTML=ca),Nn=p(t),we=a(t,"P",{"data-svelte-h":!0}),P(we)!=="svelte-v5hz18"&&(we.innerHTML=Sa),In=p(t),Le=a(t,"P",{"data-svelte-h":!0}),P(Le)!=="svelte-1ntqvm3"&&(Le.textContent=Na),En=p(t),_e=a(t,"P",{"data-svelte-h":!0}),P(_e)!=="svelte-ii1wqh"&&(_e.innerHTML=Ia),Rn=p(t),he=a(t,"P",{"data-svelte-h":!0}),P(he)!=="svelte-1xslm35"&&(he.textContent=Ea),Bn=p(t),de=a(t,"P",{"data-svelte-h":!0}),P(de)!=="svelte-sw9zg7"&&(de.textContent=Ra),Qn=p(t),ye=a(t,"UL",{"data-svelte-h":!0}),P(ye)!=="svelte-16pqr2f"&&(ye.innerHTML=Ba),Zn=p(t),De=a(t,"P",{"data-svelte-h":!0}),P(De)!=="svelte-1t1nzmn"&&(De.textContent=Qa),kn=p(t),Je=a(t,"UL",{"data-svelte-h":!0}),P(Je)!=="svelte-1o6x54n"&&(Je.innerHTML=Za),An=p(t),Ge=a(t,"P",{"data-svelte-h":!0}),P(Ge)!=="svelte-cztbby"&&(Ge.textContent=ka),gn=p(t),be=a(t,"UL",{"data-svelte-h":!0}),P(be)!=="svelte-e2tlha"&&(be.innerHTML=Aa),Vn=p(t),M(je.$$.fragment,t),Xn=p(t),He=a(t,"P",{"data-svelte-h":!0}),P(He)!=="svelte-1ft649q"&&(He.innerHTML=ga),Fn=p(t),$e=a(t,"P",{"data-svelte-h":!0}),P($e)!=="svelte-qmcl9c"&&($e.innerHTML=Va),zn=p(t),ce=a(t,"P",{"data-svelte-h":!0}),P(ce)!=="svelte-1kdddli"&&(ce.textContent=Xa),Wn=p(t),Se=a(t,"P",{"data-svelte-h":!0}),P(Se)!=="svelte-6mun4"&&(Se.textContent=Fa),On=p(t),Ne=a(t,"P",{"data-svelte-h":!0}),P(Ne)!=="svelte-1t1nzmn"&&(Ne.textContent=za),Yn=p(t),Ie=a(t,"UL",{"data-svelte-h":!0}),P(Ie)!=="svelte-1ry6c7"&&(Ie.innerHTML=Wa),qn=p(t),Ee=a(t,"P",{"data-svelte-h":!0}),P(Ee)!=="svelte-1cmjcnt"&&(Ee.textContent=Oa),Kn=p(t),M(Re.$$.fragment,t),tp=p(t),Be=a(t,"P",{"data-svelte-h":!0}),P(Be)!=="svelte-1qmo80m"&&(Be.textContent=Ya),ep=p(t),Qe=a(t,"P",{"data-svelte-h":!0}),P(Qe)!=="svelte-18rdwc7"&&(Qe.innerHTML=qa),lp=p(t),Ze=a(t,"P",{"data-svelte-h":!0}),P(Ze)!=="svelte-6bvqnr"&&(Ze.innerHTML=Ka),ip=p(t),ke=a(t,"P",{"data-svelte-h":!0}),P(ke)!=="svelte-1ctxp2k"&&(ke.textContent=t1),np=p(t),Ae=a(t,"P",{"data-svelte-h":!0}),P(Ae)!=="svelte-1t1nzmn"&&(Ae.textContent=e1),pp=p(t),ge=a(t,"UL",{"data-svelte-h":!0}),P(ge)!=="svelte-nixdp7"&&(ge.innerHTML=l1),sp=p(t),Ve=a(t,"P",{"data-svelte-h":!0}),P(Ve)!=="svelte-1deyqj7"&&(Ve.textContent=i1),ap=p(t),M(Xe.$$.fragment,t),Pp=p(t),Fe=a(t,"P",{"data-svelte-h":!0}),P(Fe)!=="svelte-1sixjhq"&&(Fe.textContent=n1),fp=p(t),ze=a(t,"P",{"data-svelte-h":!0}),P(ze)!=="svelte-dvn5ga"&&(ze.textContent=p1),Mp=p(t),We=a(t,"P",{"data-svelte-h":!0}),P(We)!=="svelte-18c9zhu"&&(We.textContent=s1),xp=p(t),Oe=a(t,"P",{"data-svelte-h":!0}),P(Oe)!=="svelte-hdy6eh"&&(Oe.textContent=a1),up=p(t),Ye=a(t,"P",{"data-svelte-h":!0}),P(Ye)!=="svelte-mqrqtn"&&(Ye.textContent=P1),Tp=p(t),qe=a(t,"P",{"data-svelte-h":!0}),P(qe)!=="svelte-1b2fyjn"&&(qe.textContent=f1),mp=p(t),Ke=a(t,"P",{"data-svelte-h":!0}),P(Ke)!=="svelte-1t1nzmn"&&(Ke.textContent=M1),vp=p(t),tl=a(t,"UL",{"data-svelte-h":!0}),P(tl)!=="svelte-1cblhzj"&&(tl.innerHTML=x1),Cp=p(t),el=a(t,"P",{"data-svelte-h":!0}),P(el)!=="svelte-1vvympt"&&(el.textContent=u1),op=p(t),ll=a(t,"UL",{"data-svelte-h":!0}),P(ll)!=="svelte-1czeqoh"&&(ll.innerHTML=T1),rp=p(t),il=a(t,"P",{"data-svelte-h":!0}),P(il)!=="svelte-1deyqj7"&&(il.textContent=m1),Up=p(t),M(nl.$$.fragment,t),wp=p(t),pl=a(t,"P",{"data-svelte-h":!0}),P(pl)!=="svelte-hf9mbc"&&(pl.innerHTML=v1),Lp=p(t),sl=a(t,"P",{"data-svelte-h":!0}),P(sl)!=="svelte-1ouo6uy"&&(sl.innerHTML=C1),_p=p(t),al=a(t,"P",{"data-svelte-h":!0}),P(al)!=="svelte-1cr6l18"&&(al.textContent=o1),hp=p(t),Pl=a(t,"OL",{"data-svelte-h":!0}),P(Pl)!=="svelte-ipafw6"&&(Pl.innerHTML=r1),dp=p(t),fl=a(t,"P",{"data-svelte-h":!0}),P(fl)!=="svelte-2h3m3n"&&(fl.textContent=U1),yp=p(t),Ml=a(t,"UL",{"data-svelte-h":!0}),P(Ml)!=="svelte-7owhqp"&&(Ml.innerHTML=w1),Dp=p(t),xl=a(t,"P",{"data-svelte-h":!0}),P(xl)!=="svelte-78y6sq"&&(xl.textContent=L1),Jp=p(t),ul=a(t,"UL",{"data-svelte-h":!0}),P(ul)!=="svelte-nr15rw"&&(ul.innerHTML=_1),Gp=p(t),Tl=a(t,"P",{"data-svelte-h":!0}),P(Tl)!=="svelte-yys12u"&&(Tl.textContent=h1),bp=p(t),ml=a(t,"UL",{"data-svelte-h":!0}),P(ml)!=="svelte-txq006"&&(ml.innerHTML=d1),jp=p(t),vl=a(t,"P",{"data-svelte-h":!0}),P(vl)!=="svelte-1i6ea3v"&&(vl.textContent=y1),Hp=p(t),Cl=a(t,"UL",{"data-svelte-h":!0}),P(Cl)!=="svelte-1ruobph"&&(Cl.innerHTML=D1),$p=p(t),ol=a(t,"P",{"data-svelte-h":!0}),P(ol)!=="svelte-1dun2jw"&&(ol.textContent=J1),cp=p(t),rl=a(t,"P",{"data-svelte-h":!0}),P(rl)!=="svelte-11zcqf6"&&(rl.textContent=G1),Sp=p(t),Ul=a(t,"P",{"data-svelte-h":!0}),P(Ul)!=="svelte-183itn7"&&(Ul.textContent=b1),Np=p(t),wl=a(t,"P",{"data-svelte-h":!0}),P(wl)!=="svelte-1pl4g43"&&(wl.textContent=j1),Ip=p(t),Ll=a(t,"P",{"data-svelte-h":!0}),P(Ll)!=="svelte-1dwdxtf"&&(Ll.innerHTML=H1),Ep=p(t),M(_l.$$.fragment,t),Rp=p(t),hl=a(t,"P",{"data-svelte-h":!0}),P(hl)!=="svelte-orwa44"&&(hl.textContent=$1),Bp=p(t),dl=a(t,"P",{"data-svelte-h":!0}),P(dl)!=="svelte-x7ybmv"&&(dl.innerHTML=c1),Qp=p(t),yl=a(t,"UL",{"data-svelte-h":!0}),P(yl)!=="svelte-1cwqz5w"&&(yl.innerHTML=S1),Zp=p(t),Dl=a(t,"P",{"data-svelte-h":!0}),P(Dl)!=="svelte-6aq26r"&&(Dl.innerHTML=N1),kp=p(t),Jl=a(t,"UL",{"data-svelte-h":!0}),P(Jl)!=="svelte-1vipcvs"&&(Jl.innerHTML=I1),Ap=p(t),Gl=a(t,"P",{"data-svelte-h":!0}),P(Gl)!=="svelte-13kh319"&&(Gl.innerHTML=E1),gp=p(t),bl=a(t,"UL",{"data-svelte-h":!0}),P(bl)!=="svelte-1yau8ud"&&(bl.innerHTML=R1),Vp=p(t),Hl=a(t,"P",{}),Q1(Hl).forEach(l),this.h()},h(){Z1(v,"name","hf:doc:metadata"),Z1(v,"content",q1)},m(t,e){z1(document.head,v),i(t,U,e),i(t,o,e),i(t,jl,e),x(w,t,e),i(t,Sl,e),i(t,L,e),i(t,Nl,e),x(r,t,e),i(t,Il,e),i(t,_,e),i(t,El,e),x(h,t,e),i(t,Rl,e),i(t,d,e),i(t,Bl,e),i(t,y,e),i(t,Ql,e),i(t,D,e),i(t,Zl,e),x(J,t,e),i(t,kl,e),i(t,G,e),i(t,Al,e),i(t,b,e),i(t,gl,e),i(t,j,e),i(t,Vl,e),i(t,H,e),i(t,Xl,e),x($,t,e),i(t,Fl,e),i(t,c,e),i(t,zl,e),x(S,t,e),i(t,Wl,e),i(t,N,e),i(t,Ol,e),i(t,I,e),i(t,Yl,e),i(t,E,e),i(t,ql,e),i(t,R,e),i(t,Kl,e),i(t,B,e),i(t,ti,e),i(t,Q,e),i(t,ei,e),i(t,Z,e),i(t,li,e),i(t,k,e),i(t,ii,e),i(t,A,e),i(t,ni,e),i(t,g,e),i(t,pi,e),i(t,V,e),i(t,si,e),i(t,X,e),i(t,ai,e),i(t,F,e),i(t,Pi,e),i(t,z,e),i(t,fi,e),i(t,W,e),i(t,Mi,e),i(t,O,e),i(t,xi,e),i(t,Y,e),i(t,ui,e),i(t,q,e),i(t,Ti,e),i(t,K,e),i(t,mi,e),i(t,tt,e),i(t,vi,e),i(t,et,e),i(t,Ci,e),x(lt,t,e),i(t,oi,e),i(t,it,e),i(t,ri,e),i(t,nt,e),i(t,Ui,e),x(pt,t,e),i(t,wi,e),i(t,st,e),i(t,Li,e),i(t,at,e),i(t,_i,e),i(t,Pt,e),i(t,hi,e),x(ft,t,e),i(t,di,e),i(t,Mt,e),i(t,yi,e),i(t,xt,e),i(t,Di,e),x(ut,t,e),i(t,Ji,e),i(t,Tt,e),i(t,Gi,e),i(t,mt,e),i(t,bi,e),x(vt,t,e),i(t,ji,e),i(t,Ct,e),i(t,Hi,e),i(t,ot,e),i(t,$i,e),i(t,rt,e),i(t,ci,e),i(t,Ut,e),i(t,Si,e),i(t,wt,e),i(t,Ni,e),i(t,Lt,e),i(t,Ii,e),i(t,_t,e),i(t,Ei,e),i(t,ht,e),i(t,Ri,e),i(t,dt,e),i(t,Bi,e),i(t,yt,e),i(t,Qi,e),i(t,Dt,e),i(t,Zi,e),i(t,Jt,e),i(t,ki,e),i(t,Gt,e),i(t,Ai,e),i(t,bt,e),i(t,gi,e),i(t,jt,e),i(t,Vi,e),x(Ht,t,e),i(t,Xi,e),i(t,$t,e),i(t,Fi,e),i(t,ct,e),i(t,zi,e),x(St,t,e),i(t,Wi,e),i(t,Nt,e),i(t,Oi,e),i(t,It,e),i(t,Yi,e),i(t,Et,e),i(t,qi,e),i(t,Rt,e),i(t,Ki,e),i(t,Bt,e),i(t,tn,e),i(t,Qt,e),i(t,en,e),i(t,Zt,e),i(t,ln,e),i(t,kt,e),i(t,nn,e),i(t,At,e),i(t,pn,e),i(t,gt,e),i(t,sn,e),i(t,Vt,e),i(t,an,e),i(t,Xt,e),i(t,Pn,e),i(t,Ft,e),i(t,fn,e),i(t,zt,e),i(t,Mn,e),i(t,Wt,e),i(t,xn,e),i(t,Ot,e),i(t,un,e),i(t,Yt,e),i(t,Tn,e),i(t,qt,e),i(t,mn,e),i(t,Kt,e),i(t,vn,e),i(t,te,e),i(t,Cn,e),i(t,ee,e),i(t,on,e),i(t,le,e),i(t,rn,e),i(t,ie,e),i(t,Un,e),i(t,ne,e),i(t,wn,e),i(t,pe,e),i(t,Ln,e),i(t,se,e),i(t,_n,e),i(t,ae,e),i(t,hn,e),i(t,Pe,e),i(t,dn,e),i(t,fe,e),i(t,yn,e),i(t,Me,e),i(t,Dn,e),i(t,xe,e),i(t,Jn,e),x(ue,t,e),i(t,Gn,e),i(t,Te,e),i(t,bn,e),i(t,me,e),i(t,jn,e),i(t,ve,e),i(t,Hn,e),i(t,Ce,e),i(t,$n,e),i(t,oe,e),i(t,cn,e),i(t,re,e),i(t,Sn,e),i(t,Ue,e),i(t,Nn,e),i(t,we,e),i(t,In,e),i(t,Le,e),i(t,En,e),i(t,_e,e),i(t,Rn,e),i(t,he,e),i(t,Bn,e),i(t,de,e),i(t,Qn,e),i(t,ye,e),i(t,Zn,e),i(t,De,e),i(t,kn,e),i(t,Je,e),i(t,An,e),i(t,Ge,e),i(t,gn,e),i(t,be,e),i(t,Vn,e),x(je,t,e),i(t,Xn,e),i(t,He,e),i(t,Fn,e),i(t,$e,e),i(t,zn,e),i(t,ce,e),i(t,Wn,e),i(t,Se,e),i(t,On,e),i(t,Ne,e),i(t,Yn,e),i(t,Ie,e),i(t,qn,e),i(t,Ee,e),i(t,Kn,e),x(Re,t,e),i(t,tp,e),i(t,Be,e),i(t,ep,e),i(t,Qe,e),i(t,lp,e),i(t,Ze,e),i(t,ip,e),i(t,ke,e),i(t,np,e),i(t,Ae,e),i(t,pp,e),i(t,ge,e),i(t,sp,e),i(t,Ve,e),i(t,ap,e),x(Xe,t,e),i(t,Pp,e),i(t,Fe,e),i(t,fp,e),i(t,ze,e),i(t,Mp,e),i(t,We,e),i(t,xp,e),i(t,Oe,e),i(t,up,e),i(t,Ye,e),i(t,Tp,e),i(t,qe,e),i(t,mp,e),i(t,Ke,e),i(t,vp,e),i(t,tl,e),i(t,Cp,e),i(t,el,e),i(t,op,e),i(t,ll,e),i(t,rp,e),i(t,il,e),i(t,Up,e),x(nl,t,e),i(t,wp,e),i(t,pl,e),i(t,Lp,e),i(t,sl,e),i(t,_p,e),i(t,al,e),i(t,hp,e),i(t,Pl,e),i(t,dp,e),i(t,fl,e),i(t,yp,e),i(t,Ml,e),i(t,Dp,e),i(t,xl,e),i(t,Jp,e),i(t,ul,e),i(t,Gp,e),i(t,Tl,e),i(t,bp,e),i(t,ml,e),i(t,jp,e),i(t,vl,e),i(t,Hp,e),i(t,Cl,e),i(t,$p,e),i(t,ol,e),i(t,cp,e),i(t,rl,e),i(t,Sp,e),i(t,Ul,e),i(t,Np,e),i(t,wl,e),i(t,Ip,e),i(t,Ll,e),i(t,Ep,e),x(_l,t,e),i(t,Rp,e),i(t,hl,e),i(t,Bp,e),i(t,dl,e),i(t,Qp,e),i(t,yl,e),i(t,Zp,e),i(t,Dl,e),i(t,kp,e),i(t,Jl,e),i(t,Ap,e),i(t,Gl,e),i(t,gp,e),i(t,bl,e),i(t,Vp,e),i(t,Hl,e),Xp=!0},p(t,[e]){const B1={};e&2&&(B1.$$scope={dirty:e,ctx:t}),r.$set(B1)},i(t){Xp||(u(w.$$.fragment,t),u(r.$$.fragment,t),u(h.$$.fragment,t),u(J.$$.fragment,t),u($.$$.fragment,t),u(S.$$.fragment,t),u(lt.$$.fragment,t),u(pt.$$.fragment,t),u(ft.$$.fragment,t),u(ut.$$.fragment,t),u(vt.$$.fragment,t),u(Ht.$$.fragment,t),u(St.$$.fragment,t),u(ue.$$.fragment,t),u(je.$$.fragment,t),u(Re.$$.fragment,t),u(Xe.$$.fragment,t),u(nl.$$.fragment,t),u(_l.$$.fragment,t),Xp=!0)},o(t){T(w.$$.fragment,t),T(r.$$.fragment,t),T(h.$$.fragment,t),T(J.$$.fragment,t),T($.$$.fragment,t),T(S.$$.fragment,t),T(lt.$$.fragment,t),T(pt.$$.fragment,t),T(ft.$$.fragment,t),T(ut.$$.fragment,t),T(vt.$$.fragment,t),T(Ht.$$.fragment,t),T(St.$$.fragment,t),T(ue.$$.fragment,t),T(je.$$.fragment,t),T(Re.$$.fragment,t),T(Xe.$$.fragment,t),T(nl.$$.fragment,t),T(_l.$$.fragment,t),Xp=!1},d(t){t&&(l(U),l(o),l(jl),l(Sl),l(L),l(Nl),l(Il),l(_),l(El),l(Rl),l(d),l(Bl),l(y),l(Ql),l(D),l(Zl),l(kl),l(G),l(Al),l(b),l(gl),l(j),l(Vl),l(H),l(Xl),l(Fl),l(c),l(zl),l(Wl),l(N),l(Ol),l(I),l(Yl),l(E),l(ql),l(R),l(Kl),l(B),l(ti),l(Q),l(ei),l(Z),l(li),l(k),l(ii),l(A),l(ni),l(g),l(pi),l(V),l(si),l(X),l(ai),l(F),l(Pi),l(z),l(fi),l(W),l(Mi),l(O),l(xi),l(Y),l(ui),l(q),l(Ti),l(K),l(mi),l(tt),l(vi),l(et),l(Ci),l(oi),l(it),l(ri),l(nt),l(Ui),l(wi),l(st),l(Li),l(at),l(_i),l(Pt),l(hi),l(di),l(Mt),l(yi),l(xt),l(Di),l(Ji),l(Tt),l(Gi),l(mt),l(bi),l(ji),l(Ct),l(Hi),l(ot),l($i),l(rt),l(ci),l(Ut),l(Si),l(wt),l(Ni),l(Lt),l(Ii),l(_t),l(Ei),l(ht),l(Ri),l(dt),l(Bi),l(yt),l(Qi),l(Dt),l(Zi),l(Jt),l(ki),l(Gt),l(Ai),l(bt),l(gi),l(jt),l(Vi),l(Xi),l($t),l(Fi),l(ct),l(zi),l(Wi),l(Nt),l(Oi),l(It),l(Yi),l(Et),l(qi),l(Rt),l(Ki),l(Bt),l(tn),l(Qt),l(en),l(Zt),l(ln),l(kt),l(nn),l(At),l(pn),l(gt),l(sn),l(Vt),l(an),l(Xt),l(Pn),l(Ft),l(fn),l(zt),l(Mn),l(Wt),l(xn),l(Ot),l(un),l(Yt),l(Tn),l(qt),l(mn),l(Kt),l(vn),l(te),l(Cn),l(ee),l(on),l(le),l(rn),l(ie),l(Un),l(ne),l(wn),l(pe),l(Ln),l(se),l(_n),l(ae),l(hn),l(Pe),l(dn),l(fe),l(yn),l(Me),l(Dn),l(xe),l(Jn),l(Gn),l(Te),l(bn),l(me),l(jn),l(ve),l(Hn),l(Ce),l($n),l(oe),l(cn),l(re),l(Sn),l(Ue),l(Nn),l(we),l(In),l(Le),l(En),l(_e),l(Rn),l(he),l(Bn),l(de),l(Qn),l(ye),l(Zn),l(De),l(kn),l(Je),l(An),l(Ge),l(gn),l(be),l(Vn),l(Xn),l(He),l(Fn),l($e),l(zn),l(ce),l(Wn),l(Se),l(On),l(Ne),l(Yn),l(Ie),l(qn),l(Ee),l(Kn),l(tp),l(Be),l(ep),l(Qe),l(lp),l(Ze),l(ip),l(ke),l(np),l(Ae),l(pp),l(ge),l(sp),l(Ve),l(ap),l(Pp),l(Fe),l(fp),l(ze),l(Mp),l(We),l(xp),l(Oe),l(up),l(Ye),l(Tp),l(qe),l(mp),l(Ke),l(vp),l(tl),l(Cp),l(el),l(op),l(ll),l(rp),l(il),l(Up),l(wp),l(pl),l(Lp),l(sl),l(_p),l(al),l(hp),l(Pl),l(dp),l(fl),l(yp),l(Ml),l(Dp),l(xl),l(Jp),l(ul),l(Gp),l(Tl),l(bp),l(ml),l(jp),l(vl),l(Hp),l(Cl),l($p),l(ol),l(cp),l(rl),l(Sp),l(Ul),l(Np),l(wl),l(Ip),l(Ll),l(Ep),l(Rp),l(hl),l(Bp),l(dl),l(Qp),l(yl),l(Zp),l(Dl),l(kp),l(Jl),l(Ap),l(Gl),l(gp),l(bl),l(Vp),l(Hl)),l(v),m(w,t),m(r,t),m(h,t),m(J,t),m($,t),m(S,t),m(lt,t),m(pt,t),m(ft,t),m(ut,t),m(vt,t),m(Ht,t),m(St,t),m(ue,t),m(je,t),m(Re,t),m(Xe,t),m(nl,t),m(_l,t)}}}const q1='{"title":"Efficient Training on Multiple GPUs","local":"efficient-training-on-multiple-gpus","sections":[{"title":"Concepts","local":"concepts","sections":[],"depth":2},{"title":"Scalability Strategy","local":"scalability-strategy","sections":[],"depth":2},{"title":"Data Parallelism","local":"data-parallelism","sections":[{"title":"DP vs DDP","local":"dp-vs-ddp","sections":[],"depth":3}],"depth":2},{"title":"ZeRO Data Parallelism","local":"zero-data-parallelism","sections":[],"depth":2},{"title":"Naive Model Parallelism (Vertical) and Pipeline Parallelism","local":"naive-model-parallelism-vertical-and-pipeline-parallelism","sections":[],"depth":2},{"title":"Tensor Parallelism","local":"tensor-parallelism","sections":[],"depth":2},{"title":"DP+PP","local":"dppp","sections":[],"depth":2},{"title":"DP+PP+TP","local":"dppptp","sections":[],"depth":2},{"title":"ZeRO DP+PP+TP","local":"zero-dppptp","sections":[],"depth":2},{"title":"FlexFlow","local":"flexflow","sections":[],"depth":2},{"title":"Which Strategy To Use When","local":"which-strategy-to-use-when","sections":[],"depth":2}],"depth":1}';function K1(cl){return A1(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pP extends V1{constructor(v){super(),X1(this,v,K1,Y1,k1,{})}}export{pP as component};
