import{s as _p,o as Dp,n as ql}from"../chunks/scheduler.9bc65507.js";import{S as Hp,i as Gp,g as s,s as n,r as d,A as jp,h as o,f as l,c as a,j as $p,u as c,x as r,k as U,y as Ip,a as i,v,d as w,t as y,w as P}from"../chunks/index.707bf1b6.js";import{T as Ls}from"../chunks/Tip.c2ecdbf4.js";import{C as b}from"../chunks/CodeBlock.54a9f38d.js";import{H as C}from"../chunks/Heading.342b1fa6.js";import{H as Jp,a as $s}from"../chunks/HfOption.6d864328.js";function kp(T){let p,g=`While the main concepts discussed in this guide are likely applicable across frameworks, here we focus on
PyTorch-based implementations.`;return{c(){p=s("p"),p.textContent=g},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-11nx342"&&(p.textContent=g)},m(f,u){i(f,p,u)},p:ql,d(f){f&&l(p)}}}function Sp(T){let p,g=`This mechanism is similar to an efficient group backpacking strategy: person A carries the tent, person B carries the stove,
and person C carries the axe. Each night they all share what they have with others and get from others what they don’t have,
and in the morning they pack up their allocated type of gear and continue on their way. This is what ZeRO DP/Sharded DDP is.
Compare this strategy to the simple one where each person has to carry their own tent, stove and axe (similar to
DataParallel (DP and DDP) in PyTorch), which would be far more inefficient.`;return{c(){p=s("p"),p.textContent=g},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-15youi0"&&(p.textContent=g)},m(f,u){i(f,p,u)},p:ql,d(f){f&&l(p)}}}function Ep(T){let p,g="Use the <code>--nproc_per_node</code> to select how many GPUs to use.",f,u,M;return u=new b({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMCUyMHRyYWluZXItcHJvZ3JhbS5weSUyMC4uLg==",highlighted:"torchrun --nproc_per_node=2  trainer-program.py ...",wrap:!1}}),{c(){p=s("p"),p.innerHTML=g,f=n(),d(u.$$.fragment)},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-ghitll"&&(p.innerHTML=g),f=a(h),c(u.$$.fragment,h)},m(h,m){i(h,p,m),i(h,f,m),v(u,h,m),M=!0},p:ql,i(h){M||(w(u.$$.fragment,h),M=!0)},o(h){y(u.$$.fragment,h),M=!1},d(h){h&&(l(p),l(f)),P(u,h)}}}function Vp(T){let p,g="Use <code>--num_processes</code> to select how many GPUs to use.",f,u,M;return u=new b({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbnVtX3Byb2Nlc3NlcyUyMDIlMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"accelerate launch --num_processes 2 trainer-program.py ...",wrap:!1}}),{c(){p=s("p"),p.innerHTML=g,f=n(),d(u.$$.fragment)},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-15fv5d7"&&(p.innerHTML=g),f=a(h),c(u.$$.fragment,h)},m(h,m){i(h,p,m),i(h,f,m),v(u,h,m),M=!0},p:ql,i(h){M||(w(u.$$.fragment,h),M=!0)},o(h){y(u.$$.fragment,h),M=!1},d(h){h&&(l(p),l(f)),P(u,h)}}}function Ap(T){let p,g="Use <code>--num_gpus</code> to select how many GPUs to use.",f,u,M;return u=new b({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDIlMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"deepspeed --num_gpus 2 trainer-program.py ...",wrap:!1}}),{c(){p=s("p"),p.innerHTML=g,f=n(),d(u.$$.fragment)},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-14evfjd"&&(p.innerHTML=g),f=a(h),c(u.$$.fragment,h)},m(h,m){i(h,p,m),i(h,f,m),v(u,h,m),M=!0},p:ql,i(h){M||(w(u.$$.fragment,h),M=!0)},o(h){y(u.$$.fragment,h),M=!1},d(h){h&&(l(p),l(f)),P(u,h)}}}function Rp(T){let p,g,f,u,M,h;return p=new $s({props:{id:"select-gpu",option:"torchrun",$$slots:{default:[Ep]},$$scope:{ctx:T}}}),f=new $s({props:{id:"select-gpu",option:"Accelerate",$$slots:{default:[Vp]},$$scope:{ctx:T}}}),M=new $s({props:{id:"select-gpu",option:"DeepSpeed",$$slots:{default:[Ap]},$$scope:{ctx:T}}}),{c(){d(p.$$.fragment),g=n(),d(f.$$.fragment),u=n(),d(M.$$.fragment)},l(m){c(p.$$.fragment,m),g=a(m),c(f.$$.fragment,m),u=a(m),c(M.$$.fragment,m)},m(m,x){v(p,m,x),i(m,g,x),v(f,m,x),i(m,u,x),v(M,m,x),h=!0},p(m,x){const z={};x&2&&(z.$$scope={dirty:x,ctx:m}),p.$set(z);const L={};x&2&&(L.$$scope={dirty:x,ctx:m}),f.$set(L);const Kl={};x&2&&(Kl.$$scope={dirty:x,ctx:m}),M.$set(Kl)},i(m){h||(w(p.$$.fragment,m),w(f.$$.fragment,m),w(M.$$.fragment,m),h=!0)},o(m){y(p.$$.fragment,m),y(f.$$.fragment,m),y(M.$$.fragment,m),h=!1},d(m){m&&(l(g),l(u)),P(p,m),P(f,m),P(M,m)}}}function Np(T){let p,g="As with any environment variable, they can be exported instead of being added to the command line. However, this is not recommended because it can be confusing if you forget how the environment variable was setup and you end up using the wrong GPUs. Instead, it is common practice to set the environment variable for a specific training run on the same command line.";return{c(){p=s("p"),p.textContent=g},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1ky103q"&&(p.textContent=g)},m(f,u){i(f,p,u)},p:ql,d(f){f&&l(p)}}}function zp(T){let p,g,f,u,M,h,m,x=`If training a model on a single GPU is too slow or if the model’s weights do not fit in a single GPU’s memory, transitioning
to a multi-GPU setup may be a viable option. Prior to making this transition, thoroughly explore all the strategies covered
in the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a> as they are universally applicable
to model training on any number of GPUs. Once you have employed those strategies and found them insufficient for your
case on a single GPU, consider moving to multiple GPUs.`,z,L,Kl=`Transitioning from a single GPU to multiple GPUs requires the introduction of some form of parallelism, as the workload
must be distributed across the resources. Multiple techniques can be employed to achieve parallelism, such as data
parallelism, tensor parallelism, and pipeline parallelism. It’s important to note that there isn’t a one-size-fits-all
solution, and the optimal settings depend on the specific hardware configuration you are using.`,ti,B,_s=`This guide offers an in-depth overview of individual types of parallelism, as well as guidance on ways to combine<br/>
techniques and choosing an appropriate approach. For step-by-step tutorials on distributed training, please refer to
the <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate documentation</a>.`,li,$,ii,Q,Ds=`Before diving deeper into the specifics of each technique, let’s go over the rough decision process when training
large models on a large infrastructure.`,ni,W,ai,F,Hs=`Begin by estimating how much vRAM is required to train your model. For models hosted on the 🤗 Hub, use our
<a href="https://huggingface.co/spaces/hf-accelerate/model-memory-usage" rel="nofollow">Model Memory Calculator</a>, which gives you
accurate calculations within a few percent margin.`,si,Z,Gs="<strong>Parallelization strategy for a single Node / multi-GPU setup</strong>",oi,X,js=`When training a model on a single node with multiple GPUs, your choice of parallelization strategy can significantly
impact performance. Here’s a breakdown of your options:`,ri,O,Is="<strong>Case 1: Your model fits onto a single GPU</strong>",pi,Y,Js="If your model can comfortably fit onto a single GPU, you have two primary options:",hi,q,ks="<li>DDP - Distributed DataParallel</li> <li>ZeRO - depending on the situation and configuration used, this method may or may not be faster, however, it’s worth experimenting with it.</li>",mi,K,Ss="<strong>Case 2: Your model doesn’t fit onto a single GPU:</strong>",fi,ee,Es="If your model is too large for a single GPU, you have several alternatives to consider:",ui,te,Vs="<li>PipelineParallel (PP)</li> <li>ZeRO</li> <li>TensorParallel (TP)</li>",di,le,As=`With very fast inter-node connectivity (e.g., NVLINK or NVSwitch) all three strategies (PP, ZeRO, TP) should result in
similar performance. However, without these, PP will be faster than TP or ZeRO. The degree of TP may also
make a difference. It’s best to experiment with your specific setup to determine the most suitable strategy.`,ci,ie,Rs="TP is almost always used within a single node. That is TP size <= GPUs per node.",vi,ne,Ns="<strong>Case 3: Largest layer of your model does not fit onto a single GPU</strong>",wi,ae,zs='<li>If you are not using ZeRO, you have to use TensorParallel (TP), because PipelineParallel (PP) alone won’t be sufficient to accommodate the large layer.</li> <li>If you are using ZeRO, additionally adopt techniques from the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a>.</li>',yi,se,Bs="<strong>Parallelization strategy for a multi-Node / multi-GPU setup</strong>",Pi,oe,Qs="<li><p>When you have fast inter-node connectivity (e.g., NVLINK or NVSwitch) consider using one of these options:</p> <ol><li>ZeRO - as it requires close to no modifications to the model</li> <li>A combination of PipelineParallel(PP) with TensorParallel(TP) and DataParallel(DP) - this approach will result in fewer communications, but requires significant changes to the model</li></ol></li> <li><p>When you have slow inter-node connectivity and still low on GPU memory:</p> <ol><li>Employ a combination of DataParallel(DP) with PipelineParallel(PP), TensorParallel(TP), and ZeRO.</li></ol></li>",Mi,re,Ws="In the following sections of this guide we dig deeper into how these different parallelism methods work.",gi,pe,Ti,he,Fs=`Even with only 2 GPUs, you can readily leverage the accelerated training capabilities offered by PyTorch’s built-in features,
such as <code>DataParallel</code> (DP) and <code>DistributedDataParallel</code> (DDP). Note that
<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">PyTorch documentation</a> recommends to prefer
<code>DistributedDataParallel</code> (DDP) over <code>DataParallel</code> (DP) for multi-GPU training as it works for all models.
Let’s take a look at how these two methods work and what makes them different.`,xi,me,bi,fe,Zs="To understand the key differences in inter-GPU communication overhead between the two methods, let’s review the processes per batch:",Ci,ue,Xs='<a href="https://pytorch.org/docs/master/notes/ddp.html" rel="nofollow">DDP</a>:',Ui,de,Os="<li>At the start time the main process replicates the model once from GPU 0 to the rest of GPUs</li> <li>Then for each batch:<ol><li>Each GPU directly consumes its mini-batch of data.</li> <li>During <code>backward</code>, once the local gradients are ready, they are averaged across all processes.</li></ol></li>",Li,ce,Ys='<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">DP</a>:',$i,ve,qs="For each batch:",_i,we,Ks="<li>GPU 0 reads the batch of data and then sends a mini-batch to each GPU.</li> <li>The up-to-date model is replicated from GPU 0 to each GPU.</li> <li><code>forward</code> is executed, and output from each GPU is sent to GPU 0 to compute the loss.</li> <li>The loss is distributed from GPU 0 to all GPUs, and <code>backward</code> is run.</li> <li>Gradients from each GPU are sent to GPU 0 and averaged.</li>",Di,ye,eo="Key differences include:",Hi,Pe,to=`<li>DDP performs only a single communication per batch - sending gradients, while DP performs five different data exchanges per batch.
DDP copies data using <a href="https://pytorch.org/docs/master/distributed.html" rel="nofollow">torch.distributed</a>, while DP copies data within
the process via Python threads (which introduces limitations associated with GIL). As a result, <strong><code>DistributedDataParallel</code> (DDP) is generally faster than <code>DataParallel</code> (DP)</strong> unless you have slow GPU card inter-connectivity.</li> <li>Under DP, GPU 0 performs significantly more work than other GPUs, resulting in GPU under-utilization.</li> <li>DDP supports distributed training across multiple machines, whereas DP does not.</li>`,Gi,Me,lo=`This is not an exhaustive list of differences between DP and DDP, however, other nuances are out of scope of this guide.
You can get a deeper understanding of these methods by reading this <a href="https://www.telesens.co/2019/04/04/distributed-data-parallel-training-using-pytorch-on-aws/" rel="nofollow">article</a>.`,ji,ge,io=`Let’s illustrate the differences between DP and DDP with an experiment. We’ll benchmark the differences between DP and
DDP with an added context of NVLink presence:`,Ii,Te,no="<li>Hardware: 2x TITAN RTX 24GB each + NVlink with 2 NVLinks (<code>NV2</code> in <code>nvidia-smi topo -m</code>).</li> <li>Software: <code>pytorch-1.8-to-be</code> + <code>cuda-11.0</code> / <code>transformers==4.3.0.dev0</code>.</li>",Ji,xe,ao="To disable the NVLink feature on one of the benchmarks, we use <code>NCCL_P2P_DISABLE=1</code>.",ki,be,so="Here is the benchmarking code and outputs:",Si,Ce,oo="<strong>DP</strong>",Ei,Ue,Vi,Le,ro="<strong>DDP w/ NVlink</strong>",Ai,$e,Ri,_e,po="<strong>DDP w/o NVlink</strong>",Ni,De,zi,He,ho="Here are the same benchmarking results gathered in a table for convenience:",Bi,Ge,mo='<thead><tr><th align="left">Type</th> <th>NVlink</th> <th align="right">Time</th></tr></thead> <tbody><tr><td align="left">2:DP</td> <td>Y</td> <td align="right">110s</td></tr> <tr><td align="left">2:DDP</td> <td>Y</td> <td align="right">101s</td></tr> <tr><td align="left">2:DDP</td> <td>N</td> <td align="right">131s</td></tr></tbody>',Qi,je,fo=`As you can see, in this case DP is ~10% slower than DDP with NVlink, but ~15% faster than DDP without NVlink.
The real difference will depend on how much data each GPU needs to sync with the others - the more there is to sync,
the more a slow link will impede the overall runtime.`,Wi,Ie,Fi,Je,uo='ZeRO-powered data parallelism (ZeRO-DP) is illustrated in the following diagram from this <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">blog post</a>.',Zi,_,co='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="DeepSpeed-Image-1"/>',Xi,ke,vo=`While it may appear complex, it is a very similar concept to <code>DataParallel</code> (DP). The difference is that instead of
replicating the full model parameters, gradients and optimizer states, each GPU stores only a slice of it. Then, at
run-time when the full layer parameters are needed just for the given layer, all GPUs synchronize to give each other
parts that they miss.`,Oi,Se,wo=`To illustrate this idea, consider a simple model with 3 layers (La, Lb, and Lc), where each layer has 3 parameters.
Layer La, for example, has weights a0, a1 and a2:`,Yi,Ee,qi,Ve,yo="If we have 3 GPUs, ZeRO-DP splits the model onto 3 GPUs like so:",Ki,Ae,en,Re,Po=`In a way, this is the same horizontal slicing as tensor parallelism, as opposed to Vertical
slicing, where one puts whole layer-groups on different GPUs. Now let’s see how this works:`,tn,Ne,Mo="Each of these GPUs will get the usual mini-batch as it works in DP:",ln,ze,nn,Be,go="The inputs are passed without modifications as if they would be processed by the original model.",an,Qe,To="First, the inputs get to the layer <code>La</code>. What happens at this point?",sn,We,xo=`On GPU0: the x0 mini-batch requires the a0, a1, a2 parameters to do its forward path through the layer, but the GPU0 has only a0.
It will get a1 from GPU1 and a2 from GPU2, bringing all the pieces of the model together.`,on,Fe,bo=`In parallel, GPU1 gets another mini-batch - x1. GPU1 has the a1 parameter, but needs a0 and a2, so it gets those from GPU0 and GPU2.
Same happens to GPU2 that gets the mini-batch x2. It gets a0 and a1 from GPU0 and GPU1.`,rn,Ze,Co=`This way each of the 3 GPUs gets the full tensors reconstructed and makes a forward pass with its own mini-batch.
As soon as the calculation is done, the data that is no longer needed gets dropped - it’s only used during the calculation.
The reconstruction is done efficiently via a pre-fetch.`,pn,Xe,Uo="Then the whole process is repeated for layer Lb, then Lc forward-wise, and then backward Lc -> Lb -> La.",hn,D,mn,Oe,Lo=`While reading the literature on this topic you may encounter the following synonyms: Sharded, Partitioned.
If you pay close attention the way ZeRO partitions the model’s weights - it looks very similar to tensor parallelism
which will be discussed later. This is because it partitions/shards each layer’s weights, unlike vertical model parallelism
which is discussed next.`,fn,Ye,$o="Implementations:",un,qe,_o='<li><a href="https://www.deepspeed.ai/tutorials/zero/" rel="nofollow">DeepSpeed</a> ZeRO-DP stages 1+2+3</li> <li><a href="https://huggingface.co/docs/accelerate/en/usage_guides/deepspeed" rel="nofollow"><code>Accelerate</code> integration</a></li> <li><a href="main_classes/trainer#trainer-integrations"><code>transformers</code> integration</a></li>',dn,Ke,cn,et,Do=`To explain Pipeline parallelism, we’ll first look into Naive Model Parallelism (MP), also known as Vertical MP. This approach
involves distributing groups of model layers across multiple GPUs by assigning specific layers to specific GPUs with <code>.to()</code>.
As data flows through these layers, it is moved to the same GPU as the layer, while the other layers remain untouched.`,vn,tt,Ho=`We refer to this Model parallelism as “Vertical” because of how models are typically visualized. For example, the
following diagram shows an 8-layer model split vertically into two slices, placing layers 0-3 onto
GPU0 and 4-7 to GPU1:`,wn,lt,yn,it,Go=`In this example, when data moves from layer 0 to 3, it’s no different from regular forward pass. However, passing data
from layer 3 to 4 requires moving it from GPU0 to GPU1, introducing a communication overhead. If the participating
GPUs are on the same compute node (e.g. same physical machine) this copying is fast, but if the GPUs are distributed
across different compute nodes (e.g. multiple machines), the communication overhead could be substantially greater.`,Pn,nt,jo=`Following that, layers 4 to 7 work as they would in the original model. Upon completion of the 7th layer, there is often
a need to send the data back to layer 0 where the labels are (or alternatively send the labels to the last layer). Now the loss can be
computed and the optimizer can do its work.`,Mn,at,Io="Naive Model Parallelism comes several shortcomings:",gn,st,Jo="<li><strong>All but one GPU are idle at any given moment</strong>: if 4 GPUs are used, it’s nearly identical to quadrupling the amount of memory of a single GPU, and ignoring the rest of the hardware.</li> <li><strong>Overhead in data transfer between devices</strong>:  E.g. 4x 6GB cards will be able to accommodate the same size as 1x 24GB card using naive MP, but a single 24GB card will complete the training faster, because it doesn’t have the data copying overhead. But, say, if you have 40GB cards and need to fit a 45GB model you can with 4x 40GB cards (but barely because of the gradient and optimizer states)</li> <li><strong>Copying shared embeddings</strong>: Shared embeddings may need to get copied back and forth between GPUs.</li>",Tn,ot,ko=`Now that you are familiar with how the naive approach to model parallelism works and its shortcomings, let’s look at Pipeline Parallelism (PP).
PP is almost identical to a naive MP, but it solves the GPU idling problem by chunking the incoming batch into micro-batches
and artificially creating a pipeline, which allows different GPUs to concurrently participate in the computation process.`,xn,rt,So=`The following illustration from the <a href="https://ai.googleblog.com/2019/03/introducing-gpipe-open-source-library.html" rel="nofollow">GPipe paper</a>
shows the naive MP on the top, and PP on the bottom:`,bn,H,Eo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-gpipe-bubble.png" alt="MP vs PP"/>',Cn,pt,Vo=`At the bottom of the diagram, you can observe that the Pipeline Parallelism (PP) approach minimizes the number of idle
GPU zones, referred to as ‘bubbles’. Both parts of the diagram show a parallelism level of degree 4, meaning that 4 GPUs
are involved in the pipeline. You can see that there’s a forward path of 4 pipe stages (F0, F1, F2 and F3) followed by
a backward path in reverse order (B3, B2, B1, and B0).`,Un,ht,Ao=`PP introduces a new hyperparameter to tune - <code>chunks</code>, which determines how many data chunks are sent in a sequence
through the same pipe stage. For example, in the bottom diagram you can see <code>chunks=4</code>. GPU0 performs the same
forward path on chunk 0, 1, 2 and 3 (F0,0, F0,1, F0,2, F0,3) and then it waits for other GPUs to do complete their work.
Only when the other GPUs begin to complete their work, GPU0 starts to work again doing the backward path for chunks
3, 2, 1 and 0 (B0,3, B0,2, B0,1, B0,0).`,Ln,mt,Ro=`Note that this is the same concept as gradient accumulation steps. PyTorch uses <code>chunks</code>, while DeepSpeed refers
to the same hyperparameter as gradient accumulation steps.`,$n,ft,No=`Because of the chunks, PP introduces the notion of micro-batches (MBS). DP splits the global data batch size into
mini-batches, so if you have a DP degree of 4, a global batch size of 1024 gets split up into 4 mini-batches of
256 each (1024/4). And if the number of <code>chunks</code> (or GAS) is 32 we end up with a micro-batch size of 8 (256/32). Each
Pipeline stage works with a single micro-batch at a time. To calculate the global batch size of the DP + PP setup,
use the formula: <code>mbs * chunks * dp_degree</code> (<code>8 * 32 * 4 = 1024</code>).
With <code>chunks=1</code> you end up with the naive MP, which is inefficient. With a large <code>chunks</code> value you end up with
tiny micro-batch sizes which is also inefficient. For this reason, we encourage to experiment with the <code>chunks</code> value to
find the one that leads to the most efficient GPUs utilization.`,_n,ut,zo=`You may notice a bubble of “dead” time on the diagram that can’t be parallelized because the last <code>forward</code> stage
has to wait for <code>backward</code> to complete the pipeline. The purpose of finding the best value for <code>chunks</code> is to enable a high
concurrent GPU utilization across all participating GPUs which translates to minimizing the size of the bubble.`,Dn,dt,Bo="Pipeline API solutions have been implemented in:",Hn,ct,Qo="<li>PyTorch</li> <li>DeepSpeed</li> <li>Megatron-LM</li>",Gn,vt,Wo="These come with some shortcomings:",jn,wt,Fo='<li>They have to modify the model quite heavily, because Pipeline requires one to rewrite the normal flow of modules into a <code>nn.Sequential</code> sequence of the same, which may require changes to the design of the model.</li> <li>Currently the Pipeline API is very restricted. If you had a bunch of Python variables being passed in the very first stage of the Pipeline, you will have to find a way around it. Currently, the pipeline interface requires either a single Tensor or a tuple of Tensors as the only input and output. These tensors must have a batch size as the very first dimension, since pipeline is going to chunk the mini batch into micro-batches. Possible improvements are being discussed here <a href="https://github.com/pytorch/pytorch/pull/50693" rel="nofollow">https://github.com/pytorch/pytorch/pull/50693</a></li> <li>Conditional control flow at the level of pipe stages is not possible - e.g., Encoder-Decoder models like T5 require special workarounds to handle a conditional encoder stage.</li> <li>They have to arrange each layer so that the output of one layer becomes an input to the other layer.</li>',In,yt,Zo="More recent solutions include:",Jn,Pt,Xo="<li>Varuna</li> <li>Sagemaker</li>",kn,Mt,Oo=`We have not experimented with Varuna and SageMaker but their papers report that they have overcome the list of problems
mentioned above and that they require smaller changes to the user’s model.`,Sn,gt,Yo="Implementations:",En,Tt,qo='<li><a href="https://pytorch.org/docs/stable/pipeline.html" rel="nofollow">PyTorch</a> (initial support in pytorch-1.8, and progressively getting improved in 1.9 and more so in 1.10). Some <a href="https://github.com/pytorch/pytorch/blob/master/benchmarks/distributed/pipeline/pipe.py" rel="nofollow">examples</a></li> <li><a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation - no API.</li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> - this is implemented based on the Hugging Face Transformers.</li>',Vn,xt,Ko=`🤗 Transformers status: as of this writing none of the models supports full-PP. GPT2 and T5 models have naive MP support.
The main obstacle is being unable to convert the models to <code>nn.Sequential</code> and have all the inputs to be Tensors. This
is because currently the models include many features that make the conversion very complicated, and will need to be removed to accomplish that.`,An,bt,er='DeepSpeed and Megatron-LM integrations are available in <a href="https://huggingface.co/docs/accelerate/main/en/usage_guides/deepspeed" rel="nofollow">🤗 Accelerate</a>',Rn,Ct,tr="Other approaches:",Nn,Ut,lr='DeepSpeed, Varuna and SageMaker use the concept of an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-parallel-core-features.html" rel="nofollow">Interleaved Pipeline</a>',zn,G,ir='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-sagemaker-interleaved-pipeline.png" alt="Interleaved pipeline execution"/>',Bn,Lt,nr=`Here the bubble (idle time) is further minimized by prioritizing backward passes. Varuna further attempts to improve the
schedule by using simulations to discover the most efficient scheduling.`,Qn,$t,ar="OSLO has pipeline parallelism implementation based on the Transformers without <code>nn.Sequential</code> conversion.",Wn,_t,Fn,Dt,sr=`In Tensor Parallelism, each GPU processes a slice of a tensor and only aggregates the full tensor for operations requiring it.
To describe this method, this section of the guide relies on the concepts and diagrams from the <a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>
paper: <a href="https://arxiv.org/abs/2104.04473" rel="nofollow">Efficient Large-Scale Language Model Training on GPU Clusters</a>.`,Zn,Ht,or=`The main building block of any transformer is a fully connected <code>nn.Linear</code> followed by a nonlinear activation <code>GeLU</code>.
The dot dot-product part of it, following the Megatron’s paper notation, can be written as <code>Y = GeLU(XA)</code>, where <code>X</code> is
an input vector, <code>Y</code> is the output vector, and <code>A</code> is the weight matrix.`,Xn,Gt,rr="If we look at the computation in matrix form, you can see how the matrix multiplication can be split between multiple GPUs:",On,j,pr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_gemm.png" alt="Parallel GEMM"/>',Yn,jt,hr=`If we split the weight matrix <code>A</code> column-wise across <code>N</code> GPUs and perform matrix multiplications <code>XA_1</code> through <code>XA_n</code> in parallel,
then we will end up with <code>N</code> output vectors <code>Y_1, Y_2, ..., Y_n</code> which can be fed into <code>GeLU</code> independently:`,qn,I,mr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-independent-gelu.png" alt="Independent GeLU"/>',Kn,It,fr=`Using this principle, we can update a multi-layer perceptron of arbitrary depth, without the need for any synchronization
between GPUs until the very end, where we need to reconstruct the output vector from shards. The Megatron-LM paper authors
provide a helpful illustration for that:`,ea,J,ur='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_shard_processing.png" alt="Parallel shard processing"/>',ta,Jt,dr=`Parallelizing the multi-headed attention layers is even simpler, since they are already inherently parallel, due to having
multiple independent heads!`,la,k,cr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_self_attention.png" alt="Parallel self-attention"/>',ia,kt,vr=`Special considerations: TP requires very fast network, and therefore it’s not advisable to do TP across more than one node.
Practically, if a node has 4 GPUs, the highest TP degree is therefore 4. If you need a TP degree of 8, you need to use
nodes that have at least 8 GPUs.`,na,St,wr=`This section is based on the original much more <a href="https://github.com/huggingface/transformers/issues/10321#issuecomment-783543530" rel="nofollow">detailed TP overview</a>.
by <a href="https://github.com/anton-l" rel="nofollow">@anton-l</a>.`,aa,Et,yr="Alternative names:",sa,Vt,Pr='<li>DeepSpeed calls it <a href="https://www.deepspeed.ai/training/#model-parallelism" rel="nofollow">tensor slicing</a></li>',oa,At,Mr="Implementations:",ra,Rt,gr='<li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation, as it’s very model-specific</li> <li><a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> (only inference at the moment)</li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> has the tensor parallelism implementation based on the Transformers.</li>',pa,Nt,Tr="SageMaker combines TP with DP for a more efficient processing.",ha,zt,xr="🤗 Transformers status:",ma,Bt,br='<li>core: not yet implemented in the core</li> <li>but if you want inference <a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> provides this support for most of our models. So until this is implemented in the core you can use theirs. And hopefully training mode will be supported too.</li> <li>Deepspeed-Inference also supports our BERT, GPT-2, and GPT-Neo models in their super-fast CUDA-kernel-based inference mode, see more <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">here</a></li>',fa,Qt,Cr='🤗 Accelerate integrates with <a href="https://huggingface.co/docs/accelerate/v0.23.0/en/usage_guides/megatron_lm" rel="nofollow">TP from Megatron-LM</a>.',ua,Wt,da,Ft,Ur=`The following diagram from the DeepSpeed <a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">pipeline tutorial</a> demonstrates
how one can combine DP with PP.`,ca,S,Lr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero-dp-pp.png" alt="DP + PP-2d"/>',va,Zt,$r=`Here it’s important to see how DP rank 0 doesn’t see GPU2 and DP rank 1 doesn’t see GPU3. To DP there is just GPUs 0
and 1 where it feeds data as if there were just 2 GPUs. GPU0 “secretly” offloads some of its load to GPU2 using PP.
And GPU1 does the same by enlisting GPU3 to its aid.`,wa,Xt,_r="Since each dimension requires at least 2 GPUs, here you’d need at least 4 GPUs.",ya,Ot,Dr="Implementations:",Pa,Yt,Hr='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Ma,qt,Gr="🤗 Transformers status: not yet implemented",ga,Kt,Ta,el,jr="To get an even more efficient training a 3D parallelism is used where PP is combined with TP and DP. This can be seen in the following diagram.",xa,E,Ir='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-deepspeed-3d.png" alt="dp-pp-tp-3d"/>',ba,tl,Jr='This diagram is from a blog post <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-extreme-scale-model-training-for-everyone/" rel="nofollow">3D parallelism: Scaling to trillion-parameter models</a>, which is a good read as well.',Ca,ll,kr="Since each dimension requires at least 2 GPUs, here you’d need at least 8 GPUs.",Ua,il,Sr="Implementations:",La,nl,Er='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> - DeepSpeed also includes an even more efficient DP, which they call ZeRO-DP.</li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',$a,al,Vr="🤗 Transformers status: not yet implemented, since we have no PP and TP.",_a,sl,Da,ol,Ar=`One of the main features of DeepSpeed is ZeRO, which is a super-scalable extension of DP. It has already been
discussed in <a href="#zero-data-parallelism">ZeRO Data Parallelism</a>. Normally it’s a standalone feature that doesn’t require PP or TP.
But it can be combined with PP and TP.`,Ha,rl,Rr="When ZeRO-DP is combined with PP (and optionally TP) it typically enables only ZeRO stage 1 (optimizer sharding).",Ga,pl,Nr=`While it’s theoretically possible to use ZeRO stage 2 (gradient sharding) with Pipeline Parallelism, it will have negative
performance impacts. There would need to be an additional reduce-scatter collective for every micro-batch to aggregate
the gradients before sharding, which adds a potentially significant communication overhead. By nature of Pipeline Parallelism,
small micro-batches are used and instead the focus is on trying to balance arithmetic intensity (micro-batch size) with
minimizing the Pipeline bubble (number of micro-batches). Therefore those communication costs are going to impact the performance.`,ja,hl,zr=`In addition, there are already fewer layers than normal due to PP and so the memory savings won’t be huge. PP already
reduces gradient size by <code>1/PP</code>, and so gradient sharding savings on top of that are less significant than pure DP.`,Ia,ml,Br="ZeRO stage 3 is not a good choice either for the same reason - more inter-node communications required.",Ja,fl,Qr="And since we have ZeRO, the other benefit is ZeRO-Offload. Since this is stage 1 optimizer states can be offloaded to CPU.",ka,ul,Wr="Implementations:",Sa,dl,Fr='<li><a href="https://github.com/microsoft/Megatron-DeepSpeed" rel="nofollow">Megatron-DeepSpeed</a> and <a href="https://github.com/bigscience-workshop/Megatron-DeepSpeed" rel="nofollow">Megatron-Deepspeed from BigScience</a>, which is the fork of the former repo.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Ea,cl,Zr="Important papers:",Va,vl,Xr='<li><a href="https://arxiv.org/abs/2201.11990" rel="nofollow">Using DeepSpeed and Megatron to Train Megatron-Turing NLG 530B, A Large-Scale Generative Language Model</a></li>',Aa,wl,Or="🤗 Transformers status: not yet implemented, since we have no PP and TP.",Ra,yl,Na,Pl,Yr='<a href="https://github.com/flexflow/FlexFlow" rel="nofollow">FlexFlow</a> also solves the parallelization problem in a slightly different approach.',za,Ml,qr='Paper: <a href="https://arxiv.org/abs/1807.05358" rel="nofollow">“Beyond Data and Model Parallelism for Deep Neural Networks” by Zhihao Jia, Matei Zaharia, Alex Aiken</a>',Ba,gl,Kr="It performs a sort of 4D Parallelism over Sample-Operator-Attribute-Parameter.",Qa,Tl,ep="<li>Sample = Data Parallelism (sample-wise parallel)</li> <li>Operator = Parallelize a single operation into several sub-operations</li> <li>Attribute = Data Parallelism (length-wise parallel)</li> <li>Parameter = Model Parallelism (regardless of dimension - horizontal or vertical)</li>",Wa,xl,tp="Examples:",Fa,bl,lp="<li>Sample</li>",Za,Cl,ip="Let’s take 10 batches of sequence length 512. If we parallelize them by sample dimension into 2 devices, we get 10 x 512 which becomes be 5 x 2 x 512.",Xa,Ul,np="<li>Operator</li>",Oa,Ll,ap=`If we perform layer normalization, we compute std first and mean second, and then we can normalize data.
Operator parallelism allows computing std and mean in parallel. So if we parallelize them by operator dimension into 2
devices (cuda:0, cuda:1), first we copy input data into both devices, and cuda:0 computes std, cuda:1 computes mean at the same time.`,Ya,$l,sp="<li>Attribute</li>",qa,_l,op="We have 10 batches of 512 length. If we parallelize them by attribute dimension into 2 devices, 10 x 512 will be 10 x 2 x 256.",Ka,Dl,rp="<li>Parameter</li>",es,Hl,pp="It is similar with tensor model parallelism or naive layer-wise model parallelism.",ts,V,hp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-flexflow.jpeg" alt="flex-flow-soap"/>',ls,Gl,mp=`The significance of this framework is that it takes resources like (1) GPU/TPU/CPU vs. (2) RAM/DRAM vs. (3)
fast-intra-connect/slow-inter-connect and it automatically optimizes all these algorithmically deciding which
parallelisation to use where.`,is,jl,fp=`One very important aspect is that FlexFlow is designed for optimizing DNN parallelizations for models with static and
fixed workloads, since models with dynamic behavior may prefer different parallelization strategies across iterations.`,ns,Il,up=`So the promise is very attractive - it runs a 30min simulation on the cluster of choice and it comes up with the best
strategy to utilise this specific environment. If you add/remove/replace any parts it’ll run and re-optimize the plan
for that. And then you can train. A different setup will have its own custom optimization.`,as,Jl,dp=`🤗 Transformers status: Transformers models are FX-trace-able via <a href="https://github.com/huggingface/transformers/blob/master/src/transformers/utils/fx.py" rel="nofollow">transformers.utils.fx</a>,
which is a prerequisite for FlexFlow, however, changes are required on the FlexFlow side to make it work with Transformers models.`,ss,kl,os,Sl,cp='When training on multiple GPUs, you can specify the number of GPUs to use and in what order. This can be useful for instance when you have GPUs with different computing power and want to use the faster GPU first. The selection process works for both <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel</a> and <a href="https://pytorch.org/docs/stable/generated/torch.nn.DataParallel.html" rel="nofollow">DataParallel</a> to use only a subset of the available GPUs, and you don’t need Accelerate or the <a href="./main_classes/deepspeed">DeepSpeed integration</a>.',rs,El,ps,Vl,vp="For example, if you have 4 GPUs and you only want to use the first 2:",hs,A,ms,Al,fs,Rl,wp="Now, to select which GPUs to use and their order, you’ll use the <code>CUDA_VISIBLE_DEVICES</code> environment variable. It is easiest to set the environment variable in a <code>~/bashrc</code> or another startup config file. <code>CUDA_VISIBLE_DEVICES</code> is used to map which GPUs are used. For example, if you have 4 GPUs (0, 1, 2, 3) and you only want to run GPUs 0 and 2:",us,Nl,ds,zl,yp="Only the 2 physical GPUs (0 and 2) are “visible” to PyTorch and these are mapped to <code>cuda:0</code> and <code>cuda:1</code> respectively. You can also reverse the order of the GPUs to use 2 first. Now, the mapping is <code>cuda:1</code> for GPU 0 and <code>cuda:0</code> for GPU 2.",cs,Bl,vs,Ql,Pp="You can also set the <code>CUDA_VISIBLE_DEVICES</code> environment variable to an empty value to create an environment without GPUs.",ws,Wl,ys,R,Ps,Fl,Mp="<code>CUDA_DEVICE_ORDER</code> is an alternative environment variable you can use to control how the GPUs are ordered. You can either order them by:",Ms,Zl,gp='<li>PCIe bus ID’s that matches the order of <a href="https://developer.nvidia.com/nvidia-system-management-interface" rel="nofollow"><code>nvidia-smi</code></a> and <a href="https://rocm.docs.amd.com/projects/rocm_smi_lib/en/latest/.doxygen/docBin/html/index.html" rel="nofollow"><code>rocm-smi</code></a> for NVIDIA and AMD GPUs respectively</li>',gs,Xl,Ts,N,Tp="<li>GPU compute ability</li>",xs,Ol,bs,Yl,xp="The <code>CUDA_DEVICE_ORDER</code> is especially useful if your training setup consists of an older and newer GPU, where the older GPU appears first, but you cannot physically swap the cards to make the newer GPU appear first. In this case, set <code>CUDA_DEVICE_ORDER=FASTEST_FIRST</code> to always use the newer and faster GPU first (<code>nvidia-smi</code> or <code>rocm-smi</code> still reports the GPUs in their PCIe order). Or you could also set <code>export CUDA_VISIBLE_DEVICES=1,0</code>.",Cs,ei,Us;return M=new C({props:{title:"Efficient Training on Multiple GPUs",local:"efficient-training-on-multiple-gpus",headingTag:"h1"}}),$=new Ls({props:{$$slots:{default:[kp]},$$scope:{ctx:T}}}),W=new C({props:{title:"Scalability strategy",local:"scalability-strategy",headingTag:"h2"}}),pe=new C({props:{title:"Data Parallelism",local:"data-parallelism",headingTag:"h2"}}),me=new C({props:{title:"DataParallel vs DistributedDataParallel",local:"dataparallel-vs-distributeddataparallel",headingTag:"h3"}}),Ue=new b({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMCU1QyUwQXB5dGhvbiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRmxhbmd1YWdlLW1vZGVsaW5nJTJGcnVuX2NsbS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEEtLWRvX3RyYWluJTIwLS1vdXRwdXRfZGlyJTIwJTJGdG1wJTJGdGVzdC1jbG0lMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAtLW1heF9zdGVwcyUyMDIwMCUwQSUwQSU3Qid0cmFpbl9ydW50aW1lJyUzQSUyMDExMC41OTQ4JTJDJTIwJ3RyYWluX3NhbXBsZXNfcGVyX3NlY29uZCclM0ElMjAxLjgwOCUyQyUyMCdlcG9jaCclM0ElMjAwLjY5JTdE",highlighted:`<span class="hljs-built_in">rm</span> -r /tmp/test-clm; CUDA_VISIBLE_DEVICES=0,1 \\
python examples/pytorch/language-modeling/run_clm.py \\
--model_name_or_path openai-community/gpt2 --dataset_name wikitext --dataset_config_name wikitext-2-raw-v1 \\
--do_train --output_dir /tmp/test-clm --per_device_train_batch_size 4 --max_steps 200

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: 110.5948, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: 1.808, <span class="hljs-string">&#x27;epoch&#x27;</span>: 0.69}`,wrap:!1}}),$e=new b({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMCU1QyUwQXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUyMDIlMjBleGFtcGxlcyUyRnB5dG9yY2glMkZsYW5ndWFnZS1tb2RlbGluZyUyRnJ1bl9jbG0ucHklMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMG9wZW5haS1jb21tdW5pdHklMkZncHQyJTIwLS1kYXRhc2V0X25hbWUlMjB3aWtpdGV4dCUyMC0tZGF0YXNldF9jb25maWdfbmFtZSUyMHdpa2l0ZXh0LTItcmF3LXYxJTIwJTVDJTBBLS1kb190cmFpbiUyMC0tb3V0cHV0X2RpciUyMCUyRnRtcCUyRnRlc3QtY2xtJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjA0JTIwLS1tYXhfc3RlcHMlMjAyMDAlMEElMEElN0IndHJhaW5fcnVudGltZSclM0ElMjAxMDEuOTAwMyUyQyUyMCd0cmFpbl9zYW1wbGVzX3Blcl9zZWNvbmQnJTNBJTIwMS45NjMlMkMlMjAnZXBvY2gnJTNBJTIwMC42OSU3RA==",highlighted:`<span class="hljs-built_in">rm</span> -r /tmp/test-clm; CUDA_VISIBLE_DEVICES=0,1 \\
torchrun --nproc_per_node 2 examples/pytorch/language-modeling/run_clm.py \\
--model_name_or_path openai-community/gpt2 --dataset_name wikitext --dataset_config_name wikitext-2-raw-v1 \\
--do_train --output_dir /tmp/test-clm --per_device_train_batch_size 4 --max_steps 200

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: 101.9003, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: 1.963, <span class="hljs-string">&#x27;epoch&#x27;</span>: 0.69}`,wrap:!1}}),De=new b({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwTkNDTF9QMlBfRElTQUJMRSUzRDElMjBDVURBX1ZJU0lCTEVfREVWSUNFUyUzRDAlMkMxJTIwJTVDJTBBdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTIwMiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRmxhbmd1YWdlLW1vZGVsaW5nJTJGcnVuX2NsbS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEEtLWRvX3RyYWluJTIwLS1vdXRwdXRfZGlyJTIwJTJGdG1wJTJGdGVzdC1jbG0lMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAtLW1heF9zdGVwcyUyMDIwMCUwQSUwQSU3Qid0cmFpbl9ydW50aW1lJyUzQSUyMDEzMS40MzY3JTJDJTIwJ3RyYWluX3NhbXBsZXNfcGVyX3NlY29uZCclM0ElMjAxLjUyMiUyQyUyMCdlcG9jaCclM0ElMjAwLjY5JTdE",highlighted:`<span class="hljs-built_in">rm</span> -r /tmp/test-clm; NCCL_P2P_DISABLE=1 CUDA_VISIBLE_DEVICES=0,1 \\
torchrun --nproc_per_node 2 examples/pytorch/language-modeling/run_clm.py \\
--model_name_or_path openai-community/gpt2 --dataset_name wikitext --dataset_config_name wikitext-2-raw-v1 \\
--do_train --output_dir /tmp/test-clm --per_device_train_batch_size 4 --max_steps 200

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: 131.4367, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: 1.522, <span class="hljs-string">&#x27;epoch&#x27;</span>: 0.69}`,wrap:!1}}),Ie=new C({props:{title:"ZeRO Data Parallelism",local:"zero-data-parallelism",headingTag:"h2"}}),Ee=new b({props:{code:"TGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWEwJTIwJTdDJTIwYjAlMjAlN0MlMjBjMCUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQWEyJTIwJTdDJTIwYjIlMjAlN0MlMjBjMg==",highlighted:`La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),Ae=new b({props:{code:"R1BVMCUzQSUwQUxhJTIwJTdDJTIwTGIlMjAlN0MlMjBMYyUwQS0tLSU3Qy0tLS0lN0MtLS0lMEFhMCUyMCU3QyUyMGIwJTIwJTdDJTIwYzAlMEElMEFHUFUxJTNBJTBBTGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQSUwQUdQVTIlM0ElMEFMYSUyMCU3QyUyMExiJTIwJTdDJTIwTGMlMEEtLS0lN0MtLS0tJTdDLS0tJTBBYTIlMjAlN0MlMjBiMiUyMCU3QyUyMGMy",highlighted:`GPU0:
La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0

GPU1:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1

GPU2:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),ze=new b({props:{code:"eDAlMjAlM0QlM0UlMjBHUFUwJTBBeDElMjAlM0QlM0UlMjBHUFUxJTBBeDIlMjAlM0QlM0UlMjBHUFUy",highlighted:`<span class="hljs-attribute">x0</span> <span class="hljs-operator">=</span>&gt; GPU0
<span class="hljs-attribute">x1</span> <span class="hljs-operator">=</span>&gt; GPU1
<span class="hljs-attribute">x2</span> <span class="hljs-operator">=</span>&gt; GPU2`,wrap:!1}}),D=new Ls({props:{$$slots:{default:[Sp]},$$scope:{ctx:T}}}),Ke=new C({props:{title:"From Naive Model Parallelism to Pipeline Parallelism",local:"from-naive-model-parallelism-to-pipeline-parallelism",headingTag:"h2"}}),lt=new b({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTdDJTIwTGF5ZXIlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElN0MlMjAlMjAlMjAwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwJTIwMSUyMCUyMCUyMCU3QyUyMEdQVTAlMjAlN0MlMEElN0MlMjAlMjAlMjAyJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwJTIwMyUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQSU3QyUyMExheWVyJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwJTIwNCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSU3QyUyMCUyMCUyMDUlMjAlMjAlMjAlN0MlMjBHUFUxJTIwJTdDJTBBJTdDJTIwJTIwJTIwNiUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSU3QyUyMCUyMCUyMDclMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0Q=",highlighted:`================
|<span class="hljs-string"> Layer </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   0   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   1   </span>|<span class="hljs-string"> GPU0 </span>|
|<span class="hljs-string">   2   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   3   </span>|<span class="hljs-string">      </span>|
================
|<span class="hljs-string"> Layer </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   4   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   5   </span>|<span class="hljs-string"> GPU1 </span>|
|<span class="hljs-string">   6   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   7   </span>|<span class="hljs-string">      </span>|
================`,wrap:!1}}),_t=new C({props:{title:"Tensor Parallelism",local:"tensor-parallelism",headingTag:"h2"}}),Wt=new C({props:{title:"Data Parallelism + Pipeline Parallelism",local:"data-parallelism--pipeline-parallelism",headingTag:"h2"}}),Kt=new C({props:{title:"Data Parallelism + Pipeline Parallelism + Tensor Parallelism",local:"data-parallelism--pipeline-parallelism--tensor-parallelism",headingTag:"h2"}}),sl=new C({props:{title:"ZeRO Data Parallelism + Pipeline Parallelism + Tensor Parallelism",local:"zero-data-parallelism--pipeline-parallelism--tensor-parallelism",headingTag:"h2"}}),yl=new C({props:{title:"FlexFlow",local:"flexflow",headingTag:"h2"}}),kl=new C({props:{title:"GPU selection",local:"gpu-selection",headingTag:"h2"}}),El=new C({props:{title:"Number of GPUs",local:"number-of-gpus",headingTag:"h3"}}),A=new Jp({props:{id:"select-gpu",options:["torchrun","Accelerate","DeepSpeed"],$$slots:{default:[Rp]},$$scope:{ctx:T}}}),Al=new C({props:{title:"Order of GPUs",local:"order-of-gpus",headingTag:"h3"}}),Nl=new b({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMiUyMHRvcmNocnVuJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:"CUDA_VISIBLE_DEVICES=0,2 torchrun trainer-program.py ...",wrap:!1}}),Bl=new b({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QyJTJDMCUyMHRvcmNocnVuJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:"CUDA_VISIBLE_DEVICES=2,0 torchrun trainer-program.py ...",wrap:!1}}),Wl=new b({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QlMjBweXRob24lMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"CUDA_VISIBLE_DEVICES= python trainer-program.py ...",wrap:!1}}),R=new Ls({props:{warning:!0,$$slots:{default:[Np]},$$scope:{ctx:T}}}),Xl=new b({props:{code:"ZXhwb3J0JTIwQ1VEQV9ERVZJQ0VfT1JERVIlM0RQQ0lfQlVTX0lE",highlighted:'<span class="hljs-built_in">export</span> CUDA_DEVICE_ORDER=PCI_BUS_ID',wrap:!1}}),Ol=new b({props:{code:"ZXhwb3J0JTIwQ1VEQV9ERVZJQ0VfT1JERVIlM0RGQVNURVNUX0ZJUlNU",highlighted:'<span class="hljs-built_in">export</span> CUDA_DEVICE_ORDER=FASTEST_FIRST',wrap:!1}}),{c(){p=s("meta"),g=n(),f=s("p"),u=n(),d(M.$$.fragment),h=n(),m=s("p"),m.innerHTML=x,z=n(),L=s("p"),L.textContent=Kl,ti=n(),B=s("p"),B.innerHTML=_s,li=n(),d($.$$.fragment),ii=n(),Q=s("p"),Q.textContent=Ds,ni=n(),d(W.$$.fragment),ai=n(),F=s("p"),F.innerHTML=Hs,si=n(),Z=s("p"),Z.innerHTML=Gs,oi=n(),X=s("p"),X.textContent=js,ri=n(),O=s("p"),O.innerHTML=Is,pi=n(),Y=s("p"),Y.textContent=Js,hi=n(),q=s("ol"),q.innerHTML=ks,mi=n(),K=s("p"),K.innerHTML=Ss,fi=n(),ee=s("p"),ee.textContent=Es,ui=n(),te=s("ol"),te.innerHTML=Vs,di=n(),le=s("p"),le.textContent=As,ci=n(),ie=s("p"),ie.textContent=Rs,vi=n(),ne=s("p"),ne.innerHTML=Ns,wi=n(),ae=s("ol"),ae.innerHTML=zs,yi=n(),se=s("p"),se.innerHTML=Bs,Pi=n(),oe=s("ul"),oe.innerHTML=Qs,Mi=n(),re=s("p"),re.textContent=Ws,gi=n(),d(pe.$$.fragment),Ti=n(),he=s("p"),he.innerHTML=Fs,xi=n(),d(me.$$.fragment),bi=n(),fe=s("p"),fe.textContent=Zs,Ci=n(),ue=s("p"),ue.innerHTML=Xs,Ui=n(),de=s("ul"),de.innerHTML=Os,Li=n(),ce=s("p"),ce.innerHTML=Ys,$i=n(),ve=s("p"),ve.textContent=qs,_i=n(),we=s("ol"),we.innerHTML=Ks,Di=n(),ye=s("p"),ye.textContent=eo,Hi=n(),Pe=s("ol"),Pe.innerHTML=to,Gi=n(),Me=s("p"),Me.innerHTML=lo,ji=n(),ge=s("p"),ge.textContent=io,Ii=n(),Te=s("ul"),Te.innerHTML=no,Ji=n(),xe=s("p"),xe.innerHTML=ao,ki=n(),be=s("p"),be.textContent=so,Si=n(),Ce=s("p"),Ce.innerHTML=oo,Ei=n(),d(Ue.$$.fragment),Vi=n(),Le=s("p"),Le.innerHTML=ro,Ai=n(),d($e.$$.fragment),Ri=n(),_e=s("p"),_e.innerHTML=po,Ni=n(),d(De.$$.fragment),zi=n(),He=s("p"),He.textContent=ho,Bi=n(),Ge=s("table"),Ge.innerHTML=mo,Qi=n(),je=s("p"),je.textContent=fo,Wi=n(),d(Ie.$$.fragment),Fi=n(),Je=s("p"),Je.innerHTML=uo,Zi=n(),_=s("div"),_.innerHTML=co,Xi=n(),ke=s("p"),ke.innerHTML=vo,Oi=n(),Se=s("p"),Se.textContent=wo,Yi=n(),d(Ee.$$.fragment),qi=n(),Ve=s("p"),Ve.textContent=yo,Ki=n(),d(Ae.$$.fragment),en=n(),Re=s("p"),Re.textContent=Po,tn=n(),Ne=s("p"),Ne.textContent=Mo,ln=n(),d(ze.$$.fragment),nn=n(),Be=s("p"),Be.textContent=go,an=n(),Qe=s("p"),Qe.innerHTML=To,sn=n(),We=s("p"),We.textContent=xo,on=n(),Fe=s("p"),Fe.textContent=bo,rn=n(),Ze=s("p"),Ze.textContent=Co,pn=n(),Xe=s("p"),Xe.textContent=Uo,hn=n(),d(D.$$.fragment),mn=n(),Oe=s("p"),Oe.textContent=Lo,fn=n(),Ye=s("p"),Ye.textContent=$o,un=n(),qe=s("ul"),qe.innerHTML=_o,dn=n(),d(Ke.$$.fragment),cn=n(),et=s("p"),et.innerHTML=Do,vn=n(),tt=s("p"),tt.textContent=Ho,wn=n(),d(lt.$$.fragment),yn=n(),it=s("p"),it.textContent=Go,Pn=n(),nt=s("p"),nt.textContent=jo,Mn=n(),at=s("p"),at.textContent=Io,gn=n(),st=s("ul"),st.innerHTML=Jo,Tn=n(),ot=s("p"),ot.textContent=ko,xn=n(),rt=s("p"),rt.innerHTML=So,bn=n(),H=s("div"),H.innerHTML=Eo,Cn=n(),pt=s("p"),pt.textContent=Vo,Un=n(),ht=s("p"),ht.innerHTML=Ao,Ln=n(),mt=s("p"),mt.innerHTML=Ro,$n=n(),ft=s("p"),ft.innerHTML=No,_n=n(),ut=s("p"),ut.innerHTML=zo,Dn=n(),dt=s("p"),dt.textContent=Bo,Hn=n(),ct=s("ul"),ct.innerHTML=Qo,Gn=n(),vt=s("p"),vt.textContent=Wo,jn=n(),wt=s("ul"),wt.innerHTML=Fo,In=n(),yt=s("p"),yt.textContent=Zo,Jn=n(),Pt=s("ul"),Pt.innerHTML=Xo,kn=n(),Mt=s("p"),Mt.textContent=Oo,Sn=n(),gt=s("p"),gt.textContent=Yo,En=n(),Tt=s("ul"),Tt.innerHTML=qo,Vn=n(),xt=s("p"),xt.innerHTML=Ko,An=n(),bt=s("p"),bt.innerHTML=er,Rn=n(),Ct=s("p"),Ct.textContent=tr,Nn=n(),Ut=s("p"),Ut.innerHTML=lr,zn=n(),G=s("div"),G.innerHTML=ir,Bn=n(),Lt=s("p"),Lt.textContent=nr,Qn=n(),$t=s("p"),$t.innerHTML=ar,Wn=n(),d(_t.$$.fragment),Fn=n(),Dt=s("p"),Dt.innerHTML=sr,Zn=n(),Ht=s("p"),Ht.innerHTML=or,Xn=n(),Gt=s("p"),Gt.textContent=rr,On=n(),j=s("div"),j.innerHTML=pr,Yn=n(),jt=s("p"),jt.innerHTML=hr,qn=n(),I=s("div"),I.innerHTML=mr,Kn=n(),It=s("p"),It.textContent=fr,ea=n(),J=s("div"),J.innerHTML=ur,ta=n(),Jt=s("p"),Jt.textContent=dr,la=n(),k=s("div"),k.innerHTML=cr,ia=n(),kt=s("p"),kt.textContent=vr,na=n(),St=s("p"),St.innerHTML=wr,aa=n(),Et=s("p"),Et.textContent=yr,sa=n(),Vt=s("ul"),Vt.innerHTML=Pr,oa=n(),At=s("p"),At.textContent=Mr,ra=n(),Rt=s("ul"),Rt.innerHTML=gr,pa=n(),Nt=s("p"),Nt.textContent=Tr,ha=n(),zt=s("p"),zt.textContent=xr,ma=n(),Bt=s("ul"),Bt.innerHTML=br,fa=n(),Qt=s("p"),Qt.innerHTML=Cr,ua=n(),d(Wt.$$.fragment),da=n(),Ft=s("p"),Ft.innerHTML=Ur,ca=n(),S=s("div"),S.innerHTML=Lr,va=n(),Zt=s("p"),Zt.textContent=$r,wa=n(),Xt=s("p"),Xt.textContent=_r,ya=n(),Ot=s("p"),Ot.textContent=Dr,Pa=n(),Yt=s("ul"),Yt.innerHTML=Hr,Ma=n(),qt=s("p"),qt.textContent=Gr,ga=n(),d(Kt.$$.fragment),Ta=n(),el=s("p"),el.textContent=jr,xa=n(),E=s("div"),E.innerHTML=Ir,ba=n(),tl=s("p"),tl.innerHTML=Jr,Ca=n(),ll=s("p"),ll.textContent=kr,Ua=n(),il=s("p"),il.textContent=Sr,La=n(),nl=s("ul"),nl.innerHTML=Er,$a=n(),al=s("p"),al.textContent=Vr,_a=n(),d(sl.$$.fragment),Da=n(),ol=s("p"),ol.innerHTML=Ar,Ha=n(),rl=s("p"),rl.textContent=Rr,Ga=n(),pl=s("p"),pl.textContent=Nr,ja=n(),hl=s("p"),hl.innerHTML=zr,Ia=n(),ml=s("p"),ml.textContent=Br,Ja=n(),fl=s("p"),fl.textContent=Qr,ka=n(),ul=s("p"),ul.textContent=Wr,Sa=n(),dl=s("ul"),dl.innerHTML=Fr,Ea=n(),cl=s("p"),cl.textContent=Zr,Va=n(),vl=s("ul"),vl.innerHTML=Xr,Aa=n(),wl=s("p"),wl.textContent=Or,Ra=n(),d(yl.$$.fragment),Na=n(),Pl=s("p"),Pl.innerHTML=Yr,za=n(),Ml=s("p"),Ml.innerHTML=qr,Ba=n(),gl=s("p"),gl.textContent=Kr,Qa=n(),Tl=s("ol"),Tl.innerHTML=ep,Wa=n(),xl=s("p"),xl.textContent=tp,Fa=n(),bl=s("ul"),bl.innerHTML=lp,Za=n(),Cl=s("p"),Cl.textContent=ip,Xa=n(),Ul=s("ul"),Ul.innerHTML=np,Oa=n(),Ll=s("p"),Ll.textContent=ap,Ya=n(),$l=s("ul"),$l.innerHTML=sp,qa=n(),_l=s("p"),_l.textContent=op,Ka=n(),Dl=s("ul"),Dl.innerHTML=rp,es=n(),Hl=s("p"),Hl.textContent=pp,ts=n(),V=s("div"),V.innerHTML=hp,ls=n(),Gl=s("p"),Gl.textContent=mp,is=n(),jl=s("p"),jl.textContent=fp,ns=n(),Il=s("p"),Il.textContent=up,as=n(),Jl=s("p"),Jl.innerHTML=dp,ss=n(),d(kl.$$.fragment),os=n(),Sl=s("p"),Sl.innerHTML=cp,rs=n(),d(El.$$.fragment),ps=n(),Vl=s("p"),Vl.textContent=vp,hs=n(),d(A.$$.fragment),ms=n(),d(Al.$$.fragment),fs=n(),Rl=s("p"),Rl.innerHTML=wp,us=n(),d(Nl.$$.fragment),ds=n(),zl=s("p"),zl.innerHTML=yp,cs=n(),d(Bl.$$.fragment),vs=n(),Ql=s("p"),Ql.innerHTML=Pp,ws=n(),d(Wl.$$.fragment),ys=n(),d(R.$$.fragment),Ps=n(),Fl=s("p"),Fl.innerHTML=Mp,Ms=n(),Zl=s("ol"),Zl.innerHTML=gp,gs=n(),d(Xl.$$.fragment),Ts=n(),N=s("ol"),N.innerHTML=Tp,xs=n(),d(Ol.$$.fragment),bs=n(),Yl=s("p"),Yl.innerHTML=xp,Cs=n(),ei=s("p"),this.h()},l(e){const t=jp("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),g=a(e),f=o(e,"P",{}),$p(f).forEach(l),u=a(e),c(M.$$.fragment,e),h=a(e),m=o(e,"P",{"data-svelte-h":!0}),r(m)!=="svelte-pmpw5m"&&(m.innerHTML=x),z=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-6u57b2"&&(L.textContent=Kl),ti=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1fmi0j5"&&(B.innerHTML=_s),li=a(e),c($.$$.fragment,e),ii=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-k4erla"&&(Q.textContent=Ds),ni=a(e),c(W.$$.fragment,e),ai=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-vl1lph"&&(F.innerHTML=Hs),si=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-exgbxp"&&(Z.innerHTML=Gs),oi=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1ld98nk"&&(X.textContent=js),ri=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-owu077"&&(O.innerHTML=Is),pi=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-108eswe"&&(Y.textContent=Js),hi=a(e),q=o(e,"OL",{"data-svelte-h":!0}),r(q)!=="svelte-17djrzw"&&(q.innerHTML=ks),mi=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1pjlj4x"&&(K.innerHTML=Ss),fi=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1vvmjdr"&&(ee.textContent=Es),ui=a(e),te=o(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-1s0wp36"&&(te.innerHTML=Vs),di=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-g99shh"&&(le.textContent=As),ci=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-bg5rkn"&&(ie.textContent=Rs),vi=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1vlifqo"&&(ne.innerHTML=Ns),wi=a(e),ae=o(e,"OL",{"data-svelte-h":!0}),r(ae)!=="svelte-12kjlqq"&&(ae.innerHTML=zs),yi=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-ym8ubp"&&(se.innerHTML=Bs),Pi=a(e),oe=o(e,"UL",{"data-svelte-h":!0}),r(oe)!=="svelte-1dtz42n"&&(oe.innerHTML=Qs),Mi=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-4bia72"&&(re.textContent=Ws),gi=a(e),c(pe.$$.fragment,e),Ti=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1017dvy"&&(he.innerHTML=Fs),xi=a(e),c(me.$$.fragment,e),bi=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1j6eoys"&&(fe.textContent=Zs),Ci=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1v8b0bi"&&(ue.innerHTML=Xs),Ui=a(e),de=o(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-ibjm0a"&&(de.innerHTML=Os),Li=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-2za96j"&&(ce.innerHTML=Ys),$i=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1e3g0sm"&&(ve.textContent=qs),_i=a(e),we=o(e,"OL",{"data-svelte-h":!0}),r(we)!=="svelte-n1bojj"&&(we.innerHTML=Ks),Di=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1yk5hqh"&&(ye.textContent=eo),Hi=a(e),Pe=o(e,"OL",{"data-svelte-h":!0}),r(Pe)!=="svelte-1glndlp"&&(Pe.innerHTML=to),Gi=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-tn8imq"&&(Me.innerHTML=lo),ji=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-196u8fm"&&(ge.textContent=io),Ii=a(e),Te=o(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-1p9lena"&&(Te.innerHTML=no),Ji=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-lyxecx"&&(xe.innerHTML=ao),ki=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1ccu14e"&&(be.textContent=so),Si=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1cuy4x"&&(Ce.innerHTML=oo),Ei=a(e),c(Ue.$$.fragment,e),Vi=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-ady25n"&&(Le.innerHTML=ro),Ai=a(e),c($e.$$.fragment,e),Ri=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1bcmt3e"&&(_e.innerHTML=po),Ni=a(e),c(De.$$.fragment,e),zi=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-ammqnu"&&(He.textContent=ho),Bi=a(e),Ge=o(e,"TABLE",{"data-svelte-h":!0}),r(Ge)!=="svelte-1glyygb"&&(Ge.innerHTML=mo),Qi=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-3h79hx"&&(je.textContent=fo),Wi=a(e),c(Ie.$$.fragment,e),Fi=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-rus1tj"&&(Je.innerHTML=uo),Zi=a(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-l6ikqh"&&(_.innerHTML=co),Xi=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1n0hd1i"&&(ke.innerHTML=vo),Oi=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-yml45c"&&(Se.textContent=wo),Yi=a(e),c(Ee.$$.fragment,e),qi=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-ycp41i"&&(Ve.textContent=yo),Ki=a(e),c(Ae.$$.fragment,e),en=a(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-vhaef9"&&(Re.textContent=Po),tn=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-v79p4j"&&(Ne.textContent=Mo),ln=a(e),c(ze.$$.fragment,e),nn=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1x8bz4m"&&(Be.textContent=go),an=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-9s70m2"&&(Qe.innerHTML=To),sn=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-18avb09"&&(We.textContent=xo),on=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-ptnnl0"&&(Fe.textContent=bo),rn=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1e42x7e"&&(Ze.textContent=Co),pn=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1qw37a5"&&(Xe.textContent=Uo),hn=a(e),c(D.$$.fragment,e),mn=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-3x8lv3"&&(Oe.textContent=Lo),fn=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1b2mzqh"&&(Ye.textContent=$o),un=a(e),qe=o(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-a0zshu"&&(qe.innerHTML=_o),dn=a(e),c(Ke.$$.fragment,e),cn=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-byke96"&&(et.innerHTML=Do),vn=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-kfubqe"&&(tt.textContent=Ho),wn=a(e),c(lt.$$.fragment,e),yn=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-vd21sy"&&(it.textContent=Go),Pn=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-vjztmh"&&(nt.textContent=jo),Mn=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1l6dgyv"&&(at.textContent=Io),gn=a(e),st=o(e,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-19omdeq"&&(st.innerHTML=Jo),Tn=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1yzyde0"&&(ot.textContent=ko),xn=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1lu2bt6"&&(rt.innerHTML=So),bn=a(e),H=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(H)!=="svelte-1zwet4"&&(H.innerHTML=Eo),Cn=a(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-10mywh3"&&(pt.textContent=Vo),Un=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-qcenct"&&(ht.innerHTML=Ao),Ln=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-q4rot4"&&(mt.innerHTML=Ro),$n=a(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1qpt7zo"&&(ft.innerHTML=No),_n=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1g0sf3v"&&(ut.innerHTML=zo),Dn=a(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-18mmroz"&&(dt.textContent=Bo),Hn=a(e),ct=o(e,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-1m54oo0"&&(ct.innerHTML=Qo),Gn=a(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-3pifdn"&&(vt.textContent=Wo),jn=a(e),wt=o(e,"UL",{"data-svelte-h":!0}),r(wt)!=="svelte-p13wwf"&&(wt.innerHTML=Fo),In=a(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-5h607a"&&(yt.textContent=Zo),Jn=a(e),Pt=o(e,"UL",{"data-svelte-h":!0}),r(Pt)!=="svelte-n2xihd"&&(Pt.innerHTML=Xo),kn=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1xvp26s"&&(Mt.textContent=Oo),Sn=a(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1b2mzqh"&&(gt.textContent=Yo),En=a(e),Tt=o(e,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-1kewxhh"&&(Tt.innerHTML=qo),Vn=a(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-zuoye1"&&(xt.innerHTML=Ko),An=a(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1nopw2u"&&(bt.innerHTML=er),Rn=a(e),Ct=o(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1djad0c"&&(Ct.textContent=tr),Nn=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-vnarcr"&&(Ut.innerHTML=lr),zn=a(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-xyuwxq"&&(G.innerHTML=ir),Bn=a(e),Lt=o(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-19x9s0e"&&(Lt.textContent=nr),Qn=a(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1q9n35q"&&($t.innerHTML=ar),Wn=a(e),c(_t.$$.fragment,e),Fn=a(e),Dt=o(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1fj06i7"&&(Dt.innerHTML=sr),Zn=a(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-1ktbklq"&&(Ht.innerHTML=or),Xn=a(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-250ai3"&&(Gt.textContent=rr),On=a(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1ugxk60"&&(j.innerHTML=pr),Yn=a(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-s73n1q"&&(jt.innerHTML=hr),qn=a(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(I)!=="svelte-gpv8h8"&&(I.innerHTML=mr),Kn=a(e),It=o(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1lnmjiw"&&(It.textContent=fr),ea=a(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-yslb0f"&&(J.innerHTML=ur),ta=a(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-8jgntx"&&(Jt.textContent=dr),la=a(e),k=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(k)!=="svelte-b5xtwy"&&(k.innerHTML=cr),ia=a(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-kplhah"&&(kt.textContent=vr),na=a(e),St=o(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-hmoxa9"&&(St.innerHTML=wr),aa=a(e),Et=o(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1ma7lah"&&(Et.textContent=yr),sa=a(e),Vt=o(e,"UL",{"data-svelte-h":!0}),r(Vt)!=="svelte-p60tn3"&&(Vt.innerHTML=Pr),oa=a(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1b2mzqh"&&(At.textContent=Mr),ra=a(e),Rt=o(e,"UL",{"data-svelte-h":!0}),r(Rt)!=="svelte-sudg8s"&&(Rt.innerHTML=gr),pa=a(e),Nt=o(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-xqarbt"&&(Nt.textContent=Tr),ha=a(e),zt=o(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-1g6ovc1"&&(zt.textContent=xr),ma=a(e),Bt=o(e,"UL",{"data-svelte-h":!0}),r(Bt)!=="svelte-13k8bts"&&(Bt.innerHTML=br),fa=a(e),Qt=o(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-f1rs41"&&(Qt.innerHTML=Cr),ua=a(e),c(Wt.$$.fragment,e),da=a(e),Ft=o(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-1oq9xy9"&&(Ft.innerHTML=Ur),ca=a(e),S=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(S)!=="svelte-jbayi"&&(S.innerHTML=Lr),va=a(e),Zt=o(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1xg3nfy"&&(Zt.textContent=$r),wa=a(e),Xt=o(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-4rkar7"&&(Xt.textContent=_r),ya=a(e),Ot=o(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1b2mzqh"&&(Ot.textContent=Dr),Pa=a(e),Yt=o(e,"UL",{"data-svelte-h":!0}),r(Yt)!=="svelte-1ry6c7"&&(Yt.innerHTML=Hr),Ma=a(e),qt=o(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-9dc2gy"&&(qt.textContent=Gr),ga=a(e),c(Kt.$$.fragment,e),Ta=a(e),el=o(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-fz9fyw"&&(el.textContent=jr),xa=a(e),E=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(E)!=="svelte-4i6t8z"&&(E.innerHTML=Ir),ba=a(e),tl=o(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-18bvwlv"&&(tl.innerHTML=Jr),Ca=a(e),ll=o(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1hp29wn"&&(ll.textContent=kr),Ua=a(e),il=o(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-1b2mzqh"&&(il.textContent=Sr),La=a(e),nl=o(e,"UL",{"data-svelte-h":!0}),r(nl)!=="svelte-3ic0jq"&&(nl.innerHTML=Er),$a=a(e),al=o(e,"P",{"data-svelte-h":!0}),r(al)!=="svelte-r6xwz8"&&(al.textContent=Vr),_a=a(e),c(sl.$$.fragment,e),Da=a(e),ol=o(e,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-7uwyc9"&&(ol.innerHTML=Ar),Ha=a(e),rl=o(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-172u2n6"&&(rl.textContent=Rr),Ga=a(e),pl=o(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-mgnvai"&&(pl.textContent=Nr),ja=a(e),hl=o(e,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-bdt2fr"&&(hl.innerHTML=zr),Ia=a(e),ml=o(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-q3kikv"&&(ml.textContent=Br),Ja=a(e),fl=o(e,"P",{"data-svelte-h":!0}),r(fl)!=="svelte-s2rtor"&&(fl.textContent=Qr),ka=a(e),ul=o(e,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-1b2mzqh"&&(ul.textContent=Wr),Sa=a(e),dl=o(e,"UL",{"data-svelte-h":!0}),r(dl)!=="svelte-o5zp0z"&&(dl.innerHTML=Fr),Ea=a(e),cl=o(e,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-1grbiex"&&(cl.textContent=Zr),Va=a(e),vl=o(e,"UL",{"data-svelte-h":!0}),r(vl)!=="svelte-1oyel1u"&&(vl.innerHTML=Xr),Aa=a(e),wl=o(e,"P",{"data-svelte-h":!0}),r(wl)!=="svelte-r6xwz8"&&(wl.textContent=Or),Ra=a(e),c(yl.$$.fragment,e),Na=a(e),Pl=o(e,"P",{"data-svelte-h":!0}),r(Pl)!=="svelte-121cfuq"&&(Pl.innerHTML=Yr),za=a(e),Ml=o(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-dou7hg"&&(Ml.innerHTML=qr),Ba=a(e),gl=o(e,"P",{"data-svelte-h":!0}),r(gl)!=="svelte-oa098n"&&(gl.textContent=Kr),Qa=a(e),Tl=o(e,"OL",{"data-svelte-h":!0}),r(Tl)!=="svelte-6cxs64"&&(Tl.innerHTML=ep),Wa=a(e),xl=o(e,"P",{"data-svelte-h":!0}),r(xl)!=="svelte-kvfsh7"&&(xl.textContent=tp),Fa=a(e),bl=o(e,"UL",{"data-svelte-h":!0}),r(bl)!=="svelte-1734ihx"&&(bl.innerHTML=lp),Za=a(e),Cl=o(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-jsce61"&&(Cl.textContent=ip),Xa=a(e),Ul=o(e,"UL",{"data-svelte-h":!0}),r(Ul)!=="svelte-ilmkvr"&&(Ul.innerHTML=np),Oa=a(e),Ll=o(e,"P",{"data-svelte-h":!0}),r(Ll)!=="svelte-w2gbdo"&&(Ll.textContent=ap),Ya=a(e),$l=o(e,"UL",{"data-svelte-h":!0}),r($l)!=="svelte-dyjda9"&&($l.innerHTML=sp),qa=a(e),_l=o(e,"P",{"data-svelte-h":!0}),r(_l)!=="svelte-1qwl5bi"&&(_l.textContent=op),Ka=a(e),Dl=o(e,"UL",{"data-svelte-h":!0}),r(Dl)!=="svelte-bzftse"&&(Dl.innerHTML=rp),es=a(e),Hl=o(e,"P",{"data-svelte-h":!0}),r(Hl)!=="svelte-pn1yl1"&&(Hl.textContent=pp),ts=a(e),V=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(V)!=="svelte-1jywqo8"&&(V.innerHTML=hp),ls=a(e),Gl=o(e,"P",{"data-svelte-h":!0}),r(Gl)!=="svelte-11n85y7"&&(Gl.textContent=mp),is=a(e),jl=o(e,"P",{"data-svelte-h":!0}),r(jl)!=="svelte-13bz10s"&&(jl.textContent=fp),ns=a(e),Il=o(e,"P",{"data-svelte-h":!0}),r(Il)!=="svelte-iohzxv"&&(Il.textContent=up),as=a(e),Jl=o(e,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-so3ryv"&&(Jl.innerHTML=dp),ss=a(e),c(kl.$$.fragment,e),os=a(e),Sl=o(e,"P",{"data-svelte-h":!0}),r(Sl)!=="svelte-18jn5v3"&&(Sl.innerHTML=cp),rs=a(e),c(El.$$.fragment,e),ps=a(e),Vl=o(e,"P",{"data-svelte-h":!0}),r(Vl)!=="svelte-1tfztmr"&&(Vl.textContent=vp),hs=a(e),c(A.$$.fragment,e),ms=a(e),c(Al.$$.fragment,e),fs=a(e),Rl=o(e,"P",{"data-svelte-h":!0}),r(Rl)!=="svelte-1gq2rbv"&&(Rl.innerHTML=wp),us=a(e),c(Nl.$$.fragment,e),ds=a(e),zl=o(e,"P",{"data-svelte-h":!0}),r(zl)!=="svelte-1jed3my"&&(zl.innerHTML=yp),cs=a(e),c(Bl.$$.fragment,e),vs=a(e),Ql=o(e,"P",{"data-svelte-h":!0}),r(Ql)!=="svelte-waga1j"&&(Ql.innerHTML=Pp),ws=a(e),c(Wl.$$.fragment,e),ys=a(e),c(R.$$.fragment,e),Ps=a(e),Fl=o(e,"P",{"data-svelte-h":!0}),r(Fl)!=="svelte-qvyxrz"&&(Fl.innerHTML=Mp),Ms=a(e),Zl=o(e,"OL",{"data-svelte-h":!0}),r(Zl)!=="svelte-dqc5mg"&&(Zl.innerHTML=gp),gs=a(e),c(Xl.$$.fragment,e),Ts=a(e),N=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(N)!=="svelte-7l4syx"&&(N.innerHTML=Tp),xs=a(e),c(Ol.$$.fragment,e),bs=a(e),Yl=o(e,"P",{"data-svelte-h":!0}),r(Yl)!=="svelte-xdw23d"&&(Yl.innerHTML=xp),Cs=a(e),ei=o(e,"P",{}),$p(ei).forEach(l),this.h()},h(){U(p,"name","hf:doc:metadata"),U(p,"content",Bp),U(_,"class","flex justify-center"),U(H,"class","flex justify-center"),U(G,"class","flex justify-center"),U(j,"class","flex justify-center"),U(I,"class","flex justify-center"),U(J,"class","flex justify-center"),U(k,"class","flex justify-center"),U(S,"class","flex justify-center"),U(E,"class","flex justify-center"),U(V,"class","flex justify-center"),U(N,"start","2")},m(e,t){Ip(document.head,p),i(e,g,t),i(e,f,t),i(e,u,t),v(M,e,t),i(e,h,t),i(e,m,t),i(e,z,t),i(e,L,t),i(e,ti,t),i(e,B,t),i(e,li,t),v($,e,t),i(e,ii,t),i(e,Q,t),i(e,ni,t),v(W,e,t),i(e,ai,t),i(e,F,t),i(e,si,t),i(e,Z,t),i(e,oi,t),i(e,X,t),i(e,ri,t),i(e,O,t),i(e,pi,t),i(e,Y,t),i(e,hi,t),i(e,q,t),i(e,mi,t),i(e,K,t),i(e,fi,t),i(e,ee,t),i(e,ui,t),i(e,te,t),i(e,di,t),i(e,le,t),i(e,ci,t),i(e,ie,t),i(e,vi,t),i(e,ne,t),i(e,wi,t),i(e,ae,t),i(e,yi,t),i(e,se,t),i(e,Pi,t),i(e,oe,t),i(e,Mi,t),i(e,re,t),i(e,gi,t),v(pe,e,t),i(e,Ti,t),i(e,he,t),i(e,xi,t),v(me,e,t),i(e,bi,t),i(e,fe,t),i(e,Ci,t),i(e,ue,t),i(e,Ui,t),i(e,de,t),i(e,Li,t),i(e,ce,t),i(e,$i,t),i(e,ve,t),i(e,_i,t),i(e,we,t),i(e,Di,t),i(e,ye,t),i(e,Hi,t),i(e,Pe,t),i(e,Gi,t),i(e,Me,t),i(e,ji,t),i(e,ge,t),i(e,Ii,t),i(e,Te,t),i(e,Ji,t),i(e,xe,t),i(e,ki,t),i(e,be,t),i(e,Si,t),i(e,Ce,t),i(e,Ei,t),v(Ue,e,t),i(e,Vi,t),i(e,Le,t),i(e,Ai,t),v($e,e,t),i(e,Ri,t),i(e,_e,t),i(e,Ni,t),v(De,e,t),i(e,zi,t),i(e,He,t),i(e,Bi,t),i(e,Ge,t),i(e,Qi,t),i(e,je,t),i(e,Wi,t),v(Ie,e,t),i(e,Fi,t),i(e,Je,t),i(e,Zi,t),i(e,_,t),i(e,Xi,t),i(e,ke,t),i(e,Oi,t),i(e,Se,t),i(e,Yi,t),v(Ee,e,t),i(e,qi,t),i(e,Ve,t),i(e,Ki,t),v(Ae,e,t),i(e,en,t),i(e,Re,t),i(e,tn,t),i(e,Ne,t),i(e,ln,t),v(ze,e,t),i(e,nn,t),i(e,Be,t),i(e,an,t),i(e,Qe,t),i(e,sn,t),i(e,We,t),i(e,on,t),i(e,Fe,t),i(e,rn,t),i(e,Ze,t),i(e,pn,t),i(e,Xe,t),i(e,hn,t),v(D,e,t),i(e,mn,t),i(e,Oe,t),i(e,fn,t),i(e,Ye,t),i(e,un,t),i(e,qe,t),i(e,dn,t),v(Ke,e,t),i(e,cn,t),i(e,et,t),i(e,vn,t),i(e,tt,t),i(e,wn,t),v(lt,e,t),i(e,yn,t),i(e,it,t),i(e,Pn,t),i(e,nt,t),i(e,Mn,t),i(e,at,t),i(e,gn,t),i(e,st,t),i(e,Tn,t),i(e,ot,t),i(e,xn,t),i(e,rt,t),i(e,bn,t),i(e,H,t),i(e,Cn,t),i(e,pt,t),i(e,Un,t),i(e,ht,t),i(e,Ln,t),i(e,mt,t),i(e,$n,t),i(e,ft,t),i(e,_n,t),i(e,ut,t),i(e,Dn,t),i(e,dt,t),i(e,Hn,t),i(e,ct,t),i(e,Gn,t),i(e,vt,t),i(e,jn,t),i(e,wt,t),i(e,In,t),i(e,yt,t),i(e,Jn,t),i(e,Pt,t),i(e,kn,t),i(e,Mt,t),i(e,Sn,t),i(e,gt,t),i(e,En,t),i(e,Tt,t),i(e,Vn,t),i(e,xt,t),i(e,An,t),i(e,bt,t),i(e,Rn,t),i(e,Ct,t),i(e,Nn,t),i(e,Ut,t),i(e,zn,t),i(e,G,t),i(e,Bn,t),i(e,Lt,t),i(e,Qn,t),i(e,$t,t),i(e,Wn,t),v(_t,e,t),i(e,Fn,t),i(e,Dt,t),i(e,Zn,t),i(e,Ht,t),i(e,Xn,t),i(e,Gt,t),i(e,On,t),i(e,j,t),i(e,Yn,t),i(e,jt,t),i(e,qn,t),i(e,I,t),i(e,Kn,t),i(e,It,t),i(e,ea,t),i(e,J,t),i(e,ta,t),i(e,Jt,t),i(e,la,t),i(e,k,t),i(e,ia,t),i(e,kt,t),i(e,na,t),i(e,St,t),i(e,aa,t),i(e,Et,t),i(e,sa,t),i(e,Vt,t),i(e,oa,t),i(e,At,t),i(e,ra,t),i(e,Rt,t),i(e,pa,t),i(e,Nt,t),i(e,ha,t),i(e,zt,t),i(e,ma,t),i(e,Bt,t),i(e,fa,t),i(e,Qt,t),i(e,ua,t),v(Wt,e,t),i(e,da,t),i(e,Ft,t),i(e,ca,t),i(e,S,t),i(e,va,t),i(e,Zt,t),i(e,wa,t),i(e,Xt,t),i(e,ya,t),i(e,Ot,t),i(e,Pa,t),i(e,Yt,t),i(e,Ma,t),i(e,qt,t),i(e,ga,t),v(Kt,e,t),i(e,Ta,t),i(e,el,t),i(e,xa,t),i(e,E,t),i(e,ba,t),i(e,tl,t),i(e,Ca,t),i(e,ll,t),i(e,Ua,t),i(e,il,t),i(e,La,t),i(e,nl,t),i(e,$a,t),i(e,al,t),i(e,_a,t),v(sl,e,t),i(e,Da,t),i(e,ol,t),i(e,Ha,t),i(e,rl,t),i(e,Ga,t),i(e,pl,t),i(e,ja,t),i(e,hl,t),i(e,Ia,t),i(e,ml,t),i(e,Ja,t),i(e,fl,t),i(e,ka,t),i(e,ul,t),i(e,Sa,t),i(e,dl,t),i(e,Ea,t),i(e,cl,t),i(e,Va,t),i(e,vl,t),i(e,Aa,t),i(e,wl,t),i(e,Ra,t),v(yl,e,t),i(e,Na,t),i(e,Pl,t),i(e,za,t),i(e,Ml,t),i(e,Ba,t),i(e,gl,t),i(e,Qa,t),i(e,Tl,t),i(e,Wa,t),i(e,xl,t),i(e,Fa,t),i(e,bl,t),i(e,Za,t),i(e,Cl,t),i(e,Xa,t),i(e,Ul,t),i(e,Oa,t),i(e,Ll,t),i(e,Ya,t),i(e,$l,t),i(e,qa,t),i(e,_l,t),i(e,Ka,t),i(e,Dl,t),i(e,es,t),i(e,Hl,t),i(e,ts,t),i(e,V,t),i(e,ls,t),i(e,Gl,t),i(e,is,t),i(e,jl,t),i(e,ns,t),i(e,Il,t),i(e,as,t),i(e,Jl,t),i(e,ss,t),v(kl,e,t),i(e,os,t),i(e,Sl,t),i(e,rs,t),v(El,e,t),i(e,ps,t),i(e,Vl,t),i(e,hs,t),v(A,e,t),i(e,ms,t),v(Al,e,t),i(e,fs,t),i(e,Rl,t),i(e,us,t),v(Nl,e,t),i(e,ds,t),i(e,zl,t),i(e,cs,t),v(Bl,e,t),i(e,vs,t),i(e,Ql,t),i(e,ws,t),v(Wl,e,t),i(e,ys,t),v(R,e,t),i(e,Ps,t),i(e,Fl,t),i(e,Ms,t),i(e,Zl,t),i(e,gs,t),v(Xl,e,t),i(e,Ts,t),i(e,N,t),i(e,xs,t),v(Ol,e,t),i(e,bs,t),i(e,Yl,t),i(e,Cs,t),i(e,ei,t),Us=!0},p(e,[t]){const bp={};t&2&&(bp.$$scope={dirty:t,ctx:e}),$.$set(bp);const Cp={};t&2&&(Cp.$$scope={dirty:t,ctx:e}),D.$set(Cp);const Up={};t&2&&(Up.$$scope={dirty:t,ctx:e}),A.$set(Up);const Lp={};t&2&&(Lp.$$scope={dirty:t,ctx:e}),R.$set(Lp)},i(e){Us||(w(M.$$.fragment,e),w($.$$.fragment,e),w(W.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(Ue.$$.fragment,e),w($e.$$.fragment,e),w(De.$$.fragment,e),w(Ie.$$.fragment,e),w(Ee.$$.fragment,e),w(Ae.$$.fragment,e),w(ze.$$.fragment,e),w(D.$$.fragment,e),w(Ke.$$.fragment,e),w(lt.$$.fragment,e),w(_t.$$.fragment,e),w(Wt.$$.fragment,e),w(Kt.$$.fragment,e),w(sl.$$.fragment,e),w(yl.$$.fragment,e),w(kl.$$.fragment,e),w(El.$$.fragment,e),w(A.$$.fragment,e),w(Al.$$.fragment,e),w(Nl.$$.fragment,e),w(Bl.$$.fragment,e),w(Wl.$$.fragment,e),w(R.$$.fragment,e),w(Xl.$$.fragment,e),w(Ol.$$.fragment,e),Us=!0)},o(e){y(M.$$.fragment,e),y($.$$.fragment,e),y(W.$$.fragment,e),y(pe.$$.fragment,e),y(me.$$.fragment,e),y(Ue.$$.fragment,e),y($e.$$.fragment,e),y(De.$$.fragment,e),y(Ie.$$.fragment,e),y(Ee.$$.fragment,e),y(Ae.$$.fragment,e),y(ze.$$.fragment,e),y(D.$$.fragment,e),y(Ke.$$.fragment,e),y(lt.$$.fragment,e),y(_t.$$.fragment,e),y(Wt.$$.fragment,e),y(Kt.$$.fragment,e),y(sl.$$.fragment,e),y(yl.$$.fragment,e),y(kl.$$.fragment,e),y(El.$$.fragment,e),y(A.$$.fragment,e),y(Al.$$.fragment,e),y(Nl.$$.fragment,e),y(Bl.$$.fragment,e),y(Wl.$$.fragment,e),y(R.$$.fragment,e),y(Xl.$$.fragment,e),y(Ol.$$.fragment,e),Us=!1},d(e){e&&(l(g),l(f),l(u),l(h),l(m),l(z),l(L),l(ti),l(B),l(li),l(ii),l(Q),l(ni),l(ai),l(F),l(si),l(Z),l(oi),l(X),l(ri),l(O),l(pi),l(Y),l(hi),l(q),l(mi),l(K),l(fi),l(ee),l(ui),l(te),l(di),l(le),l(ci),l(ie),l(vi),l(ne),l(wi),l(ae),l(yi),l(se),l(Pi),l(oe),l(Mi),l(re),l(gi),l(Ti),l(he),l(xi),l(bi),l(fe),l(Ci),l(ue),l(Ui),l(de),l(Li),l(ce),l($i),l(ve),l(_i),l(we),l(Di),l(ye),l(Hi),l(Pe),l(Gi),l(Me),l(ji),l(ge),l(Ii),l(Te),l(Ji),l(xe),l(ki),l(be),l(Si),l(Ce),l(Ei),l(Vi),l(Le),l(Ai),l(Ri),l(_e),l(Ni),l(zi),l(He),l(Bi),l(Ge),l(Qi),l(je),l(Wi),l(Fi),l(Je),l(Zi),l(_),l(Xi),l(ke),l(Oi),l(Se),l(Yi),l(qi),l(Ve),l(Ki),l(en),l(Re),l(tn),l(Ne),l(ln),l(nn),l(Be),l(an),l(Qe),l(sn),l(We),l(on),l(Fe),l(rn),l(Ze),l(pn),l(Xe),l(hn),l(mn),l(Oe),l(fn),l(Ye),l(un),l(qe),l(dn),l(cn),l(et),l(vn),l(tt),l(wn),l(yn),l(it),l(Pn),l(nt),l(Mn),l(at),l(gn),l(st),l(Tn),l(ot),l(xn),l(rt),l(bn),l(H),l(Cn),l(pt),l(Un),l(ht),l(Ln),l(mt),l($n),l(ft),l(_n),l(ut),l(Dn),l(dt),l(Hn),l(ct),l(Gn),l(vt),l(jn),l(wt),l(In),l(yt),l(Jn),l(Pt),l(kn),l(Mt),l(Sn),l(gt),l(En),l(Tt),l(Vn),l(xt),l(An),l(bt),l(Rn),l(Ct),l(Nn),l(Ut),l(zn),l(G),l(Bn),l(Lt),l(Qn),l($t),l(Wn),l(Fn),l(Dt),l(Zn),l(Ht),l(Xn),l(Gt),l(On),l(j),l(Yn),l(jt),l(qn),l(I),l(Kn),l(It),l(ea),l(J),l(ta),l(Jt),l(la),l(k),l(ia),l(kt),l(na),l(St),l(aa),l(Et),l(sa),l(Vt),l(oa),l(At),l(ra),l(Rt),l(pa),l(Nt),l(ha),l(zt),l(ma),l(Bt),l(fa),l(Qt),l(ua),l(da),l(Ft),l(ca),l(S),l(va),l(Zt),l(wa),l(Xt),l(ya),l(Ot),l(Pa),l(Yt),l(Ma),l(qt),l(ga),l(Ta),l(el),l(xa),l(E),l(ba),l(tl),l(Ca),l(ll),l(Ua),l(il),l(La),l(nl),l($a),l(al),l(_a),l(Da),l(ol),l(Ha),l(rl),l(Ga),l(pl),l(ja),l(hl),l(Ia),l(ml),l(Ja),l(fl),l(ka),l(ul),l(Sa),l(dl),l(Ea),l(cl),l(Va),l(vl),l(Aa),l(wl),l(Ra),l(Na),l(Pl),l(za),l(Ml),l(Ba),l(gl),l(Qa),l(Tl),l(Wa),l(xl),l(Fa),l(bl),l(Za),l(Cl),l(Xa),l(Ul),l(Oa),l(Ll),l(Ya),l($l),l(qa),l(_l),l(Ka),l(Dl),l(es),l(Hl),l(ts),l(V),l(ls),l(Gl),l(is),l(jl),l(ns),l(Il),l(as),l(Jl),l(ss),l(os),l(Sl),l(rs),l(ps),l(Vl),l(hs),l(ms),l(fs),l(Rl),l(us),l(ds),l(zl),l(cs),l(vs),l(Ql),l(ws),l(ys),l(Ps),l(Fl),l(Ms),l(Zl),l(gs),l(Ts),l(N),l(xs),l(bs),l(Yl),l(Cs),l(ei)),l(p),P(M,e),P($,e),P(W,e),P(pe,e),P(me,e),P(Ue,e),P($e,e),P(De,e),P(Ie,e),P(Ee,e),P(Ae,e),P(ze,e),P(D,e),P(Ke,e),P(lt,e),P(_t,e),P(Wt,e),P(Kt,e),P(sl,e),P(yl,e),P(kl,e),P(El,e),P(A,e),P(Al,e),P(Nl,e),P(Bl,e),P(Wl,e),P(R,e),P(Xl,e),P(Ol,e)}}}const Bp='{"title":"Efficient Training on Multiple GPUs","local":"efficient-training-on-multiple-gpus","sections":[{"title":"Scalability strategy","local":"scalability-strategy","sections":[],"depth":2},{"title":"Data Parallelism","local":"data-parallelism","sections":[{"title":"DataParallel vs DistributedDataParallel","local":"dataparallel-vs-distributeddataparallel","sections":[],"depth":3}],"depth":2},{"title":"ZeRO Data Parallelism","local":"zero-data-parallelism","sections":[],"depth":2},{"title":"From Naive Model Parallelism to Pipeline Parallelism","local":"from-naive-model-parallelism-to-pipeline-parallelism","sections":[],"depth":2},{"title":"Tensor Parallelism","local":"tensor-parallelism","sections":[],"depth":2},{"title":"Data Parallelism + Pipeline Parallelism","local":"data-parallelism--pipeline-parallelism","sections":[],"depth":2},{"title":"Data Parallelism + Pipeline Parallelism + Tensor Parallelism","local":"data-parallelism--pipeline-parallelism--tensor-parallelism","sections":[],"depth":2},{"title":"ZeRO Data Parallelism + Pipeline Parallelism + Tensor Parallelism","local":"zero-data-parallelism--pipeline-parallelism--tensor-parallelism","sections":[],"depth":2},{"title":"FlexFlow","local":"flexflow","sections":[],"depth":2},{"title":"GPU selection","local":"gpu-selection","sections":[{"title":"Number of GPUs","local":"number-of-gpus","sections":[],"depth":3},{"title":"Order of GPUs","local":"order-of-gpus","sections":[],"depth":3}],"depth":2}],"depth":1}';function Qp(T){return Dp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qp extends Hp{constructor(p){super(),Gp(this,p,Qp,zp,_p,{})}}export{qp as component};
