import{s as ul,o as dl,n as hl}from"../chunks/scheduler.6062bdaf.js";import{S as Ml,i as Tl,g as i,s as l,r,A as yl,h as o,f as s,c as a,j as ml,u as m,x as p,k as cl,y as Jl,a as n,v as c,d as u,t as d,w as h}from"../chunks/index.4bca734e.js";import{T as gl}from"../chunks/Tip.b9ac1f03.js";import{C as M}from"../chunks/CodeBlock.fa01571c.js";import{H as y}from"../chunks/Heading.723dceba.js";function bl(ct){let T,b="Due to a limitation of ONNX Runtime, it is not possible to run quantized models on <code>CUDAExecutionProvider</code> and only models with static quantization can be run on <code>TensorrtExecutionProvider</code>.";return{c(){T=i("p"),T.innerHTML=b},l(J){T=o(J,"P",{"data-svelte-h":!0}),p(T)!=="svelte-3znnw0"&&(T.innerHTML=b)},m(J,rt){n(J,T,rt)},p:hl,d(J){J&&s(T)}}}function wl(ct){let T,b,J,rt,w,ut,U,sn="By default, ONNX Runtime runs inference on CPU devices. However, it is possible to place supported operations on an NVIDIA GPU, while leaving any unsupported ones on CPU. In most cases, this allows costly operations to be placed on GPU and significantly accelerate inference.",dt,f,nn="This guide will show you how to run inference on two execution providers that ONNX Runtime supports for NVIDIA GPUs:",ht,j,ln='<li><code>CUDAExecutionProvider</code>: Generic acceleration on NVIDIA CUDA-enabled GPUs.</li> <li><code>TensorrtExecutionProvider</code>: Uses NVIDIA’s <a href="https://developer.nvidia.com/tensorrt" rel="nofollow">TensorRT</a> inference engine and generally provides the best runtime performance.</li>',Mt,g,Tt,v,yt,C,Jt,I,an='Provided the CUDA and cuDNN <a href="https://onnxruntime.ai/docs/execution-providers/CUDA-ExecutionProvider.html#requirements" rel="nofollow">requirements</a> are satisfied, install the additional dependencies by running',gt,N,bt,Z,on="To avoid conflicts between <code>onnxruntime</code> and <code>onnxruntime-gpu</code>, make sure the package <code>onnxruntime</code> is not installed by running <code>pip uninstall onnxruntime</code> prior to installing Optimum.",wt,R,Ut,x,pn="Before going further, run the following sample code to check whether the install was successful:",ft,V,jt,E,rn="In case this code runs gracefully, congratulations, the installation is successful! If you encounter the following error or similar,",vt,B,Ct,G,mn="then something is wrong with the CUDA or ONNX Runtime installation.",It,W,Nt,$,cn="For non-quantized models, the use is straightforward. Simply specify the <code>provider</code> argument in the <code>ORTModel.from_pretrained()</code> method. Here’s an example:",Zt,k,Rt,X,un=`The model can then be used with the common 🤗 Transformers API for inference and evaluation, such as <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/pipelines" rel="nofollow">pipelines</a>.
When using Transformers pipeline, note that the <code>device</code> argument should be set to perform pre- and post-processing on GPU, following the example below:`,xt,Q,Vt,_,dn="Additionally, you can pass the session option <code>log_severity_level = 0</code> (verbose), to check whether all nodes are indeed placed on the CUDA execution provider or not:",Et,z,Bt,S,hn="You should see the following logs:",Gt,L,Wt,H,Mn="In this example, we can see that all the costly MatMul operations are placed on the CUDA execution provider.",$t,q,kt,F,Tn="Due to current limitations in ONNX Runtime, it is not possible to use quantized models with <code>CUDAExecutionProvider</code>. The reasons are as follows:",Xt,A,yn='<li><p>When using <a href="quantization#dynamic-quantization-example">🤗 Optimum dynamic quantization</a>, nodes as <a href="https://github.com/onnx/onnx/blob/v1.12.0/docs/Operators.md#MatMulInteger" rel="nofollow"><code>MatMulInteger</code></a>, <a href="https://github.com/onnx/onnx/blob/v1.12.0/docs/Operators.md#DynamicQuantizeLinear" rel="nofollow"><code>DynamicQuantizeLinear</code></a> may be inserted in the ONNX graph, that cannot be consumed by the CUDA execution provider.</p></li> <li><p>When using <a href="quantization#static-quantization-example">static quantization</a>, the ONNX computation graph will contain matrix multiplications and convolutions in floating-point arithmetic, along with Quantize + Dequantize operations to simulate quantization. In this case, although the costly matrix multiplications and convolutions will be run on the GPU, they will use floating-point arithmetic as the <code>CUDAExecutionProvider</code> can not consume the Quantize + Dequantize nodes to replace them by the operations using integer arithmetic.</p></li>',Qt,P,_t,D,Jn='<a href="https://onnxruntime.ai/docs/api/python/api_summary.html#iobinding" rel="nofollow">IOBinding</a> is an efficient way to avoid expensive data copying when using GPUs. By default, ONNX Runtime will copy the input from the CPU (even if the tensors are already copied to the targeted device), and assume that outputs also need to be copied back to the CPU from GPUs after the run. These data copying overheads between the host and devices are expensive, and <strong>can lead to worse inference latency than vanilla PyTorch</strong> especially for the decoding process.',zt,Y,gn="To avoid the slowdown, 🤗 Optimum adopts the IOBinding to copy inputs onto GPUs and pre-allocate memory for outputs prior the inference.  When instanciating the <code>ORTModel</code>, set the value of the argument <code>use_io_binding</code> to choose whether to turn on the IOBinding during the inference. <code>use_io_binding</code> is set to <code>True</code> by default, if you choose CUDA as execution provider.",St,O,bn="And if you want to turn off IOBinding:",Lt,K,Ht,ee,wn="For the time being, IOBinding is supported for task-defined ORT models, if you want us to add support for custom models, file us an issue on the Optimum’s repository.",qt,te,Ft,se,Un="We tested three common models with a decoding process: <code>GPT2</code> / <code>T5-small</code> / <code>M2M100-418M</code>, and the benchmark was run on a versatile Tesla T4 GPU (more environment details at the end of this section).",At,ne,fn="Here are some performance results running with <code>CUDAExecutionProvider</code> when IOBinding has been turned on. We have tested input sequence length from 8 to 512, and generated outputs both with greedy search and beam search (<code>num_beam=5</code>):",Pt,le,jn='<tbody><tr><td><p align="center"><img alt="GPT2" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/t4_res_ort_gpt2.png" width="450"/> <br/> <em style="color: grey">GPT2</em></p></td> <td><p align="center"><img alt="T5-small" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/t4_res_ort_t5_s.png" width="450"/> <br/> <em style="color: grey">T5-small</em></p></td></tr> <tr><td><p align="center"><img alt="M2M100-418M" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/t4_res_ort_m2m100_418m.png" width="450"/> <br/> <em style="color: grey">M2M100-418M</em></p></td></tr></tbody>',Dt,ae,vn="And here is a summary for the saving time with different sequence lengths (32 / 128) and generation modes(greedy search / beam search) while using ONNX Runtime compared with PyTorch:",Yt,ie,Cn='<tbody><tr><td><p align="center"><img alt="seq32" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/inference_models_32.png" width="800"/> <br/> <em style="color: grey">sequence length: 32</em></p></td></tr> <tr><td><p align="center"><img alt="seq128" src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/inference_models_128.png" width="800"/> <br/> <em style="color: grey">sequence length: 128</em></p></td></tr></tbody>',Ot,oe,In="Environment:",Kt,pe,es,re,Nn="Note that previous experiments are run with <strong>vanilla ONNX</strong> models exported directly from the exporter. If you are interested in <strong>further acceleration</strong>, with <code>ORTOptimizer</code> you can optimize the graph and convert your model to FP16 if you have a GPU with mixed precision capabilities.",ts,me,ss,ce,Zn='TensorRT uses its own set of optimizations, and <strong>generally does not support the optimizations from <a href="/docs/optimum/v1.16.2/en/onnxruntime/package_reference/optimization#optimum.onnxruntime.ORTOptimizer">ORTOptimizer</a></strong>. We therefore recommend to use the original ONNX models when using TensorrtExecutionProvider (<a href="https://github.com/microsoft/onnxruntime/issues/10905#issuecomment-1072649358" rel="nofollow">reference</a>).',ns,ue,ls,de,Rn="The easiest way to use TensorRT as the execution provider for models optimized through 🤗 Optimum is with the available ONNX Runtime <code>TensorrtExecutionProvider</code>.",as,he,xn="In order to use 🤗 Optimum with TensorRT in a local environment, we recommend following the NVIDIA installation guides:",is,Me,Vn='<li>CUDA toolkit: <a href="https://docs.nvidia.com/cuda/cuda-installation-guide-linux/index.html" rel="nofollow">https://docs.nvidia.com/cuda/cuda-installation-guide-linux/index.html</a></li> <li>cuDNN: <a href="https://docs.nvidia.com/deeplearning/cudnn/install-guide/index.html" rel="nofollow">https://docs.nvidia.com/deeplearning/cudnn/install-guide/index.html</a></li> <li>TensorRT: <a href="https://docs.nvidia.com/deeplearning/tensorrt/install-guide/index.html" rel="nofollow">https://docs.nvidia.com/deeplearning/tensorrt/install-guide/index.html</a></li>',os,Te,En='For TensorRT, we recommend the Tar File Installation method. Alternatively, TensorRT may be installable with <code>pip</code> by following <a href="https://github.com/microsoft/onnxruntime/issues/9986" rel="nofollow">these instructions</a>.',ps,ye,Bn="Once the required packages are installed, the following environment variables need to be set with the appropriate paths for ONNX Runtime to detect TensorRT installation:",rs,Je,ms,ge,cs,be,Gn="Before going further, run the following sample code to check whether the install was successful:",us,we,ds,Ue,Wn="In case this code runs gracefully, congratulations, the installation is successful!",hs,fe,$n="In case the above <code>assert</code> fails, or you encounter the following warning",Ms,je,Ts,ve,kn="something is wrong with the TensorRT or ONNX Runtime installation.",ys,Ce,Js,Ie,Xn='TensorRT requires to build its <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#build-phase" rel="nofollow">inference engine</a> ahead of inference, which takes some time due to the model optimization and nodes fusion. To avoid rebuilding the engine every time the model is loaded, ONNX Runtime provides a pair of options to save the engine: <code>trt_engine_cache_enable</code> and <code>trt_engine_cache_path</code>.',gs,Ne,Qn='We recommend setting these two provider options when using the TensorRT execution provider. The usage is as follows, where <a href="https://huggingface.co/optimum/gpt2" rel="nofollow"><code>optimum/gpt2</code></a> is an ONNX model converted from PyTorch using the <a href="https://huggingface.co/docs/optimum/main/en/exporters/onnx/usage_guides/export_a_model" rel="nofollow">Optimum ONNX exporter</a>:',bs,Ze,ws,Re,_n='TensorRT builds its engine depending on specified input shapes. Unfortunately, in the <a href="https://github.com/microsoft/onnxruntime/blob/613920d6c5f53a8e5e647c5f1dcdecb0a8beef31/onnxruntime/core/providers/tensorrt/tensorrt_execution_provider.cc#L1677-L1688" rel="nofollow">current ONNX Runtime implementation</a> (references: <a href="https://github.com/microsoft/onnxruntime/issues/13559" rel="nofollow">1</a>, <a href="https://github.com/microsoft/onnxruntime/issues/13851" rel="nofollow">2</a>), the engine is rebuilt every time an input has a shape smaller than the previously smallest encountered shape, and conversely if the input has a shape larger than the previously largest encountered shape. For example, if a model takes <code>(batch_size, input_ids)</code> as inputs, and the model takes successively the inputs:',Us,xe,zn="<li><code>input.shape: (4, 5) --&gt; the engine is built (first input)</code></li> <li><code>input.shape: (4, 10) --&gt; engine rebuilt (10 larger than 5)</code></li> <li><code>input.shape: (4, 7) --&gt; no rebuild (5 &lt;= 7 &lt;= 10)</code></li> <li><code>input.shape: (4, 12) --&gt; engine rebuilt (10 &lt;= 12)</code></li> <li><code>input.shape: (4, 3) --&gt; engine rebuilt (3 &lt;= 5)</code></li>",fs,Ve,Sn="One big issue is that building the engine can be time consuming, especially for large models. Therefore, as a workaround, one recommendation is to <strong>first build the TensorRT engine with an input of small shape, and then with an input of large shape to have an engine valid for all shapes inbetween</strong>. This allows to avoid rebuilding the engine for new small and large shapes, which is unwanted once the model is deployed for inference.",js,Ee,Ln="Passing the engine cache path in the provider options, the engine can therefore be built once for all and used fully for inference thereafter.",vs,Be,Hn="For example, for text generation, the engine can be built with:",Cs,Ge,Is,We,qn="The engine is stored as:",Ns,$e,Fn='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/tensorrt_cache.png" alt="TensorRT engine cache folder"/>',Zs,ke,An="Once the engine is built, the cache can be reloaded and generation does not need to rebuild the engine:",Rs,Xe,xs,Qe,Vs,_e,Pn='Once the engine is built, it is recommended to do before inference <strong>one or a few warmup steps</strong>, as the first inference runs have <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#trtexec-flags" rel="nofollow">some overhead</a>.',Es,ze,Bs,Se,Dn="For non-quantized models, the use is straightforward, by simply using the <code>provider</code> argument in <code>ORTModel.from_pretrained()</code>. For example:",Gs,Le,Ws,He,Yn='<a href="#use-cuda-execution-provider-with-floatingpoint-models">As previously for <code>CUDAExecutionProvider</code></a>, by passing the session option <code>log_severity_level = 0</code> (verbose), we can check in the logs whether all nodes are indeed placed on the TensorRT execution provider or not:',$s,qe,ks,Fe,On='The model can then be used with the common 🤗 Transformers API for inference and evaluation, such as <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/pipelines" rel="nofollow">pipelines</a>.',Xs,Ae,Qs,Pe,Kn='When it comes to quantized models, TensorRT only supports models that use <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#enable_int8_c" rel="nofollow"><strong>static</strong> quantization</a> with <a href="https://docs.nvidia.com/deeplearning/tensorrt/developer-guide/index.html#intro-quantization" rel="nofollow"><strong>symmetric quantization</strong> for weights and activations</a>.',_s,De,el='🤗 Optimum provides a quantization config ready to be used with <a href="/docs/optimum/v1.16.2/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> with the constraints of TensorRT quantization:',zs,Ye,Ss,Oe,tl='Using this <code>qconfig</code>, static quantization can be performed as explained in the <a href="quantization#static-quantization-example">static quantization guide</a>.',Ls,Ke,sl='In the code sample below, after performing static quantization, the resulting model is loaded into the <a href="/docs/optimum/v1.16.2/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a> class using TensorRT as the execution provider. ONNX Runtime graph optimization needs to be disabled for the model to be consumed and optimized by TensorRT, and the fact that INT8 operations are used needs to be specified to TensorRT.',Hs,et,qs,tt,nl='The model can then be used with the common 🤗 Transformers API for inference and evaluation, such as <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/pipelines" rel="nofollow">pipelines</a>.',Fs,st,As,nt,ll="As highlighted in the previous section, TensorRT supports only a limited range of quantized models:",Ps,lt,al="<li>Static quantization only</li> <li>Weights and activations quantization ranges are symmetric</li> <li>Weights need to be stored in float32 in the ONNX model, thus there is no storage space saving from quantization. TensorRT indeed requires to insert full Quantize + Dequantize pairs. Normally, weights would be stored in fixed point 8-bits format and only a <code>DequantizeLinear</code> would be applied on the weights.</li>",Ds,at,il="In case <code>provider=&quot;TensorrtExecutionProvider&quot;</code> is passed and the model has not been quantized strictly following these constraints, various errors may be raised, where error messages can be unclear.",Ys,it,Os,ot,ol="Nvidia Nsight Systems tool can be used to profile the execution time on GPU. Before profiling or measuring latency/throughput, it is a good practice to do a few <strong>warmup steps</strong>.",Ks,pt,pl="Coming soon!",en,mt,tn;return w=new y({props:{title:"Accelerated inference on NVIDIA GPUs",local:"accelerated-inference-on-nvidia-gpus",headingTag:"h1"}}),g=new gl({props:{warning:!0,$$slots:{default:[bl]},$$scope:{ctx:ct}}}),v=new y({props:{title:"CUDAExecutionProvider",local:"cudaexecutionprovider",headingTag:"h2"}}),C=new y({props:{title:"CUDA installation",local:"cuda-installation",headingTag:"h3"}}),N=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0lNUJvbm54cnVudGltZS1ncHUlNUQ=",highlighted:"pip install optimum[onnxruntime-gpu]",wrap:!1}}),R=new y({props:{title:"Checking the CUDA installation is successful",local:"checking-the-cuda-installation-is-successful",headingTag:"h3"}}),V=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIycGhpbHNjaG1pZCUyRnRpbnktYmVydC1zc3QyLWRpc3RpbGxlZCUyMiUyQyUwQSUyMCUyMGV4cG9ydCUzRFRydWUlMkMlMEElMjAlMjBwcm92aWRlciUzRCUyMkNVREFFeGVjdXRpb25Qcm92aWRlciUyMiUyQyUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJwaGlsc2NobWlkJTJGdGlueS1iZXJ0LXNzdDItZGlzdGlsbGVkJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJleHBlY3RhdGlvbnMlMjB3ZXJlJTIwbG93JTJDJTIwYWN0dWFsJTIwZW5qb3ltZW50JTIwd2FzJTIwaGlnaCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFvdXRwdXRzJTIwJTNEJTIwb3J0X21vZGVsKCoqaW5wdXRzKSUwQWFzc2VydCUyMG9ydF9tb2RlbC5wcm92aWRlcnMlMjAlM0QlM0QlMjAlNUIlMjJDVURBRXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMjAlMjJDUFVFeGVjdXRpb25Qcm92aWRlciUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>,
<span class="hljs-meta">... </span>  export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;expectations were low, actual enjoyment was high&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = ort_model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> ort_model.providers == [<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>, <span class="hljs-string">&quot;CPUExecutionProvider&quot;</span>]`,wrap:!1}}),B=new M({props:{code:"VmFsdWVFcnJvciUzQSUyMEFza2VkJTIwdG8lMjB1c2UlMjBDVURBRXhlY3V0aW9uUHJvdmlkZXIlMjBhcyUyMGFuJTIwT05OWCUyMFJ1bnRpbWUlMjBleGVjdXRpb24lMjBwcm92aWRlciUyQyUyMGJ1dCUyMHRoZSUyMGF2YWlsYWJsZSUyMGV4ZWN1dGlvbiUyMHByb3ZpZGVycyUyMGFyZSUyMCU1QidDUFVFeGVjdXRpb25Qcm92aWRlciclNUQu",highlighted:'ValueError: Asked <span class="hljs-built_in">to</span> use CUDAExecutionProvider <span class="hljs-keyword">as</span> <span class="hljs-keyword">an</span> ONNX Runtime execution provider, but <span class="hljs-keyword">the</span> available execution providers are [<span class="hljs-string">&#x27;CPUExecutionProvider&#x27;</span>].',wrap:!1}}),W=new y({props:{title:"Use CUDA execution provider with floating-point models",local:"use-cuda-execution-provider-with-floating-point-models",headingTag:"h3"}}),k=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMHByb3ZpZGVyJTNEJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>  export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Q=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ucGlwZWxpbmVzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEb3J0X21vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUzQTAlMjIpJTBBcmVzdWx0JTIwJTNEJTIwcGlwZSglMjJCb3RoJTIwdGhlJTIwbXVzaWMlMjBhbmQlMjB2aXN1YWwlMjB3ZXJlJTIwYXN0b3VuZGluZyUyQyUyMG5vdCUyMHRvJTIwbWVudGlvbiUyMHRoZSUyMGFjdG9ycyUyMHBlcmZvcm1hbmNlLiUyMiklMEFwcmludChyZXN1bHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;text-classification&quot;</span>, model=ort_model, tokenizer=tokenizer, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = pipe(<span class="hljs-string">&quot;Both the music and visual were astounding, not to mention the actors performance.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)
<span class="hljs-comment"># printing: [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9997727274894714}]</span>`,wrap:!1}}),z=new M({props:{code:"aW1wb3J0JTIwb25ueHJ1bnRpbWUlMEElMEFzZXNzaW9uX29wdGlvbnMlMjAlM0QlMjBvbm54cnVudGltZS5TZXNzaW9uT3B0aW9ucygpJTBBc2Vzc2lvbl9vcHRpb25zLmxvZ19zZXZlcml0eV9sZXZlbCUyMCUzRCUyMDAlMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2Vzc2lvbl9vcHRpb25zJTNEc2Vzc2lvbl9vcHRpb25zJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> onnxruntime

<span class="hljs-meta">&gt;&gt;&gt; </span>session_options = onnxruntime.SessionOptions()
<span class="hljs-meta">&gt;&gt;&gt; </span>session_options.log_severity_level = <span class="hljs-number">0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    session_options=session_options
<span class="hljs-meta">... </span>)`,wrap:!1}}),L=new M({props:{code:"MjAyMi0xMC0xOCUyMDE0JTNBNTklM0ExMy43Mjg4ODYwNDElMjAlNUJWJTNBb25ueHJ1bnRpbWUlM0ElMkMlMjBzZXNzaW9uX3N0YXRlLmNjJTNBMTE5MyUyMFZlcmlmeUVhY2hOJTBBb2RlSXNBc3NpZ25lZFRvQW5FcCU1RCUyMCUyMFByb3ZpZGVyJTNBJTIwJTVCQ1BVRXhlY3V0aW9uUHJvdmlkZXIlNUQlM0ElMjAlNUJHYXRoZXIlMjAoR2F0aGVyXzc2KSUyQyUyMFVucyUwQXF1ZWV6ZSUyMChVbnNxdWVlemVfNzgpJTJDJTIwR2F0aGVyJTIwKEdhdGhlcl85NyklMkMlMjBHYXRoZXIlMjAoR2F0aGVyXzEwMCklMkMlMjBDb25jYXQlMjAoQ29uY2F0XzElMEExMCklMkMlMjBVbnNxdWVlemUlMjAoVW5zcXVlZXplXzEyNSklMkMlMjAuLi4lNUQlMEEyMDIyLTEwLTE4JTIwMTQlM0E1OSUzQTEzLjcyODkwNjQzMSUyMCU1QlYlM0Fvbm54cnVudGltZSUzQSUyQyUyMHNlc3Npb25fc3RhdGUuY2MlM0ExMTkzJTIwVmVyaWZ5RWFjaE4lMEFvZGVJc0Fzc2lnbmVkVG9BbkVwJTVEJTIwJTIwUHJvdmlkZXIlM0ElMjAlNUJDVURBRXhlY3V0aW9uUHJvdmlkZXIlNUQlM0ElMjAlNUJTaGFwZSUyMChTaGFwZV83NCklMkMlMjBTbGljJTBBZSUyMChTbGljZV84MCklMkMlMjBHYXRoZXIlMjAoR2F0aGVyXzgxKSUyQyUyMEdhdGhlciUyMChHYXRoZXJfODIpJTJDJTIwQWRkJTIwKEFkZF84MyklMkMlMjBTaGFwZSUyMChTaGFwZSUwQV85NSklMkMlMjBNYXRNdWwlMjAoTWF0TXVsXzEwMSklMkMlMjAuLi4lNUQ=",highlighted:`<span class="hljs-attribute">2022</span>-<span class="hljs-number">10</span>-<span class="hljs-number">18</span> <span class="hljs-number">14</span>:<span class="hljs-number">59</span>:<span class="hljs-number">13</span>.<span class="hljs-number">728886041</span><span class="hljs-meta"> [V:onnxruntime:, session_state.cc:1193 VerifyEachN
odeIsAssignedToAnEp]  Provider: [CPUExecutionProvider]: [Gather (Gather_76), Uns
queeze (Unsqueeze_78), Gather (Gather_97), Gather (Gather_100), Concat (Concat_1
10), Unsqueeze (Unsqueeze_125), ...]</span>
<span class="hljs-attribute">2022</span>-<span class="hljs-number">10</span>-<span class="hljs-number">18</span> <span class="hljs-number">14</span>:<span class="hljs-number">59</span>:<span class="hljs-number">13</span>.<span class="hljs-number">728906431</span><span class="hljs-meta"> [V:onnxruntime:, session_state.cc:1193 VerifyEachN
odeIsAssignedToAnEp]  Provider: [CUDAExecutionProvider]: [Shape (Shape_74), Slic
e (Slice_80), Gather (Gather_81), Gather (Gather_82), Add (Add_83), Shape (Shape
_95), MatMul (MatMul_101), ...]</span>`,wrap:!1}}),q=new y({props:{title:"Use CUDA execution provider with quantized models",local:"use-cuda-execution-provider-with-quantized-models",headingTag:"h3"}}),P=new y({props:{title:"Reduce memory footprint with IOBinding",local:"reduce-memory-footprint-with-iobinding",headingTag:"h3"}}),K=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJ0NS1zbWFsbCUyMiUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjB1c2VfaW9fYmluZGluZyUzREZhbHNlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19mciUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTNBMCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-comment"># Create a pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_fr&quot;</span>, model=model, tokenizer=tokenizer, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)`,wrap:!1}}),te=new y({props:{title:"Observed time gains",local:"observed-time-gains",headingTag:"h3"}}),pe=new M({props:{code:"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",highlighted:`+-----------------------------------------------------------------------------+
|<span class="hljs-string"> NVIDIA-SMI 440.33.01    Driver Version: 440.33.01    CUDA Version: 11.3     </span>|
|<span class="hljs-string">-------------------------------+----------------------+----------------------+
</span>|<span class="hljs-string"> GPU  Name        Persistence-M</span>|<span class="hljs-string"> Bus-Id        Disp.A </span>|<span class="hljs-string"> Volatile Uncorr. ECC </span>|
|<span class="hljs-string"> Fan  Temp  Perf  Pwr:Usage/Cap</span>|<span class="hljs-string">         Memory-Usage </span>|<span class="hljs-string"> GPU-Util  Compute M. </span>|
|<span class="hljs-string">===============================+======================+======================</span>|
|<span class="hljs-string">   0  Tesla T4            On   </span>|<span class="hljs-string"> 00000000:00:1E.0 Off </span>|<span class="hljs-string">                    0 </span>|
|<span class="hljs-string"> N/A   28C    P8     8W /  70W </span>|<span class="hljs-string">      0MiB / 15109MiB </span>|<span class="hljs-string">      0%      Default </span>|
+-------------------------------+----------------------+----------------------+

- Platform: Linux-5.4.0-1089-aws-x86_64-with-glibc2.29
- Python version: 3.8.10
- \`transformers\` version: 4.24.0
- \`optimum\` version: 1.5.0
- PyTorch version: 1.12.0+cu113`,wrap:!1}}),me=new y({props:{title:"TensorrtExecutionProvider",local:"tensorrtexecutionprovider",headingTag:"h2"}}),ue=new y({props:{title:"TensorRT installation",local:"tensorrt-installation",headingTag:"h3"}}),Je=new M({props:{code:"ZXhwb3J0JTIwQ1VEQV9QQVRIJTNEJTJGdXNyJTJGbG9jYWwlMkZjdWRhJTBBZXhwb3J0JTIwTERfTElCUkFSWV9QQVRIJTNEJTI0TERfTElCUkFSWV9QQVRIJTNBJTJGdXNyJTJGbG9jYWwlMkZjdWRhLXgueCUyRmxpYjY0JTNBJTJGcGF0aCUyRnRvJTJGVGVuc29yUlQtOC54LnglMkZsaWI=",highlighted:`<span class="hljs-built_in">export</span> CUDA_PATH=/usr/local/cuda
<span class="hljs-built_in">export</span> LD_LIBRARY_PATH=<span class="hljs-variable">$LD_LIBRARY_PATH</span>:/usr/local/cuda-x.x/lib64:/path/to/TensorRT-8.x.x/lib`,wrap:!1}}),ge=new y({props:{title:"Checking the TensorRT installation is successful",local:"checking-the-tensorrt-installation-is-successful",headingTag:"h3"}}),we=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycGhpbHNjaG1pZCUyRnRpbnktYmVydC1zc3QyLWRpc3RpbGxlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV4cG9ydCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMlRlbnNvcnJ0RXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMEEpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIycGhpbHNjaG1pZCUyRnRpbnktYmVydC1zc3QyLWRpc3RpbGxlZCUyMiklMEFpbnAlMjAlM0QlMjB0b2tlbml6ZXIoJTIyZXhwZWN0YXRpb25zJTIwd2VyZSUyMGxvdyUyQyUyMGFjdHVhbCUyMGVuam95bWVudCUyMHdhcyUyMGhpZ2glMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBJTBBcmVzdWx0JTIwJTNEJTIwb3J0X21vZGVsKCoqaW5wKSUwQWFzc2VydCUyMG9ydF9tb2RlbC5wcm92aWRlcnMlMjAlM0QlM0QlMjAlNUIlMjJUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTIwJTIyQ1VEQUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTIwJTIyQ1BVRXhlY3V0aW9uUHJvdmlkZXIlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inp = tokenizer(<span class="hljs-string">&quot;expectations were low, actual enjoyment was high&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>result = ort_model(**inp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> ort_model.providers == [<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>, <span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>, <span class="hljs-string">&quot;CPUExecutionProvider&quot;</span>]`,wrap:!1}}),je=new M({props:{code:"RmFpbGVkJTIwdG8lMjBjcmVhdGUlMjBUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyLiUyMFBsZWFzZSUyMHJlZmVyZW5jZSUyMGh0dHBzJTNBJTJGJTJGb25ueHJ1bnRpbWUuYWklMkZkb2NzJTJGZXhlY3V0aW9uLXByb3ZpZGVycyUyRlRlbnNvclJULUV4ZWN1dGlvblByb3ZpZGVyLmh0bWwlMjNyZXF1aXJlbWVudHMlMjB0byUyMGVuc3VyZSUyMGFsbCUyMGRlcGVuZGVuY2llcyUyMGFyZSUyMG1ldC4=",highlighted:'Failed to create TensorrtExecutionProvider. Please reference https:<span class="hljs-regexp">//</span>onnxruntime.ai<span class="hljs-regexp">/docs/</span>execution-providers/TensorRT-ExecutionProvider.html<span class="hljs-comment">#requirements to ensure all dependencies are met.</span>',wrap:!1}}),Ce=new y({props:{title:"TensorRT engine build and warmup",local:"tensorrt-engine-build-and-warmup",headingTag:"h3"}}),Ze=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckNhdXNhbExNJTBBJTBBcHJvdmlkZXJfb3B0aW9ucyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRydF9lbmdpbmVfY2FjaGVfZW5hYmxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnRydF9lbmdpbmVfY2FjaGVfcGF0aCUyMiUzQSUyMCUyMnRtcCUyRnRydF9jYWNoZV9ncHQyX2V4YW1wbGUlMjIlMEElN0QlMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcHRpbXVtJTJGZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXJfb3B0aW9ucyUzRHByb3ZpZGVyX29wdGlvbnMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>provider_options = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_enable&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_path&quot;</span>: <span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>
<span class="hljs-meta">... </span>}

<span class="hljs-comment"># the TensorRT engine is not built here, it will be when doing inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/gpt2&quot;</span>,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    provider_options=provider_options
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ge=new M({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW9zLm1ha2VkaXJzKCUyMnRtcCUyRnRydF9jYWNoZV9ncHQyX2V4YW1wbGUlMjIlMkMlMjBleGlzdF9vayUzRFRydWUpJTBBcHJvdmlkZXJfb3B0aW9ucyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRydF9lbmdpbmVfY2FjaGVfZW5hYmxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnRydF9lbmdpbmVfY2FjaGVfcGF0aCUyMiUzQSUyMCUyMnRtcCUyRnRydF9jYWNoZV9ncHQyX2V4YW1wbGUlMjIlMEElN0QlMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcHRpbXVtJTJGZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXJfb3B0aW9ucyUzRHByb3ZpZGVyX29wdGlvbnMlMkMlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBcHJpbnQoJTIyQnVpbGRpbmclMjBlbmdpbmUlMjBmb3IlMjBhJTIwc2hvcnQlMjBzZXF1ZW5jZS4uLiUyMiklMEF0ZXh0JTIwJTNEJTIwJTVCJTIyc2hvcnQlMjIlNUQlMEFlbmNvZGVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQW91dHB1dCUyMCUzRCUyMG9ydF9tb2RlbCgqKmVuY29kZWRfaW5wdXQpJTBBJTBBcHJpbnQoJTIyQnVpbGRpbmclMjBlbmdpbmUlMjBmb3IlMjBhJTIwbG9uZyUyMHNlcXVlbmNlLi4uJTIyKSUwQXRleHQlMjAlM0QlMjAlNUIlMjIlMjBhJTIwdmVyeSUyMGxvbmclMjBpbnB1dCUyMGp1c3QlMjBmb3IlMjBkZW1vJTIwcHVycG9zZSUyQyUyMHRoaXMlMjBpcyUyMHZlcnklMjBsb25nJTIyJTIwKiUyMDEwJTVEJTBBZW5jb2RlZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEFvdXRwdXQlMjAlM0QlMjBvcnRfbW9kZWwoKiplbmNvZGVkX2lucHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>os.makedirs(<span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>provider_options = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_enable&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_path&quot;</span>: <span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/gpt2&quot;</span>,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    provider_options=provider_options,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Building engine for a short sequence...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = [<span class="hljs-string">&quot;short&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_input = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = ort_model(**encoded_input)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Building engine for a long sequence...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = [<span class="hljs-string">&quot; a very long input just for demo purpose, this is very long&quot;</span> * <span class="hljs-number">10</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_input = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = ort_model(**encoded_input)`,wrap:!1}}),Xe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEElMEFwcm92aWRlcl9vcHRpb25zJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHJ0X2VuZ2luZV9jYWNoZV9lbmFibGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJ0X2VuZ2luZV9jYWNoZV9wYXRoJTIyJTNBJTIwJTIydG1wJTJGdHJ0X2NhY2hlX2dwdDJfZXhhbXBsZSUyMiUwQSU3RCUwQSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm9wdGltdW0lMkZncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2NhY2hlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMlRlbnNvcnJ0RXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBwcm92aWRlcl9vcHRpb25zJTNEcHJvdmlkZXJfb3B0aW9ucyUyQyUwQSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZ3B0MiUyMiklMEElMEF0ZXh0JTIwJTNEJTIwJTVCJTIyUmVwbGFjZSUyMG1lJTIwYnklMjBhbnklMjB0ZXh0JTIweW91J2QlMjBsaWtlLiUyMiU1RCUwQWVuY29kZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIodGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoMyklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjBvcnRfbW9kZWwuZ2VuZXJhdGUoKiplbmNvZGVkX2lucHV0KSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCkpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQklHTk9SRV9SRVNVTFQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>provider_options = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_enable&quot;</span>: <span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;trt_engine_cache_path&quot;</span>: <span class="hljs-string">&quot;tmp/trt_cache_gpt2_example&quot;</span>
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/gpt2&quot;</span>,
<span class="hljs-meta">... </span>    use_cache=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    provider_options=provider_options,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = [<span class="hljs-string">&quot;Replace me by any text you&#x27;d like.&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_input = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
<span class="hljs-meta">... </span>    output = ort_model.generate(**encoded_input)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>]))  <span class="hljs-comment"># doctest: +IGNORE_RESULT</span>`,wrap:!1}}),Qe=new y({props:{title:"Warmup",local:"warmup",headingTag:"h4"}}),ze=new y({props:{title:"Use TensorRT execution provider with floating-point models",local:"use-tensorrt-execution-provider-with-floating-point-models",headingTag:"h3"}}),Le=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyVGVuc29ycnRFeGVjdXRpb25Qcm92aWRlciUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),qe=new M({props:{code:"MjAyMi0wOS0yMiUyMDE0JTNBMTIlM0E0OC4zNzE1MTM3NDElMjAlNUJWJTNBb25ueHJ1bnRpbWUlM0ElMkMlMjBzZXNzaW9uX3N0YXRlLmNjJTNBMTE4OCUyMFZlcmlmeUVhY2hOb2RlSXNBc3NpZ25lZFRvQW5FcCU1RCUyMEFsbCUyMG5vZGVzJTIwaGF2ZSUyMGJlZW4lMjBwbGFjZWQlMjBvbiUyMCU1QlRlbnNvcnJ0RXhlY3V0aW9uUHJvdmlkZXIlNUQ=",highlighted:'<span class="hljs-attribute">2022</span>-<span class="hljs-number">09</span>-<span class="hljs-number">22</span> <span class="hljs-number">14</span>:<span class="hljs-number">12</span>:<span class="hljs-number">48</span>.<span class="hljs-number">371513741</span><span class="hljs-meta"> [V:onnxruntime:, session_state.cc:1188 VerifyEachNodeIsAssignedToAnEp] All nodes have been placed on [TensorrtExecutionProvider]</span>',wrap:!1}}),Ae=new y({props:{title:"Use TensorRT execution provider with quantized models",local:"use-tensorrt-execution-provider-with-quantized-models",headingTag:"h3"}}),Ye=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBBdXRvUXVhbnRpemF0aW9uQ29uZmlnJTBBJTBBcWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcudGVuc29ycnQocGVyX2NoYW5uZWwlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> AutoQuantizationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.tensorrt(per_channel=<span class="hljs-literal">False</span>)`,wrap:!1}}),et=new M({props:{code:"aW1wb3J0JTIwb25ueHJ1bnRpbWUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBc2Vzc2lvbl9vcHRpb25zJTIwJTNEJTIwb25ueHJ1bnRpbWUuU2Vzc2lvbk9wdGlvbnMoKSUwQXNlc3Npb25fb3B0aW9ucy5ncmFwaF9vcHRpbWl6YXRpb25fbGV2ZWwlMjAlM0QlMjBvbm54cnVudGltZS5HcmFwaE9wdGltaXphdGlvbkxldmVsLk9SVF9ESVNBQkxFX0FMTCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZ4bWFydHklMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1zc3QyLW9ubngtaW50OC1mb3ItdGVuc29ycnQlMjIpJTBBb3J0X21vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmeG1hcnR5JTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtc3N0Mi1vbm54LWludDgtZm9yLXRlbnNvcnJ0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJUZW5zb3JydEV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2Vzc2lvbl9vcHRpb25zJTNEc2Vzc2lvbl9vcHRpb25zJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXJfb3B0aW9ucyUzRCU3QiUyMnRydF9pbnQ4X2VuYWJsZSUyMiUzQSUyMFRydWUlN0QlMkMlMEEpJTBBJTBBaW5wJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRlbnNvclJUJTIwaXMlMjBhJTIwYml0JTIwcGFpbmZ1bCUyMHRvJTIwdXNlJTJDJTIwYnV0JTIwYXQlMjB0aGUlMjBlbmQlMjBvZiUyMGRheSUyMGl0JTIwcnVucyUyMHNtb290aGx5JTIwYW5kJTIwYmxhemluZ2x5JTIwZmFzdCElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQXJlcyUyMCUzRCUyMG9ydF9tb2RlbCgqKmlucCklMEElMEFwcmludChyZXMpJTBBcHJpbnQob3J0X21vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnJlcy5sb2dpdHMlNUIwJTVELmFyZ21heCgpJTVEKSUwQSUyMyUyMFNlcXVlbmNlQ2xhc3NpZmllck91dHB1dChsb3NzJTNETm9uZSUyQyUyMGxvZ2l0cyUzRGFycmF5KCU1QiU1Qi0wLjU0NTA2NiUyMCUyQyUyMCUyMDAuNTYwOTc2NCU1RCU1RCUyQyUyMGR0eXBlJTNEZmxvYXQzMiklMkMlMjBoaWRkZW5fc3RhdGVzJTNETm9uZSUyQyUyMGF0dGVudGlvbnMlM0ROb25lKSUwQSUyMyUyMFBPU0lUSVZF",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> onnxruntime
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>session_options = onnxruntime.SessionOptions()
<span class="hljs-meta">&gt;&gt;&gt; </span>session_options.graph_optimization_level = onnxruntime.GraphOptimizationLevel.ORT_DISABLE_ALL

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;fxmarty/distilbert-base-uncased-sst2-onnx-int8-for-tensorrt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fxmarty/distilbert-base-uncased-sst2-onnx-int8-for-tensorrt&quot;</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;TensorrtExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    session_options=session_options,
<span class="hljs-meta">... </span>    provider_options={<span class="hljs-string">&quot;trt_int8_enable&quot;</span>: <span class="hljs-literal">True</span>},
<span class="hljs-meta">&gt;&gt;&gt; </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inp = tokenizer(<span class="hljs-string">&quot;TensorRT is a bit painful to use, but at the end of day it runs smoothly and blazingly fast!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>res = ort_model(**inp)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(res)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(ort_model.config.id2label[res.logits[<span class="hljs-number">0</span>].argmax()])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SequenceClassifierOutput(loss=None, logits=array([[-0.545066 ,  0.5609764]], dtype=float32), hidden_states=None, attentions=None)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># POSITIVE</span>`,wrap:!1}}),st=new y({props:{title:"TensorRT limitations for quantized models",local:"tensorrt-limitations-for-quantized-models",headingTag:"h3"}}),it=new y({props:{title:"Observed time gains",local:"observed-time-gains",headingTag:"h3"}}),{c(){T=i("meta"),b=l(),J=i("p"),rt=l(),r(w.$$.fragment),ut=l(),U=i("p"),U.textContent=sn,dt=l(),f=i("p"),f.textContent=nn,ht=l(),j=i("ul"),j.innerHTML=ln,Mt=l(),r(g.$$.fragment),Tt=l(),r(v.$$.fragment),yt=l(),r(C.$$.fragment),Jt=l(),I=i("p"),I.innerHTML=an,gt=l(),r(N.$$.fragment),bt=l(),Z=i("p"),Z.innerHTML=on,wt=l(),r(R.$$.fragment),Ut=l(),x=i("p"),x.textContent=pn,ft=l(),r(V.$$.fragment),jt=l(),E=i("p"),E.textContent=rn,vt=l(),r(B.$$.fragment),Ct=l(),G=i("p"),G.textContent=mn,It=l(),r(W.$$.fragment),Nt=l(),$=i("p"),$.innerHTML=cn,Zt=l(),r(k.$$.fragment),Rt=l(),X=i("p"),X.innerHTML=un,xt=l(),r(Q.$$.fragment),Vt=l(),_=i("p"),_.innerHTML=dn,Et=l(),r(z.$$.fragment),Bt=l(),S=i("p"),S.textContent=hn,Gt=l(),r(L.$$.fragment),Wt=l(),H=i("p"),H.textContent=Mn,$t=l(),r(q.$$.fragment),kt=l(),F=i("p"),F.innerHTML=Tn,Xt=l(),A=i("ul"),A.innerHTML=yn,Qt=l(),r(P.$$.fragment),_t=l(),D=i("p"),D.innerHTML=Jn,zt=l(),Y=i("p"),Y.innerHTML=gn,St=l(),O=i("p"),O.textContent=bn,Lt=l(),r(K.$$.fragment),Ht=l(),ee=i("p"),ee.textContent=wn,qt=l(),r(te.$$.fragment),Ft=l(),se=i("p"),se.innerHTML=Un,At=l(),ne=i("p"),ne.innerHTML=fn,Pt=l(),le=i("table"),le.innerHTML=jn,Dt=l(),ae=i("p"),ae.textContent=vn,Yt=l(),ie=i("table"),ie.innerHTML=Cn,Ot=l(),oe=i("p"),oe.textContent=In,Kt=l(),r(pe.$$.fragment),es=l(),re=i("p"),re.innerHTML=Nn,ts=l(),r(me.$$.fragment),ss=l(),ce=i("p"),ce.innerHTML=Zn,ns=l(),r(ue.$$.fragment),ls=l(),de=i("p"),de.innerHTML=Rn,as=l(),he=i("p"),he.textContent=xn,is=l(),Me=i("ul"),Me.innerHTML=Vn,os=l(),Te=i("p"),Te.innerHTML=En,ps=l(),ye=i("p"),ye.textContent=Bn,rs=l(),r(Je.$$.fragment),ms=l(),r(ge.$$.fragment),cs=l(),be=i("p"),be.textContent=Gn,us=l(),r(we.$$.fragment),ds=l(),Ue=i("p"),Ue.textContent=Wn,hs=l(),fe=i("p"),fe.innerHTML=$n,Ms=l(),r(je.$$.fragment),Ts=l(),ve=i("p"),ve.textContent=kn,ys=l(),r(Ce.$$.fragment),Js=l(),Ie=i("p"),Ie.innerHTML=Xn,gs=l(),Ne=i("p"),Ne.innerHTML=Qn,bs=l(),r(Ze.$$.fragment),ws=l(),Re=i("p"),Re.innerHTML=_n,Us=l(),xe=i("ol"),xe.innerHTML=zn,fs=l(),Ve=i("p"),Ve.innerHTML=Sn,js=l(),Ee=i("p"),Ee.textContent=Ln,vs=l(),Be=i("p"),Be.textContent=Hn,Cs=l(),r(Ge.$$.fragment),Is=l(),We=i("p"),We.textContent=qn,Ns=l(),$e=i("p"),$e.innerHTML=Fn,Zs=l(),ke=i("p"),ke.textContent=An,Rs=l(),r(Xe.$$.fragment),xs=l(),r(Qe.$$.fragment),Vs=l(),_e=i("p"),_e.innerHTML=Pn,Es=l(),r(ze.$$.fragment),Bs=l(),Se=i("p"),Se.innerHTML=Dn,Gs=l(),r(Le.$$.fragment),Ws=l(),He=i("p"),He.innerHTML=Yn,$s=l(),r(qe.$$.fragment),ks=l(),Fe=i("p"),Fe.innerHTML=On,Xs=l(),r(Ae.$$.fragment),Qs=l(),Pe=i("p"),Pe.innerHTML=Kn,_s=l(),De=i("p"),De.innerHTML=el,zs=l(),r(Ye.$$.fragment),Ss=l(),Oe=i("p"),Oe.innerHTML=tl,Ls=l(),Ke=i("p"),Ke.innerHTML=sl,Hs=l(),r(et.$$.fragment),qs=l(),tt=i("p"),tt.innerHTML=nl,Fs=l(),r(st.$$.fragment),As=l(),nt=i("p"),nt.textContent=ll,Ps=l(),lt=i("ul"),lt.innerHTML=al,Ds=l(),at=i("p"),at.innerHTML=il,Ys=l(),r(it.$$.fragment),Os=l(),ot=i("p"),ot.innerHTML=ol,Ks=l(),pt=i("p"),pt.textContent=pl,en=l(),mt=i("p"),this.h()},l(e){const t=yl("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(s),b=a(e),J=o(e,"P",{}),ml(J).forEach(s),rt=a(e),m(w.$$.fragment,e),ut=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-domqad"&&(U.textContent=sn),dt=a(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-ww48at"&&(f.textContent=nn),ht=a(e),j=o(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-1f150mv"&&(j.innerHTML=ln),Mt=a(e),m(g.$$.fragment,e),Tt=a(e),m(v.$$.fragment,e),yt=a(e),m(C.$$.fragment,e),Jt=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-19ifj7n"&&(I.innerHTML=an),gt=a(e),m(N.$$.fragment,e),bt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-uw46pi"&&(Z.innerHTML=on),wt=a(e),m(R.$$.fragment,e),Ut=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-ojb3z4"&&(x.textContent=pn),ft=a(e),m(V.$$.fragment,e),jt=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-j2t2xg"&&(E.textContent=rn),vt=a(e),m(B.$$.fragment,e),Ct=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-f1x068"&&(G.textContent=mn),It=a(e),m(W.$$.fragment,e),Nt=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-8e3pil"&&($.innerHTML=cn),Zt=a(e),m(k.$$.fragment,e),Rt=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1icvfx4"&&(X.innerHTML=un),xt=a(e),m(Q.$$.fragment,e),Vt=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1i8mx2m"&&(_.innerHTML=dn),Et=a(e),m(z.$$.fragment,e),Bt=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-gej35a"&&(S.textContent=hn),Gt=a(e),m(L.$$.fragment,e),Wt=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1fiacx2"&&(H.textContent=Mn),$t=a(e),m(q.$$.fragment,e),kt=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-bair0o"&&(F.innerHTML=Tn),Xt=a(e),A=o(e,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-1530vj"&&(A.innerHTML=yn),Qt=a(e),m(P.$$.fragment,e),_t=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1weebfs"&&(D.innerHTML=Jn),zt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1uj5t80"&&(Y.innerHTML=gn),St=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-5cnra5"&&(O.textContent=bn),Lt=a(e),m(K.$$.fragment,e),Ht=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-lbg3hy"&&(ee.textContent=wn),qt=a(e),m(te.$$.fragment,e),Ft=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-j6vk0b"&&(se.innerHTML=Un),At=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-gwibyk"&&(ne.innerHTML=fn),Pt=a(e),le=o(e,"TABLE",{"data-svelte-h":!0}),p(le)!=="svelte-kb5dzt"&&(le.innerHTML=jn),Dt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1o7p4o2"&&(ae.textContent=vn),Yt=a(e),ie=o(e,"TABLE",{"data-svelte-h":!0}),p(ie)!=="svelte-1vr8f8j"&&(ie.innerHTML=Cn),Ot=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1fkshtn"&&(oe.textContent=In),Kt=a(e),m(pe.$$.fragment,e),es=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1qw28p2"&&(re.innerHTML=Nn),ts=a(e),m(me.$$.fragment,e),ss=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1nu89bp"&&(ce.innerHTML=Zn),ns=a(e),m(ue.$$.fragment,e),ls=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1rs6298"&&(de.innerHTML=Rn),as=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1ceem44"&&(he.textContent=xn),is=a(e),Me=o(e,"UL",{"data-svelte-h":!0}),p(Me)!=="svelte-dwey60"&&(Me.innerHTML=Vn),os=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-73idjo"&&(Te.innerHTML=En),ps=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-rrllkl"&&(ye.textContent=Bn),rs=a(e),m(Je.$$.fragment,e),ms=a(e),m(ge.$$.fragment,e),cs=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-ojb3z4"&&(be.textContent=Gn),us=a(e),m(we.$$.fragment,e),ds=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-10vc8nx"&&(Ue.textContent=Wn),hs=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-16mf5ei"&&(fe.innerHTML=$n),Ms=a(e),m(je.$$.fragment,e),Ts=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-a4iqo7"&&(ve.textContent=kn),ys=a(e),m(Ce.$$.fragment,e),Js=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1w34bpb"&&(Ie.innerHTML=Xn),gs=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1vctm96"&&(Ne.innerHTML=Qn),bs=a(e),m(Ze.$$.fragment,e),ws=a(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-41nl52"&&(Re.innerHTML=_n),Us=a(e),xe=o(e,"OL",{"data-svelte-h":!0}),p(xe)!=="svelte-1av7wpf"&&(xe.innerHTML=zn),fs=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-r9aypu"&&(Ve.innerHTML=Sn),js=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-7tlbrr"&&(Ee.textContent=Ln),vs=a(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-10vd8g9"&&(Be.textContent=Hn),Cs=a(e),m(Ge.$$.fragment,e),Is=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1a6v242"&&(We.textContent=qn),Ns=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-h7osbf"&&($e.innerHTML=Fn),Zs=a(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-19pgd5i"&&(ke.textContent=An),Rs=a(e),m(Xe.$$.fragment,e),xs=a(e),m(Qe.$$.fragment,e),Vs=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1go7vzm"&&(_e.innerHTML=Pn),Es=a(e),m(ze.$$.fragment,e),Bs=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1wz9kqz"&&(Se.innerHTML=Dn),Gs=a(e),m(Le.$$.fragment,e),Ws=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-12c3zjv"&&(He.innerHTML=Yn),$s=a(e),m(qe.$$.fragment,e),ks=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-16axcqn"&&(Fe.innerHTML=On),Xs=a(e),m(Ae.$$.fragment,e),Qs=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1gmqa4f"&&(Pe.innerHTML=Kn),_s=a(e),De=o(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-ug3mbc"&&(De.innerHTML=el),zs=a(e),m(Ye.$$.fragment,e),Ss=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-qouywp"&&(Oe.innerHTML=tl),Ls=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-r1i072"&&(Ke.innerHTML=sl),Hs=a(e),m(et.$$.fragment,e),qs=a(e),tt=o(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-16axcqn"&&(tt.innerHTML=nl),Fs=a(e),m(st.$$.fragment,e),As=a(e),nt=o(e,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1oae55m"&&(nt.textContent=ll),Ps=a(e),lt=o(e,"UL",{"data-svelte-h":!0}),p(lt)!=="svelte-dbp0vn"&&(lt.innerHTML=al),Ds=a(e),at=o(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1jqg7cl"&&(at.innerHTML=il),Ys=a(e),m(it.$$.fragment,e),Os=a(e),ot=o(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-cgoioi"&&(ot.innerHTML=ol),Ks=a(e),pt=o(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-15n2n4z"&&(pt.textContent=pl),en=a(e),mt=o(e,"P",{}),ml(mt).forEach(s),this.h()},h(){cl(T,"name","hf:doc:metadata"),cl(T,"content",Ul)},m(e,t){Jl(document.head,T),n(e,b,t),n(e,J,t),n(e,rt,t),c(w,e,t),n(e,ut,t),n(e,U,t),n(e,dt,t),n(e,f,t),n(e,ht,t),n(e,j,t),n(e,Mt,t),c(g,e,t),n(e,Tt,t),c(v,e,t),n(e,yt,t),c(C,e,t),n(e,Jt,t),n(e,I,t),n(e,gt,t),c(N,e,t),n(e,bt,t),n(e,Z,t),n(e,wt,t),c(R,e,t),n(e,Ut,t),n(e,x,t),n(e,ft,t),c(V,e,t),n(e,jt,t),n(e,E,t),n(e,vt,t),c(B,e,t),n(e,Ct,t),n(e,G,t),n(e,It,t),c(W,e,t),n(e,Nt,t),n(e,$,t),n(e,Zt,t),c(k,e,t),n(e,Rt,t),n(e,X,t),n(e,xt,t),c(Q,e,t),n(e,Vt,t),n(e,_,t),n(e,Et,t),c(z,e,t),n(e,Bt,t),n(e,S,t),n(e,Gt,t),c(L,e,t),n(e,Wt,t),n(e,H,t),n(e,$t,t),c(q,e,t),n(e,kt,t),n(e,F,t),n(e,Xt,t),n(e,A,t),n(e,Qt,t),c(P,e,t),n(e,_t,t),n(e,D,t),n(e,zt,t),n(e,Y,t),n(e,St,t),n(e,O,t),n(e,Lt,t),c(K,e,t),n(e,Ht,t),n(e,ee,t),n(e,qt,t),c(te,e,t),n(e,Ft,t),n(e,se,t),n(e,At,t),n(e,ne,t),n(e,Pt,t),n(e,le,t),n(e,Dt,t),n(e,ae,t),n(e,Yt,t),n(e,ie,t),n(e,Ot,t),n(e,oe,t),n(e,Kt,t),c(pe,e,t),n(e,es,t),n(e,re,t),n(e,ts,t),c(me,e,t),n(e,ss,t),n(e,ce,t),n(e,ns,t),c(ue,e,t),n(e,ls,t),n(e,de,t),n(e,as,t),n(e,he,t),n(e,is,t),n(e,Me,t),n(e,os,t),n(e,Te,t),n(e,ps,t),n(e,ye,t),n(e,rs,t),c(Je,e,t),n(e,ms,t),c(ge,e,t),n(e,cs,t),n(e,be,t),n(e,us,t),c(we,e,t),n(e,ds,t),n(e,Ue,t),n(e,hs,t),n(e,fe,t),n(e,Ms,t),c(je,e,t),n(e,Ts,t),n(e,ve,t),n(e,ys,t),c(Ce,e,t),n(e,Js,t),n(e,Ie,t),n(e,gs,t),n(e,Ne,t),n(e,bs,t),c(Ze,e,t),n(e,ws,t),n(e,Re,t),n(e,Us,t),n(e,xe,t),n(e,fs,t),n(e,Ve,t),n(e,js,t),n(e,Ee,t),n(e,vs,t),n(e,Be,t),n(e,Cs,t),c(Ge,e,t),n(e,Is,t),n(e,We,t),n(e,Ns,t),n(e,$e,t),n(e,Zs,t),n(e,ke,t),n(e,Rs,t),c(Xe,e,t),n(e,xs,t),c(Qe,e,t),n(e,Vs,t),n(e,_e,t),n(e,Es,t),c(ze,e,t),n(e,Bs,t),n(e,Se,t),n(e,Gs,t),c(Le,e,t),n(e,Ws,t),n(e,He,t),n(e,$s,t),c(qe,e,t),n(e,ks,t),n(e,Fe,t),n(e,Xs,t),c(Ae,e,t),n(e,Qs,t),n(e,Pe,t),n(e,_s,t),n(e,De,t),n(e,zs,t),c(Ye,e,t),n(e,Ss,t),n(e,Oe,t),n(e,Ls,t),n(e,Ke,t),n(e,Hs,t),c(et,e,t),n(e,qs,t),n(e,tt,t),n(e,Fs,t),c(st,e,t),n(e,As,t),n(e,nt,t),n(e,Ps,t),n(e,lt,t),n(e,Ds,t),n(e,at,t),n(e,Ys,t),c(it,e,t),n(e,Os,t),n(e,ot,t),n(e,Ks,t),n(e,pt,t),n(e,en,t),n(e,mt,t),tn=!0},p(e,[t]){const rl={};t&2&&(rl.$$scope={dirty:t,ctx:e}),g.$set(rl)},i(e){tn||(u(w.$$.fragment,e),u(g.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(B.$$.fragment,e),u(W.$$.fragment,e),u(k.$$.fragment,e),u(Q.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),u(ge.$$.fragment,e),u(we.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(Ze.$$.fragment,e),u(Ge.$$.fragment,e),u(Xe.$$.fragment,e),u(Qe.$$.fragment,e),u(ze.$$.fragment,e),u(Le.$$.fragment,e),u(qe.$$.fragment,e),u(Ae.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),tn=!0)},o(e){d(w.$$.fragment,e),d(g.$$.fragment,e),d(v.$$.fragment,e),d(C.$$.fragment,e),d(N.$$.fragment,e),d(R.$$.fragment,e),d(V.$$.fragment,e),d(B.$$.fragment,e),d(W.$$.fragment,e),d(k.$$.fragment,e),d(Q.$$.fragment,e),d(z.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(Je.$$.fragment,e),d(ge.$$.fragment,e),d(we.$$.fragment,e),d(je.$$.fragment,e),d(Ce.$$.fragment,e),d(Ze.$$.fragment,e),d(Ge.$$.fragment,e),d(Xe.$$.fragment,e),d(Qe.$$.fragment,e),d(ze.$$.fragment,e),d(Le.$$.fragment,e),d(qe.$$.fragment,e),d(Ae.$$.fragment,e),d(Ye.$$.fragment,e),d(et.$$.fragment,e),d(st.$$.fragment,e),d(it.$$.fragment,e),tn=!1},d(e){e&&(s(b),s(J),s(rt),s(ut),s(U),s(dt),s(f),s(ht),s(j),s(Mt),s(Tt),s(yt),s(Jt),s(I),s(gt),s(bt),s(Z),s(wt),s(Ut),s(x),s(ft),s(jt),s(E),s(vt),s(Ct),s(G),s(It),s(Nt),s($),s(Zt),s(Rt),s(X),s(xt),s(Vt),s(_),s(Et),s(Bt),s(S),s(Gt),s(Wt),s(H),s($t),s(kt),s(F),s(Xt),s(A),s(Qt),s(_t),s(D),s(zt),s(Y),s(St),s(O),s(Lt),s(Ht),s(ee),s(qt),s(Ft),s(se),s(At),s(ne),s(Pt),s(le),s(Dt),s(ae),s(Yt),s(ie),s(Ot),s(oe),s(Kt),s(es),s(re),s(ts),s(ss),s(ce),s(ns),s(ls),s(de),s(as),s(he),s(is),s(Me),s(os),s(Te),s(ps),s(ye),s(rs),s(ms),s(cs),s(be),s(us),s(ds),s(Ue),s(hs),s(fe),s(Ms),s(Ts),s(ve),s(ys),s(Js),s(Ie),s(gs),s(Ne),s(bs),s(ws),s(Re),s(Us),s(xe),s(fs),s(Ve),s(js),s(Ee),s(vs),s(Be),s(Cs),s(Is),s(We),s(Ns),s($e),s(Zs),s(ke),s(Rs),s(xs),s(Vs),s(_e),s(Es),s(Bs),s(Se),s(Gs),s(Ws),s(He),s($s),s(ks),s(Fe),s(Xs),s(Qs),s(Pe),s(_s),s(De),s(zs),s(Ss),s(Oe),s(Ls),s(Ke),s(Hs),s(qs),s(tt),s(Fs),s(As),s(nt),s(Ps),s(lt),s(Ds),s(at),s(Ys),s(Os),s(ot),s(Ks),s(pt),s(en),s(mt)),s(T),h(w,e),h(g,e),h(v,e),h(C,e),h(N,e),h(R,e),h(V,e),h(B,e),h(W,e),h(k,e),h(Q,e),h(z,e),h(L,e),h(q,e),h(P,e),h(K,e),h(te,e),h(pe,e),h(me,e),h(ue,e),h(Je,e),h(ge,e),h(we,e),h(je,e),h(Ce,e),h(Ze,e),h(Ge,e),h(Xe,e),h(Qe,e),h(ze,e),h(Le,e),h(qe,e),h(Ae,e),h(Ye,e),h(et,e),h(st,e),h(it,e)}}}const Ul='{"title":"Accelerated inference on NVIDIA GPUs","local":"accelerated-inference-on-nvidia-gpus","sections":[{"title":"CUDAExecutionProvider","local":"cudaexecutionprovider","sections":[{"title":"CUDA installation","local":"cuda-installation","sections":[],"depth":3},{"title":"Checking the CUDA installation is successful","local":"checking-the-cuda-installation-is-successful","sections":[],"depth":3},{"title":"Use CUDA execution provider with floating-point models","local":"use-cuda-execution-provider-with-floating-point-models","sections":[],"depth":3},{"title":"Use CUDA execution provider with quantized models","local":"use-cuda-execution-provider-with-quantized-models","sections":[],"depth":3},{"title":"Reduce memory footprint with IOBinding","local":"reduce-memory-footprint-with-iobinding","sections":[],"depth":3},{"title":"Observed time gains","local":"observed-time-gains","sections":[],"depth":3}],"depth":2},{"title":"TensorrtExecutionProvider","local":"tensorrtexecutionprovider","sections":[{"title":"TensorRT installation","local":"tensorrt-installation","sections":[],"depth":3},{"title":"Checking the TensorRT installation is successful","local":"checking-the-tensorrt-installation-is-successful","sections":[],"depth":3},{"title":"TensorRT engine build and warmup","local":"tensorrt-engine-build-and-warmup","sections":[{"title":"Warmup","local":"warmup","sections":[],"depth":4}],"depth":3},{"title":"Use TensorRT execution provider with floating-point models","local":"use-tensorrt-execution-provider-with-floating-point-models","sections":[],"depth":3},{"title":"Use TensorRT execution provider with quantized models","local":"use-tensorrt-execution-provider-with-quantized-models","sections":[],"depth":3},{"title":"TensorRT limitations for quantized models","local":"tensorrt-limitations-for-quantized-models","sections":[],"depth":3},{"title":"Observed time gains","local":"observed-time-gains","sections":[],"depth":3}],"depth":2}],"depth":1}';function fl(ct){return dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends Ml{constructor(T){super(),Tl(this,T,fl,wl,ul,{})}}export{Zl as component};
