import{s as _t,o as Zt,n as Rt}from"../chunks/scheduler.37c15a92.js";import{S as Gt,i as Ct,g as o,s as i,r as d,A as Wt,h as s,f as a,c as n,j as jt,u as c,x as p,k as kt,y as It,a as l,v as m,d as u,t as f,w as M}from"../chunks/index.2bf4358c.js";import{T as Ut}from"../chunks/Tip.363c041f.js";import{Y as Ht}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4e987730.js";import{D as Xt}from"../chunks/DocNotebookDropdown.efc1fb7c.js";import{F as Ft}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as tt,E as Et}from"../chunks/index.49fc26ef.js";function Vt(J){let r,y='💡 Se si vuole caricare automaticamente il modello all’Hub durante l’addestramento, basta passare <code>push_to_hub=True</code> come parametro nei <code>TrainingArguments</code>. Maggiori dettagli verranno forniti nel <a href="/course/chapter4/3">Capitolo 4</a>.';return{c(){r=o("p"),r.innerHTML=y},l(b){r=s(b,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1oyy0rx"&&(r.innerHTML=y)},m(b,$){l(b,r,$)},p:Rt,d(b){b&&a(r)}}}function xt(J){let r,y="✏️ <strong>Prova tu!</strong> Affinare un modello sul dataset GLUE SST-2 utilizzando il processing dei dati già fatto nella sezione 2.";return{c(){r=o("p"),r.innerHTML=y},l(b){r=s(b,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1jn42dw"&&(r.innerHTML=y)},m(b,$){l(b,r,$)},p:Rt,d(b){b&&a(r)}}}function qt(J){let r,y,b,$,h,ce,w,me,z,ue,j,fe,k,at='🤗 Transformers fornisce una classe <code>Trainer</code> (addestratore) per aiutare con l’affinamento di uno qualsiasi dei modelli pre-addestrati nel dataset. Dopo tutto il lavoro di preprocessing nella sezione precedente, rimangono giusto gli ultimi passi per definire il <code>Trainer</code>. Probabilmente la parte più complicata sarà preparare l’ambiente per eseguire <code>Trainer.train()</code>, poiché sarà molto lento su una CPU. Se non avete una GPU a disposizione, potete avere accesso gratuitamente a GPU o TPU su <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',Me,U,lt="Gli esempi di codice qui sotto partono dal presupposto che gli esempi nella sezione precedente siano già stati eseguiti. Ecco un breve riassunto di cosa serve:",be,R,Te,_,ye,Z,it="Il primo passo per definire un <code>Trainer</code> è la definizione di una classe <code>TrainingArguments</code> che contenga tutti gli iperparametri che verranno usati dal <code>Trainer</code> per l’addestramento e la valutazione. L’unico parametro da fornire è la cartella dove verranno salvati il modello addestrato e i vari checkpoint. Per tutto il resto si possono lasciare i parametri di default, che dovrebbero funzionare bene per un affinamento di base.",$e,G,he,v,ve,C,nt='Il secondo passo è definire il modello. Come nel <a href="/course/chapter2">capitolo precedente</a>, utilizzeremo la classe <code>AutoModelForSequenceClassification</code> con due label:',ge,W,Je,I,ot='Diversamente dal <a href="/course/chapter2">Capitolo 2</a>, un avviso di avvertimento verrà visualizzato dopo aver istanziato questo modello pre-addestrato. Ciò avviene perché BERT non è stato pre-addestrato per classificare coppie di frasi, quindi la testa del modello pre-addestrato viene scartata e una nuova testa adeguata per il compito di classificazione di sequenze è stata inserita. Gli avvertimenti indicano che alcuni pesi non verranno usati (quelli corrispondenti alla testa scartata del modello pre-addestrato) e che altri pesi sono stati inizializzati con valori casuali (quelli per la nuova testa). L’avvertimento viene concluso con un’esortazione ad addestrare il modello, che è esattamente ciò che stiamo per fare.',we,H,st="Una volta ottenuto il modello, si può definire un <code>Trainer</code> passandogli tutti gli oggetti costruiti fino ad adesso — il <code>model</code>, i <code>training_args</code>, i dataset di addestramento e validazione, il <code>data_collator</code>, e il <code>tokenizer</code>:",ze,X,je,F,rt="Quando si passa l’argomento <code>tokenizer</code> come appena fatto, il <code>data_collator</code> usato di default dal <code>Trainer</code> sarà del tipo <code>DataCollatorWithPadding</code>, come definito precedentemente, quindi si potrebbe evitare di specificare l’argomento <code>data_collator=data_collator</code> in questa chiamata. Tuttavia era comunque importante mostrare questa parte del processing nella sezione 2!",ke,E,pt="Per affinare il modello sul nostro dataset, bisogna solo chiamare il metodo <code>train()</code> del <code>Trainer</code>:",Ue,V,Re,x,dt="Questo farà partire l’affinamento (che richiederà un paio di minuti su una GPU) e produrrà un report della funzione obiettivo dell’addestramento ogni 500 passi. Tuttavia, non vi farà sapere quanto sia buona (o cattiva) la performance del modello. Ciò è dovuto al fatto che:",_e,q,ct="<li>Non è stato detto al <code>Trainer</code> di valutare il modello durante l’addestramento, settando <code>evaluation_strategy</code> o al valore <code>&quot;steps&quot;</code> (valuta il modello ogni <code>eval_steps</code>) oppure al valore <code>&quot;epoch&quot;</code> (valuta il modello alla fine di ogni epoca).</li> <li>Non è stato fornito al <code>Trainer</code> una funzione <code>compute_metrics()</code> per calcolare le metriche di valutazione (altrimenti la valutazione stamperebbe solo il valore della funzione obiettivo, che non è un valore molto intuitivo).</li>",Ze,Y,Ge,B,mt="Vediamo come si può costruire una funzione <code>compute_metrics()</code> utile e usarla per il prossimo addestramento. La funzione deve prendere come parametro un oggetto <code>EvalPrediction</code> (che è una named tuple avente un campo <code>predictions</code> – predizioni – e un campo <code>label_ids</code> – id delle etichette –) e restituirà un dizionario che associa stringhe a numeri floating point (le stringhe saranno i nomi delle metriche, i numeri i loro valori). Per ottenere delle predizioni, si può usare il comando <code>Trainer.predict()</code>:",Ce,A,We,L,Ie,N,ut="Il risultato del metodo <code>predict()</code> è un’altra named tuple con tre campi: <code>predictions</code>, <code>label_ids</code>, e <code>metrics</code>. Il campo <code>metrics</code> conterrà solo il valore della funzione obiettivo sul dataset, in aggiunta ad alcune metriche legate al tempo (il tempo necessario per calcolare le predizioni, in totale e in media). Una volta completata la funzione <code>compute_metrics()</code> e passata al <code>Trainer</code>, quel campo conterrà anche le metriche restituite da <code>compute_metrics()</code>.",He,Q,ft='Come si può vedere, <code>predictions</code> è un array bi-dimensionale con dimensioni 408 x 2 (poiché 408 è il numero di elementi nel dataset). Questi sono i logit per ogni elemento del dataset passato a <code>predict()</code> (come già visto nel <a href="/course/chapter2">capitolo precedente</a>, tutti i modelli Transformer restituiscono logit). Per trasformarli in predizioni associabili alle etichette, bisogna prendere l’indice col valore massimo sul secondo asse:',Xe,P,Fe,S,Mt="Ora si possono paragonare i <code>preds</code> con le etichette. Per costruire la funzione <code>compute_metric()</code>, verranno utilizzate le metriche dalla libreria 🤗 Dataset. Si possono caricare le metriche associate con il dataset MRPC in maniera semplice, utilizzando la funzione <code>load_metric()</code>. L’oggetto restituito ha un metodo <code>compute()</code> (calcola) che possiamo usare per calcolare le metriche:",Ee,D,Ve,K,xe,O,bt='L’esatto valore dei risultati potrebbe essere diverso nel vostro caso, a casa dell’inizializzazione casuale della testa del modello. In questo caso il nostro modello ha un’accuratezza del 85.78% sul set di validazione e un valore F1 di 89.97. Queste sono le due metriche utilizzate per valutare i risultati sul dataset MRPC per il benchmark GLUE. La tabella nell’<a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">articolo su BERT</a> riportava un F1 di 88.9 per il modello base. Quello era il modello <code>uncased</code> (senza distinzione fra minuscole e maiuscole) mentre noi stiamo usando quello <code>cased</code>, il che spiega il risultato migliore.',qe,ee,Tt="Mettendo tutto insieme si ottiene la funzione <code>compute_metrics()</code>:",Ye,te,Be,ae,yt="Per vederla in azione e fare il report delle metriche alla fine di ogni epoca, ecco come si definisce un nuovo <code>Trainer</code> che includa questa funzione <code>compute_metrics()</code>:",Ae,le,Le,ie,$t="Da notare che bisogna creare un nuovo oggetto <code>TrainingArguments</code> con il valore di <code>evaluation_strategy</code> pari a <code>&quot;epoch&quot;</code> e un nuovo modello — altrimenti si continuerebbe l’addestramento del modello già addestrato. Per lanciare una nuova esecuzione dell’addestramento si usa:",Ne,ne,Qe,oe,ht="Stavolta vi sarà il report della funzione obiettivo di validazione alla fine di ogni epoca, in aggiunta alla funzione obiettivo dell’addestramento. Di nuovo, i valori esatti di accuratezza/F1 ottenuti da voi potrebbero variare leggermente da quelli mostrati qui a causa dell’inizializzazione casuale della testa del modello, ma dovrebbero essere comparabili.",Pe,se,vt="Il <code>Trainer</code> funzionerà direttamente su svariate GPU e TPU e ha molte opzioni, tra cui addestramento in precisione mista (utilizzare <code>fp16 = True</code> negli argomenti). I dettagli delle opzioni verranno esplorati nel Capitolo 10.",Se,re,gt="Qui si conclude l’introduzione all’affinamento usando l’API del <code>Trainer</code>. Esempi per i compiti più comuni in NLP verranno forniti nel Capitolo 7, ma per ora vediamo come ottenere la stessa cosa usando puramente Pytorch.",De,g,Ke,pe,Oe,de,et;return h=new Ft({props:{fw:J[0]}}),w=new tt({props:{title:"Affinare il modello con la Trainer API",local:"affinare-il-modello-con-la-trainer-api",headingTag:"h1"}}),z=new Xt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter3/section3.ipynb"}]}}),j=new Ht({props:{id:"nvBXf7s7vTI"}}),R=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),_=new tt({props:{title:"Addestramento",local:"addestramento",headingTag:"h3"}}),G=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),v=new Ut({props:{$$slots:{default:[Vt]},$$scope:{ctx:J}}}),W=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),X=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),V=new T({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),Y=new tt({props:{title:"Valutazione",local:"valutazione",headingTag:"h3"}}),A=new T({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),L=new T({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),P=new T({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),D=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9tZXRyaWMlMEElMEFtZXRyaWMlMjAlM0QlMjBsb2FkX21ldHJpYyglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFtZXRyaWMuY29tcHV0ZShwcmVkaWN0aW9ucyUzRHByZWRzJTJDJTIwcmVmZXJlbmNlcyUzRHByZWRpY3Rpb25zLmxhYmVsX2lkcyk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_metric

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),K=new T({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),te=new T({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwbG9hZF9tZXRyaWMoJTIyZ2x1ZSUyMiUyQyUyMCUyMm1ycGMlMjIpJTBBJTIwJTIwJTIwJTIwbG9naXRzJTJDJTIwbGFiZWxzJTIwJTNEJTIwZXZhbF9wcmVkcyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtZXRyaWMuY29tcHV0ZShwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGxhYmVscyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),le=new T({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),ne=new T({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'trainer.trai<span class="hljs-meta">n</span>()',wrap:!1}}),g=new Ut({props:{$$slots:{default:[xt]},$$scope:{ctx:J}}}),pe=new Et({props:{source:"https://github.com/huggingface/course/blob/main/chapters/it/chapter3/3.mdx"}}),{c(){r=o("meta"),y=i(),b=o("p"),$=i(),d(h.$$.fragment),ce=i(),d(w.$$.fragment),me=i(),d(z.$$.fragment),ue=i(),d(j.$$.fragment),fe=i(),k=o("p"),k.innerHTML=at,Me=i(),U=o("p"),U.textContent=lt,be=i(),d(R.$$.fragment),Te=i(),d(_.$$.fragment),ye=i(),Z=o("p"),Z.innerHTML=it,$e=i(),d(G.$$.fragment),he=i(),d(v.$$.fragment),ve=i(),C=o("p"),C.innerHTML=nt,ge=i(),d(W.$$.fragment),Je=i(),I=o("p"),I.innerHTML=ot,we=i(),H=o("p"),H.innerHTML=st,ze=i(),d(X.$$.fragment),je=i(),F=o("p"),F.innerHTML=rt,ke=i(),E=o("p"),E.innerHTML=pt,Ue=i(),d(V.$$.fragment),Re=i(),x=o("p"),x.textContent=dt,_e=i(),q=o("ol"),q.innerHTML=ct,Ze=i(),d(Y.$$.fragment),Ge=i(),B=o("p"),B.innerHTML=mt,Ce=i(),d(A.$$.fragment),We=i(),d(L.$$.fragment),Ie=i(),N=o("p"),N.innerHTML=ut,He=i(),Q=o("p"),Q.innerHTML=ft,Xe=i(),d(P.$$.fragment),Fe=i(),S=o("p"),S.innerHTML=Mt,Ee=i(),d(D.$$.fragment),Ve=i(),d(K.$$.fragment),xe=i(),O=o("p"),O.innerHTML=bt,qe=i(),ee=o("p"),ee.innerHTML=Tt,Ye=i(),d(te.$$.fragment),Be=i(),ae=o("p"),ae.innerHTML=yt,Ae=i(),d(le.$$.fragment),Le=i(),ie=o("p"),ie.innerHTML=$t,Ne=i(),d(ne.$$.fragment),Qe=i(),oe=o("p"),oe.textContent=ht,Pe=i(),se=o("p"),se.innerHTML=vt,Se=i(),re=o("p"),re.innerHTML=gt,De=i(),d(g.$$.fragment),Ke=i(),d(pe.$$.fragment),Oe=i(),de=o("p"),this.h()},l(e){const t=Wt("svelte-u9bgzb",document.head);r=s(t,"META",{name:!0,content:!0}),t.forEach(a),y=n(e),b=s(e,"P",{}),jt(b).forEach(a),$=n(e),c(h.$$.fragment,e),ce=n(e),c(w.$$.fragment,e),me=n(e),c(z.$$.fragment,e),ue=n(e),c(j.$$.fragment,e),fe=n(e),k=s(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-w466ks"&&(k.innerHTML=at),Me=n(e),U=s(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-11al6ht"&&(U.textContent=lt),be=n(e),c(R.$$.fragment,e),Te=n(e),c(_.$$.fragment,e),ye=n(e),Z=s(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-3oidne"&&(Z.innerHTML=it),$e=n(e),c(G.$$.fragment,e),he=n(e),c(v.$$.fragment,e),ve=n(e),C=s(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-nsi4y1"&&(C.innerHTML=nt),ge=n(e),c(W.$$.fragment,e),Je=n(e),I=s(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1580ewa"&&(I.innerHTML=ot),we=n(e),H=s(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-zpy7k9"&&(H.innerHTML=st),ze=n(e),c(X.$$.fragment,e),je=n(e),F=s(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-gnh7rc"&&(F.innerHTML=rt),ke=n(e),E=s(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-xznjnr"&&(E.innerHTML=pt),Ue=n(e),c(V.$$.fragment,e),Re=n(e),x=s(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-rtrulk"&&(x.textContent=dt),_e=n(e),q=s(e,"OL",{"data-svelte-h":!0}),p(q)!=="svelte-pjo77w"&&(q.innerHTML=ct),Ze=n(e),c(Y.$$.fragment,e),Ge=n(e),B=s(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-pup2lr"&&(B.innerHTML=mt),Ce=n(e),c(A.$$.fragment,e),We=n(e),c(L.$$.fragment,e),Ie=n(e),N=s(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-mg62sf"&&(N.innerHTML=ut),He=n(e),Q=s(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-bv1sad"&&(Q.innerHTML=ft),Xe=n(e),c(P.$$.fragment,e),Fe=n(e),S=s(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-19co3eg"&&(S.innerHTML=Mt),Ee=n(e),c(D.$$.fragment,e),Ve=n(e),c(K.$$.fragment,e),xe=n(e),O=s(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-xgb3dx"&&(O.innerHTML=bt),qe=n(e),ee=s(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-10eff0k"&&(ee.innerHTML=Tt),Ye=n(e),c(te.$$.fragment,e),Be=n(e),ae=s(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-az7fqa"&&(ae.innerHTML=yt),Ae=n(e),c(le.$$.fragment,e),Le=n(e),ie=s(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-19ejq6q"&&(ie.innerHTML=$t),Ne=n(e),c(ne.$$.fragment,e),Qe=n(e),oe=s(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-18vmmqt"&&(oe.textContent=ht),Pe=n(e),se=s(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1lvweaa"&&(se.innerHTML=vt),Se=n(e),re=s(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-19uw8j0"&&(re.innerHTML=gt),De=n(e),c(g.$$.fragment,e),Ke=n(e),c(pe.$$.fragment,e),Oe=n(e),de=s(e,"P",{}),jt(de).forEach(a),this.h()},h(){kt(r,"name","hf:doc:metadata"),kt(r,"content",Yt)},m(e,t){It(document.head,r),l(e,y,t),l(e,b,t),l(e,$,t),m(h,e,t),l(e,ce,t),m(w,e,t),l(e,me,t),m(z,e,t),l(e,ue,t),m(j,e,t),l(e,fe,t),l(e,k,t),l(e,Me,t),l(e,U,t),l(e,be,t),m(R,e,t),l(e,Te,t),m(_,e,t),l(e,ye,t),l(e,Z,t),l(e,$e,t),m(G,e,t),l(e,he,t),m(v,e,t),l(e,ve,t),l(e,C,t),l(e,ge,t),m(W,e,t),l(e,Je,t),l(e,I,t),l(e,we,t),l(e,H,t),l(e,ze,t),m(X,e,t),l(e,je,t),l(e,F,t),l(e,ke,t),l(e,E,t),l(e,Ue,t),m(V,e,t),l(e,Re,t),l(e,x,t),l(e,_e,t),l(e,q,t),l(e,Ze,t),m(Y,e,t),l(e,Ge,t),l(e,B,t),l(e,Ce,t),m(A,e,t),l(e,We,t),m(L,e,t),l(e,Ie,t),l(e,N,t),l(e,He,t),l(e,Q,t),l(e,Xe,t),m(P,e,t),l(e,Fe,t),l(e,S,t),l(e,Ee,t),m(D,e,t),l(e,Ve,t),m(K,e,t),l(e,xe,t),l(e,O,t),l(e,qe,t),l(e,ee,t),l(e,Ye,t),m(te,e,t),l(e,Be,t),l(e,ae,t),l(e,Ae,t),m(le,e,t),l(e,Le,t),l(e,ie,t),l(e,Ne,t),m(ne,e,t),l(e,Qe,t),l(e,oe,t),l(e,Pe,t),l(e,se,t),l(e,Se,t),l(e,re,t),l(e,De,t),m(g,e,t),l(e,Ke,t),m(pe,e,t),l(e,Oe,t),l(e,de,t),et=!0},p(e,[t]){const Jt={};t&1&&(Jt.fw=e[0]),h.$set(Jt);const wt={};t&2&&(wt.$$scope={dirty:t,ctx:e}),v.$set(wt);const zt={};t&2&&(zt.$$scope={dirty:t,ctx:e}),g.$set(zt)},i(e){et||(u(h.$$.fragment,e),u(w.$$.fragment,e),u(z.$$.fragment,e),u(j.$$.fragment,e),u(R.$$.fragment,e),u(_.$$.fragment,e),u(G.$$.fragment,e),u(v.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(A.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(g.$$.fragment,e),u(pe.$$.fragment,e),et=!0)},o(e){f(h.$$.fragment,e),f(w.$$.fragment,e),f(z.$$.fragment,e),f(j.$$.fragment,e),f(R.$$.fragment,e),f(_.$$.fragment,e),f(G.$$.fragment,e),f(v.$$.fragment,e),f(W.$$.fragment,e),f(X.$$.fragment,e),f(V.$$.fragment,e),f(Y.$$.fragment,e),f(A.$$.fragment,e),f(L.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(ne.$$.fragment,e),f(g.$$.fragment,e),f(pe.$$.fragment,e),et=!1},d(e){e&&(a(y),a(b),a($),a(ce),a(me),a(ue),a(fe),a(k),a(Me),a(U),a(be),a(Te),a(ye),a(Z),a($e),a(he),a(ve),a(C),a(ge),a(Je),a(I),a(we),a(H),a(ze),a(je),a(F),a(ke),a(E),a(Ue),a(Re),a(x),a(_e),a(q),a(Ze),a(Ge),a(B),a(Ce),a(We),a(Ie),a(N),a(He),a(Q),a(Xe),a(Fe),a(S),a(Ee),a(Ve),a(xe),a(O),a(qe),a(ee),a(Ye),a(Be),a(ae),a(Ae),a(Le),a(ie),a(Ne),a(Qe),a(oe),a(Pe),a(se),a(Se),a(re),a(De),a(Ke),a(Oe),a(de)),a(r),M(h,e),M(w,e),M(z,e),M(j,e),M(R,e),M(_,e),M(G,e),M(v,e),M(W,e),M(X,e),M(V,e),M(Y,e),M(A,e),M(L,e),M(P,e),M(D,e),M(K,e),M(te,e),M(le,e),M(ne,e),M(g,e),M(pe,e)}}}const Yt='{"title":"Affinare il modello con la Trainer API","local":"affinare-il-modello-con-la-trainer-api","sections":[{"title":"Addestramento","local":"addestramento","sections":[],"depth":3},{"title":"Valutazione","local":"valutazione","sections":[],"depth":3}],"depth":1}';function Bt(J,r,y){let b="pt";return Zt(()=>{const $=new URLSearchParams(window.location.search);y(0,b=$.get("fw")||"pt")}),[b]}class Ot extends Gt{constructor(r){super(),Ct(this,r,Bt,qt,_t,{})}}export{Ot as component};
