import{s as DT,o as XT,n as zT}from"../chunks/scheduler.f6319a2a.js";import{S as ST,i as HT,g as t,s as M,r as s,m as fT,A as ET,h as a,f as T,c as e,j as Wl,u as n,x as i,n as vT,k as YT,y as N,a as J,v as y,d as w,t as o,w as C}from"../chunks/index.85aa684c.js";import{T as xT}from"../chunks/Tip.3d397a88.js";import{C as g}from"../chunks/CodeBlock.3400fc53.js";import{D as _T}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as c,E as $T}from"../chunks/getInferenceSnippets.743412b2.js";function qT(Al){let d,u='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){d=t("p"),d.innerHTML=u},l(I){d=a(I,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1p1d9vw"&&(d.innerHTML=u)},m(I,Bl){J(I,d,Bl)},p:zT,d(I){I&&T(d)}}}function LT(Al){let d,u,I,Bl,k,fl,m,vl,b,PU=`There’s a world of difference between building an agent that works and one that doesn’t.
How can we build agents that fall into the former category?
In this guide, we’re going to talk about best practices for building agents.`,Yl,r,Dl,V,Xl,F,KU="Giving an LLM some agency in your workflow introduces some risk of errors.",zl,j,lT="Well-programmed agentic systems have good error logging and retry mechanisms anyway, so the LLM engine has a chance to self-correct their mistake. But to reduce the risk of LLM error to the maximum, you should simplify your workflow!",Sl,R,UT=`Let’s revisit the example from the <a href="../conceptual_guides/intro_agents">intro to agents</a>: a bot that answers user queries for a surf trip company.
Instead of letting the agent do 2 different calls for “travel distance API” and “weather API” each time they are asked about a new surf spot, you could just make one unified tool “return_spot_information”, a function that calls both APIs at once and returns their concatenated outputs to the user.`,Hl,B,TT="This will reduce costs, latency, and error risk!",El,O,JT="The main guideline is: Reduce the number of LLM calls as much as you can.",xl,G,MT="This leads to a few takeaways:",_l,Q,eT="<li>Whenever possible, group 2 tools in one, like in our example of the two APIs.</li> <li>Whenever possible, logic should be based on deterministic functions rather than agentic decisions.</li>",$l,Z,ql,W,tT="Remember that your LLM engine is like an <em>intelligent</em> robot, trapped into a room with the only communication with the outside world being notes passed under a door.",Ll,A,aT="It won’t know of anything that happened if you don’t explicitly put that into its prompt.",Pl,f,iT=`So first start with making your task very clear!
Since an agent is powered by an LLM, minor variations in your task formulation might yield completely different results.`,Kl,v,sT="Then, improve the information flow towards your agent in tool use.",lU,Y,nT="Particular guidelines to follow:",UU,D,yT="<li>Each tool should log (by simply using <code>print</code> statements inside the tool’s <code>forward</code> method) everything that could be useful for the LLM engine.<ul><li>In particular, logging detail on tool execution errors would help a lot!</li></ul></li>",TU,X,wT="For instance, here’s a tool that retrieves weather data based on location and date-time:",JU,z,oT="First, here’s a poor version:",MU,S,eU,H,CT="Why is it bad?",tU,E,dT="<li>there’s no precision of the format that should be used for <code>date_time</code></li> <li>there’s no detail on how location should be specified.</li> <li>there’s no logging mechanism trying to make explicit failure cases like location not being in a proper format, or date_time not being properly formatted.</li> <li>the output format is hard to understand</li>",aU,x,IT="If the tool call fails, the error trace logged in memory can help the LLM reverse engineer the tool to fix the errors. But why leave it with so much heavy lifting to do?",iU,_,gT="A better way to build this tool would have been the following:",sU,$,nU,q,pT="In general, to ease the load on your LLM, the good question to ask yourself is: “How easy would it be for me, if I was dumb and using this tool for the first time ever, to program with this tool and correct my own errors?“.",yU,L,wU,P,hT="To pass some additional objects to your agent beyond the simple string describing the task, you can use the <code>additional_args</code> argument to pass any type of object:",oU,K,CU,ll,cT="For instance, you can use this <code>additional_args</code> argument to pass images or strings that you want your agent to leverage.",dU,Ul,IU,Tl,gU,Jl,rT=`In an agentic workflows, some of the errors are actual errors, some other are the fault of your LLM engine not reasoning properly.
For instance, consider this trace for an <code>CodeAgent</code> that I asked to create a car picture:`,pU,Ml,hU,el,NT=`The user sees, instead of an image being returned, a path being returned to them.
It could look like a bug from the system, but actually the agentic system didn’t cause the error: it’s just that the LLM brain did the mistake of not saving the image output into a variable.
Thus it cannot access the image again except by leveraging the path that was logged while saving the image, so it returns the path instead of an image.`,cU,tl,uT="The first step to debugging your agent is thus “Use a more powerful LLM”. Alternatives like <code>Qwen2/5-72B-Instruct</code> wouldn’t have made that mistake.",rU,al,NU,il,kT="You can also use less powerful models, provided you guide them more effectively.",uU,sl,mT="Put yourself in the shoes of your model: if you were the model solving the task, would you struggle with the information available to you (from the system prompt + task formulation + tool description) ?",kU,nl,bT="Would you need detailed instructions?",mU,yl,VT="<li>If the instruction is to always be given to the agent (as we generally understand a system prompt to work): you can pass it as a string under argument <code>instructions</code> upon agent initialization.</li> <li>If it’s about a specific task to solve: add all these details to the task. The task could be very long, like dozens of pages.</li> <li>If it’s about how to use specific tools: include it in the <code>description</code> attribute of these tools.</li>",bU,wl,VU,ol,FT="If above clarifications are not sufficient, you can change the agent’s prompt templates.",FU,Cl,jT='Let’s see how it works. For example, let us check the default prompt templates for the <a href="/docs/smolagents/v1.21.0/en/reference/agents#smolagents.CodeAgent">CodeAgent</a> (below version is shortened by skipping zero-shot examples).',jU,dl,RU,Il,RT="Here is what you get:",BU,gl,OU,pl,BT="As you can see, there are placeholders like <code>&quot;{{ tool.description }}&quot;</code>: these will be used upon agent initialization to insert certain automatically generated descriptions of tools or managed agents.",GU,hl,OT="So while you can overwrite this system prompt template by passing your custom prompt as an argument to the <code>system_prompt</code> parameter, your new system prompt can contain the following placeholders:",QU,p,Ol,EU,cl,xU,Gl,_U,rl,$U,Ql,GT="For <code>CodeAgent</code> only, to insert the list of authorized imports: <code>&quot;{{authorized_imports}}&quot;</code>",ZU,Nl,QT="Then you can change the system prompt as follows:",WU,ul,AU,kl,ZT='This also works with the <a href="/docs/smolagents/v1.21.0/en/reference/agents#smolagents.ToolCallingAgent">ToolCallingAgent</a>.',fU,ml,WT="But generally it’s just simpler to pass argument <code>instructions</code> upon agent initalization, like:",vU,bl,YU,Vl,DU,Fl,AT="We provide a model for a supplementary planning step, that an agent can run regularly in-between normal action steps. In this step, there is no tool call, the LLM is simply asked to update a list of facts it knows and to reflect on what steps it should take next based on those facts.",XU,jl,zU,Rl,SU,Zl,HU;return k=new c({props:{title:"Building good agents",local:"building-good-agents",headingTag:"h1"}}),m=new _T({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/building_good_agents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/building_good_agents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/building_good_agents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/building_good_agents.ipynb"}]}}),r=new xT({props:{warning:!1,$$slots:{default:[qT]},$$scope:{ctx:Al}}}),V=new c({props:{title:"The best agentic systems are the simplest: simplify the workflow as much as you can",local:"the-best-agentic-systems-are-the-simplest-simplify-the-workflow-as-much-as-you-can",headingTag:"h3"}}),Z=new c({props:{title:"Improve the information flow to the LLM engine",local:"improve-the-information-flow-to-the-llm-engine",headingTag:"h3"}}),S=new g({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMHRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoY29vcmRpbmF0ZXMlMkMlMjBkYXRlX3RpbWUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRHVtbXklMjBmdW5jdGlvbiUyQyUyMHJldHVybnMlMjBhJTIwbGlzdCUyMG9mJTIwJTVCdGVtcGVyYXR1cmUlMjBpbiUyMCVDMiVCMEMlMkMlMjByaXNrJTIwb2YlMjByYWluJTIwb24lMjBhJTIwc2NhbGUlMjAwLTElMkMlMjB3YXZlJTIwaGVpZ2h0JTIwaW4lMjBtJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCMjguMCUyQyUyMDAuMzUlMkMlMjAwLjg1JTVEJTBBJTBBZGVmJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBSZXR1cm5zJTIwZHVtbXklMjBjb29yZGluYXRlcyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QjMuMyUyQyUyMC00Mi4wJTVEJTBBJTBBJTQwdG9vbCUwQWRlZiUyMGdldF93ZWF0aGVyX2FwaShsb2NhdGlvbiUzQSUyMHN0ciUyQyUyMGRhdGVfdGltZSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUyMHRoZSUyMHdlYXRoZXIlMjByZXBvcnQuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvY2F0aW9uJTNBJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwcGxhY2UlMjB0aGF0JTIweW91JTIwd2FudCUyMHRoZSUyMHdlYXRoZXIlMjBmb3IuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0ZV90aW1lJTNBJTIwdGhlJTIwZGF0ZSUyMGFuZCUyMHRpbWUlMjBmb3IlMjB3aGljaCUyMHlvdSUyMHdhbnQlMjB0aGUlMjByZXBvcnQuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwbG9uJTJDJTIwbGF0JTIwJTNEJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklMEElMjAlMjAlMjAlMjBkYXRlX3RpbWUlMjAlM0QlMjBkYXRldGltZS5zdHJwdGltZShkYXRlX3RpbWUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGdldF93ZWF0aGVyX3JlcG9ydF9hdF9jb29yZGluYXRlcygobG9uJTJDJTIwbGF0KSUyQyUyMGRhdGVfdGltZSkp",highlighted:`<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_report_at_coordinates</span>(<span class="hljs-params">coordinates, date_time</span>):
    <span class="hljs-comment"># Dummy function, returns a list of [temperature in °C, risk of rain on a scale 0-1, wave height in m]</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">28.0</span>, <span class="hljs-number">0.35</span>, <span class="hljs-number">0.85</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">convert_location_to_coordinates</span>(<span class="hljs-params">location</span>):
    <span class="hljs-comment"># Returns dummy coordinates</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">3.3</span>, -<span class="hljs-number">42.0</span>]

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for.
        date_time: the date and time for which you want the report.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(get_weather_report_at_coordinates((lon, lat), date_time))`,wrap:!1}}),$=new g({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for. Should be a place name, followed by possibly a city name, then a country, like &quot;Anchor Point, Taghazout, Morocco&quot;.
        date_time: the date and time for which you want the report, formatted as &#x27;%m/%d/%y %H:%M:%S&#x27;.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    <span class="hljs-keyword">try</span>:
        date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Conversion of \`date_time\` to datetime format failed, make sure to provide a string in format &#x27;%m/%d/%y %H:%M:%S&#x27;. Full trace:&quot;</span> + <span class="hljs-built_in">str</span>(e))
    temperature_celsius, risk_of_rain, wave_height = get_weather_report_at_coordinates((lon, lat), date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather report for <span class="hljs-subst">{location}</span>, <span class="hljs-subst">{date_time}</span>: Temperature will be <span class="hljs-subst">{temperature_celsius}</span>°C, risk of rain is <span class="hljs-subst">{risk_of_rain*<span class="hljs-number">100</span>:<span class="hljs-number">.0</span>f}</span>%, wave height is <span class="hljs-subst">{wave_height}</span>m.&quot;</span>`,wrap:!1}}),L=new c({props:{title:"Give more arguments to the agent",local:"give-more-arguments-to-the-agent",headingTag:"h3"}}),K=new g({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0Rtb2RlbF9pZCklMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMldoeSUyMGRvZXMlMjBNaWtlJTIwbm90JTIwa25vdyUyMG1hbnklMjBwZW9wbGUlMjBpbiUyME5ldyUyMFlvcmslM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IlMjJtcDNfc291bmRfZmlsZV91cmwlMjIlM0EnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmVjb3JkaW5nLm1wMyclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Why does Mike not know many people in New York?&quot;</span>,
    additional_args={<span class="hljs-string">&quot;mp3_sound_file_url&quot;</span>:<span class="hljs-string">&#x27;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/recording.mp3&#x27;</span>}
)`,wrap:!1}}),Ul=new c({props:{title:"How to debug your agent",local:"how-to-debug-your-agent",headingTag:"h2"}}),Tl=new c({props:{title:"1. Use a stronger LLM",local:"1-use-a-stronger-llm",headingTag:"h3"}}),Ml=new g({props:{code:"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",highlighted:`==================================================================================================== <span class="hljs-keyword">New</span> <span class="hljs-keyword">task</span> ====================================================================================================
Make me a cool car picture
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
image_generator(prompt=<span class="hljs-string">&quot;A cool, futuristic sports car with LED headlights, aerodynamic design, and vibrant color, high-res, photorealistic&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Step</span> <span class="hljs-number">1</span>:

- Time taken: <span class="hljs-number">16.35</span> seconds
- Input tokens: <span class="hljs-number">1</span>,<span class="hljs-number">383</span>
- Output tokens: <span class="hljs-number">77</span>
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
final_answer(<span class="hljs-string">&quot;/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-keyword">Print</span> outputs:

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Final</span> answer:
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png`,wrap:!1}}),al=new c({props:{title:"2. Provide more information or specific instructions",local:"2-provide-more-information-or-specific-instructions",headingTag:"h3"}}),wl=new c({props:{title:"3. Change the prompt templates (generally not advised)",local:"3-change-the-prompt-templates-generally-not-advised",headingTag:"h3"}}),dl=new g({props:{code:"cHJpbnQoYWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQp",highlighted:'<span class="hljs-built_in">print</span>(agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>])',wrap:!1}}),gl=new g({props:{code:"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",highlighted:`You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.
To do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.
To solve the task, you must plan forward to proceed in a series of steps, in a cycle of &#x27;Thought:&#x27;, &#x27;Code:&#x27;, and &#x27;Observation:&#x27; sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.
Then in the &#x27;Code:&#x27; sequence, you should write the code in simple Python. The code sequence must end with &#x27;&lt;end_code&gt;&#x27; sequence.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then appear in the &#x27;Observation:&#x27; field, which will be available as input for the next step.
In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
Task: &quot;Generate an image of the oldest person in this document.&quot;

Thought: I will proceed step by step and use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.
&lt;code&gt;
answer = document_qa(document=document, question=&quot;Who is the oldest person mentioned?&quot;)
print(answer)
&lt;/code&gt;
Observation: &quot;The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.&quot;

Thought: I will now generate an image showcasing the oldest person.
&lt;code&gt;
image = image_generator(&quot;A portrait of John Doe, a 55-year-old man living in Canada.&quot;)
final_answer(image)
&lt;/code&gt;

---
Task: &quot;What is the result of the following operation: 5 + 3 + 1294.678?&quot;

Thought: I will use python code to compute the result of the operation and then return the final answer using the \`final_answer\` tool
&lt;code&gt;
result = 5 + 3 + 1294.678
final_answer(result)
&lt;/code&gt;

---
Task:
&quot;Answer the question in the variable \`question\` about the image stored in the variable \`image\`. The question is in French.
You have been provided with these additional arguments, that you can access using the keys as variables in your python code:
{&#x27;question&#x27;: &#x27;Quel est l&#x27;animal sur l&#x27;image?&#x27;, &#x27;image&#x27;: &#x27;path/to/image.jpg&#x27;}&quot;

Thought: I will use the following tools: \`translator\` to translate the question into English and then \`image_qa\` to answer the question on the input image.
&lt;code&gt;
translated_question = translator(question=question, src_lang=&quot;French&quot;, tgt_lang=&quot;English&quot;)
print(f&quot;The translated question is {translated_question}.&quot;)
answer = image_qa(image=image, question=translated_question)
final_answer(f&quot;The answer is {answer}&quot;)
&lt;/code&gt;

---
Task:
In a 1979 interview, Stanislaus Ulam discusses with Martin Sherwin about other great physicists of his time, including Oppenheimer.
What does he say was the consequence of Einstein learning too much math on his creativity, in one word?

Thought: I need to find and read the 1979 interview of Stanislaus Ulam with Martin Sherwin.
Code:
\`\`\`py
pages = search(query=&quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;)
print(pages)
\`\`\`&lt;end_code&gt;
Observation:
No result found for query &quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;.

Thought: The query was maybe too restrictive and did not find any results. Let&#x27;s try again with a broader query.
Code:
\`\`\`py
pages = search(query=&quot;1979 interview Stanislaus Ulam&quot;)
print(pages)
\`\`\`&lt;end_code&gt;
Observation:
Found 6 pages:
[Stanislaus Ulam 1979 interview](https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/)

[Ulam discusses Manhattan Project](https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/)

(truncated)

Thought: I will read the first 2 pages to know more.
Code:
\`\`\`py
for url in [&quot;https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/&quot;, &quot;https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/&quot;]:
    whole_page = visit_webpage(url)
    print(whole_page)
    print(&quot;\\n&quot; + &quot;=&quot;*80 + &quot;\\n&quot;)  # Print separator between pages
\`\`\`&lt;end_code&gt;
Observation:
Manhattan Project Locations:
Los Alamos, NM
Stanislaus Ulam was a Polish-American mathematician. He worked on the Manhattan Project at Los Alamos and later helped design the hydrogen bomb. In this interview, he discusses his work at
(truncated)

Thought: I now have the final answer: from the webpages visited, Stanislaus Ulam says of Einstein: &quot;He learned too much mathematics and sort of diminished, it seems to me personally, it seems to me his purely physics creativity.&quot; Let&#x27;s answer in one word.
Code:
\`\`\`py
final_answer(&quot;diminished&quot;)
\`\`\`&lt;end_code&gt;

---
Task: &quot;Which city has the highest population: Guangzhou or Shanghai?&quot;

Thought: I need to get the populations for both cities and compare them: I will use the tool \`search\` to get the population of both cities.
Code:
\`\`\`py
for city in [&quot;Guangzhou&quot;, &quot;Shanghai&quot;]:
    print(f&quot;Population {city}:&quot;, search(f&quot;{city} population&quot;)
\`\`\`&lt;end_code&gt;
Observation:
Population Guangzhou: [&#x27;Guangzhou has a population of 15 million inhabitants as of 2021.&#x27;]
Population Shanghai: &#x27;26 million (2019)&#x27;

Thought: Now I know that Shanghai has the highest population.
Code:
\`\`\`py
final_answer(&quot;Shanghai&quot;)
\`\`\`&lt;end_code&gt;

---
Task: &quot;What is the current age of the pope, raised to the power 0.36?&quot;

Thought: I will use the tool \`wiki\` to get the age of the pope, and confirm that with a web search.
Code:
\`\`\`py
pope_age_wiki = wiki(query=&quot;current pope age&quot;)
print(&quot;Pope age as per wikipedia:&quot;, pope_age_wiki)
pope_age_search = web_search(query=&quot;current pope age&quot;)
print(&quot;Pope age as per google search:&quot;, pope_age_search)
\`\`\`&lt;end_code&gt;
Observation:
Pope age: &quot;The pope Francis is currently 88 years old.&quot;

Thought: I know that the pope is 88 years old. Let&#x27;s compute the result using python code.
Code:
\`\`\`py
pope_current_age = 88 ** 0.36
final_answer(pope_current_age)
\`\`\`&lt;end_code&gt;

Above example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you only have access to these tools:
{%- for tool in tools.values() %}
- {{ tool.to_tool_calling_prompt() }}
{%- endfor %}

{%- if managed_agents and managed_agents.values() | list %}
You can also give tasks to team members.
Calling a team member works similarly to calling a tool: provide the task description as the &#x27;task&#x27; argument. Since this team member is a real human, be as detailed and verbose as necessary in your task description.
You can also include any relevant variables or context using the &#x27;additional_args&#x27; argument.
Here is a list of the team members that you can call:
{%- for agent in managed_agents.values() %}
- {{ agent.name }}: {{ agent.description }}
{%- endfor %}
{%- else %}
{%- endif %}

Here are the rules you should always follow to solve your task:
1. Always provide a &#x27;Thought:&#x27; sequence, and a &#x27;Code:\\n\`\`\`py&#x27; sequence ending with &#x27;\`\`\`&lt;end_code&gt;&#x27; sequence, else you will fail.
2. Use only variables that you have defined!
3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in &#x27;answer = wiki({&#x27;query&#x27;: &quot;What is the place where James Bond lives?&quot;})&#x27;, but use the arguments directly as in &#x27;answer = wiki(query=&quot;What is the place where James Bond lives?&quot;)&#x27;.
4. Take care to not chain too many sequential tool calls in the same code block, especially when the output format is unpredictable. For instance, a call to search has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.
5. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.
6. Don&#x27;t name any new variable with the same name as a tool: for instance don&#x27;t name a variable &#x27;final_answer&#x27;.
7. Never create any notional variables in our code, as having these in your logs will derail you from the true variables.
8. You can use imports in your code, but only from the following list of modules: {{authorized_imports}}
9. The state persists between code executions: so if in one step you&#x27;ve created variables or imported modules, these will all persist.
10. Don&#x27;t give up! You&#x27;re in charge of solving the task, not providing directions to solve it.

Now Begin! If you solve the task correctly, you will receive a reward of $1,000,000.`,wrap:!1}}),cl=new g({props:{code:"JTdCJTI1LSUyMGZvciUyMHRvb2wlMjBpbiUyMHRvb2xzLnZhbHVlcygpJTIwJTI1JTdEJTBBLSUyMCU3QiU3QiUyMHRvb2wudG9fdG9vbF9jYWxsaW5nX3Byb21wdCgpJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> tool <span class="hljs-keyword">in</span> tools.values() %}</span><span class="language-xml">
- </span><span class="hljs-template-variable">{{ tool.to_tool_calling_prompt() }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),rl=new g({props:{code:"JTdCJTI1LSUyMGlmJTIwbWFuYWdlZF9hZ2VudHMlMjBhbmQlMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCU3QyUyMGxpc3QlMjAlMjUlN0QlMEFZb3UlMjBjYW4lMjBhbHNvJTIwZ2l2ZSUyMHRhc2tzJTIwdG8lMjB0ZWFtJTIwbWVtYmVycy4lMEFDYWxsaW5nJTIwYSUyMHRlYW0lMjBtZW1iZXIlMjB3b3JrcyUyMHNpbWlsYXJseSUyMHRvJTIwY2FsbGluZyUyMGElMjB0b29sJTNBJTIwcHJvdmlkZSUyMHRoZSUyMHRhc2slMjBkZXNjcmlwdGlvbiUyMGFzJTIwdGhlJTIwJ3Rhc2snJTIwYXJndW1lbnQuJTIwU2luY2UlMjB0aGlzJTIwdGVhbSUyMG1lbWJlciUyMGlzJTIwYSUyMHJlYWwlMjBodW1hbiUyQyUyMGJlJTIwYXMlMjBkZXRhaWxlZCUyMGFuZCUyMHZlcmJvc2UlMjBhcyUyMG5lY2Vzc2FyeSUyMGluJTIweW91ciUyMHRhc2slMjBkZXNjcmlwdGlvbi4lMEFZb3UlMjBjYW4lMjBhbHNvJTIwaW5jbHVkZSUyMGFueSUyMHJlbGV2YW50JTIwdmFyaWFibGVzJTIwb3IlMjBjb250ZXh0JTIwdXNpbmclMjB0aGUlMjAnYWRkaXRpb25hbF9hcmdzJyUyMGFyZ3VtZW50LiUwQUhlcmUlMjBpcyUyMGElMjBsaXN0JTIwb2YlMjB0aGUlMjB0ZWFtJTIwbWVtYmVycyUyMHRoYXQlMjB5b3UlMjBjYW4lMjBjYWxsJTNBJTBBJTdCJTI1LSUyMGZvciUyMGFnZW50JTIwaW4lMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCUyNSU3RCUwQS0lMjAlN0IlN0IlMjBhZ2VudC5uYW1lJTIwJTdEJTdEJTNBJTIwJTdCJTdCJTIwYWdlbnQuZGVzY3JpcHRpb24lMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">if</span> managed_agents <span class="hljs-built_in">and</span> managed_agents.<span class="hljs-built_in">values</span>() | <span class="hljs-keyword">list</span> %}
You can also give tasks <span class="hljs-keyword">to</span> team members.
Calling <span class="hljs-keyword">a</span> team member works similarly <span class="hljs-keyword">to</span> calling <span class="hljs-keyword">a</span> tool: provide the task description <span class="hljs-keyword">as</span> the <span class="hljs-string">&#x27;task&#x27;</span> <span class="hljs-keyword">argument</span>. Since this team member <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> real human, <span class="hljs-keyword">be</span> <span class="hljs-keyword">as</span> detailed <span class="hljs-built_in">and</span> <span class="hljs-keyword">verbose</span> <span class="hljs-keyword">as</span> necessary in your task description.
You can also include any relevant variables <span class="hljs-built_in">or</span> context using the <span class="hljs-string">&#x27;additional_args&#x27;</span> <span class="hljs-keyword">argument</span>.
Here <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> <span class="hljs-keyword">list</span> of the team members that you can <span class="hljs-keyword">call</span>:
{%- <span class="hljs-keyword">for</span> agent in managed_agents.<span class="hljs-built_in">values</span>() %}
- {{ agent.name }}: {{ agent.description }}
{%- <span class="hljs-keyword">endfor</span> %}
{%- <span class="hljs-keyword">endif</span> %}`,wrap:!1}}),ul=new g({props:{code:"YWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQlMjAlM0QlMjBhZ2VudC5wcm9tcHRfdGVtcGxhdGVzJTVCJTIyc3lzdGVtX3Byb21wdCUyMiU1RCUyMCUyQiUyMCUyMiU1Q25IZXJlJTIweW91JTIwZ28hJTIy",highlighted:'agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] = agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] + <span class="hljs-string">&quot;\\nHere you go!&quot;</span>',wrap:!1}}),bl=new g({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEbW9kZWxfaWQpJTJDJTIwaW5zdHJ1Y3Rpb25zJTNEJTIyQWx3YXlzJTIwdGFsayUyMGxpa2UlMjBhJTIwNSUyMHllYXIlMjBvbGQuJTIyKQ==",highlighted:'agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), instructions=<span class="hljs-string">&quot;Always talk like a 5 year old.&quot;</span>)',wrap:!1}}),Vl=new c({props:{title:"4. Extra planning",local:"4-extra-planning",headingTag:"h3"}}),jl=new g({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFdlYlNlYXJjaFRvb2wlMEFmcm9tJTIwZG90ZW52JTIwaW1wb3J0JTIwbG9hZF9kb3RlbnYlMEElMEFsb2FkX2RvdGVudigpJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwV2ViU2VhcmNoVG9vbCgpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCUyQyUyMGltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0QzJTIwJTIzJTIwVGhpcyUyMGlzJTIwd2hlcmUlMjB5b3UlMjBhY3RpdmF0ZSUyMHBsYW5uaW5nISUwQSklMEElMEElMjMlMjBSdW4lMjBpdCElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbG9uZyUyMHdvdWxkJTIwYSUyMGNoZWV0YWglMjBhdCUyMGZ1bGwlMjBzcGVlZCUyMHRha2UlMjB0byUyMHJ1biUyMHRoZSUyMGxlbmd0aCUyMG9mJTIwUG9udCUyMEFsZXhhbmRyZSUyMElJSSUzRiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel, WebSearchTool
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv

load_dotenv()

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

search_tool = WebSearchTool()

agent = CodeAgent(
    tools=[search_tool, image_generation_tool],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
    planning_interval=<span class="hljs-number">3</span> <span class="hljs-comment"># This is where you activate planning!</span>
)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;How long would a cheetah at full speed take to run the length of Pont Alexandre III?&quot;</span>,
)`,wrap:!1}}),Rl=new $T({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/building_good_agents.md"}}),{c(){d=t("meta"),u=M(),I=t("p"),Bl=M(),s(k.$$.fragment),fl=M(),s(m.$$.fragment),vl=M(),b=t("p"),b.textContent=PU,Yl=M(),s(r.$$.fragment),Dl=M(),s(V.$$.fragment),Xl=M(),F=t("p"),F.textContent=KU,zl=M(),j=t("p"),j.textContent=lT,Sl=M(),R=t("p"),R.innerHTML=UT,Hl=M(),B=t("p"),B.textContent=TT,El=M(),O=t("p"),O.textContent=JT,xl=M(),G=t("p"),G.textContent=MT,_l=M(),Q=t("ul"),Q.innerHTML=eT,$l=M(),s(Z.$$.fragment),ql=M(),W=t("p"),W.innerHTML=tT,Ll=M(),A=t("p"),A.textContent=aT,Pl=M(),f=t("p"),f.textContent=iT,Kl=M(),v=t("p"),v.textContent=sT,lU=M(),Y=t("p"),Y.textContent=nT,UU=M(),D=t("ul"),D.innerHTML=yT,TU=M(),X=t("p"),X.textContent=wT,JU=M(),z=t("p"),z.textContent=oT,MU=M(),s(S.$$.fragment),eU=M(),H=t("p"),H.textContent=CT,tU=M(),E=t("ul"),E.innerHTML=dT,aU=M(),x=t("p"),x.textContent=IT,iU=M(),_=t("p"),_.textContent=gT,sU=M(),s($.$$.fragment),nU=M(),q=t("p"),q.textContent=pT,yU=M(),s(L.$$.fragment),wU=M(),P=t("p"),P.innerHTML=hT,oU=M(),s(K.$$.fragment),CU=M(),ll=t("p"),ll.innerHTML=cT,dU=M(),s(Ul.$$.fragment),IU=M(),s(Tl.$$.fragment),gU=M(),Jl=t("p"),Jl.innerHTML=rT,pU=M(),s(Ml.$$.fragment),hU=M(),el=t("p"),el.textContent=NT,cU=M(),tl=t("p"),tl.innerHTML=uT,rU=M(),s(al.$$.fragment),NU=M(),il=t("p"),il.textContent=kT,uU=M(),sl=t("p"),sl.textContent=mT,kU=M(),nl=t("p"),nl.textContent=bT,mU=M(),yl=t("ul"),yl.innerHTML=VT,bU=M(),s(wl.$$.fragment),VU=M(),ol=t("p"),ol.textContent=FT,FU=M(),Cl=t("p"),Cl.innerHTML=jT,jU=M(),s(dl.$$.fragment),RU=M(),Il=t("p"),Il.textContent=RT,BU=M(),s(gl.$$.fragment),OU=M(),pl=t("p"),pl.innerHTML=BT,GU=M(),hl=t("p"),hl.innerHTML=OT,QU=M(),p=t("ul"),Ol=t("li"),EU=fT(`To insert tool descriptions:
	`),s(cl.$$.fragment),xU=M(),Gl=t("li"),_U=fT(`To insert the descriptions for managed agents if there are any:
	`),s(rl.$$.fragment),$U=M(),Ql=t("li"),Ql.innerHTML=GT,ZU=M(),Nl=t("p"),Nl.textContent=QT,WU=M(),s(ul.$$.fragment),AU=M(),kl=t("p"),kl.innerHTML=ZT,fU=M(),ml=t("p"),ml.innerHTML=WT,vU=M(),s(bl.$$.fragment),YU=M(),s(Vl.$$.fragment),DU=M(),Fl=t("p"),Fl.textContent=AT,XU=M(),s(jl.$$.fragment),zU=M(),s(Rl.$$.fragment),SU=M(),Zl=t("p"),this.h()},l(l){const U=ET("svelte-u9bgzb",document.head);d=a(U,"META",{name:!0,content:!0}),U.forEach(T),u=e(l),I=a(l,"P",{}),Wl(I).forEach(T),Bl=e(l),n(k.$$.fragment,l),fl=e(l),n(m.$$.fragment,l),vl=e(l),b=a(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-vt7d0l"&&(b.textContent=PU),Yl=e(l),n(r.$$.fragment,l),Dl=e(l),n(V.$$.fragment,l),Xl=e(l),F=a(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-jydojv"&&(F.textContent=KU),zl=e(l),j=a(l,"P",{"data-svelte-h":!0}),i(j)!=="svelte-f19v2r"&&(j.textContent=lT),Sl=e(l),R=a(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-v4rmo7"&&(R.innerHTML=UT),Hl=e(l),B=a(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1265t8d"&&(B.textContent=TT),El=e(l),O=a(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-67t7fl"&&(O.textContent=JT),xl=e(l),G=a(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-zyva75"&&(G.textContent=MT),_l=e(l),Q=a(l,"UL",{"data-svelte-h":!0}),i(Q)!=="svelte-nty9k8"&&(Q.innerHTML=eT),$l=e(l),n(Z.$$.fragment,l),ql=e(l),W=a(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1xcggba"&&(W.innerHTML=tT),Ll=e(l),A=a(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1bz3os9"&&(A.textContent=aT),Pl=e(l),f=a(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-kvre75"&&(f.textContent=iT),Kl=e(l),v=a(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-s4b558"&&(v.textContent=sT),lU=e(l),Y=a(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-19k59ru"&&(Y.textContent=nT),UU=e(l),D=a(l,"UL",{"data-svelte-h":!0}),i(D)!=="svelte-sky73b"&&(D.innerHTML=yT),TU=e(l),X=a(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1pp4kyh"&&(X.textContent=wT),JU=e(l),z=a(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-14ogt9"&&(z.textContent=oT),MU=e(l),n(S.$$.fragment,l),eU=e(l),H=a(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1invwxb"&&(H.textContent=CT),tU=e(l),E=a(l,"UL",{"data-svelte-h":!0}),i(E)!=="svelte-1vekrxk"&&(E.innerHTML=dT),aU=e(l),x=a(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-73i6xx"&&(x.textContent=IT),iU=e(l),_=a(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-np4knk"&&(_.textContent=gT),sU=e(l),n($.$$.fragment,l),nU=e(l),q=a(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-q0zmuw"&&(q.textContent=pT),yU=e(l),n(L.$$.fragment,l),wU=e(l),P=a(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-jz4g6f"&&(P.innerHTML=hT),oU=e(l),n(K.$$.fragment,l),CU=e(l),ll=a(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-usmqd6"&&(ll.innerHTML=cT),dU=e(l),n(Ul.$$.fragment,l),IU=e(l),n(Tl.$$.fragment,l),gU=e(l),Jl=a(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-jh63p8"&&(Jl.innerHTML=rT),pU=e(l),n(Ml.$$.fragment,l),hU=e(l),el=a(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-y1pddw"&&(el.textContent=NT),cU=e(l),tl=a(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-y3io9r"&&(tl.innerHTML=uT),rU=e(l),n(al.$$.fragment,l),NU=e(l),il=a(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1b7s4xp"&&(il.textContent=kT),uU=e(l),sl=a(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-ofl7w0"&&(sl.textContent=mT),kU=e(l),nl=a(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-1dth48k"&&(nl.textContent=bT),mU=e(l),yl=a(l,"UL",{"data-svelte-h":!0}),i(yl)!=="svelte-1mdaznm"&&(yl.innerHTML=VT),bU=e(l),n(wl.$$.fragment,l),VU=e(l),ol=a(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-alcruo"&&(ol.textContent=FT),FU=e(l),Cl=a(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-k12dm7"&&(Cl.innerHTML=jT),jU=e(l),n(dl.$$.fragment,l),RU=e(l),Il=a(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-174l3zr"&&(Il.textContent=RT),BU=e(l),n(gl.$$.fragment,l),OU=e(l),pl=a(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-yb3mzp"&&(pl.innerHTML=BT),GU=e(l),hl=a(l,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-148o4aa"&&(hl.innerHTML=OT),QU=e(l),p=a(l,"UL",{});var h=Wl(p);Ol=a(h,"LI",{});var qU=Wl(Ol);EU=vT(qU,`To insert tool descriptions:
	`),n(cl.$$.fragment,qU),qU.forEach(T),xU=e(h),Gl=a(h,"LI",{});var LU=Wl(Gl);_U=vT(LU,`To insert the descriptions for managed agents if there are any:
	`),n(rl.$$.fragment,LU),LU.forEach(T),$U=e(h),Ql=a(h,"LI",{"data-svelte-h":!0}),i(Ql)!=="svelte-1fwgx7s"&&(Ql.innerHTML=GT),h.forEach(T),ZU=e(l),Nl=a(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-1gu6gc"&&(Nl.textContent=QT),WU=e(l),n(ul.$$.fragment,l),AU=e(l),kl=a(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-1pl7ou9"&&(kl.innerHTML=ZT),fU=e(l),ml=a(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-5842wh"&&(ml.innerHTML=WT),vU=e(l),n(bl.$$.fragment,l),YU=e(l),n(Vl.$$.fragment,l),DU=e(l),Fl=a(l,"P",{"data-svelte-h":!0}),i(Fl)!=="svelte-f8c96r"&&(Fl.textContent=AT),XU=e(l),n(jl.$$.fragment,l),zU=e(l),n(Rl.$$.fragment,l),SU=e(l),Zl=a(l,"P",{}),Wl(Zl).forEach(T),this.h()},h(){YT(d,"name","hf:doc:metadata"),YT(d,"content",PT)},m(l,U){N(document.head,d),J(l,u,U),J(l,I,U),J(l,Bl,U),y(k,l,U),J(l,fl,U),y(m,l,U),J(l,vl,U),J(l,b,U),J(l,Yl,U),y(r,l,U),J(l,Dl,U),y(V,l,U),J(l,Xl,U),J(l,F,U),J(l,zl,U),J(l,j,U),J(l,Sl,U),J(l,R,U),J(l,Hl,U),J(l,B,U),J(l,El,U),J(l,O,U),J(l,xl,U),J(l,G,U),J(l,_l,U),J(l,Q,U),J(l,$l,U),y(Z,l,U),J(l,ql,U),J(l,W,U),J(l,Ll,U),J(l,A,U),J(l,Pl,U),J(l,f,U),J(l,Kl,U),J(l,v,U),J(l,lU,U),J(l,Y,U),J(l,UU,U),J(l,D,U),J(l,TU,U),J(l,X,U),J(l,JU,U),J(l,z,U),J(l,MU,U),y(S,l,U),J(l,eU,U),J(l,H,U),J(l,tU,U),J(l,E,U),J(l,aU,U),J(l,x,U),J(l,iU,U),J(l,_,U),J(l,sU,U),y($,l,U),J(l,nU,U),J(l,q,U),J(l,yU,U),y(L,l,U),J(l,wU,U),J(l,P,U),J(l,oU,U),y(K,l,U),J(l,CU,U),J(l,ll,U),J(l,dU,U),y(Ul,l,U),J(l,IU,U),y(Tl,l,U),J(l,gU,U),J(l,Jl,U),J(l,pU,U),y(Ml,l,U),J(l,hU,U),J(l,el,U),J(l,cU,U),J(l,tl,U),J(l,rU,U),y(al,l,U),J(l,NU,U),J(l,il,U),J(l,uU,U),J(l,sl,U),J(l,kU,U),J(l,nl,U),J(l,mU,U),J(l,yl,U),J(l,bU,U),y(wl,l,U),J(l,VU,U),J(l,ol,U),J(l,FU,U),J(l,Cl,U),J(l,jU,U),y(dl,l,U),J(l,RU,U),J(l,Il,U),J(l,BU,U),y(gl,l,U),J(l,OU,U),J(l,pl,U),J(l,GU,U),J(l,hl,U),J(l,QU,U),J(l,p,U),N(p,Ol),N(Ol,EU),y(cl,Ol,null),N(p,xU),N(p,Gl),N(Gl,_U),y(rl,Gl,null),N(p,$U),N(p,Ql),J(l,ZU,U),J(l,Nl,U),J(l,WU,U),y(ul,l,U),J(l,AU,U),J(l,kl,U),J(l,fU,U),J(l,ml,U),J(l,vU,U),y(bl,l,U),J(l,YU,U),y(Vl,l,U),J(l,DU,U),J(l,Fl,U),J(l,XU,U),y(jl,l,U),J(l,zU,U),y(Rl,l,U),J(l,SU,U),J(l,Zl,U),HU=!0},p(l,[U]){const h={};U&2&&(h.$$scope={dirty:U,ctx:l}),r.$set(h)},i(l){HU||(w(k.$$.fragment,l),w(m.$$.fragment,l),w(r.$$.fragment,l),w(V.$$.fragment,l),w(Z.$$.fragment,l),w(S.$$.fragment,l),w($.$$.fragment,l),w(L.$$.fragment,l),w(K.$$.fragment,l),w(Ul.$$.fragment,l),w(Tl.$$.fragment,l),w(Ml.$$.fragment,l),w(al.$$.fragment,l),w(wl.$$.fragment,l),w(dl.$$.fragment,l),w(gl.$$.fragment,l),w(cl.$$.fragment,l),w(rl.$$.fragment,l),w(ul.$$.fragment,l),w(bl.$$.fragment,l),w(Vl.$$.fragment,l),w(jl.$$.fragment,l),w(Rl.$$.fragment,l),HU=!0)},o(l){o(k.$$.fragment,l),o(m.$$.fragment,l),o(r.$$.fragment,l),o(V.$$.fragment,l),o(Z.$$.fragment,l),o(S.$$.fragment,l),o($.$$.fragment,l),o(L.$$.fragment,l),o(K.$$.fragment,l),o(Ul.$$.fragment,l),o(Tl.$$.fragment,l),o(Ml.$$.fragment,l),o(al.$$.fragment,l),o(wl.$$.fragment,l),o(dl.$$.fragment,l),o(gl.$$.fragment,l),o(cl.$$.fragment,l),o(rl.$$.fragment,l),o(ul.$$.fragment,l),o(bl.$$.fragment,l),o(Vl.$$.fragment,l),o(jl.$$.fragment,l),o(Rl.$$.fragment,l),HU=!1},d(l){l&&(T(u),T(I),T(Bl),T(fl),T(vl),T(b),T(Yl),T(Dl),T(Xl),T(F),T(zl),T(j),T(Sl),T(R),T(Hl),T(B),T(El),T(O),T(xl),T(G),T(_l),T(Q),T($l),T(ql),T(W),T(Ll),T(A),T(Pl),T(f),T(Kl),T(v),T(lU),T(Y),T(UU),T(D),T(TU),T(X),T(JU),T(z),T(MU),T(eU),T(H),T(tU),T(E),T(aU),T(x),T(iU),T(_),T(sU),T(nU),T(q),T(yU),T(wU),T(P),T(oU),T(CU),T(ll),T(dU),T(IU),T(gU),T(Jl),T(pU),T(hU),T(el),T(cU),T(tl),T(rU),T(NU),T(il),T(uU),T(sl),T(kU),T(nl),T(mU),T(yl),T(bU),T(VU),T(ol),T(FU),T(Cl),T(jU),T(RU),T(Il),T(BU),T(OU),T(pl),T(GU),T(hl),T(QU),T(p),T(ZU),T(Nl),T(WU),T(AU),T(kl),T(fU),T(ml),T(vU),T(YU),T(DU),T(Fl),T(XU),T(zU),T(SU),T(Zl)),T(d),C(k,l),C(m,l),C(r,l),C(V,l),C(Z,l),C(S,l),C($,l),C(L,l),C(K,l),C(Ul,l),C(Tl,l),C(Ml,l),C(al,l),C(wl,l),C(dl,l),C(gl,l),C(cl),C(rl),C(ul,l),C(bl,l),C(Vl,l),C(jl,l),C(Rl,l)}}}const PT='{"title":"Building good agents","local":"building-good-agents","sections":[{"title":"The best agentic systems are the simplest: simplify the workflow as much as you can","local":"the-best-agentic-systems-are-the-simplest-simplify-the-workflow-as-much-as-you-can","sections":[],"depth":3},{"title":"Improve the information flow to the LLM engine","local":"improve-the-information-flow-to-the-llm-engine","sections":[],"depth":3},{"title":"Give more arguments to the agent","local":"give-more-arguments-to-the-agent","sections":[],"depth":3},{"title":"How to debug your agent","local":"how-to-debug-your-agent","sections":[{"title":"1. Use a stronger LLM","local":"1-use-a-stronger-llm","sections":[],"depth":3},{"title":"2. Provide more information or specific instructions","local":"2-provide-more-information-or-specific-instructions","sections":[],"depth":3},{"title":"3. Change the prompt templates (generally not advised)","local":"3-change-the-prompt-templates-generally-not-advised","sections":[],"depth":3},{"title":"4. Extra planning","local":"4-extra-planning","sections":[],"depth":3}],"depth":2}],"depth":1}';function KT(Al){return XT(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tJ extends ST{constructor(d){super(),HT(this,d,KT,LT,DT,{})}}export{tJ as component};
