import{s as ut,f as ht,n as ft,o as Mt}from"../chunks/scheduler.7bc62968.js";import{S as wt,i as gt,g as n,s as i,r as c,m as Fe,H as yt,A as Jt,h as o,f as a,c as l,j as $e,u,x as r,n as He,B as bt,k as J,y as D,a as s,v as h,d as f,t as M,w}from"../chunks/index.2f8492b0.js";import{C as Ve}from"../chunks/CodeBlock.bb61a5a9.js";import{H as Xe,E as Tt}from"../chunks/getInferenceSnippets.89372fb2.js";function Zt(Ee){let d,O,P,ee,b,te,T,Re=`This chapter introduces the building blocks of Stable Diffusion which is a generative artificial intelligence (generative AI) model that produces unique photorealistic images from text and image prompts. It originally launched in 2022 and was made possible thanks to a collaboration with
<a href="https://stability.ai/" rel="nofollow">Stability AI</a>, <a href="https://runwayml.com/" rel="nofollow">RunwayML</a> and CompVis Group at LMU Munich following the <a href="https://arxiv.org/pdf/2112.10752.pdf" rel="nofollow">paper</a>.`,ae,Z,Le="What will you learn from this chapter?",se,U,Qe="<li>Fundamental components of Stable Diffusion</li> <li>How to use <code>text-to-image</code>, <code>image2image</code>, inpainting pipelines</li>",ie,W,le,j,Ne=`To make this section interesting we will try to answer some questions to understand the basic components of the Stable Diffusion process.
We will briefly discuss each component as they are already covered in our Diffusers course. Also, you can visit our previous section, which talks about GANS and Diffusion models in details.`,ne,v,ze="<li>What strategies does Stable Diffusion employ to learn new information?<ul><li>It uses forward and reverse processes of diffusion models. In the forward process, we add Gaussian noise to an image until all that remains is the random noise. Usually we cannot identify the final noisy version of the image.</li> <li>In the reserve process, we have a learned neural network trained to gradually denoise an image starting from pure noise, until you end up with an actual image.</li></ul></li>",oe,m,Ce,q,Ae="T",Se,re,ct='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>t</mi><mn>0</mn></msub></mrow><annotation encoding="application/x-tex">t_0</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7651em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">t</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',me,g,De="Hugging Face Blog",Ye,pe,k,qe="<li>Since our images can be huge how can we compress it?</li>",de,I,Pe=`When you have large images, they require more computing power to process. This becomes very noticeable in a specific operation known as self-attention. The bigger the image, the more calculations are needed, and these calculations increase very quickly (in a way mathematicians call “quadratically”) with the size of the image.
For example, if you have an image that’s 128 pixels wide and tall, it has four times more pixels than an image that’s only 64 pixels wide and tall. Because of how self-attention works, dealing with this larger image doesn’t just need four times more memory and computing power, it actually needs sixteen times more (since 4 times 4 equals 16). This makes it challenging to work with very high-resolution images, as they require a lot of resources to process.
Latent diffusion models address the high computational demands of processing large images by using a Variational Auto-Encoder (VAE) to shrink the images into a more manageable size. The idea is that many images have repetitive or unnecessary information. A VAE, after being trained on a lot of data, can compress an image into a much smaller, condensed form. This smaller version still retains the essential features of the original image.`,ce,B,Ke="<li>How are we fusing texts with images since we are using prompts?</li>",ue,G,Oe=`We know that during inference time, we can feed in the description of an image we’d like to see and some pure noise as a starting point, and the model does its best to ‘denoise’ the random input into something that matches the caption.
SD leverages a pre-trained transformer model based on something called <a href="https://huggingface.co/learn/computer-vision-course/unit4/multimodal-models/clip-and-relatives/clip" rel="nofollow">CLIP</a>. CLIP’s text encoder was designed to process image captions into a form that could be used to compare images and text, so it is well suited to the task of creating useful representations from image descriptions. An input prompt is first tokenized (based on a large vocabulary where each word or sub-word is assigned a specific token) and then fed through the CLIP text encoder, producing a 768-dimensional (in the case of SD 1.X) or 1024-dimensional (SD 2.X) vector for each token. To keep things consistent prompts are always padded/truncated to be 77 tokens long, and so the final representation which we use as conditioning is a tensor of shape 77x1024 per prompt.`,he,x,et="<li>How can we add-in good inductive biases?</li>",fe,_,tt=`Since, we are trying to generate something new(e.g., a realistic Pokemon), we need a way to go beyond the images we have seen before(e.g., an anime Pokemon). That’s where U-Net and self-attention come into the picture. Given a noisy version of an image, the model is tasked with predicting the denoised version based on additional clues such as a text description of the image. Ok, how do we actually feed this conditioning information into the U-Net for it to use as it makes predictions? The answer is something called cross-attention. Scattered throughout the U-Net are cross-attention layers.
Each spatial location in the U-Net can ‘attend’ to different tokens in the text conditioning, bringing in relevant information from the prompt.`,Me,F,we,H,at='This section introduces helpful usecases and how we can perform these tasks using the <a href="https://github.com/huggingface/diffusers" rel="nofollow">Diffusers</a> library.',ge,V,st=`<li>Steps for <code>text-to-image</code> inference
The idea is to pass in the text prompt, which is converted to the output image.</li>`,ye,p,it="",lt,Je,X,nt="Using the <code>diffusers</code> library you can get <code>text-to-image</code> working in 2 steps.",be,C,ot="Let’s install the <code>diffusers</code> library first.",Te,S,Ze,Y,rt="We will now initialize the pipeline and pass our prompt inside and infer.",Ue,$,We,E,mt=`<li>Steps for image-to-image inference
In similar fashion, we can initialize the pipeline, but pass an image and a text prompt instead.</li>`,je,R,ve,L,pt=`<li>Steps for Inpainting
For inpainting pipeline, we need to pass an image, a text prompt, and a mask based on an object in that image, which indicates what to inpaint in the image.
In this example we also pass a negative prompt to further influence the inference on what we want to avoid.</li>`,ke,Q,Ie,N,Be,z,dt='<li><a href="https://huggingface.co/docs/diffusers/using-diffusers/pipeline_overview" rel="nofollow">Diffusers documentation</a></li> <li><a href="https://huggingface.co/docs/diffusers/installation" rel="nofollow">Diffusers installation</a></li>',Ge,A,xe,K,_e;return b=new Xe({props:{title:"Introduction to Stable Diffusion",local:"introduction-to-stable-diffusion",headingTag:"h1"}}),W=new Xe({props:{title:"What Do We Need for Stable Diffusion to Work?",local:"what-do-we-need-for-stable-diffusion-to-work",headingTag:"h2"}}),F=new Xe({props:{title:"How to use text-to-image , image-to-image , Inpainting Models in Diffusers",local:"how-to-use-text-to-image--image-to-image--inpainting-models-in-diffusers",headingTag:"h2"}}),S=new Ve({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2Vycw==",highlighted:"pip install diffusers",wrap:!1}}),$=new Ve({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMzEpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">31</span>)
image = pipeline(
    <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),R=new Ve({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwTG9hZCUyMGFuJTIwaW1hZ2UlMjB0byUyMHBhc3MlMjB0byUyMHRoZSUyMHBpcGVsaW5lJTNBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY2F0LnBuZyUyMiUwQSklMEElMEElMjMlMjBQYXNzJTIwYSUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUyMHRvJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTNBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># Load an image to pass to the pipeline:</span>
init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>
)

<span class="hljs-comment"># Pass a prompt and image to the pipeline to generate an image:</span>
prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Q=new Ve({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># Load the base and mask images:</span>
init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>
)
mask_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>
)

<span class="hljs-comment"># Create a prompt to inpaint the image with and pass it to the pipeline with the base and mask images:</span>
prompt = (
    <span class="hljs-string">&quot;a black cat with glowing eyes, cute, adorable, disney, pixar, highly detailed, 8k&quot;</span>
)
negative_prompt = <span class="hljs-string">&quot;bad anatomy, deformed, ugly, disfigured&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    image=init_image,
    mask_image=mask_image,
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),N=new Xe({props:{title:"Further Reading",local:"further-reading",headingTag:"h3"}}),A=new Tt({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit5/generative-models/diffusion-models/stable-diffusion.mdx"}}),{c(){d=n("meta"),O=i(),P=n("p"),ee=i(),c(b.$$.fragment),te=i(),T=n("p"),T.innerHTML=Re,ae=i(),Z=n("p"),Z.textContent=Le,se=i(),U=n("ul"),U.innerHTML=Qe,ie=i(),c(W.$$.fragment),le=i(),j=n("p"),j.textContent=Ne,ne=i(),v=n("ul"),v.innerHTML=ze,oe=i(),m=n("p"),Ce=Fe("Both of these processes happens for a finite number of steps "),q=n("code"),q.textContent=Ae,Se=Fe("(as per DDPM paper T=1000). You begin the process at time"),re=new yt(!1),me=Fe(" by sampling a real image from your data distribution, and the forward process samples some noise from a Gaussian distribution at each time step t, which is added to the image of the previous time step. To get more mathematical intuition, please read "),g=n("a"),g.textContent=De,Ye=Fe(" on Diffusion Models."),pe=i(),k=n("ul"),k.innerHTML=qe,de=i(),I=n("p"),I.textContent=Pe,ce=i(),B=n("ul"),B.innerHTML=Ke,ue=i(),G=n("p"),G.innerHTML=Oe,he=i(),x=n("ul"),x.innerHTML=et,fe=i(),_=n("p"),_.textContent=tt,Me=i(),c(F.$$.fragment),we=i(),H=n("p"),H.innerHTML=at,ge=i(),V=n("ul"),V.innerHTML=st,ye=i(),p=n("iframe"),p.innerHTML=it,Je=i(),X=n("p"),X.innerHTML=nt,be=i(),C=n("p"),C.innerHTML=ot,Te=i(),c(S.$$.fragment),Ze=i(),Y=n("p"),Y.textContent=rt,Ue=i(),c($.$$.fragment),We=i(),E=n("ul"),E.innerHTML=mt,je=i(),c(R.$$.fragment),ve=i(),L=n("ul"),L.innerHTML=pt,ke=i(),c(Q.$$.fragment),Ie=i(),c(N.$$.fragment),Be=i(),z=n("ul"),z.innerHTML=dt,Ge=i(),c(A.$$.fragment),xe=i(),K=n("p"),this.h()},l(e){const t=Jt("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(a),O=l(e),P=o(e,"P",{}),$e(P).forEach(a),ee=l(e),u(b.$$.fragment,e),te=l(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-z66int"&&(T.innerHTML=Re),ae=l(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1sm6n8h"&&(Z.textContent=Le),se=l(e),U=o(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-15b6ktr"&&(U.innerHTML=Qe),ie=l(e),u(W.$$.fragment,e),le=l(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-15v5s0q"&&(j.textContent=Ne),ne=l(e),v=o(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-cbr84n"&&(v.innerHTML=ze),oe=l(e),m=o(e,"P",{});var y=$e(m);Ce=He(y,"Both of these processes happens for a finite number of steps "),q=o(y,"CODE",{"data-svelte-h":!0}),r(q)!=="svelte-18tc35m"&&(q.textContent=Ae),Se=He(y,"(as per DDPM paper T=1000). You begin the process at time"),re=bt(y,!1),me=He(y," by sampling a real image from your data distribution, and the forward process samples some noise from a Gaussian distribution at each time step t, which is added to the image of the previous time step. To get more mathematical intuition, please read "),g=o(y,"A",{href:!0,rel:!0,"data-svelte-h":!0}),r(g)!=="svelte-1h13rvl"&&(g.textContent=De),Ye=He(y," on Diffusion Models."),y.forEach(a),pe=l(e),k=o(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-nhvgmx"&&(k.innerHTML=qe),de=l(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-ghqky8"&&(I.textContent=Pe),ce=l(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-wgoof5"&&(B.innerHTML=Ke),ue=l(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1xqaret"&&(G.innerHTML=Oe),he=l(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1gci2og"&&(x.innerHTML=et),fe=l(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-ceb1g8"&&(_.textContent=tt),Me=l(e),u(F.$$.fragment,e),we=l(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1tbjqci"&&(H.innerHTML=at),ge=l(e),V=o(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-4vkcyc"&&(V.innerHTML=st),ye=l(e),p=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0,"data-svelte-h":!0}),r(p)!=="svelte-1du1c08"&&(p.innerHTML=it),Je=l(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1xlt128"&&(X.innerHTML=nt),be=l(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-3yyytc"&&(C.innerHTML=ot),Te=l(e),u(S.$$.fragment,e),Ze=l(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-18bx7u2"&&(Y.textContent=rt),Ue=l(e),u($.$$.fragment,e),We=l(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-k07d6l"&&(E.innerHTML=mt),je=l(e),u(R.$$.fragment,e),ve=l(e),L=o(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-3vw8pj"&&(L.innerHTML=pt),ke=l(e),u(Q.$$.fragment,e),Ie=l(e),u(N.$$.fragment,e),Be=l(e),z=o(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-cvv663"&&(z.innerHTML=dt),Ge=l(e),u(A.$$.fragment,e),xe=l(e),K=o(e,"P",{}),$e(K).forEach(a),this.h()},h(){J(d,"name","hf:doc:metadata"),J(d,"content",Ut),re.a=me,J(g,"href","https://huggingface.co/blog/annotated-diffusion"),J(g,"rel","nofollow"),ht(p.src,lt="https://hysts-controlnet-v1-1.hf.space/")||J(p,"src",lt),J(p,"frameborder","0"),J(p,"width","850"),J(p,"height","450")},m(e,t){D(document.head,d),s(e,O,t),s(e,P,t),s(e,ee,t),h(b,e,t),s(e,te,t),s(e,T,t),s(e,ae,t),s(e,Z,t),s(e,se,t),s(e,U,t),s(e,ie,t),h(W,e,t),s(e,le,t),s(e,j,t),s(e,ne,t),s(e,v,t),s(e,oe,t),s(e,m,t),D(m,Ce),D(m,q),D(m,Se),re.m(ct,m),D(m,me),D(m,g),D(m,Ye),s(e,pe,t),s(e,k,t),s(e,de,t),s(e,I,t),s(e,ce,t),s(e,B,t),s(e,ue,t),s(e,G,t),s(e,he,t),s(e,x,t),s(e,fe,t),s(e,_,t),s(e,Me,t),h(F,e,t),s(e,we,t),s(e,H,t),s(e,ge,t),s(e,V,t),s(e,ye,t),s(e,p,t),s(e,Je,t),s(e,X,t),s(e,be,t),s(e,C,t),s(e,Te,t),h(S,e,t),s(e,Ze,t),s(e,Y,t),s(e,Ue,t),h($,e,t),s(e,We,t),s(e,E,t),s(e,je,t),h(R,e,t),s(e,ve,t),s(e,L,t),s(e,ke,t),h(Q,e,t),s(e,Ie,t),h(N,e,t),s(e,Be,t),s(e,z,t),s(e,Ge,t),h(A,e,t),s(e,xe,t),s(e,K,t),_e=!0},p:ft,i(e){_e||(f(b.$$.fragment,e),f(W.$$.fragment,e),f(F.$$.fragment,e),f(S.$$.fragment,e),f($.$$.fragment,e),f(R.$$.fragment,e),f(Q.$$.fragment,e),f(N.$$.fragment,e),f(A.$$.fragment,e),_e=!0)},o(e){M(b.$$.fragment,e),M(W.$$.fragment,e),M(F.$$.fragment,e),M(S.$$.fragment,e),M($.$$.fragment,e),M(R.$$.fragment,e),M(Q.$$.fragment,e),M(N.$$.fragment,e),M(A.$$.fragment,e),_e=!1},d(e){e&&(a(O),a(P),a(ee),a(te),a(T),a(ae),a(Z),a(se),a(U),a(ie),a(le),a(j),a(ne),a(v),a(oe),a(m),a(pe),a(k),a(de),a(I),a(ce),a(B),a(ue),a(G),a(he),a(x),a(fe),a(_),a(Me),a(we),a(H),a(ge),a(V),a(ye),a(p),a(Je),a(X),a(be),a(C),a(Te),a(Ze),a(Y),a(Ue),a(We),a(E),a(je),a(ve),a(L),a(ke),a(Ie),a(Be),a(z),a(Ge),a(xe),a(K)),a(d),w(b,e),w(W,e),w(F,e),w(S,e),w($,e),w(R,e),w(Q,e),w(N,e),w(A,e)}}}const Ut='{"title":"Introduction to Stable Diffusion","local":"introduction-to-stable-diffusion","sections":[{"title":"What Do We Need for Stable Diffusion to Work?","local":"what-do-we-need-for-stable-diffusion-to-work","sections":[],"depth":2},{"title":"How to use text-to-image , image-to-image , Inpainting Models in Diffusers","local":"how-to-use-text-to-image--image-to-image--inpainting-models-in-diffusers","sections":[{"title":"Further Reading","local":"further-reading","sections":[],"depth":3}],"depth":2}],"depth":1}';function Wt(Ee){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bt extends wt{constructor(d){super(),gt(this,d,Wt,Zt,ut,{})}}export{Bt as component};
