import{s as Ye,n as Fe,o as Le}from"../chunks/scheduler.9bc65507.js";import{S as qe,i as Ae,g as i,s as a,r as m,A as Pe,h as o,f as s,c as n,j as Qe,x as p,u as r,k as ze,y as De,a as l,v as c,d as u,t as h,w as d}from"../chunks/index.707bf1b6.js";import{C as f}from"../chunks/CodeBlock.54a9f38d.js";import{D as Ke}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as Xe}from"../chunks/Heading.342b1fa6.js";function Oe($e){let J,q,F,A,w,Ze="# Image Feature Extraction",P,b,D,g,We="Image feature extraction is the task of extracting semantically meaningful features given an image. This has many use cases, including image similarity and image retrieval. Moreover, most computer vision models can be used for image feature extraction, where one can remove the task-specific head (image classification, object detection etc) and get the features. These features are very useful on a higher level: edge detection, corner detection and so on. They may also contain information about the real world (e.g. what a cat looks like) depending on how deep the model is. Therefore, these outputs can be used to train new classifiers on a specific dataset.",K,y,ve="In this guide, you will:",O,T,Ce="<li>Learn to build a simple image similarity system on top of the <code>image-feature-extraction</code> pipeline.</li> <li>Accomplish the same task with bare model inference.</li>",ee,M,te,j,ke="We have two images of cats sitting on top of fish nets, one of them is generated.",se,U,le,I,_e='Let’s see the pipeline in action. First, initialize the pipeline. If you don’t pass any model to it, the pipeline will be automatically initialized with <a href="google/vit-base-patch16-224">google/vit-base-patch16-224</a>. If you’d like to calculate similarity, set <code>pool</code> to True.',ae,$,ne,Z,xe="To infer with <code>pipe</code> pass both images to it.",ie,W,oe,v,Ve="The output contains pooled embeddings of those two images.",pe,C,me,k,Be="To get the similarity score, we need to pass them to a similarity function.",re,_,ce,x,Ne="If you want to get the last hidden states before pooling, avoid passing any value for the <code>pool</code> parameter, as it is set to <code>False</code> by default. These hidden states are useful for training new classifiers or models based on the features from the model.",ue,V,he,B,Re="Since the outputs are unpooled, we get the last hidden states where the first dimension is the batch size, and the last two are the embedding shape.",de,N,fe,R,Je,E,Ee="We can also use <code>AutoModel</code> class of transformers to get the features. <code>AutoModel</code> loads any transformers model with no task-specific head, and we can use this to get the features.",we,G,be,H,Ge="Let’s write a simple function for inference. We will pass the inputs to the <code>processor</code> first and pass its outputs to the <code>model</code>.",ge,S,ye,Q,He="We can pass the images directly to this function and get the embeddings.",Te,z,Me,X,Se="We can get the similarity again over the embeddings.",je,Y,Ue,L,Ie;return b=new Ke({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_feature_extraction.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_feature_extraction.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_feature_extraction.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_feature_extraction.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_feature_extraction.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_feature_extraction.ipynb"}]}}),M=new Xe({props:{title:"Image Similarity using image-feature-extraction Pipeline",local:"image-similarity-using-image-feature-extraction-pipeline",headingTag:"h2"}}),U=new f({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJscyUyMCUzRCUyMCU1QiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHMucG5nJTIyJTJDJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGY2F0cy5qcGVnJTIyJTVEJTBBaW1hZ2VfcmVhbCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmxzJTVCMCU1RCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIpJTBBaW1hZ2VfZ2VuJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1nX3VybHMlNUIxJTVEJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KS5jb252ZXJ0KCUyMlJHQiUyMik=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_urls = [<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&quot;</span>, <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.jpeg&quot;</span>]
image_real = Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">0</span>], stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image_gen = Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">1</span>], stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),$=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFERVZJQ0UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJ2N1ZGEnJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUnKSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtZmVhdHVyZS1leHRyYWN0aW9uJTIyJTJDJTIwbW9kZWxfbmFtZSUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMzg0JTIyJTJDJTIwZGV2aWNlJTNEREVWSUNFJTJDJTIwcG9vbCUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

DEVICE = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
pipe = pipeline(task=<span class="hljs-string">&quot;image-feature-extraction&quot;</span>, model_name=<span class="hljs-string">&quot;google/vit-base-patch16-384&quot;</span>, device=DEVICE, pool=<span class="hljs-literal">True</span>)`,wrap:!1}}),W=new f({props:{code:"b3V0cHV0cyUyMCUzRCUyMHBpcGUoJTVCaW1hZ2VfcmVhbCUyQyUyMGltYWdlX2dlbiU1RCk=",highlighted:"outputs = pipe([image_real, image_gen])",wrap:!1}}),C=new f({props:{code:"JTIzJTIwZ2V0JTIwdGhlJTIwbGVuZ3RoJTIwb2YlMjBhJTIwc2luZ2xlJTIwb3V0cHV0JTBBcHJpbnQobGVuKG91dHB1dHMlNUIwJTVEJTVCMCU1RCkpJTBBJTIzJTIwc2hvdyUyMG91dHB1dHMlMEFwcmludChvdXRwdXRzKSUwQSUwQSUyMyUyMDc2OCUwQSUyMyUyMCU1QiU1QiU1Qi0wLjAzOTA5MjM2OTM3NzYxMzA3JTJDJTIwMC40MzM4MTY3MDExNzM3ODIzNSUyQyUyMC0wLjA2OTEzMjU1OTAwMTQ0NTc3JTJD",highlighted:`<span class="hljs-comment"># get the length of a single output</span>
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(outputs[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]))
<span class="hljs-comment"># show outputs</span>
<span class="hljs-built_in">print</span>(outputs)

<span class="hljs-comment"># 768</span>
<span class="hljs-comment"># [[[-0.03909236937761307, 0.43381670117378235, -0.06913255900144577,</span>`,wrap:!1}}),_=new f({props:{code:"ZnJvbSUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBpbXBvcnQlMjBjb3NpbmVfc2ltaWxhcml0eSUwQSUwQXNpbWlsYXJpdHlfc2NvcmUlMjAlM0QlMjBjb3NpbmVfc2ltaWxhcml0eSh0b3JjaC5UZW5zb3Iob3V0cHV0cyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guVGVuc29yKG91dHB1dHMlNUIxJTVEKSUyQyUyMGRpbSUzRDEpJTBBJTBBcHJpbnQoc2ltaWxhcml0eV9zY29yZSklMEElMEElMjMlMjB0ZW5zb3IoJTVCMC42MDQzJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> cosine_similarity

similarity_score = cosine_similarity(torch.Tensor(outputs[<span class="hljs-number">0</span>]),
                                     torch.Tensor(outputs[<span class="hljs-number">1</span>]), dim=<span class="hljs-number">1</span>)

<span class="hljs-built_in">print</span>(similarity_score)

<span class="hljs-comment"># tensor([0.6043])</span>`,wrap:!1}}),V=new f({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1mZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbF9uYW1lJTNEJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIlMkMlMjBkZXZpY2UlM0RERVZJQ0UpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZShpbWFnZV9yZWFsKQ==",highlighted:`pipe = pipeline(task=<span class="hljs-string">&quot;image-feature-extraction&quot;</span>, model_name=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, device=DEVICE)
output = pipe(image_real)`,wrap:!1}}),N=new f({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBcHJpbnQobnAuYXJyYXkob3V0cHV0cykuc2hhcGUpJTBBJTIzJTIwKDElMkMlMjAxOTclMkMlMjA3Njgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-built_in">print</span>(np.array(outputs).shape)
<span class="hljs-comment"># (1, 197, 768)</span>`,wrap:!1}}),R=new Xe({props:{title:"Getting Features and Similarities using AutoModel",local:"getting-features-and-similarities-using-automodel",headingTag:"h2"}}),G=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKS50byhERVZJQ0Up",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>).to(DEVICE)`,wrap:!1}}),S=new f({props:{code:"ZGVmJTIwaW5mZXIoaW1hZ2UpJTNBJTBBJTIwJTIwaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oREVWSUNFKSUwQSUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjByZXR1cm4lMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">infer</span>(<span class="hljs-params">image</span>):
  inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(DEVICE)
  outputs = model(**inputs)
  <span class="hljs-keyword">return</span> outputs.pooler_output`,wrap:!1}}),z=new f({props:{code:"ZW1iZWRfcmVhbCUyMCUzRCUyMGluZmVyKGltYWdlX3JlYWwpJTBBZW1iZWRfZ2VuJTIwJTNEJTIwaW5mZXIoaW1hZ2VfZ2VuKQ==",highlighted:`embed_real = infer(image_real)
embed_gen = infer(image_gen)`,wrap:!1}}),Y=new f({props:{code:"ZnJvbSUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBpbXBvcnQlMjBjb3NpbmVfc2ltaWxhcml0eSUwQSUwQXNpbWlsYXJpdHlfc2NvcmUlMjAlM0QlMjBjb3NpbmVfc2ltaWxhcml0eShlbWJlZF9yZWFsJTJDJTIwZW1iZWRfZ2VuJTJDJTIwZGltJTNEMSklMEFwcmludChzaW1pbGFyaXR5X3Njb3JlKSUwQSUwQSUyMyUyMHRlbnNvciglNUIwLjYwNjElNUQlMkMlMjBkZXZpY2UlM0QnY3VkYSUzQTAnJTJDJTIwZ3JhZF9mbiUzRCUzQ1N1bUJhY2t3YXJkMSUzRSk=",highlighted:`<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> cosine_similarity

similarity_score = cosine_similarity(embed_real, embed_gen, dim=<span class="hljs-number">1</span>)
<span class="hljs-built_in">print</span>(similarity_score)

<span class="hljs-comment"># tensor([0.6061], device=&#x27;cuda:0&#x27;, grad_fn=&lt;SumBackward1&gt;)</span>`,wrap:!1}}),{c(){J=i("meta"),q=a(),F=i("p"),A=a(),w=i("p"),w.textContent=Ze,P=a(),m(b.$$.fragment),D=a(),g=i("p"),g.textContent=We,K=a(),y=i("p"),y.textContent=ve,O=a(),T=i("ul"),T.innerHTML=Ce,ee=a(),m(M.$$.fragment),te=a(),j=i("p"),j.textContent=ke,se=a(),m(U.$$.fragment),le=a(),I=i("p"),I.innerHTML=_e,ae=a(),m($.$$.fragment),ne=a(),Z=i("p"),Z.innerHTML=xe,ie=a(),m(W.$$.fragment),oe=a(),v=i("p"),v.textContent=Ve,pe=a(),m(C.$$.fragment),me=a(),k=i("p"),k.textContent=Be,re=a(),m(_.$$.fragment),ce=a(),x=i("p"),x.innerHTML=Ne,ue=a(),m(V.$$.fragment),he=a(),B=i("p"),B.textContent=Re,de=a(),m(N.$$.fragment),fe=a(),m(R.$$.fragment),Je=a(),E=i("p"),E.innerHTML=Ee,we=a(),m(G.$$.fragment),be=a(),H=i("p"),H.innerHTML=Ge,ge=a(),m(S.$$.fragment),ye=a(),Q=i("p"),Q.textContent=He,Te=a(),m(z.$$.fragment),Me=a(),X=i("p"),X.textContent=Se,je=a(),m(Y.$$.fragment),Ue=a(),L=i("p"),this.h()},l(e){const t=Pe("svelte-u9bgzb",document.head);J=o(t,"META",{name:!0,content:!0}),t.forEach(s),q=n(e),F=o(e,"P",{}),Qe(F).forEach(s),A=n(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-lthq95"&&(w.textContent=Ze),P=n(e),r(b.$$.fragment,e),D=n(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-htpxsg"&&(g.textContent=We),K=n(e),y=o(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-dkb44i"&&(y.textContent=ve),O=n(e),T=o(e,"UL",{"data-svelte-h":!0}),p(T)!=="svelte-o9mygf"&&(T.innerHTML=Ce),ee=n(e),r(M.$$.fragment,e),te=n(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1y1lzmz"&&(j.textContent=ke),se=n(e),r(U.$$.fragment,e),le=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-ufkt7t"&&(I.innerHTML=_e),ae=n(e),r($.$$.fragment,e),ne=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1wqrlcg"&&(Z.innerHTML=xe),ie=n(e),r(W.$$.fragment,e),oe=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-ejn9fo"&&(v.textContent=Ve),pe=n(e),r(C.$$.fragment,e),me=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-7ov6zk"&&(k.textContent=Be),re=n(e),r(_.$$.fragment,e),ce=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1t8cfg9"&&(x.innerHTML=Ne),ue=n(e),r(V.$$.fragment,e),he=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-u3d9d7"&&(B.textContent=Re),de=n(e),r(N.$$.fragment,e),fe=n(e),r(R.$$.fragment,e),Je=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-18d7a3m"&&(E.innerHTML=Ee),we=n(e),r(G.$$.fragment,e),be=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1mcm377"&&(H.innerHTML=Ge),ge=n(e),r(S.$$.fragment,e),ye=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1ej6c6d"&&(Q.textContent=He),Te=n(e),r(z.$$.fragment,e),Me=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1t2j36n"&&(X.textContent=Se),je=n(e),r(Y.$$.fragment,e),Ue=n(e),L=o(e,"P",{}),Qe(L).forEach(s),this.h()},h(){ze(J,"name","hf:doc:metadata"),ze(J,"content",et)},m(e,t){De(document.head,J),l(e,q,t),l(e,F,t),l(e,A,t),l(e,w,t),l(e,P,t),c(b,e,t),l(e,D,t),l(e,g,t),l(e,K,t),l(e,y,t),l(e,O,t),l(e,T,t),l(e,ee,t),c(M,e,t),l(e,te,t),l(e,j,t),l(e,se,t),c(U,e,t),l(e,le,t),l(e,I,t),l(e,ae,t),c($,e,t),l(e,ne,t),l(e,Z,t),l(e,ie,t),c(W,e,t),l(e,oe,t),l(e,v,t),l(e,pe,t),c(C,e,t),l(e,me,t),l(e,k,t),l(e,re,t),c(_,e,t),l(e,ce,t),l(e,x,t),l(e,ue,t),c(V,e,t),l(e,he,t),l(e,B,t),l(e,de,t),c(N,e,t),l(e,fe,t),c(R,e,t),l(e,Je,t),l(e,E,t),l(e,we,t),c(G,e,t),l(e,be,t),l(e,H,t),l(e,ge,t),c(S,e,t),l(e,ye,t),l(e,Q,t),l(e,Te,t),c(z,e,t),l(e,Me,t),l(e,X,t),l(e,je,t),c(Y,e,t),l(e,Ue,t),l(e,L,t),Ie=!0},p:Fe,i(e){Ie||(u(b.$$.fragment,e),u(M.$$.fragment,e),u(U.$$.fragment,e),u($.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(_.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(S.$$.fragment,e),u(z.$$.fragment,e),u(Y.$$.fragment,e),Ie=!0)},o(e){h(b.$$.fragment,e),h(M.$$.fragment,e),h(U.$$.fragment,e),h($.$$.fragment,e),h(W.$$.fragment,e),h(C.$$.fragment,e),h(_.$$.fragment,e),h(V.$$.fragment,e),h(N.$$.fragment,e),h(R.$$.fragment,e),h(G.$$.fragment,e),h(S.$$.fragment,e),h(z.$$.fragment,e),h(Y.$$.fragment,e),Ie=!1},d(e){e&&(s(q),s(F),s(A),s(w),s(P),s(D),s(g),s(K),s(y),s(O),s(T),s(ee),s(te),s(j),s(se),s(le),s(I),s(ae),s(ne),s(Z),s(ie),s(oe),s(v),s(pe),s(me),s(k),s(re),s(ce),s(x),s(ue),s(he),s(B),s(de),s(fe),s(Je),s(E),s(we),s(be),s(H),s(ge),s(ye),s(Q),s(Te),s(Me),s(X),s(je),s(Ue),s(L)),s(J),d(b,e),d(M,e),d(U,e),d($,e),d(W,e),d(C,e),d(_,e),d(V,e),d(N,e),d(R,e),d(G,e),d(S,e),d(z,e),d(Y,e)}}}const et='{"title":"Image Similarity using image-feature-extraction Pipeline","local":"image-similarity-using-image-feature-extraction-pipeline","sections":[],"depth":2}';function tt($e){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ot extends qe{constructor(J){super(),Ae(this,J,tt,Oe,Ye,{})}}export{ot as component};
