import{s as cs,f as Ee,n as hs,o as fs}from"../chunks/scheduler.85c25b89.js";import{S as ws,i as ys,g as i,s as l,r as p,A as Ms,h as o,f as n,c as a,j as ms,u,x as r,k as w,y as gs,a as s,v as m,d as c,t as h,w as f}from"../chunks/index.c9bcf812.js";import{C as M}from"../chunks/CodeBlock.c004bd26.js";import{H as y}from"../chunks/getInferenceSnippets.80b657e7.js";function ds(fn){let g,ze,He,Ge,d,Re,T,wn="This guide will help you get Optimum Neuron up and running. There are two main approaches:",Xe,J,yn="<li><strong>🚀 Recommended: AWS EC2 with Deep Learning AMI</strong> - The simplest way to get started with pre-configured environment</li> <li><strong>⚙️ Manual Installation</strong> - Install Optimum Neuron on existing infrastructure</li>",Pe,C,Ye,I,Mn='The simplest way to work with AWS Trainium or Inferentia and Optimum Neuron on Amazon EC2 is the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a> (DLAMI). The DLAMI comes with all required libraries pre-packaged for you, including the Optimum Neuron, Neuron Drivers, Transformers, Datasets, and Accelerate. The HF DLAMI is provided at no additional charge to Amazon EC2 users.',Fe,v,gn='Optimum Neuron supports Inf1, Inf2, Trn1 and Trn2, all accessible on Amazon EC2. You can find all the specifications of the Trn and Inf instances <a href="https://aws.amazon.com/ec2/instance-types/" rel="nofollow">here</a>, in the “Accelerated Computing” section.',De,x,dn="In this section, we will show you:",qe,b,Tn='<li><a href="#create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami">How to create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI</a><ol><li><a href="#find-a-supported-region">Find a supported region</a></li> <li><a href="#increase-service-quota">Increase service quota</a></li> <li><a href="#launch-the-amazon-ec2-instance-with-the-hf-dlami">Launch the Amazon EC2 instance with the HF DLAMI</a></li> <li><a href="#connect-through-ssh">Connect through SSH</a></li></ol></li> <li><a href="#set-up-your-remote-development-environment">How to set up your remote development environment</a><ol><li><a href="#access-through-jupyter-notebook">Access through Jupyter Notebook</a></li> <li><a href="#access-through-vs-code-remote-server">Access through VS Code remote server</a></li></ol></li>',Oe,j,Ke,$,Jn="Before creating the EC2 instance, make sure you are in a supported region for the instance you selected and that you have quota in your AWS account.",et,U,tt,A,Cn="Here is the list of regions that support at least one type of Trainium or Inferentia2 instance, as of February 2025:",nt,S,In="<li>us-east-1: US East (N. Virginia)</li> <li>us-east-2: US East (Ohio)</li> <li>us-west-2: US West (Oregon)</li> <li>ap-south-1: Asia Pacific (Mumbai)</li> <li>ap-northeast-1: Asia Pacific (Tokyo)</li> <li>ap-southeast-1: Asia Pacific (Singapore)</li> <li>ap-southeast-2: Asia Pacific (Sydney)</li> <li>ap-southeast-4: Asia Pacific (Melbourne)</li> <li>eu-north-1: Europe (Stockholm)</li> <li>eu-west-3: Europe (Paris)</li> <li>eu-west-2: Europe (London)</li> <li>eu-west-1: Europe (Ireland)</li> <li>eu-central-1: Europe (Frankfurt)</li> <li>sa-east-1: South America (Sao Paulo)</li>",st,k,vn="Here is a Python script that lets you pull the latest supported instance type in each region you have enabled:",lt,_,at,L,it,N,xn="Now that you selected your region and that you switched to it, you can request a Service Quota increase through the AWS Console by navigating to Service Quota, AWS services in the left panel, search for Amazon EC2, then “trn” or “inf”. You are able to request quota increase for On-Demand and Spot instances separately.",ot,W,bn="By default, all quotas are 0 for Inferentia and Trainium. There is no charge for increased quotas. There are separate quotas for Inferentia and Trainium, and separate quotas for spot and on-demand. Quotas refer to the maximum TOTAL number of vCPUs assigned to each instance type.",rt,B,jn="For example, a quota of 192 will let you run a single inf2.48xlarge, two inf2.24xlarges, six inf2.8xlarges, or forty-eight of the inf2.xlarges. It will also let you run inf1 instance types. Similarly for Trainium, a quota of 128 will let you run a single trn1n.32xlarge or trn1.32xlarge, but it will also let you run sixteen trn1.2xlarge.",pt,V,ut,Z,$n="Let’s deploy a trn1.2xlarge instance in the us-east-1 region (North Virginia) through the EC2 console.",mt,E,Un="First, click on <strong>Launch instance</strong> and define a name for the instance (<code>trainium-huggingface-demo</code>).",ct,H,An,ht,Q,Sn="Next, you search the Amazon Marketplace for Hugging Face AMIs. Entering “Hugging Face” in the search bar for “Application and OS Images” and hitting “enter”.",ft,z,kn,wt,G,_n='This should now open the “Choose an Amazon Machine Image” view with the search. You can now navigate to “AWS Marketplace AMIs” and find the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a> and click select.',yt,R,Ln,Mt,X,Nn="<em>You will be asked to subscribe if you aren’t. The AMI is completely free of charge, and you will only pay for the EC2 compute.</em>",gt,P,Wn="Then you need to define a key pair, which will be used to connect to the instance via <code>ssh</code>. You can create one in place if you don’t have a key pair.",dt,Y,Bn,Tt,F,Vn='After that, create or select a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html" rel="nofollow">security group</a> which allows <code>ssh</code> traffic.',Jt,D,Zn,Ct,q,En="You are ready to launch the instance. Therefore click on “Launch Instance” on the right side.",It,O,Hn,vt,K,Qn='AWS will now provision the instance using the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>.',xt,ee,bt,te,zn="Once the instance is ready, you can view and copy the public IPv4 address to <code>ssh</code> into the machine.",jt,ne,Gn,$t,se,Rn="Replace the empty strings <code>&quot;&quot;</code> in the snippet below with the IP address of your instances and the path to the key pair you created/selected when launching the instance.",Ut,le,At,ae,Xn="Once you are connected, you can run <code>neuron-ls</code> to ensure you have access to the Trainium accelerators. You should see a similar output than below.",St,ie,kt,oe,_t,re,Pn="We will walk through setting up Jupyter Notebooks or VS Code remote server on the Amazon EC2 instance.",Lt,pe,Yn="These two methods require an SSH connection of some kind. These instructions were written for a Mac, but should work on a Linux system as well. A PC may require using Putty.",Nt,ue,Fn="You should have a .pem file that you created when you deployed your instance or had from previous deployments. You can connect to your system using:",Wt,me,Bt,ce,Vt,he,Dn="This method involves running the Jupyter notebook server on the Neuron instance, mapping a port locally, then using the browser on your desktop to access the notebook server.",Zt,fe,qn="Start by mapping a port on your local machine to the Neuron instance. From a terminal on your system, run",Et,we,Ht,ye,On="Then connect to your Amazon EC2 instance using SSH from your computer. Once connected, from the command prompt, run",Qt,Me,zt,ge,Kn="After a few seconds, check the nohup.out file to find your server’s token:",Gt,de,Rt,Te,es="Copy the connection string and paste it into your browser. After a few seconds, you should eventually see the Jupyter Notebook browser. It should look like http://localhost:8888/tree?token=337fc8de2aenot_a_real_tokene952c43946e4fb57131",Xt,Je,ts="This process works because you have mapped the 8888 port on your local machine to the 8888 port on the Neuron instance, so when you connect to localhost:8888, you end up accessing the Jupyter server on the Neuron instance.",Pt,Ce,ns="If you have problems, make sure the initial port mapping was successful. If you already have something running on port 8888 on your machine, this may give you an error. You can always change the port (e.g. 8885) in all the instructions if you need to.",Yt,Ie,Ft,ve,ss="With Visual Studio Code installed on your local machine, you can use the Remote-SSH command to edit and run files that are stored on a Neuron instance. See the VS Code article for additional details.",Dt,xe,ls="<li>Select Remote-SSH: Connect to Host… from the Command Palette (F1, ⇧⌘P)</li> <li>Enter in the full connection string from the ssh section above: ssh -i “/path/to/sshkey.pem” ubuntu@instance_ip_address</li> <li>VS Code should connect and automatically set up the VS Code server.</li> <li>Eventually, you should be prompted for a base directory. You can browse to a directory on the Neuron instance.</li> <li>In case you find that some commands seem greyed out in the menus, but the keyboard commands still work (⌘S to save or ^⇧` for terminal), you may need to restart VS Code.</li>",qt,be,Ot,je,as="Manual installation is useful in several scenarios:",Kt,$e,is="<li><strong>Using a newer version</strong>: Install the latest Optimum Neuron version that may not yet be available in the DLAMI</li> <li><strong>Custom AMI requirements</strong>: Working with your organization’s standard AMI or security-hardened images</li> <li><strong>Existing infrastructure</strong>: Adding Neuron support to pre-configured environments or Docker containers</li> <li><strong>Development setup</strong>: Installing pre-release or development versions for testing</li> <li><strong>Minimal installations</strong>: Creating lightweight environments with only required dependencies</li>",en,Ue,os="If you choose manual installation, you will need to ensure the Neuron drivers and tools are properly installed first.",tn,Ae,rs='Before installing <code>optimum-neuron</code> make sure that you have installed the Neuron driver and tools, check out <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/setup/torch-neuronx.html#setup-torch-neuronx" rel="nofollow">more detailed guide here</a>.',nn,Se,sn,ke,ps="Pointing to the AWS Neuron repository:",ln,_e,an,Le,on,Ne,rn,We,pn,Be,un,Ve,mn,Ze,us='Now that you have Optimum Neuron set up, check out the <strong><a href="./quickstart">Quickstart Guide</a></strong> to learn the basics of training and inference with Optimum Neuron.',cn,Qe,hn;return d=new y({props:{title:"EC2 Setup",local:"ec2-setup",headingTag:"h1"}}),C=new y({props:{title:"Recommended: AWS EC2 with Deep Learning AMI",local:"recommended-aws-ec2-with-deep-learning-ami",headingTag:"h2"}}),j=new y({props:{title:"Create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI",local:"create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami",headingTag:"h3"}}),U=new y({props:{title:"Find a supported region",local:"find-a-supported-region",headingTag:"h4"}}),_=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> boto3  
<span class="hljs-keyword">from</span> datetime <span class="hljs-keyword">import</span> datetime

ec2 = boto3.client(<span class="hljs-string">&#x27;ec2&#x27;</span>)  

regions = [region[<span class="hljs-string">&#x27;RegionName&#x27;</span>] <span class="hljs-keyword">for</span> region <span class="hljs-keyword">in</span> ec2.describe_regions()[<span class="hljs-string">&#x27;Regions&#x27;</span>]]  


<span class="hljs-comment">#Edit this line to change the instance types displayed  </span>
instance_types = [<span class="hljs-string">&#x27;trn1.32xlarge&#x27;</span>, <span class="hljs-string">&#x27;trn1.2xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.48xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.24xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.8xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.xlarge&#x27;</span>, <span class="hljs-string">&#x27;trn2.48xlarge&#x27;</span>]  
  
supported_regions = {}  
  
<span class="hljs-keyword">for</span> region <span class="hljs-keyword">in</span> regions:  
   ec2_region = boto3.client(<span class="hljs-string">&#x27;ec2&#x27;</span>, region_name=region)  
   response = ec2_region.describe_instance_type_offerings(  
      <span class="hljs-comment">#LocationType=&#x27;availability-zone&#x27;,  </span>
      Filters=[  
        {<span class="hljs-string">&#x27;Name&#x27;</span>: <span class="hljs-string">&#x27;instance-type&#x27;</span>, <span class="hljs-string">&#x27;Values&#x27;</span>: instance_types},  
      ]  
   )
   <span class="hljs-keyword">if</span> response[<span class="hljs-string">&#x27;InstanceTypeOfferings&#x27;</span>]:  
      supported_regions[region] = [offer[<span class="hljs-string">&#x27;InstanceType&#x27;</span>] <span class="hljs-keyword">for</span> offer <span class="hljs-keyword">in</span> response[<span class="hljs-string">&#x27;InstanceTypeOfferings&#x27;</span>]]  

<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;# Supported Regions as of&#x27;</span>,datetime.now().strftime(<span class="hljs-string">&#x27;%B %d, %Y&#x27;</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;================&#x27;</span>)  


client = boto3.client(<span class="hljs-string">&#x27;ssm&#x27;</span>)

<span class="hljs-keyword">for</span> region, instance_types <span class="hljs-keyword">in</span> supported_regions.items():
    <span class="hljs-keyword">try</span>:
        response = client.get_parameter(Name=<span class="hljs-string">f&#x27;/aws/service/global-infrastructure/regions/<span class="hljs-subst">{region}</span>/longName&#x27;</span>)
        region_long_name = response[<span class="hljs-string">&#x27;Parameter&#x27;</span>][<span class="hljs-string">&#x27;Value&#x27;</span>]
    <span class="hljs-keyword">except</span> (client.exceptions.ParameterNotFound, KeyError):
        region_long_name = region
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27; * <span class="hljs-subst">{region}</span>: <span class="hljs-subst">{region_long_name}</span>&#x27;</span>)
    <span class="hljs-keyword">for</span> instance_type <span class="hljs-keyword">in</span> instance_types:
      <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;  - <span class="hljs-subst">{instance_type}</span>&#x27;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;\\n&#x27;</span>) `,wrap:!1}}),L=new y({props:{title:"Increase service quota",local:"increase-service-quota",headingTag:"h4"}}),V=new y({props:{title:"Launch the Amazon EC2 instance with the HF DLAMI",local:"launch-the-amazon-ec2-instance-with-the-hf-dlami",headingTag:"h4"}}),ee=new y({props:{title:"Connect through SSH",local:"connect-through-ssh",headingTag:"h4"}}),le=new M({props:{code:"UFVCTElDX0ROUyUzRCUyMiUyMiUyMCUyMyUyMElQJTIwYWRkcmVzcyUwQUtFWV9QQVRIJTNEJTIyJTIyJTIwJTIzJTIwbG9jYWwlMjBwYXRoJTIwdG8lMjBrZXklMjBwYWlyJTBBJTBBc3NoJTIwLWklMjAlMjRLRVlfUEFUSCUyMHVidW50dSU0MCUyNFBVQkxJQ19ETlM=",highlighted:`PUBLIC_DNS=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># IP address</span>
KEY_PATH=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># local path to key pair</span>

ssh -i <span class="hljs-variable">$KEY_PATH</span> ubuntu@<span class="hljs-variable">$PUBLIC_DNS</span>`,wrap:!1}}),ie=new M({props:{code:"dWJ1bnR1JTQwaXAtMTcyLTMxLTc5LTE2NCUzQX4lMjQlMjBuZXVyb24tbHMlMEFpbnN0YW5jZS10eXBlJTNBJTIwdHJuMS4yeGxhcmdlJTBBaW5zdGFuY2UtaWQlM0ElMjBpLTA1NzA2MTVlNDE3MDBhNDgxJTBBJTJCLS0tLS0tLS0lMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0tJTJCJTBBJTdDJTIwTkVVUk9OJTIwJTdDJTIwTkVVUk9OJTIwJTdDJTIwTkVVUk9OJTIwJTdDJTIwJTIwJTIwUENJJTIwJTIwJTIwJTdDJTBBJTdDJTIwREVWSUNFJTIwJTdDJTIwQ09SRVMlMjAlMjAlN0MlMjBNRU1PUlklMjAlN0MlMjAlMjAlMjBCREYlMjAlMjAlMjAlN0MlMEElMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0lMkItLS0tLS0tLS0lMkIlMEElN0MlMjAwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMiUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDMyJTIwR0IlMjAlMjAlN0MlMjAwMCUzQTFlLjAlMjAlN0MlMEElMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0lMkItLS0tLS0tLS0lMkI=",highlighted:`ubuntu@ip<span class="hljs-number">-172</span><span class="hljs-number">-31</span><span class="hljs-number">-79</span><span class="hljs-number">-164</span><span class="hljs-punctuation">:</span>~$ neuron-ls
instance-type<span class="hljs-punctuation">:</span> trn1<span class="hljs-number">.2</span>xlarge
instance-id<span class="hljs-punctuation">:</span> i<span class="hljs-number">-0570615e41700</span>a481
+--------+--------+--------+---------+
| NEURON | NEURON | NEURON |   PCI   |
| DEVICE | CORES  | MEMORY |   BDF   |
+--------+--------+--------+---------+
| <span class="hljs-number">0</span>      | <span class="hljs-number">2</span>      | <span class="hljs-number">32</span> GB  | <span class="hljs-number">00</span><span class="hljs-punctuation">:</span><span class="hljs-number">1</span>e<span class="hljs-number">.0</span> |
+--------+--------+--------+---------+`,wrap:!1}}),oe=new y({props:{title:"Set up your remote development environment",local:"set-up-your-remote-development-environment",headingTag:"h3"}}),me=new M({props:{code:"c3NoJTIwLWklMjAlMjIlMkZwYXRoJTJGdG8lMkZzc2hrZXkucGVtJTIyJTIwdWJ1bnR1JTQwaW5zdGFuY2VfaXBfYWRkcmVzcw==",highlighted:'ssh -i <span class="hljs-string">&quot;/path/to/sshkey.pem&quot;</span> ubuntu@instance_ip_address',wrap:!1}}),ce=new y({props:{title:"Access through Jupyter Notebook",local:"access-through-jupyter-notebook",headingTag:"h4"}}),we=new M({props:{code:"c3NoJTIwLWklMjAlMjIlMkZwYXRoJTJGdG8lMkZzc2hrZXkucGVtJTIyJTIwLU4lMjAtZiUyMC1MJTIwbG9jYWxob3N0JTNBODg4OCUzQWxvY2FsaG9zdCUzQTg4ODglMjB1YnVudHUlNDBpbnN0YW5jZV9pcF9hZGRyZXNz",highlighted:'ssh -i <span class="hljs-string">&quot;/path/to/sshkey.pem&quot;</span> -N -f -L localhost:8888:localhost:8888 ubuntu@instance_ip_address',wrap:!1}}),Me=new M({props:{code:"bm9odXAlMjBqdXB5dGVyJTIwbm90ZWJvb2slMjAtLW5vLWJyb3dzZXIlMjAtLXBvcnQlM0Q4ODg4",highlighted:'<span class="hljs-built_in">nohup</span> jupyter notebook --no-browser --port=8888',wrap:!1}}),de=new M({props:{code:"Y2F0JTIwbm9odXAub3V0JTIwJTdDJTIwZ3JlcCUyMGxvY2FsaG9zdA==",highlighted:'<span class="hljs-built_in">cat</span> nohup.out | grep localhost',wrap:!1}}),Ie=new y({props:{title:"Access through VS Code remote server",local:"access-through-vs-code-remote-server",headingTag:"h4"}}),be=new y({props:{title:"Alternative: Manual Installation",local:"alternative-manual-installation",headingTag:"h2"}}),Se=new y({props:{title:"Adding pip packages URL",local:"adding-pip-packages-url",headingTag:"h3"}}),_e=new M({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBjb25maWclMjBzZXQlMjBnbG9iYWwuZXh0cmEtaW5kZXgtdXJsJTIwaHR0cHMlM0ElMkYlMkZwaXAucmVwb3MubmV1cm9uLmFtYXpvbmF3cy5jb20=",highlighted:'python -m pip config <span class="hljs-built_in">set</span> global.extra-index-url https://pip.repos.neuron.amazonaws.com',wrap:!1}}),Le=new y({props:{title:"Installing optimum-neuron for AWS Trainium ( trn1 ) or AWS inferentia2 ( inf2 )",local:"installing-optimum-neuron-for-aws-trainium--trn1--or-aws-inferentia2--inf2-",headingTag:"h3"}}),Ne=new M({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwb3B0aW11bS1uZXVyb24lNUJuZXVyb254JTVE",highlighted:"python -m pip install optimum-neuron[neuronx]",wrap:!1}}),We=new y({props:{title:"Installing optimum-neuron for AWS inferentia ( inf1 )",local:"installing-optimum-neuron-for-aws-inferentia--inf1-",headingTag:"h3"}}),Be=new M({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwb3B0aW11bS1uZXVyb24lNUJuZXVyb24lNUQ=",highlighted:"python -m pip install optimum-neuron[neuron]",wrap:!1}}),Ve=new y({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),{c(){g=i("meta"),ze=l(),He=i("p"),Ge=l(),p(d.$$.fragment),Re=l(),T=i("p"),T.textContent=wn,Xe=l(),J=i("ol"),J.innerHTML=yn,Pe=l(),p(C.$$.fragment),Ye=l(),I=i("p"),I.innerHTML=Mn,Fe=l(),v=i("p"),v.innerHTML=gn,De=l(),x=i("p"),x.textContent=dn,qe=l(),b=i("ol"),b.innerHTML=Tn,Oe=l(),p(j.$$.fragment),Ke=l(),$=i("p"),$.textContent=Jn,et=l(),p(U.$$.fragment),tt=l(),A=i("p"),A.textContent=Cn,nt=l(),S=i("ul"),S.innerHTML=In,st=l(),k=i("p"),k.textContent=vn,lt=l(),p(_.$$.fragment),at=l(),p(L.$$.fragment),it=l(),N=i("p"),N.textContent=xn,ot=l(),W=i("p"),W.textContent=bn,rt=l(),B=i("p"),B.textContent=jn,pt=l(),p(V.$$.fragment),ut=l(),Z=i("p"),Z.textContent=$n,mt=l(),E=i("p"),E.innerHTML=Un,ct=l(),H=i("img"),ht=l(),Q=i("p"),Q.textContent=Sn,ft=l(),z=i("img"),wt=l(),G=i("p"),G.innerHTML=_n,yt=l(),R=i("img"),Mt=l(),X=i("p"),X.innerHTML=Nn,gt=l(),P=i("p"),P.innerHTML=Wn,dt=l(),Y=i("img"),Tt=l(),F=i("p"),F.innerHTML=Vn,Jt=l(),D=i("img"),Ct=l(),q=i("p"),q.textContent=En,It=l(),O=i("img"),vt=l(),K=i("p"),K.innerHTML=Qn,xt=l(),p(ee.$$.fragment),bt=l(),te=i("p"),te.innerHTML=zn,jt=l(),ne=i("img"),$t=l(),se=i("p"),se.innerHTML=Rn,Ut=l(),p(le.$$.fragment),At=l(),ae=i("p"),ae.innerHTML=Xn,St=l(),p(ie.$$.fragment),kt=l(),p(oe.$$.fragment),_t=l(),re=i("p"),re.textContent=Pn,Lt=l(),pe=i("p"),pe.textContent=Yn,Nt=l(),ue=i("p"),ue.textContent=Fn,Wt=l(),p(me.$$.fragment),Bt=l(),p(ce.$$.fragment),Vt=l(),he=i("p"),he.textContent=Dn,Zt=l(),fe=i("p"),fe.textContent=qn,Et=l(),p(we.$$.fragment),Ht=l(),ye=i("p"),ye.textContent=On,Qt=l(),p(Me.$$.fragment),zt=l(),ge=i("p"),ge.textContent=Kn,Gt=l(),p(de.$$.fragment),Rt=l(),Te=i("p"),Te.textContent=es,Xt=l(),Je=i("p"),Je.textContent=ts,Pt=l(),Ce=i("p"),Ce.textContent=ns,Yt=l(),p(Ie.$$.fragment),Ft=l(),ve=i("p"),ve.textContent=ss,Dt=l(),xe=i("ol"),xe.innerHTML=ls,qt=l(),p(be.$$.fragment),Ot=l(),je=i("p"),je.textContent=as,Kt=l(),$e=i("ul"),$e.innerHTML=is,en=l(),Ue=i("p"),Ue.textContent=os,tn=l(),Ae=i("p"),Ae.innerHTML=rs,nn=l(),p(Se.$$.fragment),sn=l(),ke=i("p"),ke.textContent=ps,ln=l(),p(_e.$$.fragment),an=l(),p(Le.$$.fragment),on=l(),p(Ne.$$.fragment),rn=l(),p(We.$$.fragment),pn=l(),p(Be.$$.fragment),un=l(),p(Ve.$$.fragment),mn=l(),Ze=i("p"),Ze.innerHTML=us,cn=l(),Qe=i("p"),this.h()},l(e){const t=Ms("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(n),ze=a(e),He=o(e,"P",{}),ms(He).forEach(n),Ge=a(e),u(d.$$.fragment,e),Re=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-ppiuvg"&&(T.textContent=wn),Xe=a(e),J=o(e,"OL",{"data-svelte-h":!0}),r(J)!=="svelte-bfl7te"&&(J.innerHTML=yn),Pe=a(e),u(C.$$.fragment,e),Ye=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1gnzyei"&&(I.innerHTML=Mn),Fe=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1g253ra"&&(v.innerHTML=gn),De=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-zcjb5i"&&(x.textContent=dn),qe=a(e),b=o(e,"OL",{"data-svelte-h":!0}),r(b)!=="svelte-aa5c1n"&&(b.innerHTML=Tn),Oe=a(e),u(j.$$.fragment,e),Ke=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1y0w0e0"&&($.textContent=Jn),et=a(e),u(U.$$.fragment,e),tt=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-19mf0fu"&&(A.textContent=Cn),nt=a(e),S=o(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1ur9ox2"&&(S.innerHTML=In),st=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-cd8ooq"&&(k.textContent=vn),lt=a(e),u(_.$$.fragment,e),at=a(e),u(L.$$.fragment,e),it=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-mu91xn"&&(N.textContent=xn),ot=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1oqd42e"&&(W.textContent=bn),rt=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-tmf6ga"&&(B.textContent=jn),pt=a(e),u(V.$$.fragment,e),ut=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-r3bcy6"&&(Z.textContent=$n),mt=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-50wzvt"&&(E.innerHTML=Un),ct=a(e),H=o(e,"IMG",{src:!0,alt:!0}),ht=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-7wwfcf"&&(Q.textContent=Sn),ft=a(e),z=o(e,"IMG",{src:!0,alt:!0}),wt=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-cgjl8t"&&(G.innerHTML=_n),yt=a(e),R=o(e,"IMG",{src:!0,alt:!0}),Mt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-11azj2p"&&(X.innerHTML=Nn),gt=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1j7ptbp"&&(P.innerHTML=Wn),dt=a(e),Y=o(e,"IMG",{src:!0,alt:!0}),Tt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-jwe09q"&&(F.innerHTML=Vn),Jt=a(e),D=o(e,"IMG",{src:!0,alt:!0}),Ct=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1hnrw8h"&&(q.textContent=En),It=a(e),O=o(e,"IMG",{src:!0,alt:!0}),vt=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-yyg7kn"&&(K.innerHTML=Qn),xt=a(e),u(ee.$$.fragment,e),bt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-dpbyx7"&&(te.innerHTML=zn),jt=a(e),ne=o(e,"IMG",{src:!0,alt:!0}),$t=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-pmoe5"&&(se.innerHTML=Rn),Ut=a(e),u(le.$$.fragment,e),At=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1jd2fkg"&&(ae.innerHTML=Xn),St=a(e),u(ie.$$.fragment,e),kt=a(e),u(oe.$$.fragment,e),_t=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-va0ciz"&&(re.textContent=Pn),Lt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-20tg3z"&&(pe.textContent=Yn),Nt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-14ylm5t"&&(ue.textContent=Fn),Wt=a(e),u(me.$$.fragment,e),Bt=a(e),u(ce.$$.fragment,e),Vt=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-16s9nvc"&&(he.textContent=Dn),Zt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-s72xtc"&&(fe.textContent=qn),Et=a(e),u(we.$$.fragment,e),Ht=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-l0sx97"&&(ye.textContent=On),Qt=a(e),u(Me.$$.fragment,e),zt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1fn6l5y"&&(ge.textContent=Kn),Gt=a(e),u(de.$$.fragment,e),Rt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-ou1jyu"&&(Te.textContent=es),Xt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1965vx"&&(Je.textContent=ts),Pt=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-165fa3p"&&(Ce.textContent=ns),Yt=a(e),u(Ie.$$.fragment,e),Ft=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-bzwe4m"&&(ve.textContent=ss),Dt=a(e),xe=o(e,"OL",{"data-svelte-h":!0}),r(xe)!=="svelte-c41b6w"&&(xe.innerHTML=ls),qt=a(e),u(be.$$.fragment,e),Ot=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1qjg0mm"&&(je.textContent=as),Kt=a(e),$e=o(e,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-204tif"&&($e.innerHTML=is),en=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-134n78l"&&(Ue.textContent=os),tn=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1xl7fn1"&&(Ae.innerHTML=rs),nn=a(e),u(Se.$$.fragment,e),sn=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1fuys5u"&&(ke.textContent=ps),ln=a(e),u(_e.$$.fragment,e),an=a(e),u(Le.$$.fragment,e),on=a(e),u(Ne.$$.fragment,e),rn=a(e),u(We.$$.fragment,e),pn=a(e),u(Be.$$.fragment,e),un=a(e),u(Ve.$$.fragment,e),mn=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1yywgqb"&&(Ze.innerHTML=us),cn=a(e),Qe=o(e,"P",{}),ms(Qe).forEach(n),this.h()},h(){w(g,"name","hf:doc:metadata"),w(g,"content",Ts),Ee(H.src,An="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/01-name-instance.png")||w(H,"src",An),w(H,"alt","name instance"),Ee(z.src,kn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/02-search-ami.png")||w(z,"src",kn),w(z,"alt","search ami"),Ee(R.src,Ln="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/03-select-ami.png")||w(R,"src",Ln),w(R,"alt","select ami"),Ee(Y.src,Bn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/04-select-key.png")||w(Y,"src",Bn),w(Y,"alt","select ssh key"),Ee(D.src,Zn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/05-select-sg.png")||w(D,"src",Zn),w(D,"alt","select security group"),Ee(O.src,Hn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/06-launch-instance.png")||w(O,"src",Hn),w(O,"alt","select ssh key"),Ee(ne.src,Gn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/07-copy-dns.png")||w(ne,"src",Gn),w(ne,"alt","select public dns")},m(e,t){gs(document.head,g),s(e,ze,t),s(e,He,t),s(e,Ge,t),m(d,e,t),s(e,Re,t),s(e,T,t),s(e,Xe,t),s(e,J,t),s(e,Pe,t),m(C,e,t),s(e,Ye,t),s(e,I,t),s(e,Fe,t),s(e,v,t),s(e,De,t),s(e,x,t),s(e,qe,t),s(e,b,t),s(e,Oe,t),m(j,e,t),s(e,Ke,t),s(e,$,t),s(e,et,t),m(U,e,t),s(e,tt,t),s(e,A,t),s(e,nt,t),s(e,S,t),s(e,st,t),s(e,k,t),s(e,lt,t),m(_,e,t),s(e,at,t),m(L,e,t),s(e,it,t),s(e,N,t),s(e,ot,t),s(e,W,t),s(e,rt,t),s(e,B,t),s(e,pt,t),m(V,e,t),s(e,ut,t),s(e,Z,t),s(e,mt,t),s(e,E,t),s(e,ct,t),s(e,H,t),s(e,ht,t),s(e,Q,t),s(e,ft,t),s(e,z,t),s(e,wt,t),s(e,G,t),s(e,yt,t),s(e,R,t),s(e,Mt,t),s(e,X,t),s(e,gt,t),s(e,P,t),s(e,dt,t),s(e,Y,t),s(e,Tt,t),s(e,F,t),s(e,Jt,t),s(e,D,t),s(e,Ct,t),s(e,q,t),s(e,It,t),s(e,O,t),s(e,vt,t),s(e,K,t),s(e,xt,t),m(ee,e,t),s(e,bt,t),s(e,te,t),s(e,jt,t),s(e,ne,t),s(e,$t,t),s(e,se,t),s(e,Ut,t),m(le,e,t),s(e,At,t),s(e,ae,t),s(e,St,t),m(ie,e,t),s(e,kt,t),m(oe,e,t),s(e,_t,t),s(e,re,t),s(e,Lt,t),s(e,pe,t),s(e,Nt,t),s(e,ue,t),s(e,Wt,t),m(me,e,t),s(e,Bt,t),m(ce,e,t),s(e,Vt,t),s(e,he,t),s(e,Zt,t),s(e,fe,t),s(e,Et,t),m(we,e,t),s(e,Ht,t),s(e,ye,t),s(e,Qt,t),m(Me,e,t),s(e,zt,t),s(e,ge,t),s(e,Gt,t),m(de,e,t),s(e,Rt,t),s(e,Te,t),s(e,Xt,t),s(e,Je,t),s(e,Pt,t),s(e,Ce,t),s(e,Yt,t),m(Ie,e,t),s(e,Ft,t),s(e,ve,t),s(e,Dt,t),s(e,xe,t),s(e,qt,t),m(be,e,t),s(e,Ot,t),s(e,je,t),s(e,Kt,t),s(e,$e,t),s(e,en,t),s(e,Ue,t),s(e,tn,t),s(e,Ae,t),s(e,nn,t),m(Se,e,t),s(e,sn,t),s(e,ke,t),s(e,ln,t),m(_e,e,t),s(e,an,t),m(Le,e,t),s(e,on,t),m(Ne,e,t),s(e,rn,t),m(We,e,t),s(e,pn,t),m(Be,e,t),s(e,un,t),m(Ve,e,t),s(e,mn,t),s(e,Ze,t),s(e,cn,t),s(e,Qe,t),hn=!0},p:hs,i(e){hn||(c(d.$$.fragment,e),c(C.$$.fragment,e),c(j.$$.fragment,e),c(U.$$.fragment,e),c(_.$$.fragment,e),c(L.$$.fragment,e),c(V.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(we.$$.fragment,e),c(Me.$$.fragment,e),c(de.$$.fragment,e),c(Ie.$$.fragment,e),c(be.$$.fragment,e),c(Se.$$.fragment,e),c(_e.$$.fragment,e),c(Le.$$.fragment,e),c(Ne.$$.fragment,e),c(We.$$.fragment,e),c(Be.$$.fragment,e),c(Ve.$$.fragment,e),hn=!0)},o(e){h(d.$$.fragment,e),h(C.$$.fragment,e),h(j.$$.fragment,e),h(U.$$.fragment,e),h(_.$$.fragment,e),h(L.$$.fragment,e),h(V.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(Ie.$$.fragment,e),h(be.$$.fragment,e),h(Se.$$.fragment,e),h(_e.$$.fragment,e),h(Le.$$.fragment,e),h(Ne.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),hn=!1},d(e){e&&(n(ze),n(He),n(Ge),n(Re),n(T),n(Xe),n(J),n(Pe),n(Ye),n(I),n(Fe),n(v),n(De),n(x),n(qe),n(b),n(Oe),n(Ke),n($),n(et),n(tt),n(A),n(nt),n(S),n(st),n(k),n(lt),n(at),n(it),n(N),n(ot),n(W),n(rt),n(B),n(pt),n(ut),n(Z),n(mt),n(E),n(ct),n(H),n(ht),n(Q),n(ft),n(z),n(wt),n(G),n(yt),n(R),n(Mt),n(X),n(gt),n(P),n(dt),n(Y),n(Tt),n(F),n(Jt),n(D),n(Ct),n(q),n(It),n(O),n(vt),n(K),n(xt),n(bt),n(te),n(jt),n(ne),n($t),n(se),n(Ut),n(At),n(ae),n(St),n(kt),n(_t),n(re),n(Lt),n(pe),n(Nt),n(ue),n(Wt),n(Bt),n(Vt),n(he),n(Zt),n(fe),n(Et),n(Ht),n(ye),n(Qt),n(zt),n(ge),n(Gt),n(Rt),n(Te),n(Xt),n(Je),n(Pt),n(Ce),n(Yt),n(Ft),n(ve),n(Dt),n(xe),n(qt),n(Ot),n(je),n(Kt),n($e),n(en),n(Ue),n(tn),n(Ae),n(nn),n(sn),n(ke),n(ln),n(an),n(on),n(rn),n(pn),n(un),n(mn),n(Ze),n(cn),n(Qe)),n(g),f(d,e),f(C,e),f(j,e),f(U,e),f(_,e),f(L,e),f(V,e),f(ee,e),f(le,e),f(ie,e),f(oe,e),f(me,e),f(ce,e),f(we,e),f(Me,e),f(de,e),f(Ie,e),f(be,e),f(Se,e),f(_e,e),f(Le,e),f(Ne,e),f(We,e),f(Be,e),f(Ve,e)}}}const Ts='{"title":"EC2 Setup","local":"ec2-setup","sections":[{"title":"Recommended: AWS EC2 with Deep Learning AMI","local":"recommended-aws-ec2-with-deep-learning-ami","sections":[{"title":"Create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI","local":"create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami","sections":[{"title":"Find a supported region","local":"find-a-supported-region","sections":[],"depth":4},{"title":"Increase service quota","local":"increase-service-quota","sections":[],"depth":4},{"title":"Launch the Amazon EC2 instance with the HF DLAMI","local":"launch-the-amazon-ec2-instance-with-the-hf-dlami","sections":[],"depth":4},{"title":"Connect through SSH","local":"connect-through-ssh","sections":[],"depth":4}],"depth":3},{"title":"Set up your remote development environment","local":"set-up-your-remote-development-environment","sections":[{"title":"Access through Jupyter Notebook","local":"access-through-jupyter-notebook","sections":[],"depth":4},{"title":"Access through VS Code remote server","local":"access-through-vs-code-remote-server","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Alternative: Manual Installation","local":"alternative-manual-installation","sections":[{"title":"Adding pip packages URL","local":"adding-pip-packages-url","sections":[],"depth":3},{"title":"Installing optimum-neuron for AWS Trainium ( trn1 ) or AWS inferentia2 ( inf2 )","local":"installing-optimum-neuron-for-aws-trainium--trn1--or-aws-inferentia2--inf2-","sections":[],"depth":3},{"title":"Installing optimum-neuron for AWS inferentia ( inf1 )","local":"installing-optimum-neuron-for-aws-inferentia--inf1-","sections":[],"depth":3}],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function Js(fn){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ws{constructor(g){super(),ys(this,g,Js,ds,cs,{})}}export{bs as component};
