import{s as St,n as vt,o as Yt}from"../chunks/scheduler.8c3d61f6.js";import{S as Ft,i as Nt,g as a,s as i,r as d,A as $t,h as o,f as t,c as n,j as Vt,u as M,x as p,k as gt,y as Et,a as s,v as c,d as r,t as f,w as m}from"../chunks/index.da70eac4.js";import{C as J}from"../chunks/CodeBlock.a9c4becf.js";import{H as u,E as Lt}from"../chunks/getInferenceSnippets.725ed3d4.js";function Dt(Pl){let T,Ve,Be,ge,y,Se,U,Kl='Modular Diffusers is a framework for quickly building flexible and customizable pipelines. At the core of Modular Diffusers are <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> that can be combined with other blocks to adapt to new workflows. The blocks are converted into a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>, a friendly user-facing interface developers can use.',ve,w,Ol='This doc will show you how to implement a <a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> pipeline with the modular framework.',Ye,b,Fe,Z,et='<a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> are <em>definitions</em> that specify the components, inputs, outputs, and computation logic for a single step in a pipeline. There are four types of blocks.',Ne,h,lt='<li><a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline_blocks#diffusers.ModularPipelineBlocks">ModularPipelineBlocks</a> is the most basic block for a single step.</li> <li><code>SequentialPipelineBlocks</code> is a multi-block that composes other blocks linearly. The outputs of one block are the inputs to the next block.</li> <li><code>LoopSequentialPipelineBlocks</code> is a multi-block that runs iteratively and is designed for iterative workflows.</li> <li><code>AutoPipelineBlocks</code> is a collection of blocks for different workflows and it selects which block to run based on the input. It is designed to conveniently package multiple workflows into a single pipeline.</li>',$e,I,tt='<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> is an image-to-image workflow. Start with the <code>IMAGE2IMAGE_BLOCKS</code> preset, a collection of <code>ModularPipelineBlocks</code> for image-to-image generation.',Ee,j,Le,k,De,R,st="Modular Diffusers uses <em>state</em> to communicate data between blocks. There are two types of states.",Qe,_,it="<li><code>PipelineState</code> is a global state that can be used to track all inputs and outputs across all blocks.</li> <li><code>BlockState</code> is a local view of relevant variables from <code>PipelineState</code> for an individual block.</li>",Ae,G,ze,C,nt='<a href="https://differential-diffusion.github.io/" rel="nofollow">Differential Diffusion</a> differs from standard image-to-image in its <code>prepare_latents</code> and <code>denoise</code> blocks. All the other blocks can be reused, but you’ll need to modify these two.',He,X,at="Create placeholder <code>ModularPipelineBlocks</code> for <code>prepare_latents</code> and <code>denoise</code> by copying and modifying the existing ones.",xe,B,ot="Print the <code>denoise</code> block to see that it is composed of <code>LoopSequentialPipelineBlocks</code> with three sub-blocks, <code>before_denoiser</code>, <code>denoiser</code>, and <code>after_denoiser</code>. Only the <code>before_denoiser</code> sub-block needs to be modified to prepare the latent input for the denoiser based on the change map.",qe,W,Pe,V,pt="Replace the <code>StableDiffusionXLLoopBeforeDenoiser</code> sub-block with the new <code>SDXLDiffDiffLoopBeforeDenoiser</code> block.",Ke,g,Oe,S,el,v,dt="The <code>prepare_latents</code> block requires the following changes.",ll,Y,Mt="<li>a processor to process the change map</li> <li>a new <code>inputs</code> to accept the user-provided change map, <code>timestep</code> for precomputing all the latents and <code>num_inference_steps</code> to create the mask for updating the image regions</li> <li>update the computation in the <code>__call__</code> method for processing the change map and creating the masks, and storing it in the <code>BlockState</code></li>",tl,F,sl,N,il,$,ct="The <code>before_denoiser</code> sub-block requires the following changes.",nl,E,rt="<li>a new <code>inputs</code> to accept a <code>denoising_start</code> parameter,  <code>original_latents</code> and <code>diffdiff_masks</code> from the <code>prepare_latents</code> block</li> <li>update the computation in the <code>__call__</code> method for applying Differential Diffusion</li>",al,L,ol,D,pl,Q,ft='You should have all the blocks you need at this point to create a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>.',dl,A,mt="Copy the existing <code>IMAGE2IMAGE_BLOCKS</code> preset and for the <code>set_timesteps</code> block, use the <code>set_timesteps</code> from the <code>TEXT2IMAGE_BLOCKS</code> because Differential Diffusion doesn’t require a <code>strength</code> parameter.",Ml,z,Jt="Set the <code>prepare_latents</code> and <code>denoise</code> blocks to the <code>SDXLDiffDiffPrepareLatentsStep</code> and <code>SDXLDiffDiffDenoiseStep</code> blocks you just modified.",cl,H,ut="Call <code>SequentialPipelineBlocks.from_blocks_dict</code> on the blocks to create a <code>SequentialPipelineBlocks</code>.",rl,x,fl,q,ml,P,Tt='Convert the <code>SequentialPipelineBlocks</code> into a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> with the <code>ModularPipeline.init_pipeline</code> method. This initializes the expected components to load from a <code>modular_model_index.json</code> file. Explicitly load the components by calling <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_default_components">ModularPipeline.load_default_components()</a>.',Jl,K,yt='It is a good idea to initialize the <code>ComponentManager</code> with the pipeline to help manage the different components. Once you call <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_default_components">load_default_components()</a>, the components are registered to the <code>ComponentManager</code> and can be shared between workflows. The example below uses the <code>collection</code> argument to assign the components a <code>&quot;diffdiff&quot;</code> label for better organization.',ul,O,Tl,ee,yl,le,Ut='Other workflows can be added to the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> to support additional features without rewriting the entire pipeline from scratch.',Ul,te,wt="This section demonstrates how to add an IP-Adapter or ControlNet.",wl,se,bl,ie,bt="Stable Diffusion XL already has a preset IP-Adapter block that you can use and doesn’t require any changes to the existing Differential Diffusion pipeline.",Zl,ne,hl,ae,Zt='Use the <code>sub_blocks.insert</code> method to insert it into the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a>. The example below inserts the <code>ip_adapter_block</code> at position <code>0</code>. Print the pipeline to see that the <code>ip_adapter_block</code> is added and it requires an <code>ip_adapter_image</code>. This also added two components to the pipeline, the <code>image_encoder</code> and <code>feature_extractor</code>.',Il,oe,jl,pe,ht='Call <code>~ModularPipeline.init_pipeline</code> to initialize a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> and use <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_default_components">load_default_components()</a> to load the model components. Load and set the IP-Adapter to run the pipeline.',kl,de,Rl,Me,_l,ce,It="Stable Diffusion XL already has a preset ControlNet block that can readily be used.",Gl,re,Cl,fe,jt="However, it requires modifying the <code>denoise</code> block because that’s where the ControlNet injects the control information into the UNet.",Xl,me,kt="Modify the <code>denoise</code> block by replacing the <code>StableDiffusionXLLoopDenoiser</code> sub-block with the <code>StableDiffusionXLControlNetLoopDenoiser</code>.",Bl,Je,Wl,ue,Rt='Insert the <code>controlnet_input</code> block and replace the <code>denoise</code> block with the new <code>controlnet_denoise_block</code>. Initialize a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> and <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.load_default_components">load_default_components()</a> into it.',Vl,Te,gl,ye,Sl,Ue,_t='The Differential Diffusion, IP-Adapter, and ControlNet workflows can be bundled into a single <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> by using <code>AutoPipelineBlocks</code>. This allows automatically selecting which sub-blocks to run based on the inputs like <code>control_image</code> or <code>ip_adapter_image</code>. If none of these inputs are passed, then it defaults to the Differential Diffusion.',vl,we,Gt="Use <code>block_trigger_inputs</code> to only run the <code>SDXLDiffDiffControlNetDenoiseStep</code> block if a <code>control_image</code> input is provided. Otherwise, the <code>SDXLDiffDiffDenoiseStep</code> is used.",Yl,be,Fl,Ze,Ct="Add the <code>ip_adapter</code> and <code>controlnet_input</code> blocks.",Nl,he,$l,Ie,Xt='Call <code>SequentialPipelineBlocks.from_blocks_dict</code> to create a <code>SequentialPipelineBlocks</code> and create a <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> and load in the model components to run.',El,je,Ll,ke,Dl,Re,Bt='Add your <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> to the Hub with <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.save_pretrained">save_pretrained()</a> and set <code>push_to_hub</code> argument to <code>True</code>.',Ql,_e,Al,Ge,Wt='Other users can load the <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline">ModularPipeline</a> with <a href="/docs/diffusers/main/en/api/modular_diffusers/pipeline#diffusers.ModularPipeline.from_pretrained">from_pretrained()</a>.',zl,Ce,Hl,Xe,xl,We,ql;return y=new u({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),b=new u({props:{title:"ModularPipelineBlocks",local:"modularpipelineblocks",headingTag:"h2"}}),j=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwSU1BR0UySU1BR0VfQkxPQ0tTJTBBSU1BR0UySU1BR0VfQkxPQ0tTJTIwJTNEJTIwSW5zZXJ0YWJsZURpY3QoJTVCJTBBJTIwJTIwJTIwJTIwKCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMVGV4dEVuY29kZXJTdGVwKSUyQyUwQSUyMCUyMCUyMCUyMCglMjJpbWFnZV9lbmNvZGVyJTIyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExWYWVFbmNvZGVyU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyaW5wdXQlMjIlMkMlMjBTdGFibGVEaWZmdXNpb25YTElucHV0U3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyc2V0X3RpbWVzdGVwcyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1NldFRpbWVzdGVwc1N0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMnByZXBhcmVfbGF0ZW50cyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIycHJlcGFyZV9hZGRfY29uZCUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVBZGRpdGlvbmFsQ29uZGl0aW9uaW5nU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyZGVub2lzZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZVN0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMmRlY29kZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVjb2RlU3RlcCklMEElNUQp",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> IMAGE2IMAGE_BLOCKS
IMAGE2IMAGE_BLOCKS = InsertableDict([
    (<span class="hljs-string">&quot;text_encoder&quot;</span>, StableDiffusionXLTextEncoderStep),
    (<span class="hljs-string">&quot;image_encoder&quot;</span>, StableDiffusionXLVaeEncoderStep),
    (<span class="hljs-string">&quot;input&quot;</span>, StableDiffusionXLInputStep),
    (<span class="hljs-string">&quot;set_timesteps&quot;</span>, StableDiffusionXLImg2ImgSetTimestepsStep),
    (<span class="hljs-string">&quot;prepare_latents&quot;</span>, StableDiffusionXLImg2ImgPrepareLatentsStep),
    (<span class="hljs-string">&quot;prepare_add_cond&quot;</span>, StableDiffusionXLImg2ImgPrepareAdditionalConditioningStep),
    (<span class="hljs-string">&quot;denoise&quot;</span>, StableDiffusionXLDenoiseStep),
    (<span class="hljs-string">&quot;decode&quot;</span>, StableDiffusionXLDecodeStep)
])`,wrap:!1}}),k=new u({props:{title:"Pipeline and block states",local:"pipeline-and-block-states",headingTag:"h2"}}),G=new u({props:{title:"Customizing blocks",local:"customizing-blocks",headingTag:"h2"}}),W=new J({props:{code:"ZGVub2lzZV9ibG9ja3MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEKCklMEFwcmludChkZW5vaXNlX2Jsb2Nrcyk=",highlighted:`denoise_blocks = IMAGE2IMAGE_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>]()
<span class="hljs-built_in">print</span>(denoise_blocks)`,wrap:!1}}),g=new J({props:{code:"JTIzJTIwQ29weSUyMGV4aXN0aW5nJTIwYmxvY2tzJTIwYXMlMjBwbGFjZWhvbGRlcnMlMEFjbGFzcyUyMFNEWExEaWZmRGlmZlByZXBhcmVMYXRlbnRzU3RlcChNb2R1bGFyUGlwZWxpbmVCbG9ja3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ29waWVkJTIwZnJvbSUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCUyMC0lMjB3aWxsJTIwbW9kaWZ5JTIwbGF0ZXIlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBzYW1lJTIwaW1wbGVtZW50YXRpb24lMjBhcyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCUwQSUwQWNsYXNzJTIwU0RYTERpZmZEaWZmRGVub2lzZVN0ZXAoU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIpJTNBJTBBJTIwJTIwJTIwJTIwYmxvY2tfY2xhc3NlcyUyMCUzRCUyMCU1QlNEWExEaWZmRGlmZkxvb3BCZWZvcmVEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMTG9vcERlbm9pc2VyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExMb29wQWZ0ZXJEZW5vaXNlciU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX25hbWVzJTIwJTNEJTIwJTVCJTIyYmVmb3JlX2Rlbm9pc2VyJTIyJTJDJTIwJTIyZGVub2lzZXIlMjIlMkMlMjAlMjJhZnRlcl9kZW5vaXNlciUyMiU1RA==",highlighted:`<span class="hljs-comment"># Copy existing blocks as placeholders</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffPrepareLatentsStep</span>(<span class="hljs-title class_ inherited__">ModularPipelineBlocks</span>):
    <span class="hljs-string">&quot;&quot;&quot;Copied from StableDiffusionXLImg2ImgPrepareLatentsStep - will modify later&quot;&quot;&quot;</span>
    <span class="hljs-comment"># ... same implementation as StableDiffusionXLImg2ImgPrepareLatentsStep</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLLoopDenoiser, StableDiffusionXLLoopAfterDenoiser]
    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]`,wrap:!1}}),S=new u({props:{title:"prepare_latents",local:"preparelatents",headingTag:"h3"}}),F=new J({props:{code:"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",highlighted:`class SDXLDiffDiffPrepareLatentsStep(ModularPipelineBlocks):
    @property
    def expected_components(self) -&gt; List[ComponentSpec]:
        return [
            ComponentSpec(&quot;vae&quot;, AutoencoderKL),
            ComponentSpec(&quot;scheduler&quot;, EulerDiscreteScheduler),
<span class="hljs-addition">+           ComponentSpec(&quot;mask_processor&quot;, VaeImageProcessor, config=FrozenDict({&quot;do_normalize&quot;: False, &quot;do_convert_grayscale&quot;: True}))</span>
        ]
    @property
    def inputs(self) -&gt; List[Tuple[str, Any]]:
        return [
            InputParam(&quot;generator&quot;),
<span class="hljs-addition">+           InputParam(&quot;diffdiff_map&quot;, required=True),</span>
<span class="hljs-deletion">-           InputParam(&quot;latent_timestep&quot;, required=True, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;timesteps&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;num_inference_steps&quot;, type_hint=int),</span>
        ]

    @property
    def intermediate_outputs(self) -&gt; List[OutputParam]:
        return [
<span class="hljs-addition">+           OutputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           OutputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]
    def __call__(self, components, state: PipelineState):
        # ... existing logic ...
<span class="hljs-addition">+       # Process change map and create masks</span>
<span class="hljs-addition">+       diffdiff_map = components.mask_processor.preprocess(block_state.diffdiff_map, height=latent_height, width=latent_width)</span>
<span class="hljs-addition">+       thresholds = torch.arange(block_state.num_inference_steps, dtype=diffdiff_map.dtype) / block_state.num_inference_steps</span>
<span class="hljs-addition">+       block_state.diffdiff_masks = diffdiff_map &gt; (thresholds + (block_state.denoising_start or 0))</span>
<span class="hljs-addition">+       block_state.original_latents = block_state.latents</span>`,wrap:!1}}),N=new u({props:{title:"denoise",local:"denoise",headingTag:"h3"}}),L=new J({props:{code:"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",highlighted:`class SDXLDiffDiffLoopBeforeDenoiser(ModularPipelineBlocks):
    @property
    def description(self) -&gt; str:
        return (
            &quot;Step within the denoising loop for differential diffusion that prepare the latent input for the denoiser&quot;
        )

    @property
    def inputs(self) -&gt; List[str]:
        return [
            InputParam(&quot;latents&quot;, required=True, type_hint=torch.Tensor),
<span class="hljs-addition">+           InputParam(&quot;denoising_start&quot;),</span>
<span class="hljs-addition">+           InputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]

    def __call__(self, components, block_state, i, t):
<span class="hljs-addition">+       # Apply differential diffusion logic</span>
<span class="hljs-addition">+       if i == 0 and block_state.denoising_start is None:</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[:1]</span>
<span class="hljs-addition">+       else:</span>
<span class="hljs-addition">+           block_state.mask = block_state.diffdiff_masks[i].unsqueeze(0).unsqueeze(1)</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[i] * block_state.mask + block_state.latents * (1 - block_state.mask)</span>

        # ... rest of existing logic ...`,wrap:!1}}),D=new u({props:{title:"Assembling the blocks",local:"assembling-the-blocks",headingTag:"h2"}}),x=new J({props:{code:"RElGRkRJRkZfQkxPQ0tTJTIwJTNEJTIwSU1BR0UySU1BR0VfQkxPQ0tTLmNvcHkoKSUwQURJRkZESUZGX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEJTIwJTNEJTIwU0RYTERpZmZEaWZmRGVub2lzZVN0ZXAlMEElMEFkZF9ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9CTE9DS1MpJTBBcHJpbnQoZGRfYmxvY2tzKQ==",highlighted:`DIFFDIFF_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffDenoiseStep

dd_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_BLOCKS)
<span class="hljs-built_in">print</span>(dd_blocks)`,wrap:!1}}),q=new u({props:{title:"ModularPipeline",local:"modularpipeline",headingTag:"h2"}}),O=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMENvbXBvbmVudHNNYW5hZ2VyJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMENvbXBvbmVudE1hbmFnZXIoKSUwQSUwQWRkX3BpcGVsaW5lJTIwJTNEJTIwZGRfYmxvY2tzLmluaXRfcGlwZWxpbmUoJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfZGVmYXVsdF9jb21wb25lbmV0cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGRfcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ComponentsManager

components = ComponentManager()

dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_default_componenets(torch_dtype=torch.float16)
dd_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),ee=new u({props:{title:"Adding workflows",local:"adding-workflows",headingTag:"h2"}}),se=new u({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h3"}}),ne=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLmVuY29kZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvSVBBZGFwdGVyU3RlcCUwQSUwQWlwX2FkYXB0ZXJfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9JUEFkYXB0ZXJTdGVwKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.encoders <span class="hljs-keyword">import</span> StableDiffusionXLAutoIPAdapterStep

ip_adapter_block = StableDiffusionXLAutoIPAdapterStep()`,wrap:!1}}),oe=new J({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmlwX2FkYXB0ZXIlMjIlMkMlMjBpcF9hZGFwdGVyX2Jsb2NrJTJDJTIwMCk=",highlighted:'dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, ip_adapter_block, <span class="hljs-number">0</span>)',wrap:!1}}),de=new J({props:{code:"ZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9ibG9ja3MuaW5pdF9waXBlbGluZSglMjJZaVlpWHUlMkZtb2R1bGFyLWRlbW8tYXV0byUyMiUyQyUyMGNvbGxlY3Rpb24lM0QlMjJkaWZmZGlmZiUyMiklMEFkZF9waXBlbGluZS5sb2FkX2RlZmF1bHRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGRfcGlwZWxpbmUubG9hZGVyLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2R4bF9tb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXJfc2R4bC5iaW4lMjIpJTBBZGRfcGlwZWxpbmUubG9hZGVyLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNiklMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX3BpcGVsaW5lLnRvKGRldmljZSklMEElMEFpcF9hZGFwdGVyX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmRpZmZfb3JhbmdlLmpwZWclMjIpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk96enlHVCUyRnRlc3RpbmctcmVzb3VyY2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmZXJlbnRpYWwlMkYyMDI0MDMyOTIxMTEyOV80MDI0OTExOTMwLnBuZyUzRmRvd25sb2FkJTNEdHJ1ZSUyMiklMEFtYXNrJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGZ3JhZGllbnRfbWFzay5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGdyZWVuJTIwcGVhciUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmJsdXJyeSUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0RkZXZpY2UpLm1hbnVhbF9zZWVkKDQyKSUwQSUwQWltYWdlJTIwJTNEJTIwZGRfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBkaWZmZGlmZl9tYXAlM0RtYXNrJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dCUzRCUyMmltYWdlcyUyMiUwQSklNUIwJTVE",highlighted:`dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_default_components(torch_dtype=torch.float16)
dd_pipeline.loader.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
dd_pipeline.loader.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
dd_pipeline = dd_pipeline.to(device)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_orange.jpeg&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>)

prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

image = dd_pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    ip_adapter_image=ip_adapter_image,
    diffdiff_map=mask,
    image=image,
    output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]`,wrap:!1}}),Me=new u({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),re=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLm1vZHVsYXJfYmxvY2tzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvQ29udHJvbE5ldElucHV0U3RlcCUwQSUwQWNvbnRyb2xfaW5wdXRfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9Db250cm9sTmV0SW5wdXRTdGVwKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.modular_blocks <span class="hljs-keyword">import</span> StableDiffusionXLAutoControlNetInputStep

control_input_block = StableDiffusionXLAutoControlNetInputStep()`,wrap:!1}}),Je=new J({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAoU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIpJTNBJTBBJTIwJTIwJTIwJTIwYmxvY2tfY2xhc3NlcyUyMCUzRCUyMCU1QlNEWExEaWZmRGlmZkxvb3BCZWZvcmVEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldExvb3BEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZUxvb3BBZnRlckRlbm9pc2VyJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfbmFtZXMlMjAlM0QlMjAlNUIlMjJiZWZvcmVfZGVub2lzZXIlMjIlMkMlMjAlMjJkZW5vaXNlciUyMiUyQyUyMCUyMmFmdGVyX2Rlbm9pc2VyJTIyJTVEJTBBJTBBY29udHJvbG5ldF9kZW5vaXNlX2Jsb2NrJTIwJTNEJTIwU0RYTERpZmZEaWZmQ29udHJvbE5ldERlbm9pc2VTdGVwKCk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffControlNetDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLControlNetLoopDenoiser, StableDiffusionXLDenoiseLoopAfterDenoiser]
    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]

controlnet_denoise_block = SDXLDiffDiffControlNetDenoiseStep()`,wrap:!1}}),Te=new J({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmNvbnRyb2xuZXRfaW5wdXQlMjIlMkMlMjBjb250cm9sX2lucHV0X2Jsb2NrJTJDJTIwNyklMEFkZF9ibG9ja3Muc3ViX2Jsb2NrcyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBjb250cm9sbmV0X2Rlbm9pc2VfYmxvY2slMEElMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2Jsb2Nrcy5pbml0X3BpcGVsaW5lKCUyMllpWWlYdSUyRm1vZHVsYXItZGVtby1hdXRvJTIyJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfZGVmYXVsdF9jb21wb25lbnRzKHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX3BpcGVsaW5lLnRvKGRldmljZSklMEElMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmRpZmZfdG9tYXRvX2Nhbm55LmpwZWclMjIpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk96enlHVCUyRnRlc3RpbmctcmVzb3VyY2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmZXJlbnRpYWwlMkYyMDI0MDMyOTIxMTEyOV80MDI0OTExOTMwLnBuZyUzRmRvd25sb2FkJTNEdHJ1ZSUyMiklMEFtYXNrJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGZ3JhZGllbnRfbWFzay5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGdyZWVuJTIwcGVhciUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmJsdXJyeSUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0RkZXZpY2UpLm1hbnVhbF9zZWVkKDQyKSUwQSUwQWltYWdlJTIwJTNEJTIwZGRfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbF9pbWFnZSUzRGNvbnRyb2xfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMGRpZmZkaWZmX21hcCUzRG1hc2slMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTNEJTIyaW1hZ2VzJTIyJTBBKSU1QjAlNUQ=",highlighted:`dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>, control_input_block, <span class="hljs-number">7</span>)
dd_blocks.sub_blocks[<span class="hljs-string">&quot;denoise&quot;</span>] = controlnet_denoise_block

dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_default_components(torch_dtype=torch.float16)
dd_pipeline = dd_pipeline.to(device)

control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_tomato_canny.jpeg&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>)

prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)

image = dd_pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    control_image=control_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
    diffdiff_map=mask,
    image=image,
    output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]`,wrap:!1}}),ye=new u({props:{title:"AutoPipelineBlocks",local:"autopipelineblocks",headingTag:"h3"}}),be=new J({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAoQXV0b1BpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMGJsb2NrX2NsYXNzZXMlMjAlM0QlMjAlNUJTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAlMkMlMjBTRFhMRGlmZkRpZmZEZW5vaXNlU3RlcCU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX25hbWVzJTIwJTNEJTIwJTVCJTIyY29udHJvbG5ldF9kZW5vaXNlJTIyJTJDJTIwJTIyZGVub2lzZSUyMiU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX3RyaWdnZXJfaW5wdXRzJTIwJTNEJTIwJTVCJTIyY29udHJvbG5ldF9jb25kJTIyJTJDJTIwTm9uZSU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffAutoDenoiseStep</span>(<span class="hljs-title class_ inherited__">AutoPipelineBlocks</span>):
    block_classes = [SDXLDiffDiffControlNetDenoiseStep, SDXLDiffDiffDenoiseStep]
    block_names = [<span class="hljs-string">&quot;controlnet_denoise&quot;</span>, <span class="hljs-string">&quot;denoise&quot;</span>]
    block_trigger_inputs = [<span class="hljs-string">&quot;controlnet_cond&quot;</span>, <span class="hljs-literal">None</span>]`,wrap:!1}}),he=new J({props:{code:"RElGRkRJRkZfQVVUT19CTE9DS1MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MuY29weSgpJTBBRElGRkRJRkZfQVVUT19CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUy5pbnNlcnQoJTIyaXBfYWRhcHRlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQXV0b0lQQWRhcHRlclN0ZXAlMkMlMjAwKSUwQURJRkZESUZGX0FVVE9fQkxPQ0tTLmluc2VydCglMjJjb250cm9sbmV0X2lucHV0JTIyJTJDU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0QXV0b0lucHV0JTJDJTIwNyk=",highlighted:`DIFFDIFF_AUTO_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffAutoDenoiseStep
DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, StableDiffusionXLAutoIPAdapterStep, <span class="hljs-number">0</span>)
DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>,StableDiffusionXLControlNetAutoInput, <span class="hljs-number">7</span>)`,wrap:!1}}),je=new J({props:{code:"ZGRfYXV0b19ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9BVVRPX0JMT0NLUyklMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2F1dG9fYmxvY2tzLmluaXRfcGlwZWxpbmUoJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMkMlMjBjb2xsZWN0aW9uJTNEJTIyZGlmZmRpZmYlMjIpJTBBZGRfcGlwZWxpbmUubG9hZF9kZWZhdWx0X2NvbXBvbmVudHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KQ==",highlighted:`dd_auto_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_AUTO_BLOCKS)
dd_pipeline = dd_auto_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
dd_pipeline.load_default_components(torch_dtype=torch.float16)`,wrap:!1}}),ke=new u({props:{title:"Share",local:"share",headingTag:"h2"}}),_e=new J({props:{code:"ZGRfcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMllpWWlYdSUyRnRlc3RfbW9kdWxhcl9kb2MlMjIlMkMlMjBwdXNoX3RvX2h1YiUzRFRydWUp",highlighted:'dd_pipeline.save_pretrained(<span class="hljs-string">&quot;YiYiXu/test_modular_doc&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)',wrap:!1}}),Ce=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwTW9kdWxhclBpcGVsaW5lJTJDJTIwQ29tcG9uZW50c01hbmFnZXIlMEElMEFjb21wb25lbnRzJTIwJTNEJTIwQ29tcG9uZW50c01hbmFnZXIoKSUwQSUwQWRpZmZkaWZmX3BpcGVsaW5lJTIwJTNEJTIwTW9kdWxhclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJZaVlpWHUlMkZtb2R1bGFyLWRpZmZkaWZmLTA3MDQlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRpZmZkaWZmX3BpcGVsaW5lLmxvYWRfZGVmYXVsdF9jb21wb25lbnRzKHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ModularPipeline, ComponentsManager

components = ComponentsManager()

diffdiff_pipeline = ModularPipeline.from_pretrained(<span class="hljs-string">&quot;YiYiXu/modular-diffdiff-0704&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
diffdiff_pipeline.load_default_components(torch_dtype=torch.float16)`,wrap:!1}}),Xe=new Lt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/quickstart.md"}}),{c(){T=a("meta"),Ve=i(),Be=a("p"),ge=i(),d(y.$$.fragment),Se=i(),U=a("p"),U.innerHTML=Kl,ve=i(),w=a("p"),w.innerHTML=Ol,Ye=i(),d(b.$$.fragment),Fe=i(),Z=a("p"),Z.innerHTML=et,Ne=i(),h=a("ul"),h.innerHTML=lt,$e=i(),I=a("p"),I.innerHTML=tt,Ee=i(),d(j.$$.fragment),Le=i(),d(k.$$.fragment),De=i(),R=a("p"),R.innerHTML=st,Qe=i(),_=a("ul"),_.innerHTML=it,Ae=i(),d(G.$$.fragment),ze=i(),C=a("p"),C.innerHTML=nt,He=i(),X=a("p"),X.innerHTML=at,xe=i(),B=a("p"),B.innerHTML=ot,qe=i(),d(W.$$.fragment),Pe=i(),V=a("p"),V.innerHTML=pt,Ke=i(),d(g.$$.fragment),Oe=i(),d(S.$$.fragment),el=i(),v=a("p"),v.innerHTML=dt,ll=i(),Y=a("ul"),Y.innerHTML=Mt,tl=i(),d(F.$$.fragment),sl=i(),d(N.$$.fragment),il=i(),$=a("p"),$.innerHTML=ct,nl=i(),E=a("ul"),E.innerHTML=rt,al=i(),d(L.$$.fragment),ol=i(),d(D.$$.fragment),pl=i(),Q=a("p"),Q.innerHTML=ft,dl=i(),A=a("p"),A.innerHTML=mt,Ml=i(),z=a("p"),z.innerHTML=Jt,cl=i(),H=a("p"),H.innerHTML=ut,rl=i(),d(x.$$.fragment),fl=i(),d(q.$$.fragment),ml=i(),P=a("p"),P.innerHTML=Tt,Jl=i(),K=a("p"),K.innerHTML=yt,ul=i(),d(O.$$.fragment),Tl=i(),d(ee.$$.fragment),yl=i(),le=a("p"),le.innerHTML=Ut,Ul=i(),te=a("p"),te.textContent=wt,wl=i(),d(se.$$.fragment),bl=i(),ie=a("p"),ie.textContent=bt,Zl=i(),d(ne.$$.fragment),hl=i(),ae=a("p"),ae.innerHTML=Zt,Il=i(),d(oe.$$.fragment),jl=i(),pe=a("p"),pe.innerHTML=ht,kl=i(),d(de.$$.fragment),Rl=i(),d(Me.$$.fragment),_l=i(),ce=a("p"),ce.textContent=It,Gl=i(),d(re.$$.fragment),Cl=i(),fe=a("p"),fe.innerHTML=jt,Xl=i(),me=a("p"),me.innerHTML=kt,Bl=i(),d(Je.$$.fragment),Wl=i(),ue=a("p"),ue.innerHTML=Rt,Vl=i(),d(Te.$$.fragment),gl=i(),d(ye.$$.fragment),Sl=i(),Ue=a("p"),Ue.innerHTML=_t,vl=i(),we=a("p"),we.innerHTML=Gt,Yl=i(),d(be.$$.fragment),Fl=i(),Ze=a("p"),Ze.innerHTML=Ct,Nl=i(),d(he.$$.fragment),$l=i(),Ie=a("p"),Ie.innerHTML=Xt,El=i(),d(je.$$.fragment),Ll=i(),d(ke.$$.fragment),Dl=i(),Re=a("p"),Re.innerHTML=Bt,Ql=i(),d(_e.$$.fragment),Al=i(),Ge=a("p"),Ge.innerHTML=Wt,zl=i(),d(Ce.$$.fragment),Hl=i(),d(Xe.$$.fragment),xl=i(),We=a("p"),this.h()},l(e){const l=$t("svelte-u9bgzb",document.head);T=o(l,"META",{name:!0,content:!0}),l.forEach(t),Ve=n(e),Be=o(e,"P",{}),Vt(Be).forEach(t),ge=n(e),M(y.$$.fragment,e),Se=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-nfr4qm"&&(U.innerHTML=Kl),ve=n(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-14bi1ah"&&(w.innerHTML=Ol),Ye=n(e),M(b.$$.fragment,e),Fe=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-lxy6vq"&&(Z.innerHTML=et),Ne=n(e),h=o(e,"UL",{"data-svelte-h":!0}),p(h)!=="svelte-2w7id0"&&(h.innerHTML=lt),$e=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-7tdtn5"&&(I.innerHTML=tt),Ee=n(e),M(j.$$.fragment,e),Le=n(e),M(k.$$.fragment,e),De=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1hrx77z"&&(R.innerHTML=st),Qe=n(e),_=o(e,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-hgqjo0"&&(_.innerHTML=it),Ae=n(e),M(G.$$.fragment,e),ze=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-16tz7j4"&&(C.innerHTML=nt),He=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-pmw538"&&(X.innerHTML=at),xe=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1qke84t"&&(B.innerHTML=ot),qe=n(e),M(W.$$.fragment,e),Pe=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-g4vtz4"&&(V.innerHTML=pt),Ke=n(e),M(g.$$.fragment,e),Oe=n(e),M(S.$$.fragment,e),el=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1hnij81"&&(v.innerHTML=dt),ll=n(e),Y=o(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-wu0sp3"&&(Y.innerHTML=Mt),tl=n(e),M(F.$$.fragment,e),sl=n(e),M(N.$$.fragment,e),il=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1lriej4"&&($.innerHTML=ct),nl=n(e),E=o(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-k274di"&&(E.innerHTML=rt),al=n(e),M(L.$$.fragment,e),ol=n(e),M(D.$$.fragment,e),pl=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-rx5cas"&&(Q.innerHTML=ft),dl=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-bcrjsa"&&(A.innerHTML=mt),Ml=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1qdwaia"&&(z.innerHTML=Jt),cl=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-c6bj14"&&(H.innerHTML=ut),rl=n(e),M(x.$$.fragment,e),fl=n(e),M(q.$$.fragment,e),ml=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-47hkdb"&&(P.innerHTML=Tt),Jl=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1rotv4f"&&(K.innerHTML=yt),ul=n(e),M(O.$$.fragment,e),Tl=n(e),M(ee.$$.fragment,e),yl=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-rh0ns8"&&(le.innerHTML=Ut),Ul=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-denp3n"&&(te.textContent=wt),wl=n(e),M(se.$$.fragment,e),bl=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1mrw5mx"&&(ie.textContent=bt),Zl=n(e),M(ne.$$.fragment,e),hl=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1lami1t"&&(ae.innerHTML=Zt),Il=n(e),M(oe.$$.fragment,e),jl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1cjigq8"&&(pe.innerHTML=ht),kl=n(e),M(de.$$.fragment,e),Rl=n(e),M(Me.$$.fragment,e),_l=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-wr3jw6"&&(ce.textContent=It),Gl=n(e),M(re.$$.fragment,e),Cl=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-czmnsx"&&(fe.innerHTML=jt),Xl=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-mbulqa"&&(me.innerHTML=kt),Bl=n(e),M(Je.$$.fragment,e),Wl=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-jezo08"&&(ue.innerHTML=Rt),Vl=n(e),M(Te.$$.fragment,e),gl=n(e),M(ye.$$.fragment,e),Sl=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-12xk6i1"&&(Ue.innerHTML=_t),vl=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-rehsh7"&&(we.innerHTML=Gt),Yl=n(e),M(be.$$.fragment,e),Fl=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-o3hbbv"&&(Ze.innerHTML=Ct),Nl=n(e),M(he.$$.fragment,e),$l=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-88pyw4"&&(Ie.innerHTML=Xt),El=n(e),M(je.$$.fragment,e),Ll=n(e),M(ke.$$.fragment,e),Dl=n(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-8sp303"&&(Re.innerHTML=Bt),Ql=n(e),M(_e.$$.fragment,e),Al=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1ceh4ne"&&(Ge.innerHTML=Wt),zl=n(e),M(Ce.$$.fragment,e),Hl=n(e),M(Xe.$$.fragment,e),xl=n(e),We=o(e,"P",{}),Vt(We).forEach(t),this.h()},h(){gt(T,"name","hf:doc:metadata"),gt(T,"content",Qt)},m(e,l){Et(document.head,T),s(e,Ve,l),s(e,Be,l),s(e,ge,l),c(y,e,l),s(e,Se,l),s(e,U,l),s(e,ve,l),s(e,w,l),s(e,Ye,l),c(b,e,l),s(e,Fe,l),s(e,Z,l),s(e,Ne,l),s(e,h,l),s(e,$e,l),s(e,I,l),s(e,Ee,l),c(j,e,l),s(e,Le,l),c(k,e,l),s(e,De,l),s(e,R,l),s(e,Qe,l),s(e,_,l),s(e,Ae,l),c(G,e,l),s(e,ze,l),s(e,C,l),s(e,He,l),s(e,X,l),s(e,xe,l),s(e,B,l),s(e,qe,l),c(W,e,l),s(e,Pe,l),s(e,V,l),s(e,Ke,l),c(g,e,l),s(e,Oe,l),c(S,e,l),s(e,el,l),s(e,v,l),s(e,ll,l),s(e,Y,l),s(e,tl,l),c(F,e,l),s(e,sl,l),c(N,e,l),s(e,il,l),s(e,$,l),s(e,nl,l),s(e,E,l),s(e,al,l),c(L,e,l),s(e,ol,l),c(D,e,l),s(e,pl,l),s(e,Q,l),s(e,dl,l),s(e,A,l),s(e,Ml,l),s(e,z,l),s(e,cl,l),s(e,H,l),s(e,rl,l),c(x,e,l),s(e,fl,l),c(q,e,l),s(e,ml,l),s(e,P,l),s(e,Jl,l),s(e,K,l),s(e,ul,l),c(O,e,l),s(e,Tl,l),c(ee,e,l),s(e,yl,l),s(e,le,l),s(e,Ul,l),s(e,te,l),s(e,wl,l),c(se,e,l),s(e,bl,l),s(e,ie,l),s(e,Zl,l),c(ne,e,l),s(e,hl,l),s(e,ae,l),s(e,Il,l),c(oe,e,l),s(e,jl,l),s(e,pe,l),s(e,kl,l),c(de,e,l),s(e,Rl,l),c(Me,e,l),s(e,_l,l),s(e,ce,l),s(e,Gl,l),c(re,e,l),s(e,Cl,l),s(e,fe,l),s(e,Xl,l),s(e,me,l),s(e,Bl,l),c(Je,e,l),s(e,Wl,l),s(e,ue,l),s(e,Vl,l),c(Te,e,l),s(e,gl,l),c(ye,e,l),s(e,Sl,l),s(e,Ue,l),s(e,vl,l),s(e,we,l),s(e,Yl,l),c(be,e,l),s(e,Fl,l),s(e,Ze,l),s(e,Nl,l),c(he,e,l),s(e,$l,l),s(e,Ie,l),s(e,El,l),c(je,e,l),s(e,Ll,l),c(ke,e,l),s(e,Dl,l),s(e,Re,l),s(e,Ql,l),c(_e,e,l),s(e,Al,l),s(e,Ge,l),s(e,zl,l),c(Ce,e,l),s(e,Hl,l),c(Xe,e,l),s(e,xl,l),s(e,We,l),ql=!0},p:vt,i(e){ql||(r(y.$$.fragment,e),r(b.$$.fragment,e),r(j.$$.fragment,e),r(k.$$.fragment,e),r(G.$$.fragment,e),r(W.$$.fragment,e),r(g.$$.fragment,e),r(S.$$.fragment,e),r(F.$$.fragment,e),r(N.$$.fragment,e),r(L.$$.fragment,e),r(D.$$.fragment,e),r(x.$$.fragment,e),r(q.$$.fragment,e),r(O.$$.fragment,e),r(ee.$$.fragment,e),r(se.$$.fragment,e),r(ne.$$.fragment,e),r(oe.$$.fragment,e),r(de.$$.fragment,e),r(Me.$$.fragment,e),r(re.$$.fragment,e),r(Je.$$.fragment,e),r(Te.$$.fragment,e),r(ye.$$.fragment,e),r(be.$$.fragment,e),r(he.$$.fragment,e),r(je.$$.fragment,e),r(ke.$$.fragment,e),r(_e.$$.fragment,e),r(Ce.$$.fragment,e),r(Xe.$$.fragment,e),ql=!0)},o(e){f(y.$$.fragment,e),f(b.$$.fragment,e),f(j.$$.fragment,e),f(k.$$.fragment,e),f(G.$$.fragment,e),f(W.$$.fragment,e),f(g.$$.fragment,e),f(S.$$.fragment,e),f(F.$$.fragment,e),f(N.$$.fragment,e),f(L.$$.fragment,e),f(D.$$.fragment,e),f(x.$$.fragment,e),f(q.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(de.$$.fragment,e),f(Me.$$.fragment,e),f(re.$$.fragment,e),f(Je.$$.fragment,e),f(Te.$$.fragment,e),f(ye.$$.fragment,e),f(be.$$.fragment,e),f(he.$$.fragment,e),f(je.$$.fragment,e),f(ke.$$.fragment,e),f(_e.$$.fragment,e),f(Ce.$$.fragment,e),f(Xe.$$.fragment,e),ql=!1},d(e){e&&(t(Ve),t(Be),t(ge),t(Se),t(U),t(ve),t(w),t(Ye),t(Fe),t(Z),t(Ne),t(h),t($e),t(I),t(Ee),t(Le),t(De),t(R),t(Qe),t(_),t(Ae),t(ze),t(C),t(He),t(X),t(xe),t(B),t(qe),t(Pe),t(V),t(Ke),t(Oe),t(el),t(v),t(ll),t(Y),t(tl),t(sl),t(il),t($),t(nl),t(E),t(al),t(ol),t(pl),t(Q),t(dl),t(A),t(Ml),t(z),t(cl),t(H),t(rl),t(fl),t(ml),t(P),t(Jl),t(K),t(ul),t(Tl),t(yl),t(le),t(Ul),t(te),t(wl),t(bl),t(ie),t(Zl),t(hl),t(ae),t(Il),t(jl),t(pe),t(kl),t(Rl),t(_l),t(ce),t(Gl),t(Cl),t(fe),t(Xl),t(me),t(Bl),t(Wl),t(ue),t(Vl),t(gl),t(Sl),t(Ue),t(vl),t(we),t(Yl),t(Fl),t(Ze),t(Nl),t($l),t(Ie),t(El),t(Ll),t(Dl),t(Re),t(Ql),t(Al),t(Ge),t(zl),t(Hl),t(xl),t(We)),t(T),m(y,e),m(b,e),m(j,e),m(k,e),m(G,e),m(W,e),m(g,e),m(S,e),m(F,e),m(N,e),m(L,e),m(D,e),m(x,e),m(q,e),m(O,e),m(ee,e),m(se,e),m(ne,e),m(oe,e),m(de,e),m(Me,e),m(re,e),m(Je,e),m(Te,e),m(ye,e),m(be,e),m(he,e),m(je,e),m(ke,e),m(_e,e),m(Ce,e),m(Xe,e)}}}const Qt='{"title":"Quickstart","local":"quickstart","sections":[{"title":"ModularPipelineBlocks","local":"modularpipelineblocks","sections":[],"depth":2},{"title":"Pipeline and block states","local":"pipeline-and-block-states","sections":[],"depth":2},{"title":"Customizing blocks","local":"customizing-blocks","sections":[{"title":"prepare_latents","local":"preparelatents","sections":[],"depth":3},{"title":"denoise","local":"denoise","sections":[],"depth":3}],"depth":2},{"title":"Assembling the blocks","local":"assembling-the-blocks","sections":[],"depth":2},{"title":"ModularPipeline","local":"modularpipeline","sections":[],"depth":2},{"title":"Adding workflows","local":"adding-workflows","sections":[{"title":"IP-Adapter","local":"ip-adapter","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"AutoPipelineBlocks","local":"autopipelineblocks","sections":[],"depth":3}],"depth":2},{"title":"Share","local":"share","sections":[],"depth":2}],"depth":1}';function At(Pl){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends Ft{constructor(T){super(),Nt(this,T,At,Dt,St,{})}}export{Pt as component};
