import{s as zn,o as Rn,n as Se}from"../chunks/scheduler.6062bdaf.js";import{S as Yn,i as Ln,g as r,s as a,r as p,A as Xn,h as o,f as n,c as l,j as Sn,u as g,x as m,k as Hn,y as Qn,a as s,v as f,d as u,t as h,w as d}from"../chunks/index.4bca734e.js";import{T as Be}from"../chunks/Tip.b9ac1f03.js";import{C as _}from"../chunks/CodeBlock.fa01571c.js";import{H as j}from"../chunks/Heading.723dceba.js";function En(w){let i,y=`<a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is a Python client making HTTP calls to our APIs. If you want to make the HTTP calls directly using
your preferred tool (curl, postman,…), please refer to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>
or to the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> documentation pages.`,c,b,C=`For web development, a <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS client</a> has been released.
If you are interested in game development, you might have a look at our <a href="https://github.com/huggingface/unity-api" rel="nofollow">C# project</a>.`;return{c(){i=r("p"),i.innerHTML=y,c=a(),b=r("p"),b.innerHTML=C},l($){i=o($,"P",{"data-svelte-h":!0}),m(i)!=="svelte-mb5uxh"&&(i.innerHTML=y),c=l($),b=o($,"P",{"data-svelte-h":!0}),m(b)!=="svelte-22w7rm"&&(b.innerHTML=C)},m($,M){s($,i,M),s($,c,M),s($,b,M)},p:Se,d($){$&&(n(i),n(c),n(b))}}}function An(w){let i,y=`The API is designed to be simple. Not all parameters and options are available or described for the end user. Check out
<a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">this page</a> if you are interested in learning more about
all the parameters available for each task.`;return{c(){i=r("p"),i.innerHTML=y},l(c){i=o(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1o4uc5e"&&(i.innerHTML=y)},m(c,b){s(c,i,b)},p:Se,d(c){c&&n(i)}}}function Fn(w){let i,y=`There are more than 200k models on the Hugging Face Hub! Each task in the <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> comes with a recommended
model. Be aware that the HF recommendation can change over time without prior notice. Therefore it is best to explicitly
set a model once you are decided. Also, in most cases you’ll be interested in finding a model specific to <em>your</em> needs.
Visit the <a href="https://huggingface.co/models" rel="nofollow">Models</a> page on the Hub to explore your possibilities.`;return{c(){i=r("p"),i.innerHTML=y},l(c){i=o(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-2t5dq4"&&(i.innerHTML=y)},m(c,b){s(c,i,b)},p:Se,d(c){c&&n(i)}}}function Pn(w){let i,y=`Authentication is NOT mandatory when using the Inference API. However, authenticated users get a higher free-tier to
play with the service. Token is also mandatory if you want to run inference on your private models or on private
endpoints.`;return{c(){i=r("p"),i.textContent=y},l(c){i=o(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-7vtkgf"&&(i.textContent=y)},m(c,b){s(c,i,b)},p:Se,d(c){c&&n(i)}}}function Kn(w){let i,y=`Check out the <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> page to learn more about each task, how to use them, and the
most popular models for each task.`;return{c(){i=r("p"),i.innerHTML=y},l(c){i=o(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1u4hr1j"&&(i.innerHTML=y)},m(c,b){s(c,i,b)},p:Se,d(c){c&&n(i)}}}function Dn(w){let i,y=`This is the recommended way to adapt your code to <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. It lets you benefit from the task-specific
methods like <code>feature_extraction</code>.`;return{c(){i=r("p"),i.innerHTML=y},l(c){i=o(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-3arkg9"&&(i.innerHTML=y)},m(c,b){s(c,i,b)},p:Se,d(c){c&&n(i)}}}function On(w){let i,y,c,b,C,$,M,nn=`Inference is the process of using a trained model to make predictions on new data. As this process can be compute-intensive,
running on a dedicated server can be an interesting option. The <code>huggingface_hub</code> library provides an easy way to call a
service that runs inference for hosted models. There are several services you can connect to:`,ze,J,sn=`<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>: a service that allows you to run accelerated inference
on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and
prototype AI products.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production.
Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>`,Re,W,an=`These services can be called with the <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. It acts as a replacement for the legacy
<a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client, adding specific support for tasks and handling inference on both
<a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.
Learn how to migrate to the new client in the <a href="#legacy-inferenceapi-client">Legacy InferenceAPI client</a> section.`,Ye,U,Le,x,Xe,G,ln="Let’s get started with a text-to-image task:",Qe,V,Ee,q,cn=`We initialized an <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> with the default parameters. The only thing you need to know is the <a href="#supported-tasks">task</a> you want
to perform. By default, the client will connect to the Inference API and select a model to complete the task. In our
example, we generated an image from a text prompt. The returned value is a <code>PIL.Image</code> object that can be saved to a
file.`,Ae,I,Fe,N,Pe,B,rn="What if you want to use a specific model? You can specify it either as a parameter or directly at an instance level:",Ke,S,De,Z,Oe,H,et,z,on=`The examples we saw above use the free-hosted Inference API. This proves to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure.
That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy
any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to using exactly the same
code as before, changing only the <code>model</code> parameter:`,tt,R,nt,Y,st,L,pn=`Calls made with the <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> can be authenticated using a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>.
By default, it will use the token saved on your machine if you are logged in (check out
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#login" rel="nofollow">how to login</a>). If you are not logged in, you can pass
your token as an instance parameter:`,at,X,lt,k,it,Q,ct,E,gn=`<a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>’s goal is to provide the easiest interface to run inference on Hugging Face models. It
has a simple API that supports the most common tasks. Here is a list of the currently supported tasks:`,rt,A,fn='<thead><tr><th>Domain</th> <th>Task</th> <th>Supported</th> <th>Documentation</th></tr></thead> <tbody><tr><td>Audio</td> <td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_classification">audio_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.automatic_speech_recognition">automatic_speech_recognition()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_speech">text_to_speech()</a></td></tr> <tr><td>Computer Vision</td> <td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_classification">image_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_segmentation">image_segmentation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_image">image_to_image()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_text">image_to_text()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.object_detection">object_detection()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot-Image-Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_image_classification">zero_shot_image_classification()</a></td></tr> <tr><td>Multimodal</td> <td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Documentation Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.document_question_answering">document_question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.visual_question_answering">visual_question_answering()</a></td></tr> <tr><td>NLP</td> <td><a href="https://huggingface.co/tasks/conversational" rel="nofollow">Conversational</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.conversational">conversational()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.feature_extraction">feature_extraction()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill Mask</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.fill_mask">fill_mask()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.question_answering">question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.sentence_similarity">sentence_similarity()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.summarization">summarization()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.table_question_answering">table_question_answering()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_classification">text_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-generation" rel="nofollow">Text Generation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation">text_generation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.token_classification">token_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.translation">translation()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero Shot Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_classification">zero_shot_classification()</a></td></tr> <tr><td>Tabular</td> <td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_classification">tabular_classification()</a></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>✅</td> <td><a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_regression">tabular_regression()</a></td></tr></tbody>',ot,T,pt,F,gt,P,un=`However, it is not always possible to cover all use cases. For custom requests, the <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> method
gives you the flexibility to send any request to the Inference API. For example, you can specify how to parse the inputs
and outputs. In the example below, the generated image is returned as raw bytes instead of parsing it as a <code>PIL Image</code>.
This can be helpful if you don’t have <code>Pillow</code> installed in your setup and just care about the binary content of the
image. <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> is also useful to handle tasks that are not yet officially supported.`,ft,K,ut,D,ht,O,hn=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>. You can either install <code>aiohttp</code>
directly or use the <code>[inference]</code> extra:`,dt,ee,mt,te,dn=`After installation all async API endpoints are available via <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>. Its initialization and APIs are
strictly the same as the sync-only version.`,yt,ne,bt,se,mn='For more information about the <code>asyncio</code> module, please refer to the <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">official documentation</a>.',_t,ae,jt,le,yn='In the above section, we saw the main aspects of <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. Let’s dive into some more advanced tips.',wt,ie,$t,ce,bn="When doing inference, there are two main causes for a timeout:",Mt,re,_n="<li>The inference process takes a long time to complete.</li> <li>The model is not available, for example when Inference API is loading it for the first time.</li>",Ct,oe,jn=`<a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> has a global <code>timeout</code> parameter to handle those two aspects. By default, it is set to <code>None</code>,
meaning that the client will wait indefinitely for the inference to complete. If you want more control in your workflow,
you can set it to a specific value in seconds. If the timeout delay expires, an <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError">InferenceTimeoutError</a> is raised.
You can catch it and handle it in your code:`,Ut,pe,It,ge,Zt,fe,wn=`Some tasks require binary inputs, for example, when dealing with images or audio files. In this case, <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
tries to be as permissive as possible and accept different types:`,kt,ue,$n=`<li>raw <code>bytes</code></li> <li>a file-like object, opened as binary (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>a path (<code>str</code> or <code>Path</code>) pointing to a local file</li> <li>a URL (<code>str</code>) pointing to a remote file (e.g. <code>https://...</code>). In this case, the file will be downloaded locally before
sending it to the Inference API.</li>`,Tt,he,vt,de,Jt,me,Mn=`<a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> acts as a replacement for the legacy <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client. It adds specific support for tasks and
handles inference on both <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.`,Wt,ye,Cn='Here is a short guide to help you migrate from <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> to <a href="/docs/huggingface_hub/v0.19.1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.',xt,be,Gt,_e,Un="Change from",Vt,je,qt,we,In="to",Nt,$e,Bt,Me,St,Ce,Zn="Change from",Ht,Ue,zt,Ie,kn="to",Rt,Ze,Yt,v,Lt,ke,Xt,Te,Tn="Change from",Qt,ve,Et,Je,vn="to",At,We,Ft,xe,Pt,Ge,Jn="Change from",Kt,Ve,Dt,qe,Wn="to",Ot,Ne,en,He,tn;return C=new j({props:{title:"Run Inference on servers",local:"run-inference-on-servers",headingTag:"h1"}}),U=new Be({props:{$$slots:{default:[En]},$$scope:{ctx:w}}}),x=new j({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),V=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),I=new Be({props:{warning:!0,$$slots:{default:[An]},$$scope:{ctx:w}}}),N=new j({props:{title:"Using a specific model",local:"using-a-specific-model",headingTag:"h3"}}),S=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4pJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Initialize client for a specific model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Or use a generic client but pass your model as an argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)`,wrap:!1}}),Z=new Be({props:{$$slots:{default:[Fn]},$$scope:{ctx:w}}}),H=new j({props:{title:"Using a specific URL",local:"using-a-specific-url",headingTag:"h3"}}),R=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),Y=new j({props:{title:"Authentication",local:"authentication",headingTag:"h3"}}),X=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0b2tlbiUzRCUyMmhmXyoqKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(token=<span class="hljs-string">&quot;hf_***&quot;</span>)`,wrap:!1}}),k=new Be({props:{$$slots:{default:[Pn]},$$scope:{ctx:w}}}),Q=new j({props:{title:"Supported tasks",local:"supported-tasks",headingTag:"h2"}}),T=new Be({props:{$$slots:{default:[Kn]},$$scope:{ctx:w}}}),F=new j({props:{title:"Custom requests",local:"custom-requests",headingTag:"h2"}}),K=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTdEJTJDJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyKSUwQXJlc3BvbnNlLmNvbnRlbnQlMjAlMjMlMjByYXclMjBieXRlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>}, model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes</span>
<span class="hljs-string">b&#x27;...&#x27;</span>`,wrap:!1}}),D=new j({props:{title:"Async client",local:"async-client",headingTag:"h2"}}),ee=new _({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),ne=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Code must be run in a asyncio concurrent context.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),ae=new j({props:{title:"Advanced tips",local:"advanced-tips",headingTag:"h2"}}),ie=new j({props:{title:"Timeout",local:"timeout",headingTag:"h3"}}),pe=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),ge=new j({props:{title:"Binary inputs",local:"binary-inputs",headingTag:"h3"}}),he=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),de=new j({props:{title:"Legacy InferenceAPI client",local:"legacy-inferenceapi-client",headingTag:"h2"}}),be=new j({props:{title:"Initialization",local:"initialization",headingTag:"h3"}}),je=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjB0b2tlbiUzREFQSV9UT0tFTik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),$e=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwdG9rZW4lM0RBUElfVE9LRU4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient(model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),Me=new j({props:{title:"Run on a specific task",local:"run-on-a-specific-task",headingTag:"h3"}}),Ue=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIycGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjElMjIlMkMlMjB0YXNrJTNEJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyKSUwQWluZmVyZW5jZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(...)`,wrap:!1}}),Ze=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5mZXJlbmNlLmZlYXR1cmVfZXh0cmFjdGlvbiguLi4lMkMlMjBtb2RlbCUzRCUyMnBhcmFwaHJhc2UteGxtLXItbXVsdGlsaW5ndWFsLXYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inference.feature_extraction(..., model=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>)`,wrap:!1}}),v=new Be({props:{$$slots:{default:[Dn]},$$scope:{ctx:w}}}),ke=new j({props:{title:"Run custom request",local:"run-custom-request",headingTag:"h3"}}),ve=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBaW5mZXJlbmNlKGlucHV0cyUzRCUyMlRoZSUyMGdvYWwlMjBvZiUyMGxpZmUlMjBpcyUyMCU1Qk1BU0slNUQuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),We=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlN0QlMkMlMjBtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQXJlc3BvbnNlLmpzb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>}, model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),xe=new j({props:{title:"Run with parameters",local:"run-with-parameters",headingTag:"h3"}}),Ve=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIydHlwZWZvcm0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQWlucHV0cyUyMCUzRCUyMCUyMkhpJTJDJTIwSSUyMHJlY2VudGx5JTIwYm91Z2h0JTIwYSUyMGRldmljZSUyMGZyb20lMjB5b3VyJTIwY29tcGFueSUyMGJ1dCUyMGl0JTIwaXMlMjBub3QlMjB3b3JraW5nJTIwYXMlMjBhZHZlcnRpc2VkJTIwYW5kJTIwSSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwZ2V0JTIwcmVpbWJ1cnNlZCElMjIlMEFwYXJhbXMlMjAlM0QlMjAlN0IlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlN0QlMEFpbmZlcmVuY2UoaW5wdXRzJTJDJTIwcGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),Ne=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5wdXRzJTIwJTNEJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUwQXBhcmFtcyUyMCUzRCUyMCU3QiUyMmNhbmRpZGF0ZV9sYWJlbHMlMjIlM0ElNUIlMjJyZWZ1bmQlMjIlMkMlMjAlMjJsZWdhbCUyMiUyQyUyMCUyMmZhcSUyMiU1RCU3RCUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGlucHV0cyUyQyUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjBwYXJhbXMlN0QlMkMlMjBtb2RlbCUzRCUyMnR5cGVmb3JtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtbW5saSUyMiklMEFyZXNwb25zZS5qc29uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: inputs, <span class="hljs-string">&quot;parameters&quot;</span>: params}, model=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),{c(){i=r("meta"),y=a(),c=r("p"),b=a(),p(C.$$.fragment),$=a(),M=r("p"),M.innerHTML=nn,ze=a(),J=r("ul"),J.innerHTML=sn,Re=a(),W=r("p"),W.innerHTML=an,Ye=a(),p(U.$$.fragment),Le=a(),p(x.$$.fragment),Xe=a(),G=r("p"),G.textContent=ln,Qe=a(),p(V.$$.fragment),Ee=a(),q=r("p"),q.innerHTML=cn,Ae=a(),p(I.$$.fragment),Fe=a(),p(N.$$.fragment),Pe=a(),B=r("p"),B.textContent=rn,Ke=a(),p(S.$$.fragment),De=a(),p(Z.$$.fragment),Oe=a(),p(H.$$.fragment),et=a(),z=r("p"),z.innerHTML=on,tt=a(),p(R.$$.fragment),nt=a(),p(Y.$$.fragment),st=a(),L=r("p"),L.innerHTML=pn,at=a(),p(X.$$.fragment),lt=a(),p(k.$$.fragment),it=a(),p(Q.$$.fragment),ct=a(),E=r("p"),E.innerHTML=gn,rt=a(),A=r("table"),A.innerHTML=fn,ot=a(),p(T.$$.fragment),pt=a(),p(F.$$.fragment),gt=a(),P=r("p"),P.innerHTML=un,ft=a(),p(K.$$.fragment),ut=a(),p(D.$$.fragment),ht=a(),O=r("p"),O.innerHTML=hn,dt=a(),p(ee.$$.fragment),mt=a(),te=r("p"),te.innerHTML=dn,yt=a(),p(ne.$$.fragment),bt=a(),se=r("p"),se.innerHTML=mn,_t=a(),p(ae.$$.fragment),jt=a(),le=r("p"),le.innerHTML=yn,wt=a(),p(ie.$$.fragment),$t=a(),ce=r("p"),ce.textContent=bn,Mt=a(),re=r("ul"),re.innerHTML=_n,Ct=a(),oe=r("p"),oe.innerHTML=jn,Ut=a(),p(pe.$$.fragment),It=a(),p(ge.$$.fragment),Zt=a(),fe=r("p"),fe.innerHTML=wn,kt=a(),ue=r("ul"),ue.innerHTML=$n,Tt=a(),p(he.$$.fragment),vt=a(),p(de.$$.fragment),Jt=a(),me=r("p"),me.innerHTML=Mn,Wt=a(),ye=r("p"),ye.innerHTML=Cn,xt=a(),p(be.$$.fragment),Gt=a(),_e=r("p"),_e.textContent=Un,Vt=a(),p(je.$$.fragment),qt=a(),we=r("p"),we.textContent=In,Nt=a(),p($e.$$.fragment),Bt=a(),p(Me.$$.fragment),St=a(),Ce=r("p"),Ce.textContent=Zn,Ht=a(),p(Ue.$$.fragment),zt=a(),Ie=r("p"),Ie.textContent=kn,Rt=a(),p(Ze.$$.fragment),Yt=a(),p(v.$$.fragment),Lt=a(),p(ke.$$.fragment),Xt=a(),Te=r("p"),Te.textContent=Tn,Qt=a(),p(ve.$$.fragment),Et=a(),Je=r("p"),Je.textContent=vn,At=a(),p(We.$$.fragment),Ft=a(),p(xe.$$.fragment),Pt=a(),Ge=r("p"),Ge.textContent=Jn,Kt=a(),p(Ve.$$.fragment),Dt=a(),qe=r("p"),qe.textContent=Wn,Ot=a(),p(Ne.$$.fragment),en=a(),He=r("p"),this.h()},l(e){const t=Xn("svelte-u9bgzb",document.head);i=o(t,"META",{name:!0,content:!0}),t.forEach(n),y=l(e),c=o(e,"P",{}),Sn(c).forEach(n),b=l(e),g(C.$$.fragment,e),$=l(e),M=o(e,"P",{"data-svelte-h":!0}),m(M)!=="svelte-411gzg"&&(M.innerHTML=nn),ze=l(e),J=o(e,"UL",{"data-svelte-h":!0}),m(J)!=="svelte-lzzf1y"&&(J.innerHTML=sn),Re=l(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-slz89h"&&(W.innerHTML=an),Ye=l(e),g(U.$$.fragment,e),Le=l(e),g(x.$$.fragment,e),Xe=l(e),G=o(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-8lplub"&&(G.textContent=ln),Qe=l(e),g(V.$$.fragment,e),Ee=l(e),q=o(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-npuysq"&&(q.innerHTML=cn),Ae=l(e),g(I.$$.fragment,e),Fe=l(e),g(N.$$.fragment,e),Pe=l(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1npu22n"&&(B.textContent=rn),Ke=l(e),g(S.$$.fragment,e),De=l(e),g(Z.$$.fragment,e),Oe=l(e),g(H.$$.fragment,e),et=l(e),z=o(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-8ekppr"&&(z.innerHTML=on),tt=l(e),g(R.$$.fragment,e),nt=l(e),g(Y.$$.fragment,e),st=l(e),L=o(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1a2nn5v"&&(L.innerHTML=pn),at=l(e),g(X.$$.fragment,e),lt=l(e),g(k.$$.fragment,e),it=l(e),g(Q.$$.fragment,e),ct=l(e),E=o(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-3sn6so"&&(E.innerHTML=gn),rt=l(e),A=o(e,"TABLE",{"data-svelte-h":!0}),m(A)!=="svelte-1xq296w"&&(A.innerHTML=fn),ot=l(e),g(T.$$.fragment,e),pt=l(e),g(F.$$.fragment,e),gt=l(e),P=o(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-14w6b9u"&&(P.innerHTML=un),ft=l(e),g(K.$$.fragment,e),ut=l(e),g(D.$$.fragment,e),ht=l(e),O=o(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1gqwj00"&&(O.innerHTML=hn),dt=l(e),g(ee.$$.fragment,e),mt=l(e),te=o(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-16wv4z6"&&(te.innerHTML=dn),yt=l(e),g(ne.$$.fragment,e),bt=l(e),se=o(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-q492az"&&(se.innerHTML=mn),_t=l(e),g(ae.$$.fragment,e),jt=l(e),le=o(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1d51deb"&&(le.innerHTML=yn),wt=l(e),g(ie.$$.fragment,e),$t=l(e),ce=o(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-8gznjs"&&(ce.textContent=bn),Mt=l(e),re=o(e,"UL",{"data-svelte-h":!0}),m(re)!=="svelte-ovc80h"&&(re.innerHTML=_n),Ct=l(e),oe=o(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1ps3lh0"&&(oe.innerHTML=jn),Ut=l(e),g(pe.$$.fragment,e),It=l(e),g(ge.$$.fragment,e),Zt=l(e),fe=o(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1dxaa51"&&(fe.innerHTML=wn),kt=l(e),ue=o(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-vaeuct"&&(ue.innerHTML=$n),Tt=l(e),g(he.$$.fragment,e),vt=l(e),g(de.$$.fragment,e),Jt=l(e),me=o(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-1sfhdub"&&(me.innerHTML=Mn),Wt=l(e),ye=o(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-yjsauq"&&(ye.innerHTML=Cn),xt=l(e),g(be.$$.fragment,e),Gt=l(e),_e=o(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-ft9vbs"&&(_e.textContent=Un),Vt=l(e),g(je.$$.fragment,e),qt=l(e),we=o(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-8wg17z"&&(we.textContent=In),Nt=l(e),g($e.$$.fragment,e),Bt=l(e),g(Me.$$.fragment,e),St=l(e),Ce=o(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-ft9vbs"&&(Ce.textContent=Zn),Ht=l(e),g(Ue.$$.fragment,e),zt=l(e),Ie=o(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-8wg17z"&&(Ie.textContent=kn),Rt=l(e),g(Ze.$$.fragment,e),Yt=l(e),g(v.$$.fragment,e),Lt=l(e),g(ke.$$.fragment,e),Xt=l(e),Te=o(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-ft9vbs"&&(Te.textContent=Tn),Qt=l(e),g(ve.$$.fragment,e),Et=l(e),Je=o(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-8wg17z"&&(Je.textContent=vn),At=l(e),g(We.$$.fragment,e),Ft=l(e),g(xe.$$.fragment,e),Pt=l(e),Ge=o(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-ft9vbs"&&(Ge.textContent=Jn),Kt=l(e),g(Ve.$$.fragment,e),Dt=l(e),qe=o(e,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-8wg17z"&&(qe.textContent=Wn),Ot=l(e),g(Ne.$$.fragment,e),en=l(e),He=o(e,"P",{}),Sn(He).forEach(n),this.h()},h(){Hn(i,"name","hf:doc:metadata"),Hn(i,"content",es)},m(e,t){Qn(document.head,i),s(e,y,t),s(e,c,t),s(e,b,t),f(C,e,t),s(e,$,t),s(e,M,t),s(e,ze,t),s(e,J,t),s(e,Re,t),s(e,W,t),s(e,Ye,t),f(U,e,t),s(e,Le,t),f(x,e,t),s(e,Xe,t),s(e,G,t),s(e,Qe,t),f(V,e,t),s(e,Ee,t),s(e,q,t),s(e,Ae,t),f(I,e,t),s(e,Fe,t),f(N,e,t),s(e,Pe,t),s(e,B,t),s(e,Ke,t),f(S,e,t),s(e,De,t),f(Z,e,t),s(e,Oe,t),f(H,e,t),s(e,et,t),s(e,z,t),s(e,tt,t),f(R,e,t),s(e,nt,t),f(Y,e,t),s(e,st,t),s(e,L,t),s(e,at,t),f(X,e,t),s(e,lt,t),f(k,e,t),s(e,it,t),f(Q,e,t),s(e,ct,t),s(e,E,t),s(e,rt,t),s(e,A,t),s(e,ot,t),f(T,e,t),s(e,pt,t),f(F,e,t),s(e,gt,t),s(e,P,t),s(e,ft,t),f(K,e,t),s(e,ut,t),f(D,e,t),s(e,ht,t),s(e,O,t),s(e,dt,t),f(ee,e,t),s(e,mt,t),s(e,te,t),s(e,yt,t),f(ne,e,t),s(e,bt,t),s(e,se,t),s(e,_t,t),f(ae,e,t),s(e,jt,t),s(e,le,t),s(e,wt,t),f(ie,e,t),s(e,$t,t),s(e,ce,t),s(e,Mt,t),s(e,re,t),s(e,Ct,t),s(e,oe,t),s(e,Ut,t),f(pe,e,t),s(e,It,t),f(ge,e,t),s(e,Zt,t),s(e,fe,t),s(e,kt,t),s(e,ue,t),s(e,Tt,t),f(he,e,t),s(e,vt,t),f(de,e,t),s(e,Jt,t),s(e,me,t),s(e,Wt,t),s(e,ye,t),s(e,xt,t),f(be,e,t),s(e,Gt,t),s(e,_e,t),s(e,Vt,t),f(je,e,t),s(e,qt,t),s(e,we,t),s(e,Nt,t),f($e,e,t),s(e,Bt,t),f(Me,e,t),s(e,St,t),s(e,Ce,t),s(e,Ht,t),f(Ue,e,t),s(e,zt,t),s(e,Ie,t),s(e,Rt,t),f(Ze,e,t),s(e,Yt,t),f(v,e,t),s(e,Lt,t),f(ke,e,t),s(e,Xt,t),s(e,Te,t),s(e,Qt,t),f(ve,e,t),s(e,Et,t),s(e,Je,t),s(e,At,t),f(We,e,t),s(e,Ft,t),f(xe,e,t),s(e,Pt,t),s(e,Ge,t),s(e,Kt,t),f(Ve,e,t),s(e,Dt,t),s(e,qe,t),s(e,Ot,t),f(Ne,e,t),s(e,en,t),s(e,He,t),tn=!0},p(e,[t]){const xn={};t&2&&(xn.$$scope={dirty:t,ctx:e}),U.$set(xn);const Gn={};t&2&&(Gn.$$scope={dirty:t,ctx:e}),I.$set(Gn);const Vn={};t&2&&(Vn.$$scope={dirty:t,ctx:e}),Z.$set(Vn);const qn={};t&2&&(qn.$$scope={dirty:t,ctx:e}),k.$set(qn);const Nn={};t&2&&(Nn.$$scope={dirty:t,ctx:e}),T.$set(Nn);const Bn={};t&2&&(Bn.$$scope={dirty:t,ctx:e}),v.$set(Bn)},i(e){tn||(u(C.$$.fragment,e),u(U.$$.fragment,e),u(x.$$.fragment,e),u(V.$$.fragment,e),u(I.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(Z.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(Y.$$.fragment,e),u(X.$$.fragment,e),u(k.$$.fragment,e),u(Q.$$.fragment,e),u(T.$$.fragment,e),u(F.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(de.$$.fragment,e),u(be.$$.fragment,e),u(je.$$.fragment,e),u($e.$$.fragment,e),u(Me.$$.fragment,e),u(Ue.$$.fragment,e),u(Ze.$$.fragment,e),u(v.$$.fragment,e),u(ke.$$.fragment,e),u(ve.$$.fragment,e),u(We.$$.fragment,e),u(xe.$$.fragment,e),u(Ve.$$.fragment,e),u(Ne.$$.fragment,e),tn=!0)},o(e){h(C.$$.fragment,e),h(U.$$.fragment,e),h(x.$$.fragment,e),h(V.$$.fragment,e),h(I.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(Z.$$.fragment,e),h(H.$$.fragment,e),h(R.$$.fragment,e),h(Y.$$.fragment,e),h(X.$$.fragment,e),h(k.$$.fragment,e),h(Q.$$.fragment,e),h(T.$$.fragment,e),h(F.$$.fragment,e),h(K.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(be.$$.fragment,e),h(je.$$.fragment,e),h($e.$$.fragment,e),h(Me.$$.fragment,e),h(Ue.$$.fragment,e),h(Ze.$$.fragment,e),h(v.$$.fragment,e),h(ke.$$.fragment,e),h(ve.$$.fragment,e),h(We.$$.fragment,e),h(xe.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),tn=!1},d(e){e&&(n(y),n(c),n(b),n($),n(M),n(ze),n(J),n(Re),n(W),n(Ye),n(Le),n(Xe),n(G),n(Qe),n(Ee),n(q),n(Ae),n(Fe),n(Pe),n(B),n(Ke),n(De),n(Oe),n(et),n(z),n(tt),n(nt),n(st),n(L),n(at),n(lt),n(it),n(ct),n(E),n(rt),n(A),n(ot),n(pt),n(gt),n(P),n(ft),n(ut),n(ht),n(O),n(dt),n(mt),n(te),n(yt),n(bt),n(se),n(_t),n(jt),n(le),n(wt),n($t),n(ce),n(Mt),n(re),n(Ct),n(oe),n(Ut),n(It),n(Zt),n(fe),n(kt),n(ue),n(Tt),n(vt),n(Jt),n(me),n(Wt),n(ye),n(xt),n(Gt),n(_e),n(Vt),n(qt),n(we),n(Nt),n(Bt),n(St),n(Ce),n(Ht),n(zt),n(Ie),n(Rt),n(Yt),n(Lt),n(Xt),n(Te),n(Qt),n(Et),n(Je),n(At),n(Ft),n(Pt),n(Ge),n(Kt),n(Dt),n(qe),n(Ot),n(en),n(He)),n(i),d(C,e),d(U,e),d(x,e),d(V,e),d(I,e),d(N,e),d(S,e),d(Z,e),d(H,e),d(R,e),d(Y,e),d(X,e),d(k,e),d(Q,e),d(T,e),d(F,e),d(K,e),d(D,e),d(ee,e),d(ne,e),d(ae,e),d(ie,e),d(pe,e),d(ge,e),d(he,e),d(de,e),d(be,e),d(je,e),d($e,e),d(Me,e),d(Ue,e),d(Ze,e),d(v,e),d(ke,e),d(ve,e),d(We,e),d(xe,e),d(Ve,e),d(Ne,e)}}}const es='{"title":"Run Inference on servers","local":"run-inference-on-servers","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Using a specific model","local":"using-a-specific-model","sections":[],"depth":3},{"title":"Using a specific URL","local":"using-a-specific-url","sections":[],"depth":3},{"title":"Authentication","local":"authentication","sections":[],"depth":3}],"depth":2},{"title":"Supported tasks","local":"supported-tasks","sections":[],"depth":2},{"title":"Custom requests","local":"custom-requests","sections":[],"depth":2},{"title":"Async client","local":"async-client","sections":[],"depth":2},{"title":"Advanced tips","local":"advanced-tips","sections":[{"title":"Timeout","local":"timeout","sections":[],"depth":3},{"title":"Binary inputs","local":"binary-inputs","sections":[],"depth":3}],"depth":2},{"title":"Legacy InferenceAPI client","local":"legacy-inferenceapi-client","sections":[{"title":"Initialization","local":"initialization","sections":[],"depth":3},{"title":"Run on a specific task","local":"run-on-a-specific-task","sections":[],"depth":3},{"title":"Run custom request","local":"run-custom-request","sections":[],"depth":3},{"title":"Run with parameters","local":"run-with-parameters","sections":[],"depth":3}],"depth":2}],"depth":1}';function ts(w){return Rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cs extends Yn{constructor(i){super(),Ln(this,i,ts,On,zn,{})}}export{cs as component};
