import{s as Ft,o as Lt,n as tt}from"../chunks/scheduler.8c3d61f6.js";import{S as Qt,i as Yt,g as p,s as n,r,A as At,h as i,f as t,c as a,j as Et,u as d,x as m,k as U,y as Dt,a as l,v as c,d as h,t as u,w as f}from"../chunks/index.589a98e8.js";import{T as st}from"../chunks/Tip.42aa8582.js";import{C as b}from"../chunks/CodeBlock.36627b28.js";import{D as Pt}from"../chunks/DocNotebookDropdown.108e4998.js";import{H as I,E as qt}from"../chunks/EditOnGithub.e5a8d9cb.js";function Kt(J){let o,y='💡 Read the <a href="https://huggingface.co/blog/stable_diffusion#how-does-stable-diffusion-work" rel="nofollow">How does Stable Diffusion work?</a> blog for more details about how the VAE, UNet, and text encoder models work.';return{c(){o=p("p"),o.innerHTML=y},l(M){o=i(M,"P",{"data-svelte-h":!0}),m(o)!=="svelte-14e2v6n"&&(o.innerHTML=y)},m(M,j){l(M,o,j)},p:tt,d(M){M&&t(o)}}}function Ot(J){let o,y="💡 The <code>guidance_scale</code> parameter determines how much weight should be given to the prompt when generating an image.";return{c(){o=p("p"),o.innerHTML=y},l(M){o=i(M,"P",{"data-svelte-h":!0}),m(o)!=="svelte-vswzt8"&&(o.innerHTML=y)},m(M,j){l(M,o,j)},p:tt,d(M){M&&t(o)}}}function el(J){let o,y="💡 The height and width are divided by 8 because the <code>vae</code> model has 3 down-sampling layers. You can check by running the following:",M,j,w;return j=new b({props:{code:"MiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMjAlM0QlM0QlMjA4",highlighted:'<span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>) == <span class="hljs-number">8</span>',wrap:!1}}),{c(){o=p("p"),o.innerHTML=y,M=n(),r(j.$$.fragment)},l(g){o=i(g,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1c9k596"&&(o.innerHTML=y),M=a(g),d(j.$$.fragment,g)},m(g,T){l(g,o,T),l(g,M,T),c(j,g,T),w=!0},p:tt,i(g){w||(h(j.$$.fragment,g),w=!0)},o(g){u(j.$$.fragment,g),w=!1},d(g){g&&(t(o),t(M)),f(j,g)}}}function sl(J){let o,y,M,j,w,g,T,He,R,lt='🧨 Diffusers is designed to be a user-friendly and flexible toolbox for building diffusion systems tailored to your use-case. At the core of the toolbox are models and schedulers. While the <a href="/docs/diffusers/v0.29.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> bundles these components together for convenience, you can also unbundle the pipeline and use the models and schedulers separately to create new diffusion systems.',Se,N,nt="In this tutorial, you’ll learn how to use models and schedulers to assemble a diffusion system for inference, starting with a basic pipeline and then progressing to the Stable Diffusion pipeline.",ze,B,Ee,X,at="A pipeline is a quick and easy way to run a model for inference, requiring no more than four lines of code to generate an image:",Fe,H,Le,$,pt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ddpm-cat.png" alt="Image of cat created from DDPMPipeline"/>',Qe,S,it="That was super easy, but how did the pipeline do that? Let’s breakdown the pipeline and take a look at what’s happening under the hood.",Ye,z,mt='In the example above, the pipeline contains a <a href="/docs/diffusers/v0.29.2/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> model and a <a href="/docs/diffusers/v0.29.2/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>. The pipeline denoises an image by taking random noise the size of the desired output and passing it through the model several times. At each timestep, the model predicts the <em>noise residual</em> and the scheduler uses it to predict a less noisy image. The pipeline repeats this process until it reaches the end of the specified number of inference steps.',Ae,E,ot="To recreate the pipeline with the model and scheduler separately, let’s write our own denoising process.",De,F,rt="<li>Load the model and scheduler:</li>",Pe,L,qe,v,dt="<li>Set the number of timesteps to run the denoising process for:</li>",Ke,Q,Oe,Z,ct="<li>Setting the scheduler timesteps creates a tensor with evenly spaced elements in it, 50 in this example. Each element corresponds to a timestep at which the model denoises an image. When you create the denoising loop later, you’ll iterate over this tensor to denoise an image:</li>",es,Y,ss,C,ht="<li>Create some random noise with the same shape as the desired output:</li>",ts,A,ls,_,ut='<li>Now write a loop to iterate over the timesteps. At each timestep, the model does a <a href="/docs/diffusers/v0.29.2/en/api/models/unet2d#diffusers.UNet2DModel.forward">UNet2DModel.forward()</a> pass and returns the noisy residual. The scheduler’s <a href="/docs/diffusers/v0.29.2/en/api/schedulers/ddpm#diffusers.DDPMScheduler.step">step()</a> method takes the noisy residual, timestep, and input and it predicts the image at the previous timestep. This output becomes the next input to the model in the denoising loop, and it’ll repeat until it reaches the end of the <code>timesteps</code> array.</li>',ns,D,as,P,ft="This is the entire denoising process, and you can use this same pattern to write any diffusion system.",ps,k,Mt="<li>The last step is to convert the denoised output into an image:</li>",is,q,ms,K,bt="In the next section, you’ll put your skills to the test and breakdown the more complex Stable Diffusion pipeline. The steps are more or less the same. You’ll initialize the necessary components, and set the number of timesteps to create a <code>timestep</code> array. The <code>timestep</code> array is used in the denoising loop, and for each element in this array, the model predicts a less noisy image. The denoising loop iterates over the <code>timestep</code>’s, and at each timestep, it outputs a noisy residual and the scheduler uses it to predict a less noisy image at the previous timestep. This process is repeated until you reach the end of the <code>timestep</code> array.",os,O,gt="Let’s try it out!",rs,ee,ds,se,jt="Stable Diffusion is a text-to-image <em>latent diffusion</em> model. It is called a latent diffusion model because it works with a lower-dimensional representation of the image instead of the actual pixel space, which makes it more memory efficient. The encoder compresses the image into a smaller representation, and a decoder to convert the compressed representation back into an image. For text-to-image models, you’ll need a tokenizer and an encoder to generate text embeddings. From the previous example, you already know you need a UNet model and a scheduler.",cs,te,yt="As you can see, this is already more complex than the DDPM pipeline which only contains a UNet model. The Stable Diffusion model has three separate pretrained models.",hs,V,us,le,wt='Now that you know what you need for the Stable Diffusion pipeline, load all these components with the <a href="/docs/diffusers/v0.29.2/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method. You can find them in the pretrained <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> checkpoint, and each component is stored in a separate subfolder:',fs,ne,Ms,ae,Tt='Instead of the default <a href="/docs/diffusers/v0.29.2/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>, exchange it for the <a href="/docs/diffusers/v0.29.2/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> to see how easy it is to plug a different scheduler in:',bs,pe,gs,ie,Ut="To speed up inference, move the models to a GPU since, unlike the scheduler, they have trainable weights:",js,me,ys,oe,ws,re,Jt="The next step is to tokenize the text to generate embeddings. The text is used to condition the UNet model and steer the diffusion process towards something that resembles the input prompt.",Ts,G,Us,de,$t="Feel free to choose any prompt you like if you want to generate something else!",Js,ce,$s,he,vt="Tokenize the text and generate the embeddings from the prompt:",vs,ue,Zs,fe,Zt="You’ll also need to generate the <em>unconditional text embeddings</em> which are the embeddings for the padding token. These need to have the same shape (<code>batch_size</code> and <code>seq_length</code>) as the conditional <code>text_embeddings</code>:",Cs,Me,_s,be,Ct="Let’s concatenate the conditional and unconditional embeddings into a batch to avoid doing two forward passes:",ks,ge,Vs,je,Gs,ye,_t="Next, generate some initial random noise as a starting point for the diffusion process. This is the latent representation of the image, and it’ll be gradually denoised. At this point, the <code>latent</code> image is smaller than the final image size but that’s okay though because the model will transform it into the final 512x512 image dimensions later.",Ws,W,xs,we,Is,Te,Rs,Ue,kt='Start by scaling the input with the initial noise distribution, <em>sigma</em>, the noise scale value, which is required for improved schedulers like <a href="/docs/diffusers/v0.29.2/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>:',Ns,Je,Bs,$e,Vt="The last step is to create the denoising loop that’ll progressively transform the pure noise in <code>latents</code> to an image described by your prompt. Remember, the denoising loop needs to do three things:",Xs,ve,Gt="<li>Set the scheduler’s timesteps to use during denoising.</li> <li>Iterate over the timesteps.</li> <li>At each timestep, call the UNet model to predict the noise residual and pass it to the scheduler to compute the previous noisy sample.</li>",Hs,Ze,Ss,Ce,zs,_e,Wt="The final step is to use the <code>vae</code> to decode the latent representation into an image and get the decoded output with <code>sample</code>:",Es,ke,Fs,Ve,xt="Lastly, convert the image to a <code>PIL.Image</code> to see your generated image!",Ls,Ge,Qs,x,It='<img src="https://huggingface.co/blog/assets/98_stable_diffusion/stable_diffusion_k_lms.png"/>',Ys,We,As,xe,Rt="From basic to complex pipelines, you’ve seen that all you really need to write your own diffusion system is a denoising loop. The loop should set the scheduler’s timesteps, iterate over them, and alternate between calling the UNet model to predict the noise residual and passing it to the scheduler to compute the previous noisy sample.",Ds,Ie,Nt="This is really what 🧨 Diffusers is designed for: to make it intuitive and easy to write your own diffusion system using models and schedulers.",Ps,Re,Bt="For your next steps, feel free to:",qs,Ne,Xt='<li>Learn how to <a href="../using-diffusers/contribute_pipeline">build and contribute a pipeline</a> to 🧨 Diffusers. We can’t wait and see what you’ll come up with!</li> <li>Explore <a href="../api/pipelines/overview">existing pipelines</a> in the library, and see if you can deconstruct and build a pipeline from scratch using the models and schedulers separately.</li>',Ks,Be,Os,Xe,et;return w=new I({props:{title:"Understanding pipelines, models and schedulers",local:"understanding-pipelines-models-and-schedulers",headingTag:"h1"}}),T=new Pt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/write_own_pipeline.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/write_own_pipeline.ipynb"}]}}),B=new I({props:{title:"Deconstruct a basic pipeline",local:"deconstruct-a-basic-pipeline",headingTag:"h2"}}),H=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQSUwQWRkcG0lMjAlM0QlMjBERFBNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBkZHBtKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>ddpm = DDPMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = ddpm(num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),L=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiklMEFtb2RlbCUyMCUzRCUyMFVOZXQyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNhdC0yNTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Q=new b({props:{code:"c2NoZWR1bGVyLnNldF90aW1lc3RlcHMoNTAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(<span class="hljs-number">50</span>)',wrap:!1}}),Y=new b({props:{code:"c2NoZWR1bGVyLnRpbWVzdGVwcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.timesteps
tensor([<span class="hljs-number">980</span>, <span class="hljs-number">960</span>, <span class="hljs-number">940</span>, <span class="hljs-number">920</span>, <span class="hljs-number">900</span>, <span class="hljs-number">880</span>, <span class="hljs-number">860</span>, <span class="hljs-number">840</span>, <span class="hljs-number">820</span>, <span class="hljs-number">800</span>, <span class="hljs-number">780</span>, <span class="hljs-number">760</span>, <span class="hljs-number">740</span>, <span class="hljs-number">720</span>,
    <span class="hljs-number">700</span>, <span class="hljs-number">680</span>, <span class="hljs-number">660</span>, <span class="hljs-number">640</span>, <span class="hljs-number">620</span>, <span class="hljs-number">600</span>, <span class="hljs-number">580</span>, <span class="hljs-number">560</span>, <span class="hljs-number">540</span>, <span class="hljs-number">520</span>, <span class="hljs-number">500</span>, <span class="hljs-number">480</span>, <span class="hljs-number">460</span>, <span class="hljs-number">440</span>,
    <span class="hljs-number">420</span>, <span class="hljs-number">400</span>, <span class="hljs-number">380</span>, <span class="hljs-number">360</span>, <span class="hljs-number">340</span>, <span class="hljs-number">320</span>, <span class="hljs-number">300</span>, <span class="hljs-number">280</span>, <span class="hljs-number">260</span>, <span class="hljs-number">240</span>, <span class="hljs-number">220</span>, <span class="hljs-number">200</span>, <span class="hljs-number">180</span>, <span class="hljs-number">160</span>,
    <span class="hljs-number">140</span>, <span class="hljs-number">120</span>, <span class="hljs-number">100</span>,  <span class="hljs-number">80</span>,  <span class="hljs-number">60</span>,  <span class="hljs-number">40</span>,  <span class="hljs-number">20</span>,   <span class="hljs-number">0</span>])`,wrap:!1}}),A=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzYW1wbGVfc2l6ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5zYW1wbGVfc2l6ZSUwQW5vaXNlJTIwJTNEJTIwdG9yY2gucmFuZG4oKDElMkMlMjAzJTJDJTIwc2FtcGxlX3NpemUlMkMlMjBzYW1wbGVfc2l6ZSklMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_size = model.config.sample_size
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, sample_size, sample_size), device=<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),D=new b({props:{code:"aW5wdXQlMjAlM0QlMjBub2lzZSUwQSUwQWZvciUyMHQlMjBpbiUyMHNjaGVkdWxlci50aW1lc3RlcHMlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9pc3lfcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChpbnB1dCUyQyUyMHQpLnNhbXBsZSUwQSUyMCUyMCUyMCUyMHByZXZpb3VzX25vaXN5X3NhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXN5X3Jlc2lkdWFsJTJDJTIwdCUyQyUyMGlucHV0KS5wcmV2X3NhbXBsZSUwQSUyMCUyMCUyMCUyMGlucHV0JTIwJTNEJTIwcHJldmlvdXNfbm9pc3lfc2FtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span> = noise

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> scheduler.timesteps:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noisy_residual = model(<span class="hljs-built_in">input</span>, t).sample
<span class="hljs-meta">... </span>    previous_noisy_sample = scheduler.step(noisy_residual, t, <span class="hljs-built_in">input</span>).prev_sample
<span class="hljs-meta">... </span>    <span class="hljs-built_in">input</span> = previous_noisy_sample`,wrap:!1}}),q=new b({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBaW1hZ2UlMjAlM0QlMjAoaW5wdXQlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSkuc3F1ZWV6ZSgpJTBBaW1hZ2UlMjAlM0QlMjAoaW1hZ2UucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApJTIwKiUyMDI1NSkucm91bmQoKS50byh0b3JjaC51aW50OCkuY3B1KCkubnVtcHkoKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>image = (<span class="hljs-built_in">input</span> / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),ee=new I({props:{title:"Deconstruct the Stable Diffusion pipeline",local:"deconstruct-the-stable-diffusion-pipeline",headingTag:"h2"}}),V=new st({props:{$$slots:{default:[Kt]},$$scope:{ctx:J}}}),ne=new b({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFRleHRNb2RlbCUyQyUyMENMSVBUb2tlbml6ZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUyQyUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwUE5ETVNjaGVkdWxlciUwQSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0wuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ2YWUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMENMSVBUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwQ0xJUFRleHRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL, UNet2DConditionModel, PNDMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder = CLIPTextModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet = UNet2DConditionModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),pe=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = UniPCMultistepScheduler.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),me=new b({props:{code:"dG9yY2hfZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQXZhZS50byh0b3JjaF9kZXZpY2UpJTBBdGV4dF9lbmNvZGVyLnRvKHRvcmNoX2RldmljZSklMEF1bmV0LnRvKHRvcmNoX2RldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch_device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet.to(torch_device)`,wrap:!1}}),oe=new I({props:{title:"Create text embeddings",local:"create-text-embeddings",headingTag:"h3"}}),G=new st({props:{$$slots:{default:[Ot]},$$scope:{ctx:J}}}),ce=new b({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyYSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIyJTVEJTBBaGVpZ2h0JTIwJTNEJTIwNTEyJTIwJTIwJTIzJTIwZGVmYXVsdCUyMGhlaWdodCUyMG9mJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTBBd2lkdGglMjAlM0QlMjA1MTIlMjAlMjAlMjMlMjBkZWZhdWx0JTIwd2lkdGglMjBvZiUyMFN0YWJsZSUyMERpZmZ1c2lvbiUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyNSUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwZGVub2lzaW5nJTIwc3RlcHMlMEFndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDcuNSUyMCUyMCUyMyUyMFNjYWxlJTIwZm9yJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUyMCUyMCUyMyUyMFNlZWQlMjBnZW5lcmF0b3IlMjB0byUyMGNyZWF0ZSUyMHRoZSUyMGluaXRpYWwlMjBsYXRlbnQlMjBub2lzZSUwQWJhdGNoX3NpemUlMjAlM0QlMjBsZW4ocHJvbXB0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;a photograph of an astronaut riding a horse&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>height = <span class="hljs-number">512</span>  <span class="hljs-comment"># default height of Stable Diffusion</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>width = <span class="hljs-number">512</span>  <span class="hljs-comment"># default width of Stable Diffusion</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">25</span>  <span class="hljs-comment"># Number of denoising steps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">7.5</span>  <span class="hljs-comment"># Scale for classifier-free guidance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Seed generator to create the initial latent noise</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-built_in">len</span>(prompt)`,wrap:!1}}),ue=new b({props:{code:"dGV4dF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0R0b2tlbml6ZXIubW9kZWxfbWF4X2xlbmd0aCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKHRleHRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_input = tokenizer(
<span class="hljs-meta">... </span>    prompt, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=tokenizer.model_max_length, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    text_embeddings = text_encoder(text_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),Me=new b({props:{code:"bWF4X2xlbmd0aCUyMCUzRCUyMHRleHRfaW5wdXQuaW5wdXRfaWRzLnNoYXBlJTVCLTElNUQlMEF1bmNvbmRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyJTIyJTVEJTIwKiUyMGJhdGNoX3NpemUlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0RtYXhfbGVuZ3RoJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF1bmNvbmRfZW1iZWRkaW5ncyUyMCUzRCUyMHRleHRfZW5jb2Rlcih1bmNvbmRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>max_length = text_input.input_ids.shape[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_input = tokenizer([<span class="hljs-string">&quot;&quot;</span>] * batch_size, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=max_length, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_embeddings = text_encoder(uncond_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),ge=new b({props:{code:"dGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2guY2F0KCU1QnVuY29uZF9lbWJlZGRpbmdzJTJDJTIwdGV4dF9lbWJlZGRpbmdzJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = torch.cat([uncond_embeddings, text_embeddings])',wrap:!1}}),je=new I({props:{title:"Create random noise",local:"create-random-noise",headingTag:"h3"}}),W=new st({props:{$$slots:{default:[el]},$$scope:{ctx:J}}}),we=new b({props:{code:"bGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCUwQSUyMCUyMCUyMCUyMChiYXRjaF9zaXplJTJDJTIwdW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMjAlMkYlMkYlMjA4JTJDJTIwd2lkdGglMjAlMkYlMkYlMjA4KSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRHRvcmNoX2RldmljZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn(
<span class="hljs-meta">... </span>    (batch_size, unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    device=torch_device,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Te=new I({props:{title:"Denoise the image",local:"denoise-the-image",headingTag:"h3"}}),Je=new b({props:{code:"bGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwc2NoZWR1bGVyLmluaXRfbm9pc2Vfc2lnbWE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>latents = latents * scheduler.init_noise_sigma',wrap:!1}}),Ze=new b({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFzY2hlZHVsZXIuc2V0X3RpbWVzdGVwcyhudW1faW5mZXJlbmNlX3N0ZXBzKSUwQSUwQWZvciUyMHQlMjBpbiUyMHRxZG0oc2NoZWR1bGVyLnRpbWVzdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBleHBhbmQlMjB0aGUlMjBsYXRlbnRzJTIwaWYlMjB3ZSUyMGFyZSUyMGRvaW5nJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMjB0byUyMGF2b2lkJTIwZG9pbmclMjB0d28lMjBmb3J3YXJkJTIwcGFzc2VzLiUwQSUyMCUyMCUyMCUyMGxhdGVudF9tb2RlbF9pbnB1dCUyMCUzRCUyMHRvcmNoLmNhdCglNUJsYXRlbnRzJTVEJTIwKiUyMDIpJTBBJTBBJTIwJTIwJTIwJTIwbGF0ZW50X21vZGVsX2lucHV0JTIwJTNEJTIwc2NoZWR1bGVyLnNjYWxlX21vZGVsX2lucHV0KGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHRpbWVzdGVwJTNEdCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBwcmVkaWN0JTIwdGhlJTIwbm9pc2UlMjByZXNpZHVhbCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwdW5ldChsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTNEdGV4dF9lbWJlZGRpbmdzKS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBwZXJmb3JtJTIwZ3VpZGFuY2UlMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkX3VuY29uZCUyQyUyMG5vaXNlX3ByZWRfdGV4dCUyMCUzRCUyMG5vaXNlX3ByZWQuY2h1bmsoMiklMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwbm9pc2VfcHJlZF91bmNvbmQlMjAlMkIlMjBndWlkYW5jZV9zY2FsZSUyMColMjAobm9pc2VfcHJlZF90ZXh0JTIwLSUyMG5vaXNlX3ByZWRfdW5jb25kKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjB0aGUlMjBwcmV2aW91cyUyMG5vaXN5JTIwc2FtcGxlJTIweF90JTIwLSUzRSUyMHhfdC0xJTBBJTIwJTIwJTIwJTIwbGF0ZW50cyUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXNlX3ByZWQlMkMlMjB0JTJDJTIwbGF0ZW50cykucHJldl9zYW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(num_inference_steps)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tqdm(scheduler.timesteps):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># expand the latents if we are doing classifier-free guidance to avoid doing two forward passes.</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    latent_model_input = scheduler.scale_model_input(latent_model_input, timestep=t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># predict the noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># perform guidance</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># compute the previous noisy sample x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = scheduler.step(noise_pred, t, latents).prev_sample`,wrap:!1}}),Ce=new I({props:{title:"Decode the image",local:"decode-the-image",headingTag:"h3"}}),ke=new b({props:{code:"JTIzJTIwc2NhbGUlMjBhbmQlMjBkZWNvZGUlMjB0aGUlMjBpbWFnZSUyMGxhdGVudHMlMjB3aXRoJTIwdmFlJTBBbGF0ZW50cyUyMCUzRCUyMDElMjAlMkYlMjAwLjE4MjE1JTIwKiUyMGxhdGVudHMlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB2YWUuZGVjb2RlKGxhdGVudHMpLnNhbXBsZQ==",highlighted:`<span class="hljs-comment"># scale and decode the image latents with vae</span>
latents = <span class="hljs-number">1</span> / <span class="hljs-number">0.18215</span> * latents
<span class="hljs-keyword">with</span> torch.no_grad():
    image = vae.decode(latents).sample`,wrap:!1}}),Ge=new b({props:{code:"aW1hZ2UlMjAlM0QlMjAoaW1hZ2UlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSkuc3F1ZWV6ZSgpJTBBaW1hZ2UlMjAlM0QlMjAoaW1hZ2UucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApJTIwKiUyMDI1NSkudG8odG9yY2gudWludDgpLmNwdSgpLm51bXB5KCklMEFpbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),We=new I({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Be=new qt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/write_own_pipeline.md"}}),{c(){o=p("meta"),y=n(),M=p("p"),j=n(),r(w.$$.fragment),g=n(),r(T.$$.fragment),He=n(),R=p("p"),R.innerHTML=lt,Se=n(),N=p("p"),N.textContent=nt,ze=n(),r(B.$$.fragment),Ee=n(),X=p("p"),X.textContent=at,Fe=n(),r(H.$$.fragment),Le=n(),$=p("div"),$.innerHTML=pt,Qe=n(),S=p("p"),S.textContent=it,Ye=n(),z=p("p"),z.innerHTML=mt,Ae=n(),E=p("p"),E.textContent=ot,De=n(),F=p("ol"),F.innerHTML=rt,Pe=n(),r(L.$$.fragment),qe=n(),v=p("ol"),v.innerHTML=dt,Ke=n(),r(Q.$$.fragment),Oe=n(),Z=p("ol"),Z.innerHTML=ct,es=n(),r(Y.$$.fragment),ss=n(),C=p("ol"),C.innerHTML=ht,ts=n(),r(A.$$.fragment),ls=n(),_=p("ol"),_.innerHTML=ut,ns=n(),r(D.$$.fragment),as=n(),P=p("p"),P.textContent=ft,ps=n(),k=p("ol"),k.innerHTML=Mt,is=n(),r(q.$$.fragment),ms=n(),K=p("p"),K.innerHTML=bt,os=n(),O=p("p"),O.textContent=gt,rs=n(),r(ee.$$.fragment),ds=n(),se=p("p"),se.innerHTML=jt,cs=n(),te=p("p"),te.textContent=yt,hs=n(),r(V.$$.fragment),us=n(),le=p("p"),le.innerHTML=wt,fs=n(),r(ne.$$.fragment),Ms=n(),ae=p("p"),ae.innerHTML=Tt,bs=n(),r(pe.$$.fragment),gs=n(),ie=p("p"),ie.textContent=Ut,js=n(),r(me.$$.fragment),ys=n(),r(oe.$$.fragment),ws=n(),re=p("p"),re.textContent=Jt,Ts=n(),r(G.$$.fragment),Us=n(),de=p("p"),de.textContent=$t,Js=n(),r(ce.$$.fragment),$s=n(),he=p("p"),he.textContent=vt,vs=n(),r(ue.$$.fragment),Zs=n(),fe=p("p"),fe.innerHTML=Zt,Cs=n(),r(Me.$$.fragment),_s=n(),be=p("p"),be.textContent=Ct,ks=n(),r(ge.$$.fragment),Vs=n(),r(je.$$.fragment),Gs=n(),ye=p("p"),ye.innerHTML=_t,Ws=n(),r(W.$$.fragment),xs=n(),r(we.$$.fragment),Is=n(),r(Te.$$.fragment),Rs=n(),Ue=p("p"),Ue.innerHTML=kt,Ns=n(),r(Je.$$.fragment),Bs=n(),$e=p("p"),$e.innerHTML=Vt,Xs=n(),ve=p("ol"),ve.innerHTML=Gt,Hs=n(),r(Ze.$$.fragment),Ss=n(),r(Ce.$$.fragment),zs=n(),_e=p("p"),_e.innerHTML=Wt,Es=n(),r(ke.$$.fragment),Fs=n(),Ve=p("p"),Ve.innerHTML=xt,Ls=n(),r(Ge.$$.fragment),Qs=n(),x=p("div"),x.innerHTML=It,Ys=n(),r(We.$$.fragment),As=n(),xe=p("p"),xe.textContent=Rt,Ds=n(),Ie=p("p"),Ie.textContent=Nt,Ps=n(),Re=p("p"),Re.textContent=Bt,qs=n(),Ne=p("ul"),Ne.innerHTML=Xt,Ks=n(),r(Be.$$.fragment),Os=n(),Xe=p("p"),this.h()},l(e){const s=At("svelte-u9bgzb",document.head);o=i(s,"META",{name:!0,content:!0}),s.forEach(t),y=a(e),M=i(e,"P",{}),Et(M).forEach(t),j=a(e),d(w.$$.fragment,e),g=a(e),d(T.$$.fragment,e),He=a(e),R=i(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1oz1yr4"&&(R.innerHTML=lt),Se=a(e),N=i(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-5khcjg"&&(N.textContent=nt),ze=a(e),d(B.$$.fragment,e),Ee=a(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1o4pmop"&&(X.textContent=at),Fe=a(e),d(H.$$.fragment,e),Le=a(e),$=i(e,"DIV",{class:!0,"data-svelte-h":!0}),m($)!=="svelte-ej6f4c"&&($.innerHTML=pt),Qe=a(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-7b411q"&&(S.textContent=it),Ye=a(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-3ccjab"&&(z.innerHTML=mt),Ae=a(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-mwr50"&&(E.textContent=ot),De=a(e),F=i(e,"OL",{"data-svelte-h":!0}),m(F)!=="svelte-g7uo25"&&(F.innerHTML=rt),Pe=a(e),d(L.$$.fragment,e),qe=a(e),v=i(e,"OL",{start:!0,"data-svelte-h":!0}),m(v)!=="svelte-o7kbas"&&(v.innerHTML=dt),Ke=a(e),d(Q.$$.fragment,e),Oe=a(e),Z=i(e,"OL",{start:!0,"data-svelte-h":!0}),m(Z)!=="svelte-1jnsvh9"&&(Z.innerHTML=ct),es=a(e),d(Y.$$.fragment,e),ss=a(e),C=i(e,"OL",{start:!0,"data-svelte-h":!0}),m(C)!=="svelte-1hrlquj"&&(C.innerHTML=ht),ts=a(e),d(A.$$.fragment,e),ls=a(e),_=i(e,"OL",{start:!0,"data-svelte-h":!0}),m(_)!=="svelte-w1xu3h"&&(_.innerHTML=ut),ns=a(e),d(D.$$.fragment,e),as=a(e),P=i(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-sdv3mq"&&(P.textContent=ft),ps=a(e),k=i(e,"OL",{start:!0,"data-svelte-h":!0}),m(k)!=="svelte-1du7raq"&&(k.innerHTML=Mt),is=a(e),d(q.$$.fragment,e),ms=a(e),K=i(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-t8ln8h"&&(K.innerHTML=bt),os=a(e),O=i(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-tru974"&&(O.textContent=gt),rs=a(e),d(ee.$$.fragment,e),ds=a(e),se=i(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-hpeh95"&&(se.innerHTML=jt),cs=a(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1yb6q1d"&&(te.textContent=yt),hs=a(e),d(V.$$.fragment,e),us=a(e),le=i(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-haho5b"&&(le.innerHTML=wt),fs=a(e),d(ne.$$.fragment,e),Ms=a(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1is6k7d"&&(ae.innerHTML=Tt),bs=a(e),d(pe.$$.fragment,e),gs=a(e),ie=i(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1tr4efr"&&(ie.textContent=Ut),js=a(e),d(me.$$.fragment,e),ys=a(e),d(oe.$$.fragment,e),ws=a(e),re=i(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-ltx5oa"&&(re.textContent=Jt),Ts=a(e),d(G.$$.fragment,e),Us=a(e),de=i(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-z6gwd8"&&(de.textContent=$t),Js=a(e),d(ce.$$.fragment,e),$s=a(e),he=i(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-q7skg3"&&(he.textContent=vt),vs=a(e),d(ue.$$.fragment,e),Zs=a(e),fe=i(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-e64ab9"&&(fe.innerHTML=Zt),Cs=a(e),d(Me.$$.fragment,e),_s=a(e),be=i(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-41mj23"&&(be.textContent=Ct),ks=a(e),d(ge.$$.fragment,e),Vs=a(e),d(je.$$.fragment,e),Gs=a(e),ye=i(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1gyrog2"&&(ye.innerHTML=_t),Ws=a(e),d(W.$$.fragment,e),xs=a(e),d(we.$$.fragment,e),Is=a(e),d(Te.$$.fragment,e),Rs=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-j4n4r"&&(Ue.innerHTML=kt),Ns=a(e),d(Je.$$.fragment,e),Bs=a(e),$e=i(e,"P",{"data-svelte-h":!0}),m($e)!=="svelte-ul1wgx"&&($e.innerHTML=Vt),Xs=a(e),ve=i(e,"OL",{"data-svelte-h":!0}),m(ve)!=="svelte-ceuo6w"&&(ve.innerHTML=Gt),Hs=a(e),d(Ze.$$.fragment,e),Ss=a(e),d(Ce.$$.fragment,e),zs=a(e),_e=i(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-rzriwa"&&(_e.innerHTML=Wt),Es=a(e),d(ke.$$.fragment,e),Fs=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-6reqqn"&&(Ve.innerHTML=xt),Ls=a(e),d(Ge.$$.fragment,e),Qs=a(e),x=i(e,"DIV",{class:!0,"data-svelte-h":!0}),m(x)!=="svelte-1b0w6va"&&(x.innerHTML=It),Ys=a(e),d(We.$$.fragment,e),As=a(e),xe=i(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-9a4wlz"&&(xe.textContent=Rt),Ds=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-u3h7jy"&&(Ie.textContent=Nt),Ps=a(e),Re=i(e,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-xe6tlx"&&(Re.textContent=Bt),qs=a(e),Ne=i(e,"UL",{"data-svelte-h":!0}),m(Ne)!=="svelte-wmho1r"&&(Ne.innerHTML=Xt),Ks=a(e),d(Be.$$.fragment,e),Os=a(e),Xe=i(e,"P",{}),Et(Xe).forEach(t),this.h()},h(){U(o,"name","hf:doc:metadata"),U(o,"content",tl),U($,"class","flex justify-center"),U(v,"start","2"),U(Z,"start","3"),U(C,"start","4"),U(_,"start","5"),U(k,"start","6"),U(x,"class","flex justify-center")},m(e,s){Dt(document.head,o),l(e,y,s),l(e,M,s),l(e,j,s),c(w,e,s),l(e,g,s),c(T,e,s),l(e,He,s),l(e,R,s),l(e,Se,s),l(e,N,s),l(e,ze,s),c(B,e,s),l(e,Ee,s),l(e,X,s),l(e,Fe,s),c(H,e,s),l(e,Le,s),l(e,$,s),l(e,Qe,s),l(e,S,s),l(e,Ye,s),l(e,z,s),l(e,Ae,s),l(e,E,s),l(e,De,s),l(e,F,s),l(e,Pe,s),c(L,e,s),l(e,qe,s),l(e,v,s),l(e,Ke,s),c(Q,e,s),l(e,Oe,s),l(e,Z,s),l(e,es,s),c(Y,e,s),l(e,ss,s),l(e,C,s),l(e,ts,s),c(A,e,s),l(e,ls,s),l(e,_,s),l(e,ns,s),c(D,e,s),l(e,as,s),l(e,P,s),l(e,ps,s),l(e,k,s),l(e,is,s),c(q,e,s),l(e,ms,s),l(e,K,s),l(e,os,s),l(e,O,s),l(e,rs,s),c(ee,e,s),l(e,ds,s),l(e,se,s),l(e,cs,s),l(e,te,s),l(e,hs,s),c(V,e,s),l(e,us,s),l(e,le,s),l(e,fs,s),c(ne,e,s),l(e,Ms,s),l(e,ae,s),l(e,bs,s),c(pe,e,s),l(e,gs,s),l(e,ie,s),l(e,js,s),c(me,e,s),l(e,ys,s),c(oe,e,s),l(e,ws,s),l(e,re,s),l(e,Ts,s),c(G,e,s),l(e,Us,s),l(e,de,s),l(e,Js,s),c(ce,e,s),l(e,$s,s),l(e,he,s),l(e,vs,s),c(ue,e,s),l(e,Zs,s),l(e,fe,s),l(e,Cs,s),c(Me,e,s),l(e,_s,s),l(e,be,s),l(e,ks,s),c(ge,e,s),l(e,Vs,s),c(je,e,s),l(e,Gs,s),l(e,ye,s),l(e,Ws,s),c(W,e,s),l(e,xs,s),c(we,e,s),l(e,Is,s),c(Te,e,s),l(e,Rs,s),l(e,Ue,s),l(e,Ns,s),c(Je,e,s),l(e,Bs,s),l(e,$e,s),l(e,Xs,s),l(e,ve,s),l(e,Hs,s),c(Ze,e,s),l(e,Ss,s),c(Ce,e,s),l(e,zs,s),l(e,_e,s),l(e,Es,s),c(ke,e,s),l(e,Fs,s),l(e,Ve,s),l(e,Ls,s),c(Ge,e,s),l(e,Qs,s),l(e,x,s),l(e,Ys,s),c(We,e,s),l(e,As,s),l(e,xe,s),l(e,Ds,s),l(e,Ie,s),l(e,Ps,s),l(e,Re,s),l(e,qs,s),l(e,Ne,s),l(e,Ks,s),c(Be,e,s),l(e,Os,s),l(e,Xe,s),et=!0},p(e,[s]){const Ht={};s&2&&(Ht.$$scope={dirty:s,ctx:e}),V.$set(Ht);const St={};s&2&&(St.$$scope={dirty:s,ctx:e}),G.$set(St);const zt={};s&2&&(zt.$$scope={dirty:s,ctx:e}),W.$set(zt)},i(e){et||(h(w.$$.fragment,e),h(T.$$.fragment,e),h(B.$$.fragment,e),h(H.$$.fragment,e),h(L.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(q.$$.fragment,e),h(ee.$$.fragment,e),h(V.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(oe.$$.fragment,e),h(G.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(ge.$$.fragment,e),h(je.$$.fragment,e),h(W.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h(Ce.$$.fragment,e),h(ke.$$.fragment,e),h(Ge.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),et=!0)},o(e){u(w.$$.fragment,e),u(T.$$.fragment,e),u(B.$$.fragment,e),u(H.$$.fragment,e),u(L.$$.fragment,e),u(Q.$$.fragment,e),u(Y.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(q.$$.fragment,e),u(ee.$$.fragment,e),u(V.$$.fragment,e),u(ne.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(oe.$$.fragment,e),u(G.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(ge.$$.fragment,e),u(je.$$.fragment,e),u(W.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(Je.$$.fragment,e),u(Ze.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(Ge.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),et=!1},d(e){e&&(t(y),t(M),t(j),t(g),t(He),t(R),t(Se),t(N),t(ze),t(Ee),t(X),t(Fe),t(Le),t($),t(Qe),t(S),t(Ye),t(z),t(Ae),t(E),t(De),t(F),t(Pe),t(qe),t(v),t(Ke),t(Oe),t(Z),t(es),t(ss),t(C),t(ts),t(ls),t(_),t(ns),t(as),t(P),t(ps),t(k),t(is),t(ms),t(K),t(os),t(O),t(rs),t(ds),t(se),t(cs),t(te),t(hs),t(us),t(le),t(fs),t(Ms),t(ae),t(bs),t(gs),t(ie),t(js),t(ys),t(ws),t(re),t(Ts),t(Us),t(de),t(Js),t($s),t(he),t(vs),t(Zs),t(fe),t(Cs),t(_s),t(be),t(ks),t(Vs),t(Gs),t(ye),t(Ws),t(xs),t(Is),t(Rs),t(Ue),t(Ns),t(Bs),t($e),t(Xs),t(ve),t(Hs),t(Ss),t(zs),t(_e),t(Es),t(Fs),t(Ve),t(Ls),t(Qs),t(x),t(Ys),t(As),t(xe),t(Ds),t(Ie),t(Ps),t(Re),t(qs),t(Ne),t(Ks),t(Os),t(Xe)),t(o),f(w,e),f(T,e),f(B,e),f(H,e),f(L,e),f(Q,e),f(Y,e),f(A,e),f(D,e),f(q,e),f(ee,e),f(V,e),f(ne,e),f(pe,e),f(me,e),f(oe,e),f(G,e),f(ce,e),f(ue,e),f(Me,e),f(ge,e),f(je,e),f(W,e),f(we,e),f(Te,e),f(Je,e),f(Ze,e),f(Ce,e),f(ke,e),f(Ge,e),f(We,e),f(Be,e)}}}const tl='{"title":"Understanding pipelines, models and schedulers","local":"understanding-pipelines-models-and-schedulers","sections":[{"title":"Deconstruct a basic pipeline","local":"deconstruct-a-basic-pipeline","sections":[],"depth":2},{"title":"Deconstruct the Stable Diffusion pipeline","local":"deconstruct-the-stable-diffusion-pipeline","sections":[{"title":"Create text embeddings","local":"create-text-embeddings","sections":[],"depth":3},{"title":"Create random noise","local":"create-random-noise","sections":[],"depth":3},{"title":"Denoise the image","local":"denoise-the-image","sections":[],"depth":3},{"title":"Decode the image","local":"decode-the-image","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ll(J){return Lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rl extends Qt{constructor(o){super(),Yt(this,o,ll,sl,Ft,{})}}export{rl as component};
