import{s as vs,o as js,n as nn}from"../chunks/scheduler.c57aa7ef.js";import{S as $s,i as Zs,g as o,s as n,r as p,A as ks,h as i,f as a,c as s,j as _s,u as d,x as r,k as an,y as Us,a as l,v as m,d as f,t as h,w as c}from"../chunks/index.394f8801.js";import{T as ln}from"../chunks/Tip.23dfb1a9.js";import{C as M}from"../chunks/CodeBlock.5228ed01.js";import{H as y,E as Cs}from"../chunks/EditOnGithub.157fddbf.js";function Rs(T){let u,b='For further instructions on using EVA, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/eva_finetuning" rel="nofollow">documentation</a>.';return{c(){u=o("p"),u.innerHTML=b},l(w){u=i(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-9hfq4t"&&(u.innerHTML=b)},m(w,g){l(w,u,g)},p:nn,d(w){w&&a(u)}}}function Bs(T){let u,b='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){u=o("p"),u.innerHTML=b},l(w){u=i(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1nbpolx"&&(u.innerHTML=b)},m(w,g){l(w,u,g)},p:nn,d(w){w&&a(u)}}}function Ls(T){let u,b='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){u=o("p"),u.innerHTML=b},l(w){u=i(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-19y7vpj"&&(u.innerHTML=b)},m(w,g){l(w,u,g)},p:nn,d(w){w&&a(u)}}}function Ws(T){let u,b,w,g,$,At,Z,sn='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/v0.15.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/v0.15.0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Xt,k,on="This guide explores in more detail other options and features for using LoRA.",Qt,U,Ht,C,rn='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',zt,R,pn='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',Et,B,Ft,L,dn="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",qt,W,Yt,I,Nt,G,mn='<a href="https://arxiv.org/abs/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',St,V,fn="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",Pt,x,Dt,A,hn="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",Kt,X,Ot,Q,cn='For detailed instruction on using PiSSA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',ea,H,ta,z,un=`<a href="https://arxiv.org/pdf/2406.05223" rel="nofollow">CorDA</a> builds task-aware LoRA adapters from weight decomposition oriented by the context of downstream task to learn (instruction-previewed mode, IPM) or world knowledge to maintain (knowledge-preserved mode, KPM).
The KPM not only achieves better performance than LoRA on fine-tuning tasks, but also mitigates the catastrophic forgetting of pre-trained world knowledge.
When preserving pre-trained knowledge is not a concern,
the IPM is favored because it can further accelerate convergence and enhance the fine-tuning performance.`,aa,E,Mn="You need to configure the initialization method to “corda”, and specify the mode of IPM or KPM and the dataset to collect covariance matrices.",la,F,na,q,wn='For detailed instruction on using CorDA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/corda_finetuning" rel="nofollow">these instructions</a>.',sa,Y,oa,N,yn='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',ia,S,bn="You just need to pass a single additional option to use OLoRA:",ra,P,pa,D,gn='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',da,K,ma,O,Tn='<a href="https://arxiv.org/pdf/2410.07170" rel="nofollow">EVA</a> performs SVD on the input activations of each layer and uses the right-singular vectors to initialize LoRA weights. It is therefore a data-driven initialization scheme. Furthermore EVA adaptively allocates ranks across layers based on their “explained variance ratio” - a metric derived from the SVD analysis.',fa,ee,Jn='You can use EVA by setting <code>init_lora_weights=&quot;eva&quot;</code> and defining <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.EvaConfig">EvaConfig</a> in <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>:',ha,te,ca,ae,_n="The parameter <code>rho</code> (≥ 1.0) determines how much redistribution is allowed. When <code>rho=1.0</code> and <code>r=16</code>, LoRA adapters are limited to exactly 16 ranks, preventing any redistribution from occurring. A recommended value for EVA with redistribution is 2.0, meaning the maximum rank allowed for a layer is 2r.",ua,le,vn='It is recommended to perform EVA initialization on a GPU as it is much faster. To optimize the amount of available memory for EVA, you can use the <code>low_cpu_mem_usage</code> flag in <a href="/docs/peft/v0.15.0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>:',Ma,ne,wa,se,jn='Then, call <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> to initialize the EVA weights (in most cases the dataloader used for eva initialization can be the same as the one used for finetuning):',ya,oe,ba,ie,$n='EVA works out of the box with bitsandbytes. Simply initialize the model with <code>quantization_config</code> and call <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> as usual.',ga,J,Ta,re,Ja,pe,_a,de,Zn='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',va,me,kn="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",ja,fe,$a,he,Un="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",Za,ce,ka,ue,Cn='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Ua,Me,Rn="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",Ca,we,Bn="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",Ra,ye,Ln="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",Ba,_,La,be,Wa,ge,Wn='Another way to initialize <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Ia,Te,Ga,Je,Va,_e,In='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',xa,ve,Aa,je,Gn="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",Xa,$e,Qa,Ze,Vn="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",Ha,ke,za,Ue,xn=`DoRA is optimized (computes faster and takes less memory) for models in the evaluation mode, or when dropout is set to 0. We reuse the
base result at those times to get the speedup.
Running <a href="https://github.com/huggingface/peft/blob/main/examples/dora_finetuning/dora_finetuning.py" rel="nofollow">dora finetuning</a>
with <code>CUDA_VISIBLE_DEVICES=0 time python examples/dora_finetuning/dora_finetuning.py --quantize --lora_dropout 0 --batch_size 16 --eval_step 2 --use_dora</code>
on a 4090 with gradient accumulation set to 2 and max step to 20 resulted with the following observations:`,Ea,Ce,An='<thead><tr><th align="center"></th> <th align="center">Without Optimization</th> <th align="center">With Optimization</th></tr></thead> <tbody><tr><td align="center">train_runtime</td> <td align="center">359.7298</td> <td align="center"><strong>279.2676</strong></td></tr> <tr><td align="center">train_samples_per_second</td> <td align="center">1.779</td> <td align="center"><strong>2.292</strong></td></tr> <tr><td align="center">train_steps_per_second</td> <td align="center">0.056</td> <td align="center"><strong>0.072</strong></td></tr></tbody>',Fa,Re,qa,Be,Xn='<li>DoRA only supports embedding, linear, and Conv2d layers at the moment.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Ya,Le,Na,We,Qn='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Sa,Ie,Pa,Ge,Da,Ve,Hn='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Ka,xe,Oa,Ae,zn='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adapters.',el,Xe,En=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,tl,Qe,al,He,Fn='By default, all layers targeted with LoRA will have the same rank <code>r</code> and the same <code>lora_alpha</code> (which determines the LoRA scaling), depending on what was specified in the <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. In same cases, however, you may want to indicate different values for different layers. This is possible by passing the <code>rank_pattern</code> and <code>alpha_pattern</code> arguments to <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. These arguments should be dictionaries with the key being the layer name and the value being the rank/alpha value. The keys can be <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular expressesions</a> (regex). All LoRA layers that are not explicitly mentioned in <code>rank_pattern</code> and <code>alpha_pattern</code> will take the default <code>r</code> and <code>lora_alpha</code> values.',ll,ze,qn="To give an examples, let’s assume that we have a model with the following structure:",nl,Ee,sl,Fe,Yn="<li><code>rank_pattern={&quot;foo&quot;: 42}</code> will match all 3 <code>foo</code> layers. Neither <code>foobar</code> nor <code>barfoo</code> are matched.</li> <li><code>rank_pattern={&quot;^foo&quot;: 42}</code> will only match the <code>foo</code> layer of the model, but neither <code>module.foo</code> nor <code>module.module.foo</code>. This is because the <code>^</code> means “start of string” when using regular expressions, and only <code>foo</code> starts with <code>&quot;foo&quot;</code>, the other layer names have prefixes.</li> <li><code>rank_pattern={&quot;^module.foo&quot;: 42}</code> matches only <code>module.foo</code>, but not <code>module.module.foo</code>, for the same reason.</li> <li><code>rank_pattern={&quot;module.foo&quot;: 42}</code> matches both <code>module.foo</code> and <code>module.module.foo</code>, but not <code>foo</code>.</li> <li><code>rank_pattern={&quot;^foo&quot;: 42, &quot;^module.module.foo&quot;: 55}</code> matches <code>foo</code> and <code>module.module.foo</code>, respectively, but not <code>module.foo</code>.</li> <li>There is no need to indicate <code>$</code> to mark the end of the match, as this is added automatically by PEFT.</li>",ol,qe,Nn="The same logic applies to <code>alpha_pattern</code>. If you’re in doubt, don’t try to get fancy with regular expressions — just pass the full name for each module with a different rank/alpha, preceded by the <code>^</code> prefix, and you should be good.",il,Ye,rl,Ne,Sn="LoRA training can optionally include special purpose optimizers. Currently the only such optimizer is LoRA+.",pl,Se,dl,Pe,Pn='LoRA training can be optimized using <a href="https://arxiv.org/abs/2402.12354" rel="nofollow">LoRA+</a>, which uses different learning rates for the adapter matrices A and B, shown to increase finetuning speed by up to 2x and performance by 1-2%.',ml,De,fl,Ke,hl,Oe,Dn='Sometimes it is necessary to not only change some layer’s weights but to add new tokens as well. With larger models this can be a memory-costly endeavour. PEFT LoRA adapters support the <code>trainable_token_indices</code> parameter which allows tuning of other tokens alongside fine-tuning of specific layers with LoRA. This method only trains the tokens you specify and leaves all other tokens untouched. This saves memory and doesn’t throw away learned context of existing token embeddings in contrast to when training the whole embedding matrix. Under the hood this method uses the layer of <a href="/docs/peft/v0.15.0/en/package_reference/trainable_tokens#peft.TrainableTokensModel">TrainableTokensModel</a>.',cl,et,ul,tt,Kn="In the snippet below we show how to add new tokens to the model and how to train it alongside the other layers in the model.",Ml,at,wl,lt,On=`The token weights are part of your adapter state dict and saved alongside the LoRA weights.
If we would have used full fine-tuning with <code>modules_to_save=[&#39;embed_tokens&#39;]</code> we would have stored the full embedding matrix in the checkpoint, leading to a much bigger file.`,yl,nt,es="To give a bit of an indication how much VRAM can be saved, a rudimentary comparison of the above example was made between training the embedding matrix fully (<code>modules_to_save=[&quot;embed_tokens&quot;]</code>), using a LoRA for the embedding matrix (<code>target_modules=[..., &quot;embed_tokens&quot;]</code>, rank 32) and trainable tokens (<code>trainable_token_indices=[...]</code>, 6 tokens). Trainable tokens used about as much VRAM (15,562MB vs. 15,581MB) as LoRA while being specific to the tokens and saved ~1GB of VRAM over fully training the embedding matrix.",bl,st,gl,ot,ts='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',Tl,it,as="Below is a diagram that explains the intuition of LoRA adapter merging:",Jl,v,ls='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',_l,rt,ns="We show in the snippets below how to run that using PEFT.",vl,pt,jl,dt,ss='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/v0.15.0/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/v0.15.0/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',$l,mt,Zl,ft,os='The <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',kl,ht,is="First load the base model:",Ul,ct,Cl,ut,rs="Then we load the first adapter:",Rl,Mt,Bl,wt,ps="Then load a different adapter and merge it with the first one:",Ll,yt,Wl,j,Il,bt,ds="Now, perform inference:",Gl,gt,Vl,Tt,xl,Jt,ms='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/v0.15.0/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',Al,_t,Xl,vt,fs='To return the base model, you could use <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/v0.15.0/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',Ql,jt,Hl,$t,zl,Zt,hs="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",El,kt,cs="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an example of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",Fl,Ut,ql,Ct,us="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",Yl,Rt,Nl,Bt,Ms="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",Sl,Lt,ws="Additionally, the same approach also works with the <code>modules_to_save</code> feature, which allows for saving and reusing specific neural network layers, such as custom heads for classification tasks, across different LoRA adapters.",Pl,Wt,Dl,It,ys="Using this features has some drawbacks, namely:",Kl,Gt,bs='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>The <code>modules_to_save</code> feature is currently only supported for the layers of types <code>Linear</code>, <code>Embedding</code>, <code>Conv2d</code> and <code>Conv1d</code>.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',Ol,Vt,en,xt,tn;return $=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),U=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),W=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),I=new y({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),x=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),X=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLik=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...)',wrap:!1}}),H=new y({props:{title:"CorDA",local:"corda",headingTag:"h3"}}),F=new M({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwcnVuX21vZGVsKCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBc3N1bWUlMjAlNjBtb2RlbCU2MCUyMGFuZCUyMCU2MGRhdGFzZXQlNjAlMjBpcyUyMGluJTIwY29udGV4dC4uLiUwQSUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwoKipiYXRjaCklMEElMEElMEFjb3JkYV9jb25maWclMjAlM0QlMjBDb3JkYUNvbmZpZyglMEElMjAlMjAlMjAlMjBjb3JkYV9tZXRob2QlM0QlMjJrcG0lMjIlMkMlMEEpJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIyY29yZGElMjIlMkMlMEElMjAlMjAlMjAlMjBjb3JkYV9jb25maWclM0Rjb3JkYV9jb25maWclMkMlMEEpJTBBcHJlcHJvY2Vzc19jb3JkYShtb2RlbCUyQyUyMGxvcmFfY29uZmlnJTJDJTIwcnVuX21vZGVsJTNEcnVuX21vZGVsKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGxvcmFfY29uZmlnKQ==",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_model</span>():
    <span class="hljs-comment"># Assume \`model\` and \`dataset\` is in context...</span>
    model.<span class="hljs-built_in">eval</span>()
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataset:
        model(**batch)


corda_config = CordaConfig(
    corda_method=<span class="hljs-string">&quot;kpm&quot;</span>,
)
lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;corda&quot;</span>,
    corda_config=corda_config,
)
preprocess_corda(model, lora_config, run_model=run_model)
peft_model = get_peft_model(model, lora_config)`,wrap:!1}}),Y=new y({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),P=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),K=new y({props:{title:"EVA",local:"eva",headingTag:"h3"}}),te=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwRXZhQ29uZmlnJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTIwJTNEJTIwJTIyZXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXZhX2NvbmZpZyUyMCUzRCUyMEV2YUNvbmZpZyhyaG8lMjAlM0QlMjAyLjApJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, EvaConfig
peft_config = LoraConfig(
    init_lora_weights = <span class="hljs-string">&quot;eva&quot;</span>,
    eva_config = EvaConfig(rho = <span class="hljs-number">2.0</span>),
    ...
)`,wrap:!1}}),ne=new M({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWclMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:'peft_model = get_peft_model(model, peft_config, low_cpu_mem_usage=<span class="hljs-literal">True</span>)',wrap:!1}}),oe=new M({props:{code:"aW5pdGlhbGl6ZV9sb3JhX2V2YV93ZWlnaHRzKHBlZnRfbW9kZWwlMkMlMjBkYXRhbG9hZGVyKQ==",highlighted:"initialize_lora_eva_weights(peft_model, dataloader)",wrap:!1}}),J=new ln({props:{$$slots:{default:[Rs]},$$scope:{ctx:T}}}),re=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),pe=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),fe=new y({props:{title:"A more convenient way",local:"a-more-convenient-way",headingTag:"h4"}}),ce=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),_=new ln({props:{$$slots:{default:[Bs]},$$scope:{ctx:T}}}),be=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),Te=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),Je=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),ve=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),$e=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),ke=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),Re=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),Le=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),Ie=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),Ge=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),xe=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),Qe=new y({props:{title:"Fine grained control over ranks and alpha (scaling)",local:"fine-grained-control-over-ranks-and-alpha-scaling",headingTag:"h3"}}),Ee=new M({props:{code:"cHJpbnQobW9kZWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model)
Outer(
  (foo): Linear(...)
  (module): Middle(
    (foo): Linear(...)
    (foobar): Linear(...)
    (module): Inner(
      (foo): Linear(...)
      (barfoo): Linear(...)
    )
  )
)`,wrap:!1}}),Ye=new y({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),Se=new y({props:{title:"LoRA+ optimized LoRA",local:"lora-optimized-lora",headingTag:"h3"}}),De=new M({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_loraplus_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

base_model = ...
config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_loraplus_optimizer(
    model=model,
    optimizer_cls=bnb.optim.Adam8bit,
    lr=<span class="hljs-number">5e-5</span>,
    loraplus_lr_ratio=<span class="hljs-number">16</span>,
)
scheduler = <span class="hljs-literal">None</span>

...
trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),Ke=new y({props:{title:"Efficiently train tokens alongside LoRA",local:"efficiently-train-tokens-alongside-lora",headingTag:"h2"}}),et=new M({props:{code:"JTIzJTIwZm9yJTIwbGF5ZXIlMjAnZW1iZWRfdG9rZW5zJyUwQWNvbmZpZyUyMCUzRCUyMExvcmFDb25maWcodHJhaW5hYmxlX3Rva2VuX2luZGljZXMlM0QlNUJpZHhfMSUyQyUyMGlkeF8yJTJDJTIwLi4uJTVEJTJDJTIwLi4uKSUwQSUwQSUyMyUyMHNwZWNpZmljJTIwZW1iZWRkaW5nJTIwbGF5ZXIlMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTNEJTdCJ2VtYl90b2tlbnMnJTNBJTIwJTVCaWR4XzElMkMlMjBpZHhfMiUyQyUyMC4uLiU1RCU3RCUyQyUyMC4uLik=",highlighted:`<span class="hljs-comment"># for layer &#x27;embed_tokens&#x27;</span>
config = LoraConfig(trainable_token_indices=[idx_1, idx_2, ...], ...)

<span class="hljs-comment"># specific embedding layer</span>
config = LoraConfig(trainable_token_indices={<span class="hljs-string">&#x27;emb_tokens&#x27;</span>: [idx_1, idx_2, ...]}, ...)`,wrap:!1}}),at=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQSUyMyUyMHdlJTIwZGVmaW5lJTIwb3VyJTIwbmV3JTIwdG9rZW5zJTIwYW5kJTIwYWRkJTIwdGhlbSUyMHRvJTIwdGhlJTIwdG9rZW5pemVyJTIwYXMlMjBzcGVjaWFsJTIwdG9rZW5zJTBBc3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUInJTNDJTdDc3RhcnRfdGhpbmslN0MlM0UnJTJDJTIwJyUzQyU3Q3N0b3BfdGhpbmslN0MlM0UnJTVEJTBBdG9rZW5pemVyLmFkZF9zcGVjaWFsX3Rva2VucyglN0InYWRkaXRpb25hbF9zcGVjaWFsX3Rva2VucyclM0ElMjBzcGVjaWFsX3Rva2VucyU3RCklMEElMEElMjMlMjBtYWtlJTIwcm9vbSUyMGZvciUyMG5ldyUyMHRva2VucyUyMGluJTIwdGhlJTIwZW1iZWRkaW5nJTIwbWF0cml4JTIwaWYlMjBpdCUyMGlzbid0JTIwYmlnJTIwZW5vdWdoJTIwYWxyZWFkeSUwQWJhc2VfbW9kZWwucmVzaXplX3Rva2VuX2VtYmVkZGluZ3MobWF4KGxlbih0b2tlbml6ZXIpJTJDJTIwYmFzZV9tb2RlbC5tb2RlbC5lbWJlZF90b2tlbnMubnVtX2VtYmVkZGluZ3MpJTBBJTBBJTIzJTIwdHlwaWNhbCUyMExvUkElMjBjb25maWclMjB3aXRoJTIwJTYwdHJhaW5hYmxlX3Rva2VuX2luZGljZXMlNjAlMjB0YXJnZXRpbmclMjBlbWJlZGRpbmclMjBsYXllciUyMCU2MGVtYmVkX3Rva2VucyU2MCUwQSUyMyUyMGFuZCUyMHNwZWNpZmljYWxseSUyMG91ciUyMG5ldyUyMHRva2VucyUyMHdlJTIwanVzdCUyMGFkZGVkJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJ2FsbC1saW5lYXInJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5hYmxlX3Rva2VuX2luZGljZXMlM0QlN0InZW1iZWRfdG9rZW5zJyUzQSUyMHRva2VuaXplci5jb252ZXJ0X3Rva2Vuc190b19pZHMoc3BlY2lhbF90b2tlbnMpJTdEJTJDJTBBKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwbG9yYV9jb25maWcpJTBBJTBBJTIzJTIwcHJvY2VlZCUyMHRvJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUyMGxpa2UlMjBub3JtYWwlMEElNUIuLi4lNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

<span class="hljs-comment"># we define our new tokens and add them to the tokenizer as special tokens</span>
special_tokens = [<span class="hljs-string">&#x27;&lt;|start_think|&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;|stop_think|&gt;&#x27;</span>]
tokenizer.add_special_tokens({<span class="hljs-string">&#x27;additional_special_tokens&#x27;</span>: special_tokens})

<span class="hljs-comment"># make room for new tokens in the embedding matrix if it isn&#x27;t big enough already</span>
base_model.resize_token_embeddings(<span class="hljs-built_in">max</span>(<span class="hljs-built_in">len</span>(tokenizer), base_model.model.embed_tokens.num_embeddings)

<span class="hljs-comment"># typical LoRA config with \`trainable_token_indices\` targeting embedding layer \`embed_tokens\`</span>
<span class="hljs-comment"># and specifically our new tokens we just added</span>
lora_config = LoraConfig(
    target_modules=<span class="hljs-string">&#x27;all-linear&#x27;</span>,
    trainable_token_indices={<span class="hljs-string">&#x27;embed_tokens&#x27;</span>: tokenizer.convert_tokens_to_ids(special_tokens)},
)
peft_model = get_peft_model(base_model, lora_config)

<span class="hljs-comment"># proceed to train the model like normal</span>
[...]`,wrap:!1}}),st=new y({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),pt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),mt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),ct=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Mt=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),yt=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),j=new ln({props:{$$slots:{default:[Ls]},$$scope:{ctx:T}}}),gt=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),Tt=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),_t=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),jt=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),$t=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Ut=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),Rt=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Wt=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),Vt=new Cs({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){u=o("meta"),b=n(),w=o("p"),g=n(),p($.$$.fragment),At=n(),Z=o("p"),Z.innerHTML=sn,Xt=n(),k=o("p"),k.textContent=on,Qt=n(),p(U.$$.fragment),Ht=n(),C=o("p"),C.innerHTML=rn,zt=n(),R=o("p"),R.innerHTML=pn,Et=n(),p(B.$$.fragment),Ft=n(),L=o("p"),L.innerHTML=dn,qt=n(),p(W.$$.fragment),Yt=n(),p(I.$$.fragment),Nt=n(),G=o("p"),G.innerHTML=mn,St=n(),V=o("p"),V.textContent=fn,Pt=n(),p(x.$$.fragment),Dt=n(),A=o("p"),A.textContent=hn,Kt=n(),p(X.$$.fragment),Ot=n(),Q=o("p"),Q.innerHTML=cn,ea=n(),p(H.$$.fragment),ta=n(),z=o("p"),z.innerHTML=un,aa=n(),E=o("p"),E.textContent=Mn,la=n(),p(F.$$.fragment),na=n(),q=o("p"),q.innerHTML=wn,sa=n(),p(Y.$$.fragment),oa=n(),N=o("p"),N.innerHTML=yn,ia=n(),S=o("p"),S.textContent=bn,ra=n(),p(P.$$.fragment),pa=n(),D=o("p"),D.innerHTML=gn,da=n(),p(K.$$.fragment),ma=n(),O=o("p"),O.innerHTML=Tn,fa=n(),ee=o("p"),ee.innerHTML=Jn,ha=n(),p(te.$$.fragment),ca=n(),ae=o("p"),ae.innerHTML=_n,ua=n(),le=o("p"),le.innerHTML=vn,Ma=n(),p(ne.$$.fragment),wa=n(),se=o("p"),se.innerHTML=jn,ya=n(),p(oe.$$.fragment),ba=n(),ie=o("p"),ie.innerHTML=$n,ga=n(),p(J.$$.fragment),Ta=n(),p(re.$$.fragment),Ja=n(),p(pe.$$.fragment),_a=n(),de=o("p"),de.innerHTML=Zn,va=n(),me=o("p"),me.innerHTML=kn,ja=n(),p(fe.$$.fragment),$a=n(),he=o("p"),he.innerHTML=Un,Za=n(),p(ce.$$.fragment),ka=n(),ue=o("p"),ue.innerHTML=Cn,Ua=n(),Me=o("p"),Me.innerHTML=Rn,Ca=n(),we=o("p"),we.innerHTML=Bn,Ra=n(),ye=o("ul"),ye.innerHTML=Ln,Ba=n(),p(_.$$.fragment),La=n(),p(be.$$.fragment),Wa=n(),ge=o("p"),ge.innerHTML=Wn,Ia=n(),p(Te.$$.fragment),Ga=n(),p(Je.$$.fragment),Va=n(),_e=o("p"),_e.innerHTML=In,xa=n(),p(ve.$$.fragment),Aa=n(),je=o("p"),je.innerHTML=Gn,Xa=n(),p($e.$$.fragment),Qa=n(),Ze=o("p"),Ze.innerHTML=Vn,Ha=n(),p(ke.$$.fragment),za=n(),Ue=o("p"),Ue.innerHTML=xn,Ea=n(),Ce=o("table"),Ce.innerHTML=An,Fa=n(),p(Re.$$.fragment),qa=n(),Be=o("ul"),Be.innerHTML=Xn,Ya=n(),p(Le.$$.fragment),Na=n(),We=o("p"),We.innerHTML=Qn,Sa=n(),p(Ie.$$.fragment),Pa=n(),p(Ge.$$.fragment),Da=n(),Ve=o("p"),Ve.innerHTML=Hn,Ka=n(),p(xe.$$.fragment),Oa=n(),Ae=o("p"),Ae.innerHTML=zn,el=n(),Xe=o("p"),Xe.innerHTML=En,tl=n(),p(Qe.$$.fragment),al=n(),He=o("p"),He.innerHTML=Fn,ll=n(),ze=o("p"),ze.textContent=qn,nl=n(),p(Ee.$$.fragment),sl=n(),Fe=o("ul"),Fe.innerHTML=Yn,ol=n(),qe=o("p"),qe.innerHTML=Nn,il=n(),p(Ye.$$.fragment),rl=n(),Ne=o("p"),Ne.textContent=Sn,pl=n(),p(Se.$$.fragment),dl=n(),Pe=o("p"),Pe.innerHTML=Pn,ml=n(),p(De.$$.fragment),fl=n(),p(Ke.$$.fragment),hl=n(),Oe=o("p"),Oe.innerHTML=Dn,cl=n(),p(et.$$.fragment),ul=n(),tt=o("p"),tt.textContent=Kn,Ml=n(),p(at.$$.fragment),wl=n(),lt=o("p"),lt.innerHTML=On,yl=n(),nt=o("p"),nt.innerHTML=es,bl=n(),p(st.$$.fragment),gl=n(),ot=o("p"),ot.innerHTML=ts,Tl=n(),it=o("p"),it.textContent=as,Jl=n(),v=o("div"),v.innerHTML=ls,_l=n(),rt=o("p"),rt.textContent=ns,vl=n(),p(pt.$$.fragment),jl=n(),dt=o("p"),dt.innerHTML=ss,$l=n(),p(mt.$$.fragment),Zl=n(),ft=o("p"),ft.innerHTML=os,kl=n(),ht=o("p"),ht.textContent=is,Ul=n(),p(ct.$$.fragment),Cl=n(),ut=o("p"),ut.textContent=rs,Rl=n(),p(Mt.$$.fragment),Bl=n(),wt=o("p"),wt.textContent=ps,Ll=n(),p(yt.$$.fragment),Wl=n(),p(j.$$.fragment),Il=n(),bt=o("p"),bt.textContent=ds,Gl=n(),p(gt.$$.fragment),Vl=n(),p(Tt.$$.fragment),xl=n(),Jt=o("p"),Jt.innerHTML=ms,Al=n(),p(_t.$$.fragment),Xl=n(),vt=o("p"),vt.innerHTML=fs,Ql=n(),p(jt.$$.fragment),Hl=n(),p($t.$$.fragment),zl=n(),Zt=o("p"),Zt.textContent=hs,El=n(),kt=o("p"),kt.innerHTML=cs,Fl=n(),p(Ut.$$.fragment),ql=n(),Ct=o("p"),Ct.innerHTML=us,Yl=n(),p(Rt.$$.fragment),Nl=n(),Bt=o("p"),Bt.innerHTML=Ms,Sl=n(),Lt=o("p"),Lt.innerHTML=ws,Pl=n(),p(Wt.$$.fragment),Dl=n(),It=o("p"),It.textContent=ys,Kl=n(),Gt=o("ul"),Gt.innerHTML=bs,Ol=n(),p(Vt.$$.fragment),en=n(),xt=o("p"),this.h()},l(e){const t=ks("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(a),b=s(e),w=i(e,"P",{}),_s(w).forEach(a),g=s(e),d($.$$.fragment,e),At=s(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-147g1uz"&&(Z.innerHTML=sn),Xt=s(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-ovsn32"&&(k.textContent=on),Qt=s(e),d(U.$$.fragment,e),Ht=s(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-17xgkc2"&&(C.innerHTML=rn),zt=s(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1fujb7a"&&(R.innerHTML=pn),Et=s(e),d(B.$$.fragment,e),Ft=s(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-mwvui1"&&(L.innerHTML=dn),qt=s(e),d(W.$$.fragment,e),Yt=s(e),d(I.$$.fragment,e),Nt=s(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-p4dbd4"&&(G.innerHTML=mn),St=s(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1hy0lgx"&&(V.textContent=fn),Pt=s(e),d(x.$$.fragment,e),Dt=s(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-auzrbb"&&(A.textContent=hn),Kt=s(e),d(X.$$.fragment,e),Ot=s(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-16k39wq"&&(Q.innerHTML=cn),ea=s(e),d(H.$$.fragment,e),ta=s(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-15qnrt6"&&(z.innerHTML=un),aa=s(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1s3c5rd"&&(E.textContent=Mn),la=s(e),d(F.$$.fragment,e),na=s(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-19qemwc"&&(q.innerHTML=wn),sa=s(e),d(Y.$$.fragment,e),oa=s(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-17kc0j8"&&(N.innerHTML=yn),ia=s(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1j9g8qn"&&(S.textContent=bn),ra=s(e),d(P.$$.fragment,e),pa=s(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-sulxp4"&&(D.innerHTML=gn),da=s(e),d(K.$$.fragment,e),ma=s(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-jrbt6r"&&(O.innerHTML=Tn),fa=s(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1dy99cw"&&(ee.innerHTML=Jn),ha=s(e),d(te.$$.fragment,e),ca=s(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-168zxvb"&&(ae.innerHTML=_n),ua=s(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1gj8j2w"&&(le.innerHTML=vn),Ma=s(e),d(ne.$$.fragment,e),wa=s(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1yza7ax"&&(se.innerHTML=jn),ya=s(e),d(oe.$$.fragment,e),ba=s(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-19dc8ve"&&(ie.innerHTML=$n),ga=s(e),d(J.$$.fragment,e),Ta=s(e),d(re.$$.fragment,e),Ja=s(e),d(pe.$$.fragment,e),_a=s(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1ts8vpq"&&(de.innerHTML=Zn),va=s(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-7f0aai"&&(me.innerHTML=kn),ja=s(e),d(fe.$$.fragment,e),$a=s(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-14vtcq9"&&(he.innerHTML=Un),Za=s(e),d(ce.$$.fragment,e),ka=s(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1nywyxh"&&(ue.innerHTML=Cn),Ua=s(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1d2jix1"&&(Me.innerHTML=Rn),Ca=s(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-yl8kok"&&(we.innerHTML=Bn),Ra=s(e),ye=i(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-12tl4fy"&&(ye.innerHTML=Ln),Ba=s(e),d(_.$$.fragment,e),La=s(e),d(be.$$.fragment,e),Wa=s(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-tupcre"&&(ge.innerHTML=Wn),Ia=s(e),d(Te.$$.fragment,e),Ga=s(e),d(Je.$$.fragment,e),Va=s(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1ukfkwt"&&(_e.innerHTML=In),xa=s(e),d(ve.$$.fragment,e),Aa=s(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-8wzhde"&&(je.innerHTML=Gn),Xa=s(e),d($e.$$.fragment,e),Qa=s(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-16lyt50"&&(Ze.innerHTML=Vn),Ha=s(e),d(ke.$$.fragment,e),za=s(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-zr3cxq"&&(Ue.innerHTML=xn),Ea=s(e),Ce=i(e,"TABLE",{"data-svelte-h":!0}),r(Ce)!=="svelte-1iyfgt7"&&(Ce.innerHTML=An),Fa=s(e),d(Re.$$.fragment,e),qa=s(e),Be=i(e,"UL",{"data-svelte-h":!0}),r(Be)!=="svelte-3tasxa"&&(Be.innerHTML=Xn),Ya=s(e),d(Le.$$.fragment,e),Na=s(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-15vxux2"&&(We.innerHTML=Qn),Sa=s(e),d(Ie.$$.fragment,e),Pa=s(e),d(Ge.$$.fragment,e),Da=s(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1mosto0"&&(Ve.innerHTML=Hn),Ka=s(e),d(xe.$$.fragment,e),Oa=s(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1ttqqw0"&&(Ae.innerHTML=zn),el=s(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-foj0wd"&&(Xe.innerHTML=En),tl=s(e),d(Qe.$$.fragment,e),al=s(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-ik9loz"&&(He.innerHTML=Fn),ll=s(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1s2ho3d"&&(ze.textContent=qn),nl=s(e),d(Ee.$$.fragment,e),sl=s(e),Fe=i(e,"UL",{"data-svelte-h":!0}),r(Fe)!=="svelte-1qf6hnm"&&(Fe.innerHTML=Yn),ol=s(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-qh5siy"&&(qe.innerHTML=Nn),il=s(e),d(Ye.$$.fragment,e),rl=s(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-rkzqzi"&&(Ne.textContent=Sn),pl=s(e),d(Se.$$.fragment,e),dl=s(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-9dmo2s"&&(Pe.innerHTML=Pn),ml=s(e),d(De.$$.fragment,e),fl=s(e),d(Ke.$$.fragment,e),hl=s(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-113ki37"&&(Oe.innerHTML=Dn),cl=s(e),d(et.$$.fragment,e),ul=s(e),tt=i(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-66nz7l"&&(tt.textContent=Kn),Ml=s(e),d(at.$$.fragment,e),wl=s(e),lt=i(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-32mf1g"&&(lt.innerHTML=On),yl=s(e),nt=i(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-sspyjf"&&(nt.innerHTML=es),bl=s(e),d(st.$$.fragment,e),gl=s(e),ot=i(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-nzl5a8"&&(ot.innerHTML=ts),Tl=s(e),it=i(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1wwmf5r"&&(it.textContent=as),Jl=s(e),v=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1f6iuw5"&&(v.innerHTML=ls),_l=s(e),rt=i(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-hlzwis"&&(rt.textContent=ns),vl=s(e),d(pt.$$.fragment,e),jl=s(e),dt=i(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1s1i8g1"&&(dt.innerHTML=ss),$l=s(e),d(mt.$$.fragment,e),Zl=s(e),ft=i(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-yov2ak"&&(ft.innerHTML=os),kl=s(e),ht=i(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1mwdwt1"&&(ht.textContent=is),Ul=s(e),d(ct.$$.fragment,e),Cl=s(e),ut=i(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1lnmg1d"&&(ut.textContent=rs),Rl=s(e),d(Mt.$$.fragment,e),Bl=s(e),wt=i(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1n53hd9"&&(wt.textContent=ps),Ll=s(e),d(yt.$$.fragment,e),Wl=s(e),d(j.$$.fragment,e),Il=s(e),bt=i(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-qwbdkg"&&(bt.textContent=ds),Gl=s(e),d(gt.$$.fragment,e),Vl=s(e),d(Tt.$$.fragment,e),xl=s(e),Jt=i(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1to8xcq"&&(Jt.innerHTML=ms),Al=s(e),d(_t.$$.fragment,e),Xl=s(e),vt=i(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-i25fa2"&&(vt.innerHTML=fs),Ql=s(e),d(jt.$$.fragment,e),Hl=s(e),d($t.$$.fragment,e),zl=s(e),Zt=i(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1fq5tpu"&&(Zt.textContent=hs),El=s(e),kt=i(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-lcywla"&&(kt.innerHTML=cs),Fl=s(e),d(Ut.$$.fragment,e),ql=s(e),Ct=i(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-6wkyom"&&(Ct.innerHTML=us),Yl=s(e),d(Rt.$$.fragment,e),Nl=s(e),Bt=i(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1o40ch6"&&(Bt.innerHTML=Ms),Sl=s(e),Lt=i(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-mqf2jo"&&(Lt.innerHTML=ws),Pl=s(e),d(Wt.$$.fragment,e),Dl=s(e),It=i(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-fpz5mj"&&(It.textContent=ys),Kl=s(e),Gt=i(e,"UL",{"data-svelte-h":!0}),r(Gt)!=="svelte-150o10n"&&(Gt.innerHTML=bs),Ol=s(e),d(Vt.$$.fragment,e),en=s(e),xt=i(e,"P",{}),_s(xt).forEach(a),this.h()},h(){an(u,"name","hf:doc:metadata"),an(u,"content",Is),an(v,"class","flex justify-center")},m(e,t){Us(document.head,u),l(e,b,t),l(e,w,t),l(e,g,t),m($,e,t),l(e,At,t),l(e,Z,t),l(e,Xt,t),l(e,k,t),l(e,Qt,t),m(U,e,t),l(e,Ht,t),l(e,C,t),l(e,zt,t),l(e,R,t),l(e,Et,t),m(B,e,t),l(e,Ft,t),l(e,L,t),l(e,qt,t),m(W,e,t),l(e,Yt,t),m(I,e,t),l(e,Nt,t),l(e,G,t),l(e,St,t),l(e,V,t),l(e,Pt,t),m(x,e,t),l(e,Dt,t),l(e,A,t),l(e,Kt,t),m(X,e,t),l(e,Ot,t),l(e,Q,t),l(e,ea,t),m(H,e,t),l(e,ta,t),l(e,z,t),l(e,aa,t),l(e,E,t),l(e,la,t),m(F,e,t),l(e,na,t),l(e,q,t),l(e,sa,t),m(Y,e,t),l(e,oa,t),l(e,N,t),l(e,ia,t),l(e,S,t),l(e,ra,t),m(P,e,t),l(e,pa,t),l(e,D,t),l(e,da,t),m(K,e,t),l(e,ma,t),l(e,O,t),l(e,fa,t),l(e,ee,t),l(e,ha,t),m(te,e,t),l(e,ca,t),l(e,ae,t),l(e,ua,t),l(e,le,t),l(e,Ma,t),m(ne,e,t),l(e,wa,t),l(e,se,t),l(e,ya,t),m(oe,e,t),l(e,ba,t),l(e,ie,t),l(e,ga,t),m(J,e,t),l(e,Ta,t),m(re,e,t),l(e,Ja,t),m(pe,e,t),l(e,_a,t),l(e,de,t),l(e,va,t),l(e,me,t),l(e,ja,t),m(fe,e,t),l(e,$a,t),l(e,he,t),l(e,Za,t),m(ce,e,t),l(e,ka,t),l(e,ue,t),l(e,Ua,t),l(e,Me,t),l(e,Ca,t),l(e,we,t),l(e,Ra,t),l(e,ye,t),l(e,Ba,t),m(_,e,t),l(e,La,t),m(be,e,t),l(e,Wa,t),l(e,ge,t),l(e,Ia,t),m(Te,e,t),l(e,Ga,t),m(Je,e,t),l(e,Va,t),l(e,_e,t),l(e,xa,t),m(ve,e,t),l(e,Aa,t),l(e,je,t),l(e,Xa,t),m($e,e,t),l(e,Qa,t),l(e,Ze,t),l(e,Ha,t),m(ke,e,t),l(e,za,t),l(e,Ue,t),l(e,Ea,t),l(e,Ce,t),l(e,Fa,t),m(Re,e,t),l(e,qa,t),l(e,Be,t),l(e,Ya,t),m(Le,e,t),l(e,Na,t),l(e,We,t),l(e,Sa,t),m(Ie,e,t),l(e,Pa,t),m(Ge,e,t),l(e,Da,t),l(e,Ve,t),l(e,Ka,t),m(xe,e,t),l(e,Oa,t),l(e,Ae,t),l(e,el,t),l(e,Xe,t),l(e,tl,t),m(Qe,e,t),l(e,al,t),l(e,He,t),l(e,ll,t),l(e,ze,t),l(e,nl,t),m(Ee,e,t),l(e,sl,t),l(e,Fe,t),l(e,ol,t),l(e,qe,t),l(e,il,t),m(Ye,e,t),l(e,rl,t),l(e,Ne,t),l(e,pl,t),m(Se,e,t),l(e,dl,t),l(e,Pe,t),l(e,ml,t),m(De,e,t),l(e,fl,t),m(Ke,e,t),l(e,hl,t),l(e,Oe,t),l(e,cl,t),m(et,e,t),l(e,ul,t),l(e,tt,t),l(e,Ml,t),m(at,e,t),l(e,wl,t),l(e,lt,t),l(e,yl,t),l(e,nt,t),l(e,bl,t),m(st,e,t),l(e,gl,t),l(e,ot,t),l(e,Tl,t),l(e,it,t),l(e,Jl,t),l(e,v,t),l(e,_l,t),l(e,rt,t),l(e,vl,t),m(pt,e,t),l(e,jl,t),l(e,dt,t),l(e,$l,t),m(mt,e,t),l(e,Zl,t),l(e,ft,t),l(e,kl,t),l(e,ht,t),l(e,Ul,t),m(ct,e,t),l(e,Cl,t),l(e,ut,t),l(e,Rl,t),m(Mt,e,t),l(e,Bl,t),l(e,wt,t),l(e,Ll,t),m(yt,e,t),l(e,Wl,t),m(j,e,t),l(e,Il,t),l(e,bt,t),l(e,Gl,t),m(gt,e,t),l(e,Vl,t),m(Tt,e,t),l(e,xl,t),l(e,Jt,t),l(e,Al,t),m(_t,e,t),l(e,Xl,t),l(e,vt,t),l(e,Ql,t),m(jt,e,t),l(e,Hl,t),m($t,e,t),l(e,zl,t),l(e,Zt,t),l(e,El,t),l(e,kt,t),l(e,Fl,t),m(Ut,e,t),l(e,ql,t),l(e,Ct,t),l(e,Yl,t),m(Rt,e,t),l(e,Nl,t),l(e,Bt,t),l(e,Sl,t),l(e,Lt,t),l(e,Pl,t),m(Wt,e,t),l(e,Dl,t),l(e,It,t),l(e,Kl,t),l(e,Gt,t),l(e,Ol,t),m(Vt,e,t),l(e,en,t),l(e,xt,t),tn=!0},p(e,[t]){const gs={};t&2&&(gs.$$scope={dirty:t,ctx:e}),J.$set(gs);const Ts={};t&2&&(Ts.$$scope={dirty:t,ctx:e}),_.$set(Ts);const Js={};t&2&&(Js.$$scope={dirty:t,ctx:e}),j.$set(Js)},i(e){tn||(f($.$$.fragment,e),f(U.$$.fragment,e),f(B.$$.fragment,e),f(W.$$.fragment,e),f(I.$$.fragment,e),f(x.$$.fragment,e),f(X.$$.fragment,e),f(H.$$.fragment,e),f(F.$$.fragment,e),f(Y.$$.fragment,e),f(P.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(J.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(fe.$$.fragment,e),f(ce.$$.fragment,e),f(_.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(Je.$$.fragment,e),f(ve.$$.fragment,e),f($e.$$.fragment,e),f(ke.$$.fragment,e),f(Re.$$.fragment,e),f(Le.$$.fragment,e),f(Ie.$$.fragment,e),f(Ge.$$.fragment,e),f(xe.$$.fragment,e),f(Qe.$$.fragment,e),f(Ee.$$.fragment,e),f(Ye.$$.fragment,e),f(Se.$$.fragment,e),f(De.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(at.$$.fragment,e),f(st.$$.fragment,e),f(pt.$$.fragment,e),f(mt.$$.fragment,e),f(ct.$$.fragment,e),f(Mt.$$.fragment,e),f(yt.$$.fragment,e),f(j.$$.fragment,e),f(gt.$$.fragment,e),f(Tt.$$.fragment,e),f(_t.$$.fragment,e),f(jt.$$.fragment,e),f($t.$$.fragment,e),f(Ut.$$.fragment,e),f(Rt.$$.fragment,e),f(Wt.$$.fragment,e),f(Vt.$$.fragment,e),tn=!0)},o(e){h($.$$.fragment,e),h(U.$$.fragment,e),h(B.$$.fragment,e),h(W.$$.fragment,e),h(I.$$.fragment,e),h(x.$$.fragment,e),h(X.$$.fragment,e),h(H.$$.fragment,e),h(F.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(J.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(fe.$$.fragment,e),h(ce.$$.fragment,e),h(_.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(ve.$$.fragment,e),h($e.$$.fragment,e),h(ke.$$.fragment,e),h(Re.$$.fragment,e),h(Le.$$.fragment,e),h(Ie.$$.fragment,e),h(Ge.$$.fragment,e),h(xe.$$.fragment,e),h(Qe.$$.fragment,e),h(Ee.$$.fragment,e),h(Ye.$$.fragment,e),h(Se.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(at.$$.fragment,e),h(st.$$.fragment,e),h(pt.$$.fragment,e),h(mt.$$.fragment,e),h(ct.$$.fragment,e),h(Mt.$$.fragment,e),h(yt.$$.fragment,e),h(j.$$.fragment,e),h(gt.$$.fragment,e),h(Tt.$$.fragment,e),h(_t.$$.fragment,e),h(jt.$$.fragment,e),h($t.$$.fragment,e),h(Ut.$$.fragment,e),h(Rt.$$.fragment,e),h(Wt.$$.fragment,e),h(Vt.$$.fragment,e),tn=!1},d(e){e&&(a(b),a(w),a(g),a(At),a(Z),a(Xt),a(k),a(Qt),a(Ht),a(C),a(zt),a(R),a(Et),a(Ft),a(L),a(qt),a(Yt),a(Nt),a(G),a(St),a(V),a(Pt),a(Dt),a(A),a(Kt),a(Ot),a(Q),a(ea),a(ta),a(z),a(aa),a(E),a(la),a(na),a(q),a(sa),a(oa),a(N),a(ia),a(S),a(ra),a(pa),a(D),a(da),a(ma),a(O),a(fa),a(ee),a(ha),a(ca),a(ae),a(ua),a(le),a(Ma),a(wa),a(se),a(ya),a(ba),a(ie),a(ga),a(Ta),a(Ja),a(_a),a(de),a(va),a(me),a(ja),a($a),a(he),a(Za),a(ka),a(ue),a(Ua),a(Me),a(Ca),a(we),a(Ra),a(ye),a(Ba),a(La),a(Wa),a(ge),a(Ia),a(Ga),a(Va),a(_e),a(xa),a(Aa),a(je),a(Xa),a(Qa),a(Ze),a(Ha),a(za),a(Ue),a(Ea),a(Ce),a(Fa),a(qa),a(Be),a(Ya),a(Na),a(We),a(Sa),a(Pa),a(Da),a(Ve),a(Ka),a(Oa),a(Ae),a(el),a(Xe),a(tl),a(al),a(He),a(ll),a(ze),a(nl),a(sl),a(Fe),a(ol),a(qe),a(il),a(rl),a(Ne),a(pl),a(dl),a(Pe),a(ml),a(fl),a(hl),a(Oe),a(cl),a(ul),a(tt),a(Ml),a(wl),a(lt),a(yl),a(nt),a(bl),a(gl),a(ot),a(Tl),a(it),a(Jl),a(v),a(_l),a(rt),a(vl),a(jl),a(dt),a($l),a(Zl),a(ft),a(kl),a(ht),a(Ul),a(Cl),a(ut),a(Rl),a(Bl),a(wt),a(Ll),a(Wl),a(Il),a(bt),a(Gl),a(Vl),a(xl),a(Jt),a(Al),a(Xl),a(vt),a(Ql),a(Hl),a(zl),a(Zt),a(El),a(kt),a(Fl),a(ql),a(Ct),a(Yl),a(Nl),a(Bt),a(Sl),a(Lt),a(Pl),a(Dl),a(It),a(Kl),a(Gt),a(Ol),a(en),a(xt)),a(u),c($,e),c(U,e),c(B,e),c(W,e),c(I,e),c(x,e),c(X,e),c(H,e),c(F,e),c(Y,e),c(P,e),c(K,e),c(te,e),c(ne,e),c(oe,e),c(J,e),c(re,e),c(pe,e),c(fe,e),c(ce,e),c(_,e),c(be,e),c(Te,e),c(Je,e),c(ve,e),c($e,e),c(ke,e),c(Re,e),c(Le,e),c(Ie,e),c(Ge,e),c(xe,e),c(Qe,e),c(Ee,e),c(Ye,e),c(Se,e),c(De,e),c(Ke,e),c(et,e),c(at,e),c(st,e),c(pt,e),c(mt,e),c(ct,e),c(Mt,e),c(yt,e),c(j,e),c(gt,e),c(Tt,e),c(_t,e),c(jt,e),c($t,e),c(Ut,e),c(Rt,e),c(Wt,e),c(Vt,e)}}}const Is='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"CorDA","local":"corda","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"EVA","local":"eva","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convenient way","local":"a-more-convenient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3},{"title":"Fine grained control over ranks and alpha (scaling)","local":"fine-grained-control-over-ranks-and-alpha-scaling","sections":[],"depth":3}],"depth":2},{"title":"Optimizers","local":"optimizers","sections":[{"title":"LoRA+ optimized LoRA","local":"lora-optimized-lora","sections":[],"depth":3}],"depth":2},{"title":"Efficiently train tokens alongside LoRA","local":"efficiently-train-tokens-alongside-lora","sections":[],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function Gs(T){return js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends $s{constructor(u){super(),Zs(this,u,Gs,Ws,vs,{})}}export{Hs as component};
