import{s as Gt,o as kt,n as Oe}from"../chunks/scheduler.182ea377.js";import{S as Bt,i as Zt,g as l,s as i,r as h,A as Xt,h as r,f as n,c as o,j as _e,u,x as d,k as be,y as f,a,v as g,d as _,t as b,w as x}from"../chunks/index.abf12888.js";import{T as rt}from"../chunks/Tip.230e2334.js";import{D as ze}from"../chunks/Docstring.93f6f462.js";import{C as ce}from"../chunks/CodeBlock.57fe6e13.js";import{E as Lt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as pt}from"../chunks/Heading.16916d63.js";function Et(A){let s,M='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){s=l("p"),s.innerHTML=M},l(p){s=r(p,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1wmc0l4"&&(s.innerHTML=M)},m(p,m){a(p,s,m)},p:Oe,d(p){p&&n(s)}}}function Ht(A){let s,M="Notice that while initializing <code>pipe</code>, you’re setting <code>text_encoder</code> to <code>None</code> so that it’s not loaded.";return{c(){s=l("p"),s.innerHTML=M},l(p){s=r(p,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1of5pjk"&&(s.innerHTML=M)},m(p,m){a(p,s,m)},p:Oe,d(p){p&&n(s)}}}function Wt(A){let s,M="Text embeddings computed in 8-bit can impact the quality of the generated images because of the information loss in the representation space caused by the reduced precision. It’s recommended to compare the outputs with and without 8-bit.";return{c(){s=l("p"),s.textContent=M},l(p){s=r(p,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1rutysd"&&(s.textContent=M)},m(p,m){a(p,s,m)},p:Oe,d(p){p&&n(s)}}}function Rt(A){let s,M="Examples:",p,m,T;return m=new ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUGl4QXJ0QWxwaGFQaXBlbGluZSUwQSUwQSUyMyUyMFlvdSUyMGNhbiUyMHJlcGxhY2UlMjB0aGUlMjBjaGVja3BvaW50JTIwaWQlMjB3aXRoJTIwJTIyUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVhMLTItNTEyeDUxMiUyMiUyMHRvby4lMEFwaXBlJTIwJTNEJTIwUGl4QXJ0QWxwaGFQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVhMLTItMTAyNC1NUyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMjMlMjBFbmFibGUlMjBtZW1vcnklMjBvcHRpbWl6YXRpb25zLiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwc21hbGwlMjBjYWN0dXMlMjB3aXRoJTIwYSUyMGhhcHB5JTIwZmFjZSUyMGluJTIwdGhlJTIwU2FoYXJhJTIwZGVzZXJ0LiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtAlphaPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can replace the checkpoint id with &quot;PixArt-alpha/PixArt-XL-2-512x512&quot; too.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = PixArtAlphaPipeline.from_pretrained(<span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable memory optimizations.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small cactus with a happy face in the Sahara desert.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=l("p"),s.textContent=M,p=i(),h(m.$$.fragment)},l(c){s=r(c,"P",{"data-svelte-h":!0}),d(s)!=="svelte-kvfsh7"&&(s.textContent=M),p=o(c),u(m.$$.fragment,c)},m(c,y){a(c,s,y),a(c,p,y),g(m,c,y),T=!0},p:Oe,i(c){T||(_(m.$$.fragment,c),T=!0)},o(c){b(m.$$.fragment,c),T=!1},d(c){c&&(n(s),n(p)),x(m,c)}}}function Vt(A){let s,M,p,m,T,c,y,dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/header_collage.png"/>',we,k,ct='<a href="https://huggingface.co/papers/2310.00426" rel="nofollow">PixArt-α: Fast Training of Diffusion Transformer for Photorealistic Text-to-Image Synthesis</a> is Junsong Chen, Jincheng Yu, Chongjian Ge, Lewei Yao, Enze Xie, Yue Wu, Zhongdao Wang, James Kwok, Ping Luo, Huchuan Lu, and Zhenguo Li.',Me,B,mt="The abstract from the paper is:",ve,Z,ft="<em>The most advanced text-to-image (T2I) models require significant training costs (e.g., millions of GPU hours), seriously hindering the fundamental innovation for the AIGC community while increasing CO2 emissions. This paper introduces PIXART-α, a Transformer-based T2I diffusion model whose image generation quality is competitive with state-of-the-art image generators (e.g., Imagen, SDXL, and even Midjourney), reaching near-commercial application standards. Additionally, it supports high-resolution image synthesis up to 1024px resolution with low training cost, as shown in Figure 1 and 2. To achieve this goal, three core designs are proposed: (1) Training strategy decomposition: We devise three distinct training steps that separately optimize pixel dependency, text-image alignment, and image aesthetic quality; (2) Efficient T2I Transformer: We incorporate cross-attention modules into Diffusion Transformer (DiT) to inject text conditions and streamline the computation-intensive class-condition branch; (3) High-informative data: We emphasize the significance of concept density in text-image pairs and leverage a large Vision-Language model to auto-label dense pseudo-captions to assist text-image alignment learning. As a result, PIXART-α’s training speed markedly surpasses existing large-scale T2I models, e.g., PIXART-α only takes 10.8% of Stable Diffusion v1.5’s training time (675 vs. 6,250 A100 GPU days), saving nearly $300,000 ($26,000 vs. $320,000) and reducing 90% CO2 emissions. Moreover, compared with a larger SOTA model, RAPHAEL, our training cost is merely 1%. Extensive experiments demonstrate that PIXART-α excels in image quality, artistry, and semantic control. We hope PIXART-α will provide new insights to the AIGC community and startups to accelerate building their own high-quality yet low-cost generative models from scratch.</em>",Te,X,ht='You can find the original codebase at <a href="https://github.com/PixArt-alpha/PixArt-alpha" rel="nofollow">PixArt-alpha/PixArt-alpha</a> and all the available checkpoints at <a href="https://huggingface.co/PixArt-alpha" rel="nofollow">PixArt-alpha</a>.',ye,L,ut="Some notes about this pipeline:",Ae,E,gt='<li>It uses a Transformer backbone (instead of a UNet) for denoising. As such it has a similar architecture as <a href="./dit">DiT</a>.</li> <li>It was trained using text conditions computed from T5. This aspect makes the pipeline better at following complex text prompts with intricate details.</li> <li>It is good at producing high-resolution images at different aspect ratios. To get the best results, the authors recommend some size brackets which can be found <a href="https://github.com/PixArt-alpha/PixArt-alpha/blob/08fbbd281ec96866109bdd2cdb75f2f58fb17610/diffusion/data/datasets/utils.py" rel="nofollow">here</a>.</li> <li>It rivals the quality of state-of-the-art text-to-image generation systems (as of this writing) such as Stable Diffusion XL, Imagen, and DALL-E 2, while being more efficient than them.</li>',Pe,J,$e,H,Je,W,_t='Run the <a href="/docs/diffusers/main/en/api/pipelines/pixart#diffusers.PixArtAlphaPipeline">PixArtAlphaPipeline</a> with under 8GB GPU VRAM by loading the text encoder in 8-bit precision. Let’s walk through a full-fledged example.',je,R,bt='First, install the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library:',Ie,V,Ue,Q,xt="Then load the text encoder in 8-bit:",Ce,q,Ge,F,wt="Now, use the <code>pipe</code> to encode a prompt:",ke,N,Be,S,Mt="Since text embeddings have been computed, remove the <code>text_encoder</code> and <code>pipe</code> from the memory, and free up som GPU VRAM:",Ze,Y,Xe,D,vt="Then compute the latents with the prompt embeddings as inputs:",Le,z,Ee,j,He,O,Tt="Once the latents are computed, pass it off to the VAE to decode into a real image:",We,K,Re,ee,yt='By deleting components you aren’t using and flushing the GPU VRAM, you should be able to run <a href="/docs/diffusers/main/en/api/pipelines/pixart#diffusers.PixArtAlphaPipeline">PixArtAlphaPipeline</a> with under 8GB GPU VRAM.',Ve,te,At='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/pixart/8bits_cat.png"/>',Qe,ne,Pt='If you want a report of your memory-usage, run this <a href="https://gist.github.com/sayakpaul/3ae0f847001d342af27018a96f467e4e" rel="nofollow">script</a>.',qe,I,Fe,ae,$t="While loading the <code>text_encoder</code>, you set <code>load_in_8bit</code> to <code>True</code>. You could also specify <code>load_in_4bit</code> to bring your memory requirements down even further to under 7GB.",Ne,ie,Se,w,oe,Ke,me,Jt="Pipeline for text-to-image generation using PixArt-Alpha.",et,fe,jt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,tt,P,se,nt,he,It="Function invoked when calling the pipeline for generation.",at,U,it,C,le,ot,ue,Ut="Returns binned height and width.",st,G,re,lt,ge,Ct="Encodes the prompt into text encoder hidden states.",Ye,xe,De;return T=new pt({props:{title:"PixArt-α",local:"pixart-α",headingTag:"h1"}}),J=new rt({props:{$$slots:{default:[Et]},$$scope:{ctx:A}}}),H=new pt({props:{title:"Inference with under 8GB GPU VRAM",local:"inference-with-under-8gb-gpu-vram",headingTag:"h2"}}),V=new ce({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U bitsandbytes",wrap:!1}}),q=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFBpeEFydEFscGhhUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTBBKSUwQXBpcGUlMjAlM0QlMjBQaXhBcnRBbHBoYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJQaXhBcnQtYWxwaGElMkZQaXhBcnQtWEwtMi0xMDI0LU1TJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTNEdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> PixArtAlphaPipeline
<span class="hljs-keyword">import</span> torch

text_encoder = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,

)
pipe = PixArtAlphaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>,
    text_encoder=text_encoder,
    transformer=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),N=new ce({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmN1dGUlMjBjYXQlMjIlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTJDJTIwcHJvbXB0X2F0dGVudGlvbl9tYXNrJTJDJTIwbmVnYXRpdmVfZW1iZWRzJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2F0dGVudGlvbl9tYXNrJTIwJTNEJTIwcGlwZS5lbmNvZGVfcHJvbXB0KHByb21wdCk=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    prompt = <span class="hljs-string">&quot;cute cat&quot;</span>
    prompt_embeds, prompt_attention_mask, negative_embeds, negative_prompt_attention_mask = pipe.encode_prompt(prompt)`,wrap:!1}}),Y=new ce({props:{code:"aW1wb3J0JTIwZ2MlMjAlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTBBZGVsJTIwdGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZSUwQWZsdXNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gc 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()

<span class="hljs-keyword">del</span> text_encoder
<span class="hljs-keyword">del</span> pipe
flush()`,wrap:!1}}),z=new ce({props:{code:"cGlwZSUyMCUzRCUyMFBpeEFydEFscGhhUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlBpeEFydC1hbHBoYSUyRlBpeEFydC1YTC0yLTEwMjQtTVMlMjIlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWxhdGVudHMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRE5vbmUlMkMlMjAlMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfYXR0ZW50aW9uX21hc2slM0Rwcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slM0RuZWdhdGl2ZV9wcm9tcHRfYXR0ZW50aW9uX21hc2slMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIlMkMlMEEpLmltYWdlcyUwQSUwQWRlbCUyMHBpcGUudHJhbnNmb3JtZXIlMEFmbHVzaCgp",highlighted:`pipe = PixArtAlphaPipeline.from_pretrained(
    <span class="hljs-string">&quot;PixArt-alpha/PixArt-XL-2-1024-MS&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

latents = pipe(
    negative_prompt=<span class="hljs-literal">None</span>, 
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    prompt_attention_mask=prompt_attention_mask,
    negative_prompt_attention_mask=negative_prompt_attention_mask,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images

<span class="hljs-keyword">del</span> pipe.transformer
flush()`,wrap:!1}}),j=new rt({props:{$$slots:{default:[Ht]},$$scope:{ctx:A}}}),K=new ce({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZS52YWUuZGVjb2RlKGxhdGVudHMlMjAlMkYlMjBwaXBlLnZhZS5jb25maWcuc2NhbGluZ19mYWN0b3IlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSU1QjAlNUQlMEFpbWFnZSUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLnBvc3Rwcm9jZXNzKGltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIpJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    image = pipe.vae.decode(latents / pipe.vae.config.scaling_factor, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
image = pipe.image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),I=new rt({props:{warning:!0,$$slots:{default:[Wt]},$$scope:{ctx:A}}}),ie=new pt({props:{title:"PixArtAlphaPipeline",local:"diffusers.PixArtAlphaPipeline",headingTag:"h2"}}),oe=new ze({props:{name:"class diffusers.PixArtAlphaPipeline",anchor:"diffusers.PixArtAlphaPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKL"},{name:"transformer",val:": Transformer2DModel"},{name:"scheduler",val:": DPMSolverMultistepScheduler"}],parametersDescription:[{anchor:"diffusers.PixArtAlphaPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.PixArtAlphaPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. PixArt-Alpha uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.PixArtAlphaPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.PixArtAlphaPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel">Transformer2DModel</a>) &#x2014;
A text conditioned <code>Transformer2DModel</code> to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.PixArtAlphaPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L218"}}),se=new ze({props:{name:"__call__",anchor:"diffusers.PixArtAlphaPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"clean_caption",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"max_sequence_length",val:": int = 120"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtAlphaPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps are used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Alpha this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.PixArtAlphaPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 120) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L704",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),U=new Lt({props:{anchor:"diffusers.PixArtAlphaPipeline.__call__.example",$$slots:{default:[Rt]},$$scope:{ctx:A}}}),le=new ze({props:{name:"classify_height_width_bin",anchor:"diffusers.PixArtAlphaPipeline.classify_height_width_bin",parameters:[{name:"height",val:": int"},{name:"width",val:": int"},{name:"ratios",val:": dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L672"}}),re=new ze({props:{name:"encode_prompt",anchor:"diffusers.PixArtAlphaPipeline.encode_prompt",parameters:[{name:"prompt",val:": Union"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"prompt_attention_mask",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 120"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt
device &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"num_images_per_prompt"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Alpha, it&#x2019;s should be the embeddings of the &quot;&quot;
string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.PixArtAlphaPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 120) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pixart_alpha/pipeline_pixart_alpha.py#L287"}}),{c(){s=l("meta"),M=i(),p=l("p"),m=i(),h(T.$$.fragment),c=i(),y=l("p"),y.innerHTML=dt,we=i(),k=l("p"),k.innerHTML=ct,Me=i(),B=l("p"),B.textContent=mt,ve=i(),Z=l("p"),Z.innerHTML=ft,Te=i(),X=l("p"),X.innerHTML=ht,ye=i(),L=l("p"),L.textContent=ut,Ae=i(),E=l("ul"),E.innerHTML=gt,Pe=i(),h(J.$$.fragment),$e=i(),h(H.$$.fragment),Je=i(),W=l("p"),W.innerHTML=_t,je=i(),R=l("p"),R.innerHTML=bt,Ie=i(),h(V.$$.fragment),Ue=i(),Q=l("p"),Q.textContent=xt,Ce=i(),h(q.$$.fragment),Ge=i(),F=l("p"),F.innerHTML=wt,ke=i(),h(N.$$.fragment),Be=i(),S=l("p"),S.innerHTML=Mt,Ze=i(),h(Y.$$.fragment),Xe=i(),D=l("p"),D.textContent=vt,Le=i(),h(z.$$.fragment),Ee=i(),h(j.$$.fragment),He=i(),O=l("p"),O.textContent=Tt,We=i(),h(K.$$.fragment),Re=i(),ee=l("p"),ee.innerHTML=yt,Ve=i(),te=l("p"),te.innerHTML=At,Qe=i(),ne=l("p"),ne.innerHTML=Pt,qe=i(),h(I.$$.fragment),Fe=i(),ae=l("p"),ae.innerHTML=$t,Ne=i(),h(ie.$$.fragment),Se=i(),w=l("div"),h(oe.$$.fragment),Ke=i(),me=l("p"),me.textContent=Jt,et=i(),fe=l("p"),fe.innerHTML=jt,tt=i(),P=l("div"),h(se.$$.fragment),nt=i(),he=l("p"),he.textContent=It,at=i(),h(U.$$.fragment),it=i(),C=l("div"),h(le.$$.fragment),ot=i(),ue=l("p"),ue.textContent=Ut,st=i(),G=l("div"),h(re.$$.fragment),lt=i(),ge=l("p"),ge.textContent=Ct,Ye=i(),xe=l("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);s=r(t,"META",{name:!0,content:!0}),t.forEach(n),M=o(e),p=r(e,"P",{}),_e(p).forEach(n),m=o(e),u(T.$$.fragment,e),c=o(e),y=r(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-v8u40f"&&(y.innerHTML=dt),we=o(e),k=r(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-9ej743"&&(k.innerHTML=ct),Me=o(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1cwsb16"&&(B.textContent=mt),ve=o(e),Z=r(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1ddr7a0"&&(Z.innerHTML=ft),Te=o(e),X=r(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1c7kadv"&&(X.innerHTML=ht),ye=o(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-v1sn1g"&&(L.textContent=ut),Ae=o(e),E=r(e,"UL",{"data-svelte-h":!0}),d(E)!=="svelte-1o0jwg8"&&(E.innerHTML=gt),Pe=o(e),u(J.$$.fragment,e),$e=o(e),u(H.$$.fragment,e),Je=o(e),W=r(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-143a3hz"&&(W.innerHTML=_t),je=o(e),R=r(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-c2h3fb"&&(R.innerHTML=bt),Ie=o(e),u(V.$$.fragment,e),Ue=o(e),Q=r(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-5r7318"&&(Q.textContent=xt),Ce=o(e),u(q.$$.fragment,e),Ge=o(e),F=r(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-rj1jgt"&&(F.innerHTML=wt),ke=o(e),u(N.$$.fragment,e),Be=o(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-b16cf1"&&(S.innerHTML=Mt),Ze=o(e),u(Y.$$.fragment,e),Xe=o(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-w3d4de"&&(D.textContent=vt),Le=o(e),u(z.$$.fragment,e),Ee=o(e),u(j.$$.fragment,e),He=o(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1yf7wfg"&&(O.textContent=Tt),We=o(e),u(K.$$.fragment,e),Re=o(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-ev444i"&&(ee.innerHTML=yt),Ve=o(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1g55ccf"&&(te.innerHTML=At),Qe=o(e),ne=r(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-11lvu0m"&&(ne.innerHTML=Pt),qe=o(e),u(I.$$.fragment,e),Fe=o(e),ae=r(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1i82z60"&&(ae.innerHTML=$t),Ne=o(e),u(ie.$$.fragment,e),Se=o(e),w=r(e,"DIV",{class:!0});var v=_e(w);u(oe.$$.fragment,v),Ke=o(v),me=r(v,"P",{"data-svelte-h":!0}),d(me)!=="svelte-31ka93"&&(me.textContent=Jt),et=o(v),fe=r(v,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-wu1jmh"&&(fe.innerHTML=jt),tt=o(v),P=r(v,"DIV",{class:!0});var $=_e(P);u(se.$$.fragment,$),nt=o($),he=r($,"P",{"data-svelte-h":!0}),d(he)!=="svelte-v78lg8"&&(he.textContent=It),at=o($),u(U.$$.fragment,$),$.forEach(n),it=o(v),C=r(v,"DIV",{class:!0});var pe=_e(C);u(le.$$.fragment,pe),ot=o(pe),ue=r(pe,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-vknpvz"&&(ue.textContent=Ut),pe.forEach(n),st=o(v),G=r(v,"DIV",{class:!0});var de=_e(G);u(re.$$.fragment,de),lt=o(de),ge=r(de,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-16q0ax1"&&(ge.textContent=Ct),de.forEach(n),v.forEach(n),Ye=o(e),xe=r(e,"P",{}),_e(xe).forEach(n),this.h()},h(){be(s,"name","hf:doc:metadata"),be(s,"content",Qt),be(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),be(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),be(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),be(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){f(document.head,s),a(e,M,t),a(e,p,t),a(e,m,t),g(T,e,t),a(e,c,t),a(e,y,t),a(e,we,t),a(e,k,t),a(e,Me,t),a(e,B,t),a(e,ve,t),a(e,Z,t),a(e,Te,t),a(e,X,t),a(e,ye,t),a(e,L,t),a(e,Ae,t),a(e,E,t),a(e,Pe,t),g(J,e,t),a(e,$e,t),g(H,e,t),a(e,Je,t),a(e,W,t),a(e,je,t),a(e,R,t),a(e,Ie,t),g(V,e,t),a(e,Ue,t),a(e,Q,t),a(e,Ce,t),g(q,e,t),a(e,Ge,t),a(e,F,t),a(e,ke,t),g(N,e,t),a(e,Be,t),a(e,S,t),a(e,Ze,t),g(Y,e,t),a(e,Xe,t),a(e,D,t),a(e,Le,t),g(z,e,t),a(e,Ee,t),g(j,e,t),a(e,He,t),a(e,O,t),a(e,We,t),g(K,e,t),a(e,Re,t),a(e,ee,t),a(e,Ve,t),a(e,te,t),a(e,Qe,t),a(e,ne,t),a(e,qe,t),g(I,e,t),a(e,Fe,t),a(e,ae,t),a(e,Ne,t),g(ie,e,t),a(e,Se,t),a(e,w,t),g(oe,w,null),f(w,Ke),f(w,me),f(w,et),f(w,fe),f(w,tt),f(w,P),g(se,P,null),f(P,nt),f(P,he),f(P,at),g(U,P,null),f(w,it),f(w,C),g(le,C,null),f(C,ot),f(C,ue),f(w,st),f(w,G),g(re,G,null),f(G,lt),f(G,ge),a(e,Ye,t),a(e,xe,t),De=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),J.$set(v);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),j.$set($);const pe={};t&2&&(pe.$$scope={dirty:t,ctx:e}),I.$set(pe);const de={};t&2&&(de.$$scope={dirty:t,ctx:e}),U.$set(de)},i(e){De||(_(T.$$.fragment,e),_(J.$$.fragment,e),_(H.$$.fragment,e),_(V.$$.fragment,e),_(q.$$.fragment,e),_(N.$$.fragment,e),_(Y.$$.fragment,e),_(z.$$.fragment,e),_(j.$$.fragment,e),_(K.$$.fragment,e),_(I.$$.fragment,e),_(ie.$$.fragment,e),_(oe.$$.fragment,e),_(se.$$.fragment,e),_(U.$$.fragment,e),_(le.$$.fragment,e),_(re.$$.fragment,e),De=!0)},o(e){b(T.$$.fragment,e),b(J.$$.fragment,e),b(H.$$.fragment,e),b(V.$$.fragment,e),b(q.$$.fragment,e),b(N.$$.fragment,e),b(Y.$$.fragment,e),b(z.$$.fragment,e),b(j.$$.fragment,e),b(K.$$.fragment,e),b(I.$$.fragment,e),b(ie.$$.fragment,e),b(oe.$$.fragment,e),b(se.$$.fragment,e),b(U.$$.fragment,e),b(le.$$.fragment,e),b(re.$$.fragment,e),De=!1},d(e){e&&(n(M),n(p),n(m),n(c),n(y),n(we),n(k),n(Me),n(B),n(ve),n(Z),n(Te),n(X),n(ye),n(L),n(Ae),n(E),n(Pe),n($e),n(Je),n(W),n(je),n(R),n(Ie),n(Ue),n(Q),n(Ce),n(Ge),n(F),n(ke),n(Be),n(S),n(Ze),n(Xe),n(D),n(Le),n(Ee),n(He),n(O),n(We),n(Re),n(ee),n(Ve),n(te),n(Qe),n(ne),n(qe),n(Fe),n(ae),n(Ne),n(Se),n(w),n(Ye),n(xe)),n(s),x(T,e),x(J,e),x(H,e),x(V,e),x(q,e),x(N,e),x(Y,e),x(z,e),x(j,e),x(K,e),x(I,e),x(ie,e),x(oe),x(se),x(U),x(le),x(re)}}}const Qt='{"title":"PixArt-α","local":"pixart-α","sections":[{"title":"Inference with under 8GB GPU VRAM","local":"inference-with-under-8gb-gpu-vram","sections":[],"depth":2},{"title":"PixArtAlphaPipeline","local":"diffusers.PixArtAlphaPipeline","sections":[],"depth":2}],"depth":1}';function qt(A){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Bt{constructor(s){super(),Zt(this,s,qt,Vt,Gt,{})}}export{Kt as component};
