import{s as kt,o as Ct,n as nt}from"../chunks/scheduler.182ea377.js";import{S as Bt,i as It,g as r,s as a,r as c,A as Rt,h as p,f as l,c as i,j as vt,u,x as o,k as Xt,y as Gt,a as n,v as f,d,t as h,w as M}from"../chunks/index.abf12888.js";import{T as lt}from"../chunks/Tip.230e2334.js";import{C as g}from"../chunks/CodeBlock.57fe6e13.js";import{H as ce}from"../chunks/Heading.16916d63.js";function Vt(b){let s,y='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){s=r("p"),s.innerHTML=y},l(m){s=p(m,"P",{"data-svelte-h":!0}),o(s)!=="svelte-1qbiqsn"&&(s.innerHTML=y)},m(m,w){n(m,s,w)},p:nt,d(m){m&&l(s)}}}function Ft(b){let s,y='The following sections highlight parts of the training scripts that are important for understanding how to modify it, but it doesn’t cover every aspect of the <a href="https://github.com/huggingface/diffusers/blob/main/examples/wuerstchen/text_to_image/train_text_to_image_prior.py" rel="nofollow">script</a> in detail. If you’re interested in learning more, feel free to read through the scripts and let us know if you have any questions or concerns.';return{c(){s=r("p"),s.innerHTML=y},l(m){s=p(m,"P",{"data-svelte-h":!0}),o(s)!=="svelte-1fbavkc"&&(s.innerHTML=y)},m(m,w){n(m,s,w)},p:nt,d(m){m&&l(s)}}}function Et(b){let s,y="To monitor training progress with Weights &amp; Biases, add the <code>--report_to=wandb</code> parameter to the training command. You’ll also need to add the <code>--validation_prompt</code> to the training command to keep track of results. This can be really useful for debugging the model and viewing intermediate results.";return{c(){s=r("p"),s.innerHTML=y},l(m){s=p(m,"P",{"data-svelte-h":!0}),o(s)!=="svelte-1sfnrue"&&(s.innerHTML=y)},m(m,w){n(m,s,w)},p:nt,d(m){m&&l(s)}}}function At(b){let s,y,m,w,$,ue,j,at='The <a href="https://hf.co/papers/2306.00637" rel="nofollow">Wuerstchen</a> model drastically reduces computational costs by compressing the latent space by 42x, without compromising image quality and accelerating inference. During training, Wuerstchen uses two models (VQGAN + autoencoder) to compress the latents, and then a third model (text-conditioned latent diffusion model) is conditioned on this highly compressed space to generate an image.',fe,U,it="To fit the prior model into GPU memory and to speedup training, try enabling <code>gradient_accumulation_steps</code>, <code>gradient_checkpointing</code>, and <code>mixed_precision</code> respectively.",de,x,st='This guide explores the <a href="https://github.com/huggingface/diffusers/blob/main/examples/wuerstchen/text_to_image/train_text_to_image_prior.py" rel="nofollow">train_text_to_image_prior.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',he,Z,rt="Before running the script, make sure you install the library from source:",Me,W,ye,v,pt="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",ge,X,we,_,be,k,ot="Initialize an 🤗 Accelerate environment:",_e,C,Te,B,mt="To setup a default 🤗 Accelerate environment without choosing any configurations:",Je,I,$e,R,ct="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",je,G,Ue,V,ut='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',xe,T,Ze,F,We,E,ft='The training scripts provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L192" rel="nofollow"><code>parse_args()</code></a> function. It provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',ve,A,dt="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",Xe,H,ke,N,ht='Most of the parameters are identical to the parameters in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so let’s dive right into the Wuerstchen training script!',Ce,Y,Be,Q,Mt='The training script is also similar to the <a href="text2image#training-script">Text-to-image</a> training guide, but it’s been modified to support Wuerstchen. This guide focuses on the code that is unique to the Wuerstchen training script.',Ie,L,yt='The <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L441" rel="nofollow"><code>main()</code></a> function starts by initializing the image encoder - an <a href="https://github.com/huggingface/diffusers/blob/main/examples/wuerstchen/text_to_image/modeling_efficient_net_encoder.py" rel="nofollow">EfficientNet</a> - in addition to the usual scheduler and tokenizer.',Re,S,Ge,z,gt="You’ll also load the <code>WuerstchenPrior</code> model for optimization.",Ve,q,Fe,P,wt='Next, you’ll apply some <a href="https://github.com/huggingface/diffusers/blob/65ef7a0c5c594b4f84092e328fbdd73183613b30/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L656" rel="nofollow">transforms</a> to the images and <a href="https://github.com/huggingface/diffusers/blob/65ef7a0c5c594b4f84092e328fbdd73183613b30/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L637" rel="nofollow">tokenize</a> the captions:',Ee,D,Ae,K,bt='Finally, the <a href="https://github.com/huggingface/diffusers/blob/65ef7a0c5c594b4f84092e328fbdd73183613b30/examples/wuerstchen/text_to_image/train_text_to_image_prior.py#L656" rel="nofollow">training loop</a> handles compressing the images to latent space with the <code>EfficientNetEncoder</code>, adding noise to the latents, and predicting the noise residual with the <code>WuerstchenPrior</code> model.',He,O,Ne,ee,_t='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',Ye,te,Qe,le,Tt="Once you’ve made all your changes or you’re okay with the default configuration, you’re ready to launch the training script! 🚀",Le,ne,Jt='Set the <code>DATASET_NAME</code> environment variable to the dataset name from the Hub. This guide uses the <a href="https://huggingface.co/datasets/lambdalabs/pokemon-blip-captions" rel="nofollow">Pokémon BLIP captions</a> dataset, but you can create and train on your own datasets as well (see the <a href="create_dataset">Create a dataset for training</a> guide).',Se,J,ze,ae,qe,ie,$t="Once training is complete, you can use your newly trained model for inference!",Pe,se,De,re,Ke,pe,jt="Congratulations on training a Wuerstchen model! To learn more about how to use your new model, the following may be helpful:",Oe,oe,Ut='<li>Take a look at the <a href="../api/pipelines/wuerstchen#text-to-image-generation">Wuerstchen</a> API documentation to learn more about how to use the pipeline for text-to-image generation and its limitations.</li>',et,me,tt;return $=new ce({props:{title:"Wuerstchen",local:"wuerstchen",headingTag:"h1"}}),W=new g({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),X=new g({props:{code:"Y2QlMjBleGFtcGxlcyUyRnd1ZXJzdGNoZW4lMkZ0ZXh0X3RvX2ltYWdlJTBBcGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`<span class="hljs-built_in">cd</span> examples/wuerstchen/text_to_image
pip install -r requirements.txt`,wrap:!1}}),_=new lt({props:{$$slots:{default:[Vt]},$$scope:{ctx:b}}}),C=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),I=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),G=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),T=new lt({props:{$$slots:{default:[Ft]},$$scope:{ctx:b}}}),F=new ce({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),H=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX3RleHRfdG9faW1hZ2VfcHJpb3IucHklMjAlNUMlMEElMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjI=",highlighted:`accelerate launch train_text_to_image_prior.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`,wrap:!1}}),Y=new ce({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),S=new g({props:{code:"d2l0aCUyMENvbnRleHRNYW5hZ2VycyhkZWVwc3BlZWRfemVyb19pbml0X2Rpc2FibGVkX2NvbnRleHRfbWFuYWdlcigpKSUzQSUwQSUyMCUyMCUyMCUyMHByZXRyYWluZWRfY2hlY2twb2ludF9maWxlJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUyMmRvbWUyNzIlMkZ3dWVyc3RjaGVuJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJtb2RlbF92Ml9zdGFnZV9iLnB0JTIyKSUwQSUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlMjAlM0QlMjB0b3JjaC5sb2FkKHByZXRyYWluZWRfY2hlY2twb2ludF9maWxlJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3B1JTIyKSUwQSUyMCUyMCUyMCUyMGltYWdlX2VuY29kZXIlMjAlM0QlMjBFZmZpY2llbnROZXRFbmNvZGVyKCklMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTVCJTIyZWZmbmV0X3N0YXRlX2RpY3QlMjIlNUQpJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW5jb2Rlci5ldmFsKCk=",highlighted:`<span class="hljs-keyword">with</span> ContextManagers(deepspeed_zero_init_disabled_context_manager()):
    pretrained_checkpoint_file = hf_hub_download(<span class="hljs-string">&quot;dome272/wuerstchen&quot;</span>, filename=<span class="hljs-string">&quot;model_v2_stage_b.pt&quot;</span>)
    state_dict = torch.load(pretrained_checkpoint_file, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
    image_encoder = EfficientNetEncoder()
    image_encoder.load_state_dict(state_dict[<span class="hljs-string">&quot;effnet_state_dict&quot;</span>])
    image_encoder.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),q=new g({props:{code:"cHJpb3IlMjAlM0QlMjBXdWVyc3RjaGVuUHJpb3IuZnJvbV9wcmV0cmFpbmVkKGFyZ3MucHJldHJhaW5lZF9wcmlvcl9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJwcmlvciUyMiklMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBvcHRpbWl6ZXJfY2xzKCUwQSUyMCUyMCUyMCUyMHByaW9yLnBhcmFtZXRlcnMoKSUyQyUwQSUyMCUyMCUyMCUyMGxyJTNEYXJncy5sZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwYmV0YXMlM0QoYXJncy5hZGFtX2JldGExJTJDJTIwYXJncy5hZGFtX2JldGEyKSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRGFyZ3MuYWRhbV93ZWlnaHRfZGVjYXklMkMlMEElMjAlMjAlMjAlMjBlcHMlM0RhcmdzLmFkYW1fZXBzaWxvbiUyQyUwQSk=",highlighted:`prior = WuerstchenPrior.from_pretrained(args.pretrained_prior_model_name_or_path, subfolder=<span class="hljs-string">&quot;prior&quot;</span>)

optimizer = optimizer_cls(
    prior.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),D=new g({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMiklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUJpbWFnZV9jb2x1bW4lNUQlNUQlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMmVmZm5ldF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjAlNUJlZmZuZXRfdHJhbnNmb3JtcyhpbWFnZSklMjBmb3IlMjBpbWFnZSUyMGluJTIwaW1hZ2VzJTVEJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJ0ZXh0X2lucHV0X2lkcyUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIydGV4dF9tYXNrJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVfY2FwdGlvbnMoZXhhbXBsZXMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">examples</span>):
    images = [image.convert(<span class="hljs-string">&quot;RGB&quot;</span>) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[image_column]]
    examples[<span class="hljs-string">&quot;effnet_pixel_values&quot;</span>] = [effnet_transforms(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
    examples[<span class="hljs-string">&quot;text_input_ids&quot;</span>], examples[<span class="hljs-string">&quot;text_mask&quot;</span>] = tokenize_captions(examples)
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),O=new g({props:{code:"cHJlZF9ub2lzZSUyMCUzRCUyMHByaW9yKG5vaXN5X2xhdGVudHMlMkMlMjB0aW1lc3RlcHMlMkMlMjBwcm9tcHRfZW1iZWRzKQ==",highlighted:"pred_noise = prior(noisy_latents, timesteps, prompt_embeds)",wrap:!1}}),te=new ce({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),J=new lt({props:{$$slots:{default:[Et]},$$scope:{ctx:b}}}),ae=new g({props:{code:"ZXhwb3J0JTIwREFUQVNFVF9OQU1FJTNEJTIybGFtYmRhbGFicyUyRnBva2Vtb24tYmxpcC1jYXB0aW9ucyUyMiUwQSUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjAlMjB0cmFpbl90ZXh0X3RvX2ltYWdlX3ByaW9yLnB5JTIwJTVDJTBBJTIwJTIwLS1taXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyJTIwJTVDJTBBJTIwJTIwLS1kYXRhc2V0X25hbWUlM0QlMjREQVRBU0VUX05BTUUlMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q3NjglMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0Q0JTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIwJTVDJTBBJTIwJTIwLS1kYXRhbG9hZGVyX251bV93b3JrZXJzJTNENCUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMTUwMDAlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0QxZS0wNSUyMCU1QyUwQSUyMCUyMC0tbWF4X2dyYWRfbm9ybSUzRDElMjAlNUMlMEElMjAlMjAtLWNoZWNrcG9pbnRzX3RvdGFsX2xpbWl0JTNEMyUyMCU1QyUwQSUyMCUyMC0tbHJfc2NoZWR1bGVyJTNEJTIyY29uc3RhbnQlMjIlMjAlNUMlMEElMjAlMjAtLWxyX3dhcm11cF9zdGVwcyUzRDAlMjAlNUMlMEElMjAlMjAtLXZhbGlkYXRpb25fcHJvbXB0cyUzRCUyMkElMjByb2JvdCUyMHBva2Vtb24lMkMlMjA0ayUyMHBob3RvJTIyJTIwJTVDJTBBJTIwJTIwLS1yZXBvcnRfdG8lM0QlMjJ3YW5kYiUyMiUyMCU1QyUwQSUyMCUyMC0tcHVzaF90b19odWIlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlM0QlMjJ3dWVyc3RjaGVuLXByaW9yLXBva2Vtb24tbW9kZWwlMjI=",highlighted:`<span class="hljs-built_in">export</span> DATASET_NAME=<span class="hljs-string">&quot;lambdalabs/pokemon-blip-captions&quot;</span>

accelerate launch  train_text_to_image_prior.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> \\
  --dataset_name=<span class="hljs-variable">$DATASET_NAME</span> \\
  --resolution=768 \\
  --train_batch_size=4 \\
  --gradient_accumulation_steps=4 \\
  --gradient_checkpointing \\
  --dataloader_num_workers=4 \\
  --max_train_steps=15000 \\
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --checkpoints_total_limit=3 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --validation_prompts=<span class="hljs-string">&quot;A robot pokemon, 4k photo&quot;</span> \\
  --report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
  --push_to_hub \\
  --output_dir=<span class="hljs-string">&quot;wuerstchen-prior-pokemon-model&quot;</span>`,wrap:!1}}),se=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMucGlwZWxpbmVzLnd1ZXJzdGNoZW4lMjBpbXBvcnQlMjBERUZBVUxUX1NUQUdFX0NfVElNRVNURVBTJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZzYXZlZCUyRm1vZGVsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQWNhcHRpb24lMjAlM0QlMjAlMjJBJTIwY3V0ZSUyMGJpcmQlMjBwb2tlbW9uJTIwaG9sZGluZyUyMGElMjBzaGllbGQlMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBjYXB0aW9uJTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTUzNiUyQyUwQSUyMCUyMCUyMCUyMHByaW9yX3RpbWVzdGVwcyUzRERFRkFVTFRfU1RBR0VfQ19USU1FU1RFUFMlMkMlMEElMjAlMjAlMjAlMjBwcmlvcl9ndWlkYW5jZV9zY2FsZSUzRDQuMCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRDIlMkMlMEEpLmltYWdlcw==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.pipelines.wuerstchen <span class="hljs-keyword">import</span> DEFAULT_STAGE_C_TIMESTEPS

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;path/to/saved/model&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

caption = <span class="hljs-string">&quot;A cute bird pokemon holding a shield&quot;</span>
images = pipeline(
    caption,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1536</span>,
    prior_timesteps=DEFAULT_STAGE_C_TIMESTEPS,
    prior_guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=<span class="hljs-number">2</span>,
).images`,wrap:!1}}),re=new ce({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){s=r("meta"),y=a(),m=r("p"),w=a(),c($.$$.fragment),ue=a(),j=r("p"),j.innerHTML=at,fe=a(),U=r("p"),U.innerHTML=it,de=a(),x=r("p"),x.innerHTML=st,he=a(),Z=r("p"),Z.textContent=rt,Me=a(),c(W.$$.fragment),ye=a(),v=r("p"),v.textContent=pt,ge=a(),c(X.$$.fragment),we=a(),c(_.$$.fragment),be=a(),k=r("p"),k.textContent=ot,_e=a(),c(C.$$.fragment),Te=a(),B=r("p"),B.textContent=mt,Je=a(),c(I.$$.fragment),$e=a(),R=r("p"),R.textContent=ct,je=a(),c(G.$$.fragment),Ue=a(),V=r("p"),V.innerHTML=ut,xe=a(),c(T.$$.fragment),Ze=a(),c(F.$$.fragment),We=a(),E=r("p"),E.innerHTML=ft,ve=a(),A=r("p"),A.innerHTML=dt,Xe=a(),c(H.$$.fragment),ke=a(),N=r("p"),N.innerHTML=ht,Ce=a(),c(Y.$$.fragment),Be=a(),Q=r("p"),Q.innerHTML=Mt,Ie=a(),L=r("p"),L.innerHTML=yt,Re=a(),c(S.$$.fragment),Ge=a(),z=r("p"),z.innerHTML=gt,Ve=a(),c(q.$$.fragment),Fe=a(),P=r("p"),P.innerHTML=wt,Ee=a(),c(D.$$.fragment),Ae=a(),K=r("p"),K.innerHTML=bt,He=a(),c(O.$$.fragment),Ne=a(),ee=r("p"),ee.innerHTML=_t,Ye=a(),c(te.$$.fragment),Qe=a(),le=r("p"),le.textContent=Tt,Le=a(),ne=r("p"),ne.innerHTML=Jt,Se=a(),c(J.$$.fragment),ze=a(),c(ae.$$.fragment),qe=a(),ie=r("p"),ie.textContent=$t,Pe=a(),c(se.$$.fragment),De=a(),c(re.$$.fragment),Ke=a(),pe=r("p"),pe.textContent=jt,Oe=a(),oe=r("ul"),oe.innerHTML=Ut,et=a(),me=r("p"),this.h()},l(e){const t=Rt("svelte-u9bgzb",document.head);s=p(t,"META",{name:!0,content:!0}),t.forEach(l),y=i(e),m=p(e,"P",{}),vt(m).forEach(l),w=i(e),u($.$$.fragment,e),ue=i(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-i7ckto"&&(j.innerHTML=at),fe=i(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1ogrf3c"&&(U.innerHTML=it),de=i(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-19e0b6t"&&(x.innerHTML=st),he=i(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-l7dm2q"&&(Z.textContent=rt),Me=i(e),u(W.$$.fragment,e),ye=i(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-z4z0b9"&&(v.textContent=pt),ge=i(e),u(X.$$.fragment,e),we=i(e),u(_.$$.fragment,e),be=i(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-60q53m"&&(k.textContent=ot),_e=i(e),u(C.$$.fragment,e),Te=i(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-di6juu"&&(B.textContent=mt),Je=i(e),u(I.$$.fragment,e),$e=i(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-tsz4qp"&&(R.textContent=ct),je=i(e),u(G.$$.fragment,e),Ue=i(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1fkfdql"&&(V.innerHTML=ut),xe=i(e),u(T.$$.fragment,e),Ze=i(e),u(F.$$.fragment,e),We=i(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-5hssf5"&&(E.innerHTML=ft),ve=i(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1r0bv1x"&&(A.innerHTML=dt),Xe=i(e),u(H.$$.fragment,e),ke=i(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-94nkgl"&&(N.innerHTML=ht),Ce=i(e),u(Y.$$.fragment,e),Be=i(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1qezx8a"&&(Q.innerHTML=Mt),Ie=i(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1dwkzrk"&&(L.innerHTML=yt),Re=i(e),u(S.$$.fragment,e),Ge=i(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1q4frxg"&&(z.innerHTML=gt),Ve=i(e),u(q.$$.fragment,e),Fe=i(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-hccx6h"&&(P.innerHTML=wt),Ee=i(e),u(D.$$.fragment,e),Ae=i(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1mgnmwn"&&(K.innerHTML=bt),He=i(e),u(O.$$.fragment,e),Ne=i(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-6gmbd2"&&(ee.innerHTML=_t),Ye=i(e),u(te.$$.fragment,e),Qe=i(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-9dei1q"&&(le.textContent=Tt),Le=i(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-6q7ycx"&&(ne.innerHTML=Jt),Se=i(e),u(J.$$.fragment,e),ze=i(e),u(ae.$$.fragment,e),qe=i(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1x6in5t"&&(ie.textContent=$t),Pe=i(e),u(se.$$.fragment,e),De=i(e),u(re.$$.fragment,e),Ke=i(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1o0am8e"&&(pe.textContent=jt),Oe=i(e),oe=p(e,"UL",{"data-svelte-h":!0}),o(oe)!=="svelte-m7qkni"&&(oe.innerHTML=Ut),et=i(e),me=p(e,"P",{}),vt(me).forEach(l),this.h()},h(){Xt(s,"name","hf:doc:metadata"),Xt(s,"content",Ht)},m(e,t){Gt(document.head,s),n(e,y,t),n(e,m,t),n(e,w,t),f($,e,t),n(e,ue,t),n(e,j,t),n(e,fe,t),n(e,U,t),n(e,de,t),n(e,x,t),n(e,he,t),n(e,Z,t),n(e,Me,t),f(W,e,t),n(e,ye,t),n(e,v,t),n(e,ge,t),f(X,e,t),n(e,we,t),f(_,e,t),n(e,be,t),n(e,k,t),n(e,_e,t),f(C,e,t),n(e,Te,t),n(e,B,t),n(e,Je,t),f(I,e,t),n(e,$e,t),n(e,R,t),n(e,je,t),f(G,e,t),n(e,Ue,t),n(e,V,t),n(e,xe,t),f(T,e,t),n(e,Ze,t),f(F,e,t),n(e,We,t),n(e,E,t),n(e,ve,t),n(e,A,t),n(e,Xe,t),f(H,e,t),n(e,ke,t),n(e,N,t),n(e,Ce,t),f(Y,e,t),n(e,Be,t),n(e,Q,t),n(e,Ie,t),n(e,L,t),n(e,Re,t),f(S,e,t),n(e,Ge,t),n(e,z,t),n(e,Ve,t),f(q,e,t),n(e,Fe,t),n(e,P,t),n(e,Ee,t),f(D,e,t),n(e,Ae,t),n(e,K,t),n(e,He,t),f(O,e,t),n(e,Ne,t),n(e,ee,t),n(e,Ye,t),f(te,e,t),n(e,Qe,t),n(e,le,t),n(e,Le,t),n(e,ne,t),n(e,Se,t),f(J,e,t),n(e,ze,t),f(ae,e,t),n(e,qe,t),n(e,ie,t),n(e,Pe,t),f(se,e,t),n(e,De,t),f(re,e,t),n(e,Ke,t),n(e,pe,t),n(e,Oe,t),n(e,oe,t),n(e,et,t),n(e,me,t),tt=!0},p(e,[t]){const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),_.$set(xt);const Zt={};t&2&&(Zt.$$scope={dirty:t,ctx:e}),T.$set(Zt);const Wt={};t&2&&(Wt.$$scope={dirty:t,ctx:e}),J.$set(Wt)},i(e){tt||(d($.$$.fragment,e),d(W.$$.fragment,e),d(X.$$.fragment,e),d(_.$$.fragment,e),d(C.$$.fragment,e),d(I.$$.fragment,e),d(G.$$.fragment,e),d(T.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(J.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),tt=!0)},o(e){h($.$$.fragment,e),h(W.$$.fragment,e),h(X.$$.fragment,e),h(_.$$.fragment,e),h(C.$$.fragment,e),h(I.$$.fragment,e),h(G.$$.fragment,e),h(T.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(Y.$$.fragment,e),h(S.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(J.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),tt=!1},d(e){e&&(l(y),l(m),l(w),l(ue),l(j),l(fe),l(U),l(de),l(x),l(he),l(Z),l(Me),l(ye),l(v),l(ge),l(we),l(be),l(k),l(_e),l(Te),l(B),l(Je),l($e),l(R),l(je),l(Ue),l(V),l(xe),l(Ze),l(We),l(E),l(ve),l(A),l(Xe),l(ke),l(N),l(Ce),l(Be),l(Q),l(Ie),l(L),l(Re),l(Ge),l(z),l(Ve),l(Fe),l(P),l(Ee),l(Ae),l(K),l(He),l(Ne),l(ee),l(Ye),l(Qe),l(le),l(Le),l(ne),l(Se),l(ze),l(qe),l(ie),l(Pe),l(De),l(Ke),l(pe),l(Oe),l(oe),l(et),l(me)),l(s),M($,e),M(W,e),M(X,e),M(_,e),M(C,e),M(I,e),M(G,e),M(T,e),M(F,e),M(H,e),M(Y,e),M(S,e),M(q,e),M(D,e),M(O,e),M(te,e),M(J,e),M(ae,e),M(se,e),M(re,e)}}}const Ht='{"title":"Wuerstchen","local":"wuerstchen","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Nt(b){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends Bt{constructor(s){super(),It(this,s,Nt,At,kt,{})}}export{qt as component};
