import{s as la,o as na,n as aa}from"../chunks/scheduler.9bc65507.js";import{S as ia,i as pa,g as i,s as l,r as o,A as ra,h as p,f as t,c as n,j as ta,u as c,x as r,k as ct,y as oa,a,v as m,d as h,t as u,w as f,m as ca,n as ma}from"../chunks/index.707bf1b6.js";import{H as J,g as ha}from"../chunks/Heading.98cce615.js";import{T as mt}from"../chunks/Tip.c2ecdbf4.js";import{C as M}from"../chunks/CodeBlock.54a9f38d.js";function ua($){let d,w='Take a look at the <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> documentation for a complete list of supported tasks and available parameters.';return{c(){d=i("p"),d.innerHTML=w},l(g){d=p(g,"P",{"data-svelte-h":!0}),r(d)!=="svelte-c2rgnm"&&(d.innerHTML=w)},m(g,T){a(g,d,T)},p:aa,d(g){g&&t(d)}}}function fa($){let d;return{c(){d=ca(`Creating an inference engine is a complex topic which deserves it's own
page.`)},l(w){d=ma(w,`Creating an inference engine is a complex topic which deserves it's own
page.`)},m(w,g){a(w,d,g)},d(w){w&&t(d)}}}function da($){let d,w='To run the example above you need to have <a href="https://pypi.org/project/pytesseract/" rel="nofollow"><code>pytesseract</code></a> installed in addition to 🤗 Transformers:',g,T,j;return T=new M({props:{code:"c3VkbyUyMGFwdCUyMGluc3RhbGwlMjAteSUyMHRlc3NlcmFjdC1vY3IlMEFwaXAlMjBpbnN0YWxsJTIwcHl0ZXNzZXJhY3Q=",highlighted:`sudo apt install -y tesseract-ocr
pip install pytesseract`,wrap:!1}}),{c(){d=i("p"),d.innerHTML=w,g=l(),o(T.$$.fragment)},l(y){d=p(y,"P",{"data-svelte-h":!0}),r(d)!=="svelte-z3k1tk"&&(d.innerHTML=w),g=n(y),c(T.$$.fragment,y)},m(y,b){a(y,d,b),a(y,g,b),m(T,y,b),j=!0},p:aa,i(y){j||(h(T.$$.fragment,y),j=!0)},o(y){u(T.$$.fragment,y),j=!1},d(y){y&&(t(d),t(g)),f(T,y)}}}function ya($){let d,w,g,T,j,y,b,ht='The <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> makes it simple to use any model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a> for inference on any language, computer vision, speech, and multimodal tasks. Even if you don’t have experience with a specific modality or aren’t familiar with the underlying code behind the models, you can still use them for inference with the <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>! This tutorial will teach you to:',Fe,x,ut='<li>Use a <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for inference.</li> <li>Use a specific tokenizer or model.</li> <li>Use a <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for audio, vision, and multimodal tasks.</li>',Se,U,Le,k,Qe,G,ft=`While each task has an associated <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, it is simpler to use the general <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> abstraction which contains
all the task-specific pipelines. The <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> automatically loads a default model and a preprocessing class capable
of inference for your task. Let’s take the example of using the <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for automatic speech recognition (ASR), or
speech-to-text.`,Ee,B,dt='<li>Start by creating a <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> and specify the inference task:</li>',Pe,W,Ae,v,yt='<li>Pass your input to the <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>. In the case of speech recognition, this is an audio input file:</li>',De,X,Ke,C,Mt=`Not the result you had in mind? Check out some of the <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;sort=trending" rel="nofollow">most downloaded automatic speech recognition models</a>
on the Hub to see if you can get a better transcription.`,Oe,R,gt=`Let’s try the <a href="https://huggingface.co/openai/whisper-large" rel="nofollow">Whisper large-v2</a> model from OpenAI. Whisper was released
2 years later than Wav2Vec2, and was trained on close to 10x more data. As such, it beats Wav2Vec2 on most downstream
benchmarks. It also has the added benefit of predicting punctuation and casing, neither of which are possible with<br/>
Wav2Vec2.`,es,_,wt="Let’s give it a try here to see how it performs:",ss,H,ts,V,Tt=`Now this result looks more accurate! For a deep-dive comparison on Wav2Vec2 vs Whisper, refer to the <a href="https://huggingface.co/learn/audio-course/chapter5/asr_models" rel="nofollow">Audio Transformers Course</a>.
We really encourage you to check out the Hub for models in different languages, models specialized in your field, and more.
You can check out and compare model results directly from your browser on the Hub to see if it fits or
handles corner cases better than other ones.
And if you don’t find a model for your use case, you can always start <a href="training">training</a> your own!`,as,Y,jt="If you have several inputs, you can pass your input as a list:",ls,N,ns,q,Jt=`Pipelines are great for experimentation as switching from one model to another is trivial; however, there are some ways to optimize them for larger workloads than experimentation. See the following guides that dive into iterating over whole datasets or using pipelines in a webserver:
of the docs:`,is,z,bt='<li><a href="#using-pipelines-on-a-dataset">Using pipelines on a dataset</a></li> <li><a href="./pipeline_webserver">Using pipelines for a webserver</a></li>',ps,F,rs,S,$t=`<a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports many parameters; some are task specific, and some are general to all pipelines.
In general, you can specify parameters anywhere you want:`,os,L,cs,Q,Ut="Let’s check out 3 important ones:",ms,E,hs,P,vt=`If you use <code>device=n</code>, the pipeline automatically puts the model on the specified device.
This will work regardless of whether you are using PyTorch or Tensorflow.`,us,A,fs,D,Zt=`If the model is too large for a single GPU and you are using PyTorch, you can set <code>device_map=&quot;auto&quot;</code> to automatically
determine how to load and store the model weights. Using the <code>device_map</code> argument requires the 🤗 <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Accelerate</a>
package:`,ds,K,ys,O,It="The following code automatically loads and stores model weights across devices:",Ms,ee,gs,se,xt="Note that if  <code>device_map=&quot;auto&quot;</code> is passed, there is no need to add the argument <code>device=device</code> when instantiating your <code>pipeline</code> as you may encounter some unexpected behavior!",ws,te,Ts,ae,kt='By default, pipelines will not batch inference for reasons explained in detail <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#pipeline-batching" rel="nofollow">here</a>. The reason is that batching is not necessarily faster, and can actually be quite slower in some cases.',js,le,Gt="But if it works in your use case, you can use:",Js,ne,bs,ie,Bt=`This runs the pipeline on the 4 provided audio files, but it will pass them in batches of 2
to the model (which is on a GPU, where batching is more likely to help) without requiring any further code from you.
The output should always match what you would have received without batching. It is only meant as a way to help you get more speed out of a pipeline.`,$s,pe,Wt='Pipelines can also alleviate some of the complexities of batching because, for some pipelines, a single item (like a long audio file) needs to be chunked into multiple parts to be processed by a model. The pipeline performs this <a href="./main_classes/pipelines#pipeline-chunk-batching"><em>chunk batching</em></a> for you.',Us,re,vs,oe,Xt=`All tasks provide task specific parameters which allow for additional flexibility and options to help you get your job done.
For instance, the <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline.__call__">transformers.AutomaticSpeechRecognitionPipeline.<strong>call</strong>()</a> method has a <code>return_timestamps</code> parameter which sounds promising for subtitling videos:`,Zs,ce,Is,me,Ct="As you can see, the model inferred the text and also outputted <strong>when</strong> the various sentences were pronounced.",xs,he,Rt=`There are many parameters available for each task, so check out each task’s API reference to see what you can tinker with!
For instance, the <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline">AutomaticSpeechRecognitionPipeline</a> has a <code>chunk_length_s</code> parameter which is helpful
for working on really long audio files (for example, subtitling entire movies or hour-long videos) that a model typically
cannot handle on its own:`,ks,ue,Gs,fe,_t='If you can’t find a parameter that would really help you out, feel free to <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=feature&amp;template=feature-request.yml" rel="nofollow">request it</a>!',Bs,de,Ws,ye,Ht="The pipeline can also run inference on a large dataset. The easiest way we recommend doing this is by using an iterator:",Xs,Me,Cs,ge,Vt=`The iterator <code>data()</code> yields each result, and the pipeline automatically
recognizes the input is iterable and will start fetching the data while
it continues to process it on the GPU (this uses <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> under the hood).
This is important because you don’t have to allocate memory for the whole dataset
and you can feed the GPU as fast as possible.`,Rs,we,Yt="Since batching could speed things up, it may be useful to try tuning the <code>batch_size</code> parameter here.",_s,Te,Nt='The simplest way to iterate over a dataset is to just load one from 🤗 <a href="https://github.com/huggingface/datasets/" rel="nofollow">Datasets</a>:',Hs,je,Vs,Je,Ys,Z,Ns,be,qt='<a href="./pipeline_webserver">Link</a>',qs,$e,zs,Ue,zt='Using a <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for vision tasks is practically identical.',Fs,ve,Ft="Specify your task and pass your image to the classifier. The image can be a link, a local path or a base64-encoded image. For example, what species of cat is shown below?",Ss,Ze,St='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Ls,Ie,Qs,xe,Es,ke,Lt='Using a <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for NLP tasks is practically identical.',Ps,Ge,As,Be,Ds,We,Qt='The <a href="/docs/transformers/v4.35.1/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports more than one modality. For example, a visual question answering (VQA) task combines text and image. Feel free to use any image link you like and a question you want to ask about the image. The image can be a URL or a local path to the image.',Ks,Xe,Et='For example, if you use this <a href="https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png" rel="nofollow">invoice image</a>:',Os,Ce,et,I,st,Re,tt,_e,Pt="You can easily run <code>pipeline</code> on large models using 🤗 <code>accelerate</code>! First make sure you have installed <code>accelerate</code> with <code>pip install accelerate</code>.",at,He,At="First load your model using <code>device_map=&quot;auto&quot;</code>! We will use <code>facebook/opt-1.3b</code> for our example.",lt,Ve,nt,Ye,Dt="You can also pass 8-bit loaded models if you install <code>bitsandbytes</code> and add the argument <code>load_in_8bit=True</code>",it,Ne,pt,qe,Kt="Note that you can replace the checkpoint with any of the Hugging Face model that supports large model loading such as BLOOM!",rt,ze,ot;return j=new J({props:{title:"Pipelines for inference",local:"pipelines-for-inference",headingTag:"h1"}}),U=new mt({props:{$$slots:{default:[ua]},$$scope:{ctx:$}}}),k=new J({props:{title:"Pipeline usage",local:"pipeline-usage",headingTag:"h2"}}),W=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)`,wrap:!1}}),X=new M({props:{code:"dHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I HAVE A DREAM BUT ONE DAY THIS NATION WILL RISE UP LIVE UP THE TRUE MEANING OF ITS TREES&#x27;</span>}`,wrap:!1}}),H=new M({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),N=new M({props:{code:"dHJhbnNjcmliZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGMS5mbGFjJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`transcriber(
    [
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>,
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/1.flac&quot;</span>,
    ]
)`,wrap:!1}}),F=new J({props:{title:"Parameters",local:"parameters",headingTag:"h2"}}),L=new M({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBteV9wYXJhbWV0ZXIlM0QxKSUwQSUwQW91dCUyMCUzRCUyMHRyYW5zY3JpYmVyKC4uLiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMHVzZSUyMCU2MG15X3BhcmFtZXRlciUzRDElNjAuJTBBb3V0JTIwJTNEJTIwdHJhbnNjcmliZXIoLi4uJTJDJTIwbXlfcGFyYW1ldGVyJTNEMiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMG92ZXJyaWRlJTIwYW5kJTIwdXNlJTIwJTYwbXlfcGFyYW1ldGVyJTNEMiU2MC4lMEFvdXQlMjAlM0QlMjB0cmFuc2NyaWJlciguLi4pJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBnbyUyMGJhY2slMjB0byUyMHVzaW5nJTIwJTYwbXlfcGFyYW1ldGVyJTNEMSU2MC4=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, my_parameter=<span class="hljs-number">1</span>)\n\nout = transcriber(...)  <span class="hljs-comment"># This will use `my_parameter=1`.</span>\nout = transcriber(..., my_parameter=<span class="hljs-number">2</span>)  <span class="hljs-comment"># This will override and use `my_parameter=2`.</span>\nout = transcriber(...)  <span class="hljs-comment"># This will go back to using `my_parameter=1`.</span>',wrap:!1}}),E=new J({props:{title:"Device",local:"device",headingTag:"h3"}}),A=new M({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwKQ==",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>)',wrap:!1}}),K=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGFjY2VsZXJhdGU=",highlighted:"pip install --upgrade accelerate",wrap:!1}}),ee=new M({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)',wrap:!1}}),te=new J({props:{title:"Batch size",local:"batch-size",headingTag:"h3"}}),ne=new M({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwJTJDJTIwYmF0Y2hfc2l6ZSUzRDIpJTBBYXVkaW9fZmlsZW5hbWVzJTIwJTNEJTIwJTVCZiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGJTdCaSU3RC5mbGFjJTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMSUyQyUyMDUpJTVEJTBBdGV4dHMlMjAlM0QlMjB0cmFuc2NyaWJlcihhdWRpb19maWxlbmFtZXMp",highlighted:`transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>, batch_size=<span class="hljs-number">2</span>)
audio_filenames = [<span class="hljs-string">f&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/<span class="hljs-subst">{i}</span>.flac&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>)]
texts = transcriber(audio_filenames)`,wrap:!1}}),re=new J({props:{title:"Task specific parameters",local:"task-specific-parameters",headingTag:"h3"}}),ce=new M({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjByZXR1cm5fdGltZXN0YW1wcyUzRFRydWUpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>, <span class="hljs-string">&#x27;chunks&#x27;</span>: [{<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">0.0</span>, <span class="hljs-number">11.88</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its&#x27;</span>}, {<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">11.88</span>, <span class="hljs-number">12.38</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; creed.&#x27;</span>}]}`,wrap:!1}}),ue=new M({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBjaHVua19sZW5ndGhfcyUzRDMwJTJDJTIwcmV0dXJuX3RpbWVzdGFtcHMlM0RUcnVlKSUwQXRyYW5zY3JpYmVyKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnNhbmNoaXQtZ2FuZGhpJTJGbGlicmlzcGVlY2hfbG9uZyUyRnJlc29sdmUlMkZtYWluJTJGYXVkaW8ud2F2JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, chunk_length_s=<span class="hljs-number">30</span>, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/sanchit-gandhi/librispeech_long/resolve/main/audio.wav&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot; Chapter 16. I might have told you of the beginning of this liaison in a few lines, but I wanted you to see every step by which we came.  I, too, agree to whatever Marguerite wished, Marguerite to be unable to live apart from me. It was the day after the evening...</span>`,wrap:!1}}),de=new J({props:{title:"Using pipelines on a dataset",local:"using-pipelines-on-a-dataset",headingTag:"h2"}}),Me=new M({props:{code:"ZGVmJTIwZGF0YSgpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGYlMjJNeSUyMGV4YW1wbGUlMjAlN0JpJTdEJTIyJTBBJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyZ3B0MiUyMiUyQyUyMGRldmljZSUzRDApJTBBZ2VuZXJhdGVkX2NoYXJhY3RlcnMlMjAlM0QlMjAwJTBBZm9yJTIwb3V0JTIwaW4lMjBwaXBlKGRhdGEoKSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfY2hhcmFjdGVycyUyMCUyQiUzRCUyMGxlbihvdXQlNUIwJTVEJTVCJTIyZ2VuZXJhdGVkX3RleHQlMjIlNUQp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">data</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> <span class="hljs-string">f&quot;My example <span class="hljs-subst">{i}</span>&quot;</span>


pipe = pipeline(model=<span class="hljs-string">&quot;gpt2&quot;</span>, device=<span class="hljs-number">0</span>)
generated_characters = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(data()):
    generated_characters += <span class="hljs-built_in">len</span>(out[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>])`,wrap:!1}}),je=new M({props:{code:"JTIzJTIwS2V5RGF0YXNldCUyMGlzJTIwYSUyMHV0aWwlMjB0aGF0JTIwd2lsbCUyMGp1c3QlMjBvdXRwdXQlMjB0aGUlMjBpdGVtJTIwd2UncmUlMjBpbnRlcmVzdGVkJTIwaW4uJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMucHRfdXRpbHMlMjBpbXBvcnQlMjBLZXlEYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRnRpbnktcmFuZG9tLXdhdjJ2ZWMyJTIyJTJDJTIwZGV2aWNlJTNEMCklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiU1QiUzQTEwJTVEJTIyKSUwQSUwQWZvciUyMG91dCUyMGluJTIwcGlwZShLZXlEYXRhc2V0KGRhdGFzZXQlMkMlMjAlMjJhdWRpbyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQob3V0KQ==",highlighted:`<span class="hljs-comment"># KeyDataset is a util that will just output the item we&#x27;re interested in.</span>
<span class="hljs-keyword">from</span> transformers.pipelines.pt_utils <span class="hljs-keyword">import</span> KeyDataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

pipe = pipeline(model=<span class="hljs-string">&quot;hf-internal-testing/tiny-random-wav2vec2&quot;</span>, device=<span class="hljs-number">0</span>)
dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation[:10]&quot;</span>)

<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(KeyDataset(dataset, <span class="hljs-string">&quot;audio&quot;</span>)):
    <span class="hljs-built_in">print</span>(out)`,wrap:!1}}),Je=new J({props:{title:"Using pipelines for a webserver",local:"using-pipelines-for-a-webserver",headingTag:"h2"}}),Z=new mt({props:{$$slots:{default:[fa]},$$scope:{ctx:$}}}),$e=new J({props:{title:"Vision pipeline",local:"vision-pipeline",headingTag:"h2"}}),Ie=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByZWRzJTIwJTNEJTIwdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),xe=new J({props:{title:"Text pipeline",local:"text-pipeline",headingTag:"h2"}}),Ge=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjBhJTIwJTYwemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTYwJTIwbW9kZWwuJTBBJTIzJTIwSXQlMjB3aWxsJTIwY2xhc3NpZnklMjB0ZXh0JTJDJTIwZXhjZXB0JTIweW91JTIwYXJlJTIwZnJlZSUyMHRvJTIwY2hvb3NlJTIwYW55JTIwbGFiZWwlMjB5b3UlMjBtaWdodCUyMGltYWdpbmUlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSUyMiklMEFjbGFzc2lmaWVyKCUwQSUyMCUyMCUyMCUyMCUyMkklMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISElMjIlMkMlMEElMjAlMjAlMjAlMjBjYW5kaWRhdGVfbGFiZWxzJTNEJTVCJTIydXJnZW50JTIyJTJDJTIwJTIybm90JTIwdXJnZW50JTIyJTJDJTIwJTIycGhvbmUlMjIlMkMlMjAlMjJ0YWJsZXQlMjIlMkMlMjAlMjJjb21wdXRlciUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This model is a \`zero-shot-classification\` model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># It will classify text, except you are free to choose any label you might imagine</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;facebook/bart-large-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;I have a problem with my iphone that needs to be resolved asap!!&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;urgent&quot;</span>, <span class="hljs-string">&quot;not urgent&quot;</span>, <span class="hljs-string">&quot;phone&quot;</span>, <span class="hljs-string">&quot;tablet&quot;</span>, <span class="hljs-string">&quot;computer&quot;</span>],
<span class="hljs-meta">... </span>)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.504</span>, <span class="hljs-number">0.479</span>, <span class="hljs-number">0.013</span>, <span class="hljs-number">0.003</span>, <span class="hljs-number">0.002</span>]}`,wrap:!1}}),Be=new J({props:{title:"Multimodal pipeline",local:"multimodal-pipeline",headingTag:"h2"}}),Ce=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdnFhJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiklMEF2cWEoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBpbnZvaWNlJTIwbnVtYmVyJTNGJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vqa = pipeline(model=<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vqa(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>,
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.42515</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;us-001&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}]`,wrap:!1}}),I=new mt({props:{$$slots:{default:[da]},$$scope:{ctx:$}}}),Re=new J({props:{title:"Using pipeline on large models with 🤗 accelerate :",local:"using-pipeline-on-large-models-with--accelerate-",headingTag:"h2"}}),Ve=new M({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),Ne=new M({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG1vZGVsX2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fOGJpdCUyMiUzQSUyMFRydWUlN0QpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate bitsandbytes</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, model_kwargs={<span class="hljs-string">&quot;load_in_8bit&quot;</span>: <span class="hljs-literal">True</span>})
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),{c(){d=i("meta"),w=l(),g=i("p"),T=l(),o(j.$$.fragment),y=l(),b=i("p"),b.innerHTML=ht,Fe=l(),x=i("ul"),x.innerHTML=ut,Se=l(),o(U.$$.fragment),Le=l(),o(k.$$.fragment),Qe=l(),G=i("p"),G.innerHTML=ft,Ee=l(),B=i("ol"),B.innerHTML=dt,Pe=l(),o(W.$$.fragment),Ae=l(),v=i("ol"),v.innerHTML=yt,De=l(),o(X.$$.fragment),Ke=l(),C=i("p"),C.innerHTML=Mt,Oe=l(),R=i("p"),R.innerHTML=gt,es=l(),_=i("p"),_.textContent=wt,ss=l(),o(H.$$.fragment),ts=l(),V=i("p"),V.innerHTML=Tt,as=l(),Y=i("p"),Y.textContent=jt,ls=l(),o(N.$$.fragment),ns=l(),q=i("p"),q.textContent=Jt,is=l(),z=i("ul"),z.innerHTML=bt,ps=l(),o(F.$$.fragment),rs=l(),S=i("p"),S.innerHTML=$t,os=l(),o(L.$$.fragment),cs=l(),Q=i("p"),Q.textContent=Ut,ms=l(),o(E.$$.fragment),hs=l(),P=i("p"),P.innerHTML=vt,us=l(),o(A.$$.fragment),fs=l(),D=i("p"),D.innerHTML=Zt,ds=l(),o(K.$$.fragment),ys=l(),O=i("p"),O.textContent=It,Ms=l(),o(ee.$$.fragment),gs=l(),se=i("p"),se.innerHTML=xt,ws=l(),o(te.$$.fragment),Ts=l(),ae=i("p"),ae.innerHTML=kt,js=l(),le=i("p"),le.textContent=Gt,Js=l(),o(ne.$$.fragment),bs=l(),ie=i("p"),ie.textContent=Bt,$s=l(),pe=i("p"),pe.innerHTML=Wt,Us=l(),o(re.$$.fragment),vs=l(),oe=i("p"),oe.innerHTML=Xt,Zs=l(),o(ce.$$.fragment),Is=l(),me=i("p"),me.innerHTML=Ct,xs=l(),he=i("p"),he.innerHTML=Rt,ks=l(),o(ue.$$.fragment),Gs=l(),fe=i("p"),fe.innerHTML=_t,Bs=l(),o(de.$$.fragment),Ws=l(),ye=i("p"),ye.textContent=Ht,Xs=l(),o(Me.$$.fragment),Cs=l(),ge=i("p"),ge.innerHTML=Vt,Rs=l(),we=i("p"),we.innerHTML=Yt,_s=l(),Te=i("p"),Te.innerHTML=Nt,Hs=l(),o(je.$$.fragment),Vs=l(),o(Je.$$.fragment),Ys=l(),o(Z.$$.fragment),Ns=l(),be=i("p"),be.innerHTML=qt,qs=l(),o($e.$$.fragment),zs=l(),Ue=i("p"),Ue.innerHTML=zt,Fs=l(),ve=i("p"),ve.textContent=Ft,Ss=l(),Ze=i("p"),Ze.innerHTML=St,Ls=l(),o(Ie.$$.fragment),Qs=l(),o(xe.$$.fragment),Es=l(),ke=i("p"),ke.innerHTML=Lt,Ps=l(),o(Ge.$$.fragment),As=l(),o(Be.$$.fragment),Ds=l(),We=i("p"),We.innerHTML=Qt,Ks=l(),Xe=i("p"),Xe.innerHTML=Et,Os=l(),o(Ce.$$.fragment),et=l(),o(I.$$.fragment),st=l(),o(Re.$$.fragment),tt=l(),_e=i("p"),_e.innerHTML=Pt,at=l(),He=i("p"),He.innerHTML=At,lt=l(),o(Ve.$$.fragment),nt=l(),Ye=i("p"),Ye.innerHTML=Dt,it=l(),o(Ne.$$.fragment),pt=l(),qe=i("p"),qe.textContent=Kt,rt=l(),ze=i("p"),this.h()},l(e){const s=ra("svelte-u9bgzb",document.head);d=p(s,"META",{name:!0,content:!0}),s.forEach(t),w=n(e),g=p(e,"P",{}),ta(g).forEach(t),T=n(e),c(j.$$.fragment,e),y=n(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-2fg02w"&&(b.innerHTML=ht),Fe=n(e),x=p(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-mnz724"&&(x.innerHTML=ut),Se=n(e),c(U.$$.fragment,e),Le=n(e),c(k.$$.fragment,e),Qe=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-utjyt8"&&(G.innerHTML=ft),Ee=n(e),B=p(e,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-jnkglc"&&(B.innerHTML=dt),Pe=n(e),c(W.$$.fragment,e),Ae=n(e),v=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(v)!=="svelte-urm7go"&&(v.innerHTML=yt),De=n(e),c(X.$$.fragment,e),Ke=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-jt3v05"&&(C.innerHTML=Mt),Oe=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1sbs9t3"&&(R.innerHTML=gt),es=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-5gg07s"&&(_.textContent=wt),ss=n(e),c(H.$$.fragment,e),ts=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1yjypga"&&(V.innerHTML=Tt),as=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1udq0dv"&&(Y.textContent=jt),ls=n(e),c(N.$$.fragment,e),ns=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1y2bxsh"&&(q.textContent=Jt),is=n(e),z=p(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-boqb6q"&&(z.innerHTML=bt),ps=n(e),c(F.$$.fragment,e),rs=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1kdpvr9"&&(S.innerHTML=$t),os=n(e),c(L.$$.fragment,e),cs=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-e9485z"&&(Q.textContent=Ut),ms=n(e),c(E.$$.fragment,e),hs=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-sob7ne"&&(P.innerHTML=vt),us=n(e),c(A.$$.fragment,e),fs=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1tfx7co"&&(D.innerHTML=Zt),ds=n(e),c(K.$$.fragment,e),ys=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-6riuku"&&(O.textContent=It),Ms=n(e),c(ee.$$.fragment,e),gs=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1otna9r"&&(se.innerHTML=xt),ws=n(e),c(te.$$.fragment,e),Ts=n(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-v1mumi"&&(ae.innerHTML=kt),js=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1jutax8"&&(le.textContent=Gt),Js=n(e),c(ne.$$.fragment,e),bs=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-n3ouik"&&(ie.textContent=Bt),$s=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-sq1wry"&&(pe.innerHTML=Wt),Us=n(e),c(re.$$.fragment,e),vs=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-wwb1cs"&&(oe.innerHTML=Xt),Zs=n(e),c(ce.$$.fragment,e),Is=n(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1ad1wem"&&(me.innerHTML=Ct),xs=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1ertchu"&&(he.innerHTML=Rt),ks=n(e),c(ue.$$.fragment,e),Gs=n(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1nowgzq"&&(fe.innerHTML=_t),Bs=n(e),c(de.$$.fragment,e),Ws=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1sh6mg6"&&(ye.textContent=Ht),Xs=n(e),c(Me.$$.fragment,e),Cs=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1rrzg9"&&(ge.innerHTML=Vt),Rs=n(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1litpj1"&&(we.innerHTML=Yt),_s=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1pgxdbs"&&(Te.innerHTML=Nt),Hs=n(e),c(je.$$.fragment,e),Vs=n(e),c(Je.$$.fragment,e),Ys=n(e),c(Z.$$.fragment,e),Ns=n(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-52dmam"&&(be.innerHTML=qt),qs=n(e),c($e.$$.fragment,e),zs=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-18ns5ze"&&(Ue.innerHTML=zt),Fs=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-ip2z2f"&&(ve.textContent=Ft),Ss=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1bks2jw"&&(Ze.innerHTML=St),Ls=n(e),c(Ie.$$.fragment,e),Qs=n(e),c(xe.$$.fragment,e),Es=n(e),ke=p(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-qc24ea"&&(ke.innerHTML=Lt),Ps=n(e),c(Ge.$$.fragment,e),As=n(e),c(Be.$$.fragment,e),Ds=n(e),We=p(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-jcjfzz"&&(We.innerHTML=Qt),Ks=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-4s0csr"&&(Xe.innerHTML=Et),Os=n(e),c(Ce.$$.fragment,e),et=n(e),c(I.$$.fragment,e),st=n(e),c(Re.$$.fragment,e),tt=n(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-32c7q2"&&(_e.innerHTML=Pt),at=n(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1yg483v"&&(He.innerHTML=At),lt=n(e),c(Ve.$$.fragment,e),nt=n(e),Ye=p(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1c9ycn6"&&(Ye.innerHTML=Dt),it=n(e),c(Ne.$$.fragment,e),pt=n(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1f2oxpa"&&(qe.textContent=Kt),rt=n(e),ze=p(e,"P",{}),ta(ze).forEach(t),this.h()},h(){ct(d,"name","hf:doc:metadata"),ct(d,"content",Ma),ct(v,"start","2")},m(e,s){oa(document.head,d),a(e,w,s),a(e,g,s),a(e,T,s),m(j,e,s),a(e,y,s),a(e,b,s),a(e,Fe,s),a(e,x,s),a(e,Se,s),m(U,e,s),a(e,Le,s),m(k,e,s),a(e,Qe,s),a(e,G,s),a(e,Ee,s),a(e,B,s),a(e,Pe,s),m(W,e,s),a(e,Ae,s),a(e,v,s),a(e,De,s),m(X,e,s),a(e,Ke,s),a(e,C,s),a(e,Oe,s),a(e,R,s),a(e,es,s),a(e,_,s),a(e,ss,s),m(H,e,s),a(e,ts,s),a(e,V,s),a(e,as,s),a(e,Y,s),a(e,ls,s),m(N,e,s),a(e,ns,s),a(e,q,s),a(e,is,s),a(e,z,s),a(e,ps,s),m(F,e,s),a(e,rs,s),a(e,S,s),a(e,os,s),m(L,e,s),a(e,cs,s),a(e,Q,s),a(e,ms,s),m(E,e,s),a(e,hs,s),a(e,P,s),a(e,us,s),m(A,e,s),a(e,fs,s),a(e,D,s),a(e,ds,s),m(K,e,s),a(e,ys,s),a(e,O,s),a(e,Ms,s),m(ee,e,s),a(e,gs,s),a(e,se,s),a(e,ws,s),m(te,e,s),a(e,Ts,s),a(e,ae,s),a(e,js,s),a(e,le,s),a(e,Js,s),m(ne,e,s),a(e,bs,s),a(e,ie,s),a(e,$s,s),a(e,pe,s),a(e,Us,s),m(re,e,s),a(e,vs,s),a(e,oe,s),a(e,Zs,s),m(ce,e,s),a(e,Is,s),a(e,me,s),a(e,xs,s),a(e,he,s),a(e,ks,s),m(ue,e,s),a(e,Gs,s),a(e,fe,s),a(e,Bs,s),m(de,e,s),a(e,Ws,s),a(e,ye,s),a(e,Xs,s),m(Me,e,s),a(e,Cs,s),a(e,ge,s),a(e,Rs,s),a(e,we,s),a(e,_s,s),a(e,Te,s),a(e,Hs,s),m(je,e,s),a(e,Vs,s),m(Je,e,s),a(e,Ys,s),m(Z,e,s),a(e,Ns,s),a(e,be,s),a(e,qs,s),m($e,e,s),a(e,zs,s),a(e,Ue,s),a(e,Fs,s),a(e,ve,s),a(e,Ss,s),a(e,Ze,s),a(e,Ls,s),m(Ie,e,s),a(e,Qs,s),m(xe,e,s),a(e,Es,s),a(e,ke,s),a(e,Ps,s),m(Ge,e,s),a(e,As,s),m(Be,e,s),a(e,Ds,s),a(e,We,s),a(e,Ks,s),a(e,Xe,s),a(e,Os,s),m(Ce,e,s),a(e,et,s),m(I,e,s),a(e,st,s),m(Re,e,s),a(e,tt,s),a(e,_e,s),a(e,at,s),a(e,He,s),a(e,lt,s),m(Ve,e,s),a(e,nt,s),a(e,Ye,s),a(e,it,s),m(Ne,e,s),a(e,pt,s),a(e,qe,s),a(e,rt,s),a(e,ze,s),ot=!0},p(e,[s]){const Ot={};s&2&&(Ot.$$scope={dirty:s,ctx:e}),U.$set(Ot);const ea={};s&2&&(ea.$$scope={dirty:s,ctx:e}),Z.$set(ea);const sa={};s&2&&(sa.$$scope={dirty:s,ctx:e}),I.$set(sa)},i(e){ot||(h(j.$$.fragment,e),h(U.$$.fragment,e),h(k.$$.fragment,e),h(W.$$.fragment,e),h(X.$$.fragment,e),h(H.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),h(L.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(de.$$.fragment,e),h(Me.$$.fragment,e),h(je.$$.fragment,e),h(Je.$$.fragment,e),h(Z.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(xe.$$.fragment,e),h(Ge.$$.fragment,e),h(Be.$$.fragment,e),h(Ce.$$.fragment,e),h(I.$$.fragment,e),h(Re.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),ot=!0)},o(e){u(j.$$.fragment,e),u(U.$$.fragment,e),u(k.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(H.$$.fragment,e),u(N.$$.fragment,e),u(F.$$.fragment,e),u(L.$$.fragment,e),u(E.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(de.$$.fragment,e),u(Me.$$.fragment,e),u(je.$$.fragment,e),u(Je.$$.fragment,e),u(Z.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(xe.$$.fragment,e),u(Ge.$$.fragment,e),u(Be.$$.fragment,e),u(Ce.$$.fragment,e),u(I.$$.fragment,e),u(Re.$$.fragment,e),u(Ve.$$.fragment,e),u(Ne.$$.fragment,e),ot=!1},d(e){e&&(t(w),t(g),t(T),t(y),t(b),t(Fe),t(x),t(Se),t(Le),t(Qe),t(G),t(Ee),t(B),t(Pe),t(Ae),t(v),t(De),t(Ke),t(C),t(Oe),t(R),t(es),t(_),t(ss),t(ts),t(V),t(as),t(Y),t(ls),t(ns),t(q),t(is),t(z),t(ps),t(rs),t(S),t(os),t(cs),t(Q),t(ms),t(hs),t(P),t(us),t(fs),t(D),t(ds),t(ys),t(O),t(Ms),t(gs),t(se),t(ws),t(Ts),t(ae),t(js),t(le),t(Js),t(bs),t(ie),t($s),t(pe),t(Us),t(vs),t(oe),t(Zs),t(Is),t(me),t(xs),t(he),t(ks),t(Gs),t(fe),t(Bs),t(Ws),t(ye),t(Xs),t(Cs),t(ge),t(Rs),t(we),t(_s),t(Te),t(Hs),t(Vs),t(Ys),t(Ns),t(be),t(qs),t(zs),t(Ue),t(Fs),t(ve),t(Ss),t(Ze),t(Ls),t(Qs),t(Es),t(ke),t(Ps),t(As),t(Ds),t(We),t(Ks),t(Xe),t(Os),t(et),t(st),t(tt),t(_e),t(at),t(He),t(lt),t(nt),t(Ye),t(it),t(pt),t(qe),t(rt),t(ze)),t(d),f(j,e),f(U,e),f(k,e),f(W,e),f(X,e),f(H,e),f(N,e),f(F,e),f(L,e),f(E,e),f(A,e),f(K,e),f(ee,e),f(te,e),f(ne,e),f(re,e),f(ce,e),f(ue,e),f(de,e),f(Me,e),f(je,e),f(Je,e),f(Z,e),f($e,e),f(Ie,e),f(xe,e),f(Ge,e),f(Be,e),f(Ce,e),f(I,e),f(Re,e),f(Ve,e),f(Ne,e)}}}const Ma='{"title":"Pipelines for inference","local":"pipelines-for-inference","sections":[{"title":"Pipeline usage","local":"pipeline-usage","sections":[],"depth":2},{"title":"Parameters","local":"parameters","sections":[{"title":"Device","local":"device","sections":[],"depth":3},{"title":"Batch size","local":"batch-size","sections":[],"depth":3},{"title":"Task specific parameters","local":"task-specific-parameters","sections":[],"depth":3}],"depth":2},{"title":"Using pipelines on a dataset","local":"using-pipelines-on-a-dataset","sections":[],"depth":2},{"title":"Using pipelines for a webserver","local":"using-pipelines-for-a-webserver","sections":[],"depth":2},{"title":"Vision pipeline","local":"vision-pipeline","sections":[],"depth":2},{"title":"Text pipeline","local":"text-pipeline","sections":[],"depth":2},{"title":"Multimodal pipeline","local":"multimodal-pipeline","sections":[],"depth":2},{"title":"Using pipeline on large models with 🤗 accelerate :","local":"using-pipeline-on-large-models-with--accelerate-","sections":[],"depth":2}],"depth":1}';function ga($){return na(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ha}),[]}class $a extends ia{constructor(d){super(),pa(this,d,ga,ya,la,{})}}export{$a as component};
