import{s as At,n as Kt,o as Ot}from"../chunks/scheduler.d586627e.js";import{S as el,i as tl,g as o,s as a,r as d,A as ll,h as i,f as l,c as n,j as St,u as r,x as m,k as Dt,y as sl,a as s,v as p,d as u,t as g,w as c}from"../chunks/index.8589a59c.js";import{C as M}from"../chunks/CodeBlock.47c46d2c.js";import{D as al}from"../chunks/DocNotebookDropdown.35d6cac5.js";import{H as b}from"../chunks/Heading.a70e045b.js";function nl(bt){let f,be,Me,Je,J,Te,T,ye,y,Jt=`Existem vários modelos multilinguísticos no 🤗 Transformers e seus usos para inferência diferem dos modelos monolíngues.
No entanto, nem <em>todos</em> os usos dos modelos multilíngues são tão diferentes.
Alguns modelos, como o <a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a>,
podem ser usados como se fossem monolíngues. Este guia irá te ajudar a usar modelos multilíngues cujo uso difere
para o propósito de inferência.`,he,h,Ue,U,Tt=`O XLM tem dez checkpoints diferentes dos quais apenas um é monolíngue.
Os nove checkpoints restantes do modelo são subdivididos em duas categorias:
checkpoints que usam de language embeddings e os que não.`,$e,$,ke,k,yt="Os seguintes modelos de XLM usam language embeddings para especificar a linguagem utilizada para a inferência.",je,j,ht="<li><code>xlm-mlm-ende-1024</code> (Masked language modeling, English-German)</li> <li><code>xlm-mlm-enfr-1024</code> (Masked language modeling, English-French)</li> <li><code>xlm-mlm-enro-1024</code> (Masked language modeling, English-Romanian)</li> <li><code>xlm-mlm-xnli15-1024</code> (Masked language modeling, XNLI languages)</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> (Masked language modeling + translation, XNLI languages)</li> <li><code>xlm-clm-enfr-1024</code> (Causal language modeling, English-French)</li> <li><code>xlm-clm-ende-1024</code> (Causal language modeling, English-German)</li>",we,w,Ut=`Os language embeddings são representados por um tensor de mesma dimensão que os <code>input_ids</code> passados ao modelo.
Os valores destes tensores dependem do idioma utilizado e se identificam pelos atributos <code>lang2id</code> e <code>id2lang</code> do tokenizador.`,xe,x,$t="Neste exemplo, carregamos o checkpoint <code>xlm-clm-enfr-1024</code>(Causal language modeling, English-French):",ve,v,Ce,C,kt="O atributo <code>lang2id</code> do tokenizador mostra os idiomas deste modelo e seus ids:",Ze,Z,_e,_,jt="Em seguida, cria-se um input de exemplo:",Xe,X,Ge,G,wt=`Estabelece-se o id do idioma, por exemplo <code>&quot;en&quot;</code>, e utiliza-se o mesmo para definir a language embedding.
A language embedding é um tensor preenchido com <code>0</code>, que é o id de idioma para o inglês.
Este tensor deve ser do mesmo tamanho que os <code>input_ids</code>.`,ze,z,Ie,I,xt="Agora você pode passar os <code>input_ids</code> e a language embedding ao modelo:",Re,R,We,W,vt='O script <a href="https://github.com/huggingface/transformers/tree/master/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> pode gerar um texto com language embeddings utilizando os checkpoints <code>xlm-clm</code>.',Ve,V,Le,L,Ct="Os seguintes modelos XLM não requerem o uso de language embeddings durante a inferência:",Be,B,Zt="<li><code>xlm-mlm-17-1280</code> (Modelagem de linguagem com máscara, 17 idiomas)</li> <li><code>xlm-mlm-100-1280</code> (Modelagem de linguagem com máscara, 100 idiomas)</li>",Ee,E,_t="Estes modelos são utilizados para representações genéricas de frase diferentemente dos checkpoints XLM anteriores.",qe,q,He,H,Xt="Os seguintes modelos do BERT podem ser utilizados para tarefas multilinguísticas:",Fe,F,Gt="<li><code>bert-base-multilingual-uncased</code> (Modelagem de linguagem com máscara + Previsão de frases, 102 idiomas)</li> <li><code>bert-base-multilingual-cased</code> (Modelagem de linguagem com máscara + Previsão de frases, 104 idiomas)</li>",Qe,Q,zt=`Estes modelos não requerem language embeddings durante a inferência. Devem identificar a linguagem a partir
do contexto e realizar a inferência em sequência.`,Ne,N,Ye,Y,It="Os seguintes modelos do XLM-RoBERTa podem ser utilizados para tarefas multilinguísticas:",Pe,P,Rt="<li><code>xlm-roberta-base</code> (Modelagem de linguagem com máscara, 100 idiomas)</li> <li><code>xlm-roberta-large</code> Modelagem de linguagem com máscara, 100 idiomas)</li>",Se,S,Wt=`O XLM-RoBERTa foi treinado com 2,5 TB de dados do CommonCrawl recém-criados e testados em 100 idiomas.
Proporciona fortes vantagens sobre os modelos multilinguísticos publicados anteriormente como o mBERT e o XLM em tarefas
subsequentes como a classificação, a rotulagem de sequências e à respostas a perguntas.`,De,D,Ae,A,Vt="Os seguintes modelos de M2M100 podem ser utilizados para traduções multilinguísticas:",Ke,K,Lt="<li><code>facebook/m2m100_418M</code> (Tradução)</li> <li><code>facebook/m2m100_1.2B</code> (Tradução)</li>",Oe,O,Bt=`Neste exemplo, o checkpoint <code>facebook/m2m100_418M</code> é carregado para traduzir do mandarim ao inglês. É possível
estabelecer o idioma de origem no tokenizador:`,et,ee,tt,te,Et="Tokenização do texto:",lt,le,st,se,qt=`O M2M100 força o id do idioma de destino como o primeiro token gerado para traduzir ao idioma de destino.
É definido o <code>forced_bos_token_id</code> como <code>en</code> no método <code>generate</code> para traduzir ao inglês.`,at,ae,nt,ne,ot,oe,Ht="Os seguintes modelos do MBart podem ser utilizados para tradução multilinguística:",it,ie,Ft="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (Tradução automática multilinguística de um a vários, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Tradução automática multilinguística de vários a vários, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Tradução automática multilinguística vários a um, 50 idiomas)</li> <li><code>facebook/mbart-large-50</code> (Tradução multilinguística, 50 idiomas)</li> <li><code>facebook/mbart-large-cc25</code></li>",mt,me,Qt=`Neste exemplo, carrega-se o checkpoint <code>facebook/mbart-large-50-many-to-many-mmt</code> para traduzir do finlandês ao inglês.
Pode-se definir o idioma de origem no tokenizador:`,dt,de,rt,re,Nt="Tokenizando o texto:",pt,pe,ut,ue,Yt=`O MBart força o id do idioma de destino como o primeiro token gerado para traduzir ao idioma de destino.
É definido o <code>forced_bos_token_id</code> como <code>en</code> no método <code>generate</code> para traduzir ao inglês.`,gt,ge,ct,ce,Pt=`Se estiver usando o checkpoint <code>facebook/mbart-large-50-many-to-one-mmt</code> não será necessário forçar o id do idioma de destino
como sendo o primeiro token generado, caso contrário a usagem é a mesma.`,Mt,fe,ft;return J=new b({props:{title:"Modelos multilinguísticos para inferência",local:"modelos-multilinguísticos-para-inferência",headingTag:"h1"}}),T=new al({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/multilingual.ipynb"}]}}),h=new b({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),$=new b({props:{title:"XLM com language embeddings",local:"xlm-com-language-embeddings",headingTag:"h3"}}),v=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),Z=new M({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),X=new M({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),z=new M({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),R=new M({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),V=new b({props:{title:"XLM sem language embeddings",local:"xlm-sem-language-embeddings",headingTag:"h3"}}),q=new b({props:{title:"BERT",local:"bert",headingTag:"h2"}}),N=new b({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),D=new b({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new M({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ae=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),ne=new b({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),de=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),pe=new M({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ge=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){f=o("meta"),be=a(),Me=o("p"),Je=a(),d(J.$$.fragment),Te=a(),d(T.$$.fragment),ye=a(),y=o("p"),y.innerHTML=Jt,he=a(),d(h.$$.fragment),Ue=a(),U=o("p"),U.textContent=Tt,$e=a(),d($.$$.fragment),ke=a(),k=o("p"),k.textContent=yt,je=a(),j=o("ul"),j.innerHTML=ht,we=a(),w=o("p"),w.innerHTML=Ut,xe=a(),x=o("p"),x.innerHTML=$t,ve=a(),d(v.$$.fragment),Ce=a(),C=o("p"),C.innerHTML=kt,Ze=a(),d(Z.$$.fragment),_e=a(),_=o("p"),_.textContent=jt,Xe=a(),d(X.$$.fragment),Ge=a(),G=o("p"),G.innerHTML=wt,ze=a(),d(z.$$.fragment),Ie=a(),I=o("p"),I.innerHTML=xt,Re=a(),d(R.$$.fragment),We=a(),W=o("p"),W.innerHTML=vt,Ve=a(),d(V.$$.fragment),Le=a(),L=o("p"),L.textContent=Ct,Be=a(),B=o("ul"),B.innerHTML=Zt,Ee=a(),E=o("p"),E.textContent=_t,qe=a(),d(q.$$.fragment),He=a(),H=o("p"),H.textContent=Xt,Fe=a(),F=o("ul"),F.innerHTML=Gt,Qe=a(),Q=o("p"),Q.textContent=zt,Ne=a(),d(N.$$.fragment),Ye=a(),Y=o("p"),Y.textContent=It,Pe=a(),P=o("ul"),P.innerHTML=Rt,Se=a(),S=o("p"),S.textContent=Wt,De=a(),d(D.$$.fragment),Ae=a(),A=o("p"),A.textContent=Vt,Ke=a(),K=o("ul"),K.innerHTML=Lt,Oe=a(),O=o("p"),O.innerHTML=Bt,et=a(),d(ee.$$.fragment),tt=a(),te=o("p"),te.textContent=Et,lt=a(),d(le.$$.fragment),st=a(),se=o("p"),se.innerHTML=qt,at=a(),d(ae.$$.fragment),nt=a(),d(ne.$$.fragment),ot=a(),oe=o("p"),oe.textContent=Ht,it=a(),ie=o("ul"),ie.innerHTML=Ft,mt=a(),me=o("p"),me.innerHTML=Qt,dt=a(),d(de.$$.fragment),rt=a(),re=o("p"),re.textContent=Nt,pt=a(),d(pe.$$.fragment),ut=a(),ue=o("p"),ue.innerHTML=Yt,gt=a(),d(ge.$$.fragment),ct=a(),ce=o("p"),ce.innerHTML=Pt,Mt=a(),fe=o("p"),this.h()},l(e){const t=ll("svelte-u9bgzb",document.head);f=i(t,"META",{name:!0,content:!0}),t.forEach(l),be=n(e),Me=i(e,"P",{}),St(Me).forEach(l),Je=n(e),r(J.$$.fragment,e),Te=n(e),r(T.$$.fragment,e),ye=n(e),y=i(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-2yvpqx"&&(y.innerHTML=Jt),he=n(e),r(h.$$.fragment,e),Ue=n(e),U=i(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1b8wedt"&&(U.textContent=Tt),$e=n(e),r($.$$.fragment,e),ke=n(e),k=i(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1g05fmh"&&(k.textContent=yt),je=n(e),j=i(e,"UL",{"data-svelte-h":!0}),m(j)!=="svelte-1iu32ge"&&(j.innerHTML=ht),we=n(e),w=i(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1wzx267"&&(w.innerHTML=Ut),xe=n(e),x=i(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-m23kr5"&&(x.innerHTML=$t),ve=n(e),r(v.$$.fragment,e),Ce=n(e),C=i(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1jlw8vy"&&(C.innerHTML=kt),Ze=n(e),r(Z.$$.fragment,e),_e=n(e),_=i(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-fdserj"&&(_.textContent=jt),Xe=n(e),r(X.$$.fragment,e),Ge=n(e),G=i(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-gr6p76"&&(G.innerHTML=wt),ze=n(e),r(z.$$.fragment,e),Ie=n(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-syxnxn"&&(I.innerHTML=xt),Re=n(e),r(R.$$.fragment,e),We=n(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1olpich"&&(W.innerHTML=vt),Ve=n(e),r(V.$$.fragment,e),Le=n(e),L=i(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-uu1fkj"&&(L.textContent=Ct),Be=n(e),B=i(e,"UL",{"data-svelte-h":!0}),m(B)!=="svelte-ggmk6q"&&(B.innerHTML=Zt),Ee=n(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1647i4h"&&(E.textContent=_t),qe=n(e),r(q.$$.fragment,e),He=n(e),H=i(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1otw1i1"&&(H.textContent=Xt),Fe=n(e),F=i(e,"UL",{"data-svelte-h":!0}),m(F)!=="svelte-1em2xx"&&(F.innerHTML=Gt),Qe=n(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-188d9hb"&&(Q.textContent=zt),Ne=n(e),r(N.$$.fragment,e),Ye=n(e),Y=i(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1on8run"&&(Y.textContent=It),Pe=n(e),P=i(e,"UL",{"data-svelte-h":!0}),m(P)!=="svelte-1u28pca"&&(P.innerHTML=Rt),Se=n(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1mo7moz"&&(S.textContent=Wt),De=n(e),r(D.$$.fragment,e),Ae=n(e),A=i(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1uzzyuv"&&(A.textContent=Vt),Ke=n(e),K=i(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-1811mz9"&&(K.innerHTML=Lt),Oe=n(e),O=i(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-18dxqmr"&&(O.innerHTML=Bt),et=n(e),r(ee.$$.fragment,e),tt=n(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-6ksz4d"&&(te.textContent=Et),lt=n(e),r(le.$$.fragment,e),st=n(e),se=i(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1k8y33q"&&(se.innerHTML=qt),at=n(e),r(ae.$$.fragment,e),nt=n(e),r(ne.$$.fragment,e),ot=n(e),oe=i(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-i72hny"&&(oe.textContent=Ht),it=n(e),ie=i(e,"UL",{"data-svelte-h":!0}),m(ie)!=="svelte-1wsg399"&&(ie.innerHTML=Ft),mt=n(e),me=i(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-134fnsi"&&(me.innerHTML=Qt),dt=n(e),r(de.$$.fragment,e),rt=n(e),re=i(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-u1agxv"&&(re.textContent=Nt),pt=n(e),r(pe.$$.fragment,e),ut=n(e),ue=i(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-ybbnzp"&&(ue.innerHTML=Yt),gt=n(e),r(ge.$$.fragment,e),ct=n(e),ce=i(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-quxms0"&&(ce.innerHTML=Pt),Mt=n(e),fe=i(e,"P",{}),St(fe).forEach(l),this.h()},h(){Dt(f,"name","hf:doc:metadata"),Dt(f,"content",ol)},m(e,t){sl(document.head,f),s(e,be,t),s(e,Me,t),s(e,Je,t),p(J,e,t),s(e,Te,t),p(T,e,t),s(e,ye,t),s(e,y,t),s(e,he,t),p(h,e,t),s(e,Ue,t),s(e,U,t),s(e,$e,t),p($,e,t),s(e,ke,t),s(e,k,t),s(e,je,t),s(e,j,t),s(e,we,t),s(e,w,t),s(e,xe,t),s(e,x,t),s(e,ve,t),p(v,e,t),s(e,Ce,t),s(e,C,t),s(e,Ze,t),p(Z,e,t),s(e,_e,t),s(e,_,t),s(e,Xe,t),p(X,e,t),s(e,Ge,t),s(e,G,t),s(e,ze,t),p(z,e,t),s(e,Ie,t),s(e,I,t),s(e,Re,t),p(R,e,t),s(e,We,t),s(e,W,t),s(e,Ve,t),p(V,e,t),s(e,Le,t),s(e,L,t),s(e,Be,t),s(e,B,t),s(e,Ee,t),s(e,E,t),s(e,qe,t),p(q,e,t),s(e,He,t),s(e,H,t),s(e,Fe,t),s(e,F,t),s(e,Qe,t),s(e,Q,t),s(e,Ne,t),p(N,e,t),s(e,Ye,t),s(e,Y,t),s(e,Pe,t),s(e,P,t),s(e,Se,t),s(e,S,t),s(e,De,t),p(D,e,t),s(e,Ae,t),s(e,A,t),s(e,Ke,t),s(e,K,t),s(e,Oe,t),s(e,O,t),s(e,et,t),p(ee,e,t),s(e,tt,t),s(e,te,t),s(e,lt,t),p(le,e,t),s(e,st,t),s(e,se,t),s(e,at,t),p(ae,e,t),s(e,nt,t),p(ne,e,t),s(e,ot,t),s(e,oe,t),s(e,it,t),s(e,ie,t),s(e,mt,t),s(e,me,t),s(e,dt,t),p(de,e,t),s(e,rt,t),s(e,re,t),s(e,pt,t),p(pe,e,t),s(e,ut,t),s(e,ue,t),s(e,gt,t),p(ge,e,t),s(e,ct,t),s(e,ce,t),s(e,Mt,t),s(e,fe,t),ft=!0},p:Kt,i(e){ft||(u(J.$$.fragment,e),u(T.$$.fragment,e),u(h.$$.fragment,e),u($.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(X.$$.fragment,e),u(z.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(q.$$.fragment,e),u(N.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(de.$$.fragment,e),u(pe.$$.fragment,e),u(ge.$$.fragment,e),ft=!0)},o(e){g(J.$$.fragment,e),g(T.$$.fragment,e),g(h.$$.fragment,e),g($.$$.fragment,e),g(v.$$.fragment,e),g(Z.$$.fragment,e),g(X.$$.fragment,e),g(z.$$.fragment,e),g(R.$$.fragment,e),g(V.$$.fragment,e),g(q.$$.fragment,e),g(N.$$.fragment,e),g(D.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(ge.$$.fragment,e),ft=!1},d(e){e&&(l(be),l(Me),l(Je),l(Te),l(ye),l(y),l(he),l(Ue),l(U),l($e),l(ke),l(k),l(je),l(j),l(we),l(w),l(xe),l(x),l(ve),l(Ce),l(C),l(Ze),l(_e),l(_),l(Xe),l(Ge),l(G),l(ze),l(Ie),l(I),l(Re),l(We),l(W),l(Ve),l(Le),l(L),l(Be),l(B),l(Ee),l(E),l(qe),l(He),l(H),l(Fe),l(F),l(Qe),l(Q),l(Ne),l(Ye),l(Y),l(Pe),l(P),l(Se),l(S),l(De),l(Ae),l(A),l(Ke),l(K),l(Oe),l(O),l(et),l(tt),l(te),l(lt),l(st),l(se),l(at),l(nt),l(ot),l(oe),l(it),l(ie),l(mt),l(me),l(dt),l(rt),l(re),l(pt),l(ut),l(ue),l(gt),l(ct),l(ce),l(Mt),l(fe)),l(f),c(J,e),c(T,e),c(h,e),c($,e),c(v,e),c(Z,e),c(X,e),c(z,e),c(R,e),c(V,e),c(q,e),c(N,e),c(D,e),c(ee,e),c(le,e),c(ae,e),c(ne,e),c(de,e),c(pe,e),c(ge,e)}}}const ol='{"title":"Modelos multilinguísticos para inferência","local":"modelos-multilinguísticos-para-inferência","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"XLM com language embeddings","local":"xlm-com-language-embeddings","sections":[],"depth":3},{"title":"XLM sem language embeddings","local":"xlm-sem-language-embeddings","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function il(bt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gl extends el{constructor(f){super(),tl(this,f,il,nl,At,{})}}export{gl as component};
