import{s as qo,o as No,n as ce}from"../chunks/scheduler.182ea377.js";import{S as Qo,i as Yo,g as l,s as a,r as m,A as Ho,h as d,f as t,c as i,j as T,u as g,x as c,k as J,y as r,a as s,v as u,d as f,t as h,w as y}from"../chunks/index.abf12888.js";import{T as So}from"../chunks/Tip.230e2334.js";import{D as I}from"../chunks/Docstring.93f6f462.js";import{C as v}from"../chunks/CodeBlock.57fe6e13.js";import{E as Ie}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as x}from"../chunks/Heading.16916d63.js";function zo(U){let p,w=`To generate images directly from a single pipeline, you can use <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22CombinedPipeline">KandinskyV22CombinedPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22Img2ImgCombinedPipeline">KandinskyV22Img2ImgCombinedPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22InpaintCombinedPipeline">KandinskyV22InpaintCombinedPipeline</a>.
These combined pipelines wrap the <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22PriorPipeline">KandinskyV22PriorPipeline</a> and <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22Pipeline">KandinskyV22Pipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22Img2ImgPipeline">KandinskyV22Img2ImgPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22InpaintPipeline">KandinskyV22InpaintPipeline</a> respectively into a single
pipeline for a simpler user experience`;return{c(){p=l("p"),p.innerHTML=w},l(b){p=d(b,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1i8f66r"&&(p.innerHTML=w)},m(b,_){s(b,p,_)},p:ce,d(b){b&&t(p)}}}function Do(U){let p,w="Examples:",b,_,M;return _=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQXplcm9faW1hZ2VfZW1iJTIwJTNEJTIwb3V0Lm5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lWMjJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRGltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUzRHplcm9faW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmltYWdlcyUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMmNhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>zero_image_emb = out.negative_image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){p=l("p"),p.textContent=w,b=a(),m(_.$$.fragment)},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=w),b=i(o),g(_.$$.fragment,o)},m(o,k){s(o,p,k),s(o,b,k),u(_,o,k),M=!0},p:ce,i(o){M||(f(_.$$.fragment,o),M=!0)},o(o){h(_.$$.fragment,o),M=!1},d(o){o&&(t(p),t(b)),y(_,o)}}}function Ao(U){let p,w="Examples:",b,_,M;return _=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBaW1hZ2VfZW1iJTJDJTIwbmVnYXRpdmVfaW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpLnRvX3R1cGxlKCklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0RuZWdhdGl2ZV9pbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2UlNUIwJTVELnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, negative_image_emb = pipe_prior(prompt).to_tuple()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){p=l("p"),p.textContent=w,b=a(),m(_.$$.fragment)},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=w),b=i(o),g(_.$$.fragment,o)},m(o,k){s(o,p,k),s(o,b,k),u(_,o,k),M=!0},p:ce,i(o){M||(f(_.$$.fragment,o),M=!0)},o(o){h(_.$$.fragment,o),M=!1},d(o){o&&(t(p),t(b)),y(_,o)}}}function Oo(U){let p,w="Examples:",b,_,M;return _=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUlMkMlMjBLYW5kaW5za3lWMjJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2h2aXNpb24lMjBpbXBvcnQlMjB0cmFuc2Zvcm1zJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFpbWcxJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEFpbWcyJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGc3RhcnJ5X25pZ2h0LmpwZWclMjIlMEEpJTBBaW1hZ2VzX3RleHRzJTIwJTNEJTIwJTVCJTIyYSUyMGNhdCUyMiUyQyUyMGltZzElMkMlMjBpbWcyJTVEJTBBd2VpZ2h0cyUyMCUzRCUyMCU1QjAuMyUyQyUyMDAuMyUyQyUyMDAuNCU1RCUwQW91dCUyMCUzRCUyMHBpcGVfcHJpb3IuaW50ZXJwb2xhdGUoaW1hZ2VzX3RleHRzJTJDJTIwd2VpZ2h0cyklMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RvdXQuaW1hZ2VfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEb3V0Lm5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzdGFycnlfY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorPipeline, KandinskyV22Pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior.interpolate(images_texts, weights)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=out.image_embeds,
<span class="hljs-meta">... </span>    negative_image_embeds=out.negative_image_embeds,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`,wrap:!1}}),{c(){p=l("p"),p.textContent=w,b=a(),m(_.$$.fragment)},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=w),b=i(o),g(_.$$.fragment,o)},m(o,k){s(o,p,k),s(o,b,k),u(_,o,k),M=!0},p:ce,i(o){M||(f(_.$$.fragment,o),M=!0)},o(o){h(_.$$.fragment,o),M=!1},d(o){o&&(t(p),t(b)),y(_,o)}}}function er(U){let p,w="Examples:",b,_,M;return _=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JFbWIyRW1iUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlX3ByaW9yLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIycmVkJTIwY2F0JTJDJTIwNGslMjBwaG90byUyMiUwQWltZyUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBaW1hZ2VfZW1iJTJDJTIwbmFnYXRpdmVfaW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQlMkMlMjBpbWFnZSUzRGltZyUyQyUyMHN0cmVuZ3RoJTNEMC4yKS50b190dXBsZSgpJTBBJTBBcGlwZSUyMCUzRCUyMEthbmRpbnNreVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTIyJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorEmb2EmbPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, nagative_image_emb = pipe_prior(prompt, image=img, strength=<span class="hljs-number">0.2</span>).to_tuple()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder, torch_dtype=torch.float16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){p=l("p"),p.textContent=w,b=a(),m(_.$$.fragment)},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=w),b=i(o),g(_.$$.fragment,o)},m(o,k){s(o,p,k),s(o,b,k),u(_,o,k),M=!0},p:ce,i(o){M||(f(_.$$.fragment,o),M=!0)},o(o){h(_.$$.fragment,o),M=!1},d(o){o&&(t(p),t(b)),y(_,o)}}}function nr(U){let p,w="Examples:",b,_,M;return _=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yRW1iMkVtYlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMFBJTCUwQSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lWMjJQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlX3ByaW9yLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1nMSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBJTBBaW1nMiUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRnN0YXJyeV9uaWdodC5qcGVnJTIyJTBBKSUwQSUwQWltYWdlc190ZXh0cyUyMCUzRCUyMCU1QiUyMmElMjBjYXQlMjIlMkMlMjBpbWcxJTJDJTIwaW1nMiU1RCUwQXdlaWdodHMlMjAlM0QlMjAlNUIwLjMlMkMlMjAwLjMlMkMlMjAwLjQlNUQlMEFpbWFnZV9lbWIlMkMlMjB6ZXJvX2ltYWdlX2VtYiUyMCUzRCUyMHBpcGVfcHJpb3IuaW50ZXJwb2xhdGUoaW1hZ2VzX3RleHRzJTJDJTIwd2VpZ2h0cyklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDE1MCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc3RhcnJ5X2NhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorEmb2EmbPipeline, KandinskyV22Pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior.interpolate(images_texts, weights)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">150</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`,wrap:!1}}),{c(){p=l("p"),p.textContent=w,b=a(),m(_.$$.fragment)},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=w),b=i(o),g(_.$$.fragment,o)},m(o,k){s(o,p,k),s(o,b,k),u(_,o,k),M=!0},p:ce,i(o){M||(f(_.$$.fragment,o),M=!0)},o(o){h(_.$$.fragment,o),M=!1},d(o){o&&(t(p),t(b)),y(_,o)}}}function tr(U){let p,w="Examples:",b,_,M;return _=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwbGlvbiUyMGluJTIwZ2FsYXhpZXMlMkMlMjBzcGlyYWxzJTJDJTIwbmVidWxhZSUyQyUyMHN0YXJzJTJDJTIwc21va2UlMkMlMjBpcmlkZXNjZW50JTJDJTIwaW50cmljYXRlJTIwZGV0YWlsJTJDJTIwb2N0YW5lJTIwcmVuZGVyJTJDJTIwOGslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipe = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A lion in galaxies, spirals, nebulae, stars, smoke, iridescent, intricate detail, octane render, 8k&quot;</span>

image = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=l("p"),p.textContent=w,b=a(),m(_.$$.fragment)},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=w),b=i(o),g(_.$$.fragment,o)},m(o,k){s(o,p,k),s(o,b,k),u(_,o,k),M=!0},p:ce,i(o){M||(f(_.$$.fragment,o),M=!0)},o(o){h(_.$$.fragment,o),M=!1},d(o){o&&(t(p),t(b)),y(_,o)}}}function ar(U){let p,w="Examples:",b,_,M;return _=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBvcyUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjBDaW5lbWF0aWMlMjBsaWdodGluZyUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmxvdyUyMHF1YWxpdHklMkMlMjBiYWQlMjBxdWFsaXR5JTIyJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWltYWdlLnRodW1ibmFpbCgoNzY4JTJDJTIwNzY4KSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RvcmlnaW5hbF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipe(prompt=prompt, image=original_image, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=l("p"),p.textContent=w,b=a(),m(_.$$.fragment)},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=w),b=i(o),g(_.$$.fragment,o)},m(o,k){s(o,p,k),s(o,b,k),u(_,o,k),M=!0},p:ce,i(o){M||(f(_.$$.fragment,o),M=!0)},o(o){h(_.$$.fragment,o),M=!1},d(o){o&&(t(p),t(b)),y(_,o)}}}function ir(U){let p,w="Examples:",b,_,M;return _=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXItaW5wYWludCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjBDaW5lbWF0aWMlMjBsaWdodGluZyUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmxvdyUyMHF1YWxpdHklMkMlMjBiYWQlMjBxdWFsaXR5JTIyJTBBJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMjIlMjAlMjIlMkZrYW5kaW5za3klMkZjYXQucG5nJTIyJTBBKSUwQSUwQW1hc2slMjAlM0QlMjBucC56ZXJvcygoNzY4JTJDJTIwNzY4KSUyQyUyMGR0eXBlJTNEbnAuZmxvYXQzMiklMEElMjMlMjBMZXQncyUyMG1hc2slMjBvdXQlMjBhbiUyMGFyZWElMjBhYm92ZSUyMHRoZSUyMGNhdCdzJTIwaGVhZCUwQW1hc2slNUIlM0EyNTAlMkMlMjAyNTAlM0EtMjUwJTVEJTIwJTNEJTIwMSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRG9yaWdpbmFsX2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span> <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
)

mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-comment"># Let&#x27;s mask out an area above the cat&#x27;s head</span>
mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

image = pipe(prompt=prompt, image=original_image, mask_image=mask, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=l("p"),p.textContent=w,b=a(),m(_.$$.fragment)},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=w),b=i(o),g(_.$$.fragment,o)},m(o,k){s(o,p,k),s(o,b,k),u(_,o,k),M=!0},p:ce,i(o){M||(f(_.$$.fragment,o),M=!0)},o(o){h(_.$$.fragment,o),M=!1},d(o){o&&(t(p),t(b)),y(_,o)}}}function sr(U){let p,w,b,_,M,o,k,Us="The Kandinsky 2.2 release includes robust new text-to-image models that support text-to-image generation, image-to-image generation, image interpolation, and text-guided image inpainting. The general workflow to perform these tasks using Kandinsky 2.2 is the same as in Kandinsky 2.1. First, you will need to use a prior pipeline to generate image embeddings based on your text prompt, and then use one of the image decoding pipelines to generate the output image. The only difference is that in Kandinsky 2.2, all of the decoding pipelines no longer accept the <code>prompt</code> input, and the image generation process is conditioned with only <code>image_embeds</code> and <code>negative_image_embeds</code>.",Dt,ve,Cs="Same as with Kandinsky 2.1, the easiest way to perform text-to-image generation is to use the combined Kandinsky pipeline. This process is exactly the same as Kandinsky 2.1. All you need to do is to replace the Kandinsky 2.1 checkpoint with 2.2.",At,Ue,Ot,Ce,js="Now, let’s look at an example where we take separate steps to run the prior pipeline and text-to-image pipeline. This way, we can understand what’s happening under the hood and how Kandinsky 2.2 differs from Kandinsky 2.1.",ea,je,Vs="First, let’s create the prior pipeline and text-to-image pipeline with Kandinsky 2.2 checkpoints.",na,Ve,ta,Pe,Ps="You can then use <code>pipe_prior</code> to generate image embeddings.",aa,Ze,ia,xe,Zs="Now you can pass these embeddings to the text-to-image pipeline. When using Kandinsky 2.2 you don’t need to pass the <code>prompt</code> (but you do with the previous version, Kandinsky 2.1).",sa,Ge,oa,We,xs='<img src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/kandinskyv22/%20blue%20eyes.png" alt="img"/>',ra,$e,Gs="We used the text-to-image pipeline as an example, but the same process applies to all decoding pipelines in Kandinsky 2.2. For more information, please refer to our API section for each pipeline.",la,Be,da,Ke,Ws='In the following, we give a simple example of how to use <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22ControlnetPipeline">KandinskyV22ControlnetPipeline</a> to add control to the text-to-image generation with a depth image.',pa,Ee,$s="First, let’s take an image and extract its depth map.",ca,Fe,ma,Xe,Bs='<img src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/kandinskyv22/cat.png" alt="img"/>',ga,Le,Ks="We can use the <code>depth-estimation</code> pipeline from transformers to process the image and retrieve its depth map.",ua,Re,fa,qe,Es="Now, we load the prior pipeline and the text-to-image controlnet pipeline",ha,Ne,ya,Qe,Fs="We pass the prompt and negative prompt through the prior to generate image embeddings",_a,Ye,ba,He,Xs="Now we can pass the image embeddings and the depth image we extracted to the controlnet pipeline. With Kandinsky 2.2, only prior pipelines accept <code>prompt</code> input. You do not need to pass the prompt to the controlnet pipeline.",Ma,Se,ka,ze,Ls=`The output image looks as follow:
<img src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/kandinskyv22/robot_cat_text2img.png" alt="img"/>`,wa,De,Ta,Ae,Rs='Kandinsky 2.2 also includes a <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22ControlnetImg2ImgPipeline">KandinskyV22ControlnetImg2ImgPipeline</a> that will allow you to add control to the image generation process with both the image and its depth map. This pipeline works really well with <a href="/docs/diffusers/main/en/api/pipelines/kandinsky_v22#diffusers.KandinskyV22PriorEmb2EmbPipeline">KandinskyV22PriorEmb2EmbPipeline</a>, which generates image embeddings based on both a text prompt and an image.',Ja,Oe,qs="For our robot cat example, we will pass the prompt and cat image together to the prior pipeline to generate an image embedding. We will then use that image embedding and the depth map of the cat to further control the image generation process.",Ia,en,Ns="We can use the same cat image and its depth map from the last example.",va,nn,Ua,tn,Qs="Here is the output. Compared with the output from our text-to-image controlnet example, it kept a lot more cat facial details from the original image and worked into the robot style we asked for.",Ca,an,Ys='<img src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/kandinskyv22/robot_cat.png" alt="img"/>',ja,sn,Va,on,Hs=`Running Kandinsky in inference requires running both a first prior pipeline: <a href="/docs/diffusers/main/en/api/pipelines/kandinsky#diffusers.KandinskyPriorPipeline">KandinskyPriorPipeline</a>
and a second image decoding pipeline which is one of <a href="/docs/diffusers/main/en/api/pipelines/kandinsky#diffusers.KandinskyPipeline">KandinskyPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/kandinsky#diffusers.KandinskyImg2ImgPipeline">KandinskyImg2ImgPipeline</a>, or <a href="/docs/diffusers/main/en/api/pipelines/kandinsky#diffusers.KandinskyInpaintPipeline">KandinskyInpaintPipeline</a>.`,Pa,rn,Ss=`The bulk of the computation time will always be the second image decoding pipeline, so when looking
into optimizing the model, one should look into the second image decoding pipeline.`,Za,ln,zs=`When running with PyTorch &lt; 2.0, we strongly recommend making use of <a href="https://github.com/facebookresearch/xformers" rel="nofollow"><code>xformers</code></a>
to speed-up the optimization. This can be done by simply running:`,xa,dn,Ga,pn,Ds=`When running on PyTorch &gt;= 2.0, PyTorch’s SDPA attention will automatically be used. For more information on
PyTorch’s SDPA, feel free to have a look at <a href="https://pytorch.org/blog/accelerated-diffusers-pt-20/" rel="nofollow">this blog post</a>.`,Wa,cn,As="To have explicit control , you can also manually set the pipeline to use PyTorch’s 2.0 efficient attention:",$a,mn,Ba,gn,Os=`The slowest and most memory intense attention processor is the default <code>AttnAddedKVProcessor</code> processor.
We do <strong>not</strong> recommend using it except for testing purposes or cases where very high determistic behaviour is desired.
You can set it with:`,Ka,un,Ea,fn,eo=`With PyTorch &gt;= 2.0, you can also use Kandinsky with <code>torch.compile</code> which depending
on your hardware can significantly speed-up your inference time once the model is compiled.
To use Kandinsksy with <code>torch.compile</code>, you can do:`,Fa,hn,Xa,yn,no=`After compilation you should see a very fast inference time. For more information,
feel free to have a look at <a href="https://huggingface.co/docs/diffusers/main/en/optimization/torch2.0" rel="nofollow">Our PyTorch 2.0 benchmark</a>.`,La,me,Ra,_n,qa,bn,to='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py" rel="nofollow">pipeline_kandinsky2_2.py</a></td> <td><em>Text-to-Image Generation</em></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py" rel="nofollow">pipeline_kandinsky2_2_combined.py</a></td> <td><em>End-to-end Text-to-Image, image-to-image, Inpainting Generation</em></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpaint.py" rel="nofollow">pipeline_kandinsky2_2_inpaint.py</a></td> <td><em>Image-Guided Image Generation</em></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py" rel="nofollow">pipeline_kandinsky2_2_img2img.py</a></td> <td><em>Image-Guided Image Generation</em></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py" rel="nofollow">pipeline_kandinsky2_2_controlnet.py</a></td> <td><em>Image-Guided Image Generation</em></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py" rel="nofollow">pipeline_kandinsky2_2_controlnet_img2img.py</a></td> <td><em>Image-Guided Image Generation</em></td></tr></tbody>',Na,Mn,Qa,G,kn,yi,tt,ao="Pipeline for text-to-image generation using Kandinsky",_i,at,io=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,bi,N,wn,Mi,it,so="Function invoked when calling the pipeline for generation.",ki,ge,Ya,Tn,Ha,W,Jn,wi,st,oo="Pipeline for text-to-image generation using Kandinsky",Ti,ot,ro=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ji,Q,In,Ii,rt,lo="Function invoked when calling the pipeline for generation.",vi,lt,po="Examples:",Sa,vn,za,$,Un,Ui,dt,co="Pipeline for image-to-image generation using Kandinsky",Ci,pt,mo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ji,Y,Cn,Vi,ct,go="Function invoked when calling the pipeline for generation.",Pi,mt,uo="Examples:",Da,jn,Aa,B,Vn,Zi,gt,fo="Pipeline for image-to-image generation using Kandinsky",xi,ut,ho=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Gi,H,Pn,Wi,ft,yo="Function invoked when calling the pipeline for generation.",$i,ht,_o="Examples:",Oa,Zn,ei,K,xn,Bi,yt,bo="Pipeline for text-guided image inpainting using Kandinsky2.1",Ki,_t,Mo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ei,S,Gn,Fi,bt,ko="Function invoked when calling the pipeline for generation.",Xi,Mt,wo="Examples:",ni,Wn,ti,j,$n,Li,kt,To="Pipeline for generating image prior for Kandinsky",Ri,wt,Jo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,qi,z,Bn,Ni,Tt,Io="Function invoked when calling the pipeline for generation.",Qi,ue,Yi,D,Kn,Hi,Jt,vo="Function invoked when using the prior pipeline for interpolation.",Si,fe,ai,En,ii,V,Fn,zi,It,Uo="Pipeline for generating image prior for Kandinsky",Di,vt,Co=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ai,A,Xn,Oi,Ut,jo="Function invoked when calling the pipeline for generation.",es,he,ns,O,Ln,ts,Ct,Vo="Function invoked when using the prior pipeline for interpolation.",as,ye,si,Rn,oi,P,qn,is,jt,Po="Combined Pipeline for text-to-image generation using Kandinsky",ss,Vt,Zo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,os,ee,Nn,rs,Pt,xo="Function invoked when calling the pipeline for generation.",ls,_e,ds,be,Qn,ps,Zt,Go=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,ri,Yn,li,C,Hn,cs,xt,Wo="Combined Pipeline for image-to-image generation using Kandinsky",ms,Gt,$o=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,gs,ne,Sn,us,Wt,Bo="Function invoked when calling the pipeline for generation.",fs,Me,hs,ke,zn,ys,$t,Ko=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,_s,we,Dn,bs,Bt,Eo=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,di,An,pi,Z,On,Ms,Kt,Fo="Combined Pipeline for inpainting generation using Kandinsky",ks,Et,Xo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ws,te,et,Ts,Ft,Lo="Function invoked when calling the pipeline for generation.",Js,Te,Is,Je,nt,vs,Xt,Ro=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,ci,zt,mi;return M=new x({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h1"}}),Ue=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwYWxpZW4lMjBjaGVlc2VidXJnZXIlMjBjcmVhdHVyZSUyMGVhdGluZyUyMGl0c2VsZiUyQyUyMGNsYXltYXRpb24lMkMlMjBjaW5lbWF0aWMlMkMlMjBtb29keSUyMGxpZ2h0aW5nJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIybG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTIwcHJpb3JfZ3VpZGFuY2Vfc2NhbGUlMjAlM0QxLjAlMkMlMjBoZWlnaHQlM0Q3NjglMkMlMjB3aWR0aCUzRDc2OCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipe = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A alien cheeseburger creature eating itself, claymation, cinematic, moody lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

image = pipe(prompt=prompt, negative_prompt=negative_prompt, prior_guidance_scale =<span class="hljs-number">1.0</span>, height=<span class="hljs-number">768</span>, width=<span class="hljs-number">768</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ve=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlX3ByaW9yJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEF0MmlfcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXQyaV9waXBlLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe_prior = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16)
pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

t2i_pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16)
t2i_pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ze=new v({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIycG9ydHJhaXQlMjBvZiUyMGElMjB3b21lbiUyQyUyMGJsdWUlMjBleWVzJTJDJTIwY2luZW1hdGljJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIybG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMjIlMEElMEFpbWFnZV9lbWJlZHMlMkMlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlMjAlM0QlMjBwaXBlX3ByaW9yKHByb21wdCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMS4wKS50b190dXBsZSgp",highlighted:`prompt = <span class="hljs-string">&quot;portrait of a women, blue eyes, cinematic&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

image_embeds, negative_image_embeds = pipe_prior(prompt, guidance_scale=<span class="hljs-number">1.0</span>).to_tuple()`,wrap:!1}}),Ge=new v({props:{code:"aW1hZ2UlMjAlM0QlMjB0MmlfcGlwZShpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWJlZHMlMkMlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0RuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlMkMlMjBoZWlnaHQlM0Q3NjglMkMlMjB3aWR0aCUzRDc2OCkuaW1hZ2VzJTVCJTBBJTIwJTIwJTIwJTIwMCUwQSU1RCUwQWltYWdlLnNhdmUoJTIycG9ydHJhaXQucG5nJTIyKQ==",highlighted:`image = t2i_pipe(<span class="hljs-attribute">image_embeds</span>=image_embeds, <span class="hljs-attribute">negative_image_embeds</span>=negative_image_embeds, <span class="hljs-attribute">height</span>=768, <span class="hljs-attribute">width</span>=768).images[
    0
]
image.save(<span class="hljs-string">&quot;portrait.png&quot;</span>)`,wrap:!1}}),Be=new x({props:{title:"Text-to-Image Generation with ControlNet Conditioning",local:"text-to-image-generation-with-controlnet-conditioning",headingTag:"h3"}}),Fe=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFpbWclMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZrYW5kaW5za3l2MjIlMkZjYXQucG5nJTIyJTBBKS5yZXNpemUoKDc2OCUyQyUyMDc2OCkp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/kandinskyv22/cat.png&quot;</span>
).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))`,wrap:!1}}),Re=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQSUwQWRlZiUyMG1ha2VfaGludChpbWFnZSUyQyUyMGRlcHRoX2VzdGltYXRvciklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMGRlcHRoX2VzdGltYXRvcihpbWFnZSklNUIlMjJkZXB0aCUyMiU1RCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQSUyMCUyMCUyMCUyMGRldGVjdGVkX21hcCUyMCUzRCUyMHRvcmNoLmZyb21fbnVtcHkoaW1hZ2UpLmZsb2F0KCklMjAlMkYlMjAyNTUuMCUwQSUyMCUyMCUyMCUyMGhpbnQlMjAlM0QlMjBkZXRlY3RlZF9tYXAucGVybXV0ZSgyJTJDJTIwMCUyQyUyMDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaGludCUwQSUwQSUwQWRlcHRoX2VzdGltYXRvciUyMCUzRCUyMHBpcGVsaW5lKCUyMmRlcHRoLWVzdGltYXRpb24lMjIpJTBBaGludCUyMCUzRCUyMG1ha2VfaGludChpbWclMkMlMjBkZXB0aF9lc3RpbWF0b3IpLnVuc3F1ZWV6ZSgwKS5oYWxmKCkudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image


<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_hint</span>(<span class="hljs-params">image, depth_estimator</span>):
    image = depth_estimator(image)[<span class="hljs-string">&quot;depth&quot;</span>]
    image = np.array(image)
    image = image[:, :, <span class="hljs-literal">None</span>]
    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
    detected_map = torch.from_numpy(image).<span class="hljs-built_in">float</span>() / <span class="hljs-number">255.0</span>
    hint = detected_map.permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> hint


depth_estimator = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>)
hint = make_hint(img, depth_estimator).unsqueeze(<span class="hljs-number">0</span>).half().to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ne=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUlMkMlMjBLYW5kaW5za3lWMjJDb250cm9sbmV0UGlwZWxpbmUlMEElMEFwaXBlX3ByaW9yJTIwJTNEJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItcHJpb3IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZV9wcmlvciUyMCUzRCUyMHBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyQ29udHJvbG5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1jb250cm9sbmV0LWRlcHRoJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorPipeline, KandinskyV22ControlnetPipeline

pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
)
pipe_prior = pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe = KandinskyV22ControlnetPipeline.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-controlnet-depth&quot;</span>, torch_dtype=torch.float16
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ye=new v({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMHJvYm90JTJDJTIwNGslMjBwaG90byUyMiUwQSUwQW5lZ2F0aXZlX3ByaW9yX3Byb21wdCUyMCUzRCUyMCUyMmxvd3JlcyUyQyUyMHRleHQlMkMlMjBlcnJvciUyQyUyMGNyb3BwZWQlMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTJDJTIwanBlZyUyMGFydGlmYWN0cyUyQyUyMHVnbHklMkMlMjBkdXBsaWNhdGUlMkMlMjBtb3JiaWQlMkMlMjBtdXRpbGF0ZWQlMkMlMjBvdXQlMjBvZiUyMGZyYW1lJTJDJTIwZXh0cmElMjBmaW5nZXJzJTJDJTIwbXV0YXRlZCUyMGhhbmRzJTJDJTIwcG9vcmx5JTIwZHJhd24lMjBoYW5kcyUyQyUyMHBvb3JseSUyMGRyYXduJTIwZmFjZSUyQyUyMG11dGF0aW9uJTJDJTIwZGVmb3JtZWQlMkMlMjBibHVycnklMkMlMjBkZWh5ZHJhdGVkJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMGJhZCUyMHByb3BvcnRpb25zJTJDJTIwZXh0cmElMjBsaW1icyUyQyUyMGNsb25lZCUyMGZhY2UlMkMlMjBkaXNmaWd1cmVkJTJDJTIwZ3Jvc3MlMjBwcm9wb3J0aW9ucyUyQyUyMG1hbGZvcm1lZCUyMGxpbWJzJTJDJTIwbWlzc2luZyUyMGFybXMlMkMlMjBtaXNzaW5nJTIwbGVncyUyQyUyMGV4dHJhJTIwYXJtcyUyQyUyMGV4dHJhJTIwbGVncyUyQyUyMGZ1c2VkJTIwZmluZ2VycyUyQyUyMHRvbyUyMG1hbnklMjBmaW5nZXJzJTJDJTIwbG9uZyUyMG5lY2slMkMlMjB1c2VybmFtZSUyQyUyMHdhdGVybWFyayUyQyUyMHNpZ25hdHVyZSUyMiUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg0MyklMEFpbWFnZV9lbWIlMkMlMjB6ZXJvX2ltYWdlX2VtYiUyMCUzRCUyMHBpcGVfcHJpb3IoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJpb3JfcHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTBBKS50b190dXBsZSgp",highlighted:`prompt = <span class="hljs-string">&quot;A robot, 4k photo&quot;</span>

negative_prior_prompt = <span class="hljs-string">&quot;lowres, text, error, cropped, worst quality, low quality, jpeg artifacts, ugly, duplicate, morbid, mutilated, out of frame, extra fingers, mutated hands, poorly drawn hands, poorly drawn face, mutation, deformed, blurry, dehydrated, bad anatomy, bad proportions, extra limbs, cloned face, disfigured, gross proportions, malformed limbs, missing arms, missing legs, extra arms, extra legs, fused fingers, too many fingers, long neck, username, watermark, signature&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">43</span>)
image_emb, zero_image_emb = pipe_prior(
    prompt=prompt, negative_prompt=negative_prior_prompt, generator=generator
).to_tuple()`,wrap:!1}}),Se=new v({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhpbnQlM0RoaW50JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEEpLmltYWdlcyUwQSUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJyb2JvdF9jYXQucG5nJTIyKQ==",highlighted:`images = pipe(
    image_embeds=image_emb,
    negative_image_embeds=zero_image_emb,
    hint=hint,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">768</span>,
).images

images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;robot_cat.png&quot;</span>)`,wrap:!1}}),De=new x({props:{title:"Image-to-Image Generation with ControlNet Conditioning",local:"image-to-image-generation-with-controlnet-conditioning",headingTag:"h3"}}),nn=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwS2FuZGluc2t5VjIyUHJpb3JFbWIyRW1iUGlwZWxpbmUlMkMlMjBLYW5kaW5za3lWMjJDb250cm9sbmV0SW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFpbWclMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMjIlMjAlMjIlMkZrYW5kaW5za3l2MjIlMkZjYXQucG5nJTIyJTBBKS5yZXNpemUoKDc2OCUyQyUyMDc2OCkpJTBBJTBBJTBBZGVmJTIwbWFrZV9oaW50KGltYWdlJTJDJTIwZGVwdGhfZXN0aW1hdG9yKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwZGVwdGhfZXN0aW1hdG9yKGltYWdlKSU1QiUyMmRlcHRoJTIyJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBucC5hcnJheShpbWFnZSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMGltYWdlJTVCJTNBJTJDJTIwJTNBJTJDJTIwTm9uZSU1RCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuY29uY2F0ZW5hdGUoJTVCaW1hZ2UlMkMlMjBpbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwYXhpcyUzRDIpJTBBJTIwJTIwJTIwJTIwZGV0ZWN0ZWRfbWFwJTIwJTNEJTIwdG9yY2guZnJvbV9udW1weShpbWFnZSkuZmxvYXQoKSUyMCUyRiUyMDI1NS4wJTBBJTIwJTIwJTIwJTIwaGludCUyMCUzRCUyMGRldGVjdGVkX21hcC5wZXJtdXRlKDIlMkMlMjAwJTJDJTIwMSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBoaW50JTBBJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiklMEFoaW50JTIwJTNEJTIwbWFrZV9oaW50KGltZyUyQyUyMGRlcHRoX2VzdGltYXRvcikudW5zcXVlZXplKDApLmhhbGYoKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lWMjJQcmlvckVtYjJFbWJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItcHJpb3IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZV9wcmlvciUyMCUzRCUyMHBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyQ29udHJvbG5ldEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItY29udHJvbG5ldC1kZXB0aCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjByb2JvdCUyQyUyMDRrJTIwcGhvdG8lMjIlMEFuZWdhdGl2ZV9wcmlvcl9wcm9tcHQlMjAlM0QlMjAlMjJsb3dyZXMlMkMlMjB0ZXh0JTJDJTIwZXJyb3IlMkMlMjBjcm9wcGVkJTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyQyUyMGpwZWclMjBhcnRpZmFjdHMlMkMlMjB1Z2x5JTJDJTIwZHVwbGljYXRlJTJDJTIwbW9yYmlkJTJDJTIwbXV0aWxhdGVkJTJDJTIwb3V0JTIwb2YlMjBmcmFtZSUyQyUyMGV4dHJhJTIwZmluZ2VycyUyQyUyMG11dGF0ZWQlMjBoYW5kcyUyQyUyMHBvb3JseSUyMGRyYXduJTIwaGFuZHMlMkMlMjBwb29ybHklMjBkcmF3biUyMGZhY2UlMkMlMjBtdXRhdGlvbiUyQyUyMGRlZm9ybWVkJTJDJTIwYmx1cnJ5JTJDJTIwZGVoeWRyYXRlZCUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjBiYWQlMjBwcm9wb3J0aW9ucyUyQyUyMGV4dHJhJTIwbGltYnMlMkMlMjBjbG9uZWQlMjBmYWNlJTJDJTIwZGlzZmlndXJlZCUyQyUyMGdyb3NzJTIwcHJvcG9ydGlvbnMlMkMlMjBtYWxmb3JtZWQlMjBsaW1icyUyQyUyMG1pc3NpbmclMjBhcm1zJTJDJTIwbWlzc2luZyUyMGxlZ3MlMkMlMjBleHRyYSUyMGFybXMlMkMlMjBleHRyYSUyMGxlZ3MlMkMlMjBmdXNlZCUyMGZpbmdlcnMlMkMlMjB0b28lMjBtYW55JTIwZmluZ2VycyUyQyUyMGxvbmclMjBuZWNrJTJDJTIwdXNlcm5hbWUlMkMlMjB3YXRlcm1hcmslMkMlMjBzaWduYXR1cmUlMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoNDMpJTBBJTBBJTIzJTIwcnVuJTIwcHJpb3IlMjBwaXBlbGluZSUwQSUwQWltZ19lbWIlMjAlM0QlMjBwaXBlX3ByaW9yKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW1nJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKSUwQW5lZ2F0aXZlX2VtYiUyMCUzRCUyMHBpcGVfcHJpb3IocHJvbXB0JTNEbmVnYXRpdmVfcHJpb3JfcHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWclMkMlMjBzdHJlbmd0aCUzRDElMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpJTBBJTBBJTIzJTIwcnVuJTIwY29udHJvbG5ldCUyMGltZzJpbWclMjBwaXBlbGluZSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWclMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRGltZ19lbWIuaW1hZ2VfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfZW1iLmltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMGhpbnQlM0RoaW50JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEEpLmltYWdlcyUwQSUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJyb2JvdF9jYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorEmb2EmbPipeline, KandinskyV22ControlnetImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

img = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span> <span class="hljs-string">&quot;/kandinskyv22/cat.png&quot;</span>
).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))


<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_hint</span>(<span class="hljs-params">image, depth_estimator</span>):
    image = depth_estimator(image)[<span class="hljs-string">&quot;depth&quot;</span>]
    image = np.array(image)
    image = image[:, :, <span class="hljs-literal">None</span>]
    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
    detected_map = torch.from_numpy(image).<span class="hljs-built_in">float</span>() / <span class="hljs-number">255.0</span>
    hint = detected_map.permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> hint


depth_estimator = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>)
hint = make_hint(img, depth_estimator).unsqueeze(<span class="hljs-number">0</span>).half().to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe_prior = KandinskyV22PriorEmb2EmbPipeline.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
)
pipe_prior = pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe = KandinskyV22ControlnetImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-controlnet-depth&quot;</span>, torch_dtype=torch.float16
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A robot, 4k photo&quot;</span>
negative_prior_prompt = <span class="hljs-string">&quot;lowres, text, error, cropped, worst quality, low quality, jpeg artifacts, ugly, duplicate, morbid, mutilated, out of frame, extra fingers, mutated hands, poorly drawn hands, poorly drawn face, mutation, deformed, blurry, dehydrated, bad anatomy, bad proportions, extra limbs, cloned face, disfigured, gross proportions, malformed limbs, missing arms, missing legs, extra arms, extra legs, fused fingers, too many fingers, long neck, username, watermark, signature&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">43</span>)

<span class="hljs-comment"># run prior pipeline</span>

img_emb = pipe_prior(prompt=prompt, image=img, strength=<span class="hljs-number">0.85</span>, generator=generator)
negative_emb = pipe_prior(prompt=negative_prior_prompt, image=img, strength=<span class="hljs-number">1</span>, generator=generator)

<span class="hljs-comment"># run controlnet img2img pipeline</span>
images = pipe(
    image=img,
    strength=<span class="hljs-number">0.5</span>,
    image_embeds=img_emb.image_embeds,
    negative_image_embeds=negative_emb.image_embeds,
    hint=hint,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">768</span>,
).images

images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;robot_cat.png&quot;</span>)`,wrap:!1}}),sn=new x({props:{title:"Optimization",local:"optimization",headingTag:"h2"}}),dn=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0MmlfcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXQyaV9waXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

t2i_pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16)
t2i_pipe.enable_xformers_memory_efficient_attention()`,wrap:!1}}),mn=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2RlbHMuYXR0ZW50aW9uX3Byb2Nlc3NvciUyMGltcG9ydCUyMEF0dG5BZGRlZEtWUHJvY2Vzc29yMl8wJTBBJTBBdDJpX3BpcGUudW5ldC5zZXRfYXR0bl9wcm9jZXNzb3IoQXR0bkFkZGVkS1ZQcm9jZXNzb3IyXzAoKSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.models.attention_processor <span class="hljs-keyword">import</span> AttnAddedKVProcessor2_0

t2i_pipe.unet.set_attn_processor(AttnAddedKVProcessor2_0())`,wrap:!1}}),un=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2RlbHMuYXR0ZW50aW9uX3Byb2Nlc3NvciUyMGltcG9ydCUyMEF0dG5BZGRlZEtWUHJvY2Vzc29yJTBBJTBBdDJpX3BpcGUudW5ldC5zZXRfYXR0bl9wcm9jZXNzb3IoQXR0bkFkZGVkS1ZQcm9jZXNzb3IoKSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.models.attention_processor <span class="hljs-keyword">import</span> AttnAddedKVProcessor

t2i_pipe.unet.set_attn_processor(AttnAddedKVProcessor())`,wrap:!1}}),hn=new v({props:{code:"dDJpX3BpcGUudW5ldC50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEF0MmlfcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZSh0MmlfcGlwZS51bmV0JTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUp",highlighted:`t2i_pipe.unet.to(memory_format=torch.channels_last)
t2i_pipe.unet = torch.<span class="hljs-built_in">compile</span>(t2i_pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),me=new So({props:{$$slots:{default:[zo]},$$scope:{ctx:U}}}),_n=new x({props:{title:"Available Pipelines:",local:"available-pipelines",headingTag:"h2"}}),Mn=new x({props:{title:"KandinskyV22Pipeline",local:"diffusers.KandinskyV22Pipeline",headingTag:"h3"}}),kn=new I({props:{name:"class diffusers.KandinskyV22Pipeline",anchor:"diffusers.KandinskyV22Pipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Pipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Pipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Pipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py#L67"}}),wn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22Pipeline.__call__",parameters:[{name:"image_embeds",val:": typing.Union[torch.FloatTensor, typing.List[torch.FloatTensor]]"},{name:"negative_image_embeds",val:": typing.Union[torch.FloatTensor, typing.List[torch.FloatTensor]]"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Pipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py#L112",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ge=new Ie({props:{anchor:"diffusers.KandinskyV22Pipeline.__call__.example",$$slots:{default:[Do]},$$scope:{ctx:U}}}),Tn=new x({props:{title:"KandinskyV22ControlnetPipeline",local:"diffusers.KandinskyV22ControlnetPipeline",headingTag:"h3"}}),Jn=new I({props:{name:"class diffusers.KandinskyV22ControlnetPipeline",anchor:"diffusers.KandinskyV22ControlnetPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py#L106"}}),In=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__",parameters:[{name:"image_embeds",val:": typing.Union[torch.FloatTensor, typing.List[torch.FloatTensor]]"},{name:"negative_image_embeds",val:": typing.Union[torch.FloatTensor, typing.List[torch.FloatTensor]]"},{name:"hint",val:": FloatTensor"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.hint",description:`<strong>hint</strong> (<code>torch.FloatTensor</code>) &#x2014;
The controlnet condition.`,name:"hint"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py#L151",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),vn=new x({props:{title:"KandinskyV22ControlnetImg2ImgPipeline",local:"diffusers.KandinskyV22ControlnetImg2ImgPipeline",headingTag:"h3"}}),Un=new I({props:{name:"class diffusers.KandinskyV22ControlnetImg2ImgPipeline",anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py#L120"}}),Cn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__",parameters:[{name:"image_embeds",val:": typing.Union[torch.FloatTensor, typing.List[torch.FloatTensor]]"},{name:"image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image, typing.List[torch.FloatTensor], typing.List[PIL.Image.Image]]"},{name:"negative_image_embeds",val:": typing.Union[torch.FloatTensor, typing.List[torch.FloatTensor]]"},{name:"hint",val:": FloatTensor"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.hint",description:`<strong>hint</strong> (<code>torch.FloatTensor</code>) &#x2014;
The controlnet condition.`,name:"hint"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py#L206",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),jn=new x({props:{title:"KandinskyV22Img2ImgPipeline",local:"diffusers.KandinskyV22Img2ImgPipeline",headingTag:"h3"}}),Vn=new I({props:{name:"class diffusers.KandinskyV22Img2ImgPipeline",anchor:"diffusers.KandinskyV22Img2ImgPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py#L94"}}),Pn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__",parameters:[{name:"image_embeds",val:": typing.Union[torch.FloatTensor, typing.List[torch.FloatTensor]]"},{name:"image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image, typing.List[torch.FloatTensor], typing.List[PIL.Image.Image]]"},{name:"negative_image_embeds",val:": typing.Union[torch.FloatTensor, typing.List[torch.FloatTensor]]"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py#L179",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Zn=new x({props:{title:"KandinskyV22InpaintPipeline",local:"diffusers.KandinskyV22InpaintPipeline",headingTag:"h3"}}),xn=new I({props:{name:"class diffusers.KandinskyV22InpaintPipeline",anchor:"diffusers.KandinskyV22InpaintPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22InpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22InpaintPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpainting.py#L237"}}),Gn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22InpaintPipeline.__call__",parameters:[{name:"image_embeds",val:": typing.Union[torch.FloatTensor, typing.List[torch.FloatTensor]]"},{name:"image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image]"},{name:"mask_image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image, numpy.ndarray]"},{name:"negative_image_embeds",val:": typing.Union[torch.FloatTensor, typing.List[torch.FloatTensor]]"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be inpainted, <em>i.e.</em> parts of the image will
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>.`,name:"image"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpainting.py#L283",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Wn=new x({props:{title:"KandinskyV22PriorPipeline",local:"diffusers.KandinskyV22PriorPipeline",headingTag:"h3"}}),$n=new I({props:{name:"class diffusers.KandinskyV22PriorPipeline",anchor:"diffusers.KandinskyV22PriorPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyV22PriorPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyV22PriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyV22PriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyV22PriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22PriorPipeline.image_processor",description:`<strong>image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L84"}}),Bn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22PriorPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": typing.Optional[str] = 'pt'"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L357",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),ue=new Ie({props:{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.example",$$slots:{default:[Ao]},$$scope:{ctx:U}}}),Kn=new I({props:{name:"interpolate",anchor:"diffusers.KandinskyV22PriorPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": typing.List[typing.Union[str, PIL.Image.Image, torch.FloatTensor]]"},{name:"weights",val:": typing.List[float]"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prior_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.FloatTensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L130",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),fe=new Ie({props:{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.example",$$slots:{default:[Oo]},$$scope:{ctx:U}}}),En=new x({props:{title:"KandinskyV22PriorEmb2EmbPipeline",local:"diffusers.KandinskyV22PriorEmb2EmbPipeline",headingTag:"h3"}}),Fn=new I({props:{name:"class diffusers.KandinskyV22PriorEmb2EmbPipeline",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L102"}}),Xn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Union[torch.Tensor, typing.List[torch.Tensor], PIL.Image.Image, typing.List[PIL.Image.Image]]"},{name:"strength",val:": float = 0.3"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": typing.Optional[str] = 'pt'"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>emb</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added.`,name:"strength"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.emb",description:`<strong>emb</strong> (<code>torch.FloatTensor</code>) &#x2014;
The image embedding.`,name:"emb"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L396",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),he=new Ie({props:{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.example",$$slots:{default:[er]},$$scope:{ctx:U}}}),Ln=new I({props:{name:"interpolate",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": typing.List[typing.Union[str, PIL.Image.Image, torch.FloatTensor]]"},{name:"weights",val:": typing.List[float]"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prior_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.FloatTensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L155",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),ye=new Ie({props:{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.example",$$slots:{default:[nr]},$$scope:{ctx:U}}}),Rn=new x({props:{title:"KandinskyV22CombinedPipeline",local:"diffusers.KandinskyV22CombinedPipeline",headingTag:"h3"}}),qn=new I({props:{name:"class diffusers.KandinskyV22CombinedPipeline",anchor:"diffusers.KandinskyV22CombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22CombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22CombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22CombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L110"}}),Nn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22CombinedPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L204",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),_e=new Ie({props:{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.example",$$slots:{default:[tr]},$$scope:{ctx:U}}}),Qn=new I({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22CombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L184"}}),Yn=new x({props:{title:"KandinskyV22Img2ImgCombinedPipeline",local:"diffusers.KandinskyV22Img2ImgCombinedPipeline",headingTag:"h3"}}),Hn=new I({props:{name:"class diffusers.KandinskyV22Img2ImgCombinedPipeline",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L316"}}),Sn=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image, typing.List[torch.FloatTensor], typing.List[PIL.Image.Image]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L420",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Me=new Ie({props:{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.example",$$slots:{default:[ar]},$$scope:{ctx:U}}}),zn=new I({props:{name:"enable_model_cpu_offload",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L390"}}),Dn=new I({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L400"}}),An=new x({props:{title:"KandinskyV22InpaintCombinedPipeline",local:"diffusers.KandinskyV22InpaintCombinedPipeline",headingTag:"h3"}}),On=new I({props:{name:"class diffusers.KandinskyV22InpaintCombinedPipeline",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L554"}}),et=new I({props:{name:"__call__",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image, typing.List[torch.FloatTensor], typing.List[PIL.Image.Image]]"},{name:"mask_image",val:": typing.Union[torch.FloatTensor, PIL.Image.Image, typing.List[torch.FloatTensor], typing.List[PIL.Image.Image]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L648",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Te=new Ie({props:{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.example",$$slots:{default:[ir]},$$scope:{ctx:U}}}),nt=new I({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L628"}}),{c(){p=l("meta"),w=a(),b=l("p"),_=a(),m(M.$$.fragment),o=a(),k=l("p"),k.innerHTML=Us,Dt=a(),ve=l("p"),ve.textContent=Cs,At=a(),m(Ue.$$.fragment),Ot=a(),Ce=l("p"),Ce.textContent=js,ea=a(),je=l("p"),je.textContent=Vs,na=a(),m(Ve.$$.fragment),ta=a(),Pe=l("p"),Pe.innerHTML=Ps,aa=a(),m(Ze.$$.fragment),ia=a(),xe=l("p"),xe.innerHTML=Zs,sa=a(),m(Ge.$$.fragment),oa=a(),We=l("p"),We.innerHTML=xs,ra=a(),$e=l("p"),$e.textContent=Gs,la=a(),m(Be.$$.fragment),da=a(),Ke=l("p"),Ke.innerHTML=Ws,pa=a(),Ee=l("p"),Ee.textContent=$s,ca=a(),m(Fe.$$.fragment),ma=a(),Xe=l("p"),Xe.innerHTML=Bs,ga=a(),Le=l("p"),Le.innerHTML=Ks,ua=a(),m(Re.$$.fragment),fa=a(),qe=l("p"),qe.textContent=Es,ha=a(),m(Ne.$$.fragment),ya=a(),Qe=l("p"),Qe.textContent=Fs,_a=a(),m(Ye.$$.fragment),ba=a(),He=l("p"),He.innerHTML=Xs,Ma=a(),m(Se.$$.fragment),ka=a(),ze=l("p"),ze.innerHTML=Ls,wa=a(),m(De.$$.fragment),Ta=a(),Ae=l("p"),Ae.innerHTML=Rs,Ja=a(),Oe=l("p"),Oe.textContent=qs,Ia=a(),en=l("p"),en.textContent=Ns,va=a(),m(nn.$$.fragment),Ua=a(),tn=l("p"),tn.textContent=Qs,Ca=a(),an=l("p"),an.innerHTML=Ys,ja=a(),m(sn.$$.fragment),Va=a(),on=l("p"),on.innerHTML=Hs,Pa=a(),rn=l("p"),rn.textContent=Ss,Za=a(),ln=l("p"),ln.innerHTML=zs,xa=a(),m(dn.$$.fragment),Ga=a(),pn=l("p"),pn.innerHTML=Ds,Wa=a(),cn=l("p"),cn.textContent=As,$a=a(),m(mn.$$.fragment),Ba=a(),gn=l("p"),gn.innerHTML=Os,Ka=a(),m(un.$$.fragment),Ea=a(),fn=l("p"),fn.innerHTML=eo,Fa=a(),m(hn.$$.fragment),Xa=a(),yn=l("p"),yn.innerHTML=no,La=a(),m(me.$$.fragment),Ra=a(),m(_n.$$.fragment),qa=a(),bn=l("table"),bn.innerHTML=to,Na=a(),m(Mn.$$.fragment),Qa=a(),G=l("div"),m(kn.$$.fragment),yi=a(),tt=l("p"),tt.textContent=ao,_i=a(),at=l("p"),at.innerHTML=io,bi=a(),N=l("div"),m(wn.$$.fragment),Mi=a(),it=l("p"),it.textContent=so,ki=a(),m(ge.$$.fragment),Ya=a(),m(Tn.$$.fragment),Ha=a(),W=l("div"),m(Jn.$$.fragment),wi=a(),st=l("p"),st.textContent=oo,Ti=a(),ot=l("p"),ot.innerHTML=ro,Ji=a(),Q=l("div"),m(In.$$.fragment),Ii=a(),rt=l("p"),rt.textContent=lo,vi=a(),lt=l("p"),lt.textContent=po,Sa=a(),m(vn.$$.fragment),za=a(),$=l("div"),m(Un.$$.fragment),Ui=a(),dt=l("p"),dt.textContent=co,Ci=a(),pt=l("p"),pt.innerHTML=mo,ji=a(),Y=l("div"),m(Cn.$$.fragment),Vi=a(),ct=l("p"),ct.textContent=go,Pi=a(),mt=l("p"),mt.textContent=uo,Da=a(),m(jn.$$.fragment),Aa=a(),B=l("div"),m(Vn.$$.fragment),Zi=a(),gt=l("p"),gt.textContent=fo,xi=a(),ut=l("p"),ut.innerHTML=ho,Gi=a(),H=l("div"),m(Pn.$$.fragment),Wi=a(),ft=l("p"),ft.textContent=yo,$i=a(),ht=l("p"),ht.textContent=_o,Oa=a(),m(Zn.$$.fragment),ei=a(),K=l("div"),m(xn.$$.fragment),Bi=a(),yt=l("p"),yt.textContent=bo,Ki=a(),_t=l("p"),_t.innerHTML=Mo,Ei=a(),S=l("div"),m(Gn.$$.fragment),Fi=a(),bt=l("p"),bt.textContent=ko,Xi=a(),Mt=l("p"),Mt.textContent=wo,ni=a(),m(Wn.$$.fragment),ti=a(),j=l("div"),m($n.$$.fragment),Li=a(),kt=l("p"),kt.textContent=To,Ri=a(),wt=l("p"),wt.innerHTML=Jo,qi=a(),z=l("div"),m(Bn.$$.fragment),Ni=a(),Tt=l("p"),Tt.textContent=Io,Qi=a(),m(ue.$$.fragment),Yi=a(),D=l("div"),m(Kn.$$.fragment),Hi=a(),Jt=l("p"),Jt.textContent=vo,Si=a(),m(fe.$$.fragment),ai=a(),m(En.$$.fragment),ii=a(),V=l("div"),m(Fn.$$.fragment),zi=a(),It=l("p"),It.textContent=Uo,Di=a(),vt=l("p"),vt.innerHTML=Co,Ai=a(),A=l("div"),m(Xn.$$.fragment),Oi=a(),Ut=l("p"),Ut.textContent=jo,es=a(),m(he.$$.fragment),ns=a(),O=l("div"),m(Ln.$$.fragment),ts=a(),Ct=l("p"),Ct.textContent=Vo,as=a(),m(ye.$$.fragment),si=a(),m(Rn.$$.fragment),oi=a(),P=l("div"),m(qn.$$.fragment),is=a(),jt=l("p"),jt.textContent=Po,ss=a(),Vt=l("p"),Vt.innerHTML=Zo,os=a(),ee=l("div"),m(Nn.$$.fragment),rs=a(),Pt=l("p"),Pt.textContent=xo,ls=a(),m(_e.$$.fragment),ds=a(),be=l("div"),m(Qn.$$.fragment),ps=a(),Zt=l("p"),Zt.innerHTML=Go,ri=a(),m(Yn.$$.fragment),li=a(),C=l("div"),m(Hn.$$.fragment),cs=a(),xt=l("p"),xt.textContent=Wo,ms=a(),Gt=l("p"),Gt.innerHTML=$o,gs=a(),ne=l("div"),m(Sn.$$.fragment),us=a(),Wt=l("p"),Wt.textContent=Bo,fs=a(),m(Me.$$.fragment),hs=a(),ke=l("div"),m(zn.$$.fragment),ys=a(),$t=l("p"),$t.innerHTML=Ko,_s=a(),we=l("div"),m(Dn.$$.fragment),bs=a(),Bt=l("p"),Bt.innerHTML=Eo,di=a(),m(An.$$.fragment),pi=a(),Z=l("div"),m(On.$$.fragment),Ms=a(),Kt=l("p"),Kt.textContent=Fo,ks=a(),Et=l("p"),Et.innerHTML=Xo,ws=a(),te=l("div"),m(et.$$.fragment),Ts=a(),Ft=l("p"),Ft.textContent=Lo,Js=a(),m(Te.$$.fragment),Is=a(),Je=l("div"),m(nt.$$.fragment),vs=a(),Xt=l("p"),Xt.innerHTML=Ro,ci=a(),zt=l("p"),this.h()},l(e){const n=Ho("svelte-u9bgzb",document.head);p=d(n,"META",{name:!0,content:!0}),n.forEach(t),w=i(e),b=d(e,"P",{}),T(b).forEach(t),_=i(e),g(M.$$.fragment,e),o=i(e),k=d(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1fq4hdh"&&(k.innerHTML=Us),Dt=i(e),ve=d(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-1emcolw"&&(ve.textContent=Cs),At=i(e),g(Ue.$$.fragment,e),Ot=i(e),Ce=d(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-226n3c"&&(Ce.textContent=js),ea=i(e),je=d(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-1k6wutn"&&(je.textContent=Vs),na=i(e),g(Ve.$$.fragment,e),ta=i(e),Pe=d(e,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-4o6xpe"&&(Pe.innerHTML=Ps),aa=i(e),g(Ze.$$.fragment,e),ia=i(e),xe=d(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-1f59rwi"&&(xe.innerHTML=Zs),sa=i(e),g(Ge.$$.fragment,e),oa=i(e),We=d(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1f0fulj"&&(We.innerHTML=xs),ra=i(e),$e=d(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-s9qq3q"&&($e.textContent=Gs),la=i(e),g(Be.$$.fragment,e),da=i(e),Ke=d(e,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-15nnunb"&&(Ke.innerHTML=Ws),pa=i(e),Ee=d(e,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-dhsy8d"&&(Ee.textContent=$s),ca=i(e),g(Fe.$$.fragment,e),ma=i(e),Xe=d(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-ovq273"&&(Xe.innerHTML=Bs),ga=i(e),Le=d(e,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-f49a2u"&&(Le.innerHTML=Ks),ua=i(e),g(Re.$$.fragment,e),fa=i(e),qe=d(e,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-s7yhc8"&&(qe.textContent=Es),ha=i(e),g(Ne.$$.fragment,e),ya=i(e),Qe=d(e,"P",{"data-svelte-h":!0}),c(Qe)!=="svelte-44q39d"&&(Qe.textContent=Fs),_a=i(e),g(Ye.$$.fragment,e),ba=i(e),He=d(e,"P",{"data-svelte-h":!0}),c(He)!=="svelte-bn3br3"&&(He.innerHTML=Xs),Ma=i(e),g(Se.$$.fragment,e),ka=i(e),ze=d(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-2xsf0t"&&(ze.innerHTML=Ls),wa=i(e),g(De.$$.fragment,e),Ta=i(e),Ae=d(e,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-jik9w1"&&(Ae.innerHTML=Rs),Ja=i(e),Oe=d(e,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-7c7x3"&&(Oe.textContent=qs),Ia=i(e),en=d(e,"P",{"data-svelte-h":!0}),c(en)!=="svelte-1jvdjgo"&&(en.textContent=Ns),va=i(e),g(nn.$$.fragment,e),Ua=i(e),tn=d(e,"P",{"data-svelte-h":!0}),c(tn)!=="svelte-qrztzv"&&(tn.textContent=Qs),Ca=i(e),an=d(e,"P",{"data-svelte-h":!0}),c(an)!=="svelte-os8doe"&&(an.innerHTML=Ys),ja=i(e),g(sn.$$.fragment,e),Va=i(e),on=d(e,"P",{"data-svelte-h":!0}),c(on)!=="svelte-15b6kfb"&&(on.innerHTML=Hs),Pa=i(e),rn=d(e,"P",{"data-svelte-h":!0}),c(rn)!=="svelte-18p7ues"&&(rn.textContent=Ss),Za=i(e),ln=d(e,"P",{"data-svelte-h":!0}),c(ln)!=="svelte-f2ggu"&&(ln.innerHTML=zs),xa=i(e),g(dn.$$.fragment,e),Ga=i(e),pn=d(e,"P",{"data-svelte-h":!0}),c(pn)!=="svelte-1k82in"&&(pn.innerHTML=Ds),Wa=i(e),cn=d(e,"P",{"data-svelte-h":!0}),c(cn)!=="svelte-mne364"&&(cn.textContent=As),$a=i(e),g(mn.$$.fragment,e),Ba=i(e),gn=d(e,"P",{"data-svelte-h":!0}),c(gn)!=="svelte-uv8kcw"&&(gn.innerHTML=Os),Ka=i(e),g(un.$$.fragment,e),Ea=i(e),fn=d(e,"P",{"data-svelte-h":!0}),c(fn)!=="svelte-8w9xrt"&&(fn.innerHTML=eo),Fa=i(e),g(hn.$$.fragment,e),Xa=i(e),yn=d(e,"P",{"data-svelte-h":!0}),c(yn)!=="svelte-jquec0"&&(yn.innerHTML=no),La=i(e),g(me.$$.fragment,e),Ra=i(e),g(_n.$$.fragment,e),qa=i(e),bn=d(e,"TABLE",{"data-svelte-h":!0}),c(bn)!=="svelte-1v5gzzu"&&(bn.innerHTML=to),Na=i(e),g(Mn.$$.fragment,e),Qa=i(e),G=d(e,"DIV",{class:!0});var F=T(G);g(kn.$$.fragment,F),yi=i(F),tt=d(F,"P",{"data-svelte-h":!0}),c(tt)!=="svelte-jhhofy"&&(tt.textContent=ao),_i=i(F),at=d(F,"P",{"data-svelte-h":!0}),c(at)!=="svelte-wu1jmh"&&(at.innerHTML=io),bi=i(F),N=d(F,"DIV",{class:!0});var re=T(N);g(wn.$$.fragment,re),Mi=i(re),it=d(re,"P",{"data-svelte-h":!0}),c(it)!=="svelte-v78lg8"&&(it.textContent=so),ki=i(re),g(ge.$$.fragment,re),re.forEach(t),F.forEach(t),Ya=i(e),g(Tn.$$.fragment,e),Ha=i(e),W=d(e,"DIV",{class:!0});var X=T(W);g(Jn.$$.fragment,X),wi=i(X),st=d(X,"P",{"data-svelte-h":!0}),c(st)!=="svelte-jhhofy"&&(st.textContent=oo),Ti=i(X),ot=d(X,"P",{"data-svelte-h":!0}),c(ot)!=="svelte-wu1jmh"&&(ot.innerHTML=ro),Ji=i(X),Q=d(X,"DIV",{class:!0});var le=T(Q);g(In.$$.fragment,le),Ii=i(le),rt=d(le,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-v78lg8"&&(rt.textContent=lo),vi=i(le),lt=d(le,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-kvfsh7"&&(lt.textContent=po),le.forEach(t),X.forEach(t),Sa=i(e),g(vn.$$.fragment,e),za=i(e),$=d(e,"DIV",{class:!0});var L=T($);g(Un.$$.fragment,L),Ui=i(L),dt=d(L,"P",{"data-svelte-h":!0}),c(dt)!=="svelte-1nm2rj2"&&(dt.textContent=co),Ci=i(L),pt=d(L,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-wu1jmh"&&(pt.innerHTML=mo),ji=i(L),Y=d(L,"DIV",{class:!0});var de=T(Y);g(Cn.$$.fragment,de),Vi=i(de),ct=d(de,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-v78lg8"&&(ct.textContent=go),Pi=i(de),mt=d(de,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-kvfsh7"&&(mt.textContent=uo),de.forEach(t),L.forEach(t),Da=i(e),g(jn.$$.fragment,e),Aa=i(e),B=d(e,"DIV",{class:!0});var R=T(B);g(Vn.$$.fragment,R),Zi=i(R),gt=d(R,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-1nm2rj2"&&(gt.textContent=fo),xi=i(R),ut=d(R,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-wu1jmh"&&(ut.innerHTML=ho),Gi=i(R),H=d(R,"DIV",{class:!0});var pe=T(H);g(Pn.$$.fragment,pe),Wi=i(pe),ft=d(pe,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-v78lg8"&&(ft.textContent=yo),$i=i(pe),ht=d(pe,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-kvfsh7"&&(ht.textContent=_o),pe.forEach(t),R.forEach(t),Oa=i(e),g(Zn.$$.fragment,e),ei=i(e),K=d(e,"DIV",{class:!0});var q=T(K);g(xn.$$.fragment,q),Bi=i(q),yt=d(q,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-2p9m8a"&&(yt.textContent=bo),Ki=i(q),_t=d(q,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-wu1jmh"&&(_t.innerHTML=Mo),Ei=i(q),S=d(q,"DIV",{class:!0});var Lt=T(S);g(Gn.$$.fragment,Lt),Fi=i(Lt),bt=d(Lt,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-v78lg8"&&(bt.textContent=ko),Xi=i(Lt),Mt=d(Lt,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-kvfsh7"&&(Mt.textContent=wo),Lt.forEach(t),q.forEach(t),ni=i(e),g(Wn.$$.fragment,e),ti=i(e),j=d(e,"DIV",{class:!0});var ae=T(j);g($n.$$.fragment,ae),Li=i(ae),kt=d(ae,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-gfz7tn"&&(kt.textContent=To),Ri=i(ae),wt=d(ae,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-wu1jmh"&&(wt.innerHTML=Jo),qi=i(ae),z=d(ae,"DIV",{class:!0});var Rt=T(z);g(Bn.$$.fragment,Rt),Ni=i(Rt),Tt=d(Rt,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-v78lg8"&&(Tt.textContent=Io),Qi=i(Rt),g(ue.$$.fragment,Rt),Rt.forEach(t),Yi=i(ae),D=d(ae,"DIV",{class:!0});var qt=T(D);g(Kn.$$.fragment,qt),Hi=i(qt),Jt=d(qt,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-1k7d7q8"&&(Jt.textContent=vo),Si=i(qt),g(fe.$$.fragment,qt),qt.forEach(t),ae.forEach(t),ai=i(e),g(En.$$.fragment,e),ii=i(e),V=d(e,"DIV",{class:!0});var ie=T(V);g(Fn.$$.fragment,ie),zi=i(ie),It=d(ie,"P",{"data-svelte-h":!0}),c(It)!=="svelte-gfz7tn"&&(It.textContent=Uo),Di=i(ie),vt=d(ie,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-wu1jmh"&&(vt.innerHTML=Co),Ai=i(ie),A=d(ie,"DIV",{class:!0});var Nt=T(A);g(Xn.$$.fragment,Nt),Oi=i(Nt),Ut=d(Nt,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-v78lg8"&&(Ut.textContent=jo),es=i(Nt),g(he.$$.fragment,Nt),Nt.forEach(t),ns=i(ie),O=d(ie,"DIV",{class:!0});var Qt=T(O);g(Ln.$$.fragment,Qt),ts=i(Qt),Ct=d(Qt,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-1k7d7q8"&&(Ct.textContent=Vo),as=i(Qt),g(ye.$$.fragment,Qt),Qt.forEach(t),ie.forEach(t),si=i(e),g(Rn.$$.fragment,e),oi=i(e),P=d(e,"DIV",{class:!0});var se=T(P);g(qn.$$.fragment,se),is=i(se),jt=d(se,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-1spbql3"&&(jt.textContent=Po),ss=i(se),Vt=d(se,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-wu1jmh"&&(Vt.innerHTML=Zo),os=i(se),ee=d(se,"DIV",{class:!0});var Yt=T(ee);g(Nn.$$.fragment,Yt),rs=i(Yt),Pt=d(Yt,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-v78lg8"&&(Pt.textContent=xo),ls=i(Yt),g(_e.$$.fragment,Yt),Yt.forEach(t),ds=i(se),be=d(se,"DIV",{class:!0});var gi=T(be);g(Qn.$$.fragment,gi),ps=i(gi),Zt=d(gi,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-1ff7ilh"&&(Zt.innerHTML=Go),gi.forEach(t),se.forEach(t),ri=i(e),g(Yn.$$.fragment,e),li=i(e),C=d(e,"DIV",{class:!0});var E=T(C);g(Hn.$$.fragment,E),cs=i(E),xt=d(E,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-1ql3mrb"&&(xt.textContent=Wo),ms=i(E),Gt=d(E,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-wu1jmh"&&(Gt.innerHTML=$o),gs=i(E),ne=d(E,"DIV",{class:!0});var Ht=T(ne);g(Sn.$$.fragment,Ht),us=i(Ht),Wt=d(Ht,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-v78lg8"&&(Wt.textContent=Bo),fs=i(Ht),g(Me.$$.fragment,Ht),Ht.forEach(t),hs=i(E),ke=d(E,"DIV",{class:!0});var ui=T(ke);g(zn.$$.fragment,ui),ys=i(ui),$t=d(ui,"P",{"data-svelte-h":!0}),c($t)!=="svelte-d7vywi"&&($t.innerHTML=Ko),ui.forEach(t),_s=i(E),we=d(E,"DIV",{class:!0});var fi=T(we);g(Dn.$$.fragment,fi),bs=i(fi),Bt=d(fi,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-1ff7ilh"&&(Bt.innerHTML=Eo),fi.forEach(t),E.forEach(t),di=i(e),g(An.$$.fragment,e),pi=i(e),Z=d(e,"DIV",{class:!0});var oe=T(Z);g(On.$$.fragment,oe),Ms=i(oe),Kt=d(oe,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-ydcvxp"&&(Kt.textContent=Fo),ks=i(oe),Et=d(oe,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-wu1jmh"&&(Et.innerHTML=Xo),ws=i(oe),te=d(oe,"DIV",{class:!0});var St=T(te);g(et.$$.fragment,St),Ts=i(St),Ft=d(St,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-v78lg8"&&(Ft.textContent=Lo),Js=i(St),g(Te.$$.fragment,St),St.forEach(t),Is=i(oe),Je=d(oe,"DIV",{class:!0});var hi=T(Je);g(nt.$$.fragment,hi),vs=i(hi),Xt=d(hi,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-1ff7ilh"&&(Xt.innerHTML=Ro),hi.forEach(t),oe.forEach(t),ci=i(e),zt=d(e,"P",{}),T(zt).forEach(t),this.h()},h(){J(p,"name","hf:doc:metadata"),J(p,"content",or),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){r(document.head,p),s(e,w,n),s(e,b,n),s(e,_,n),u(M,e,n),s(e,o,n),s(e,k,n),s(e,Dt,n),s(e,ve,n),s(e,At,n),u(Ue,e,n),s(e,Ot,n),s(e,Ce,n),s(e,ea,n),s(e,je,n),s(e,na,n),u(Ve,e,n),s(e,ta,n),s(e,Pe,n),s(e,aa,n),u(Ze,e,n),s(e,ia,n),s(e,xe,n),s(e,sa,n),u(Ge,e,n),s(e,oa,n),s(e,We,n),s(e,ra,n),s(e,$e,n),s(e,la,n),u(Be,e,n),s(e,da,n),s(e,Ke,n),s(e,pa,n),s(e,Ee,n),s(e,ca,n),u(Fe,e,n),s(e,ma,n),s(e,Xe,n),s(e,ga,n),s(e,Le,n),s(e,ua,n),u(Re,e,n),s(e,fa,n),s(e,qe,n),s(e,ha,n),u(Ne,e,n),s(e,ya,n),s(e,Qe,n),s(e,_a,n),u(Ye,e,n),s(e,ba,n),s(e,He,n),s(e,Ma,n),u(Se,e,n),s(e,ka,n),s(e,ze,n),s(e,wa,n),u(De,e,n),s(e,Ta,n),s(e,Ae,n),s(e,Ja,n),s(e,Oe,n),s(e,Ia,n),s(e,en,n),s(e,va,n),u(nn,e,n),s(e,Ua,n),s(e,tn,n),s(e,Ca,n),s(e,an,n),s(e,ja,n),u(sn,e,n),s(e,Va,n),s(e,on,n),s(e,Pa,n),s(e,rn,n),s(e,Za,n),s(e,ln,n),s(e,xa,n),u(dn,e,n),s(e,Ga,n),s(e,pn,n),s(e,Wa,n),s(e,cn,n),s(e,$a,n),u(mn,e,n),s(e,Ba,n),s(e,gn,n),s(e,Ka,n),u(un,e,n),s(e,Ea,n),s(e,fn,n),s(e,Fa,n),u(hn,e,n),s(e,Xa,n),s(e,yn,n),s(e,La,n),u(me,e,n),s(e,Ra,n),u(_n,e,n),s(e,qa,n),s(e,bn,n),s(e,Na,n),u(Mn,e,n),s(e,Qa,n),s(e,G,n),u(kn,G,null),r(G,yi),r(G,tt),r(G,_i),r(G,at),r(G,bi),r(G,N),u(wn,N,null),r(N,Mi),r(N,it),r(N,ki),u(ge,N,null),s(e,Ya,n),u(Tn,e,n),s(e,Ha,n),s(e,W,n),u(Jn,W,null),r(W,wi),r(W,st),r(W,Ti),r(W,ot),r(W,Ji),r(W,Q),u(In,Q,null),r(Q,Ii),r(Q,rt),r(Q,vi),r(Q,lt),s(e,Sa,n),u(vn,e,n),s(e,za,n),s(e,$,n),u(Un,$,null),r($,Ui),r($,dt),r($,Ci),r($,pt),r($,ji),r($,Y),u(Cn,Y,null),r(Y,Vi),r(Y,ct),r(Y,Pi),r(Y,mt),s(e,Da,n),u(jn,e,n),s(e,Aa,n),s(e,B,n),u(Vn,B,null),r(B,Zi),r(B,gt),r(B,xi),r(B,ut),r(B,Gi),r(B,H),u(Pn,H,null),r(H,Wi),r(H,ft),r(H,$i),r(H,ht),s(e,Oa,n),u(Zn,e,n),s(e,ei,n),s(e,K,n),u(xn,K,null),r(K,Bi),r(K,yt),r(K,Ki),r(K,_t),r(K,Ei),r(K,S),u(Gn,S,null),r(S,Fi),r(S,bt),r(S,Xi),r(S,Mt),s(e,ni,n),u(Wn,e,n),s(e,ti,n),s(e,j,n),u($n,j,null),r(j,Li),r(j,kt),r(j,Ri),r(j,wt),r(j,qi),r(j,z),u(Bn,z,null),r(z,Ni),r(z,Tt),r(z,Qi),u(ue,z,null),r(j,Yi),r(j,D),u(Kn,D,null),r(D,Hi),r(D,Jt),r(D,Si),u(fe,D,null),s(e,ai,n),u(En,e,n),s(e,ii,n),s(e,V,n),u(Fn,V,null),r(V,zi),r(V,It),r(V,Di),r(V,vt),r(V,Ai),r(V,A),u(Xn,A,null),r(A,Oi),r(A,Ut),r(A,es),u(he,A,null),r(V,ns),r(V,O),u(Ln,O,null),r(O,ts),r(O,Ct),r(O,as),u(ye,O,null),s(e,si,n),u(Rn,e,n),s(e,oi,n),s(e,P,n),u(qn,P,null),r(P,is),r(P,jt),r(P,ss),r(P,Vt),r(P,os),r(P,ee),u(Nn,ee,null),r(ee,rs),r(ee,Pt),r(ee,ls),u(_e,ee,null),r(P,ds),r(P,be),u(Qn,be,null),r(be,ps),r(be,Zt),s(e,ri,n),u(Yn,e,n),s(e,li,n),s(e,C,n),u(Hn,C,null),r(C,cs),r(C,xt),r(C,ms),r(C,Gt),r(C,gs),r(C,ne),u(Sn,ne,null),r(ne,us),r(ne,Wt),r(ne,fs),u(Me,ne,null),r(C,hs),r(C,ke),u(zn,ke,null),r(ke,ys),r(ke,$t),r(C,_s),r(C,we),u(Dn,we,null),r(we,bs),r(we,Bt),s(e,di,n),u(An,e,n),s(e,pi,n),s(e,Z,n),u(On,Z,null),r(Z,Ms),r(Z,Kt),r(Z,ks),r(Z,Et),r(Z,ws),r(Z,te),u(et,te,null),r(te,Ts),r(te,Ft),r(te,Js),u(Te,te,null),r(Z,Is),r(Z,Je),u(nt,Je,null),r(Je,vs),r(Je,Xt),s(e,ci,n),s(e,zt,n),mi=!0},p(e,[n]){const F={};n&2&&(F.$$scope={dirty:n,ctx:e}),me.$set(F);const re={};n&2&&(re.$$scope={dirty:n,ctx:e}),ge.$set(re);const X={};n&2&&(X.$$scope={dirty:n,ctx:e}),ue.$set(X);const le={};n&2&&(le.$$scope={dirty:n,ctx:e}),fe.$set(le);const L={};n&2&&(L.$$scope={dirty:n,ctx:e}),he.$set(L);const de={};n&2&&(de.$$scope={dirty:n,ctx:e}),ye.$set(de);const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),_e.$set(R);const pe={};n&2&&(pe.$$scope={dirty:n,ctx:e}),Me.$set(pe);const q={};n&2&&(q.$$scope={dirty:n,ctx:e}),Te.$set(q)},i(e){mi||(f(M.$$.fragment,e),f(Ue.$$.fragment,e),f(Ve.$$.fragment,e),f(Ze.$$.fragment,e),f(Ge.$$.fragment,e),f(Be.$$.fragment,e),f(Fe.$$.fragment,e),f(Re.$$.fragment,e),f(Ne.$$.fragment,e),f(Ye.$$.fragment,e),f(Se.$$.fragment,e),f(De.$$.fragment,e),f(nn.$$.fragment,e),f(sn.$$.fragment,e),f(dn.$$.fragment,e),f(mn.$$.fragment,e),f(un.$$.fragment,e),f(hn.$$.fragment,e),f(me.$$.fragment,e),f(_n.$$.fragment,e),f(Mn.$$.fragment,e),f(kn.$$.fragment,e),f(wn.$$.fragment,e),f(ge.$$.fragment,e),f(Tn.$$.fragment,e),f(Jn.$$.fragment,e),f(In.$$.fragment,e),f(vn.$$.fragment,e),f(Un.$$.fragment,e),f(Cn.$$.fragment,e),f(jn.$$.fragment,e),f(Vn.$$.fragment,e),f(Pn.$$.fragment,e),f(Zn.$$.fragment,e),f(xn.$$.fragment,e),f(Gn.$$.fragment,e),f(Wn.$$.fragment,e),f($n.$$.fragment,e),f(Bn.$$.fragment,e),f(ue.$$.fragment,e),f(Kn.$$.fragment,e),f(fe.$$.fragment,e),f(En.$$.fragment,e),f(Fn.$$.fragment,e),f(Xn.$$.fragment,e),f(he.$$.fragment,e),f(Ln.$$.fragment,e),f(ye.$$.fragment,e),f(Rn.$$.fragment,e),f(qn.$$.fragment,e),f(Nn.$$.fragment,e),f(_e.$$.fragment,e),f(Qn.$$.fragment,e),f(Yn.$$.fragment,e),f(Hn.$$.fragment,e),f(Sn.$$.fragment,e),f(Me.$$.fragment,e),f(zn.$$.fragment,e),f(Dn.$$.fragment,e),f(An.$$.fragment,e),f(On.$$.fragment,e),f(et.$$.fragment,e),f(Te.$$.fragment,e),f(nt.$$.fragment,e),mi=!0)},o(e){h(M.$$.fragment,e),h(Ue.$$.fragment,e),h(Ve.$$.fragment,e),h(Ze.$$.fragment,e),h(Ge.$$.fragment,e),h(Be.$$.fragment,e),h(Fe.$$.fragment,e),h(Re.$$.fragment,e),h(Ne.$$.fragment,e),h(Ye.$$.fragment,e),h(Se.$$.fragment,e),h(De.$$.fragment,e),h(nn.$$.fragment,e),h(sn.$$.fragment,e),h(dn.$$.fragment,e),h(mn.$$.fragment,e),h(un.$$.fragment,e),h(hn.$$.fragment,e),h(me.$$.fragment,e),h(_n.$$.fragment,e),h(Mn.$$.fragment,e),h(kn.$$.fragment,e),h(wn.$$.fragment,e),h(ge.$$.fragment,e),h(Tn.$$.fragment,e),h(Jn.$$.fragment,e),h(In.$$.fragment,e),h(vn.$$.fragment,e),h(Un.$$.fragment,e),h(Cn.$$.fragment,e),h(jn.$$.fragment,e),h(Vn.$$.fragment,e),h(Pn.$$.fragment,e),h(Zn.$$.fragment,e),h(xn.$$.fragment,e),h(Gn.$$.fragment,e),h(Wn.$$.fragment,e),h($n.$$.fragment,e),h(Bn.$$.fragment,e),h(ue.$$.fragment,e),h(Kn.$$.fragment,e),h(fe.$$.fragment,e),h(En.$$.fragment,e),h(Fn.$$.fragment,e),h(Xn.$$.fragment,e),h(he.$$.fragment,e),h(Ln.$$.fragment,e),h(ye.$$.fragment,e),h(Rn.$$.fragment,e),h(qn.$$.fragment,e),h(Nn.$$.fragment,e),h(_e.$$.fragment,e),h(Qn.$$.fragment,e),h(Yn.$$.fragment,e),h(Hn.$$.fragment,e),h(Sn.$$.fragment,e),h(Me.$$.fragment,e),h(zn.$$.fragment,e),h(Dn.$$.fragment,e),h(An.$$.fragment,e),h(On.$$.fragment,e),h(et.$$.fragment,e),h(Te.$$.fragment,e),h(nt.$$.fragment,e),mi=!1},d(e){e&&(t(w),t(b),t(_),t(o),t(k),t(Dt),t(ve),t(At),t(Ot),t(Ce),t(ea),t(je),t(na),t(ta),t(Pe),t(aa),t(ia),t(xe),t(sa),t(oa),t(We),t(ra),t($e),t(la),t(da),t(Ke),t(pa),t(Ee),t(ca),t(ma),t(Xe),t(ga),t(Le),t(ua),t(fa),t(qe),t(ha),t(ya),t(Qe),t(_a),t(ba),t(He),t(Ma),t(ka),t(ze),t(wa),t(Ta),t(Ae),t(Ja),t(Oe),t(Ia),t(en),t(va),t(Ua),t(tn),t(Ca),t(an),t(ja),t(Va),t(on),t(Pa),t(rn),t(Za),t(ln),t(xa),t(Ga),t(pn),t(Wa),t(cn),t($a),t(Ba),t(gn),t(Ka),t(Ea),t(fn),t(Fa),t(Xa),t(yn),t(La),t(Ra),t(qa),t(bn),t(Na),t(Qa),t(G),t(Ya),t(Ha),t(W),t(Sa),t(za),t($),t(Da),t(Aa),t(B),t(Oa),t(ei),t(K),t(ni),t(ti),t(j),t(ai),t(ii),t(V),t(si),t(oi),t(P),t(ri),t(li),t(C),t(di),t(pi),t(Z),t(ci),t(zt)),t(p),y(M,e),y(Ue,e),y(Ve,e),y(Ze,e),y(Ge,e),y(Be,e),y(Fe,e),y(Re,e),y(Ne,e),y(Ye,e),y(Se,e),y(De,e),y(nn,e),y(sn,e),y(dn,e),y(mn,e),y(un,e),y(hn,e),y(me,e),y(_n,e),y(Mn,e),y(kn),y(wn),y(ge),y(Tn,e),y(Jn),y(In),y(vn,e),y(Un),y(Cn),y(jn,e),y(Vn),y(Pn),y(Zn,e),y(xn),y(Gn),y(Wn,e),y($n),y(Bn),y(ue),y(Kn),y(fe),y(En,e),y(Fn),y(Xn),y(he),y(Ln),y(ye),y(Rn,e),y(qn),y(Nn),y(_e),y(Qn),y(Yn,e),y(Hn),y(Sn),y(Me),y(zn),y(Dn),y(An,e),y(On),y(et),y(Te),y(nt)}}}const or='{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[{"title":"Text-to-Image Generation with ControlNet Conditioning","local":"text-to-image-generation-with-controlnet-conditioning","sections":[],"depth":3},{"title":"Image-to-Image Generation with ControlNet Conditioning","local":"image-to-image-generation-with-controlnet-conditioning","sections":[],"depth":3},{"title":"Optimization","local":"optimization","sections":[],"depth":2},{"title":"Available Pipelines:","local":"available-pipelines","sections":[{"title":"KandinskyV22Pipeline","local":"diffusers.KandinskyV22Pipeline","sections":[],"depth":3},{"title":"KandinskyV22ControlnetPipeline","local":"diffusers.KandinskyV22ControlnetPipeline","sections":[],"depth":3},{"title":"KandinskyV22ControlnetImg2ImgPipeline","local":"diffusers.KandinskyV22ControlnetImg2ImgPipeline","sections":[],"depth":3},{"title":"KandinskyV22Img2ImgPipeline","local":"diffusers.KandinskyV22Img2ImgPipeline","sections":[],"depth":3},{"title":"KandinskyV22InpaintPipeline","local":"diffusers.KandinskyV22InpaintPipeline","sections":[],"depth":3},{"title":"KandinskyV22PriorPipeline","local":"diffusers.KandinskyV22PriorPipeline","sections":[],"depth":3},{"title":"KandinskyV22PriorEmb2EmbPipeline","local":"diffusers.KandinskyV22PriorEmb2EmbPipeline","sections":[],"depth":3},{"title":"KandinskyV22CombinedPipeline","local":"diffusers.KandinskyV22CombinedPipeline","sections":[],"depth":3},{"title":"KandinskyV22Img2ImgCombinedPipeline","local":"diffusers.KandinskyV22Img2ImgCombinedPipeline","sections":[],"depth":3},{"title":"KandinskyV22InpaintCombinedPipeline","local":"diffusers.KandinskyV22InpaintCombinedPipeline","sections":[],"depth":3}],"depth":2}],"depth":1}';function rr(U){return No(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fr extends Qo{constructor(p){super(),Yo(this,p,rr,sr,qo,{})}}export{fr as component};
