import{s as Cn,o as Bn,n as kt}from"../chunks/scheduler.8c3d61f6.js";import{S as Wn,i as Rn,g as r,s as o,r as c,A as Nn,h as d,f as n,c as s,j as I,u as m,x as _,k as j,y as a,a as i,v as g,d as h,t as u,w as f}from"../chunks/index.da70eac4.js";import{T as $n}from"../chunks/Tip.1d9b8c37.js";import{D as G}from"../chunks/Docstring.6b390b9a.js";import{C as Q}from"../chunks/CodeBlock.00a903b3.js";import{E as an}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as Ge,E as Pn}from"../chunks/EditOnGithub.1e64e623.js";function zn(k){let p,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){p=r("p"),p.innerHTML=J},l(T){p=d(T,"P",{"data-svelte-h":!0}),_(p)!=="svelte-1qn15hi"&&(p.innerHTML=J)},m(T,y){i(T,p,y)},p:kt,d(T){T&&n(p)}}}function Hn(k){let p,J="Examples:",T,y,M;return y=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMExUWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJMaWdodHJpY2tzJTJGTFRYLVZpZGVvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHdvbWFuJTIwd2l0aCUyMGxvbmclMjBicm93biUyMGhhaXIlMjBhbmQlMjBsaWdodCUyMHNraW4lMjBzbWlsZXMlMjBhdCUyMGFub3RoZXIlMjB3b21hbiUyMHdpdGglMjBsb25nJTIwYmxvbmRlJTIwaGFpci4lMjBUaGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIlMjB3ZWFycyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMGhhcyUyMGElMjBzbWFsbCUyQyUyMGJhcmVseSUyMG5vdGljZWFibGUlMjBtb2xlJTIwb24lMjBoZXIlMjByaWdodCUyMGNoZWVrLiUyMFRoZSUyMGNhbWVyYSUyMGFuZ2xlJTIwaXMlMjBhJTIwY2xvc2UtdXAlMkMlMjBmb2N1c2VkJTIwb24lMjB0aGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIncyUyMGZhY2UuJTIwVGhlJTIwbGlnaHRpbmclMjBpcyUyMHdhcm0lMjBhbmQlMjBuYXR1cmFsJTJDJTIwbGlrZWx5JTIwZnJvbSUyMHRoZSUyMHNldHRpbmclMjBzdW4lMkMlMjBjYXN0aW5nJTIwYSUyMHNvZnQlMjBnbG93JTIwb24lMjB0aGUlMjBzY2VuZS4lMjBUaGUlMjBzY2VuZSUyMGFwcGVhcnMlMjB0byUyMGJlJTIwcmVhbC1saWZlJTIwZm9vdGFnZSUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMndvcnN0JTIwcXVhbGl0eSUyQyUyMGluY29uc2lzdGVudCUyMG1vdGlvbiUyQyUyMGJsdXJyeSUyQyUyMGppdHRlcnklMkMlMjBkaXN0b3J0ZWQlMjIlMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3MDQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYxJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDI0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LTXPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A woman with long brown hair and light skin smiles at another woman with long blonde hair. The woman with brown hair wears a black jacket and has a small, barely noticeable mole on her right cheek. The camera angle is a close-up, focused on the woman with brown hair&#x27;s face. The lighting is warm and natural, likely from the setting sun, casting a soft glow on the scene. The scene appears to be real-life footage&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">704</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">161</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),{c(){p=r("p"),p.textContent=J,T=o(),c(y.$$.fragment)},l(l){p=d(l,"P",{"data-svelte-h":!0}),_(p)!=="svelte-kvfsh7"&&(p.textContent=J),T=s(l),m(y.$$.fragment,l)},m(l,b){i(l,p,b),i(l,T,b),g(y,l,b),M=!0},p:kt,i(l){M||(h(y.$$.fragment,l),M=!0)},o(l){u(y.$$.fragment,l),M=!1},d(l){l&&(n(p),n(T)),f(y,l)}}}function Fn(k){let p,J="Examples:",T,y,M;return y=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBMVFhJbWFnZVRvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyTGlnaHRyaWNrcyUyRkxUWC1WaWRlbyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZhLXItci1vLXclMkZ0aW55LW1lbWUtZGF0YXNldC1jYXB0aW9uZWQlMkZyZXNvbHZlJTJGbWFpbiUyRmltYWdlcyUyRjgucG5nJTIyJTBBKSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjB5b3VuZyUyMGdpcmwlMjBzdGFuZHMlMjBjYWxtbHklMjBpbiUyMHRoZSUyMGZvcmVncm91bmQlMkMlMjBsb29raW5nJTIwZGlyZWN0bHklMjBhdCUyMHRoZSUyMGNhbWVyYSUyQyUyMGFzJTIwYSUyMGhvdXNlJTIwZmlyZSUyMHJhZ2VzJTIwaW4lMjB0aGUlMjBiYWNrZ3JvdW5kLiUyMEZsYW1lcyUyMGVuZ3VsZiUyMHRoZSUyMHN0cnVjdHVyZSUyQyUyMHdpdGglMjBzbW9rZSUyMGJpbGxvd2luZyUyMGludG8lMjB0aGUlMjBhaXIuJTIwRmlyZWZpZ2h0ZXJzJTIwaW4lMjBwcm90ZWN0aXZlJTIwZ2VhciUyMHJ1c2glMjB0byUyMHRoZSUyMHNjZW5lJTJDJTIwYSUyMGZpcmUlMjB0cnVjayUyMGxhYmVsZWQlMjAnMzgnJTIwdmlzaWJsZSUyMGJlaGluZCUyMHRoZW0uJTIwVGhlJTIwZ2lybCdzJTIwbmV1dHJhbCUyMGV4cHJlc3Npb24lMjBjb250cmFzdHMlMjBzaGFycGx5JTIwd2l0aCUyMHRoZSUyMGNoYW9zJTIwb2YlMjB0aGUlMjBmaXJlJTJDJTIwY3JlYXRpbmclMjBhJTIwcG9pZ25hbnQlMjBhbmQlMjBlbW90aW9uYWxseSUyMGNoYXJnZWQlMjBzY2VuZS4lMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJ3b3JzdCUyMHF1YWxpdHklMkMlMjBpbmNvbnNpc3RlbnQlMjBtb3Rpb24lMkMlMjBibHVycnklMkMlMjBqaXR0ZXJ5JTJDJTIwZGlzdG9ydGVkJTIyJTBBJTBBdmlkZW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDcwNCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDQ4MCUyQyUwQSUyMCUyMCUyMCUyMG51bV9mcmFtZXMlM0QxNjElMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEMjQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXImageToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LTXImageToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/a-r-r-o-w/tiny-meme-dataset-captioned/resolve/main/images/8.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A young girl stands calmly in the foreground, looking directly at the camera, as a house fire rages in the background. Flames engulf the structure, with smoke billowing into the air. Firefighters in protective gear rush to the scene, a fire truck labeled &#x27;38&#x27; visible behind them. The girl&#x27;s neutral expression contrasts sharply with the chaos of the fire, creating a poignant and emotionally charged scene.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">704</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">161</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),{c(){p=r("p"),p.textContent=J,T=o(),c(y.$$.fragment)},l(l){p=d(l,"P",{"data-svelte-h":!0}),_(p)!=="svelte-kvfsh7"&&(p.textContent=J),T=s(l),m(y.$$.fragment,l)},m(l,b){i(l,p,b),i(l,T,b),g(y,l,b),M=!0},p:kt,i(l){M||(h(y.$$.fragment,l),M=!0)},o(l){u(y.$$.fragment,l),M=!1},d(l){l&&(n(p),n(T)),f(y,l)}}}function En(k){let p,J="Examples:",T,y,M;return y=new Q({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.pipelines.ltx.pipeline_ltx_condition <span class="hljs-keyword">import</span> LTXConditionPipeline, LTXVideoCondition
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LTXConditionPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video-0.9.5&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load input image and video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cosmos/cosmos-video2world-input-vid.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cosmos/cosmos-video2world-input.jpg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create conditioning objects</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>condition1 = LTXVideoCondition(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    frame_index=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>condition2 = LTXVideoCondition(
<span class="hljs-meta">... </span>    video=video,
<span class="hljs-meta">... </span>    frame_index=<span class="hljs-number">80</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The video depicts a long, straight highway stretching into the distance, flanked by metal guardrails. The road is divided into multiple lanes, with a few vehicles visible in the far distance. The surrounding landscape features dry, grassy fields on one side and rolling hills on the other. The sky is mostly clear with a few scattered clouds, suggesting a bright, sunny day. And then the camera switch to a winding mountain road covered in snow, with a single vehicle traveling along it. The road is flanked by steep, rocky cliffs and sparse vegetation. The landscape is characterized by rugged terrain and a river visible in the distance. The scene captures the solitude and beauty of a winter drive through a mountainous region.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    conditions=[condition1, condition2],
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">161</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">40</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),{c(){p=r("p"),p.textContent=J,T=o(),c(y.$$.fragment)},l(l){p=d(l,"P",{"data-svelte-h":!0}),_(p)!=="svelte-kvfsh7"&&(p.textContent=J),T=s(l),m(y.$$.fragment,l)},m(l,b){i(l,p,b),i(l,T,b),g(y,l,b),M=!0},p:kt,i(l){M||(h(y.$$.fragment,l),M=!0)},o(l){u(y.$$.fragment,l),M=!1},d(l){l&&(n(p),n(T)),f(y,l)}}}function Yn(k){let p,J,T,y,M,l,b,ln='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',Ae,S,rn='<a href="https://huggingface.co/Lightricks/LTX-Video" rel="nofollow">LTX Video</a> is the first DiT-based video generation model capable of generating high-quality videos in real-time. It produces 24 FPS videos at a 768x512 resolution faster than they can be watched. Trained on a large-scale dataset of diverse videos, the model generates high-resolution videos with realistic and varied content. We provide a model for both text-to-video as well as image + text-to-video usecases.',De,R,Oe,q,dn="Available models:",Ke,A,pn='<thead><tr><th align="center">Model name</th> <th align="center">Recommended dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltx-video-2b-v0.9.safetensors" rel="nofollow"><code>LTX Video 0.9.0</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltx-video-2b-v0.9.1.safetensors" rel="nofollow"><code>LTX Video 0.9.1</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr></tbody>',et,D,cn="Note: The recommended dtype is for the transformer component. The VAE and text encoders can be either <code>torch.float32</code>, <code>torch.bfloat16</code> or <code>torch.float16</code> but the recommended dtype is <code>torch.bfloat16</code> as used in the original repository.",tt,O,nt,K,mn="Loading the original LTX Video checkpoints is also possible with <code>~ModelMixin.from_single_file</code>. We recommend using <code>from_single_file</code> for the Lightricks series of models, as they plan to release multiple models in the future in the single file format.",ot,ee,st,te,gn="Alternatively, the pipeline can be used to load the weights with <code>~FromSingleFileMixin.from_single_file</code>.",it,ne,at,oe,hn='Loading <a href="https://huggingface.co/city96/LTX-Video-gguf" rel="nofollow">LTX GGUF checkpoints</a> are also supported:',lt,se,rt,ie,un='Make sure to read the <a href="../../quantization/gguf">documentation on GGUF</a> to learn more about our GGUF support.',dt,ae,fn='Loading and running inference with <a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltx-video-2b-v0.9.1.safetensors" rel="nofollow">LTX Video 0.9.1</a> weights.',pt,le,ct,re,_n='Refer to <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/cogvideox#memory-optimization" rel="nofollow">this section</a> to learn more about optimizing memory consumption.',mt,de,gt,pe,yn="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",ht,ce,Tn='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/ltx_video#diffusers.LTXPipeline">LTXPipeline</a> for inference with bitsandbytes.',ut,me,ft,ge,_t,v,he,Lt,ke,Mn="Pipeline for text-to-video generation.",Vt,Le,bn='Reference: <a href="https://github.com/Lightricks/LTX-Video" rel="nofollow">https://github.com/Lightricks/LTX-Video</a>',Ct,L,ue,Bt,Ve,wn="Function invoked when calling the pipeline for generation.",Wt,N,Rt,$,fe,Nt,Ce,Jn="Encodes the prompt into text encoder hidden states.",yt,_e,Tt,U,ye,$t,Be,vn="Pipeline for image-to-video generation.",Pt,We,Un='Reference: <a href="https://github.com/Lightricks/LTX-Video" rel="nofollow">https://github.com/Lightricks/LTX-Video</a>',zt,V,Te,Ht,Re,jn="Function invoked when calling the pipeline for generation.",Ft,P,Et,z,Me,Yt,Ne,Zn="Encodes the prompt into text encoder hidden states.",Mt,be,bt,w,we,Qt,$e,In="Pipeline for image-to-video generation.",St,Pe,Xn='Reference: <a href="https://github.com/Lightricks/LTX-Video" rel="nofollow">https://github.com/Lightricks/LTX-Video</a>',qt,C,Je,At,ze,xn="Function invoked when calling the pipeline for generation.",Dt,H,Ot,F,ve,Kt,He,Gn=`Add timestep-dependent noise to the hard-conditioning latents. This helps with motion continuity, especially
when conditioned on a single frame.`,en,E,Ue,tn,Fe,kn="Encodes the prompt into text encoder hidden states.",nn,Y,je,on,Ee,Ln="Trim a conditioning sequence to the allowed number of frames.",wt,Ze,Jt,B,Ie,sn,Ye,Vn="Output class for LTX pipelines.",vt,Xe,Ut,qe,jt;return M=new Ge({props:{title:"LTX Video",local:"ltx-video",headingTag:"h1"}}),R=new $n({props:{$$slots:{default:[zn]},$$scope:{ctx:k}}}),O=new Ge({props:{title:"Loading Single Files",local:"loading-single-files",headingTag:"h2"}}),ee=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTExUWFZpZGVvJTJDJTIwTFRYSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMkMlMjBMVFhWaWRlb1RyYW5zZm9ybWVyM0RNb2RlbCUwQSUwQSUyMyUyMCU2MHNpbmdsZV9maWxlX3VybCU2MCUyMGNvdWxkJTIwYWxzbyUyMGJlJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRkxpZ2h0cmlja3MlMkZMVFgtVmlkZW8lMkZsdHgtdmlkZW8tMmItdjAuOS4xLnNhZmV0ZW5zb3JzJTBBc2luZ2xlX2ZpbGVfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRkxpZ2h0cmlja3MlMkZMVFgtVmlkZW8lMkZsdHgtdmlkZW8tMmItdjAuOS5zYWZldGVuc29ycyUyMiUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwTFRYVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjBzaW5nbGVfZmlsZV91cmwlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0xMVFhWaWRlby5mcm9tX3NpbmdsZV9maWxlKHNpbmdsZV9maWxlX3VybCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMExUWEltYWdlVG9WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJMaWdodHJpY2tzJTJGTFRYLVZpZGVvJTIyJTJDJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lciUyQyUyMHZhZSUzRHZhZSUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBJTBBJTIzJTIwLi4uJTIwaW5mZXJlbmNlJTIwY29kZSUyMC4uLg==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLLTXVideo, LTXImageToVideoPipeline, LTXVideoTransformer3DModel

<span class="hljs-comment"># \`single_file_url\` could also be https://huggingface.co/Lightricks/LTX-Video/ltx-video-2b-v0.9.1.safetensors</span>
single_file_url = <span class="hljs-string">&quot;https://huggingface.co/Lightricks/LTX-Video/ltx-video-2b-v0.9.safetensors&quot;</span>
transformer = LTXVideoTransformer3DModel.from_single_file(
  single_file_url, torch_dtype=torch.bfloat16
)
vae = AutoencoderKLLTXVideo.from_single_file(single_file_url, torch_dtype=torch.bfloat16)
pipe = LTXImageToVideoPipeline.from_pretrained(
  <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, transformer=transformer, vae=vae, torch_dtype=torch.bfloat16
)

<span class="hljs-comment"># ... inference code ...</span>`,wrap:!1}}),ne=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMkMlMjBUNVRva2VuaXplciUwQSUwQXNpbmdsZV9maWxlX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZMaWdodHJpY2tzJTJGTFRYLVZpZGVvJTJGbHR4LXZpZGVvLTJiLXYwLjkuc2FmZXRlbnNvcnMlMjIlMEF0ZXh0X2VuY29kZXIlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyTGlnaHRyaWNrcyUyRkxUWC1WaWRlbyUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMkxpZ2h0cmlja3MlMkZMVFgtVmlkZW8lMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBMVFhJbWFnZVRvVmlkZW9QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMHNpbmdsZV9maWxlX3VybCUyQyUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXImageToVideoPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, T5Tokenizer

single_file_url = <span class="hljs-string">&quot;https://huggingface.co/Lightricks/LTX-Video/ltx-video-2b-v0.9.safetensors&quot;</span>
text_encoder = T5EncoderModel.from_pretrained(
  <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, torch_dtype=torch.bfloat16
)
tokenizer = T5Tokenizer.from_pretrained(
  <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>, torch_dtype=torch.bfloat16
)
pipe = LTXImageToVideoPipeline.from_single_file(
  single_file_url, text_encoder=text_encoder, tokenizer=tokenizer, torch_dtype=torch.bfloat16
)`,wrap:!1}}),se=new Q({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXPipeline, LTXVideoTransformer3DModel, GGUFQuantizationConfig

ckpt_path = (
    <span class="hljs-string">&quot;https://huggingface.co/city96/LTX-Video-gguf/blob/main/ltx-video-2b-v0.9-Q3_K_S.gguf&quot;</span>
)
transformer = LTXVideoTransformer3DModel.from_single_file(
    ckpt_path,
    quantization_config=GGUFQuantizationConfig(compute_dtype=torch.bfloat16),
    torch_dtype=torch.bfloat16,
)
pipe = LTXPipeline.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16,
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A woman with long brown hair and light skin smiles at another woman with long blonde hair. The woman with brown hair wears a black jacket and has a small, barely noticeable mole on her right cheek. The camera angle is a close-up, focused on the woman with brown hair&#x27;s face. The lighting is warm and natural, likely from the setting sun, casting a soft glow on the scene. The scene appears to be real-life footage&quot;</span>
negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

video = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=<span class="hljs-number">704</span>,
    height=<span class="hljs-number">480</span>,
    num_frames=<span class="hljs-number">161</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output_gguf_ltx.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),le=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMExUWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJhLXItci1vLXclMkZMVFgtVmlkZW8tMC45LjEtZGlmZnVzZXJzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHdvbWFuJTIwd2l0aCUyMGxvbmclMjBicm93biUyMGhhaXIlMjBhbmQlMjBsaWdodCUyMHNraW4lMjBzbWlsZXMlMjBhdCUyMGFub3RoZXIlMjB3b21hbiUyMHdpdGglMjBsb25nJTIwYmxvbmRlJTIwaGFpci4lMjBUaGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIlMjB3ZWFycyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMGhhcyUyMGElMjBzbWFsbCUyQyUyMGJhcmVseSUyMG5vdGljZWFibGUlMjBtb2xlJTIwb24lMjBoZXIlMjByaWdodCUyMGNoZWVrLiUyMFRoZSUyMGNhbWVyYSUyMGFuZ2xlJTIwaXMlMjBhJTIwY2xvc2UtdXAlMkMlMjBmb2N1c2VkJTIwb24lMjB0aGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIncyUyMGZhY2UuJTIwVGhlJTIwbGlnaHRpbmclMjBpcyUyMHdhcm0lMjBhbmQlMjBuYXR1cmFsJTJDJTIwbGlrZWx5JTIwZnJvbSUyMHRoZSUyMHNldHRpbmclMjBzdW4lMkMlMjBjYXN0aW5nJTIwYSUyMHNvZnQlMjBnbG93JTIwb24lMjB0aGUlMjBzY2VuZS4lMjBUaGUlMjBzY2VuZSUyMGFwcGVhcnMlMjB0byUyMGJlJTIwcmVhbC1saWZlJTIwZm9vdGFnZSUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMndvcnN0JTIwcXVhbGl0eSUyQyUyMGluY29uc2lzdGVudCUyMG1vdGlvbiUyQyUyMGJsdXJyeSUyQyUyMGppdHRlcnklMkMlMjBkaXN0b3J0ZWQlMjIlMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYxJTJDJTBBJTIwJTIwJTIwJTIwZGVjb2RlX3RpbWVzdGVwJTNEMC4wMyUyQyUwQSUyMCUyMCUyMCUyMGRlY29kZV9ub2lzZV9zY2FsZSUzRDAuMDI1JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDI0KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = LTXPipeline.from_pretrained(<span class="hljs-string">&quot;a-r-r-o-w/LTX-Video-0.9.1-diffusers&quot;</span>, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A woman with long brown hair and light skin smiles at another woman with long blonde hair. The woman with brown hair wears a black jacket and has a small, barely noticeable mole on her right cheek. The camera angle is a close-up, focused on the woman with brown hair&#x27;s face. The lighting is warm and natural, likely from the setting sun, casting a soft glow on the scene. The scene appears to be real-life footage&quot;</span>
negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

video = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=<span class="hljs-number">768</span>,
    height=<span class="hljs-number">512</span>,
    num_frames=<span class="hljs-number">161</span>,
    decode_timestep=<span class="hljs-number">0.03</span>,
    decode_noise_scale=<span class="hljs-number">0.025</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),de=new Ge({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),me=new Q({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, LTXVideoTransformer3DModel, LTXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, T5EncoderModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = LTXVideoTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = LTXPipeline.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;A detailed wooden toy ship with intricately carved masts and sails is seen gliding smoothly over a plush, blue carpet that mimics the waves of the sea. The ship&#x27;s hull is painted a rich brown, with tiny windows. The carpet, soft and textured, provides a perfect backdrop, resembling an oceanic expanse. Surrounding the ship are various other toys and children&#x27;s items, hinting at a playful environment. The scene captures the innocence and imagination of childhood, with the toy ship&#x27;s journey symbolizing endless adventures in a whimsical, indoor setting.&quot;</span>
video = pipeline(prompt=prompt, num_frames=<span class="hljs-number">161</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;ship.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),ge=new Ge({props:{title:"LTXPipeline",local:"diffusers.LTXPipeline",headingTag:"h2"}}),he=new G({props:{name:"class diffusers.LTXPipeline",anchor:"diffusers.LTXPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLLTXVideo"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": LTXVideoTransformer3DModel"}],parametersDescription:[{anchor:"diffusers.LTXPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/ltx_video_transformer3d#diffusers.LTXVideoTransformer3DModel">LTXVideoTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.LTXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.LTXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_ltx_video#diffusers.AutoencoderKLLTXVideo">AutoencoderKLLTXVideo</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LTXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LTXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LTXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx.py#L143"}}),ue=new G({props:{name:"__call__",anchor:"diffusers.LTXPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 704"},{name:"num_frames",val:": int = 161"},{name:"frame_rate",val:": int = 25"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 3"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decode_timestep",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"decode_noise_scale",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 128"}],parametersDescription:[{anchor:"diffusers.LTXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.LTXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>512</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.LTXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>704</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.LTXPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>161</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.LTXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.LTXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.LTXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>3 </code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.LTXPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LTXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.LTXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.LTXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.LTXPipeline.__call__.decode_timestep",description:`<strong>decode_timestep</strong> (<code>float</code>, defaults to <code>0.0</code>) &#x2014;
The timestep at which generated video is decoded.`,name:"decode_timestep"},{anchor:"diffusers.LTXPipeline.__call__.decode_noise_scale",description:`<strong>decode_noise_scale</strong> (<code>float</code>, defaults to <code>None</code>) &#x2014;
The interpolation factor between random noise and denoised latents at the decode timestep.`,name:"decode_noise_scale"},{anchor:"diffusers.LTXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LTXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.ltx.LTXPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LTXPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.LTXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LTXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.LTXPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>128 </code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx.py#L500",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.ltx.LTXPipelineOutput</code> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.ltx.LTXPipelineOutput</code> or <code>tuple</code></p>
`}}),N=new an({props:{anchor:"diffusers.LTXPipeline.__call__.example",$$slots:{default:[Hn]},$$scope:{ctx:k}}}),fe=new G({props:{name:"encode_prompt",anchor:"diffusers.LTXPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 128"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.LTXPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.LTXPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LTXPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.LTXPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.LTXPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx.py#L256"}}),_e=new Ge({props:{title:"LTXImageToVideoPipeline",local:"diffusers.LTXImageToVideoPipeline",headingTag:"h2"}}),ye=new G({props:{name:"class diffusers.LTXImageToVideoPipeline",anchor:"diffusers.LTXImageToVideoPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLLTXVideo"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": LTXVideoTransformer3DModel"}],parametersDescription:[{anchor:"diffusers.LTXImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/ltx_video_transformer3d#diffusers.LTXVideoTransformer3DModel">LTXVideoTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.LTXImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.LTXImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_ltx_video#diffusers.AutoencoderKLLTXVideo">AutoencoderKLLTXVideo</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LTXImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LTXImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LTXImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_image2video.py#L162"}}),Te=new G({props:{name:"__call__",anchor:"diffusers.LTXImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 704"},{name:"num_frames",val:": int = 161"},{name:"frame_rate",val:": int = 25"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 3"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decode_timestep",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"decode_noise_scale",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 128"}],parametersDescription:[{anchor:"diffusers.LTXImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>512</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>704</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>161</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>3 </code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.decode_timestep",description:`<strong>decode_timestep</strong> (<code>float</code>, defaults to <code>0.0</code>) &#x2014;
The timestep at which generated video is decoded.`,name:"decode_timestep"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.decode_noise_scale",description:`<strong>decode_noise_scale</strong> (<code>float</code>, defaults to <code>None</code>) &#x2014;
The interpolation factor between random noise and denoised latents at the decode timestep.`,name:"decode_noise_scale"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.ltx.LTXPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>128 </code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_image2video.py#L559",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.ltx.LTXPipelineOutput</code> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.ltx.LTXPipelineOutput</code> or <code>tuple</code></p>
`}}),P=new an({props:{anchor:"diffusers.LTXImageToVideoPipeline.__call__.example",$$slots:{default:[Fn]},$$scope:{ctx:k}}}),Me=new G({props:{name:"encode_prompt",anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 128"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_image2video.py#L279"}}),be=new Ge({props:{title:"LTXConditionPipeline",local:"diffusers.LTXConditionPipeline",headingTag:"h2"}}),we=new G({props:{name:"class diffusers.LTXConditionPipeline",anchor:"diffusers.LTXConditionPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLLTXVideo"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": LTXVideoTransformer3DModel"}],parametersDescription:[{anchor:"diffusers.LTXConditionPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/ltx_video_transformer3d#diffusers.LTXVideoTransformer3DModel">LTXVideoTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.LTXConditionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.LTXConditionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_ltx_video#diffusers.AutoencoderKLLTXVideo">AutoencoderKLLTXVideo</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LTXConditionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LTXConditionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LTXConditionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_condition.py#L224"}}),Je=new G({props:{name:"__call__",anchor:"diffusers.LTXConditionPipeline.__call__",parameters:[{name:"conditions",val:": typing.Union[diffusers.pipelines.ltx.pipeline_ltx_condition.LTXVideoCondition, typing.List[diffusers.pipelines.ltx.pipeline_ltx_condition.LTXVideoCondition]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], typing.List[typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]]] = None"},{name:"video",val:": typing.List[typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]] = None"},{name:"frame_index",val:": typing.Union[int, typing.List[int]] = 0"},{name:"strength",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 704"},{name:"num_frames",val:": int = 161"},{name:"frame_rate",val:": int = 25"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 3"},{name:"image_cond_noise_scale",val:": float = 0.15"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decode_timestep",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"decode_noise_scale",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.LTXConditionPipeline.__call__.conditions",description:`<strong>conditions</strong> (<code>List[LTXVideoCondition], *optional*</code>) &#x2014;
The list of frame-conditioning items for the video generation.If not provided, conditions will be
created using <code>image</code>, <code>video</code>, <code>frame_index</code> and <code>strength</code>.`,name:"conditions"},{anchor:"diffusers.LTXConditionPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code> or <code>List[PipelineImageInput]</code>, <em>optional</em>) &#x2014;
The image or images to condition the video generation. If not provided, one has to pass <code>video</code> or
<code>conditions</code>.`,name:"image"},{anchor:"diffusers.LTXConditionPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PipelineImageInput]</code>, <em>optional</em>) &#x2014;
The video to condition the video generation. If not provided, one has to pass <code>image</code> or <code>conditions</code>.`,name:"video"},{anchor:"diffusers.LTXConditionPipeline.__call__.frame_index",description:`<strong>frame_index</strong> (<code>int</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
The frame index or frame indices at which the image or video will conditionally effect the video
generation. If not provided, one has to pass <code>conditions</code>.`,name:"frame_index"},{anchor:"diffusers.LTXConditionPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>) &#x2014;
The strength or strengths of the conditioning effect. If not provided, one has to pass <code>conditions</code>.`,name:"strength"},{anchor:"diffusers.LTXConditionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.LTXConditionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>512</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.LTXConditionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>704</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.LTXConditionPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>161</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.LTXConditionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.LTXConditionPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.LTXConditionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>3 </code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.LTXConditionPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXConditionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LTXConditionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.LTXConditionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXConditionPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.LTXConditionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXConditionPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.LTXConditionPipeline.__call__.decode_timestep",description:`<strong>decode_timestep</strong> (<code>float</code>, defaults to <code>0.0</code>) &#x2014;
The timestep at which generated video is decoded.`,name:"decode_timestep"},{anchor:"diffusers.LTXConditionPipeline.__call__.decode_noise_scale",description:`<strong>decode_noise_scale</strong> (<code>float</code>, defaults to <code>None</code>) &#x2014;
The interpolation factor between random noise and denoised latents at the decode timestep.`,name:"decode_noise_scale"},{anchor:"diffusers.LTXConditionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LTXConditionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.ltx.LTXPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LTXConditionPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.LTXConditionPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LTXConditionPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.LTXConditionPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>128 </code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_condition.py#L785",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.ltx.LTXPipelineOutput</code> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.ltx.LTXPipelineOutput</code> or <code>tuple</code></p>
`}}),H=new an({props:{anchor:"diffusers.LTXConditionPipeline.__call__.example",$$slots:{default:[En]},$$scope:{ctx:k}}}),ve=new G({props:{name:"add_noise_to_image_conditioning_latents",anchor:"diffusers.LTXConditionPipeline.add_noise_to_image_conditioning_latents",parameters:[{name:"t",val:": float"},{name:"init_latents",val:": Tensor"},{name:"latents",val:": Tensor"},{name:"noise_scale",val:": float"},{name:"conditioning_mask",val:": Tensor"},{name:"generator",val:""},{name:"eps",val:" = 1e-06"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_condition.py#L617"}}),Ue=new G({props:{name:"encode_prompt",anchor:"diffusers.LTXConditionPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 256"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.LTXConditionPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.LTXConditionPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_condition.py#L341"}}),je=new G({props:{name:"trim_conditioning_sequence",anchor:"diffusers.LTXConditionPipeline.trim_conditioning_sequence",parameters:[{name:"start_frame",val:": int"},{name:"sequence_num_frames",val:": int"},{name:"target_num_frames",val:": int"}],parametersDescription:[{anchor:"diffusers.LTXConditionPipeline.trim_conditioning_sequence.start_frame",description:"<strong>start_frame</strong> (int) &#x2014; The target frame number of the first frame in the sequence.",name:"start_frame"},{anchor:"diffusers.LTXConditionPipeline.trim_conditioning_sequence.sequence_num_frames",description:"<strong>sequence_num_frames</strong> (int) &#x2014; The number of frames in the sequence.",name:"sequence_num_frames"},{anchor:"diffusers.LTXConditionPipeline.trim_conditioning_sequence.target_num_frames",description:"<strong>target_num_frames</strong> (int) &#x2014; The target number of frames in the generated video.",name:"target_num_frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_condition.py#L600",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>updated sequence length</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>int</p>
`}}),Ze=new Ge({props:{title:"LTXPipelineOutput",local:"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput",headingTag:"h2"}}),Ie=new G({props:{name:"class diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput",anchor:"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_output.py#L8"}}),Xe=new Pn({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/ltx_video.md"}}),{c(){p=r("meta"),J=o(),T=r("p"),y=o(),c(M.$$.fragment),l=o(),b=r("div"),b.innerHTML=ln,Ae=o(),S=r("p"),S.innerHTML=rn,De=o(),c(R.$$.fragment),Oe=o(),q=r("p"),q.textContent=dn,Ke=o(),A=r("table"),A.innerHTML=pn,et=o(),D=r("p"),D.innerHTML=cn,tt=o(),c(O.$$.fragment),nt=o(),K=r("p"),K.innerHTML=mn,ot=o(),c(ee.$$.fragment),st=o(),te=r("p"),te.innerHTML=gn,it=o(),c(ne.$$.fragment),at=o(),oe=r("p"),oe.innerHTML=hn,lt=o(),c(se.$$.fragment),rt=o(),ie=r("p"),ie.innerHTML=un,dt=o(),ae=r("p"),ae.innerHTML=fn,pt=o(),c(le.$$.fragment),ct=o(),re=r("p"),re.innerHTML=_n,mt=o(),c(de.$$.fragment),gt=o(),pe=r("p"),pe.textContent=yn,ht=o(),ce=r("p"),ce.innerHTML=Tn,ut=o(),c(me.$$.fragment),ft=o(),c(ge.$$.fragment),_t=o(),v=r("div"),c(he.$$.fragment),Lt=o(),ke=r("p"),ke.textContent=Mn,Vt=o(),Le=r("p"),Le.innerHTML=bn,Ct=o(),L=r("div"),c(ue.$$.fragment),Bt=o(),Ve=r("p"),Ve.textContent=wn,Wt=o(),c(N.$$.fragment),Rt=o(),$=r("div"),c(fe.$$.fragment),Nt=o(),Ce=r("p"),Ce.textContent=Jn,yt=o(),c(_e.$$.fragment),Tt=o(),U=r("div"),c(ye.$$.fragment),$t=o(),Be=r("p"),Be.textContent=vn,Pt=o(),We=r("p"),We.innerHTML=Un,zt=o(),V=r("div"),c(Te.$$.fragment),Ht=o(),Re=r("p"),Re.textContent=jn,Ft=o(),c(P.$$.fragment),Et=o(),z=r("div"),c(Me.$$.fragment),Yt=o(),Ne=r("p"),Ne.textContent=Zn,Mt=o(),c(be.$$.fragment),bt=o(),w=r("div"),c(we.$$.fragment),Qt=o(),$e=r("p"),$e.textContent=In,St=o(),Pe=r("p"),Pe.innerHTML=Xn,qt=o(),C=r("div"),c(Je.$$.fragment),At=o(),ze=r("p"),ze.textContent=xn,Dt=o(),c(H.$$.fragment),Ot=o(),F=r("div"),c(ve.$$.fragment),Kt=o(),He=r("p"),He.textContent=Gn,en=o(),E=r("div"),c(Ue.$$.fragment),tn=o(),Fe=r("p"),Fe.textContent=kn,nn=o(),Y=r("div"),c(je.$$.fragment),on=o(),Ee=r("p"),Ee.textContent=Ln,wt=o(),c(Ze.$$.fragment),Jt=o(),B=r("div"),c(Ie.$$.fragment),sn=o(),Ye=r("p"),Ye.textContent=Vn,vt=o(),c(Xe.$$.fragment),Ut=o(),qe=r("p"),this.h()},l(e){const t=Nn("svelte-u9bgzb",document.head);p=d(t,"META",{name:!0,content:!0}),t.forEach(n),J=s(e),T=d(e,"P",{}),I(T).forEach(n),y=s(e),m(M.$$.fragment,e),l=s(e),b=d(e,"DIV",{class:!0,"data-svelte-h":!0}),_(b)!=="svelte-si9ct8"&&(b.innerHTML=ln),Ae=s(e),S=d(e,"P",{"data-svelte-h":!0}),_(S)!=="svelte-1t4cyrb"&&(S.innerHTML=rn),De=s(e),m(R.$$.fragment,e),Oe=s(e),q=d(e,"P",{"data-svelte-h":!0}),_(q)!=="svelte-1bob28v"&&(q.textContent=dn),Ke=s(e),A=d(e,"TABLE",{"data-svelte-h":!0}),_(A)!=="svelte-z7ye80"&&(A.innerHTML=pn),et=s(e),D=d(e,"P",{"data-svelte-h":!0}),_(D)!=="svelte-xu6cps"&&(D.innerHTML=cn),tt=s(e),m(O.$$.fragment,e),nt=s(e),K=d(e,"P",{"data-svelte-h":!0}),_(K)!=="svelte-lk4l6j"&&(K.innerHTML=mn),ot=s(e),m(ee.$$.fragment,e),st=s(e),te=d(e,"P",{"data-svelte-h":!0}),_(te)!=="svelte-rvy320"&&(te.innerHTML=gn),it=s(e),m(ne.$$.fragment,e),at=s(e),oe=d(e,"P",{"data-svelte-h":!0}),_(oe)!=="svelte-1r1x4fd"&&(oe.innerHTML=hn),lt=s(e),m(se.$$.fragment,e),rt=s(e),ie=d(e,"P",{"data-svelte-h":!0}),_(ie)!=="svelte-7vi8uq"&&(ie.innerHTML=un),dt=s(e),ae=d(e,"P",{"data-svelte-h":!0}),_(ae)!=="svelte-1d7qawf"&&(ae.innerHTML=fn),pt=s(e),m(le.$$.fragment,e),ct=s(e),re=d(e,"P",{"data-svelte-h":!0}),_(re)!=="svelte-obf3nv"&&(re.innerHTML=_n),mt=s(e),m(de.$$.fragment,e),gt=s(e),pe=d(e,"P",{"data-svelte-h":!0}),_(pe)!=="svelte-1ou2pxc"&&(pe.textContent=yn),ht=s(e),ce=d(e,"P",{"data-svelte-h":!0}),_(ce)!=="svelte-1dokfz4"&&(ce.innerHTML=Tn),ut=s(e),m(me.$$.fragment,e),ft=s(e),m(ge.$$.fragment,e),_t=s(e),v=d(e,"DIV",{class:!0});var X=I(v);m(he.$$.fragment,X),Lt=s(X),ke=d(X,"P",{"data-svelte-h":!0}),_(ke)!=="svelte-19ipoo4"&&(ke.textContent=Mn),Vt=s(X),Le=d(X,"P",{"data-svelte-h":!0}),_(Le)!=="svelte-1sr6eg8"&&(Le.innerHTML=bn),Ct=s(X),L=d(X,"DIV",{class:!0});var W=I(L);m(ue.$$.fragment,W),Bt=s(W),Ve=d(W,"P",{"data-svelte-h":!0}),_(Ve)!=="svelte-v78lg8"&&(Ve.textContent=wn),Wt=s(W),m(N.$$.fragment,W),W.forEach(n),Rt=s(X),$=d(X,"DIV",{class:!0});var xe=I($);m(fe.$$.fragment,xe),Nt=s(xe),Ce=d(xe,"P",{"data-svelte-h":!0}),_(Ce)!=="svelte-16q0ax1"&&(Ce.textContent=Jn),xe.forEach(n),X.forEach(n),yt=s(e),m(_e.$$.fragment,e),Tt=s(e),U=d(e,"DIV",{class:!0});var x=I(U);m(ye.$$.fragment,x),$t=s(x),Be=d(x,"P",{"data-svelte-h":!0}),_(Be)!=="svelte-10tczlw"&&(Be.textContent=vn),Pt=s(x),We=d(x,"P",{"data-svelte-h":!0}),_(We)!=="svelte-1sr6eg8"&&(We.innerHTML=Un),zt=s(x),V=d(x,"DIV",{class:!0});var Qe=I(V);m(Te.$$.fragment,Qe),Ht=s(Qe),Re=d(Qe,"P",{"data-svelte-h":!0}),_(Re)!=="svelte-v78lg8"&&(Re.textContent=jn),Ft=s(Qe),m(P.$$.fragment,Qe),Qe.forEach(n),Et=s(x),z=d(x,"DIV",{class:!0});var Zt=I(z);m(Me.$$.fragment,Zt),Yt=s(Zt),Ne=d(Zt,"P",{"data-svelte-h":!0}),_(Ne)!=="svelte-16q0ax1"&&(Ne.textContent=Zn),Zt.forEach(n),x.forEach(n),Mt=s(e),m(be.$$.fragment,e),bt=s(e),w=d(e,"DIV",{class:!0});var Z=I(w);m(we.$$.fragment,Z),Qt=s(Z),$e=d(Z,"P",{"data-svelte-h":!0}),_($e)!=="svelte-10tczlw"&&($e.textContent=In),St=s(Z),Pe=d(Z,"P",{"data-svelte-h":!0}),_(Pe)!=="svelte-1sr6eg8"&&(Pe.innerHTML=Xn),qt=s(Z),C=d(Z,"DIV",{class:!0});var Se=I(C);m(Je.$$.fragment,Se),At=s(Se),ze=d(Se,"P",{"data-svelte-h":!0}),_(ze)!=="svelte-v78lg8"&&(ze.textContent=xn),Dt=s(Se),m(H.$$.fragment,Se),Se.forEach(n),Ot=s(Z),F=d(Z,"DIV",{class:!0});var It=I(F);m(ve.$$.fragment,It),Kt=s(It),He=d(It,"P",{"data-svelte-h":!0}),_(He)!=="svelte-9ak1um"&&(He.textContent=Gn),It.forEach(n),en=s(Z),E=d(Z,"DIV",{class:!0});var Xt=I(E);m(Ue.$$.fragment,Xt),tn=s(Xt),Fe=d(Xt,"P",{"data-svelte-h":!0}),_(Fe)!=="svelte-16q0ax1"&&(Fe.textContent=kn),Xt.forEach(n),nn=s(Z),Y=d(Z,"DIV",{class:!0});var xt=I(Y);m(je.$$.fragment,xt),on=s(xt),Ee=d(xt,"P",{"data-svelte-h":!0}),_(Ee)!=="svelte-1eod455"&&(Ee.textContent=Ln),xt.forEach(n),Z.forEach(n),wt=s(e),m(Ze.$$.fragment,e),Jt=s(e),B=d(e,"DIV",{class:!0});var Gt=I(B);m(Ie.$$.fragment,Gt),sn=s(Gt),Ye=d(Gt,"P",{"data-svelte-h":!0}),_(Ye)!=="svelte-ia4jjd"&&(Ye.textContent=Vn),Gt.forEach(n),vt=s(e),m(Xe.$$.fragment,e),Ut=s(e),qe=d(e,"P",{}),I(qe).forEach(n),this.h()},h(){j(p,"name","hf:doc:metadata"),j(p,"content",Qn),j(b,"class","flex flex-wrap space-x-1"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,p),i(e,J,t),i(e,T,t),i(e,y,t),g(M,e,t),i(e,l,t),i(e,b,t),i(e,Ae,t),i(e,S,t),i(e,De,t),g(R,e,t),i(e,Oe,t),i(e,q,t),i(e,Ke,t),i(e,A,t),i(e,et,t),i(e,D,t),i(e,tt,t),g(O,e,t),i(e,nt,t),i(e,K,t),i(e,ot,t),g(ee,e,t),i(e,st,t),i(e,te,t),i(e,it,t),g(ne,e,t),i(e,at,t),i(e,oe,t),i(e,lt,t),g(se,e,t),i(e,rt,t),i(e,ie,t),i(e,dt,t),i(e,ae,t),i(e,pt,t),g(le,e,t),i(e,ct,t),i(e,re,t),i(e,mt,t),g(de,e,t),i(e,gt,t),i(e,pe,t),i(e,ht,t),i(e,ce,t),i(e,ut,t),g(me,e,t),i(e,ft,t),g(ge,e,t),i(e,_t,t),i(e,v,t),g(he,v,null),a(v,Lt),a(v,ke),a(v,Vt),a(v,Le),a(v,Ct),a(v,L),g(ue,L,null),a(L,Bt),a(L,Ve),a(L,Wt),g(N,L,null),a(v,Rt),a(v,$),g(fe,$,null),a($,Nt),a($,Ce),i(e,yt,t),g(_e,e,t),i(e,Tt,t),i(e,U,t),g(ye,U,null),a(U,$t),a(U,Be),a(U,Pt),a(U,We),a(U,zt),a(U,V),g(Te,V,null),a(V,Ht),a(V,Re),a(V,Ft),g(P,V,null),a(U,Et),a(U,z),g(Me,z,null),a(z,Yt),a(z,Ne),i(e,Mt,t),g(be,e,t),i(e,bt,t),i(e,w,t),g(we,w,null),a(w,Qt),a(w,$e),a(w,St),a(w,Pe),a(w,qt),a(w,C),g(Je,C,null),a(C,At),a(C,ze),a(C,Dt),g(H,C,null),a(w,Ot),a(w,F),g(ve,F,null),a(F,Kt),a(F,He),a(w,en),a(w,E),g(Ue,E,null),a(E,tn),a(E,Fe),a(w,nn),a(w,Y),g(je,Y,null),a(Y,on),a(Y,Ee),i(e,wt,t),g(Ze,e,t),i(e,Jt,t),i(e,B,t),g(Ie,B,null),a(B,sn),a(B,Ye),i(e,vt,t),g(Xe,e,t),i(e,Ut,t),i(e,qe,t),jt=!0},p(e,[t]){const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),R.$set(X);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),N.$set(W);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),P.$set(xe);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),H.$set(x)},i(e){jt||(h(M.$$.fragment,e),h(R.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(N.$$.fragment,e),h(fe.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(P.$$.fragment,e),h(Me.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(H.$$.fragment,e),h(ve.$$.fragment,e),h(Ue.$$.fragment,e),h(je.$$.fragment,e),h(Ze.$$.fragment,e),h(Ie.$$.fragment,e),h(Xe.$$.fragment,e),jt=!0)},o(e){u(M.$$.fragment,e),u(R.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(N.$$.fragment,e),u(fe.$$.fragment,e),u(_e.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(P.$$.fragment,e),u(Me.$$.fragment,e),u(be.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(H.$$.fragment,e),u(ve.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Ze.$$.fragment,e),u(Ie.$$.fragment,e),u(Xe.$$.fragment,e),jt=!1},d(e){e&&(n(J),n(T),n(y),n(l),n(b),n(Ae),n(S),n(De),n(Oe),n(q),n(Ke),n(A),n(et),n(D),n(tt),n(nt),n(K),n(ot),n(st),n(te),n(it),n(at),n(oe),n(lt),n(rt),n(ie),n(dt),n(ae),n(pt),n(ct),n(re),n(mt),n(gt),n(pe),n(ht),n(ce),n(ut),n(ft),n(_t),n(v),n(yt),n(Tt),n(U),n(Mt),n(bt),n(w),n(wt),n(Jt),n(B),n(vt),n(Ut),n(qe)),n(p),f(M,e),f(R,e),f(O,e),f(ee,e),f(ne,e),f(se,e),f(le,e),f(de,e),f(me,e),f(ge,e),f(he),f(ue),f(N),f(fe),f(_e,e),f(ye),f(Te),f(P),f(Me),f(be,e),f(we),f(Je),f(H),f(ve),f(Ue),f(je),f(Ze,e),f(Ie),f(Xe,e)}}}const Qn='{"title":"LTX Video","local":"ltx-video","sections":[{"title":"Loading Single Files","local":"loading-single-files","sections":[],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"LTXPipeline","local":"diffusers.LTXPipeline","sections":[],"depth":2},{"title":"LTXImageToVideoPipeline","local":"diffusers.LTXImageToVideoPipeline","sections":[],"depth":2},{"title":"LTXConditionPipeline","local":"diffusers.LTXConditionPipeline","sections":[],"depth":2},{"title":"LTXPipelineOutput","local":"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput","sections":[],"depth":2}],"depth":1}';function Sn(k){return Bn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class no extends Wn{constructor(p){super(),Rn(this,p,Sn,Yn,Cn,{})}}export{no as component};
