import{s as Zt,o as It,n as rt}from"../chunks/scheduler.22bf70d2.js";import{S as At,i as Wt,g as f,s as c,r as u,A as Xt,h,f as a,c as o,j as kt,u as y,x as b,k as Ct,y as Rt,a as l,v as M,d as w,t as $,w as g}from"../chunks/index.59178e06.js";import{T as ct}from"../chunks/Tip.75d940ba.js";import{C as k}from"../chunks/CodeBlock.f7047b13.js";import{H as C}from"../chunks/Heading.f8746c79.js";import{H as Yt,a as Gt}from"../chunks/HfOption.04cc3620.js";function Ht(j){let r,T="Accelerate only prepares objects that inherit from their respective PyTorch classes such as <code>torch.optim.Optimizer</code>.";return{c(){r=f("p"),r.innerHTML=T},l(s){r=h(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-1oh2ah6"&&(r.innerHTML=T)},m(s,m){l(s,r,m)},p:rt,d(s){s&&a(r)}}}function Vt(j){let r,T='Accelerate enables automatic mixed precision, so <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> is only needed if there are other mixed precision operations besides those performed on loss by <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> which already handles the scaling.';return{c(){r=f("p"),r.innerHTML=T},l(s){r=h(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-rgbqmb"&&(r.innerHTML=T)},m(s,m){l(s,r,m)},p:rt,d(s){s&&a(r)}}}function Bt(j){let r,T='For models from the <a href="https://hf.co/docs/transformers/index" rel="nofollow">Transformers</a> library, save the model with the <a href="https://huggingface.co/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a> method so that it can be reloaded with the <a href="https://huggingface.co/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained" rel="nofollow">from_pretrained</a> method.',s,m,n;return m=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQXVud3JhcHBlZF9tb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEF1bndyYXBwZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnBhdGglMkZ0byUyRm15X21vZGVsX2RpcmVjdG9yeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlzX21haW5fcHJvY2VzcyUzRGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZnVuY3Rpb24lM0RhY2NlbGVyYXRvci5zYXZlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZteV9tb2RlbF9kaXJlY3RvcnklMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

unwrapped_model = accelerator.unwrap_model(model)
unwrapped_model.save_pretrained(
    <span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>,
    is_main_process=accelerator.is_main_process,
    save_function=accelerator.save,
)

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>)`,wrap:!1}}),{c(){r=f("p"),r.innerHTML=T,s=c(),u(m.$$.fragment)},l(p){r=h(p,"P",{"data-svelte-h":!0}),b(r)!=="svelte-1ehy9oh"&&(r.innerHTML=T),s=o(p),y(m.$$.fragment,p)},m(p,v){l(p,r,v),l(p,s,v),M(m,p,v),n=!0},p:rt,i(p){n||(w(m.$$.fragment,p),n=!0)},o(p){$(m.$$.fragment,p),n=!1},d(p){p&&(a(r),a(s)),g(m,p)}}}function zt(j){let r,T,s,m,n,p='To load your weights, use the <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method to unwrap the model first before loading the weights. All model parameters are references to tensors, so this loads your weights inside <code>model</code>.',v,U,J;return r=new k({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory)`,wrap:!1}}),s=new ct({props:{$$slots:{default:[Bt]},$$scope:{ctx:j}}}),U=new k({props:{code:"dW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQXBhdGhfdG9fY2hlY2twb2ludCUyMCUzRCUyMG9zLnBhdGguam9pbihzYXZlX2RpcmVjdG9yeSUyQyUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSUwQXVud3JhcHBlZF9tb2RlbC5sb2FkX3N0YXRlX2RpY3QodG9yY2gubG9hZChwYXRoX3RvX2NoZWNrcG9pbnQpKQ==",highlighted:`unwrapped_model = accelerator.unwrap_model(model)
path_to_checkpoint = os.path.join(save_directory,<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
unwrapped_model.load_state_dict(torch.load(path_to_checkpoint))`,wrap:!1}}),{c(){u(r.$$.fragment),T=c(),u(s.$$.fragment),m=c(),n=f("p"),n.innerHTML=p,v=c(),u(U.$$.fragment)},l(i){y(r.$$.fragment,i),T=o(i),y(s.$$.fragment,i),m=o(i),n=h(i,"P",{"data-svelte-h":!0}),b(n)!=="svelte-mw1lq5"&&(n.innerHTML=p),v=o(i),y(U.$$.fragment,i)},m(i,d){M(r,i,d),l(i,T,d),M(s,i,d),l(i,m,d),l(i,n,d),l(i,v,d),M(U,i,d),J=!0},p(i,d){const _={};d&2&&(_.$$scope={dirty:d,ctx:i}),s.$set(_)},i(i){J||(w(r.$$.fragment,i),w(s.$$.fragment,i),w(U.$$.fragment,i),J=!0)},o(i){$(r.$$.fragment,i),$(s.$$.fragment,i),$(U.$$.fragment,i),J=!1},d(i){i&&(a(T),a(m),a(n),a(v)),g(r,i),g(s,i),g(U,i)}}}function xt(j){let r,T="Set <code>safe_serialization=True</code> to save the model in the safetensor format.",s,m,n,p,v='To load a sharded checkpoint or a safetensor formatted checkpoint, use the <a href="/docs/accelerate/v0.29.0/en/package_reference/big_modeling#accelerate.load_checkpoint_in_model">load_checkpoint_in_model()</a> method. This method allows you to load a checkpoint onto a specific device.',U,J,i;return m=new k({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMG1heF9zaGFyZF9zaXplJTNEJTIyMUdCJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNEVHJ1ZSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>, safe_serialization=<span class="hljs-literal">True</span>)`,wrap:!1}}),J=new k({props:{code:"bG9hZF9jaGVja3BvaW50X2luX21vZGVsKHVud3JhcHBlZF9tb2RlbCUyQyUyMHNhdmVfZGlyZWN0b3J5JTJDJTIwZGV2aWNlX21hcCUzRCU3QiUyMiUyMiUzQWRldmljZSU3RCk=",highlighted:'load_checkpoint_in_model(unwrapped_model, save_directory, device_map={<span class="hljs-string">&quot;&quot;</span>:device})',wrap:!1}}),{c(){r=f("p"),r.innerHTML=T,s=c(),u(m.$$.fragment),n=c(),p=f("p"),p.innerHTML=v,U=c(),u(J.$$.fragment)},l(d){r=h(d,"P",{"data-svelte-h":!0}),b(r)!=="svelte-jahj75"&&(r.innerHTML=T),s=o(d),y(m.$$.fragment,d),n=o(d),p=h(d,"P",{"data-svelte-h":!0}),b(p)!=="svelte-1eqt1rh"&&(p.innerHTML=v),U=o(d),y(J.$$.fragment,d)},m(d,_){l(d,r,_),l(d,s,_),M(m,d,_),l(d,n,_),l(d,p,_),l(d,U,_),M(J,d,_),i=!0},p:rt,i(d){i||(w(m.$$.fragment,d),w(J.$$.fragment,d),i=!0)},o(d){$(m.$$.fragment,d),$(J.$$.fragment,d),i=!1},d(d){d&&(a(r),a(s),a(n),a(p),a(U)),g(m,d),g(J,d)}}}function Ft(j){let r,T,s,m;return r=new Gt({props:{id:"save",option:"single checkpoint",$$slots:{default:[zt]},$$scope:{ctx:j}}}),s=new Gt({props:{id:"save",option:"sharded checkpoint",$$slots:{default:[xt]},$$scope:{ctx:j}}}),{c(){u(r.$$.fragment),T=c(),u(s.$$.fragment)},l(n){y(r.$$.fragment,n),T=o(n),y(s.$$.fragment,n)},m(n,p){M(r,n,p),l(n,T,p),M(s,n,p),m=!0},p(n,p){const v={};p&2&&(v.$$scope={dirty:p,ctx:n}),r.$set(v);const U={};p&2&&(U.$$scope={dirty:p,ctx:n}),s.$set(U)},i(n){m||(w(r.$$.fragment,n),w(s.$$.fragment,n),m=!0)},o(n){$(r.$$.fragment,n),$(s.$$.fragment,n),m=!1},d(n){n&&a(T),g(r,n),g(s,n)}}}function Qt(j){let r,T,s,m,n,p,v,U="Each distributed training framework has their own way of doing things which can require writing a lot of custom code to adapt it to your PyTorch training code and training environment. Accelerate offers a friendly way to interface with these distributed training frameworks without having to learn the specific details of each one. Accelerate takes care of those details for you, so you can focus on the training code and scale it to any distributed training environment.",J,i,d="In this tutorial, you’ll learn how to adapt your existing PyTorch code with Accelerate and get you on your way toward training on distributed systems with ease! You’ll start with a basic PyTorch training loop (it assumes all the training objects like <code>model</code> and <code>optimizer</code> have been setup already) and progressively integrate Accelerate into it.",_,A,Me,W,we,X,ot='The <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is the main class for adapting your code to work with Accelerate. It knows about the distributed setup you’re using such as the number of different processes and your hardware type. This class also provides access to many of the necessary methods for enabling your PyTorch code to work in any distributed training environment and for managing and executing processes across devices.',$e,R,nt='That’s why you should always start by importing and creating an <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> instance in your script.',ge,Y,be,H,st='The <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> also knows which device to move your PyTorch objects to, so it is recommended to let Accelerate handle this for you.',Te,V,ve,B,Ue,z,it='Next, you need to prepare your PyTorch objects (model, optimizer, scheduler, etc.) for distributed training. The <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method takes care of placing your model in the appropriate container (like single GPU or multi-GPU) for your training setup, adapting the optimizer and scheduler to use Accelerate’s <a href="/docs/accelerate/v0.29.0/en/package_reference/torch_wrappers#accelerate.optimizer.AcceleratedOptimizer">AcceleratedOptimizer</a> and <a href="/docs/accelerate/v0.29.0/en/package_reference/torch_wrappers#accelerate.scheduler.AcceleratedScheduler">AcceleratedScheduler</a>, and creating a new dataloader that can be sharded across processes.',Je,G,_e,x,pt="The PyTorch objects are returned in the same order they’re sent.",je,F,ke,Q,Ce,S,dt='Finally, remove the <code>to(device)</code> calls to the inputs and targets in the training loop because Accelerate’s DataLoader classes automatically places them on the right device. You should also replace the usual <code>backward()</code> pass with Accelerate’s <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> method which scales the gradients for you and uses the appropriate <code>backward()</code> method depending on your distributed setup (for example, DeepSpeed or Megatron).',Ge,N,Ze,L,mt="Put everything together and your new Accelerate training loop should now look like this!",Ie,P,Ae,E,We,K,ft="Accelerate offers additional features - like gradient accumulation, gradient clipping, mixed precision training and more - you can add to your script to improve your training run. Let’s explore these three features.",Xe,q,Re,D,ht='Gradient accumulation enables you to train on larger batch sizes by accumulating the gradients over multiple batches before updating the weights. This can be useful for getting around memory limitations. To enable this feature in Accelerate, specify the <code>gradient_accumulation_steps</code> parameter in the <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class and add the <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> context manager to your script.',Ye,O,He,ee,Ve,te,ut="Gradient clipping is a technique to prevent “exploding gradients”, and Accelerate offers:",Be,ae,yt='<li><a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_value_">clip<em>grad_value</em>()</a> to clip gradients to a minimum and maximum value</li> <li><a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_norm_">clip<em>grad_norm</em>()</a> for normalizing gradients to a certain value</li>',ze,le,xe,re,Mt="Mixed precision accelerates training by using a lower precision data type like fp16 (half-precision) to calculate the gradients. For the best performance with Accelerate, the loss should be computed inside your model (like in Transformers models) because computations outside of the model are computed in full precision.",Fe,ce,wt='Set the mixed precision type to use in the <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, and then use the <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> context manager to automatically cast the values to the specified data type.',Qe,Z,Se,oe,Ne,ne,Le,se,$t="Accelerate can also save and load a <em>model</em> once training is complete or you can also save the model and optimizer <em>state</em> which could be useful for resuming training.",Pe,ie,Ee,pe,gt='Once all processes are complete, unwrap the model with the <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method before saving it because the <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method wrapped your model into the proper interface for distributed training. If you don’t unwrap the model, saving the model state dictionary also saves any potential extra layers from the larger model and you won’t be able to load the weights back into your base model.',Ke,de,bt='You should use the <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a> method to unwrap and save the model state dictionary. This method can also save a model into sharded checkpoints or into the <a href="https://hf.co/docs/safetensors/index" rel="nofollow">safetensors</a> format.',qe,I,De,me,Oe,fe,Tt='During training, you may want to save the current state of the model, optimizer, random generators, and potentially learning rate schedulers so they can be restored in the <em>same script</em>. You should add the <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a> and <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.load_state">load_state()</a> methods to your script to save and load states.',et,he,vt='To further customize where and how states are saved through <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a>, use the <a href="/docs/accelerate/v0.29.0/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> class. For example, if <code>automatic_checkpoint_naming</code> is enabled, each saved checkpoint is stored at <code>Accelerator.project_dir/checkpoints/checkpoint_{checkpoint_number}</code>.',tt,ue,Ut='Any other stateful items to be stored should be registered with the <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.register_for_checkpointing">register_for_checkpointing()</a> method so they can be saved and loaded. Every object passed to this method to be stored must have a <code>load_state_dict</code> and <code>state_dict</code> function.',at,ye,lt;return n=new C({props:{title:"Add Accelerate to your code",local:"add-accelerate-to-your-code",headingTag:"h1"}}),A=new k({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMHRhcmdldHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss.backward()
    optimizer.step()
    scheduler.step()`,wrap:!1}}),W=new C({props:{title:"Accelerator",local:"accelerator",headingTag:"h2"}}),Y=new k({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),V=new k({props:{code:"LSUyMGRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEElMkIlMjBkZXZpY2UlMjAlM0QlMjBhY2NlbGVyYXRvci5kZXZpY2UlMEElMjAlMjBtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-deletion">- device = &quot;cuda&quot;</span>
<span class="hljs-addition">+ device = accelerator.device</span>
  model.to(device)`,wrap:!1}}),B=new C({props:{title:"Prepare PyTorch objects",local:"prepare-pytorch-objects",headingTag:"h2"}}),G=new ct({props:{warning:!1,$$slots:{default:[Ht]},$$scope:{ctx:j}}}),F=new k({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMEEp",highlighted:`model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)`,wrap:!1}}),Q=new C({props:{title:"Training loop",local:"training-loop",headingTag:"h2"}}),N=new k({props:{code:"LSUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBLSUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQS0lMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMkIlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKQ==",highlighted:`<span class="hljs-deletion">-   inputs = inputs.to(device)</span>
<span class="hljs-deletion">-   targets = targets.to(device)</span>
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
<span class="hljs-deletion">-   loss.backward()</span>
<span class="hljs-addition">+   accelerator.backward(loss)</span>`,wrap:!1}}),P=new k({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQWRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerator = Accelerator()

device = accelerator.device
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    accelerator.backward(loss)
    optimizer.step()
    scheduler.step()`,wrap:!1}}),E=new C({props:{title:"Training features",local:"training-features",headingTag:"h2"}}),q=new C({props:{title:"Gradient accumulation",local:"gradient-accumulation",headingTag:"h3"}}),O=new k({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QyKSUwQSUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUwQSUyMCUyMGZvciUyMGlucHV0JTJDJTIwbGFiZWwlMjBpbiUyMHRyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMkIlMjAlMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IuYWNjdW11bGF0ZShtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKHByZWRpY3Rpb25zJTJDJTIwbGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>
  model, optimizer, training_dataloader = accelerator.prepare(model, optimizer, training_dataloader)

  for input, label in training_dataloader:
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          predictions = model(input)
          loss = loss_function(predictions, label)
          accelerator.backward(loss)
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),ee=new C({props:{title:"Gradient clipping",local:"gradient-clipping",headingTag:"h3"}}),le=new C({props:{title:"Mixed precision",local:"mixed-precision",headingTag:"h3"}}),Z=new ct({props:{warning:!0,$$slots:{default:[Vt]},$$scope:{ctx:j}}}),oe=new k({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyKSUwQSUyQiUyMHdpdGglMjBhY2NlbGVyYXRvci5hdXRvY2FzdCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGNvbXBsZXhfbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0KSUzQQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(mixed_precision=&quot;fp16&quot;)</span>
<span class="hljs-addition">+ with accelerator.autocast():</span>
      loss = complex_loss_function(outputs, target):`,wrap:!1}}),ne=new C({props:{title:"Save and load",local:"save-and-load",headingTag:"h2"}}),ie=new C({props:{title:"Model",local:"model",headingTag:"h3"}}),I=new Yt({props:{id:"save",options:["single checkpoint","sharded checkpoint"],$$slots:{default:[Ft]},$$scope:{ctx:j}}}),me=new C({props:{title:"State",local:"state",headingTag:"h3"}}),{c(){r=f("meta"),T=c(),s=f("p"),m=c(),u(n.$$.fragment),p=c(),v=f("p"),v.textContent=U,J=c(),i=f("p"),i.innerHTML=d,_=c(),u(A.$$.fragment),Me=c(),u(W.$$.fragment),we=c(),X=f("p"),X.innerHTML=ot,$e=c(),R=f("p"),R.innerHTML=nt,ge=c(),u(Y.$$.fragment),be=c(),H=f("p"),H.innerHTML=st,Te=c(),u(V.$$.fragment),ve=c(),u(B.$$.fragment),Ue=c(),z=f("p"),z.innerHTML=it,Je=c(),u(G.$$.fragment),_e=c(),x=f("p"),x.textContent=pt,je=c(),u(F.$$.fragment),ke=c(),u(Q.$$.fragment),Ce=c(),S=f("p"),S.innerHTML=dt,Ge=c(),u(N.$$.fragment),Ze=c(),L=f("p"),L.textContent=mt,Ie=c(),u(P.$$.fragment),Ae=c(),u(E.$$.fragment),We=c(),K=f("p"),K.textContent=ft,Xe=c(),u(q.$$.fragment),Re=c(),D=f("p"),D.innerHTML=ht,Ye=c(),u(O.$$.fragment),He=c(),u(ee.$$.fragment),Ve=c(),te=f("p"),te.textContent=ut,Be=c(),ae=f("ul"),ae.innerHTML=yt,ze=c(),u(le.$$.fragment),xe=c(),re=f("p"),re.textContent=Mt,Fe=c(),ce=f("p"),ce.innerHTML=wt,Qe=c(),u(Z.$$.fragment),Se=c(),u(oe.$$.fragment),Ne=c(),u(ne.$$.fragment),Le=c(),se=f("p"),se.innerHTML=$t,Pe=c(),u(ie.$$.fragment),Ee=c(),pe=f("p"),pe.innerHTML=gt,Ke=c(),de=f("p"),de.innerHTML=bt,qe=c(),u(I.$$.fragment),De=c(),u(me.$$.fragment),Oe=c(),fe=f("p"),fe.innerHTML=Tt,et=c(),he=f("p"),he.innerHTML=vt,tt=c(),ue=f("p"),ue.innerHTML=Ut,at=c(),ye=f("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);r=h(t,"META",{name:!0,content:!0}),t.forEach(a),T=o(e),s=h(e,"P",{}),kt(s).forEach(a),m=o(e),y(n.$$.fragment,e),p=o(e),v=h(e,"P",{"data-svelte-h":!0}),b(v)!=="svelte-19zbp5z"&&(v.textContent=U),J=o(e),i=h(e,"P",{"data-svelte-h":!0}),b(i)!=="svelte-1lmjen8"&&(i.innerHTML=d),_=o(e),y(A.$$.fragment,e),Me=o(e),y(W.$$.fragment,e),we=o(e),X=h(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1kukc1u"&&(X.innerHTML=ot),$e=o(e),R=h(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-1cs6qa7"&&(R.innerHTML=nt),ge=o(e),y(Y.$$.fragment,e),be=o(e),H=h(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-x8m4jr"&&(H.innerHTML=st),Te=o(e),y(V.$$.fragment,e),ve=o(e),y(B.$$.fragment,e),Ue=o(e),z=h(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-76dzd1"&&(z.innerHTML=it),Je=o(e),y(G.$$.fragment,e),_e=o(e),x=h(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-l5v2wx"&&(x.textContent=pt),je=o(e),y(F.$$.fragment,e),ke=o(e),y(Q.$$.fragment,e),Ce=o(e),S=h(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-197dgh9"&&(S.innerHTML=dt),Ge=o(e),y(N.$$.fragment,e),Ze=o(e),L=h(e,"P",{"data-svelte-h":!0}),b(L)!=="svelte-1b6tm11"&&(L.textContent=mt),Ie=o(e),y(P.$$.fragment,e),Ae=o(e),y(E.$$.fragment,e),We=o(e),K=h(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-1ef6475"&&(K.textContent=ft),Xe=o(e),y(q.$$.fragment,e),Re=o(e),D=h(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-5q5lo9"&&(D.innerHTML=ht),Ye=o(e),y(O.$$.fragment,e),He=o(e),y(ee.$$.fragment,e),Ve=o(e),te=h(e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-bg95gl"&&(te.textContent=ut),Be=o(e),ae=h(e,"UL",{"data-svelte-h":!0}),b(ae)!=="svelte-58v7sh"&&(ae.innerHTML=yt),ze=o(e),y(le.$$.fragment,e),xe=o(e),re=h(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-81s14c"&&(re.textContent=Mt),Fe=o(e),ce=h(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-1yhmtdk"&&(ce.innerHTML=wt),Qe=o(e),y(Z.$$.fragment,e),Se=o(e),y(oe.$$.fragment,e),Ne=o(e),y(ne.$$.fragment,e),Le=o(e),se=h(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-dqdivd"&&(se.innerHTML=$t),Pe=o(e),y(ie.$$.fragment,e),Ee=o(e),pe=h(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-imuujp"&&(pe.innerHTML=gt),Ke=o(e),de=h(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-pfvzlo"&&(de.innerHTML=bt),qe=o(e),y(I.$$.fragment,e),De=o(e),y(me.$$.fragment,e),Oe=o(e),fe=h(e,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-kpcd93"&&(fe.innerHTML=Tt),et=o(e),he=h(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-1spb81m"&&(he.innerHTML=vt),tt=o(e),ue=h(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-3pwc14"&&(ue.innerHTML=Ut),at=o(e),ye=h(e,"P",{}),kt(ye).forEach(a),this.h()},h(){Ct(r,"name","hf:doc:metadata"),Ct(r,"content",St)},m(e,t){Rt(document.head,r),l(e,T,t),l(e,s,t),l(e,m,t),M(n,e,t),l(e,p,t),l(e,v,t),l(e,J,t),l(e,i,t),l(e,_,t),M(A,e,t),l(e,Me,t),M(W,e,t),l(e,we,t),l(e,X,t),l(e,$e,t),l(e,R,t),l(e,ge,t),M(Y,e,t),l(e,be,t),l(e,H,t),l(e,Te,t),M(V,e,t),l(e,ve,t),M(B,e,t),l(e,Ue,t),l(e,z,t),l(e,Je,t),M(G,e,t),l(e,_e,t),l(e,x,t),l(e,je,t),M(F,e,t),l(e,ke,t),M(Q,e,t),l(e,Ce,t),l(e,S,t),l(e,Ge,t),M(N,e,t),l(e,Ze,t),l(e,L,t),l(e,Ie,t),M(P,e,t),l(e,Ae,t),M(E,e,t),l(e,We,t),l(e,K,t),l(e,Xe,t),M(q,e,t),l(e,Re,t),l(e,D,t),l(e,Ye,t),M(O,e,t),l(e,He,t),M(ee,e,t),l(e,Ve,t),l(e,te,t),l(e,Be,t),l(e,ae,t),l(e,ze,t),M(le,e,t),l(e,xe,t),l(e,re,t),l(e,Fe,t),l(e,ce,t),l(e,Qe,t),M(Z,e,t),l(e,Se,t),M(oe,e,t),l(e,Ne,t),M(ne,e,t),l(e,Le,t),l(e,se,t),l(e,Pe,t),M(ie,e,t),l(e,Ee,t),l(e,pe,t),l(e,Ke,t),l(e,de,t),l(e,qe,t),M(I,e,t),l(e,De,t),M(me,e,t),l(e,Oe,t),l(e,fe,t),l(e,et,t),l(e,he,t),l(e,tt,t),l(e,ue,t),l(e,at,t),l(e,ye,t),lt=!0},p(e,[t]){const Jt={};t&2&&(Jt.$$scope={dirty:t,ctx:e}),G.$set(Jt);const _t={};t&2&&(_t.$$scope={dirty:t,ctx:e}),Z.$set(_t);const jt={};t&2&&(jt.$$scope={dirty:t,ctx:e}),I.$set(jt)},i(e){lt||(w(n.$$.fragment,e),w(A.$$.fragment,e),w(W.$$.fragment,e),w(Y.$$.fragment,e),w(V.$$.fragment,e),w(B.$$.fragment,e),w(G.$$.fragment,e),w(F.$$.fragment,e),w(Q.$$.fragment,e),w(N.$$.fragment,e),w(P.$$.fragment,e),w(E.$$.fragment,e),w(q.$$.fragment,e),w(O.$$.fragment,e),w(ee.$$.fragment,e),w(le.$$.fragment,e),w(Z.$$.fragment,e),w(oe.$$.fragment,e),w(ne.$$.fragment,e),w(ie.$$.fragment,e),w(I.$$.fragment,e),w(me.$$.fragment,e),lt=!0)},o(e){$(n.$$.fragment,e),$(A.$$.fragment,e),$(W.$$.fragment,e),$(Y.$$.fragment,e),$(V.$$.fragment,e),$(B.$$.fragment,e),$(G.$$.fragment,e),$(F.$$.fragment,e),$(Q.$$.fragment,e),$(N.$$.fragment,e),$(P.$$.fragment,e),$(E.$$.fragment,e),$(q.$$.fragment,e),$(O.$$.fragment,e),$(ee.$$.fragment,e),$(le.$$.fragment,e),$(Z.$$.fragment,e),$(oe.$$.fragment,e),$(ne.$$.fragment,e),$(ie.$$.fragment,e),$(I.$$.fragment,e),$(me.$$.fragment,e),lt=!1},d(e){e&&(a(T),a(s),a(m),a(p),a(v),a(J),a(i),a(_),a(Me),a(we),a(X),a($e),a(R),a(ge),a(be),a(H),a(Te),a(ve),a(Ue),a(z),a(Je),a(_e),a(x),a(je),a(ke),a(Ce),a(S),a(Ge),a(Ze),a(L),a(Ie),a(Ae),a(We),a(K),a(Xe),a(Re),a(D),a(Ye),a(He),a(Ve),a(te),a(Be),a(ae),a(ze),a(xe),a(re),a(Fe),a(ce),a(Qe),a(Se),a(Ne),a(Le),a(se),a(Pe),a(Ee),a(pe),a(Ke),a(de),a(qe),a(De),a(Oe),a(fe),a(et),a(he),a(tt),a(ue),a(at),a(ye)),a(r),g(n,e),g(A,e),g(W,e),g(Y,e),g(V,e),g(B,e),g(G,e),g(F,e),g(Q,e),g(N,e),g(P,e),g(E,e),g(q,e),g(O,e),g(ee,e),g(le,e),g(Z,e),g(oe,e),g(ne,e),g(ie,e),g(I,e),g(me,e)}}}const St='{"title":"Add Accelerate to your code","local":"add-accelerate-to-your-code","sections":[{"title":"Accelerator","local":"accelerator","sections":[],"depth":2},{"title":"Prepare PyTorch objects","local":"prepare-pytorch-objects","sections":[],"depth":2},{"title":"Training loop","local":"training-loop","sections":[],"depth":2},{"title":"Training features","local":"training-features","sections":[{"title":"Gradient accumulation","local":"gradient-accumulation","sections":[],"depth":3},{"title":"Gradient clipping","local":"gradient-clipping","sections":[],"depth":3},{"title":"Mixed precision","local":"mixed-precision","sections":[],"depth":3}],"depth":2},{"title":"Save and load","local":"save-and-load","sections":[{"title":"Model","local":"model","sections":[],"depth":3},{"title":"State","local":"state","sections":[],"depth":3}],"depth":2}],"depth":1}';function Nt(j){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends At{constructor(r){super(),Wt(this,r,Nt,Qt,Zt,{})}}export{Ot as component};
