import{s as _e,n as Te,o as $e}from"../chunks/scheduler.852ec091.js";import{S as qe,i as Le,g as o,s as n,r as ee,A as ke,h as l,f as i,c as s,j as Pe,u as te,x as r,k as Z,y as He,a,v as ie,d as ae,t as ne,w as se}from"../chunks/index.28275fd3.js";import{H as oe}from"../chunks/Heading.3b22a250.js";function Me(le){let m,H,L,M,u,U,h,re="Stateful optimizers maintain gradient statistics over time, for example, the exponentially smoothed sum (SGD with momentum) or squared sum (Adam) of past gradient values. This state can be used to accelerate optimization compared to plain stochastic gradient descent, but uses memory that might otherwise be allocated to model parameters. As a result, this limits the maximum size of models that can be trained in practice. Now take a look at the biggest models that can be trained with 8-bit optimizers.",I,d,me='<figure><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bitsandbytes/optimizer_largest_model.png"/> <figcaption class="text-center">Depending on your GPU size, you can train a much larger model with a 8-bit optimizer.</figcaption></figure>',G,f,de="bitsandbytes optimizers use 8-bit statistics, while maintaining the performance levels of using 32-bit optimizer states.",S,c,pe="To overcome the resulting computational, quantization and stability challenges, 8-bit optimizers have three components:",j,b,ue="<li>Block-wise quantization: divides input tensors into smaller blocks that are independently quantized, isolating outliers and distributing the error more equally over all bits. Each block is processed in parallel across cores, yielding faster optimization and high precision quantization.</li> <li>Dynamic quantization: quantizes both small and large values with high precision.</li> <li>Stable embedding layer: improves stability during optimization for models with word embeddings.</li>",A,g,he="With these components, performing an optimizer update with 8-bit states is straightforward. The 8-bit optimizer states are dequantized to 32-bit before you perform the update, and then the states are quantized back to 8-bit for storage.",D,y,fe="The 8-bit to 32-bit conversion happens element-by-element in registers, meaning no slow copies to GPU memory or additional temporary memory are needed to perform quantization and dequantization. For GPUs, this makes 8-bit optimizers much faster than regular 32-bit optimizers.",E,p,ce='<figure><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bitsandbytes/optimizer_comparison.png"/> <figcaption class="text-center">A comparison of memory and time saved using 8-bit and 32-bit optimizers.</figcaption></figure>',B,v,F,x,be="The stable embedding layer improves the training stability of the standard word embedding layer for NLP tasks. It addresses the challenge of non-uniform input distributions and mitigates extreme gradient variations. This means the stable embedding layer can support more aggressive quantization strategies without compromising training stability, and it can help achieve stable training outcomes, which is particularly important for models dealing with diverse and complex language data.",N,z,ge="There are three features of the stable embedding layer:",O,C,ye="<li>Initialization: utilizes Xavier uniform initialization to maintain consistent variance, reducing the likelihood of large gradients.</li> <li>Normalization: incorporates layer normalization before adding positional embeddings, aiding in output stability.</li> <li>Optimizer states: employs 32-bit optimizer states exclusively for this layer to enhance stability, while the rest of the model may use standard 16-bit precision.</li>",W,w,V,P,ve='Paged optimizers are built on top of the <a href="https://developer.nvidia.com/blog/unified-memory-cuda-beginners/" rel="nofollow">unified memory</a> feature of CUDA. Unified memory provides a single memory space the GPU and CPU can easily access. While this feature is not supported by PyTorch, it has been added to bitsandbytes.',R,_,xe="Paged optimizers works like regular CPU paging, which means that it <em>only becomes active if you run out of GPU memory</em>. When that happens, memory is transferred page-by-page from GPU to CPU. The memory is mapped, meaning that pages are pre-allocated on the CPU but they are not updated automatically. Pages are only updated if the memory is accessed or a swapping operation is launched.",X,T,ze="The unified memory feature is less efficient than regular asynchronous memory transfers, and you usually won’t be able to get full PCIe memory bandwidth utilization. If you do a manual prefetch, transfer speeds can be high but still only about half or worse than the full PCIe memory bandwidth (tested on 16x lanes PCIe 3.0).",J,$,Ce="This means performance depends highly on the particular use-case. For example, if you evict 1 GB of memory per forward-backward-optimizer loop, then you can expect about 50% of the PCIe bandwidth as time in the best case. So, 1 GB for PCIe 3.0 with 16x lanes would run at 16 GB/s, which is <code>1/(16*0.5) = 1/8 = 125ms</code> of overhead per optimizer step. Other overhead can be estimated for the particular use-case given a PCIe interface, lanes, and the memory evicted in each iteration.",K,q,we="Compared to CPU offloading, a paged optimizer has zero overhead if all the memory fits onto the device and only some overhead if some of memory needs to be evicted. For offloading, you usually offload fixed parts of the model and need to off and onload all this memory with each iteration through the model (sometimes twice for both forward and backward pass).",Q,k,Y;return u=new oe({props:{title:"8-bit optimizers",local:"8-bit-optimizers",headingTag:"h1"}}),v=new oe({props:{title:"Stable embedding layer",local:"stable-embedding-layer",headingTag:"h2"}}),w=new oe({props:{title:"Paged optimizers",local:"paged-optimizers",headingTag:"h2"}}),{c(){m=o("meta"),H=n(),L=o("p"),M=n(),ee(u.$$.fragment),U=n(),h=o("p"),h.textContent=re,I=n(),d=o("div"),d.innerHTML=me,G=n(),f=o("p"),f.textContent=de,S=n(),c=o("p"),c.textContent=pe,j=n(),b=o("ol"),b.innerHTML=ue,A=n(),g=o("p"),g.textContent=he,D=n(),y=o("p"),y.textContent=fe,E=n(),p=o("div"),p.innerHTML=ce,B=n(),ee(v.$$.fragment),F=n(),x=o("p"),x.textContent=be,N=n(),z=o("p"),z.textContent=ge,O=n(),C=o("ul"),C.innerHTML=ye,W=n(),ee(w.$$.fragment),V=n(),P=o("p"),P.innerHTML=ve,R=n(),_=o("p"),_.innerHTML=xe,X=n(),T=o("p"),T.textContent=ze,J=n(),$=o("p"),$.innerHTML=Ce,K=n(),q=o("p"),q.textContent=we,Q=n(),k=o("p"),this.h()},l(e){const t=ke("svelte-u9bgzb",document.head);m=l(t,"META",{name:!0,content:!0}),t.forEach(i),H=s(e),L=l(e,"P",{}),Pe(L).forEach(i),M=s(e),te(u.$$.fragment,e),U=s(e),h=l(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-xvqqf6"&&(h.textContent=re),I=s(e),d=l(e,"DIV",{class:!0,"data-svelte-h":!0}),r(d)!=="svelte-133ai6n"&&(d.innerHTML=me),G=s(e),f=l(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-dtecpb"&&(f.textContent=de),S=s(e),c=l(e,"P",{"data-svelte-h":!0}),r(c)!=="svelte-t1yq9c"&&(c.textContent=pe),j=s(e),b=l(e,"OL",{"data-svelte-h":!0}),r(b)!=="svelte-ixr27h"&&(b.innerHTML=ue),A=s(e),g=l(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1yk0ad"&&(g.textContent=he),D=s(e),y=l(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-i24tp8"&&(y.textContent=fe),E=s(e),p=l(e,"DIV",{class:!0,"data-svelte-h":!0}),r(p)!=="svelte-1ffqqa1"&&(p.innerHTML=ce),B=s(e),te(v.$$.fragment,e),F=s(e),x=l(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1cdjq6f"&&(x.textContent=be),N=s(e),z=l(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1xbcj8o"&&(z.textContent=ge),O=s(e),C=l(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-17lmhka"&&(C.innerHTML=ye),W=s(e),te(w.$$.fragment,e),V=s(e),P=l(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-phb6f5"&&(P.innerHTML=ve),R=s(e),_=l(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-71whgn"&&(_.innerHTML=xe),X=s(e),T=l(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1b4jzri"&&(T.textContent=ze),J=s(e),$=l(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1h5ow31"&&($.innerHTML=Ce),K=s(e),q=l(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ttez5b"&&(q.textContent=we),Q=s(e),k=l(e,"P",{}),Pe(k).forEach(i),this.h()},h(){Z(m,"name","hf:doc:metadata"),Z(m,"content",Ue),Z(d,"class","flex justify-center"),Z(p,"class","flex justify-center")},m(e,t){He(document.head,m),a(e,H,t),a(e,L,t),a(e,M,t),ie(u,e,t),a(e,U,t),a(e,h,t),a(e,I,t),a(e,d,t),a(e,G,t),a(e,f,t),a(e,S,t),a(e,c,t),a(e,j,t),a(e,b,t),a(e,A,t),a(e,g,t),a(e,D,t),a(e,y,t),a(e,E,t),a(e,p,t),a(e,B,t),ie(v,e,t),a(e,F,t),a(e,x,t),a(e,N,t),a(e,z,t),a(e,O,t),a(e,C,t),a(e,W,t),ie(w,e,t),a(e,V,t),a(e,P,t),a(e,R,t),a(e,_,t),a(e,X,t),a(e,T,t),a(e,J,t),a(e,$,t),a(e,K,t),a(e,q,t),a(e,Q,t),a(e,k,t),Y=!0},p:Te,i(e){Y||(ae(u.$$.fragment,e),ae(v.$$.fragment,e),ae(w.$$.fragment,e),Y=!0)},o(e){ne(u.$$.fragment,e),ne(v.$$.fragment,e),ne(w.$$.fragment,e),Y=!1},d(e){e&&(i(H),i(L),i(M),i(U),i(h),i(I),i(d),i(G),i(f),i(S),i(c),i(j),i(b),i(A),i(g),i(D),i(y),i(E),i(p),i(B),i(F),i(x),i(N),i(z),i(O),i(C),i(W),i(V),i(P),i(R),i(_),i(X),i(T),i(J),i($),i(K),i(q),i(Q),i(k)),i(m),se(u,e),se(v,e),se(w,e)}}}const Ue='{"title":"8-bit optimizers","local":"8-bit-optimizers","sections":[{"title":"Stable embedding layer","local":"stable-embedding-layer","sections":[],"depth":2},{"title":"Paged optimizers","local":"paged-optimizers","sections":[],"depth":2}],"depth":1}';function Ie(le){return $e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ae extends qe{constructor(m){super(),Le(this,m,Ie,Me,_e,{})}}export{Ae as component};
