# 混合推理

**通过混合推理赋能本地 AI 构建者**

> [!TIP]
> 混合推理是一项[实验性功能](https://huggingface.co/blog/remote_vae)。
> 可以在此处提供反馈[此处](https://github.com/huggingface/diffusers/issues/new?template=remote-vae-pilot-feedback.yml)。

## 为什么使用混合推理？

混合推理提供了一种快速简单的方式来卸载本地生成需求。

- 🚀 **降低要求：** 无需昂贵硬件即可访问强大模型。
- 💎 **无妥协：** 在不牺牲性能的情况下实现最高质量。
- 💰 **成本效益高：** 它是免费的！🤑
- 🎯 **多样化用例：** 与 Diffusers � 和更广泛的社区完全兼容。
- 🔧 **开发者友好：** 简单请求，快速响应。

---

## 可用模型

* **VAE 解码 🖼️：** 快速将潜在表示解码为高质量图像，不影响性能或工作流速度。
* **VAE 编码 🔢：** 高效将图像编码为潜在表示，用于生成和训练。
* **文本编码器 📃（即将推出）：** 快速准确地计算提示的文本嵌入，确保流畅高质量的工作流。

---

## 集成

* **[SD.Next](https://github.com/vladmandic/sdnext)：** 一体化 UI，直接支持混合推理。
* **[ComfyUI-HFRemoteVae](https://github.com/kijai/ComfyUI-HFRemoteVae)：** 用于混合推理的 ComfyUI 节点。

## 更新日志

- 2025 年 3 月 10 日：添加了 VAE 编码
- 2025 年 3 月 2 日：初始发布，包含 VAE 解码

## 内容

文档分为三个部分：

* **VAE 解码** 学习如何使用混合推理进行 VAE 解码的基础知识。
* **VAE 编码** 学习如何使用混合推理进行 VAE 编码的基础知识。
* **API 参考** 深入了解任务特定设置和参数。

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/zh/hybrid_inference/overview.md" />