import{s as Ke,n as Oe,o as el}from"../chunks/scheduler.32f3c0d7.js";import{S as ll,i as tl,e as a,s as i,c as o,h as sl,a as p,d as t,b as n,f as De,j as u,g as m,k as q,l as il,m as s,n as c,t as r,o as f,p as M}from"../chunks/index.a3055d2a.js";import{C as nl,H as _e,E as al}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2bbe216f.js";import{C as U}from"../chunks/CodeBlock.6764d584.js";function pl(Ie){let d,D,P,K,h,O,j,ee,J,Re='Diffusersは様々なタスクをこなすことができ、テキストから画像、画像から画像、画像の修復など、複数のタスクに対して同じように事前学習された重みを再利用することができます。しかし、ライブラリや拡散モデルに慣れていない場合、どのタスクにどのパイプラインを使えばいいのかがわかりにくいかもしれません。例えば、 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">stable-diffusion-v1-5/stable-diffusion-v1-5</a> チェックポイントをテキストから画像に変換するために使用している場合、それぞれ<code>StableDiffusionImg2ImgPipeline</code>クラスと<code>StableDiffusionInpaintPipeline</code>クラスでチェックポイントをロードすることで、画像から画像や画像の修復にも使えることを知らない可能性もあります。',le,w,ke="<code>AutoPipeline</code> クラスは、🤗 Diffusers の様々なパイプラインをよりシンプルするために設計されています。この汎用的でタスク重視のパイプラインによってタスクそのものに集中することができます。<code>AutoPipeline</code> は、使用するべき正しいパイプラインクラスを自動的に検出するため、特定のパイプラインクラス名を知らなくても、タスクのチェックポイントを簡単にロードできます。",te,y,Xe='<p>どのタスクがサポートされているかは、<a href="../api/pipelines/auto_pipeline">AutoPipeline</a> のリファレンスをご覧ください。現在、text-to-image、image-to-image、inpaintingをサポートしています。</p>',se,G,Fe="このチュートリアルでは、<code>AutoPipeline</code> を使用して、事前に学習された重みが与えられたときに、特定のタスクを読み込むためのパイプラインクラスを自動的に推測する方法を示します。",ie,W,ne,T,$e='まずはチェックポイントを選ぶことから始めましょう。例えば、 <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">stable-diffusion-v1-5/stable-diffusion-v1-5</a> チェックポイントでテキストから画像への変換したいなら、<code>AutoPipelineForText2Image</code>を使います:',ae,B,pe,b,xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-text2img.png" alt="generated image of peasant fighting dragon in wood cutting style"/>',me,v,Se="<code>AutoPipelineForText2Image</code> を具体的に見ていきましょう:",oe,V,Ce='<li><a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> ファイルから <code>&quot;stable-diffusion&quot;</code> クラスを自動的に検出します。</li> <li><code>&quot;stable-diffusion&quot;</code> のクラス名に基づいて、テキストから画像へ変換する <code>StableDiffusionPipeline</code> を読み込みます。</li>',ue,_,He="同様に、画像から画像へ変換する場合、<code>AutoPipelineForImage2Image</code> は <code>model_index.json</code> ファイルから <code>&quot;stable-diffusion&quot;</code> チェックポイントを検出し、対応する <code>StableDiffusionImg2ImgPipeline</code> を読み込みます。また、入力画像にノイズの量やバリエーションの追加を決めるための強さなど、パイプラインクラスに固有の追加引数を渡すこともできます:",ce,I,re,Z,Ye='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-img2img.png" alt="generated image of a vermeer portrait of a dog wearing a pearl earring"/>',fe,R,Qe="また、画像の修復を行いたい場合は、 <code>AutoPipelineForInpainting</code> が、同様にベースとなる<code>StableDiffusionInpaintPipeline</code>クラスを読み込みます：",Me,k,de,g,ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/autopipeline-inpaint.png" alt="generated image of a tiger sitting on a bench"/>',ye,X,Ee="サポートされていないチェックポイントを読み込もうとすると、エラーになります:",be,F,Ze,$,ge,x,Ae='いくつかのワークフローや多くのパイプラインを読み込む場合、不要なメモリを使ってしまう再読み込みをするよりも、チェックポイントから同じコンポーネントを再利用する方がメモリ効率が良いです。たとえば、テキストから画像への変換にチェックポイントを使い、画像から画像への変換にまたチェックポイントを使いたい場合、<a href="https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe" rel="nofollow">from_pipe()</a> メソッドを使用します。このメソッドは、以前読み込まれたパイプラインのコンポーネントを使うことで追加のメモリを消費することなく、新しいパイプラインを作成します。',Ue,S,Le='<a href="https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe" rel="nofollow">from_pipe()</a> メソッドは、元のパイプラインクラスを検出し、実行したいタスクに対応する新しいパイプラインクラスにマッピングします。例えば、テキストから画像への<code>&quot;stable-diffusion&quot;</code> クラスのパイプラインを読み込む場合：',he,C,je,H,qe='そして、[from_pipe()] (<a href="https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe)%E3%81%AF%E3%80%81%E3%82%82%E3%81%A8%E3%81%AE%60%22stable-diffusion%22%60" rel="nofollow">https://huggingface.co/docs/diffusers/v0.25.1/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image.from_pipe)は、もとの`“stable-diffusion”`</a> パイプラインのクラスである <code>StableDiffusionImg2ImgPipeline</code> にマップします:',Je,Y,we,Q,Pe="元のパイプラインにオプションとして引数（セーフティチェッカーの無効化など）を渡した場合、この引数も新しいパイプラインに渡されます:",Ge,z,We,E,Ne="新しいパイプラインの動作を変更したい場合は、元のパイプラインの引数や設定を上書きすることができます。例えば、セーフティチェッカーをオンに戻し、<code>strength</code> 引数を追加します:",Te,A,Be,L,ve,N,Ve;return h=new nl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new _e({props:{title:"AutoPipeline",local:"autopipeline",headingTag:"h1"}}),W=new _e({props:{title:"タスクに合わせてAutoPipeline を選択する",local:"タスクに合わせてautopipeline-を選択する",headingTag:"h2"}}),B=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSkudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJwZWFzYW50JTIwYW5kJTIwZHJhZ29uJTIwY29tYmF0JTJDJTIwd29vZCUyMGN1dHRpbmclMjBzdHlsZSUyQyUyMHZpa2luZyUyMGVyYSUyQyUyMGJldmVsJTIwd2l0aCUyMHJ1bmUlMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;peasant and dragon combat, wood cutting style, viking era, bevel with rune&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),I=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwb3J0cmFpdCUyMG9mJTIwYSUyMGRvZyUyMHdlYXJpbmclMjBhJTIwcGVhcmwlMjBlYXJyaW5nJTIyJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cGxvYWQud2lraW1lZGlhLm9yZyUyRndpa2lwZWRpYSUyRmNvbW1vbnMlMkZ0aHVtYiUyRjAlMkYwZiUyRjE2NjVfR2lybF93aXRoX2FfUGVhcmxfRWFycmluZy5qcGclMkY4MDBweC0xNjY1X0dpcmxfd2l0aF9hX1BlYXJsX0VhcnJpbmcuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbWFnZS50aHVtYm5haWwoKDc2OCUyQyUyMDc2OCkpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMDAlMkMlMjBzdHJlbmd0aCUzRDAuNzUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEwLjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a portrait of a dog wearing a pearl earring&quot;</span>

url = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/0/0f/1665_Girl_with_a_Pearl_Earring.jpg/800px-1665_Girl_with_a_Pearl_Earring.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipeline(prompt, image, num_inference_steps=<span class="hljs-number">200</span>, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),k=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBbWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBtYWplc3RpYyUyMHRpZ2VyJTIwc2l0dGluZyUyMG9uJTIwYSUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMHN0cmVuZ3RoJTNEMC44MCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
image = pipeline(prompt, image=init_image, mask_image=mask_image, num_inference_steps=<span class="hljs-number">50</span>, strength=<span class="hljs-number">0.80</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),F=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZzaGFwLWUtaW1nMmltZyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIyVmFsdWVFcnJvciUzQSUyMEF1dG9QaXBlbGluZSUyMGNhbid0JTIwZmluZCUyMGElMjBwaXBlbGluZSUyMGxpbmtlZCUyMHRvJTIwU2hhcEVJbWcySW1nUGlwZWxpbmUlMjBmb3IlMjBOb25lJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;openai/shap-e-img2img&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-string">&quot;ValueError: AutoPipeline can&#x27;t find a pipeline linked to ShapEImg2ImgPipeline for None&quot;</span>`,wrap:!1}}),$=new _e({props:{title:"複数のパイプラインを使用する",local:"複数のパイプラインを使用する",headingTag:"h2"}}),C=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmVfdGV4dDJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXByaW50KHR5cGUocGlwZWxpbmVfdGV4dDJpbWcpKSUwQSUyMiUzQ2NsYXNzJTIwJ2RpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9zdGFibGVfZGlmZnVzaW9uLlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJyUzRSUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_text2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt;&quot;</span>`,wrap:!1}}),Y=new U({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyklMEFwcmludCh0eXBlKHBpcGVsaW5lX2ltZzJpbWcpKSUwQSUyMiUzQ2NsYXNzJTIwJ2RpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9zdGFibGVfZGlmZnVzaW9uX2ltZzJpbWcuU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJyUzRSUyMg==",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">type</span>(pipeline_img2img))
<span class="hljs-string">&quot;&lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion_img2img.StableDiffusionImg2ImgPipeline&#x27;&gt;&quot;</span>`,wrap:!1}}),z=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmVfdGV4dDJpbWclMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmVxdWlyZXNfc2FmZXR5X2NoZWNrZXIlM0RGYWxzZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlbGluZV9pbWcyaW1nJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3RleHQyaW1nKSUwQXByaW50KHBpcGVsaW5lX2ltZzJpbWcuY29uZmlnLnJlcXVpcmVzX3NhZmV0eV9jaGVja2VyKSUwQSUyMkZhbHNlJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2img = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img)
<span class="hljs-built_in">print</span>(pipeline_img2img.config.requires_safety_checker)
<span class="hljs-string">&quot;False&quot;</span>`,wrap:!1}}),A=new U({props:{code:"cGlwZWxpbmVfaW1nMmltZyUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltZyUyQyUyMHJlcXVpcmVzX3NhZmV0eV9jaGVja2VyJTNEVHJ1ZSUyQyUyMHN0cmVuZ3RoJTNEMC4zKSUwQXByaW50KHBpcGVsaW5lX2ltZzJpbWcuY29uZmlnLnJlcXVpcmVzX3NhZmV0eV9jaGVja2VyKSUwQSUyMlRydWUlMjI=",highlighted:`pipeline_img2img = AutoPipelineForImage2Image.from_pipe(pipeline_text2img, requires_safety_checker=<span class="hljs-literal">True</span>, strength=<span class="hljs-number">0.3</span>)
<span class="hljs-built_in">print</span>(pipeline_img2img.config.requires_safety_checker)
<span class="hljs-string">&quot;True&quot;</span>`,wrap:!1}}),L=new al({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ja/tutorials/autopipeline.md"}}),{c(){d=a("meta"),D=i(),P=a("p"),K=i(),o(h.$$.fragment),O=i(),o(j.$$.fragment),ee=i(),J=a("p"),J.innerHTML=Re,le=i(),w=a("p"),w.innerHTML=ke,te=i(),y=a("blockquote"),y.innerHTML=Xe,se=i(),G=a("p"),G.innerHTML=Fe,ie=i(),o(W.$$.fragment),ne=i(),T=a("p"),T.innerHTML=$e,ae=i(),o(B.$$.fragment),pe=i(),b=a("div"),b.innerHTML=xe,me=i(),v=a("p"),v.innerHTML=Se,oe=i(),V=a("ol"),V.innerHTML=Ce,ue=i(),_=a("p"),_.innerHTML=He,ce=i(),o(I.$$.fragment),re=i(),Z=a("div"),Z.innerHTML=Ye,fe=i(),R=a("p"),R.innerHTML=Qe,Me=i(),o(k.$$.fragment),de=i(),g=a("div"),g.innerHTML=ze,ye=i(),X=a("p"),X.textContent=Ee,be=i(),o(F.$$.fragment),Ze=i(),o($.$$.fragment),ge=i(),x=a("p"),x.innerHTML=Ae,Ue=i(),S=a("p"),S.innerHTML=Le,he=i(),o(C.$$.fragment),je=i(),H=a("p"),H.innerHTML=qe,Je=i(),o(Y.$$.fragment),we=i(),Q=a("p"),Q.textContent=Pe,Ge=i(),o(z.$$.fragment),We=i(),E=a("p"),E.innerHTML=Ne,Te=i(),o(A.$$.fragment),Be=i(),o(L.$$.fragment),ve=i(),N=a("p"),this.h()},l(e){const l=sl("svelte-u9bgzb",document.head);d=p(l,"META",{name:!0,content:!0}),l.forEach(t),D=n(e),P=p(e,"P",{}),De(P).forEach(t),K=n(e),u(h.$$.fragment,e),O=n(e),u(j.$$.fragment,e),ee=n(e),J=p(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-qai92n"&&(J.innerHTML=Re),le=n(e),w=p(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-bhmuwk"&&(w.innerHTML=ke),te=n(e),y=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(y)!=="svelte-1615jnz"&&(y.innerHTML=Xe),se=n(e),G=p(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-fxxxlv"&&(G.innerHTML=Fe),ie=n(e),u(W.$$.fragment,e),ne=n(e),T=p(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1l9b5y1"&&(T.innerHTML=$e),ae=n(e),u(B.$$.fragment,e),pe=n(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-1yzwly4"&&(b.innerHTML=xe),me=n(e),v=p(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-bx1qu8"&&(v.innerHTML=Se),oe=n(e),V=p(e,"OL",{"data-svelte-h":!0}),m(V)!=="svelte-j698gc"&&(V.innerHTML=Ce),ue=n(e),_=p(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1tv7o7j"&&(_.innerHTML=He),ce=n(e),u(I.$$.fragment,e),re=n(e),Z=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(Z)!=="svelte-9fi2fw"&&(Z.innerHTML=Ye),fe=n(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1a50jb8"&&(R.innerHTML=Qe),Me=n(e),u(k.$$.fragment,e),de=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(g)!=="svelte-1id5o5z"&&(g.innerHTML=ze),ye=n(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1iuzdt9"&&(X.textContent=Ee),be=n(e),u(F.$$.fragment,e),Ze=n(e),u($.$$.fragment,e),ge=n(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-q2xv6p"&&(x.innerHTML=Ae),Ue=n(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-mczuk5"&&(S.innerHTML=Le),he=n(e),u(C.$$.fragment,e),je=n(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-5m0bbd"&&(H.innerHTML=qe),Je=n(e),u(Y.$$.fragment,e),we=n(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1m19tqu"&&(Q.textContent=Pe),Ge=n(e),u(z.$$.fragment,e),We=n(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1vu2fjh"&&(E.innerHTML=Ne),Te=n(e),u(A.$$.fragment,e),Be=n(e),u(L.$$.fragment,e),ve=n(e),N=p(e,"P",{}),De(N).forEach(t),this.h()},h(){q(d,"name","hf:doc:metadata"),q(d,"content",ml),q(y,"class","tip"),q(b,"class","flex justify-center"),q(Z,"class","flex justify-center"),q(g,"class","flex justify-center")},m(e,l){il(document.head,d),s(e,D,l),s(e,P,l),s(e,K,l),c(h,e,l),s(e,O,l),c(j,e,l),s(e,ee,l),s(e,J,l),s(e,le,l),s(e,w,l),s(e,te,l),s(e,y,l),s(e,se,l),s(e,G,l),s(e,ie,l),c(W,e,l),s(e,ne,l),s(e,T,l),s(e,ae,l),c(B,e,l),s(e,pe,l),s(e,b,l),s(e,me,l),s(e,v,l),s(e,oe,l),s(e,V,l),s(e,ue,l),s(e,_,l),s(e,ce,l),c(I,e,l),s(e,re,l),s(e,Z,l),s(e,fe,l),s(e,R,l),s(e,Me,l),c(k,e,l),s(e,de,l),s(e,g,l),s(e,ye,l),s(e,X,l),s(e,be,l),c(F,e,l),s(e,Ze,l),c($,e,l),s(e,ge,l),s(e,x,l),s(e,Ue,l),s(e,S,l),s(e,he,l),c(C,e,l),s(e,je,l),s(e,H,l),s(e,Je,l),c(Y,e,l),s(e,we,l),s(e,Q,l),s(e,Ge,l),c(z,e,l),s(e,We,l),s(e,E,l),s(e,Te,l),c(A,e,l),s(e,Be,l),c(L,e,l),s(e,ve,l),s(e,N,l),Ve=!0},p:Oe,i(e){Ve||(r(h.$$.fragment,e),r(j.$$.fragment,e),r(W.$$.fragment,e),r(B.$$.fragment,e),r(I.$$.fragment,e),r(k.$$.fragment,e),r(F.$$.fragment,e),r($.$$.fragment,e),r(C.$$.fragment,e),r(Y.$$.fragment,e),r(z.$$.fragment,e),r(A.$$.fragment,e),r(L.$$.fragment,e),Ve=!0)},o(e){f(h.$$.fragment,e),f(j.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(I.$$.fragment,e),f(k.$$.fragment,e),f(F.$$.fragment,e),f($.$$.fragment,e),f(C.$$.fragment,e),f(Y.$$.fragment,e),f(z.$$.fragment,e),f(A.$$.fragment,e),f(L.$$.fragment,e),Ve=!1},d(e){e&&(t(D),t(P),t(K),t(O),t(ee),t(J),t(le),t(w),t(te),t(y),t(se),t(G),t(ie),t(ne),t(T),t(ae),t(pe),t(b),t(me),t(v),t(oe),t(V),t(ue),t(_),t(ce),t(re),t(Z),t(fe),t(R),t(Me),t(de),t(g),t(ye),t(X),t(be),t(Ze),t(ge),t(x),t(Ue),t(S),t(he),t(je),t(H),t(Je),t(we),t(Q),t(Ge),t(We),t(E),t(Te),t(Be),t(ve),t(N)),t(d),M(h,e),M(j,e),M(W,e),M(B,e),M(I,e),M(k,e),M(F,e),M($,e),M(C,e),M(Y,e),M(z,e),M(A,e),M(L,e)}}}const ml='{"title":"AutoPipeline","local":"autopipeline","sections":[{"title":"タスクに合わせてAutoPipeline を選択する","local":"タスクに合わせてautopipeline-を選択する","sections":[],"depth":2},{"title":"複数のパイプラインを使用する","local":"複数のパイプラインを使用する","sections":[],"depth":2}],"depth":1}';function ol(Ie){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ml extends ll{constructor(d){super(),tl(this,d,ol,pl,Ke,{})}}export{Ml as component};
