# Video Processor

The `VideoProcessor` provides a unified API for video pipelines to prepare inputs for VAE encoding and post-processing outputs once they're decoded. The class inherits `VaeImageProcessor` so it includes transformations such as resizing, normalization, and conversion between PIL Image, PyTorch, and NumPy arrays.

## VideoProcessor[[diffusers.video_processor.VideoProcessor.preprocess_video]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.video_processor.VideoProcessor.preprocess_video</name><anchor>diffusers.video_processor.VideoProcessor.preprocess_video</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/video_processor.py#L29</source><parameters>[{"name": "video", "val": ""}, {"name": "height", "val": ": typing.Optional[int] = None"}, {"name": "width", "val": ": typing.Optional[int] = None"}]</parameters><paramsdesc>- **video** (`List[PIL.Image]`, `List[List[PIL.Image]]`, `torch.Tensor`, `np.array`, `List[torch.Tensor]`, `List[np.array]`) --
  The input video. It can be one of the following:
  * List of the PIL images.
  * List of list of PIL images.
  * 4D Torch tensors (expected shape for each tensor `(num_frames, num_channels, height, width)`).
  * 4D NumPy arrays (expected shape for each array `(num_frames, height, width, num_channels)`).
  * List of 4D Torch tensors (expected shape for each tensor `(num_frames, num_channels, height,
    width)`).
  * List of 4D NumPy arrays (expected shape for each array `(num_frames, height, width, num_channels)`).
  * 5D NumPy arrays: expected shape for each array `(batch_size, num_frames, height, width,
    num_channels)`.
  * 5D Torch tensors: expected shape for each array `(batch_size, num_frames, num_channels, height,
    width)`.
- **height** (`int`, *optional*, defaults to `None`) --
  The height in preprocessed frames of the video. If `None`, will use the `get_default_height_width()` to
  get default height.
- **width** (`int`, *optional*`, defaults to `None`) --
  The width in preprocessed frames of the video. If `None`, will use get_default_height_width()` to get
  the default width.</paramsdesc><paramgroups>0</paramgroups></docstring>

Preprocesses input video(s).




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>diffusers.video_processor.VideoProcessor.postprocess_video</name><anchor>diffusers.video_processor.VideoProcessor.postprocess_video</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/video_processor.py#L90</source><parameters>[{"name": "video", "val": ": Tensor"}, {"name": "output_type", "val": ": str = 'np'"}]</parameters><paramsdesc>- **video** (`torch.Tensor`) -- The video as a tensor.
- **output_type** (`str`, defaults to `"np"`) -- Output type of the postprocessed `video` tensor.</paramsdesc><paramgroups>0</paramgroups></docstring>

Converts a video tensor to a list of frames for export.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/video_processor.md" />