# DPMSolverMultistepInverse

`DPMSolverMultistepInverse` is the inverted scheduler from [DPM-Solver: A Fast ODE Solver for Diffusion Probabilistic Model Sampling in Around 10 Steps](https://huggingface.co/papers/2206.00927) and [DPM-Solver++: Fast Solver for Guided Sampling of Diffusion Probabilistic Models](https://huggingface.co/papers/2211.01095) by Cheng Lu, Yuhao Zhou, Fan Bao, Jianfei Chen, Chongxuan Li, and Jun Zhu.

The implementation is mostly based on the DDIM inversion definition of [Null-text Inversion for Editing Real Images using Guided Diffusion Models](https://huggingface.co/papers/2211.09794) and notebook implementation of the `DiffEdit` latent inversion from [Xiang-cd/DiffEdit-stable-diffusion](https://github.com/Xiang-cd/DiffEdit-stable-diffusion/blob/main/diffedit.ipynb).

## Tips

Dynamic thresholding from [Imagen](https://huggingface.co/papers/2205.11487) is supported, and for pixel-space
diffusion models, you can set both `algorithm_type="dpmsolver++"` and `thresholding=True` to use the dynamic
thresholding. This thresholding method is unsuitable for latent-space diffusion models such as
Stable Diffusion.

## DPMSolverMultistepInverseScheduler[[diffusers.DPMSolverMultistepInverseScheduler]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.DPMSolverMultistepInverseScheduler</name><anchor>diffusers.DPMSolverMultistepInverseScheduler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep_inverse.py#L78</source><parameters>[{"name": "num_train_timesteps", "val": ": int = 1000"}, {"name": "beta_start", "val": ": float = 0.0001"}, {"name": "beta_end", "val": ": float = 0.02"}, {"name": "beta_schedule", "val": ": str = 'linear'"}, {"name": "trained_betas", "val": ": typing.Union[numpy.ndarray, typing.List[float], NoneType] = None"}, {"name": "solver_order", "val": ": int = 2"}, {"name": "prediction_type", "val": ": str = 'epsilon'"}, {"name": "thresholding", "val": ": bool = False"}, {"name": "dynamic_thresholding_ratio", "val": ": float = 0.995"}, {"name": "sample_max_value", "val": ": float = 1.0"}, {"name": "algorithm_type", "val": ": str = 'dpmsolver++'"}, {"name": "solver_type", "val": ": str = 'midpoint'"}, {"name": "lower_order_final", "val": ": bool = True"}, {"name": "euler_at_final", "val": ": bool = False"}, {"name": "use_karras_sigmas", "val": ": typing.Optional[bool] = False"}, {"name": "use_exponential_sigmas", "val": ": typing.Optional[bool] = False"}, {"name": "use_beta_sigmas", "val": ": typing.Optional[bool] = False"}, {"name": "use_flow_sigmas", "val": ": typing.Optional[bool] = False"}, {"name": "flow_shift", "val": ": typing.Optional[float] = 1.0"}, {"name": "lambda_min_clipped", "val": ": float = -inf"}, {"name": "variance_type", "val": ": typing.Optional[str] = None"}, {"name": "timestep_spacing", "val": ": str = 'linspace'"}, {"name": "steps_offset", "val": ": int = 0"}]</parameters><paramsdesc>- **num_train_timesteps** (`int`, defaults to 1000) --
  The number of diffusion steps to train the model.
- **beta_start** (`float`, defaults to 0.0001) --
  The starting `beta` value of inference.
- **beta_end** (`float`, defaults to 0.02) --
  The final `beta` value.
- **beta_schedule** (`str`, defaults to `"linear"`) --
  The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
  `linear`, `scaled_linear`, or `squaredcos_cap_v2`.
- **trained_betas** (`np.ndarray`, *optional*) --
  Pass an array of betas directly to the constructor to bypass `beta_start` and `beta_end`.
- **solver_order** (`int`, defaults to 2) --
  The DPMSolver order which can be `1` or `2` or `3`. It is recommended to use `solver_order=2` for guided
  sampling, and `solver_order=3` for unconditional sampling.
- **prediction_type** (`str`, defaults to `epsilon`, *optional*) --
  Prediction type of the scheduler function; can be `epsilon` (predicts the noise of the diffusion process),
  `sample` (directly predicts the noisy sample`) or `v_prediction` (see section 2.4 of [Imagen
  Video](https://imagen.research.google/video/paper.pdf) paper).
- **thresholding** (`bool`, defaults to `False`) --
  Whether to use the "dynamic thresholding" method. This is unsuitable for latent-space diffusion models such
  as Stable Diffusion.
- **dynamic_thresholding_ratio** (`float`, defaults to 0.995) --
  The ratio for the dynamic thresholding method. Valid only when `thresholding=True`.
- **sample_max_value** (`float`, defaults to 1.0) --
  The threshold value for dynamic thresholding. Valid only when `thresholding=True` and
  `algorithm_type="dpmsolver++"`.
- **algorithm_type** (`str`, defaults to `dpmsolver++`) --
  Algorithm type for the solver; can be `dpmsolver`, `dpmsolver++`, `sde-dpmsolver` or `sde-dpmsolver++`. The
  `dpmsolver` type implements the algorithms in the [DPMSolver](https://huggingface.co/papers/2206.00927)
  paper, and the `dpmsolver++` type implements the algorithms in the
  [DPMSolver++](https://huggingface.co/papers/2211.01095) paper. It is recommended to use `dpmsolver++` or
  `sde-dpmsolver++` with `solver_order=2` for guided sampling like in Stable Diffusion.
- **solver_type** (`str`, defaults to `midpoint`) --
  Solver type for the second-order solver; can be `midpoint` or `heun`. The solver type slightly affects the
  sample quality, especially for a small number of steps. It is recommended to use `midpoint` solvers.
- **lower_order_final** (`bool`, defaults to `True`) --
  Whether to use lower-order solvers in the final steps. Only valid for < 15 inference steps. This can
  stabilize the sampling of DPMSolver for steps < 15, especially for steps <= 10.
- **euler_at_final** (`bool`, defaults to `False`) --
  Whether to use Euler's method in the final step. It is a trade-off between numerical stability and detail
  richness. This can stabilize the sampling of the SDE variant of DPMSolver for small number of inference
  steps, but sometimes may result in blurring.
- **use_karras_sigmas** (`bool`, *optional*, defaults to `False`) --
  Whether to use Karras sigmas for step sizes in the noise schedule during the sampling process. If `True`,
  the sigmas are determined according to a sequence of noise levels {σi}.
- **use_exponential_sigmas** (`bool`, *optional*, defaults to `False`) --
  Whether to use exponential sigmas for step sizes in the noise schedule during the sampling process.
- **use_beta_sigmas** (`bool`, *optional*, defaults to `False`) --
  Whether to use beta sigmas for step sizes in the noise schedule during the sampling process. Refer to [Beta
  Sampling is All You Need](https://huggingface.co/papers/2407.12173) for more information.
- **lambda_min_clipped** (`float`, defaults to `-inf`) --
  Clipping threshold for the minimum value of `lambda(t)` for numerical stability. This is critical for the
  cosine (`squaredcos_cap_v2`) noise schedule.
- **variance_type** (`str`, *optional*) --
  Set to "learned" or "learned_range" for diffusion models that predict variance. If set, the model's output
  contains the predicted Gaussian variance.
- **timestep_spacing** (`str`, defaults to `"linspace"`) --
  The way the timesteps should be scaled. Refer to Table 2 of the [Common Diffusion Noise Schedules and
  Sample Steps are Flawed](https://huggingface.co/papers/2305.08891) for more information.
- **steps_offset** (`int`, defaults to 0) --
  An offset added to the inference steps, as required by some model families.</paramsdesc><paramgroups>0</paramgroups></docstring>

`DPMSolverMultistepInverseScheduler` is the reverse scheduler of [DPMSolverMultistepScheduler](/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler).

This model inherits from [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) and [ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin). Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>convert_model_output</name><anchor>diffusers.DPMSolverMultistepInverseScheduler.convert_model_output</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep_inverse.py#L482</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "*args", "val": ""}, {"name": "sample", "val": ": Tensor = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from the learned diffusion model.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>The converted model output.</retdesc></docstring>

Convert the model output to the corresponding type the DPMSolver/DPMSolver++ algorithm needs. DPM-Solver is
designed to discretize an integral of the noise prediction model, and DPM-Solver++ is designed to discretize an
integral of the data prediction model.

> [!TIP] > The algorithm and model type are decoupled. You can use either DPMSolver or DPMSolver++ for both
noise > prediction and data prediction models.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>dpm_solver_first_order_update</name><anchor>diffusers.DPMSolverMultistepInverseScheduler.dpm_solver_first_order_update</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep_inverse.py#L581</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "*args", "val": ""}, {"name": "sample", "val": ": Tensor = None"}, {"name": "noise", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from the learned diffusion model.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>The sample tensor at the previous timestep.</retdesc></docstring>

One step for the first-order DPMSolver (equivalent to DDIM).








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>multistep_dpm_solver_second_order_update</name><anchor>diffusers.DPMSolverMultistepInverseScheduler.multistep_dpm_solver_second_order_update</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep_inverse.py#L651</source><parameters>[{"name": "model_output_list", "val": ": typing.List[torch.Tensor]"}, {"name": "*args", "val": ""}, {"name": "sample", "val": ": Tensor = None"}, {"name": "noise", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **model_output_list** (`List[torch.Tensor]`) --
  The direct outputs from learned diffusion model at current and latter timesteps.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>The sample tensor at the previous timestep.</retdesc></docstring>

One step for the second-order multistep DPMSolver.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>multistep_dpm_solver_third_order_update</name><anchor>diffusers.DPMSolverMultistepInverseScheduler.multistep_dpm_solver_third_order_update</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep_inverse.py#L775</source><parameters>[{"name": "model_output_list", "val": ": typing.List[torch.Tensor]"}, {"name": "*args", "val": ""}, {"name": "sample", "val": ": Tensor = None"}, {"name": "noise", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **model_output_list** (`List[torch.Tensor]`) --
  The direct outputs from learned diffusion model at current and latter timesteps.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by diffusion process.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>The sample tensor at the previous timestep.</retdesc></docstring>

One step for the third-order multistep DPMSolver.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_model_input</name><anchor>diffusers.DPMSolverMultistepInverseScheduler.scale_model_input</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep_inverse.py#L972</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The input sample.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>A scaled input sample.</retdesc></docstring>

Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_timesteps</name><anchor>diffusers.DPMSolverMultistepInverseScheduler.set_timesteps</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep_inverse.py#L245</source><parameters>[{"name": "num_inference_steps", "val": ": int = None"}, {"name": "device", "val": ": typing.Union[str, torch.device] = None"}]</parameters><paramsdesc>- **num_inference_steps** (`int`) --
  The number of diffusion steps used when generating samples with a pre-trained model.
- **device** (`str` or `torch.device`, *optional*) --
  The device to which the timesteps should be moved to. If `None`, the timesteps are not moved.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the discrete timesteps used for the diffusion chain (to be run before inference).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>diffusers.DPMSolverMultistepInverseScheduler.step</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_dpmsolver_multistep_inverse.py#L889</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Union[int, torch.Tensor]"}, {"name": "sample", "val": ": Tensor"}, {"name": "generator", "val": " = None"}, {"name": "variance_noise", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from learned diffusion model.
- **timestep** (`int`) --
  The current discrete timestep in the diffusion chain.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.
- **generator** (`torch.Generator`, *optional*) --
  A random number generator.
- **variance_noise** (`torch.Tensor`) --
  Alternative to generating noise with `generator` by directly providing the noise for the variance
  itself. Useful for methods such as `CycleDiffusion`.
- **return_dict** (`bool`) --
  Whether or not to return a [SchedulerOutput](/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput) or `tuple`.</paramsdesc><paramgroups>0</paramgroups><rettype>[SchedulerOutput](/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput) or `tuple`</rettype><retdesc>If return_dict is `True`, [SchedulerOutput](/docs/diffusers/main/en/api/schedulers/pndm#diffusers.schedulers.scheduling_utils.SchedulerOutput) is returned, otherwise a
tuple is returned where the first element is the sample tensor.</retdesc></docstring>

Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the multistep DPMSolver.








</div></div>

## SchedulerOutput[[diffusers.schedulers.scheduling_utils.SchedulerOutput]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.schedulers.scheduling_utils.SchedulerOutput</name><anchor>diffusers.schedulers.scheduling_utils.SchedulerOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_utils.py#L62</source><parameters>[{"name": "prev_sample", "val": ": Tensor"}]</parameters><paramsdesc>- **prev_sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` for images) --
  Computed sample `(x_{t-1})` of previous timestep. `prev_sample` should be used as next model input in the
  denoising loop.</paramsdesc><paramgroups>0</paramgroups></docstring>

Base class for the output of a scheduler's `step` function.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/multistep_dpm_solver_inverse.md" />