# Kandinsky 5.0 Video

Kandinsky 5.0 Video is created by the Kandinsky team: Alexey Letunovskiy, Maria Kovaleva, Ivan Kirillov, Lev Novitskiy, Denis Koposov, Dmitrii Mikhailov, Anna Averchenkova, Andrey Shutkin, Julia Agafonova, Olga Kim, Anastasiia Kargapoltseva, Nikita Kiselev, Anna Dmitrienko,  Anastasia Maltseva, Kirill Chernyshev, Ilia Vasiliev, Viacheslav Vasilev, Vladimir Polovnikov, Yury Kolabushin, Alexander Belykh, Mikhail Mamaev, Anastasia Aliaskina, Tatiana Nikulina, Polina Gavrilova, Vladimir Arkhipkin, Vladimir Korviakov, Nikolai Gerasimenko, Denis Parkhomenko, Denis Dimitrov


Kandinsky 5.0 is a family of diffusion models for Video & Image generation. Kandinsky 5.0 T2V Lite is a lightweight video generation model (2B parameters) that ranks #1 among open-source models in its class. It outperforms larger models and offers the best understanding of Russian concepts in the open-source ecosystem.

The model introduces several key innovations:
- **Latent diffusion pipeline** with **Flow Matching** for improved training stability
- **Diffusion Transformer (DiT)** as the main generative backbone with cross-attention to text embeddings
- Dual text encoding using **Qwen2.5-VL** and **CLIP** for comprehensive text understanding
- **HunyuanVideo 3D VAE** for efficient video encoding and decoding
- **Sparse attention mechanisms** (NABLA) for efficient long-sequence processing

The original codebase can be found at [ai-forever/Kandinsky-5](https://github.com/ai-forever/Kandinsky-5).

> [!TIP]
> Check out the [AI Forever](https://huggingface.co/ai-forever) organization on the Hub for the official model checkpoints for text-to-video generation, including pretrained, SFT, no-CFG, and distilled variants.

## Available Models

Kandinsky 5.0 T2V Lite comes in several variants optimized for different use cases:

| model_id | Description | Use Cases |
|------------|-------------|-----------|
| **ai-forever/Kandinsky-5.0-T2V-Lite-sft-5s-Diffusers** | 5 second Supervised Fine-Tuned model | Highest generation quality |
| **ai-forever/Kandinsky-5.0-T2V-Lite-sft-10s-Diffusers** | 10 second Supervised Fine-Tuned model | Highest generation quality |
| **ai-forever/Kandinsky-5.0-T2V-Lite-nocfg-5s-Diffusers** | 5 second Classifier-Free Guidance distilled | 2× faster inference |
| **ai-forever/Kandinsky-5.0-T2V-Lite-nocfg-10s-Diffusers** | 10 second Classifier-Free Guidance distilled | 2× faster inference |
| **ai-forever/Kandinsky-5.0-T2V-Lite-distilled16steps-5s-Diffusers** | 5 second Diffusion distilled to 16 steps | 6× faster inference, minimal quality loss |
| **ai-forever/Kandinsky-5.0-T2V-Lite-distilled16steps-10s-Diffusers** | 10 second Diffusion distilled to 16 steps | 6× faster inference, minimal quality loss |
| **ai-forever/Kandinsky-5.0-T2V-Lite-pretrain-5s-Diffusers** | 5 second Base pretrained model | Research and fine-tuning |
| **ai-forever/Kandinsky-5.0-T2V-Lite-pretrain-10s-Diffusers** | 10 second Base pretrained model | Research and fine-tuning |

All models are available in 5-second and 10-second video generation versions.

## Kandinsky5T2VPipeline[[diffusers.Kandinsky5T2VPipeline]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.Kandinsky5T2VPipeline</name><anchor>diffusers.Kandinsky5T2VPipeline</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky5/pipeline_kandinsky.py#L107</source><parameters>[{"name": "transformer", "val": ": Kandinsky5Transformer3DModel"}, {"name": "vae", "val": ": AutoencoderKLHunyuanVideo"}, {"name": "text_encoder", "val": ": Qwen2_5_VLForConditionalGeneration"}, {"name": "tokenizer", "val": ": Qwen2VLProcessor"}, {"name": "text_encoder_2", "val": ": CLIPTextModel"}, {"name": "tokenizer_2", "val": ": CLIPTokenizer"}, {"name": "scheduler", "val": ": FlowMatchEulerDiscreteScheduler"}]</parameters><paramsdesc>- **transformer** (`Kandinsky5Transformer3DModel`) --
  Conditional Transformer to denoise the encoded video latents.
- **vae** ([AutoencoderKLHunyuanVideo](/docs/diffusers/main/en/api/models/autoencoder_kl_hunyuan_video#diffusers.AutoencoderKLHunyuanVideo)) --
  Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.
- **text_encoder** (`Qwen2_5_VLForConditionalGeneration`) --
  Frozen text-encoder (Qwen2.5-VL).
- **tokenizer** (`AutoProcessor`) --
  Tokenizer for Qwen2.5-VL.
- **text_encoder_2** (`CLIPTextModel`) --
  Frozen CLIP text encoder.
- **tokenizer_2** (`CLIPTokenizer`) --
  Tokenizer for CLIP.
- **scheduler** ([FlowMatchEulerDiscreteScheduler](/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler)) --
  A scheduler to be used in combination with `transformer` to denoise the encoded video latents.</paramsdesc><paramgroups>0</paramgroups></docstring>

Pipeline for text-to-video generation using Kandinsky 5.0.

This model inherits from [DiffusionPipeline](/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline). Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__call__</name><anchor>diffusers.Kandinsky5T2VPipeline.__call__</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky5/pipeline_kandinsky.py#L615</source><parameters>[{"name": "prompt", "val": ": typing.Union[str, typing.List[str]] = None"}, {"name": "negative_prompt", "val": ": typing.Union[str, typing.List[str], NoneType] = None"}, {"name": "height", "val": ": int = 512"}, {"name": "width", "val": ": int = 768"}, {"name": "num_frames", "val": ": int = 121"}, {"name": "num_inference_steps", "val": ": int = 50"}, {"name": "guidance_scale", "val": ": float = 5.0"}, {"name": "num_videos_per_prompt", "val": ": typing.Optional[int] = 1"}, {"name": "generator", "val": ": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"}, {"name": "latents", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "prompt_embeds_qwen", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "prompt_embeds_clip", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "negative_prompt_embeds_qwen", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "negative_prompt_embeds_clip", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "prompt_cu_seqlens", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "negative_prompt_cu_seqlens", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "output_type", "val": ": typing.Optional[str] = 'pil'"}, {"name": "return_dict", "val": ": bool = True"}, {"name": "callback_on_step_end", "val": ": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"}, {"name": "callback_on_step_end_tensor_inputs", "val": ": typing.List[str] = ['latents']"}, {"name": "max_sequence_length", "val": ": int = 512"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **prompt** (`str` or `List[str]`, *optional*) --
  The prompt or prompts to guide the video generation. If not defined, pass `prompt_embeds` instead.
- **negative_prompt** (`str` or `List[str]`, *optional*) --
  The prompt or prompts to avoid during video generation. If not defined, pass `negative_prompt_embeds`
  instead. Ignored when not using guidance (`guidance_scale` < `1`).
- **height** (`int`, defaults to `512`) --
  The height in pixels of the generated video.
- **width** (`int`, defaults to `768`) --
  The width in pixels of the generated video.
- **num_frames** (`int`, defaults to `25`) --
  The number of frames in the generated video.
- **num_inference_steps** (`int`, defaults to `50`) --
  The number of denoising steps.
- **guidance_scale** (`float`, defaults to `5.0`) --
  Guidance scale as defined in classifier-free guidance.
- **num_videos_per_prompt** (`int`, *optional*, defaults to 1) --
  The number of videos to generate per prompt.
- **generator** (`torch.Generator` or `List[torch.Generator]`, *optional*) --
  A torch generator to make generation deterministic.
- **latents** (`torch.Tensor`, *optional*) --
  Pre-generated noisy latents.
- **prompt_embeds** (`torch.Tensor`, *optional*) --
  Pre-generated text embeddings.
- **negative_prompt_embeds** (`torch.Tensor`, *optional*) --
  Pre-generated negative text embeddings.
- **output_type** (`str`, *optional*, defaults to `"pil"`) --
  The output format of the generated video.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a `KandinskyPipelineOutput`.
- **callback_on_step_end** (`Callable`, `PipelineCallback`, `MultiPipelineCallbacks`, *optional*) --
  A function that is called at the end of each denoising step.
- **callback_on_step_end_tensor_inputs** (`List`, *optional*) --
  The list of tensor inputs for the `callback_on_step_end` function.
- **max_sequence_length** (`int`, defaults to `512`) --
  The maximum sequence length for text encoding.</paramsdesc><paramgroups>0</paramgroups><rettype>`~KandinskyPipelineOutput` or `tuple`</rettype><retdesc>If `return_dict` is `True`, `KandinskyPipelineOutput` is returned, otherwise a `tuple` is returned
where the first element is a list with the generated images.</retdesc></docstring>

The call function to the pipeline for generation.



<ExampleCodeBlock anchor="diffusers.Kandinsky5T2VPipeline.__call__.example">

Examples:

```python
>>> import torch
>>> from diffusers import Kandinsky5T2VPipeline
>>> from diffusers.utils import export_to_video

>>> # Available models:
>>> # ai-forever/Kandinsky-5.0-T2V-Lite-sft-5s-Diffusers
>>> # ai-forever/Kandinsky-5.0-T2V-Lite-nocfg-5s-Diffusers
>>> # ai-forever/Kandinsky-5.0-T2V-Lite-distilled16steps-5s-Diffusers
>>> # ai-forever/Kandinsky-5.0-T2V-Lite-pretrain-5s-Diffusers

>>> model_id = "ai-forever/Kandinsky-5.0-T2V-Lite-sft-5s-Diffusers"
>>> pipe = Kandinsky5T2VPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
>>> pipe = pipe.to("cuda")

>>> prompt = "A cat and a dog baking a cake together in a kitchen."
>>> negative_prompt = "Static, 2D cartoon, cartoon, 2d animation, paintings, images, worst quality, low quality, ugly, deformed, walking backwards"

>>> output = pipe(
...     prompt=prompt,
...     negative_prompt=negative_prompt,
...     height=512,
...     width=768,
...     num_frames=121,
...     num_inference_steps=50,
...     guidance_scale=5.0,
... ).frames[0]

>>> export_to_video(output, "output.mp4", fps=24, quality=9)
```

</ExampleCodeBlock>







</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>check_inputs</name><anchor>diffusers.Kandinsky5T2VPipeline.check_inputs</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky5/pipeline_kandinsky.py#L446</source><parameters>[{"name": "prompt", "val": ""}, {"name": "negative_prompt", "val": ""}, {"name": "height", "val": ""}, {"name": "width", "val": ""}, {"name": "prompt_embeds_qwen", "val": " = None"}, {"name": "prompt_embeds_clip", "val": " = None"}, {"name": "negative_prompt_embeds_qwen", "val": " = None"}, {"name": "negative_prompt_embeds_clip", "val": " = None"}, {"name": "prompt_cu_seqlens", "val": " = None"}, {"name": "negative_prompt_cu_seqlens", "val": " = None"}, {"name": "callback_on_step_end_tensor_inputs", "val": " = None"}]</parameters><paramsdesc>- **prompt** -- Input prompt
- **negative_prompt** -- Negative prompt for guidance
- **height** -- Video height
- **width** -- Video width
- **prompt_embeds_qwen** -- Pre-computed Qwen prompt embeddings
- **prompt_embeds_clip** -- Pre-computed CLIP prompt embeddings
- **negative_prompt_embeds_qwen** -- Pre-computed Qwen negative prompt embeddings
- **negative_prompt_embeds_clip** -- Pre-computed CLIP negative prompt embeddings
- **prompt_cu_seqlens** -- Pre-computed cumulative sequence lengths for Qwen positive prompt
- **negative_prompt_cu_seqlens** -- Pre-computed cumulative sequence lengths for Qwen negative prompt
- **callback_on_step_end_tensor_inputs** -- Callback tensor inputs</paramsdesc><paramgroups>0</paramgroups><raises>- ``ValueError`` -- If inputs are invalid</raises><raisederrors>``ValueError``</raisederrors></docstring>

Validate input parameters for the pipeline.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>encode_prompt</name><anchor>diffusers.Kandinsky5T2VPipeline.encode_prompt</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky5/pipeline_kandinsky.py#L353</source><parameters>[{"name": "prompt", "val": ": typing.Union[str, typing.List[str]]"}, {"name": "num_videos_per_prompt", "val": ": int = 1"}, {"name": "max_sequence_length", "val": ": int = 512"}, {"name": "device", "val": ": typing.Optional[torch.device] = None"}, {"name": "dtype", "val": ": typing.Optional[torch.dtype] = None"}]</parameters><paramsdesc>- **prompt** (`str` or `List[str]`) --
  Prompt to be encoded.
- **num_videos_per_prompt** (`int`, *optional*, defaults to 1) --
  Number of videos to generate per prompt.
- **max_sequence_length** (`int`, *optional*, defaults to 512) --
  Maximum sequence length for text encoding.
- **device** (`torch.device`, *optional*) --
  Torch device.
- **dtype** (`torch.dtype`, *optional*) --
  Torch dtype.</paramsdesc><paramgroups>0</paramgroups><rettype>Tuple[torch.Tensor, torch.Tensor, torch.Tensor]</rettype><retdesc>- Qwen text embeddings of shape (batch_size * num_videos_per_prompt, sequence_length, embedding_dim)
- CLIP pooled embeddings of shape (batch_size * num_videos_per_prompt, clip_embedding_dim)
- Cumulative sequence lengths (`cu_seqlens`) for Qwen embeddings of shape (batch_size *
  num_videos_per_prompt + 1,)</retdesc></docstring>

Encodes a single prompt (positive or negative) into text encoder hidden states.

This method combines embeddings from both Qwen2.5-VL and CLIP text encoders to create comprehensive text
representations for video generation.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>fast_sta_nabla</name><anchor>diffusers.Kandinsky5T2VPipeline.fast_sta_nabla</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky5/pipeline_kandinsky.py#L182</source><parameters>[{"name": "T", "val": ": int"}, {"name": "H", "val": ": int"}, {"name": "W", "val": ": int"}, {"name": "wT", "val": ": int = 3"}, {"name": "wH", "val": ": int = 3"}, {"name": "wW", "val": ": int = 3"}, {"name": "device", "val": " = 'cuda'"}]</parameters><paramsdesc>- **T** (int) -- Number of temporal frames
- **H** (int) -- Height in latent space
- **W** (int) -- Width in latent space
- **wT** (int) -- Temporal attention window size
- **wH** (int) -- Height attention window size
- **wW** (int) -- Width attention window size
- **device** (str) -- Device to create tensor on</paramsdesc><paramgroups>0</paramgroups><rettype>torch.Tensor</rettype><retdesc>Sparse attention mask of shape (T*H*W, T*H*W)</retdesc></docstring>

Create a sparse temporal attention (STA) mask for efficient video generation.

This method generates a mask that limits attention to nearby frames and spatial positions, reducing
computational complexity for video generation.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_sparse_params</name><anchor>diffusers.Kandinsky5T2VPipeline.get_sparse_params</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky5/pipeline_kandinsky.py#L217</source><parameters>[{"name": "sample", "val": ""}, {"name": "device", "val": ""}]</parameters><paramsdesc>- **sample** (torch.Tensor) -- Input sample tensor
- **device** (torch.device) -- Device to place tensors on</paramsdesc><paramgroups>0</paramgroups><rettype>Dict</rettype><retdesc>Dictionary containing sparse attention parameters</retdesc></docstring>

Generate sparse attention parameters for the transformer based on sample dimensions.

This method computes the sparse attention configuration needed for efficient video processing in the
transformer model.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>prepare_latents</name><anchor>diffusers.Kandinsky5T2VPipeline.prepare_latents</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky5/pipeline_kandinsky.py#L527</source><parameters>[{"name": "batch_size", "val": ": int"}, {"name": "num_channels_latents", "val": ": int = 16"}, {"name": "height", "val": ": int = 480"}, {"name": "width", "val": ": int = 832"}, {"name": "num_frames", "val": ": int = 81"}, {"name": "dtype", "val": ": typing.Optional[torch.dtype] = None"}, {"name": "device", "val": ": typing.Optional[torch.device] = None"}, {"name": "generator", "val": ": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"}, {"name": "latents", "val": ": typing.Optional[torch.Tensor] = None"}]</parameters><paramsdesc>- **batch_size** (int) -- Number of videos to generate
- **num_channels_latents** (int) -- Number of channels in latent space
- **height** (int) -- Height of generated video
- **width** (int) -- Width of generated video
- **num_frames** (int) -- Number of frames in video
- **dtype** (torch.dtype) -- Data type for latents
- **device** (torch.device) -- Device to create latents on
- **generator** (torch.Generator) -- Random number generator
- **latents** (torch.Tensor) -- Pre-existing latents to use</paramsdesc><paramgroups>0</paramgroups><rettype>torch.Tensor</rettype><retdesc>Prepared latent tensor</retdesc></docstring>

Prepare initial latent variables for video generation.

This method creates random noise latents or uses provided latents as starting point for the denoising process.








</div></div>

## Usage Examples

### Basic Text-to-Video Generation

```python
import torch
from diffusers import Kandinsky5T2VPipeline
from diffusers.utils import export_to_video

# Load the pipeline
model_id = "ai-forever/Kandinsky-5.0-T2V-Lite-sft-5s-Diffusers"
pipe = Kandinsky5T2VPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
pipe = pipe.to("cuda")

# Generate video
prompt = "A cat and a dog baking a cake together in a kitchen."
negative_prompt = "Static, 2D cartoon, cartoon, 2d animation, paintings, images, worst quality, low quality, ugly, deformed, walking backwards"

output = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    height=512,
    width=768,
    num_frames=121,  # ~5 seconds at 24fps
    num_inference_steps=50,
    guidance_scale=5.0,
).frames[0]

export_to_video(output, "output.mp4", fps=24, quality=9)
```

### 10 second Models
**⚠️ Warning!** all 10 second models should be used with Flex attention and max-autotune-no-cudagraphs compilation:

```python
pipe = Kandinsky5T2VPipeline.from_pretrained(
    "ai-forever/Kandinsky-5.0-T2V-Lite-sft-10s-Diffusers", 
    torch_dtype=torch.bfloat16
)
pipe = pipe.to("cuda")

pipe.transformer.set_attention_backend(
    "flex"
)                                       # <--- Sett attention bakend to Flex
pipe.transformer.compile(
    mode="max-autotune-no-cudagraphs", 
    dynamic=True
)                                       # <--- Compile with max-autotune-no-cudagraphs

prompt = "A cat and a dog baking a cake together in a kitchen."
negative_prompt = "Static, 2D cartoon, cartoon, 2d animation, paintings, images, worst quality, low quality, ugly, deformed, walking backwards"

output = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    height=512,
    width=768,
    num_frames=241,
    num_inference_steps=50,
    guidance_scale=5.0,
).frames[0]

export_to_video(output, "output.mp4", fps=24, quality=9)
```

### Diffusion Distilled model
**⚠️ Warning!** all nocfg and diffusion distilled models should be infered wothout CFG (```guidance_scale=1.0```):

```python
model_id = "ai-forever/Kandinsky-5.0-T2V-Lite-distilled16steps-5s-Diffusers"
pipe = Kandinsky5T2VPipeline.from_pretrained(model_id, torch_dtype=torch.bfloat16)
pipe = pipe.to("cuda")

output = pipe(
    prompt="A beautiful sunset over mountains",
    num_inference_steps=16,  # <--- Model is distilled in 16 steps
    guidance_scale=1.0,      # <--- no CFG
).frames[0]

export_to_video(output, "output.mp4", fps=24, quality=9)
```


## Citation
```bibtex
@misc{kandinsky2025,
    author = {Alexey Letunovskiy and Maria Kovaleva and Ivan Kirillov and Lev Novitskiy and Denis Koposov and
              Dmitrii Mikhailov and Anna Averchenkova and Andrey Shutkin and Julia Agafonova and Olga Kim and
              Anastasiia Kargapoltseva and Nikita Kiselev and Vladimir Arkhipkin and Vladimir Korviakov and
              Nikolai Gerasimenko and Denis Parkhomenko and Anna Dmitrienko and Anastasia Maltseva and
              Kirill Chernyshev and Ilia Vasiliev and Viacheslav Vasilev and Vladimir Polovnikov and
              Yury Kolabushin and Alexander Belykh and Mikhail Mamaev and Anastasia Aliaskina and
              Tatiana Nikulina and Polina Gavrilova and Denis Dimitrov},
    title = {Kandinsky 5.0: A family of diffusion models for Video & Image generation},
    howpublished = {\url{https://github.com/ai-forever/Kandinsky-5}},
    year = 2025
}
```


<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/kandinsky5_video.md" />