# Outputs

All model outputs are subclasses of [BaseOutput](/docs/diffusers/main/en/api/outputs#diffusers.utils.BaseOutput), data structures containing all the information returned by the model. The outputs can also be used as tuples or dictionaries.

For example:

```python
from diffusers import DDIMPipeline

pipeline = DDIMPipeline.from_pretrained("google/ddpm-cifar10-32")
outputs = pipeline()
```

The `outputs` object is a [ImagePipelineOutput](/docs/diffusers/main/en/api/pipelines/ddim#diffusers.ImagePipelineOutput) which means it has an image attribute.

You can access each attribute as you normally would or with a keyword lookup, and if that attribute is not returned by the model, you will get `None`:

```python
outputs.images
outputs["images"]
```

When considering the `outputs` object as a tuple, it only considers the attributes that don't have `None` values.
For instance, retrieving an image by indexing into it returns the tuple `(outputs.images)`:

```python
outputs[:1]
```

> [!TIP]
> To check a specific pipeline or model output, refer to its corresponding API documentation.

## BaseOutput[[diffusers.utils.BaseOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.utils.BaseOutput</name><anchor>diffusers.utils.BaseOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/outputs.py#L40</source><parameters>""</parameters></docstring>

Base class for all model outputs as dataclass. Has a `__getitem__` that allows indexing by integer or slice (like a
tuple) or strings (like a dictionary) that will ignore the `None` attributes. Otherwise behaves like a regular
Python dictionary.

> [!WARNING] > You can't unpack a `BaseOutput` directly. Use the [to_tuple()](/docs/diffusers/main/en/api/outputs#diffusers.utils.BaseOutput.to_tuple) method to convert
it to a tuple > first.



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>to_tuple</name><anchor>diffusers.utils.BaseOutput.to_tuple</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/outputs.py#L130</source><parameters>[]</parameters></docstring>

Convert self to a tuple containing all the attributes/keys that are not `None`.


</div></div>

## ImagePipelineOutput[[diffusers.ImagePipelineOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.ImagePipelineOutput</name><anchor>diffusers.ImagePipelineOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L118</source><parameters>[{"name": "images", "val": ": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}]</parameters><paramsdesc>- **images** (`List[PIL.Image.Image]` or `np.ndarray`) --
  List of denoised PIL images of length `batch_size` or NumPy array of shape `(batch_size, height, width,
  num_channels)`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output class for image pipelines.




</div>

## AudioPipelineOutput[[diffusers.AudioPipelineOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.AudioPipelineOutput</name><anchor>diffusers.AudioPipelineOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L132</source><parameters>[{"name": "audios", "val": ": ndarray"}]</parameters><paramsdesc>- **audios** (`np.ndarray`) --
  List of denoised audio samples of a NumPy array of shape `(batch_size, num_channels, sample_rate)`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output class for audio pipelines.




</div>

## ImageTextPipelineOutput[[diffusers.ImageTextPipelineOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.ImageTextPipelineOutput</name><anchor>diffusers.ImageTextPipelineOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unidiffuser/pipeline_unidiffuser.py#L48</source><parameters>[{"name": "images", "val": ": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray, NoneType]"}, {"name": "text", "val": ": typing.Union[typing.List[str], typing.List[typing.List[str]], NoneType]"}]</parameters><paramsdesc>- **images** (`List[PIL.Image.Image]` or `np.ndarray`) --
  List of denoised PIL images of length `batch_size` or NumPy array of shape `(batch_size, height, width,
  num_channels)`.
- **text** (`List[str]` or `List[List[str]]`) --
  List of generated text strings of length `batch_size` or a list of list of strings whose outer list has
  length `batch_size`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output class for joint image-text pipelines.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/outputs.md" />