# Guiders

Guiders are components in Modular Diffusers that control how the diffusion process is guided during generation. They implement various guidance techniques to improve generation quality and control.

## BaseGuidance[[diffusers.BaseGuidance]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.BaseGuidance</name><anchor>diffusers.BaseGuidance</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/guider_utils.py#L36</source><parameters>[{"name": "start", "val": ": float = 0.0"}, {"name": "stop", "val": ": float = 1.0"}, {"name": "enabled", "val": ": bool = True"}]</parameters></docstring>
Base class providing the skeleton for implementing guidance techniques.


<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>cleanup_models</name><anchor>diffusers.BaseGuidance.cleanup_models</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/guider_utils.py#L158</source><parameters>[{"name": "denoiser", "val": ": Module"}]</parameters></docstring>

Cleans up the models for the guidance technique after a given batch of data. This method should be overridden
in subclasses to implement specific model cleanup logic. It is useful for removing any hooks or other stateful
modifications made during `prepare_models`.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_pretrained</name><anchor>diffusers.BaseGuidance.from_pretrained</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/guider_utils.py#L287</source><parameters>[{"name": "pretrained_model_name_or_path", "val": ": typing.Union[str, os.PathLike, NoneType] = None"}, {"name": "subfolder", "val": ": typing.Optional[str] = None"}, {"name": "return_unused_kwargs", "val": " = False"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **pretrained_model_name_or_path** (`str` or `os.PathLike`, *optional*) --
  Can be either:

  - A string, the *model id* (for example `google/ddpm-celebahq-256`) of a pretrained model hosted on
    the Hub.
  - A path to a *directory* (for example `./my_model_directory`) containing the guider configuration
    saved with [save_pretrained()](/docs/diffusers/main/en/api/modular_diffusers/guiders#diffusers.BaseGuidance.save_pretrained).
- **subfolder** (`str`, *optional*) --
  The subfolder location of a model file within a larger model repository on the Hub or locally.
- **return_unused_kwargs** (`bool`, *optional*, defaults to `False`) --
  Whether kwargs that are not consumed by the Python class should be returned or not.
- **cache_dir** (`Union[str, os.PathLike]`, *optional*) --
  Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
  is not used.
- **force_download** (`bool`, *optional*, defaults to `False`) --
  Whether or not to force the (re-)download of the model weights and configuration files, overriding the
  cached versions if they exist.

- **proxies** (`Dict[str, str]`, *optional*) --
  A dictionary of proxy servers to use by protocol or endpoint, for example, `{'http': 'foo.bar:3128',
  'http://hostname': 'foo.bar:4012'}`. The proxies are used on each request.
- **output_loading_info(`bool`,** *optional*, defaults to `False`) --
  Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.
- **local_files_only(`bool`,** *optional*, defaults to `False`) --
  Whether to only load local model weights and configuration files or not. If set to `True`, the model
  won't be downloaded from the Hub.
- **token** (`str` or *bool*, *optional*) --
  The token to use as HTTP bearer authorization for remote files. If `True`, the token generated from
  `diffusers-cli login` (stored in `~/.huggingface`) is used.
- **revision** (`str`, *optional*, defaults to `"main"`) --
  The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
  allowed by Git.</paramsdesc><paramgroups>0</paramgroups></docstring>

Instantiate a guider from a pre-defined JSON configuration file in a local directory or Hub repository.



> [!TIP] > To use private or [gated models](https://huggingface.co/docs/hub/models-gated#gated-models), log-in
with `hf > auth login`. You can also activate the special >
["offline-mode"](https://huggingface.co/diffusers/installation.html#offline-mode) to use this method in a >
firewalled environment.



</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_state</name><anchor>diffusers.BaseGuidance.get_state</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/guider_utils.py#L104</source><parameters>[]</parameters></docstring>

Returns the current state of the guidance technique as a dictionary. The state variables will be included in
the __repr__ method. Returns:
`Dict[str, Any]`: A dictionary containing the current state variables including:
- step: Current inference step
- num_inference_steps: Total number of inference steps
- timestep: Current timestep tensor
- count_prepared: Number of times prepare_models has been called
- enabled: Whether the guidance is enabled
- num_conditions: Number of conditions


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>new</name><anchor>diffusers.BaseGuidance.new</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/guider_utils.py#L67</source><parameters>[{"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- ****kwargs** -- Configuration parameters to override in the new instance. If no kwargs are provided,
  returns an exact copy with the same configuration.</paramsdesc><paramgroups>0</paramgroups><retdesc>A new guider instance with the same (or updated) configuration.</retdesc></docstring>

Creates a copy of this guider instance, optionally with modified configuration parameters.





<ExampleCodeBlock anchor="diffusers.BaseGuidance.new.example">

Example:
```python
# Create a CFG guider
guider = ClassifierFreeGuidance(guidance_scale=3.5)

# Create an exact copy
same_guider = guider.new()

# Create a copy with different start step, keeping other config the same
new_guider = guider.new(guidance_scale=5)
```

</ExampleCodeBlock>


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>prepare_models</name><anchor>diffusers.BaseGuidance.prepare_models</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/guider_utils.py#L151</source><parameters>[{"name": "denoiser", "val": ": Module"}]</parameters></docstring>

Prepares the models for the guidance technique on a given batch of data. This method should be overridden in
subclasses to implement specific model preparation logic.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>save_pretrained</name><anchor>diffusers.BaseGuidance.save_pretrained</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/guider_utils.py#L348</source><parameters>[{"name": "save_directory", "val": ": typing.Union[str, os.PathLike]"}, {"name": "push_to_hub", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **save_directory** (`str` or `os.PathLike`) --
  Directory where the configuration JSON file will be saved (will be created if it does not exist).
- **push_to_hub** (`bool`, *optional*, defaults to `False`) --
  Whether or not to push your model to the Hugging Face Hub after saving it. You can specify the
  repository you want to push to with `repo_id` (will default to the name of `save_directory` in your
  namespace).
- **kwargs** (`Dict[str, Any]`, *optional*) --
  Additional keyword arguments passed along to the [push_to_hub()](/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub) method.</paramsdesc><paramgroups>0</paramgroups></docstring>

Save a guider configuration object to a directory so that it can be reloaded using the
[from_pretrained()](/docs/diffusers/main/en/api/modular_diffusers/guiders#diffusers.BaseGuidance.from_pretrained) class method.




</div></div>

## ClassifierFreeGuidance[[diffusers.ClassifierFreeGuidance]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.ClassifierFreeGuidance</name><anchor>diffusers.ClassifierFreeGuidance</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/classifier_free_guidance.py#L28</source><parameters>[{"name": "guidance_scale", "val": ": float = 7.5"}, {"name": "guidance_rescale", "val": ": float = 0.0"}, {"name": "use_original_formulation", "val": ": bool = False"}, {"name": "start", "val": ": float = 0.0"}, {"name": "stop", "val": ": float = 1.0"}, {"name": "enabled", "val": ": bool = True"}]</parameters><paramsdesc>- **guidance_scale** (`float`, defaults to `7.5`) --
  CFG scale applied by this guider during post-processing. Higher values = stronger prompt conditioning but
  may reduce quality. Typical range: 1.0-20.0.
- **guidance_rescale** (`float`, defaults to `0.0`) --
  Rescaling factor to prevent overexposure from high guidance scales. Based on [Common Diffusion Noise
  Schedules and Sample Steps are Flawed](https://huggingface.co/papers/2305.08891). Range: 0.0 (no rescaling)
  to 1.0 (full rescaling).
- **use_original_formulation** (`bool`, defaults to `False`) --
  If `True`, uses the original CFG formulation from the paper. If `False` (default), uses the
  diffusers-native formulation from the Imagen paper.
- **start** (`float`, defaults to `0.0`) --
  Fraction of denoising steps (0.0-1.0) after which CFG starts. Use > 0.0 to disable CFG in early denoising
  steps.
- **stop** (`float`, defaults to `1.0`) --
  Fraction of denoising steps (0.0-1.0) after which CFG stops. Use < 1.0 to disable CFG in late denoising
  steps.
- **enabled** (`bool`, defaults to `True`) --
  Whether CFG is enabled. Set to `False` to disable CFG entirely (uses only conditional predictions).</paramsdesc><paramgroups>0</paramgroups></docstring>

Implements Classifier-Free Guidance (CFG) for diffusion models.

Reference: https://huggingface.co/papers/2207.12598

CFG improves generation quality and prompt adherence by jointly training models on both conditional and
unconditional data, then combining predictions during inference. This allows trading off between quality (high
guidance) and diversity (low guidance).

**Two CFG Formulations:**

<ExampleCodeBlock anchor="diffusers.ClassifierFreeGuidance.example">

1. **Original formulation** (from paper):
```
x_pred = x_cond + guidance_scale * (x_cond - x_uncond)
```

</ExampleCodeBlock>
   Moves conditional predictions further from unconditional ones.

<ExampleCodeBlock anchor="diffusers.ClassifierFreeGuidance.example-2">

2. **Diffusers-native formulation** (default, from Imagen paper):
```
x_pred = x_uncond + guidance_scale * (x_cond - x_uncond)
```

</ExampleCodeBlock>
   Moves unconditional predictions toward conditional ones, effectively suppressing negative features (e.g., "bad
   quality", "watermarks"). Equivalent in theory but more intuitive.

Use `use_original_formulation=True` to switch to the original formulation.




</div>

## ClassifierFreeZeroStarGuidance[[diffusers.ClassifierFreeZeroStarGuidance]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.ClassifierFreeZeroStarGuidance</name><anchor>diffusers.ClassifierFreeZeroStarGuidance</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/classifier_free_zero_star_guidance.py#L28</source><parameters>[{"name": "guidance_scale", "val": ": float = 7.5"}, {"name": "zero_init_steps", "val": ": int = 1"}, {"name": "guidance_rescale", "val": ": float = 0.0"}, {"name": "use_original_formulation", "val": ": bool = False"}, {"name": "start", "val": ": float = 0.0"}, {"name": "stop", "val": ": float = 1.0"}, {"name": "enabled", "val": ": bool = True"}]</parameters><paramsdesc>- **guidance_scale** (`float`, defaults to `7.5`) --
  The scale parameter for classifier-free guidance. Higher values result in stronger conditioning on the text
  prompt, while lower values allow for more freedom in generation. Higher values may lead to saturation and
  deterioration of image quality.
- **zero_init_steps** (`int`, defaults to `1`) --
  The number of inference steps for which the noise predictions are zeroed out (see Section 4.2).
- **guidance_rescale** (`float`, defaults to `0.0`) --
  The rescale factor applied to the noise predictions. This is used to improve image quality and fix
  overexposure. Based on Section 3.4 from [Common Diffusion Noise Schedules and Sample Steps are
  Flawed](https://huggingface.co/papers/2305.08891).
- **use_original_formulation** (`bool`, defaults to `False`) --
  Whether to use the original formulation of classifier-free guidance as proposed in the paper. By default,
  we use the diffusers-native implementation that has been in the codebase for a long time. See
  [~guiders.classifier_free_guidance.ClassifierFreeGuidance] for more details.
- **start** (`float`, defaults to `0.01`) --
  The fraction of the total number of denoising steps after which guidance starts.
- **stop** (`float`, defaults to `0.2`) --
  The fraction of the total number of denoising steps after which guidance stops.</paramsdesc><paramgroups>0</paramgroups></docstring>

Classifier-free Zero* (CFG-Zero*): https://huggingface.co/papers/2503.18886

This is an implementation of the Classifier-Free Zero* guidance technique, which is a variant of classifier-free
guidance. It proposes zero initialization of the noise predictions for the first few steps of the diffusion
process, and also introduces an optimal rescaling factor for the noise predictions, which can help in improving the
quality of generated images.

The authors of the paper suggest setting zero initialization in the first 4% of the inference steps.




</div>

## SkipLayerGuidance[[diffusers.SkipLayerGuidance]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.SkipLayerGuidance</name><anchor>diffusers.SkipLayerGuidance</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/skip_layer_guidance.py#L30</source><parameters>[{"name": "guidance_scale", "val": ": float = 7.5"}, {"name": "skip_layer_guidance_scale", "val": ": float = 2.8"}, {"name": "skip_layer_guidance_start", "val": ": float = 0.01"}, {"name": "skip_layer_guidance_stop", "val": ": float = 0.2"}, {"name": "skip_layer_guidance_layers", "val": ": typing.Union[int, typing.List[int], NoneType] = None"}, {"name": "skip_layer_config", "val": ": typing.Union[diffusers.hooks.layer_skip.LayerSkipConfig, typing.List[diffusers.hooks.layer_skip.LayerSkipConfig], typing.Dict[str, typing.Any]] = None"}, {"name": "guidance_rescale", "val": ": float = 0.0"}, {"name": "use_original_formulation", "val": ": bool = False"}, {"name": "start", "val": ": float = 0.0"}, {"name": "stop", "val": ": float = 1.0"}, {"name": "enabled", "val": ": bool = True"}]</parameters><paramsdesc>- **guidance_scale** (`float`, defaults to `7.5`) --
  The scale parameter for classifier-free guidance. Higher values result in stronger conditioning on the text
  prompt, while lower values allow for more freedom in generation. Higher values may lead to saturation and
  deterioration of image quality.
- **skip_layer_guidance_scale** (`float`, defaults to `2.8`) --
  The scale parameter for skip layer guidance. Anatomy and structure coherence may improve with higher
  values, but it may also lead to overexposure and saturation.
- **skip_layer_guidance_start** (`float`, defaults to `0.01`) --
  The fraction of the total number of denoising steps after which skip layer guidance starts.
- **skip_layer_guidance_stop** (`float`, defaults to `0.2`) --
  The fraction of the total number of denoising steps after which skip layer guidance stops.
- **skip_layer_guidance_layers** (`int` or `List[int]`, *optional*) --
  The layer indices to apply skip layer guidance to. Can be a single integer or a list of integers. If not
  provided, `skip_layer_config` must be provided. The recommended values are `[7, 8, 9]` for Stable Diffusion
  3.5 Medium.
- **skip_layer_config** (`LayerSkipConfig` or `List[LayerSkipConfig]`, *optional*) --
  The configuration for the skip layer guidance. Can be a single `LayerSkipConfig` or a list of
  `LayerSkipConfig`. If not provided, `skip_layer_guidance_layers` must be provided.
- **guidance_rescale** (`float`, defaults to `0.0`) --
  The rescale factor applied to the noise predictions. This is used to improve image quality and fix
  overexposure. Based on Section 3.4 from [Common Diffusion Noise Schedules and Sample Steps are
  Flawed](https://huggingface.co/papers/2305.08891).
- **use_original_formulation** (`bool`, defaults to `False`) --
  Whether to use the original formulation of classifier-free guidance as proposed in the paper. By default,
  we use the diffusers-native implementation that has been in the codebase for a long time. See
  [~guiders.classifier_free_guidance.ClassifierFreeGuidance] for more details.
- **start** (`float`, defaults to `0.01`) --
  The fraction of the total number of denoising steps after which guidance starts.
- **stop** (`float`, defaults to `0.2`) --
  The fraction of the total number of denoising steps after which guidance stops.</paramsdesc><paramgroups>0</paramgroups></docstring>

Skip Layer Guidance (SLG): https://github.com/Stability-AI/sd3.5

Spatio-Temporal Guidance (STG): https://huggingface.co/papers/2411.18664

SLG was introduced by StabilityAI for improving structure and anotomy coherence in generated images. It works by
skipping the forward pass of specified transformer blocks during the denoising process on an additional conditional
batch of data, apart from the conditional and unconditional batches already used in CFG
([~guiders.classifier_free_guidance.ClassifierFreeGuidance]), and then scaling and shifting the CFG predictions
based on the difference between conditional without skipping and conditional with skipping predictions.

The intution behind SLG can be thought of as moving the CFG predicted distribution estimates further away from
worse versions of the conditional distribution estimates (because skipping layers is equivalent to using a worse
version of the model for the conditional prediction).

STG is an improvement and follow-up work combining ideas from SLG, PAG and similar techniques for improving
generation quality in video diffusion models.

Additional reading:
- [Guiding a Diffusion Model with a Bad Version of Itself](https://huggingface.co/papers/2406.02507)

The values for `skip_layer_guidance_scale`, `skip_layer_guidance_start`, and `skip_layer_guidance_stop` are
defaulted to the recommendations by StabilityAI for Stable Diffusion 3.5 Medium.




</div>

## SmoothedEnergyGuidance[[diffusers.SmoothedEnergyGuidance]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.SmoothedEnergyGuidance</name><anchor>diffusers.SmoothedEnergyGuidance</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/smoothed_energy_guidance.py#L30</source><parameters>[{"name": "guidance_scale", "val": ": float = 7.5"}, {"name": "seg_guidance_scale", "val": ": float = 2.8"}, {"name": "seg_blur_sigma", "val": ": float = 9999999.0"}, {"name": "seg_blur_threshold_inf", "val": ": float = 9999.0"}, {"name": "seg_guidance_start", "val": ": float = 0.0"}, {"name": "seg_guidance_stop", "val": ": float = 1.0"}, {"name": "seg_guidance_layers", "val": ": typing.Union[int, typing.List[int], NoneType] = None"}, {"name": "seg_guidance_config", "val": ": typing.Union[diffusers.hooks.smoothed_energy_guidance_utils.SmoothedEnergyGuidanceConfig, typing.List[diffusers.hooks.smoothed_energy_guidance_utils.SmoothedEnergyGuidanceConfig]] = None"}, {"name": "guidance_rescale", "val": ": float = 0.0"}, {"name": "use_original_formulation", "val": ": bool = False"}, {"name": "start", "val": ": float = 0.0"}, {"name": "stop", "val": ": float = 1.0"}, {"name": "enabled", "val": ": bool = True"}]</parameters><paramsdesc>- **guidance_scale** (`float`, defaults to `7.5`) --
  The scale parameter for classifier-free guidance. Higher values result in stronger conditioning on the text
  prompt, while lower values allow for more freedom in generation. Higher values may lead to saturation and
  deterioration of image quality.
- **seg_guidance_scale** (`float`, defaults to `3.0`) --
  The scale parameter for smoothed energy guidance. Anatomy and structure coherence may improve with higher
  values, but it may also lead to overexposure and saturation.
- **seg_blur_sigma** (`float`, defaults to `9999999.0`) --
  The amount by which we blur the attention weights. Setting this value greater than 9999.0 results in
  infinite blur, which means uniform queries. Controlling it exponentially is empirically effective.
- **seg_blur_threshold_inf** (`float`, defaults to `9999.0`) --
  The threshold above which the blur is considered infinite.
- **seg_guidance_start** (`float`, defaults to `0.0`) --
  The fraction of the total number of denoising steps after which smoothed energy guidance starts.
- **seg_guidance_stop** (`float`, defaults to `1.0`) --
  The fraction of the total number of denoising steps after which smoothed energy guidance stops.
- **seg_guidance_layers** (`int` or `List[int]`, *optional*) --
  The layer indices to apply smoothed energy guidance to. Can be a single integer or a list of integers. If
  not provided, `seg_guidance_config` must be provided. The recommended values are `[7, 8, 9]` for Stable
  Diffusion 3.5 Medium.
- **seg_guidance_config** (`SmoothedEnergyGuidanceConfig` or `List[SmoothedEnergyGuidanceConfig]`, *optional*) --
  The configuration for the smoothed energy layer guidance. Can be a single `SmoothedEnergyGuidanceConfig` or
  a list of `SmoothedEnergyGuidanceConfig`. If not provided, `seg_guidance_layers` must be provided.
- **guidance_rescale** (`float`, defaults to `0.0`) --
  The rescale factor applied to the noise predictions. This is used to improve image quality and fix
  overexposure. Based on Section 3.4 from [Common Diffusion Noise Schedules and Sample Steps are
  Flawed](https://huggingface.co/papers/2305.08891).
- **use_original_formulation** (`bool`, defaults to `False`) --
  Whether to use the original formulation of classifier-free guidance as proposed in the paper. By default,
  we use the diffusers-native implementation that has been in the codebase for a long time. See
  [~guiders.classifier_free_guidance.ClassifierFreeGuidance] for more details.
- **start** (`float`, defaults to `0.01`) --
  The fraction of the total number of denoising steps after which guidance starts.
- **stop** (`float`, defaults to `0.2`) --
  The fraction of the total number of denoising steps after which guidance stops.</paramsdesc><paramgroups>0</paramgroups></docstring>

Smoothed Energy Guidance (SEG): https://huggingface.co/papers/2408.00760

SEG is only supported as an experimental prototype feature for now, so the implementation may be modified in the
future without warning or guarantee of reproducibility. This implementation assumes:
- Generated images are square (height == width)
- The model does not combine different modalities together (e.g., text and image latent streams are not combined
  together such as Flux)




</div>

## PerturbedAttentionGuidance[[diffusers.PerturbedAttentionGuidance]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.PerturbedAttentionGuidance</name><anchor>diffusers.PerturbedAttentionGuidance</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/perturbed_attention_guidance.py#L34</source><parameters>[{"name": "guidance_scale", "val": ": float = 7.5"}, {"name": "perturbed_guidance_scale", "val": ": float = 2.8"}, {"name": "perturbed_guidance_start", "val": ": float = 0.01"}, {"name": "perturbed_guidance_stop", "val": ": float = 0.2"}, {"name": "perturbed_guidance_layers", "val": ": typing.Union[int, typing.List[int], NoneType] = None"}, {"name": "perturbed_guidance_config", "val": ": typing.Union[diffusers.hooks.layer_skip.LayerSkipConfig, typing.List[diffusers.hooks.layer_skip.LayerSkipConfig], typing.Dict[str, typing.Any]] = None"}, {"name": "guidance_rescale", "val": ": float = 0.0"}, {"name": "use_original_formulation", "val": ": bool = False"}, {"name": "start", "val": ": float = 0.0"}, {"name": "stop", "val": ": float = 1.0"}, {"name": "enabled", "val": ": bool = True"}]</parameters><paramsdesc>- **guidance_scale** (`float`, defaults to `7.5`) --
  The scale parameter for classifier-free guidance. Higher values result in stronger conditioning on the text
  prompt, while lower values allow for more freedom in generation. Higher values may lead to saturation and
  deterioration of image quality.
- **perturbed_guidance_scale** (`float`, defaults to `2.8`) --
  The scale parameter for perturbed attention guidance.
- **perturbed_guidance_start** (`float`, defaults to `0.01`) --
  The fraction of the total number of denoising steps after which perturbed attention guidance starts.
- **perturbed_guidance_stop** (`float`, defaults to `0.2`) --
  The fraction of the total number of denoising steps after which perturbed attention guidance stops.
- **perturbed_guidance_layers** (`int` or `List[int]`, *optional*) --
  The layer indices to apply perturbed attention guidance to. Can be a single integer or a list of integers.
  If not provided, `perturbed_guidance_config` must be provided.
- **perturbed_guidance_config** (`LayerSkipConfig` or `List[LayerSkipConfig]`, *optional*) --
  The configuration for the perturbed attention guidance. Can be a single `LayerSkipConfig` or a list of
  `LayerSkipConfig`. If not provided, `perturbed_guidance_layers` must be provided.
- **guidance_rescale** (`float`, defaults to `0.0`) --
  The rescale factor applied to the noise predictions. This is used to improve image quality and fix
  overexposure. Based on Section 3.4 from [Common Diffusion Noise Schedules and Sample Steps are
  Flawed](https://huggingface.co/papers/2305.08891).
- **use_original_formulation** (`bool`, defaults to `False`) --
  Whether to use the original formulation of classifier-free guidance as proposed in the paper. By default,
  we use the diffusers-native implementation that has been in the codebase for a long time. See
  [~guiders.classifier_free_guidance.ClassifierFreeGuidance] for more details.
- **start** (`float`, defaults to `0.01`) --
  The fraction of the total number of denoising steps after which guidance starts.
- **stop** (`float`, defaults to `0.2`) --
  The fraction of the total number of denoising steps after which guidance stops.</paramsdesc><paramgroups>0</paramgroups></docstring>

Perturbed Attention Guidance (PAG): https://huggingface.co/papers/2403.17377

The intution behind PAG can be thought of as moving the CFG predicted distribution estimates further away from
worse versions of the conditional distribution estimates. PAG was one of the first techniques to introduce the idea
of using a worse version of the trained model for better guiding itself in the denoising process. It perturbs the
attention scores of the latent stream by replacing the score matrix with an identity matrix for selectively chosen
layers.

Additional reading:
- [Guiding a Diffusion Model with a Bad Version of Itself](https://huggingface.co/papers/2406.02507)

PAG is implemented with similar implementation to SkipLayerGuidance due to overlap in the configuration parameters
and implementation details.




</div>

## AdaptiveProjectedGuidance[[diffusers.AdaptiveProjectedGuidance]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.AdaptiveProjectedGuidance</name><anchor>diffusers.AdaptiveProjectedGuidance</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/adaptive_projected_guidance.py#L28</source><parameters>[{"name": "guidance_scale", "val": ": float = 7.5"}, {"name": "adaptive_projected_guidance_momentum", "val": ": typing.Optional[float] = None"}, {"name": "adaptive_projected_guidance_rescale", "val": ": float = 15.0"}, {"name": "eta", "val": ": float = 1.0"}, {"name": "guidance_rescale", "val": ": float = 0.0"}, {"name": "use_original_formulation", "val": ": bool = False"}, {"name": "start", "val": ": float = 0.0"}, {"name": "stop", "val": ": float = 1.0"}, {"name": "enabled", "val": ": bool = True"}]</parameters><paramsdesc>- **guidance_scale** (`float`, defaults to `7.5`) --
  The scale parameter for classifier-free guidance. Higher values result in stronger conditioning on the text
  prompt, while lower values allow for more freedom in generation. Higher values may lead to saturation and
  deterioration of image quality.
- **adaptive_projected_guidance_momentum** (`float`, defaults to `None`) --
  The momentum parameter for the adaptive projected guidance. Disabled if set to `None`.
- **adaptive_projected_guidance_rescale** (`float`, defaults to `15.0`) --
  The rescale factor applied to the noise predictions. This is used to improve image quality and fix
- **guidance_rescale** (`float`, defaults to `0.0`) --
  The rescale factor applied to the noise predictions. This is used to improve image quality and fix
  overexposure. Based on Section 3.4 from [Common Diffusion Noise Schedules and Sample Steps are
  Flawed](https://huggingface.co/papers/2305.08891).
- **use_original_formulation** (`bool`, defaults to `False`) --
  Whether to use the original formulation of classifier-free guidance as proposed in the paper. By default,
  we use the diffusers-native implementation that has been in the codebase for a long time. See
  [~guiders.classifier_free_guidance.ClassifierFreeGuidance] for more details.
- **start** (`float`, defaults to `0.0`) --
  The fraction of the total number of denoising steps after which guidance starts.
- **stop** (`float`, defaults to `1.0`) --
  The fraction of the total number of denoising steps after which guidance stops.</paramsdesc><paramgroups>0</paramgroups></docstring>

Adaptive Projected Guidance (APG): https://huggingface.co/papers/2410.02416




</div>

## AutoGuidance[[diffusers.AutoGuidance]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.AutoGuidance</name><anchor>diffusers.AutoGuidance</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/auto_guidance.py#L30</source><parameters>[{"name": "guidance_scale", "val": ": float = 7.5"}, {"name": "auto_guidance_layers", "val": ": typing.Union[int, typing.List[int], NoneType] = None"}, {"name": "auto_guidance_config", "val": ": typing.Union[diffusers.hooks.layer_skip.LayerSkipConfig, typing.List[diffusers.hooks.layer_skip.LayerSkipConfig], typing.Dict[str, typing.Any]] = None"}, {"name": "dropout", "val": ": typing.Optional[float] = None"}, {"name": "guidance_rescale", "val": ": float = 0.0"}, {"name": "use_original_formulation", "val": ": bool = False"}, {"name": "start", "val": ": float = 0.0"}, {"name": "stop", "val": ": float = 1.0"}, {"name": "enabled", "val": ": bool = True"}]</parameters><paramsdesc>- **guidance_scale** (`float`, defaults to `7.5`) --
  The scale parameter for classifier-free guidance. Higher values result in stronger conditioning on the text
  prompt, while lower values allow for more freedom in generation. Higher values may lead to saturation and
  deterioration of image quality.
- **auto_guidance_layers** (`int` or `List[int]`, *optional*) --
  The layer indices to apply skip layer guidance to. Can be a single integer or a list of integers. If not
  provided, `skip_layer_config` must be provided.
- **auto_guidance_config** (`LayerSkipConfig` or `List[LayerSkipConfig]`, *optional*) --
  The configuration for the skip layer guidance. Can be a single `LayerSkipConfig` or a list of
  `LayerSkipConfig`. If not provided, `skip_layer_guidance_layers` must be provided.
- **dropout** (`float`, *optional*) --
  The dropout probability for autoguidance on the enabled skip layers (either with `auto_guidance_layers` or
  `auto_guidance_config`). If not provided, the dropout probability will be set to 1.0.
- **guidance_rescale** (`float`, defaults to `0.0`) --
  The rescale factor applied to the noise predictions. This is used to improve image quality and fix
  overexposure. Based on Section 3.4 from [Common Diffusion Noise Schedules and Sample Steps are
  Flawed](https://huggingface.co/papers/2305.08891).
- **use_original_formulation** (`bool`, defaults to `False`) --
  Whether to use the original formulation of classifier-free guidance as proposed in the paper. By default,
  we use the diffusers-native implementation that has been in the codebase for a long time. See
  [~guiders.classifier_free_guidance.ClassifierFreeGuidance] for more details.
- **start** (`float`, defaults to `0.0`) --
  The fraction of the total number of denoising steps after which guidance starts.
- **stop** (`float`, defaults to `1.0`) --
  The fraction of the total number of denoising steps after which guidance stops.</paramsdesc><paramgroups>0</paramgroups></docstring>

AutoGuidance: https://huggingface.co/papers/2406.02507




</div>

## TangentialClassifierFreeGuidance[[diffusers.TangentialClassifierFreeGuidance]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.TangentialClassifierFreeGuidance</name><anchor>diffusers.TangentialClassifierFreeGuidance</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/guiders/tangential_classifier_free_guidance.py#L28</source><parameters>[{"name": "guidance_scale", "val": ": float = 7.5"}, {"name": "guidance_rescale", "val": ": float = 0.0"}, {"name": "use_original_formulation", "val": ": bool = False"}, {"name": "start", "val": ": float = 0.0"}, {"name": "stop", "val": ": float = 1.0"}, {"name": "enabled", "val": ": bool = True"}]</parameters><paramsdesc>- **guidance_scale** (`float`, defaults to `7.5`) --
  The scale parameter for classifier-free guidance. Higher values result in stronger conditioning on the text
  prompt, while lower values allow for more freedom in generation. Higher values may lead to saturation and
  deterioration of image quality.
- **guidance_rescale** (`float`, defaults to `0.0`) --
  The rescale factor applied to the noise predictions. This is used to improve image quality and fix
  overexposure. Based on Section 3.4 from [Common Diffusion Noise Schedules and Sample Steps are
  Flawed](https://huggingface.co/papers/2305.08891).
- **use_original_formulation** (`bool`, defaults to `False`) --
  Whether to use the original formulation of classifier-free guidance as proposed in the paper. By default,
  we use the diffusers-native implementation that has been in the codebase for a long time. See
  [~guiders.classifier_free_guidance.ClassifierFreeGuidance] for more details.
- **start** (`float`, defaults to `0.0`) --
  The fraction of the total number of denoising steps after which guidance starts.
- **stop** (`float`, defaults to `1.0`) --
  The fraction of the total number of denoising steps after which guidance stops.</paramsdesc><paramgroups>0</paramgroups></docstring>

Tangential Classifier Free Guidance (TCFG): https://huggingface.co/papers/2503.18137




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/modular_diffusers/guiders.md" />