# VQModel

The VQ-VAE model was introduced in [Neural Discrete Representation Learning](https://huggingface.co/papers/1711.00937) by Aaron van den Oord, Oriol Vinyals and Koray Kavukcuoglu. The model is used in 🤗 Diffusers to decode latent representations into images. Unlike [AutoencoderKL](/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL), the [VQModel](/docs/diffusers/main/en/api/models/vq#diffusers.VQModel) works in a quantized latent space.

The abstract from the paper is:

*Learning useful representations without supervision remains a key challenge in machine learning. In this paper, we propose a simple yet powerful generative model that learns such discrete representations. Our model, the Vector Quantised-Variational AutoEncoder (VQ-VAE), differs from VAEs in two key ways: the encoder network outputs discrete, rather than continuous, codes; and the prior is learnt rather than static. In order to learn a discrete latent representation, we incorporate ideas from vector quantisation (VQ). Using the VQ method allows the model to circumvent issues of "posterior collapse" -- where the latents are ignored when they are paired with a powerful autoregressive decoder -- typically observed in the VAE framework. Pairing these representations with an autoregressive prior, the model can generate high quality images, videos, and speech as well as doing high quality speaker conversion and unsupervised learning of phonemes, providing further evidence of the utility of the learnt representations.*

## VQModel[[diffusers.VQModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.VQModel</name><anchor>diffusers.VQModel</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/vq_model.py#L41</source><parameters>[{"name": "in_channels", "val": ": int = 3"}, {"name": "out_channels", "val": ": int = 3"}, {"name": "down_block_types", "val": ": typing.Tuple[str, ...] = ('DownEncoderBlock2D',)"}, {"name": "up_block_types", "val": ": typing.Tuple[str, ...] = ('UpDecoderBlock2D',)"}, {"name": "block_out_channels", "val": ": typing.Tuple[int, ...] = (64,)"}, {"name": "layers_per_block", "val": ": int = 1"}, {"name": "act_fn", "val": ": str = 'silu'"}, {"name": "latent_channels", "val": ": int = 3"}, {"name": "sample_size", "val": ": int = 32"}, {"name": "num_vq_embeddings", "val": ": int = 256"}, {"name": "norm_num_groups", "val": ": int = 32"}, {"name": "vq_embed_dim", "val": ": typing.Optional[int] = None"}, {"name": "scaling_factor", "val": ": float = 0.18215"}, {"name": "norm_type", "val": ": str = 'group'"}, {"name": "mid_block_add_attention", "val": " = True"}, {"name": "lookup_from_codebook", "val": " = False"}, {"name": "force_upcast", "val": " = False"}]</parameters><paramsdesc>- **in_channels** (int, *optional*, defaults to 3) -- Number of channels in the input image.
- **out_channels** (int,  *optional*, defaults to 3) -- Number of channels in the output.
- **down_block_types** (`Tuple[str]`, *optional*, defaults to `("DownEncoderBlock2D",)`) --
  Tuple of downsample block types.
- **up_block_types** (`Tuple[str]`, *optional*, defaults to `("UpDecoderBlock2D",)`) --
  Tuple of upsample block types.
- **block_out_channels** (`Tuple[int]`, *optional*, defaults to `(64,)`) --
  Tuple of block output channels.
- **layers_per_block** (`int`, *optional*, defaults to `1`) -- Number of layers per block.
- **act_fn** (`str`, *optional*, defaults to `"silu"`) -- The activation function to use.
- **latent_channels** (`int`, *optional*, defaults to `3`) -- Number of channels in the latent space.
- **sample_size** (`int`, *optional*, defaults to `32`) -- Sample input size.
- **num_vq_embeddings** (`int`, *optional*, defaults to `256`) -- Number of codebook vectors in the VQ-VAE.
- **norm_num_groups** (`int`, *optional*, defaults to `32`) -- Number of groups for normalization layers.
- **vq_embed_dim** (`int`, *optional*) -- Hidden dim of codebook vectors in the VQ-VAE.
- **scaling_factor** (`float`, *optional*, defaults to `0.18215`) --
  The component-wise standard deviation of the trained latent space computed using the first batch of the
  training set. This is used to scale the latent space to have unit variance when training the diffusion
  model. The latents are scaled with the formula `z = z * scaling_factor` before being passed to the
  diffusion model. When decoding, the latents are scaled back to the original scale with the formula: `z = 1
  / scaling_factor * z`. For more details, refer to sections 4.3.2 and D.1 of the [High-Resolution Image
  Synthesis with Latent Diffusion Models](https://huggingface.co/papers/2112.10752) paper.
- **norm_type** (`str`, *optional*, defaults to `"group"`) --
  Type of normalization layer to use. Can be one of `"group"` or `"spatial"`.</paramsdesc><paramgroups>0</paramgroups></docstring>

A VQ-VAE model for decoding latent representations.

This model inherits from [ModelMixin](/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin). Check the superclass documentation for it's generic methods implemented
for all models (such as downloading or saving).





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>forward</name><anchor>diffusers.VQModel.forward</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/vq_model.py#L164</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) -- Input sample.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a [models.autoencoders.vq_model.VQEncoderOutput](/docs/diffusers/main/en/api/models/vq#diffusers.models.autoencoders.vq_model.VQEncoderOutput) instead of a plain tuple.</paramsdesc><paramgroups>0</paramgroups><rettype>[VQEncoderOutput](/docs/diffusers/main/en/api/models/vq#diffusers.models.autoencoders.vq_model.VQEncoderOutput) or `tuple`</rettype><retdesc>If return_dict is True, a [VQEncoderOutput](/docs/diffusers/main/en/api/models/vq#diffusers.models.autoencoders.vq_model.VQEncoderOutput) is returned, otherwise a
plain `tuple` is returned.</retdesc></docstring>

The [VQModel](/docs/diffusers/main/en/api/models/vq#diffusers.VQModel) forward method.








</div></div>

## VQEncoderOutput[[diffusers.models.autoencoders.vq_model.VQEncoderOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.autoencoders.vq_model.VQEncoderOutput</name><anchor>diffusers.models.autoencoders.vq_model.VQEncoderOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/vq_model.py#L29</source><parameters>[{"name": "latents", "val": ": Tensor"}]</parameters><paramsdesc>- **latents** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)`) --
  The encoded output sample from the last layer of the model.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output of VQModel encoding method.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/vq.md" />