# UNetMotionModel

The [UNet](https://huggingface.co/papers/1505.04597) model was originally introduced by Ronneberger et al for biomedical image segmentation, but it is also commonly used in 🤗 Diffusers because it outputs images that are the same size as the input. It is one of the most important components of a diffusion system because it facilitates the actual diffusion process. There are several variants of the UNet model in 🤗 Diffusers, depending on it's number of dimensions and whether it is a conditional model or not. This is a 2D UNet model.

The abstract from the paper is:

*There is large consent that successful training of deep networks requires many thousand annotated training samples. In this paper, we present a network and training strategy that relies on the strong use of data augmentation to use the available annotated samples more efficiently. The architecture consists of a contracting path to capture context and a symmetric expanding path that enables precise localization. We show that such a network can be trained end-to-end from very few images and outperforms the prior best method (a sliding-window convolutional network) on the ISBI challenge for segmentation of neuronal structures in electron microscopic stacks. Using the same network trained on transmitted light microscopy images (phase contrast and DIC) we won the ISBI cell tracking challenge 2015 in these categories by a large margin. Moreover, the network is fast. Segmentation of a 512x512 image takes less than a second on a recent GPU. The full implementation (based on Caffe) and the trained networks are available at http://lmb.informatik.uni-freiburg.de/people/ronneber/u-net.*

## UNetMotionModel[[diffusers.UNetMotionModel]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.UNetMotionModel</name><anchor>diffusers.UNetMotionModel</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_motion_model.py#L1198</source><parameters>[{"name": "sample_size", "val": ": typing.Optional[int] = None"}, {"name": "in_channels", "val": ": int = 4"}, {"name": "out_channels", "val": ": int = 4"}, {"name": "down_block_types", "val": ": typing.Tuple[str, ...] = ('CrossAttnDownBlockMotion', 'CrossAttnDownBlockMotion', 'CrossAttnDownBlockMotion', 'DownBlockMotion')"}, {"name": "up_block_types", "val": ": typing.Tuple[str, ...] = ('UpBlockMotion', 'CrossAttnUpBlockMotion', 'CrossAttnUpBlockMotion', 'CrossAttnUpBlockMotion')"}, {"name": "block_out_channels", "val": ": typing.Tuple[int, ...] = (320, 640, 1280, 1280)"}, {"name": "layers_per_block", "val": ": typing.Union[int, typing.Tuple[int]] = 2"}, {"name": "downsample_padding", "val": ": int = 1"}, {"name": "mid_block_scale_factor", "val": ": float = 1"}, {"name": "act_fn", "val": ": str = 'silu'"}, {"name": "norm_num_groups", "val": ": int = 32"}, {"name": "norm_eps", "val": ": float = 1e-05"}, {"name": "cross_attention_dim", "val": ": int = 1280"}, {"name": "transformer_layers_per_block", "val": ": typing.Union[int, typing.Tuple[int], typing.Tuple[typing.Tuple]] = 1"}, {"name": "reverse_transformer_layers_per_block", "val": ": typing.Union[int, typing.Tuple[int], typing.Tuple[typing.Tuple], NoneType] = None"}, {"name": "temporal_transformer_layers_per_block", "val": ": typing.Union[int, typing.Tuple[int], typing.Tuple[typing.Tuple]] = 1"}, {"name": "reverse_temporal_transformer_layers_per_block", "val": ": typing.Union[int, typing.Tuple[int], typing.Tuple[typing.Tuple], NoneType] = None"}, {"name": "transformer_layers_per_mid_block", "val": ": typing.Union[int, typing.Tuple[int], NoneType] = None"}, {"name": "temporal_transformer_layers_per_mid_block", "val": ": typing.Union[int, typing.Tuple[int], NoneType] = 1"}, {"name": "use_linear_projection", "val": ": bool = False"}, {"name": "num_attention_heads", "val": ": typing.Union[int, typing.Tuple[int, ...]] = 8"}, {"name": "motion_max_seq_length", "val": ": int = 32"}, {"name": "motion_num_attention_heads", "val": ": typing.Union[int, typing.Tuple[int, ...]] = 8"}, {"name": "reverse_motion_num_attention_heads", "val": ": typing.Union[int, typing.Tuple[int, ...], typing.Tuple[typing.Tuple[int, ...], ...], NoneType] = None"}, {"name": "use_motion_mid_block", "val": ": bool = True"}, {"name": "mid_block_layers", "val": ": int = 1"}, {"name": "encoder_hid_dim", "val": ": typing.Optional[int] = None"}, {"name": "encoder_hid_dim_type", "val": ": typing.Optional[str] = None"}, {"name": "addition_embed_type", "val": ": typing.Optional[str] = None"}, {"name": "addition_time_embed_dim", "val": ": typing.Optional[int] = None"}, {"name": "projection_class_embeddings_input_dim", "val": ": typing.Optional[int] = None"}, {"name": "time_cond_proj_dim", "val": ": typing.Optional[int] = None"}]</parameters></docstring>

A modified conditional 2D UNet model that takes a noisy sample, conditional state, and a timestep and returns a
sample shaped output.

This model inherits from [ModelMixin](/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin). Check the superclass documentation for it's generic methods implemented
for all models (such as downloading or saving).



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>disable_freeu</name><anchor>diffusers.UNetMotionModel.disable_freeu</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_motion_model.py#L1899</source><parameters>[]</parameters></docstring>
Disables the FreeU mechanism.

</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>enable_forward_chunking</name><anchor>diffusers.UNetMotionModel.enable_forward_chunking</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_motion_model.py#L1817</source><parameters>[{"name": "chunk_size", "val": ": typing.Optional[int] = None"}, {"name": "dim", "val": ": int = 0"}]</parameters><paramsdesc>- **chunk_size** (`int`, *optional*) --
  The chunk size of the feed-forward layers. If not specified, will run feed-forward layer individually
  over each tensor of dim=`dim`.
- **dim** (`int`, *optional*, defaults to `0`) --
  The dimension over which the feed-forward computation should be chunked. Choose between dim=0 (batch)
  or dim=1 (sequence length).</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the attention processor to use [feed forward
chunking](https://huggingface.co/blog/reformer#2-chunked-feed-forward-layers).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>enable_freeu</name><anchor>diffusers.UNetMotionModel.enable_freeu</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_motion_model.py#L1874</source><parameters>[{"name": "s1", "val": ": float"}, {"name": "s2", "val": ": float"}, {"name": "b1", "val": ": float"}, {"name": "b2", "val": ": float"}]</parameters><paramsdesc>- **s1** (`float`) --
  Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
  mitigate the "oversmoothing effect" in the enhanced denoising process.
- **s2** (`float`) --
  Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
  mitigate the "oversmoothing effect" in the enhanced denoising process.
- **b1** (`float`) -- Scaling factor for stage 1 to amplify the contributions of backbone features.
- **b2** (`float`) -- Scaling factor for stage 2 to amplify the contributions of backbone features.</paramsdesc><paramgroups>0</paramgroups></docstring>
Enables the FreeU mechanism from https://huggingface.co/papers/2309.11497.

The suffixes after the scaling factors represent the stage blocks where they are being applied.

Please refer to the [official repository](https://github.com/ChenyangSi/FreeU) for combinations of values that
are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>forward</name><anchor>diffusers.UNetMotionModel.forward</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_motion_model.py#L1939</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Union[torch.Tensor, float, int]"}, {"name": "encoder_hidden_states", "val": ": Tensor"}, {"name": "timestep_cond", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "attention_mask", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "cross_attention_kwargs", "val": ": typing.Optional[typing.Dict[str, typing.Any]] = None"}, {"name": "added_cond_kwargs", "val": ": typing.Optional[typing.Dict[str, torch.Tensor]] = None"}, {"name": "down_block_additional_residuals", "val": ": typing.Optional[typing.Tuple[torch.Tensor]] = None"}, {"name": "mid_block_additional_residual", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The noisy input tensor with the following shape `(batch, num_frames, channel, height, width`.
- **timestep** (`torch.Tensor` or `float` or `int`) -- The number of timesteps to denoise an input.
- **encoder_hidden_states** (`torch.Tensor`) --
  The encoder hidden states with shape `(batch, sequence_length, feature_dim)`.
- **timestep_cond** -- (`torch.Tensor`, *optional*, defaults to `None`):
  Conditional embeddings for timestep. If provided, the embeddings will be summed with the samples passed
  through the `self.time_embedding` layer to obtain the timestep embeddings.
- **attention_mask** (`torch.Tensor`, *optional*, defaults to `None`) --
  An attention mask of shape `(batch, key_tokens)` is applied to `encoder_hidden_states`. If `1` the mask
  is kept, otherwise if `0` it is discarded. Mask will be converted into a bias, which adds large
  negative values to the attention scores corresponding to "discard" tokens.
- **cross_attention_kwargs** (`dict`, *optional*) --
  A kwargs dictionary that if specified is passed along to the `AttentionProcessor` as defined under
  `self.processor` in
  [diffusers.models.attention_processor](https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py).
- **down_block_additional_residuals** -- (`tuple` of `torch.Tensor`, *optional*):
  A tuple of tensors that if specified are added to the residuals of down unet blocks.
- **mid_block_additional_residual** -- (`torch.Tensor`, *optional*):
  A tensor that if specified is added to the residual of the middle unet block.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a `UNetMotionOutput` instead of a plain
  tuple.</paramsdesc><paramgroups>0</paramgroups><rettype>`UNetMotionOutput` or `tuple`</rettype><retdesc>If `return_dict` is True, an `UNetMotionOutput` is returned,
otherwise a `tuple` is returned where the first element is the sample tensor.</retdesc></docstring>

The [UNetMotionModel](/docs/diffusers/main/en/api/models/unet-motion#diffusers.UNetMotionModel) forward method.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>freeze_unet2d_params</name><anchor>diffusers.UNetMotionModel.freeze_unet2d_params</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_motion_model.py#L1688</source><parameters>[]</parameters></docstring>
Freeze the weights of just the UNet2DConditionModel, and leave the motion modules
unfrozen for fine tuning.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>fuse_qkv_projections</name><anchor>diffusers.UNetMotionModel.fuse_qkv_projections</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_motion_model.py#L1908</source><parameters>[]</parameters></docstring>

Enables fused QKV projections. For self-attention modules, all projection matrices (i.e., query, key, value)
are fused. For cross-attention modules, key and value projection matrices are fused.

> [!WARNING] > This API is 🧪 experimental.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_attn_processor</name><anchor>diffusers.UNetMotionModel.set_attn_processor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_motion_model.py#L1783</source><parameters>[{"name": "processor", "val": ": typing.Union[diffusers.models.attention_processor.AttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor2_0, diffusers.models.attention_processor.JointAttnProcessor2_0, diffusers.models.attention_processor.PAGJointAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGJointAttnProcessor2_0, diffusers.models.attention_processor.FusedJointAttnProcessor2_0, diffusers.models.attention_processor.AllegroAttnProcessor2_0, diffusers.models.attention_processor.AuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FusedAuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.CogVideoXAttnProcessor2_0, diffusers.models.attention_processor.FusedCogVideoXAttnProcessor2_0, diffusers.models.attention_processor.XFormersAttnAddedKVProcessor, diffusers.models.attention_processor.XFormersAttnProcessor, diffusers.models.attention_processor.XLAFlashAttnProcessor2_0, diffusers.models.attention_processor.AttnProcessorNPU, diffusers.models.attention_processor.AttnProcessor2_0, diffusers.models.attention_processor.MochiVaeAttnProcessor2_0, diffusers.models.attention_processor.MochiAttnProcessor2_0, diffusers.models.attention_processor.StableAudioAttnProcessor2_0, diffusers.models.attention_processor.HunyuanAttnProcessor2_0, diffusers.models.attention_processor.FusedHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.LuminaAttnProcessor2_0, diffusers.models.attention_processor.FusedAttnProcessor2_0, diffusers.models.attention_processor.CustomDiffusionXFormersAttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor2_0, diffusers.models.attention_processor.SlicedAttnProcessor, diffusers.models.attention_processor.SlicedAttnAddedKVProcessor, diffusers.models.attention_processor.SanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGSanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySanaLinearAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleLinearAttention, diffusers.models.attention_processor.SanaMultiscaleAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleAttentionProjection, diffusers.models.attention_processor.IPAdapterAttnProcessor, diffusers.models.attention_processor.IPAdapterAttnProcessor2_0, diffusers.models.attention_processor.IPAdapterXFormersAttnProcessor, diffusers.models.attention_processor.SD3IPAdapterJointAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.LoRAAttnProcessor, diffusers.models.attention_processor.LoRAAttnProcessor2_0, diffusers.models.attention_processor.LoRAXFormersAttnProcessor, diffusers.models.attention_processor.LoRAAttnAddedKVProcessor, typing.Dict[str, typing.Union[diffusers.models.attention_processor.AttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor2_0, diffusers.models.attention_processor.JointAttnProcessor2_0, diffusers.models.attention_processor.PAGJointAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGJointAttnProcessor2_0, diffusers.models.attention_processor.FusedJointAttnProcessor2_0, diffusers.models.attention_processor.AllegroAttnProcessor2_0, diffusers.models.attention_processor.AuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FusedAuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.CogVideoXAttnProcessor2_0, diffusers.models.attention_processor.FusedCogVideoXAttnProcessor2_0, diffusers.models.attention_processor.XFormersAttnAddedKVProcessor, diffusers.models.attention_processor.XFormersAttnProcessor, diffusers.models.attention_processor.XLAFlashAttnProcessor2_0, diffusers.models.attention_processor.AttnProcessorNPU, diffusers.models.attention_processor.AttnProcessor2_0, diffusers.models.attention_processor.MochiVaeAttnProcessor2_0, diffusers.models.attention_processor.MochiAttnProcessor2_0, diffusers.models.attention_processor.StableAudioAttnProcessor2_0, diffusers.models.attention_processor.HunyuanAttnProcessor2_0, diffusers.models.attention_processor.FusedHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.LuminaAttnProcessor2_0, diffusers.models.attention_processor.FusedAttnProcessor2_0, diffusers.models.attention_processor.CustomDiffusionXFormersAttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor2_0, diffusers.models.attention_processor.SlicedAttnProcessor, diffusers.models.attention_processor.SlicedAttnAddedKVProcessor, diffusers.models.attention_processor.SanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGSanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySanaLinearAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleLinearAttention, diffusers.models.attention_processor.SanaMultiscaleAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleAttentionProjection, diffusers.models.attention_processor.IPAdapterAttnProcessor, diffusers.models.attention_processor.IPAdapterAttnProcessor2_0, diffusers.models.attention_processor.IPAdapterXFormersAttnProcessor, diffusers.models.attention_processor.SD3IPAdapterJointAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.LoRAAttnProcessor, diffusers.models.attention_processor.LoRAAttnProcessor2_0, diffusers.models.attention_processor.LoRAXFormersAttnProcessor, diffusers.models.attention_processor.LoRAAttnAddedKVProcessor]]]"}]</parameters><paramsdesc>- **processor** (`dict` of `AttentionProcessor` or only `AttentionProcessor`) --
  The instantiated processor class or a dictionary of processor classes that will be set as the processor
  for **all** `Attention` layers.

  If `processor` is a dict, the key needs to define the path to the corresponding cross attention
  processor. This is strongly recommended when setting trainable attention processors.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the attention processor to use to compute attention.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_default_attn_processor</name><anchor>diffusers.UNetMotionModel.set_default_attn_processor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_motion_model.py#L1858</source><parameters>[]</parameters></docstring>

Disables custom attention processors and sets the default attention implementation.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>unfuse_qkv_projections</name><anchor>diffusers.UNetMotionModel.unfuse_qkv_projections</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_motion_model.py#L1930</source><parameters>[]</parameters></docstring>
Disables the fused QKV projection if enabled.

> [!WARNING] > This API is 🧪 experimental.



</div></div>

## UNet3DConditionOutput[[diffusers.models.unets.unet_3d_condition.UNet3DConditionOutput]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.unets.unet_3d_condition.UNet3DConditionOutput</name><anchor>diffusers.models.unets.unet_3d_condition.UNet3DConditionOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unets/unet_3d_condition.py#L49</source><parameters>[{"name": "sample", "val": ": Tensor"}]</parameters><paramsdesc>- **sample** (`torch.Tensor` of shape `(batch_size, num_channels, num_frames, height, width)`) --
  The hidden states output conditioned on `encoder_hidden_states` input. Output of last layer of model.</paramsdesc><paramgroups>0</paramgroups></docstring>

The output of [UNet3DConditionModel](/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel).




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/unet-motion.md" />