# QwenImageTransformer2DModel

The model can be loaded with the following code snippet.

```python
from diffusers import QwenImageTransformer2DModel

transformer = QwenImageTransformer2DModel.from_pretrained("Qwen/QwenImage-20B", subfolder="transformer", torch_dtype=torch.bfloat16)
```

## QwenImageTransformer2DModel[[diffusers.QwenImageTransformer2DModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.QwenImageTransformer2DModel</name><anchor>diffusers.QwenImageTransformer2DModel</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/transformer_qwenimage.py#L479</source><parameters>[{"name": "patch_size", "val": ": int = 2"}, {"name": "in_channels", "val": ": int = 64"}, {"name": "out_channels", "val": ": typing.Optional[int] = 16"}, {"name": "num_layers", "val": ": int = 60"}, {"name": "attention_head_dim", "val": ": int = 128"}, {"name": "num_attention_heads", "val": ": int = 24"}, {"name": "joint_attention_dim", "val": ": int = 3584"}, {"name": "guidance_embeds", "val": ": bool = False"}, {"name": "axes_dims_rope", "val": ": typing.Tuple[int, int, int] = (16, 56, 56)"}]</parameters><paramsdesc>- **patch_size** (`int`, defaults to `2`) --
  Patch size to turn the input data into small patches.
- **in_channels** (`int`, defaults to `64`) --
  The number of channels in the input.
- **out_channels** (`int`, *optional*, defaults to `None`) --
  The number of channels in the output. If not specified, it defaults to `in_channels`.
- **num_layers** (`int`, defaults to `60`) --
  The number of layers of dual stream DiT blocks to use.
- **attention_head_dim** (`int`, defaults to `128`) --
  The number of dimensions to use for each attention head.
- **num_attention_heads** (`int`, defaults to `24`) --
  The number of attention heads to use.
- **joint_attention_dim** (`int`, defaults to `3584`) --
  The number of dimensions to use for the joint attention (embedding/channel dimension of
  `encoder_hidden_states`).
- **guidance_embeds** (`bool`, defaults to `False`) --
  Whether to use guidance embeddings for guidance-distilled variant of the model.
- **axes_dims_rope** (`Tuple[int]`, defaults to `(16, 56, 56)`) --
  The dimensions to use for the rotary positional embeddings.</paramsdesc><paramgroups>0</paramgroups></docstring>

The Transformer model introduced in Qwen.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>forward</name><anchor>diffusers.QwenImageTransformer2DModel.forward</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/transformer_qwenimage.py#L566</source><parameters>[{"name": "hidden_states", "val": ": Tensor"}, {"name": "encoder_hidden_states", "val": ": Tensor = None"}, {"name": "encoder_hidden_states_mask", "val": ": Tensor = None"}, {"name": "timestep", "val": ": LongTensor = None"}, {"name": "img_shapes", "val": ": typing.Optional[typing.List[typing.Tuple[int, int, int]]] = None"}, {"name": "txt_seq_lens", "val": ": typing.Optional[typing.List[int]] = None"}, {"name": "guidance", "val": ": Tensor = None"}, {"name": "attention_kwargs", "val": ": typing.Optional[typing.Dict[str, typing.Any]] = None"}, {"name": "controlnet_block_samples", "val": " = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **hidden_states** (`torch.Tensor` of shape `(batch_size, image_sequence_length, in_channels)`) --
  Input `hidden_states`.
- **encoder_hidden_states** (`torch.Tensor` of shape `(batch_size, text_sequence_length, joint_attention_dim)`) --
  Conditional embeddings (embeddings computed from the input conditions such as prompts) to use.
- **encoder_hidden_states_mask** (`torch.Tensor` of shape `(batch_size, text_sequence_length)`) --
  Mask of the input conditions.
- **timestep** ( `torch.LongTensor`) --
  Used to indicate denoising step.
- **attention_kwargs** (`dict`, *optional*) --
  A kwargs dictionary that if specified is passed along to the `AttentionProcessor` as defined under
  `self.processor` in
  [diffusers.models.attention_processor](https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py).
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a `~models.transformer_2d.Transformer2DModelOutput` instead of a plain
  tuple.</paramsdesc><paramgroups>0</paramgroups><retdesc>If `return_dict` is True, an `~models.transformer_2d.Transformer2DModelOutput` is returned, otherwise a
`tuple` where the first element is the sample tensor.</retdesc></docstring>

The `QwenTransformer2DModel` forward method.






</div></div>

## Transformer2DModelOutput[[diffusers.models.modeling_outputs.Transformer2DModelOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.modeling_outputs.Transformer2DModelOutput</name><anchor>diffusers.models.modeling_outputs.Transformer2DModelOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_outputs.py#L21</source><parameters>[{"name": "sample", "val": ": torch.Tensor"}]</parameters><paramsdesc>- **sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` or `(batch size, num_vector_embeds - 1, num_latent_pixels)` if [Transformer2DModel](/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel) is discrete) --
  The hidden states output conditioned on the `encoder_hidden_states` input. If discrete, returns probability
  distributions for the unnoised latent pixels.</paramsdesc><paramgroups>0</paramgroups></docstring>

The output of [Transformer2DModel](/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel).




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/qwenimage_transformer2d.md" />