# PriorTransformer

The Prior Transformer was originally introduced in [Hierarchical Text-Conditional Image Generation with CLIP Latents](https://huggingface.co/papers/2204.06125) by Ramesh et al. It is used to predict CLIP image embeddings from CLIP text embeddings; image embeddings are predicted through a denoising diffusion process.

The abstract from the paper is:

*Contrastive models like CLIP have been shown to learn robust representations of images that capture both semantics and style. To leverage these representations for image generation, we propose a two-stage model: a prior that generates a CLIP image embedding given a text caption, and a decoder that generates an image conditioned on the image embedding. We show that explicitly generating image representations improves image diversity with minimal loss in photorealism and caption similarity. Our decoders conditioned on image representations can also produce variations of an image that preserve both its semantics and style, while varying the non-essential details absent from the image representation. Moreover, the joint embedding space of CLIP enables language-guided image manipulations in a zero-shot fashion. We use diffusion models for the decoder and experiment with both autoregressive and diffusion models for the prior, finding that the latter are computationally more efficient and produce higher-quality samples.*

## PriorTransformer[[diffusers.PriorTransformer]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.PriorTransformer</name><anchor>diffusers.PriorTransformer</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/prior_transformer.py#L36</source><parameters>[{"name": "num_attention_heads", "val": ": int = 32"}, {"name": "attention_head_dim", "val": ": int = 64"}, {"name": "num_layers", "val": ": int = 20"}, {"name": "embedding_dim", "val": ": int = 768"}, {"name": "num_embeddings", "val": " = 77"}, {"name": "additional_embeddings", "val": " = 4"}, {"name": "dropout", "val": ": float = 0.0"}, {"name": "time_embed_act_fn", "val": ": str = 'silu'"}, {"name": "norm_in_type", "val": ": typing.Optional[str] = None"}, {"name": "embedding_proj_norm_type", "val": ": typing.Optional[str] = None"}, {"name": "encoder_hid_proj_type", "val": ": typing.Optional[str] = 'linear'"}, {"name": "added_emb_type", "val": ": typing.Optional[str] = 'prd'"}, {"name": "time_embed_dim", "val": ": typing.Optional[int] = None"}, {"name": "embedding_proj_dim", "val": ": typing.Optional[int] = None"}, {"name": "clip_embed_dim", "val": ": typing.Optional[int] = None"}]</parameters><paramsdesc>- **num_attention_heads** (`int`, *optional*, defaults to 32) -- The number of heads to use for multi-head attention.
- **attention_head_dim** (`int`, *optional*, defaults to 64) -- The number of channels in each head.
- **num_layers** (`int`, *optional*, defaults to 20) -- The number of layers of Transformer blocks to use.
- **embedding_dim** (`int`, *optional*, defaults to 768) -- The dimension of the model input `hidden_states`
- **num_embeddings** (`int`, *optional*, defaults to 77) --
  The number of embeddings of the model input `hidden_states`
- **additional_embeddings** (`int`, *optional*, defaults to 4) -- The number of additional tokens appended to the
  projected `hidden_states`. The actual length of the used `hidden_states` is `num_embeddings +
  additional_embeddings`.
- **dropout** (`float`, *optional*, defaults to 0.0) -- The dropout probability to use.
- **time_embed_act_fn** (`str`, *optional*, defaults to 'silu') --
  The activation function to use to create timestep embeddings.
- **norm_in_type** (`str`, *optional*, defaults to None) -- The normalization layer to apply on hidden states before
  passing to Transformer blocks. Set it to `None` if normalization is not needed.
- **embedding_proj_norm_type** (`str`, *optional*, defaults to None) --
  The normalization layer to apply on the input `proj_embedding`. Set it to `None` if normalization is not
  needed.
- **encoder_hid_proj_type** (`str`, *optional*, defaults to `linear`) --
  The projection layer to apply on the input `encoder_hidden_states`. Set it to `None` if
  `encoder_hidden_states` is `None`.
- **added_emb_type** (`str`, *optional*, defaults to `prd`) -- Additional embeddings to condition the model.
  Choose from `prd` or `None`. if choose `prd`, it will prepend a token indicating the (quantized) dot
  product between the text embedding and image embedding as proposed in the unclip paper
  https://huggingface.co/papers/2204.06125 If it is `None`, no additional embeddings will be prepended.
- **time_embed_dim** (`int, *optional*, defaults to None) -- The dimension of timestep embeddings.
  If None, will be set to `num_attention_heads * attention_head_dim`
- **embedding_proj_dim** (`int`, *optional*, default to None) --
  The dimension of `proj_embedding`. If None, will be set to `embedding_dim`.
- **clip_embed_dim** (`int`, *optional*, default to None) --
  The dimension of the output. If None, will be set to `embedding_dim`.</paramsdesc><paramgroups>0</paramgroups></docstring>

A Prior Transformer model.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>forward</name><anchor>diffusers.PriorTransformer.forward</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/prior_transformer.py#L245</source><parameters>[{"name": "hidden_states", "val": ""}, {"name": "timestep", "val": ": typing.Union[torch.Tensor, float, int]"}, {"name": "proj_embedding", "val": ": Tensor"}, {"name": "encoder_hidden_states", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "attention_mask", "val": ": typing.Optional[torch.BoolTensor] = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **hidden_states** (`torch.Tensor` of shape `(batch_size, embedding_dim)`) --
  The currently predicted image embeddings.
- **timestep** (`torch.LongTensor`) --
  Current denoising step.
- **proj_embedding** (`torch.Tensor` of shape `(batch_size, embedding_dim)`) --
  Projected embedding vector the denoising process is conditioned on.
- **encoder_hidden_states** (`torch.Tensor` of shape `(batch_size, num_embeddings, embedding_dim)`) --
  Hidden states of the text embeddings the denoising process is conditioned on.
- **attention_mask** (`torch.BoolTensor` of shape `(batch_size, num_embeddings)`) --
  Text mask for the text embeddings.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a [PriorTransformerOutput](/docs/diffusers/main/en/api/models/prior_transformer#diffusers.models.transformers.prior_transformer.PriorTransformerOutput) instead of
  a plain tuple.</paramsdesc><paramgroups>0</paramgroups><rettype>[PriorTransformerOutput](/docs/diffusers/main/en/api/models/prior_transformer#diffusers.models.transformers.prior_transformer.PriorTransformerOutput) or `tuple`</rettype><retdesc>If return_dict is True, a [PriorTransformerOutput](/docs/diffusers/main/en/api/models/prior_transformer#diffusers.models.transformers.prior_transformer.PriorTransformerOutput) is
returned, otherwise a tuple is returned where the first element is the sample tensor.</retdesc></docstring>

The [PriorTransformer](/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer) forward method.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_attn_processor</name><anchor>diffusers.PriorTransformer.set_attn_processor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/prior_transformer.py#L195</source><parameters>[{"name": "processor", "val": ": typing.Union[diffusers.models.attention_processor.AttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor2_0, diffusers.models.attention_processor.JointAttnProcessor2_0, diffusers.models.attention_processor.PAGJointAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGJointAttnProcessor2_0, diffusers.models.attention_processor.FusedJointAttnProcessor2_0, diffusers.models.attention_processor.AllegroAttnProcessor2_0, diffusers.models.attention_processor.AuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FusedAuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.CogVideoXAttnProcessor2_0, diffusers.models.attention_processor.FusedCogVideoXAttnProcessor2_0, diffusers.models.attention_processor.XFormersAttnAddedKVProcessor, diffusers.models.attention_processor.XFormersAttnProcessor, diffusers.models.attention_processor.XLAFlashAttnProcessor2_0, diffusers.models.attention_processor.AttnProcessorNPU, diffusers.models.attention_processor.AttnProcessor2_0, diffusers.models.attention_processor.MochiVaeAttnProcessor2_0, diffusers.models.attention_processor.MochiAttnProcessor2_0, diffusers.models.attention_processor.StableAudioAttnProcessor2_0, diffusers.models.attention_processor.HunyuanAttnProcessor2_0, diffusers.models.attention_processor.FusedHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.LuminaAttnProcessor2_0, diffusers.models.attention_processor.FusedAttnProcessor2_0, diffusers.models.attention_processor.CustomDiffusionXFormersAttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor2_0, diffusers.models.attention_processor.SlicedAttnProcessor, diffusers.models.attention_processor.SlicedAttnAddedKVProcessor, diffusers.models.attention_processor.SanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGSanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySanaLinearAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleLinearAttention, diffusers.models.attention_processor.SanaMultiscaleAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleAttentionProjection, diffusers.models.attention_processor.IPAdapterAttnProcessor, diffusers.models.attention_processor.IPAdapterAttnProcessor2_0, diffusers.models.attention_processor.IPAdapterXFormersAttnProcessor, diffusers.models.attention_processor.SD3IPAdapterJointAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.LoRAAttnProcessor, diffusers.models.attention_processor.LoRAAttnProcessor2_0, diffusers.models.attention_processor.LoRAXFormersAttnProcessor, diffusers.models.attention_processor.LoRAAttnAddedKVProcessor, typing.Dict[str, typing.Union[diffusers.models.attention_processor.AttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor, diffusers.models.attention_processor.AttnAddedKVProcessor2_0, diffusers.models.attention_processor.JointAttnProcessor2_0, diffusers.models.attention_processor.PAGJointAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGJointAttnProcessor2_0, diffusers.models.attention_processor.FusedJointAttnProcessor2_0, diffusers.models.attention_processor.AllegroAttnProcessor2_0, diffusers.models.attention_processor.AuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FusedAuraFlowAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0, diffusers.models.attention_processor.FluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0, diffusers.models.attention_processor.FusedFluxAttnProcessor2_0_NPU, diffusers.models.attention_processor.CogVideoXAttnProcessor2_0, diffusers.models.attention_processor.FusedCogVideoXAttnProcessor2_0, diffusers.models.attention_processor.XFormersAttnAddedKVProcessor, diffusers.models.attention_processor.XFormersAttnProcessor, diffusers.models.attention_processor.XLAFlashAttnProcessor2_0, diffusers.models.attention_processor.AttnProcessorNPU, diffusers.models.attention_processor.AttnProcessor2_0, diffusers.models.attention_processor.MochiVaeAttnProcessor2_0, diffusers.models.attention_processor.MochiAttnProcessor2_0, diffusers.models.attention_processor.StableAudioAttnProcessor2_0, diffusers.models.attention_processor.HunyuanAttnProcessor2_0, diffusers.models.attention_processor.FusedHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGHunyuanAttnProcessor2_0, diffusers.models.attention_processor.LuminaAttnProcessor2_0, diffusers.models.attention_processor.FusedAttnProcessor2_0, diffusers.models.attention_processor.CustomDiffusionXFormersAttnProcessor, diffusers.models.attention_processor.CustomDiffusionAttnProcessor2_0, diffusers.models.attention_processor.SlicedAttnProcessor, diffusers.models.attention_processor.SlicedAttnAddedKVProcessor, diffusers.models.attention_processor.SanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGSanaLinearAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySanaLinearAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleLinearAttention, diffusers.models.attention_processor.SanaMultiscaleAttnProcessor2_0, diffusers.models.attention_processor.SanaMultiscaleAttentionProjection, diffusers.models.attention_processor.IPAdapterAttnProcessor, diffusers.models.attention_processor.IPAdapterAttnProcessor2_0, diffusers.models.attention_processor.IPAdapterXFormersAttnProcessor, diffusers.models.attention_processor.SD3IPAdapterJointAttnProcessor2_0, diffusers.models.attention_processor.PAGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.PAGCFGIdentitySelfAttnProcessor2_0, diffusers.models.attention_processor.LoRAAttnProcessor, diffusers.models.attention_processor.LoRAAttnProcessor2_0, diffusers.models.attention_processor.LoRAXFormersAttnProcessor, diffusers.models.attention_processor.LoRAAttnAddedKVProcessor]]]"}]</parameters><paramsdesc>- **processor** (`dict` of `AttentionProcessor` or only `AttentionProcessor`) --
  The instantiated processor class or a dictionary of processor classes that will be set as the processor
  for **all** `Attention` layers.

  If `processor` is a dict, the key needs to define the path to the corresponding cross attention
  processor. This is strongly recommended when setting trainable attention processors.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the attention processor to use to compute attention.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_default_attn_processor</name><anchor>diffusers.PriorTransformer.set_default_attn_processor</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/prior_transformer.py#L230</source><parameters>[]</parameters></docstring>

Disables custom attention processors and sets the default attention implementation.


</div></div>

## PriorTransformerOutput[[diffusers.models.transformers.prior_transformer.PriorTransformerOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.transformers.prior_transformer.PriorTransformerOutput</name><anchor>diffusers.models.transformers.prior_transformer.PriorTransformerOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/prior_transformer.py#L24</source><parameters>[{"name": "predicted_image_embedding", "val": ": Tensor"}]</parameters><paramsdesc>- **predicted_image_embedding** (`torch.Tensor` of shape `(batch_size, embedding_dim)`) --
  The predicted CLIP image embedding conditioned on the CLIP text embedding input.</paramsdesc><paramgroups>0</paramgroups></docstring>

The output of [PriorTransformer](/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer).




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/prior_transformer.md" />