# AutoencoderDC

The 2D Autoencoder model used in [SANA](https://huggingface.co/papers/2410.10629) and introduced in [DCAE](https://huggingface.co/papers/2410.10733) by authors Junyu Chen\*, Han Cai\*, Junsong Chen, Enze Xie, Shang Yang, Haotian Tang, Muyang Li, Yao Lu, Song Han from MIT HAN Lab.

The abstract from the paper is:

*We present Deep Compression Autoencoder (DC-AE), a new family of autoencoder models for accelerating high-resolution diffusion models. Existing autoencoder models have demonstrated impressive results at a moderate spatial compression ratio (e.g., 8x), but fail to maintain satisfactory reconstruction accuracy for high spatial compression ratios (e.g., 64x). We address this challenge by introducing two key techniques: (1) Residual Autoencoding, where we design our models to learn residuals based on the space-to-channel transformed features to alleviate the optimization difficulty of high spatial-compression autoencoders; (2) Decoupled High-Resolution Adaptation, an efficient decoupled three-phases training strategy for mitigating the generalization penalty of high spatial-compression autoencoders. With these designs, we improve the autoencoder's spatial compression ratio up to 128 while maintaining the reconstruction quality. Applying our DC-AE to latent diffusion models, we achieve significant speedup without accuracy drop. For example, on ImageNet 512x512, our DC-AE provides 19.1x inference speedup and 17.9x training speedup on H100 GPU for UViT-H while achieving a better FID, compared with the widely used SD-VAE-f8 autoencoder. Our code is available at [this https URL](https://github.com/mit-han-lab/efficientvit).*

The following DCAE models are released and supported in Diffusers.

| Diffusers format | Original format |
|:----------------:|:---------------:|
| [`mit-han-lab/dc-ae-f32c32-sana-1.0-diffusers`](https://huggingface.co/mit-han-lab/dc-ae-f32c32-sana-1.0-diffusers) | [`mit-han-lab/dc-ae-f32c32-sana-1.0`](https://huggingface.co/mit-han-lab/dc-ae-f32c32-sana-1.0)
| [`mit-han-lab/dc-ae-f32c32-in-1.0-diffusers`](https://huggingface.co/mit-han-lab/dc-ae-f32c32-in-1.0-diffusers) | [`mit-han-lab/dc-ae-f32c32-in-1.0`](https://huggingface.co/mit-han-lab/dc-ae-f32c32-in-1.0)
| [`mit-han-lab/dc-ae-f32c32-mix-1.0-diffusers`](https://huggingface.co/mit-han-lab/dc-ae-f32c32-mix-1.0-diffusers) | [`mit-han-lab/dc-ae-f32c32-mix-1.0`](https://huggingface.co/mit-han-lab/dc-ae-f32c32-mix-1.0)
| [`mit-han-lab/dc-ae-f64c128-in-1.0-diffusers`](https://huggingface.co/mit-han-lab/dc-ae-f64c128-in-1.0-diffusers) | [`mit-han-lab/dc-ae-f64c128-in-1.0`](https://huggingface.co/mit-han-lab/dc-ae-f64c128-in-1.0)
| [`mit-han-lab/dc-ae-f64c128-mix-1.0-diffusers`](https://huggingface.co/mit-han-lab/dc-ae-f64c128-mix-1.0-diffusers) | [`mit-han-lab/dc-ae-f64c128-mix-1.0`](https://huggingface.co/mit-han-lab/dc-ae-f64c128-mix-1.0)
| [`mit-han-lab/dc-ae-f128c512-in-1.0-diffusers`](https://huggingface.co/mit-han-lab/dc-ae-f128c512-in-1.0-diffusers) | [`mit-han-lab/dc-ae-f128c512-in-1.0`](https://huggingface.co/mit-han-lab/dc-ae-f128c512-in-1.0)
| [`mit-han-lab/dc-ae-f128c512-mix-1.0-diffusers`](https://huggingface.co/mit-han-lab/dc-ae-f128c512-mix-1.0-diffusers) | [`mit-han-lab/dc-ae-f128c512-mix-1.0`](https://huggingface.co/mit-han-lab/dc-ae-f128c512-mix-1.0)

This model was contributed by [lawrence-cj](https://github.com/lawrence-cj).

Load a model in Diffusers format with [from_pretrained()](/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained).

```python
from diffusers import AutoencoderDC

ae = AutoencoderDC.from_pretrained("mit-han-lab/dc-ae-f32c32-sana-1.0-diffusers", torch_dtype=torch.float32).to("cuda")
```

## Load a model in Diffusers via `from_single_file`

```python
from difusers import AutoencoderDC

ckpt_path = "https://huggingface.co/mit-han-lab/dc-ae-f32c32-sana-1.0/blob/main/model.safetensors"
model = AutoencoderDC.from_single_file(ckpt_path) 

```

The `AutoencoderDC` model has `in` and `mix` single file checkpoint variants that have matching checkpoint keys, but use different scaling factors. It is not possible for Diffusers to automatically infer the correct config file to use with the model based on just the checkpoint and will default to configuring the model using the `mix` variant config file. To override the automatically determined config, please use the `config` argument when using single file loading with `in` variant checkpoints. 

```python
from diffusers import AutoencoderDC

ckpt_path = "https://huggingface.co/mit-han-lab/dc-ae-f128c512-in-1.0/blob/main/model.safetensors"
model = AutoencoderDC.from_single_file(ckpt_path, config="mit-han-lab/dc-ae-f128c512-in-1.0-diffusers")
```


## AutoencoderDC[[diffusers.AutoencoderDC]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.AutoencoderDC</name><anchor>diffusers.AutoencoderDC</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_dc.py#L381</source><parameters>[{"name": "in_channels", "val": ": int = 3"}, {"name": "latent_channels", "val": ": int = 32"}, {"name": "attention_head_dim", "val": ": int = 32"}, {"name": "encoder_block_types", "val": ": typing.Union[str, typing.Tuple[str]] = 'ResBlock'"}, {"name": "decoder_block_types", "val": ": typing.Union[str, typing.Tuple[str]] = 'ResBlock'"}, {"name": "encoder_block_out_channels", "val": ": typing.Tuple[int, ...] = (128, 256, 512, 512, 1024, 1024)"}, {"name": "decoder_block_out_channels", "val": ": typing.Tuple[int, ...] = (128, 256, 512, 512, 1024, 1024)"}, {"name": "encoder_layers_per_block", "val": ": typing.Tuple[int, ...] = (2, 2, 2, 3, 3, 3)"}, {"name": "decoder_layers_per_block", "val": ": typing.Tuple[int, ...] = (3, 3, 3, 3, 3, 3)"}, {"name": "encoder_qkv_multiscales", "val": ": typing.Tuple[typing.Tuple[int, ...], ...] = ((), (), (), (5,), (5,), (5,))"}, {"name": "decoder_qkv_multiscales", "val": ": typing.Tuple[typing.Tuple[int, ...], ...] = ((), (), (), (5,), (5,), (5,))"}, {"name": "upsample_block_type", "val": ": str = 'pixel_shuffle'"}, {"name": "downsample_block_type", "val": ": str = 'pixel_unshuffle'"}, {"name": "decoder_norm_types", "val": ": typing.Union[str, typing.Tuple[str]] = 'rms_norm'"}, {"name": "decoder_act_fns", "val": ": typing.Union[str, typing.Tuple[str]] = 'silu'"}, {"name": "encoder_out_shortcut", "val": ": bool = True"}, {"name": "decoder_in_shortcut", "val": ": bool = True"}, {"name": "decoder_conv_act_fn", "val": ": str = 'relu'"}, {"name": "scaling_factor", "val": ": float = 1.0"}]</parameters><paramsdesc>- **in_channels** (`int`, defaults to `3`) --
  The number of input channels in samples.
- **latent_channels** (`int`, defaults to `32`) --
  The number of channels in the latent space representation.
- **encoder_block_types** (`Union[str, Tuple[str]]`, defaults to `"ResBlock"`) --
  The type(s) of block to use in the encoder.
- **decoder_block_types** (`Union[str, Tuple[str]]`, defaults to `"ResBlock"`) --
  The type(s) of block to use in the decoder.
- **encoder_block_out_channels** (`Tuple[int, ...]`, defaults to `(128, 256, 512, 512, 1024, 1024)`) --
  The number of output channels for each block in the encoder.
- **decoder_block_out_channels** (`Tuple[int, ...]`, defaults to `(128, 256, 512, 512, 1024, 1024)`) --
  The number of output channels for each block in the decoder.
- **encoder_layers_per_block** (`Tuple[int]`, defaults to `(2, 2, 2, 3, 3, 3)`) --
  The number of layers per block in the encoder.
- **decoder_layers_per_block** (`Tuple[int]`, defaults to `(3, 3, 3, 3, 3, 3)`) --
  The number of layers per block in the decoder.
- **encoder_qkv_multiscales** (`Tuple[Tuple[int, ...], ...]`, defaults to `((), (), (), (5,), (5,), (5,))`) --
  Multi-scale configurations for the encoder's QKV (query-key-value) transformations.
- **decoder_qkv_multiscales** (`Tuple[Tuple[int, ...], ...]`, defaults to `((), (), (), (5,), (5,), (5,))`) --
  Multi-scale configurations for the decoder's QKV (query-key-value) transformations.
- **upsample_block_type** (`str`, defaults to `"pixel_shuffle"`) --
  The type of block to use for upsampling in the decoder.
- **downsample_block_type** (`str`, defaults to `"pixel_unshuffle"`) --
  The type of block to use for downsampling in the encoder.
- **decoder_norm_types** (`Union[str, Tuple[str]]`, defaults to `"rms_norm"`) --
  The normalization type(s) to use in the decoder.
- **decoder_act_fns** (`Union[str, Tuple[str]]`, defaults to `"silu"`) --
  The activation function(s) to use in the decoder.
- **encoder_out_shortcut**  (`bool`, defaults to `True`) --
  Whether to use shortcut at the end of the encoder.
- **decoder_in_shortcut** (`bool`, defaults to `True`) --
  Whether to use shortcut at the beginning of the decoder.
- **decoder_conv_act_fn** (`str`, defaults to `"relu"`) --
  The activation function to use at the end of the decoder.
- **scaling_factor** (`float`, defaults to `1.0`) --
  The multiplicative inverse of the root mean square of the latent features. This is used to scale the latent
  space to have unit variance when training the diffusion model. The latents are scaled with the formula `z =
  z * scaling_factor` before being passed to the diffusion model. When decoding, the latents are scaled back
  to the original scale with the formula: `z = 1 / scaling_factor * z`.</paramsdesc><paramgroups>0</paramgroups></docstring>

An Autoencoder model introduced in [DCAE](https://huggingface.co/papers/2410.10733) and used in
[SANA](https://huggingface.co/papers/2410.10629).

This model inherits from [ModelMixin](/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin). Check the superclass documentation for it's generic methods implemented
for all models (such as downloading or saving).





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>wrapper</name><anchor>diffusers.AutoencoderDC.encode</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/accelerate_utils.py#L43</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>wrapper</name><anchor>diffusers.AutoencoderDC.decode</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/accelerate_utils.py#L43</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>enable_tiling</name><anchor>diffusers.AutoencoderDC.enable_tiling</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_dc.py#L507</source><parameters>[{"name": "tile_sample_min_height", "val": ": typing.Optional[int] = None"}, {"name": "tile_sample_min_width", "val": ": typing.Optional[int] = None"}, {"name": "tile_sample_stride_height", "val": ": typing.Optional[float] = None"}, {"name": "tile_sample_stride_width", "val": ": typing.Optional[float] = None"}]</parameters><paramsdesc>- **tile_sample_min_height** (`int`, *optional*) --
  The minimum height required for a sample to be separated into tiles across the height dimension.
- **tile_sample_min_width** (`int`, *optional*) --
  The minimum width required for a sample to be separated into tiles across the width dimension.
- **tile_sample_stride_height** (`int`, *optional*) --
  The minimum amount of overlap between two consecutive vertical tiles. This is to ensure that there are
  no tiling artifacts produced across the height dimension.
- **tile_sample_stride_width** (`int`, *optional*) --
  The stride between two consecutive horizontal tiles. This is to ensure that there are no tiling
  artifacts produced across the width dimension.</paramsdesc><paramgroups>0</paramgroups></docstring>

Enable tiled AE decoding. When this option is enabled, the AE will split the input tensor into tiles to compute
decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.




</div></div>

## DecoderOutput[[diffusers.models.autoencoders.vae.DecoderOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.autoencoders.vae.DecoderOutput</name><anchor>diffusers.models.autoencoders.vae.DecoderOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/vae.py#L47</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "commit_loss", "val": ": typing.Optional[torch.FloatTensor] = None"}]</parameters><paramsdesc>- **sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)`) --
  The decoded output sample from the last layer of the model.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output of decoding method.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/autoencoder_dc.md" />