# SD3Transformer2D

This class is useful when *only* loading weights into a [SD3Transformer2DModel](/docs/diffusers/main/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel). If you need to load weights into the text encoder or a text encoder and SD3Transformer2DModel, check [`SD3LoraLoaderMixin`](lora#diffusers.loaders.SD3LoraLoaderMixin) class instead.

The `SD3Transformer2DLoadersMixin` class currently only loads IP-Adapter weights, but will be used in the future to save weights and load LoRAs.

> [!TIP]
> To learn more about how to load LoRA weights, see the [LoRA](../../tutorials/using_peft_for_inference) loading guide.

## SD3Transformer2DLoadersMixin[[diffusers.loaders.SD3Transformer2DLoadersMixin]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.loaders.SD3Transformer2DLoadersMixin</name><anchor>diffusers.loaders.SD3Transformer2DLoadersMixin</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/transformer_sd3.py#L28</source><parameters>[]</parameters></docstring>
Load IP-Adapters and LoRA layers into a `[SD3Transformer2DModel]`.


<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>_load_ip_adapter_weights</name><anchor>diffusers.loaders.SD3Transformer2DLoadersMixin._load_ip_adapter_weights</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/transformer_sd3.py#L158</source><parameters>[{"name": "state_dict", "val": ": typing.Dict"}, {"name": "low_cpu_mem_usage", "val": ": bool = True"}]</parameters><paramsdesc>- **state_dict** (`Dict`) --
  State dict with keys "ip_adapter", which contains parameters for attention processors, and
  "image_proj", which contains parameters for image projection net.
- **low_cpu_mem_usage** (`bool`, *optional*, defaults to `True` if torch version >= 1.9.0 else `False`) --
  Speed up model loading only loading the pretrained weights and not initializing the weights. This also
  tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
  Only supported for PyTorch >= 1.9.0. If you are using an older version of PyTorch, setting this
  argument to `True` will raise an error.</paramsdesc><paramgroups>0</paramgroups></docstring>
Sets IP-Adapter attention processors, image projection, and loads state_dict.




</div></div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/loaders/transformer_sd3.md" />