import{s as _s,n as Xs,o as Vs}from"../chunks/scheduler.53228c21.js";import{S as ks,i as Es,e as n,s as a,c as r,q as $e,H as Pe,h as zs,a as o,d as l,b as i,f as qe,g as m,j as p,r as Le,v as Ke,k as w,w as Gl,l as g,m as s,n as d,t as c,o as h,p as u}from"../chunks/index.100fac89.js";import{C as Ns}from"../chunks/CopyLLMTxtMenu.fb2ec027.js";import{C as f}from"../chunks/CodeBlock.d30a6509.js";import{H as T,E as Hs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.09d4dba9.js";function Ys(Xl){let j,Oe,Fe,et,X,tt,V,lt,k,Vl=`<strong>Marigold</strong> is a diffusion-based <a href="https://huggingface.co/papers/2312.02145" rel="nofollow">method</a> and a collection of <a href="../api/pipelines/marigold">pipelines</a> designed for
dense computer vision tasks, including <strong>monocular depth prediction</strong>, <strong>surface normals estimation</strong>, and <strong>intrinsic
image decomposition</strong>.`,st,E,kl="This guide will walk you through using Marigold to generate fast and high-quality predictions for images and videos.",at,z,El=`Each pipeline is tailored for a specific computer vision task, processing an input RGB image and generating a
corresponding prediction.
Currently, the following computer vision tasks are implemented:`,it,N,zl='<thead><tr><th>Pipeline</th> <th>Recommended Model Checkpoints</th> <th align="center">Spaces (Interactive Apps)</th> <th>Predicted Modalities</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_depth.py" rel="nofollow">MarigoldDepthPipeline</a></td> <td><a href="https://huggingface.co/prs-eth/marigold-depth-v1-1" rel="nofollow">prs-eth/marigold-depth-v1-1</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold" rel="nofollow">Depth Estimation</a></td> <td><a href="https://en.wikipedia.org/wiki/Depth_map" rel="nofollow">Depth</a>, <a href="https://en.wikipedia.org/wiki/Binocular_disparity" rel="nofollow">Disparity</a></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_normals.py" rel="nofollow">MarigoldNormalsPipeline</a></td> <td><a href="https://huggingface.co/prs-eth/marigold-normals-v1-1" rel="nofollow">prs-eth/marigold-normals-v1-1</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold-normals" rel="nofollow">Surface Normals Estimation</a></td> <td><a href="https://en.wikipedia.org/wiki/Normal_mapping" rel="nofollow">Surface normals</a></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/marigold/pipeline_marigold_intrinsics.py" rel="nofollow">MarigoldIntrinsicsPipeline</a></td> <td><a href="https://huggingface.co/prs-eth/marigold-iid-appearance-v1-1" rel="nofollow">prs-eth/marigold-iid-appearance-v1-1</a>,<br/><a href="https://huggingface.co/prs-eth/marigold-iid-lighting-v1-1" rel="nofollow">prs-eth/marigold-iid-lighting-v1-1</a></td> <td align="center"><a href="https://huggingface.co/spaces/prs-eth/marigold-iid" rel="nofollow">Intrinsic Image Decomposition</a></td> <td><a href="https://en.wikipedia.org/wiki/Albedo" rel="nofollow">Albedo</a>, <a href="https://www.n.aiq3d.com/wiki/roughnessmetalnessao-map" rel="nofollow">Materials</a>, <a href="https://en.wikipedia.org/wiki/Diffuse_reflection" rel="nofollow">Lighting</a></td></tr></tbody>',nt,H,Nl=`All original checkpoints are available under the <a href="https://huggingface.co/prs-eth/" rel="nofollow">PRS-ETH</a> organization on Hugging Face.
They are designed for use with diffusers pipelines and the <a href="https://github.com/prs-eth/marigold" rel="nofollow">original codebase</a>, which can also be used to train
new model checkpoints.
The following is a summary of the recommended checkpoints, all of which produce reliable results with 1 to 4 steps.`,ot,U,ze,Hl="<tr><th>Checkpoint</th> <th>Modality</th> <th>Comment</th></tr>",Il,J,Ne,Yl='<td><a href="https://huggingface.co/prs-eth/marigold-depth-v1-1" rel="nofollow">prs-eth/marigold-depth-v1-1</a></td> <td>Depth</td> <td>Affine-invariant depth prediction assigns each pixel a value between 0 (near plane) and 1 (far plane), with both planes determined by the model during inference.</td>',Wl,He,Sl='<td><a href="https://huggingface.co/prs-eth/marigold-normals-v0-1" rel="nofollow">prs-eth/marigold-normals-v0-1</a></td> <td>Normals</td> <td>The surface normals predictions are unit-length 3D vectors in the screen space camera, with values in the range from -1 to 1.</td>',xl,Ye,Al='<td><a href="https://huggingface.co/prs-eth/marigold-iid-appearance-v1-1" rel="nofollow">prs-eth/marigold-iid-appearance-v1-1</a></td> <td>Intrinsics</td> <td>InteriorVerse decomposition is comprised of Albedo and two BRDF material properties: Roughness and Metallicity.</td>',Bl,v,Se,Ql='<a href="https://huggingface.co/prs-eth/marigold-iid-lighting-v1-1" rel="nofollow">prs-eth/marigold-iid-lighting-v1-1</a>',Rl,Ae,$l="Intrinsics",Cl,M,_l,pt,Ws='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>I</mi></mrow><annotation encoding="application/x-tex">I</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">I</span></span></span></span>',rt,mt,xs='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>A</mi></mrow><annotation encoding="application/x-tex">A</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal">A</span></span></span></span>',dt,ct,Bs='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>S</mi></mrow><annotation encoding="application/x-tex">S</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span></span></span></span>',ht,ut,Rs='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>R</mi></mrow><annotation encoding="application/x-tex">R</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.00773em;">R</span></span></span></span>',gt,Mt,Cs='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>I</mi><mo>=</mo><mi>A</mi><mo>∗</mo><mi>S</mi><mo>+</mo><mi>R</mi></mrow><annotation encoding="application/x-tex">I = A*S+R</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">I</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal">A</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.7667em;vertical-align:-0.0833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.00773em;">R</span></span></span></span>',ft,yt,Y,ql=`The examples below are mostly given for depth prediction, but they can be universally applied to other supported
modalities.
We showcase the predictions using the same input image of Albert Einstein generated by Midjourney.
This makes it easier to compare visualizations of the predictions across various modalities and checkpoints.`,Jt,b,Ll='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://marigoldmonodepth.github.io/images/einstein.jpg"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Example input image for all Marigold pipelines</figcaption></div>',wt,S,Tt,A,Fl=`To get a depth prediction, load the <code>prs-eth/marigold-depth-v1-1</code> checkpoint into <a href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.MarigoldDepthPipeline">MarigoldDepthPipeline</a>,
put the image through the pipeline, and save the predictions:`,bt,Q,Zt,$,Dl=`The <a href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_depth">visualize_depth()</a> function applies one of
<a href="https://matplotlib.org/stable/users/explain/colors/colormaps.html" rel="nofollow">matplotlib’s colormaps</a> (<code>Spectral</code> by default) to map the predicted pixel values from a single-channel <code>[0, 1]</code>
depth range into an RGB image.
With the <code>Spectral</code> colormap, pixels with near depth are painted red, and far pixels are blue.
The 16-bit PNG file stores the single channel values mapped linearly from the <code>[0, 1]</code> range into <code>[0, 65535]</code>.
Below are the raw and the visualized predictions. The darker and closer areas (mustache) are easier to distinguish in
the visualization.`,jt,G,Pl='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_lcm_depth_16bit.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted depth (16-bit PNG)</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_lcm_depth.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted depth visualization (Spectral)</figcaption></div>',vt,q,Ut,L,Kl=`Load the <code>prs-eth/marigold-normals-v1-1</code> checkpoint into <a href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.MarigoldNormalsPipeline">MarigoldNormalsPipeline</a>, put the image through the
pipeline, and save the predictions:`,Gt,F,It,D,Ol=`The <a href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_normals">visualize_normals()</a> maps the three-dimensional
prediction with pixel values in the range <code>[-1, 1]</code> into an RGB image.
The visualization function supports flipping surface normals axes to make the visualization compatible with other
choices of the frame of reference.
Conceptually, each pixel is painted according to the surface normal vector in the frame of reference, where <code>X</code> axis
points right, <code>Y</code> axis points up, and <code>Z</code> axis points at the viewer.
Below is the visualized prediction:`,Wt,Z,es='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_lcm_normals.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted surface normals visualization</figcaption></div>',xt,P,ts=`In this example, the nose tip almost certainly has a point on the surface, in which the surface normal vector points
straight at the viewer, meaning that its coordinates are <code>[0, 0, 1]</code>.
This vector maps to the RGB <code>[128, 128, 255]</code>, which corresponds to the violet-blue color.
Similarly, a surface normal on the cheek in the right part of the image has a large <code>X</code> component, which increases the
red hue.
Points on the shoulders pointing up with a large <code>Y</code> promote green color.`,Bt,K,Rt,O,ls=`Marigold provides two models for Intrinsic Image Decomposition (IID): “Appearance” and “Lighting”.
Each model produces Albedo maps, derived from InteriorVerse and Hypersim annotations, respectively.`,Ct,ee,ss="<li>The “Appearance” model also estimates Material properties: Roughness and Metallicity.</li> <li>The “Lighting” model generates Diffuse Shading and Non-diffuse Residual.</li>",_t,te,as="Here is the sample code saving predictions made by the “Appearance” model:",Xt,le,Vt,se,is="Another example demonstrating the predictions made by the “Lighting” model:",kt,ae,Et,ie,ns=`Both models share the same pipeline while supporting different decomposition types.
The exact decomposition parameterization (e.g., sRGB vs. linear space) is stored in the
<code>pipe.target_properties</code> dictionary, which is passed into the
<a href="/docs/diffusers/main/en/api/pipelines/marigold#diffusers.pipelines.marigold.MarigoldImageProcessor.visualize_intrinsics">visualize_intrinsics()</a> function.`,zt,ne,os=`Below are some examples showcasing the predicted decomposition outputs.
All modalities can be inspected in the
<a href="https://huggingface.co/spaces/prs-eth/marigold-iid" rel="nofollow">Intrinsic Image Decomposition</a> Space.`,Nt,I,ps='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/8c7986eaaab5eb9604eb88336311f46a7b0ff5ab/marigold/marigold_einstein_albedo.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted albedo (&quot;Appearance&quot; model)</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/8c7986eaaab5eb9604eb88336311f46a7b0ff5ab/marigold/marigold_einstein_diffuse.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Predicted diffuse shading (&quot;Lighting&quot; model)</figcaption></div>',Ht,oe,Yt,pe,rs=`The above quick start snippets are already optimized for quality and speed, loading the checkpoint, utilizing the
<code>fp16</code> variant of weights and computation, and performing the default number (4) of denoising diffusion steps.
The first step to accelerate inference, at the expense of prediction quality, is to reduce the denoising diffusion
steps to the minimum:`,St,re,At,me,ms=`With this change, the <code>pipe</code> call completes in 280ms on RTX 3090 GPU.
Internally, the input image is first encoded using the Stable Diffusion VAE encoder, followed by a single denoising
step performed by the U-Net.
Finally, the prediction latent is decoded with the VAE decoder into pixel space.
In this setup, two out of three module calls are dedicated to converting between the pixel and latent spaces of the LDM.
Since Marigold’s latent space is compatible with Stable Diffusion 2.0, inference can be accelerated by more than 3x,
reducing the call time to 85ms on an RTX 3090, by using a <a href="../api/models/autoencoder_tiny">lightweight replacement of the SD VAE</a>.
Note that using a lightweight VAE may slightly reduce the visual quality of the predictions.`,Qt,de,$t,ce,ds=`So far, we have optimized the number of diffusion steps and model components. Self-attention operations account for a
significant portion of computations.
Speeding them up can be achieved by using a more efficient attention processor:`,qt,he,Lt,ue,cs=`Finally, as suggested in <a href="../optimization/fp16#torchcompile">Optimizations</a>, enabling <code>torch.compile</code> can further enhance performance depending on
the target hardware.
However, compilation incurs a significant overhead during the first pipeline invocation, making it beneficial only when
the same pipeline instance is called repeatedly, such as within a loop.`,Ft,ge,Dt,Me,Pt,fe,hs=`Marigold pipelines have a built-in ensembling mechanism combining multiple predictions from different random latents.
This is a brute-force way of improving the precision of predictions, capitalizing on the generative nature of diffusion.
The ensembling path is activated automatically when the <code>ensemble_size</code> argument is set greater or equal than <code>3</code>.
When aiming for maximum precision, it makes sense to adjust <code>num_inference_steps</code> simultaneously with <code>ensemble_size</code>.
The recommended values vary across checkpoints but primarily depend on the scheduler type.
The effect of ensembling is particularly well-seen with surface normals:`,Kt,ye,Ot,W,us='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_lcm_normals.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Surface normals, no ensembling</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_normals.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Surface normals, with ensembling</figcaption></div>',el,Je,gs=`As can be seen, all areas with fine-grained structurers, such as hair, got more conservative and on average more
correct predictions.
Such a result is more suitable for precision-sensitive downstream tasks, such as 3D reconstruction.`,tl,we,ll,Te,Ms=`Due to Marigold’s generative nature, each prediction is unique and defined by the random noise sampled for the latent
initialization.
This becomes an obvious drawback compared to traditional end-to-end dense regression networks, as exemplified in the
following videos:`,sl,x,fs='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_obama.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Input video</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_obama_depth_independent.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold Depth applied to input video frames independently</figcaption></div>',al,be,ys=`To address this issue, it is possible to pass <code>latents</code> argument to the pipelines, which defines the starting point of
diffusion.
Empirically, we found that a convex combination of the very same starting point noise latent and the latent
corresponding to the previous frame prediction give sufficiently smooth results, as implemented in the snippet below:`,il,Ze,nl,je,Js=`Here, the diffusion process starts from the given computed latent.
The pipeline sets <code>output_latent=True</code> to access <code>out.latent</code> and computes its contribution to the next frame’s latent
initialization.
The result is much more stable now:`,ol,B,ws='<div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_obama_depth_independent.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold Depth applied to input video frames independently</figcaption></div> <div style="flex: 1 1 50%; max-width: 50%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_obama_depth_consistent.gif"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Marigold Depth with forced latents initialization</figcaption></div>',pl,ve,rl,Ue,Ts=`A very common application for depth prediction with diffusion models comes in conjunction with ControlNet.
Depth crispness plays a crucial role in obtaining high-quality results from ControlNet.
As seen in comparisons with other methods above, Marigold excels at that task.
The snippet below demonstrates how to load an image, compute depth, and pass it into ControlNet in a compatible format:`,ml,Ge,dl,R,bs='<div style="flex: 1 1 33%; max-width: 33%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_depth_source.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Input image</figcaption></div> <div style="flex: 1 1 33%; max-width: 33%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/motorcycle_controlnet_depth.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Depth in the format compatible with ControlNet</figcaption></div> <div style="flex: 1 1 33%; max-width: 33%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/motorcycle_controlnet_out.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">ControlNet generation, conditioned on depth and prompt: &quot;high quality photo of a sports bike, city&quot;</figcaption></div>',cl,Ie,hl,We,Zs=`To evaluate Marigold quantitatively in standard leaderboards and benchmarks (such as NYU, KITTI, and other datasets),
follow the evaluation protocol outlined in the paper: load the full precision fp32 model and use appropriate values
for <code>num_inference_steps</code> and <code>ensemble_size</code>.
Optionally seed randomness to ensure reproducibility.
Maximizing <code>batch_size</code> will deliver maximum device utilization.`,ul,xe,gl,Be,Ml,Re,js=`The ensembling mechanism built into Marigold pipelines combines multiple predictions obtained from different random
latents.
As a side effect, it can be used to quantify epistemic (model) uncertainty; simply specify <code>ensemble_size</code> greater
or equal than 3 and set <code>output_uncertainty=True</code>.
The resulting uncertainty will be available in the <code>uncertainty</code> field of the output.
It can be visualized as follows:`,fl,Ce,yl,C,vs='<div style="flex: 1 1 33%; max-width: 33%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_depth_uncertainty.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Depth uncertainty</figcaption></div> <div style="flex: 1 1 33%; max-width: 33%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/marigold/marigold_einstein_normals_uncertainty.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Surface normals uncertainty</figcaption></div> <div style="flex: 1 1 33%; max-width: 33%;"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/4f83035d84a24e5ec44fdda129b1d51eba12ce04/marigold/marigold_einstein_albedo_uncertainty.png"/> <figcaption class="mt-1 text-center text-sm text-gray-500">Albedo uncertainty</figcaption></div>',Jl,_e,Us=`The interpretation of uncertainty is easy: higher values (white) correspond to pixels, where the model struggles to
make consistent predictions.`,wl,Xe,Gs=`<li>The depth model exhibits the most uncertainty around discontinuities, where object depth changes abruptly.</li> <li>The surface normals model is least confident in fine-grained structures like hair and in dark regions such as the
collar area.</li> <li>Albedo uncertainty is represented as an RGB image, as it captures uncertainty independently for each color channel,
unlike depth and surface normals. It is also higher in shaded regions and at discontinuities.</li>`,Tl,Ve,bl,ke,Is=`We hope Marigold proves valuable for your downstream tasks, whether as part of a broader generative workflow or for
perception-based applications like 3D reconstruction.`,Zl,Ee,jl,De,vl;return X=new Ns({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),V=new T({props:{title:"Marigold Computer Vision",local:"marigold-computer-vision",headingTag:"h1"}}),S=new T({props:{title:"Depth Prediction",local:"depth-prediction",headingTag:"h2"}}),Q=new f({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLXYxLTElMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUwQWRlcHRoJTIwJTNEJTIwcGlwZShpbWFnZSklMEElMEF2aXMlMjAlM0QlMjBwaXBlLmltYWdlX3Byb2Nlc3Nvci52aXN1YWxpemVfZGVwdGgoZGVwdGgucHJlZGljdGlvbiklMEF2aXMlNUIwJTVELnNhdmUoJTIyZWluc3RlaW5fZGVwdGgucG5nJTIyKSUwQSUwQWRlcHRoXzE2Yml0JTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IuZXhwb3J0X2RlcHRoX3RvXzE2Yml0X3BuZyhkZXB0aC5wcmVkaWN0aW9uKSUwQWRlcHRoXzE2Yml0JTVCMCU1RC5zYXZlKCUyMmVpbnN0ZWluX2RlcHRoXzE2Yml0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-depth-v1-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)

depth = pipe(image)

vis = pipe.image_processor.visualize_depth(depth.prediction)
vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth.png&quot;</span>)

depth_16bit = pipe.image_processor.export_depth_to_16bit_png(depth.prediction)
depth_16bit[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth_16bit.png&quot;</span>)`,wrap:!1}}),q=new T({props:{title:"Surface Normals Estimation",local:"surface-normals-estimation",headingTag:"h2"}}),F=new f({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkTm9ybWFsc1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtbm9ybWFscy12MS0xJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBkaWZmdXNlcnMudXRpbHMubG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRm1hcmlnb2xkbW9ub2RlcHRoLmdpdGh1Yi5pbyUyRmltYWdlcyUyRmVpbnN0ZWluLmpwZyUyMiklMEElMEFub3JtYWxzJTIwJTNEJTIwcGlwZShpbWFnZSklMEElMEF2aXMlMjAlM0QlMjBwaXBlLmltYWdlX3Byb2Nlc3Nvci52aXN1YWxpemVfbm9ybWFscyhub3JtYWxzLnByZWRpY3Rpb24pJTBBdmlzJTVCMCU1RC5zYXZlKCUyMmVpbnN0ZWluX25vcm1hbHMucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldNormalsPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-normals-v1-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)

normals = pipe(image)

vis = pipe.image_processor.visualize_normals(normals.prediction)
vis[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_normals.png&quot;</span>)`,wrap:!1}}),K=new T({props:{title:"Intrinsic Image Decomposition",local:"intrinsic-image-decomposition",headingTag:"h2"}}),le=new f({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkSW50cmluc2ljc1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtaWlkLWFwcGVhcmFuY2UtdjEtMSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwZGlmZnVzZXJzLnV0aWxzLmxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZtYXJpZ29sZG1vbm9kZXB0aC5naXRodWIuaW8lMkZpbWFnZXMlMkZlaW5zdGVpbi5qcGclMjIpJTBBJTBBaW50cmluc2ljcyUyMCUzRCUyMHBpcGUoaW1hZ2UpJTBBJTBBdmlzJTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX2ludHJpbnNpY3MoaW50cmluc2ljcy5wcmVkaWN0aW9uJTJDJTIwcGlwZS50YXJnZXRfcHJvcGVydGllcyklMEF2aXMlNUIwJTVEJTVCJTIyYWxiZWRvJTIyJTVELnNhdmUoJTIyZWluc3RlaW5fYWxiZWRvLnBuZyUyMiklMEF2aXMlNUIwJTVEJTVCJTIycm91Z2huZXNzJTIyJTVELnNhdmUoJTIyZWluc3RlaW5fcm91Z2huZXNzLnBuZyUyMiklMEF2aXMlNUIwJTVEJTVCJTIybWV0YWxsaWNpdHklMjIlNUQuc2F2ZSglMjJlaW5zdGVpbl9tZXRhbGxpY2l0eS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldIntrinsicsPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-iid-appearance-v1-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)

intrinsics = pipe(image)

vis = pipe.image_processor.visualize_intrinsics(intrinsics.prediction, pipe.target_properties)
vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;albedo&quot;</span>].save(<span class="hljs-string">&quot;einstein_albedo.png&quot;</span>)
vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;roughness&quot;</span>].save(<span class="hljs-string">&quot;einstein_roughness.png&quot;</span>)
vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;metallicity&quot;</span>].save(<span class="hljs-string">&quot;einstein_metallicity.png&quot;</span>)`,wrap:!1}}),ae=new f({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkSW50cmluc2ljc1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtaWlkLWxpZ2h0aW5nLXYxLTElMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUwQWludHJpbnNpY3MlMjAlM0QlMjBwaXBlKGltYWdlKSUwQSUwQXZpcyUyMCUzRCUyMHBpcGUuaW1hZ2VfcHJvY2Vzc29yLnZpc3VhbGl6ZV9pbnRyaW5zaWNzKGludHJpbnNpY3MucHJlZGljdGlvbiUyQyUyMHBpcGUudGFyZ2V0X3Byb3BlcnRpZXMpJTBBdmlzJTVCMCU1RCU1QiUyMmFsYmVkbyUyMiU1RC5zYXZlKCUyMmVpbnN0ZWluX2FsYmVkby5wbmclMjIpJTBBdmlzJTVCMCU1RCU1QiUyMnNoYWRpbmclMjIlNUQuc2F2ZSglMjJlaW5zdGVpbl9zaGFkaW5nLnBuZyUyMiklMEF2aXMlNUIwJTVEJTVCJTIycmVzaWR1YWwlMjIlNUQuc2F2ZSglMjJlaW5zdGVpbl9yZXNpZHVhbC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldIntrinsicsPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-iid-lighting-v1-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)

intrinsics = pipe(image)

vis = pipe.image_processor.visualize_intrinsics(intrinsics.prediction, pipe.target_properties)
vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;albedo&quot;</span>].save(<span class="hljs-string">&quot;einstein_albedo.png&quot;</span>)
vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;shading&quot;</span>].save(<span class="hljs-string">&quot;einstein_shading.png&quot;</span>)
vis[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;residual&quot;</span>].save(<span class="hljs-string">&quot;einstein_residual.png&quot;</span>)`,wrap:!1}}),oe=new T({props:{title:"Speeding up inference",local:"speeding-up-inference",headingTag:"h2"}}),re=new f({props:{code:"JTIwJTIwaW1wb3J0JTIwZGlmZnVzZXJzJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLXYxLTElMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSUyMCUyMCkudG8oJTIyY3VkYSUyMiklMEElMEElMjAlMjBpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUyMCUyMCUwQS0lMjBkZXB0aCUyMCUzRCUyMHBpcGUoaW1hZ2UpJTBBJTJCJTIwZGVwdGglMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEp",highlighted:`  import diffusers
  import torch

  pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
      &quot;prs-eth/marigold-depth-v1-1&quot;, variant=&quot;fp16&quot;, torch_dtype=torch.float16
  ).to(&quot;cuda&quot;)

  image = diffusers.utils.load_image(&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;)
  
<span class="hljs-deletion">- depth = pipe(image)</span>
<span class="hljs-addition">+ depth = pipe(image, num_inference_steps=1)</span>`,wrap:!1}}),de=new f({props:{code:"JTIwJTIwaW1wb3J0JTIwZGlmZnVzZXJzJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLXYxLTElMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSUyMCUyMCkudG8oJTIyY3VkYSUyMiklMEElMEElMkIlMjBwaXBlLnZhZSUyMCUzRCUyMGRpZmZ1c2Vycy5BdXRvZW5jb2RlclRpbnkuZnJvbV9wcmV0cmFpbmVkKCUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMm1hZGVieW9sbGluJTJGdGFlc2QlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEElMkIlMjApLmN1ZGEoKSUwQSUwQSUyMCUyMGltYWdlJTIwJTNEJTIwZGlmZnVzZXJzLnV0aWxzLmxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZtYXJpZ29sZG1vbm9kZXB0aC5naXRodWIuaW8lMkZpbWFnZXMlMkZlaW5zdGVpbi5qcGclMjIpJTBBJTBBJTIwJTIwZGVwdGglMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEp",highlighted:`  import diffusers
  import torch

  pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
      &quot;prs-eth/marigold-depth-v1-1&quot;, variant=&quot;fp16&quot;, torch_dtype=torch.float16
  ).to(&quot;cuda&quot;)

<span class="hljs-addition">+ pipe.vae = diffusers.AutoencoderTiny.from_pretrained(</span>
<span class="hljs-addition">+     &quot;madebyollin/taesd&quot;, torch_dtype=torch.float16</span>
<span class="hljs-addition">+ ).cuda()</span>

  image = diffusers.utils.load_image(&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;)

  depth = pipe(image, num_inference_steps=1)`,wrap:!1}}),he=new f({props:{code:"JTIwJTIwaW1wb3J0JTIwZGlmZnVzZXJzJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMkIlMjBmcm9tJTIwZGlmZnVzZXJzLm1vZGVscy5hdHRlbnRpb25fcHJvY2Vzc29yJTIwaW1wb3J0JTIwQXR0blByb2Nlc3NvcjJfMCUwQSUwQSUyMCUyMHBpcGUlMjAlM0QlMjBkaWZmdXNlcnMuTWFyaWdvbGREZXB0aFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtZGVwdGgtdjEtMSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBJTIwJTIwKS50byglMjJjdWRhJTIyKSUwQSUwQSUyQiUyMHBpcGUudmFlLnNldF9hdHRuX3Byb2Nlc3NvcihBdHRuUHJvY2Vzc29yMl8wKCkpJTIwJTBBJTJCJTIwcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihBdHRuUHJvY2Vzc29yMl8wKCkpJTBBJTBBJTIwJTIwaW1hZ2UlMjAlM0QlMjBkaWZmdXNlcnMudXRpbHMubG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRm1hcmlnb2xkbW9ub2RlcHRoLmdpdGh1Yi5pbyUyRmltYWdlcyUyRmVpbnN0ZWluLmpwZyUyMiklMEElMEElMjAlMjBkZXB0aCUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMSk=",highlighted:`  import diffusers
  import torch
<span class="hljs-addition">+ from diffusers.models.attention_processor import AttnProcessor2_0</span>

  pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
      &quot;prs-eth/marigold-depth-v1-1&quot;, variant=&quot;fp16&quot;, torch_dtype=torch.float16
  ).to(&quot;cuda&quot;)

<span class="hljs-addition">+ pipe.vae.set_attn_processor(AttnProcessor2_0()) </span>
<span class="hljs-addition">+ pipe.unet.set_attn_processor(AttnProcessor2_0())</span>

  image = diffusers.utils.load_image(&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;)

  depth = pipe(image, num_inference_steps=1)`,wrap:!1}}),ge=new f({props:{code:"JTIwJTIwaW1wb3J0JTIwZGlmZnVzZXJzJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjBmcm9tJTIwZGlmZnVzZXJzLm1vZGVscy5hdHRlbnRpb25fcHJvY2Vzc29yJTIwaW1wb3J0JTIwQXR0blByb2Nlc3NvcjJfMCUwQSUwQSUyMCUyMHBpcGUlMjAlM0QlMjBkaWZmdXNlcnMuTWFyaWdvbGREZXB0aFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwcnMtZXRoJTJGbWFyaWdvbGQtZGVwdGgtdjEtMSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBJTIwJTIwKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMCUyMHBpcGUudmFlLnNldF9hdHRuX3Byb2Nlc3NvcihBdHRuUHJvY2Vzc29yMl8wKCkpJTIwJTBBJTIwJTIwcGlwZS51bmV0LnNldF9hdHRuX3Byb2Nlc3NvcihBdHRuUHJvY2Vzc29yMl8wKCkpJTBBJTBBJTJCJTIwcGlwZS52YWUlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudmFlJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBJTJCJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjAlMjBpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUwQSUyMCUyMGRlcHRoJTIwJTNEJTIwcGlwZShpbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKQ==",highlighted:`  import diffusers
  import torch
  from diffusers.models.attention_processor import AttnProcessor2_0

  pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
      &quot;prs-eth/marigold-depth-v1-1&quot;, variant=&quot;fp16&quot;, torch_dtype=torch.float16
  ).to(&quot;cuda&quot;)

  pipe.vae.set_attn_processor(AttnProcessor2_0()) 
  pipe.unet.set_attn_processor(AttnProcessor2_0())

<span class="hljs-addition">+ pipe.vae = torch.compile(pipe.vae, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>
<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>

  image = diffusers.utils.load_image(&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;)

  depth = pipe(image, num_inference_steps=1)`,wrap:!1}}),Me=new T({props:{title:"Maximizing Precision and Ensembling",local:"maximizing-precision-and-ensembling",headingTag:"h2"}}),ye=new f({props:{code:"JTIwJTIwaW1wb3J0JTIwZGlmZnVzZXJzJTBBJTBBJTIwJTIwcGlwZSUyMCUzRCUyMGRpZmZ1c2Vycy5NYXJpZ29sZE5vcm1hbHNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycHJzLWV0aCUyRm1hcmlnb2xkLW5vcm1hbHMtdjEtMSUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjAlMjBpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUwQS0lMjBkZXB0aCUyMCUzRCUyMHBpcGUoaW1hZ2UpJTBBJTJCJTIwZGVwdGglMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwJTJDJTIwZW5zZW1ibGVfc2l6ZSUzRDUpJTBBJTBBJTIwJTIwdmlzJTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX25vcm1hbHMoZGVwdGgucHJlZGljdGlvbiklMEElMjAlMjB2aXMlNUIwJTVELnNhdmUoJTIyZWluc3RlaW5fbm9ybWFscy5wbmclMjIp",highlighted:`  import diffusers

  pipe = diffusers.MarigoldNormalsPipeline.from_pretrained(&quot;prs-eth/marigold-normals-v1-1&quot;).to(&quot;cuda&quot;)

  image = diffusers.utils.load_image(&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;)

<span class="hljs-deletion">- depth = pipe(image)</span>
<span class="hljs-addition">+ depth = pipe(image, num_inference_steps=10, ensemble_size=5)</span>

  vis = pipe.image_processor.visualize_normals(depth.prediction)
  vis[0].save(&quot;einstein_normals.png&quot;)`,wrap:!1}}),we=new T({props:{title:"Frame-by-frame Video Processing with Temporal Consistency",local:"frame-by-frame-video-processing-with-temporal-consistency",headingTag:"h2"}}),Ze=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.models.attention_processor <span class="hljs-keyword">import</span> AttnProcessor2_0
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

device = <span class="hljs-string">&quot;cuda&quot;</span>
path_in = <span class="hljs-string">&quot;https://huggingface.co/spaces/prs-eth/marigold-lcm/resolve/c7adb5427947d2680944f898cd91d386bf0d4924/files/video/obama.mp4&quot;</span>
path_out = <span class="hljs-string">&quot;obama_depth.gif&quot;</span>

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-depth-v1-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(device)
pipe.vae = diffusers.AutoencoderTiny.from_pretrained(
    <span class="hljs-string">&quot;madebyollin/taesd&quot;</span>, torch_dtype=torch.float16
).to(device)
pipe.unet.set_attn_processor(AttnProcessor2_0())
pipe.vae = torch.<span class="hljs-built_in">compile</span>(pipe.vae, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> imageio.get_reader(path_in) <span class="hljs-keyword">as</span> reader:
    size = reader.get_meta_data()[<span class="hljs-string">&#x27;size&#x27;</span>]
    last_frame_latent = <span class="hljs-literal">None</span>
    latent_common = torch.randn(
        (<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">768</span> * size[<span class="hljs-number">1</span>] // (<span class="hljs-number">8</span> * <span class="hljs-built_in">max</span>(size)), <span class="hljs-number">768</span> * size[<span class="hljs-number">0</span>] // (<span class="hljs-number">8</span> * <span class="hljs-built_in">max</span>(size)))
    ).to(device=device, dtype=torch.float16)

    out = []
    <span class="hljs-keyword">for</span> frame_id, frame <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(reader), desc=<span class="hljs-string">&quot;Processing Video&quot;</span>):
        frame = Image.fromarray(frame)
        latents = latent_common
        <span class="hljs-keyword">if</span> last_frame_latent <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            latents = <span class="hljs-number">0.9</span> * latents + <span class="hljs-number">0.1</span> * last_frame_latent

        depth = pipe(
            frame,
            num_inference_steps=<span class="hljs-number">1</span>,
            match_input_resolution=<span class="hljs-literal">False</span>, 
            latents=latents, 
            output_latent=<span class="hljs-literal">True</span>,
        )
        last_frame_latent = depth.latent
        out.append(pipe.image_processor.visualize_depth(depth.prediction)[<span class="hljs-number">0</span>])

    diffusers.utils.export_to_gif(out, path_out, fps=reader.get_meta_data()[<span class="hljs-string">&#x27;fps&#x27;</span>])`,wrap:!1}}),ve=new T({props:{title:"Marigold for ControlNet",local:"marigold-for-controlnet",headingTag:"h2"}}),Ge=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBkaWZmdXNlcnMlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRGRldmljZSkubWFudWFsX3NlZWQoMjAyNCklMEFpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNvbnRyb2xuZXRfZGVwdGhfc291cmNlLnBuZyUyMiUwQSklMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLXYxLTElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oZGV2aWNlKSUwQSUwQWRlcHRoX2ltYWdlJTIwJTNEJTIwcGlwZShpbWFnZSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikucHJlZGljdGlvbiUwQWRlcHRoX2ltYWdlJTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX2RlcHRoKGRlcHRoX2ltYWdlJTJDJTIwY29sb3JfbWFwJTNEJTIyYmluYXJ5JTIyKSUwQWRlcHRoX2ltYWdlJTVCMCU1RC5zYXZlKCUyMm1vdG9yY3ljbGVfY29udHJvbG5ldF9kZXB0aC5wbmclMjIpJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMGRpZmZ1c2Vycy5Db250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyRmNvbnRyb2xuZXQtZGVwdGgtc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oZGV2aWNlKSUwQXBpcGUlMjAlM0QlMjBkaWZmdXNlcnMuU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlNHMTYxMjIyJTJGUmVhbFZpc1hMX1Y0LjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTBBKS50byhkZXZpY2UpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBkaWZmdXNlcnMuRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMHVzZV9rYXJyYXNfc2lnbWFzJTNEVHJ1ZSklMEElMEFjb250cm9sbmV0X291dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyaGlnaCUyMHF1YWxpdHklMjBwaG90byUyMG9mJTIwYSUyMHNwb3J0cyUyMGJpa2UlMkMlMjBjaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q2LjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGRlcHRoX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0QwLjclMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2d1aWRhbmNlX2VuZCUzRDAuNyUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTBBY29udHJvbG5ldF9vdXQlNUIwJTVELnNhdmUoJTIybW90b3JjeWNsZV9jb250cm9sbmV0X291dC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> diffusers

device = <span class="hljs-string">&quot;cuda&quot;</span>
generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">2024</span>)
image = diffusers.utils.load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet_depth_source.png&quot;</span>
)

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-depth-v1-1&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(device)

depth_image = pipe(image, generator=generator).prediction
depth_image = pipe.image_processor.visualize_depth(depth_image, color_map=<span class="hljs-string">&quot;binary&quot;</span>)
depth_image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;motorcycle_controlnet_depth.png&quot;</span>)

controlnet = diffusers.ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-depth-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(device)
pipe = diffusers.StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, controlnet=controlnet
).to(device)
pipe.scheduler = diffusers.DPMSolverMultistepScheduler.from_config(pipe.scheduler.config, use_karras_sigmas=<span class="hljs-literal">True</span>)

controlnet_out = pipe(
    prompt=<span class="hljs-string">&quot;high quality photo of a sports bike, city&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    guidance_scale=<span class="hljs-number">6.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    image=depth_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.7</span>,
    control_guidance_end=<span class="hljs-number">0.7</span>,
    generator=generator,
).images
controlnet_out[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;motorcycle_controlnet_out.png&quot;</span>)`,wrap:!1}}),Ie=new T({props:{title:"Quantitative Evaluation",local:"quantitative-evaluation",headingTag:"h2"}}),xe=new f({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBc2VlZCUyMCUzRCUyMDIwMjQlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEZGV2aWNlKS5tYW51YWxfc2VlZChzZWVkKSUwQXBpcGUlMjAlM0QlMjBkaWZmdXNlcnMuTWFyaWdvbGREZXB0aFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJwcnMtZXRoJTJGbWFyaWdvbGQtZGVwdGgtdjEtMSUyMikudG8oZGV2aWNlKSUwQSUwQWltYWdlJTIwJTNEJTIwZGlmZnVzZXJzLnV0aWxzLmxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZtYXJpZ29sZG1vbm9kZXB0aC5naXRodWIuaW8lMkZpbWFnZXMlMkZlaW5zdGVpbi5qcGclMjIpJTBBJTBBZGVwdGglMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGltYWdlJTJDJTIwJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjAlMjAlMjMlMjBzZXQlMjBhY2NvcmRpbmclMjB0byUyMHRoZSUyMGV2YWx1YXRpb24lMjBwcm90b2NvbCUyMGZyb20lMjB0aGUlMjBwYXBlciUwQSUyMCUyMCUyMCUyMGVuc2VtYmxlX3NpemUlM0QxMCUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHNldCUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwZXZhbHVhdGlvbiUyMHByb3RvY29sJTIwZnJvbSUyMHRoZSUyMHBhcGVyJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKSUwQSUwQSUyMyUyMGV2YWx1YXRlJTIwbWV0cmljcw==",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span>
seed = <span class="hljs-number">2024</span>

generator = torch.Generator(device=device).manual_seed(seed)
pipe = diffusers.MarigoldDepthPipeline.from_pretrained(<span class="hljs-string">&quot;prs-eth/marigold-depth-v1-1&quot;</span>).to(device)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)

depth = pipe(
    image, 
    num_inference_steps=<span class="hljs-number">4</span>,  <span class="hljs-comment"># set according to the evaluation protocol from the paper</span>
    ensemble_size=<span class="hljs-number">10</span>,       <span class="hljs-comment"># set according to the evaluation protocol from the paper</span>
    generator=generator,
)

<span class="hljs-comment"># evaluate metrics</span>`,wrap:!1}}),Be=new T({props:{title:"Using Predictive Uncertainty",local:"using-predictive-uncertainty",headingTag:"h2"}}),Ce=new f({props:{code:"aW1wb3J0JTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwZGlmZnVzZXJzLk1hcmlnb2xkRGVwdGhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycHJzLWV0aCUyRm1hcmlnb2xkLWRlcHRoLXYxLTElMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMGRpZmZ1c2Vycy51dGlscy5sb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGbWFyaWdvbGRtb25vZGVwdGguZ2l0aHViLmlvJTJGaW1hZ2VzJTJGZWluc3RlaW4uanBnJTIyKSUwQSUwQWRlcHRoJTIwJTNEJTIwcGlwZSglMEElMDlpbWFnZSUyQyUwQSUwOWVuc2VtYmxlX3NpemUlM0QxMCUyQyUyMCUyMCUyMyUyMGFueSUyMG51bWJlciUyMCUzRSUzRCUyMDMlMEElMDlvdXRwdXRfdW5jZXJ0YWludHklM0RUcnVlJTJDJTBBKSUwQSUwQXVuY2VydGFpbnR5JTIwJTNEJTIwcGlwZS5pbWFnZV9wcm9jZXNzb3IudmlzdWFsaXplX3VuY2VydGFpbnR5KGRlcHRoLnVuY2VydGFpbnR5KSUwQXVuY2VydGFpbnR5JTVCMCU1RC5zYXZlKCUyMmVpbnN0ZWluX2RlcHRoX3VuY2VydGFpbnR5LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> diffusers
<span class="hljs-keyword">import</span> torch

pipe = diffusers.MarigoldDepthPipeline.from_pretrained(
    <span class="hljs-string">&quot;prs-eth/marigold-depth-v1-1&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = diffusers.utils.load_image(<span class="hljs-string">&quot;https://marigoldmonodepth.github.io/images/einstein.jpg&quot;</span>)

depth = pipe(
	image,
	ensemble_size=<span class="hljs-number">10</span>,  <span class="hljs-comment"># any number &gt;= 3</span>
	output_uncertainty=<span class="hljs-literal">True</span>,
)

uncertainty = pipe.image_processor.visualize_uncertainty(depth.uncertainty)
uncertainty[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;einstein_depth_uncertainty.png&quot;</span>)`,wrap:!1}}),Ve=new T({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Ee=new Hs({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/marigold_usage.md"}}),{c(){j=n("meta"),Oe=a(),Fe=n("p"),et=a(),r(X.$$.fragment),tt=a(),r(V.$$.fragment),lt=a(),k=n("p"),k.innerHTML=Vl,st=a(),E=n("p"),E.textContent=kl,at=a(),z=n("p"),z.textContent=El,it=a(),N=n("table"),N.innerHTML=zl,nt=a(),H=n("p"),H.innerHTML=Nl,ot=a(),U=n("table"),ze=n("thead"),ze.innerHTML=Hl,Il=a(),J=n("tbody"),Ne=n("tr"),Ne.innerHTML=Yl,Wl=a(),He=n("tr"),He.innerHTML=Sl,xl=a(),Ye=n("tr"),Ye.innerHTML=Al,Bl=a(),v=n("tr"),Se=n("td"),Se.innerHTML=Ql,Rl=a(),Ae=n("td"),Ae.textContent=$l,Cl=a(),M=n("td"),_l=$e("HyperSim decomposition of an image"),pt=new Pe(!1),rt=$e(" is comprised of Albedo"),mt=new Pe(!1),dt=$e(", Diffuse shading"),ct=new Pe(!1),ht=$e(", and Non-diffuse residual"),ut=new Pe(!1),gt=$e(":"),Mt=new Pe(!1),ft=$e("."),yt=a(),Y=n("p"),Y.textContent=ql,Jt=a(),b=n("div"),b.innerHTML=Ll,wt=a(),r(S.$$.fragment),Tt=a(),A=n("p"),A.innerHTML=Fl,bt=a(),r(Q.$$.fragment),Zt=a(),$=n("p"),$.innerHTML=Dl,jt=a(),G=n("div"),G.innerHTML=Pl,vt=a(),r(q.$$.fragment),Ut=a(),L=n("p"),L.innerHTML=Kl,Gt=a(),r(F.$$.fragment),It=a(),D=n("p"),D.innerHTML=Ol,Wt=a(),Z=n("div"),Z.innerHTML=es,xt=a(),P=n("p"),P.innerHTML=ts,Bt=a(),r(K.$$.fragment),Rt=a(),O=n("p"),O.textContent=ls,Ct=a(),ee=n("ul"),ee.innerHTML=ss,_t=a(),te=n("p"),te.textContent=as,Xt=a(),r(le.$$.fragment),Vt=a(),se=n("p"),se.textContent=is,kt=a(),r(ae.$$.fragment),Et=a(),ie=n("p"),ie.innerHTML=ns,zt=a(),ne=n("p"),ne.innerHTML=os,Nt=a(),I=n("div"),I.innerHTML=ps,Ht=a(),r(oe.$$.fragment),Yt=a(),pe=n("p"),pe.innerHTML=rs,St=a(),r(re.$$.fragment),At=a(),me=n("p"),me.innerHTML=ms,Qt=a(),r(de.$$.fragment),$t=a(),ce=n("p"),ce.textContent=ds,qt=a(),r(he.$$.fragment),Lt=a(),ue=n("p"),ue.innerHTML=cs,Ft=a(),r(ge.$$.fragment),Dt=a(),r(Me.$$.fragment),Pt=a(),fe=n("p"),fe.innerHTML=hs,Kt=a(),r(ye.$$.fragment),Ot=a(),W=n("div"),W.innerHTML=us,el=a(),Je=n("p"),Je.textContent=gs,tl=a(),r(we.$$.fragment),ll=a(),Te=n("p"),Te.textContent=Ms,sl=a(),x=n("div"),x.innerHTML=fs,al=a(),be=n("p"),be.innerHTML=ys,il=a(),r(Ze.$$.fragment),nl=a(),je=n("p"),je.innerHTML=Js,ol=a(),B=n("div"),B.innerHTML=ws,pl=a(),r(ve.$$.fragment),rl=a(),Ue=n("p"),Ue.textContent=Ts,ml=a(),r(Ge.$$.fragment),dl=a(),R=n("div"),R.innerHTML=bs,cl=a(),r(Ie.$$.fragment),hl=a(),We=n("p"),We.innerHTML=Zs,ul=a(),r(xe.$$.fragment),gl=a(),r(Be.$$.fragment),Ml=a(),Re=n("p"),Re.innerHTML=js,fl=a(),r(Ce.$$.fragment),yl=a(),C=n("div"),C.innerHTML=vs,Jl=a(),_e=n("p"),_e.textContent=Us,wl=a(),Xe=n("ul"),Xe.innerHTML=Gs,Tl=a(),r(Ve.$$.fragment),bl=a(),ke=n("p"),ke.textContent=Is,Zl=a(),r(Ee.$$.fragment),jl=a(),De=n("p"),this.h()},l(e){const t=zs("svelte-u9bgzb",document.head);j=o(t,"META",{name:!0,content:!0}),t.forEach(l),Oe=i(e),Fe=o(e,"P",{}),qe(Fe).forEach(l),et=i(e),m(X.$$.fragment,e),tt=i(e),m(V.$$.fragment,e),lt=i(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1m1paos"&&(k.innerHTML=Vl),st=i(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1bjomdr"&&(E.textContent=kl),at=i(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-d9hh6k"&&(z.textContent=El),it=i(e),N=o(e,"TABLE",{"data-svelte-h":!0}),p(N)!=="svelte-1puk2lq"&&(N.innerHTML=zl),nt=i(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1w30tm5"&&(H.innerHTML=Nl),ot=i(e),U=o(e,"TABLE",{});var Ul=qe(U);ze=o(Ul,"THEAD",{"data-svelte-h":!0}),p(ze)!=="svelte-ubewwm"&&(ze.innerHTML=Hl),Il=i(Ul),J=o(Ul,"TBODY",{});var _=qe(J);Ne=o(_,"TR",{"data-svelte-h":!0}),p(Ne)!=="svelte-ao7el9"&&(Ne.innerHTML=Yl),Wl=i(_),He=o(_,"TR",{"data-svelte-h":!0}),p(He)!=="svelte-9wucso"&&(He.innerHTML=Sl),xl=i(_),Ye=o(_,"TR",{"data-svelte-h":!0}),p(Ye)!=="svelte-1mu3nd5"&&(Ye.innerHTML=Al),Bl=i(_),v=o(_,"TR",{});var Qe=qe(v);Se=o(Qe,"TD",{"data-svelte-h":!0}),p(Se)!=="svelte-1u8ffq5"&&(Se.innerHTML=Ql),Rl=i(Qe),Ae=o(Qe,"TD",{"data-svelte-h":!0}),p(Ae)!=="svelte-pxwxqa"&&(Ae.textContent=$l),Cl=i(Qe),M=o(Qe,"TD",{});var y=qe(M);_l=Le(y,"HyperSim decomposition of an image"),pt=Ke(y,!1),rt=Le(y," is comprised of Albedo"),mt=Ke(y,!1),dt=Le(y,", Diffuse shading"),ct=Ke(y,!1),ht=Le(y,", and Non-diffuse residual"),ut=Ke(y,!1),gt=Le(y,":"),Mt=Ke(y,!1),ft=Le(y,"."),y.forEach(l),Qe.forEach(l),_.forEach(l),Ul.forEach(l),yt=i(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-r6ainx"&&(Y.textContent=ql),Jt=i(e),b=o(e,"DIV",{class:!0,style:!0,"data-svelte-h":!0}),p(b)!=="svelte-130z9iz"&&(b.innerHTML=Ll),wt=i(e),m(S.$$.fragment,e),Tt=i(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-iopzr7"&&(A.innerHTML=Fl),bt=i(e),m(Q.$$.fragment,e),Zt=i(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1s6m3af"&&($.innerHTML=Dl),jt=i(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-16yoeuw"&&(G.innerHTML=Pl),vt=i(e),m(q.$$.fragment,e),Ut=i(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-19fb6h0"&&(L.innerHTML=Kl),Gt=i(e),m(F.$$.fragment,e),It=i(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-e9a1t5"&&(D.innerHTML=Ol),Wt=i(e),Z=o(e,"DIV",{class:!0,style:!0,"data-svelte-h":!0}),p(Z)!=="svelte-15wm70y"&&(Z.innerHTML=es),xt=i(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-112j81b"&&(P.innerHTML=ts),Bt=i(e),m(K.$$.fragment,e),Rt=i(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-4kpwil"&&(O.textContent=ls),Ct=i(e),ee=o(e,"UL",{"data-svelte-h":!0}),p(ee)!=="svelte-1ryhu3o"&&(ee.innerHTML=ss),_t=i(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-5ngr7b"&&(te.textContent=as),Xt=i(e),m(le.$$.fragment,e),Vt=i(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1gpdgbg"&&(se.textContent=is),kt=i(e),m(ae.$$.fragment,e),Et=i(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1m7qg5r"&&(ie.innerHTML=ns),zt=i(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-120nvgo"&&(ne.innerHTML=os),Nt=i(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-nydk8v"&&(I.innerHTML=ps),Ht=i(e),m(oe.$$.fragment,e),Yt=i(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-ldmjw6"&&(pe.innerHTML=rs),St=i(e),m(re.$$.fragment,e),At=i(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-17orz4u"&&(me.innerHTML=ms),Qt=i(e),m(de.$$.fragment,e),$t=i(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1qszioo"&&(ce.textContent=ds),qt=i(e),m(he.$$.fragment,e),Lt=i(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-s03s1d"&&(ue.innerHTML=cs),Ft=i(e),m(ge.$$.fragment,e),Dt=i(e),m(Me.$$.fragment,e),Pt=i(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-3i2mxl"&&(fe.innerHTML=hs),Kt=i(e),m(ye.$$.fragment,e),Ot=i(e),W=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-etsikn"&&(W.innerHTML=us),el=i(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-3lgzgw"&&(Je.textContent=gs),tl=i(e),m(we.$$.fragment,e),ll=i(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1liveae"&&(Te.textContent=Ms),sl=i(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(x)!=="svelte-1k6s96j"&&(x.innerHTML=fs),al=i(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-o99xnx"&&(be.innerHTML=ys),il=i(e),m(Ze.$$.fragment,e),nl=i(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1dxdmz7"&&(je.innerHTML=Js),ol=i(e),B=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-u703tp"&&(B.innerHTML=ws),pl=i(e),m(ve.$$.fragment,e),rl=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-12oh700"&&(Ue.textContent=Ts),ml=i(e),m(Ge.$$.fragment,e),dl=i(e),R=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(R)!=="svelte-bddy4e"&&(R.innerHTML=bs),cl=i(e),m(Ie.$$.fragment,e),hl=i(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1r9j6ij"&&(We.innerHTML=Zs),ul=i(e),m(xe.$$.fragment,e),gl=i(e),m(Be.$$.fragment,e),Ml=i(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-yvw9s0"&&(Re.innerHTML=js),fl=i(e),m(Ce.$$.fragment,e),yl=i(e),C=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(C)!=="svelte-a7wlst"&&(C.innerHTML=vs),Jl=i(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1kdua20"&&(_e.textContent=Us),wl=i(e),Xe=o(e,"UL",{"data-svelte-h":!0}),p(Xe)!=="svelte-41v41f"&&(Xe.innerHTML=Gs),Tl=i(e),m(Ve.$$.fragment,e),bl=i(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-rdb8rm"&&(ke.textContent=Is),Zl=i(e),m(Ee.$$.fragment,e),jl=i(e),De=o(e,"P",{}),qe(De).forEach(l),this.h()},h(){w(j,"name","hf:doc:metadata"),w(j,"content",Ss),pt.a=rt,mt.a=dt,ct.a=ht,ut.a=gt,Mt.a=ft,w(b,"class","flex gap-4"),Gl(b,"justify-content","center"),Gl(b,"width","100%"),w(G,"class","flex gap-4"),w(Z,"class","flex gap-4"),Gl(Z,"justify-content","center"),Gl(Z,"width","100%"),w(I,"class","flex gap-4"),w(W,"class","flex gap-4"),w(x,"class","flex gap-4"),w(B,"class","flex gap-4"),w(R,"class","flex gap-4"),w(C,"class","flex gap-4")},m(e,t){g(document.head,j),s(e,Oe,t),s(e,Fe,t),s(e,et,t),d(X,e,t),s(e,tt,t),d(V,e,t),s(e,lt,t),s(e,k,t),s(e,st,t),s(e,E,t),s(e,at,t),s(e,z,t),s(e,it,t),s(e,N,t),s(e,nt,t),s(e,H,t),s(e,ot,t),s(e,U,t),g(U,ze),g(U,Il),g(U,J),g(J,Ne),g(J,Wl),g(J,He),g(J,xl),g(J,Ye),g(J,Bl),g(J,v),g(v,Se),g(v,Rl),g(v,Ae),g(v,Cl),g(v,M),g(M,_l),pt.m(Ws,M),g(M,rt),mt.m(xs,M),g(M,dt),ct.m(Bs,M),g(M,ht),ut.m(Rs,M),g(M,gt),Mt.m(Cs,M),g(M,ft),s(e,yt,t),s(e,Y,t),s(e,Jt,t),s(e,b,t),s(e,wt,t),d(S,e,t),s(e,Tt,t),s(e,A,t),s(e,bt,t),d(Q,e,t),s(e,Zt,t),s(e,$,t),s(e,jt,t),s(e,G,t),s(e,vt,t),d(q,e,t),s(e,Ut,t),s(e,L,t),s(e,Gt,t),d(F,e,t),s(e,It,t),s(e,D,t),s(e,Wt,t),s(e,Z,t),s(e,xt,t),s(e,P,t),s(e,Bt,t),d(K,e,t),s(e,Rt,t),s(e,O,t),s(e,Ct,t),s(e,ee,t),s(e,_t,t),s(e,te,t),s(e,Xt,t),d(le,e,t),s(e,Vt,t),s(e,se,t),s(e,kt,t),d(ae,e,t),s(e,Et,t),s(e,ie,t),s(e,zt,t),s(e,ne,t),s(e,Nt,t),s(e,I,t),s(e,Ht,t),d(oe,e,t),s(e,Yt,t),s(e,pe,t),s(e,St,t),d(re,e,t),s(e,At,t),s(e,me,t),s(e,Qt,t),d(de,e,t),s(e,$t,t),s(e,ce,t),s(e,qt,t),d(he,e,t),s(e,Lt,t),s(e,ue,t),s(e,Ft,t),d(ge,e,t),s(e,Dt,t),d(Me,e,t),s(e,Pt,t),s(e,fe,t),s(e,Kt,t),d(ye,e,t),s(e,Ot,t),s(e,W,t),s(e,el,t),s(e,Je,t),s(e,tl,t),d(we,e,t),s(e,ll,t),s(e,Te,t),s(e,sl,t),s(e,x,t),s(e,al,t),s(e,be,t),s(e,il,t),d(Ze,e,t),s(e,nl,t),s(e,je,t),s(e,ol,t),s(e,B,t),s(e,pl,t),d(ve,e,t),s(e,rl,t),s(e,Ue,t),s(e,ml,t),d(Ge,e,t),s(e,dl,t),s(e,R,t),s(e,cl,t),d(Ie,e,t),s(e,hl,t),s(e,We,t),s(e,ul,t),d(xe,e,t),s(e,gl,t),d(Be,e,t),s(e,Ml,t),s(e,Re,t),s(e,fl,t),d(Ce,e,t),s(e,yl,t),s(e,C,t),s(e,Jl,t),s(e,_e,t),s(e,wl,t),s(e,Xe,t),s(e,Tl,t),d(Ve,e,t),s(e,bl,t),s(e,ke,t),s(e,Zl,t),d(Ee,e,t),s(e,jl,t),s(e,De,t),vl=!0},p:Xs,i(e){vl||(c(X.$$.fragment,e),c(V.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(q.$$.fragment,e),c(F.$$.fragment,e),c(K.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(he.$$.fragment,e),c(ge.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c(Ze.$$.fragment,e),c(ve.$$.fragment,e),c(Ge.$$.fragment,e),c(Ie.$$.fragment,e),c(xe.$$.fragment,e),c(Be.$$.fragment,e),c(Ce.$$.fragment,e),c(Ve.$$.fragment,e),c(Ee.$$.fragment,e),vl=!0)},o(e){h(X.$$.fragment,e),h(V.$$.fragment,e),h(S.$$.fragment,e),h(Q.$$.fragment,e),h(q.$$.fragment,e),h(F.$$.fragment,e),h(K.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(ge.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Ze.$$.fragment,e),h(ve.$$.fragment,e),h(Ge.$$.fragment,e),h(Ie.$$.fragment,e),h(xe.$$.fragment,e),h(Be.$$.fragment,e),h(Ce.$$.fragment,e),h(Ve.$$.fragment,e),h(Ee.$$.fragment,e),vl=!1},d(e){e&&(l(Oe),l(Fe),l(et),l(tt),l(lt),l(k),l(st),l(E),l(at),l(z),l(it),l(N),l(nt),l(H),l(ot),l(U),l(yt),l(Y),l(Jt),l(b),l(wt),l(Tt),l(A),l(bt),l(Zt),l($),l(jt),l(G),l(vt),l(Ut),l(L),l(Gt),l(It),l(D),l(Wt),l(Z),l(xt),l(P),l(Bt),l(Rt),l(O),l(Ct),l(ee),l(_t),l(te),l(Xt),l(Vt),l(se),l(kt),l(Et),l(ie),l(zt),l(ne),l(Nt),l(I),l(Ht),l(Yt),l(pe),l(St),l(At),l(me),l(Qt),l($t),l(ce),l(qt),l(Lt),l(ue),l(Ft),l(Dt),l(Pt),l(fe),l(Kt),l(Ot),l(W),l(el),l(Je),l(tl),l(ll),l(Te),l(sl),l(x),l(al),l(be),l(il),l(nl),l(je),l(ol),l(B),l(pl),l(rl),l(Ue),l(ml),l(dl),l(R),l(cl),l(hl),l(We),l(ul),l(gl),l(Ml),l(Re),l(fl),l(yl),l(C),l(Jl),l(_e),l(wl),l(Xe),l(Tl),l(bl),l(ke),l(Zl),l(jl),l(De)),l(j),u(X,e),u(V,e),u(S,e),u(Q,e),u(q,e),u(F,e),u(K,e),u(le,e),u(ae,e),u(oe,e),u(re,e),u(de,e),u(he,e),u(ge,e),u(Me,e),u(ye,e),u(we,e),u(Ze,e),u(ve,e),u(Ge,e),u(Ie,e),u(xe,e),u(Be,e),u(Ce,e),u(Ve,e),u(Ee,e)}}}const Ss='{"title":"Marigold Computer Vision","local":"marigold-computer-vision","sections":[{"title":"Depth Prediction","local":"depth-prediction","sections":[],"depth":2},{"title":"Surface Normals Estimation","local":"surface-normals-estimation","sections":[],"depth":2},{"title":"Intrinsic Image Decomposition","local":"intrinsic-image-decomposition","sections":[],"depth":2},{"title":"Speeding up inference","local":"speeding-up-inference","sections":[],"depth":2},{"title":"Maximizing Precision and Ensembling","local":"maximizing-precision-and-ensembling","sections":[],"depth":2},{"title":"Frame-by-frame Video Processing with Temporal Consistency","local":"frame-by-frame-video-processing-with-temporal-consistency","sections":[],"depth":2},{"title":"Marigold for ControlNet","local":"marigold-for-controlnet","sections":[],"depth":2},{"title":"Quantitative Evaluation","local":"quantitative-evaluation","sections":[],"depth":2},{"title":"Using Predictive Uncertainty","local":"using-predictive-uncertainty","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function As(Xl){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends ks{constructor(j){super(),Es(this,j,As,Ys,_s,{})}}export{Ds as component};
