import{s as kt,n as vt,o as Yt}from"../chunks/scheduler.53228c21.js";import{S as Et,i as Ht,e as i,s as a,c as m,h as $t,a as p,d as l,b as n,f as Rt,g as r,j as o,k as de,l as xt,m as s,n as d,t as c,o as M,p as J}from"../chunks/index.100fac89.js";import{C as Nt}from"../chunks/CopyLLMTxtMenu.fb2ec027.js";import{C as u}from"../chunks/CodeBlock.d30a6509.js";import{D as Ft}from"../chunks/DocNotebookDropdown.74a16910.js";import{H as pt,E as Qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.09d4dba9.js";function zt(ot){let y,ce,me,Me,T,Je,h,ue,g,ye,U,mt="Image editing typically requires providing a mask of the area to be edited. DiffEdit automatically generates the mask for you based on a text query, making it easier overall to create a mask without image editing software. The DiffEdit algorithm works in three steps:",fe,j,rt="<li>the diffusion model denoises an image conditioned on some query text and reference text which produces different noise estimates for different areas of the image; the difference is used to infer a mask to identify which area of the image needs to be changed to match the query text</li> <li>the input image is encoded into latent space with DDIM</li> <li>the latents are decoded with the diffusion model conditioned on the text query, using the mask as a guide such that pixels outside the mask remain the same as in the input image</li>",we,Z,dt="This guide will show you how to use DiffEdit to edit images without manually creating a mask.",be,I,ct="Before you begin, make sure you have the following libraries installed:",Te,W,he,_,Mt='The <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline">StableDiffusionDiffEditPipeline</a> requires an image mask and a set of partially inverted latents. The image mask is generated from the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> function, and includes two parameters, <code>source_prompt</code> and <code>target_prompt</code>. These parameters determine what to edit in the image. For example, if you want to change a bowl of <em>fruits</em> to a bowl of <em>pears</em>, then:',ge,G,Ue,B,Jt='The partially inverted latents are generated from the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> function, and it is generally a good idea to include a <code>prompt</code> or <em>caption</em> describing the image to help guide the inverse latent sampling process. The caption can often be your <code>source_prompt</code>, but feel free to experiment with other text descriptions!',je,X,ut="Let’s load the pipeline, scheduler, inverse scheduler, and enable some optimizations to reduce memory usage:",Ze,C,Ie,V,yt="Load the image to edit:",We,R,_e,k,ft='Use the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> function to generate the image mask. You’ll need to pass it the <code>source_prompt</code> and <code>target_prompt</code> to specify what to edit in the image:',Ge,v,Be,Y,wt="Next, create the inverted latents and pass it a caption describing the image:",Xe,E,Ce,H,bt="Finally, pass the image mask and inverted latents to the pipeline. The <code>target_prompt</code> becomes the <code>prompt</code> now, and the <code>source_prompt</code> is used as the <code>negative_prompt</code>:",Ve,$,Re,f,Tt='<div><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/blob/main/assets/target.png?raw=true"/> <figcaption class="mt-2 text-center text-sm text-gray-500">edited image</figcaption></div>',ke,x,ve,N,ht='The source and target embeddings can be automatically generated with the <a href="https://huggingface.co/docs/transformers/model_doc/flan-t5" rel="nofollow">Flan-T5</a> model instead of creating them manually.',Ye,F,gt="Load the Flan-T5 model and tokenizer from the 🤗 Transformers library:",Ee,Q,He,z,Ut="Provide some initial text to prompt the model to generate the source and target prompts.",$e,S,xe,D,jt="Next, create a utility function to generate the prompts:",Ne,A,Fe,w,Zt='<p>Check out the <a href="https://huggingface.co/docs/transformers/main/en/generation_strategies" rel="nofollow">generation strategy</a> guide if you’re interested in learning more about strategies for generating different quality text.</p>',Qe,q,It='Load the text encoder model used by the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline">StableDiffusionDiffEditPipeline</a> to encode the text. You’ll use the text encoder to compute the text embeddings:',ze,L,Se,P,Wt='Finally, pass the embeddings to the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> and <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> functions, and pipeline to generate the image:',De,K,Ae,O,qe,ee,_t='While you can use the <code>source_prompt</code> as a caption to help generate the partially inverted latents, you can also use the <a href="https://huggingface.co/docs/transformers/model_doc/blip" rel="nofollow">BLIP</a> model to automatically generate a caption.',Le,te,Gt="Load the BLIP model and processor from the 🤗 Transformers library:",Pe,le,Ke,se,Bt="Create a utility function to generate a caption from the input image:",Oe,ae,et,ne,Xt="Load an input image and generate a caption for it using the <code>generate_caption</code> function:",tt,ie,lt,b,Ct='<figure><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png"/> <figcaption class="text-center">generated caption: &quot;a photograph of a bowl of fruit on a table&quot;</figcaption></figure>',st,pe,Vt='Now you can drop the caption into the <a href="/docs/diffusers/main/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> function to generate the partially inverted latents!',at,oe,nt,re,it;return T=new Nt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new Ft({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/diffedit.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/diffedit.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/diffedit.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/diffedit.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/diffedit.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/diffedit.ipynb"}]}}),g=new pt({props:{title:"DiffEdit",local:"diffedit",headingTag:"h1"}}),W=new u({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRl",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate</span>`,wrap:!1}}),G=new u({props:{code:"c291cmNlX3Byb21wdCUyMCUzRCUyMCUyMmElMjBib3dsJTIwb2YlMjBmcnVpdHMlMjIlMEF0YXJnZXRfcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJvd2wlMjBvZiUyMHBlYXJzJTIy",highlighted:`source_prompt = <span class="hljs-string">&quot;a bowl of fruits&quot;</span>
target_prompt = <span class="hljs-string">&quot;a bowl of pears&quot;</span>`,wrap:!1}}),C=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMERESU1JbnZlcnNlU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uRGlmZkVkaXRQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uRGlmZkVkaXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHNhZmV0eV9jaGVja2VyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmludmVyc2Vfc2NoZWR1bGVyJTIwJTNEJTIwRERJTUludmVyc2VTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGVsaW5lLmVuYWJsZV92YWVfc2xpY2luZygp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, DDIMInverseScheduler, StableDiffusionDiffEditPipeline

pipeline = StableDiffusionDiffEditPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()
pipeline.enable_vae_slicing()`,wrap:!1}}),R=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFyYXdfaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

img_url = <span class="hljs-string">&quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;</span>
raw_image = load_image(img_url).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
raw_image`,wrap:!1}}),v=new u({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBc291cmNlX3Byb21wdCUyMCUzRCUyMCUyMmElMjBib3dsJTIwb2YlMjBmcnVpdHMlMjIlMEF0YXJnZXRfcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJhc2tldCUyMG9mJTIwcGVhcnMlMjIlMEFtYXNrX2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUuZ2VuZXJhdGVfbWFzayglMEElMjAlMjAlMjAlMjBpbWFnZSUzRHJhd19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHNvdXJjZV9wcm9tcHQlM0Rzb3VyY2VfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3Byb21wdCUzRHRhcmdldF9wcm9tcHQlMkMlMEEpJTBBSW1hZ2UuZnJvbWFycmF5KChtYXNrX2ltYWdlLnNxdWVlemUoKSoyNTUpLmFzdHlwZSglMjJ1aW50OCUyMiklMkMlMjAlMjJMJTIyKS5yZXNpemUoKDc2OCUyQyUyMDc2OCkp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

source_prompt = <span class="hljs-string">&quot;a bowl of fruits&quot;</span>
target_prompt = <span class="hljs-string">&quot;a basket of pears&quot;</span>
mask_image = pipeline.generate_mask(
    image=raw_image,
    source_prompt=source_prompt,
    target_prompt=target_prompt,
)
Image.fromarray((mask_image.squeeze()*<span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>), <span class="hljs-string">&quot;L&quot;</span>).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))`,wrap:!1}}),E=new u({props:{code:"aW52X2xhdGVudHMlMjAlM0QlMjBwaXBlbGluZS5pbnZlcnQocHJvbXB0JTNEc291cmNlX3Byb21wdCUyQyUyMGltYWdlJTNEcmF3X2ltYWdlKS5sYXRlbnRz",highlighted:"inv_latents = pipeline.invert(prompt=source_prompt, image=raw_image).latents",wrap:!1}}),$=new u({props:{code:"b3V0cHV0X2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEdGFyZ2V0X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfbGF0ZW50cyUzRGludl9sYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEc291cmNlX3Byb21wdCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoKG1hc2tfaW1hZ2Uuc3F1ZWV6ZSgpKjI1NSkuYXN0eXBlKCUyMnVpbnQ4JTIyKSUyQyUyMCUyMkwlMjIpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCcmF3X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMG91dHB1dF9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`output_image = pipeline(
    prompt=target_prompt,
    mask_image=mask_image,
    image_latents=inv_latents,
    negative_prompt=source_prompt,
).images[<span class="hljs-number">0</span>]
mask_image = Image.fromarray((mask_image.squeeze()*<span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>), <span class="hljs-string">&quot;L&quot;</span>).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
make_image_grid([raw_image, mask_image, output_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),x=new pt({props:{title:"Generate source and target embeddings",local:"generate-source-and-target-embeddings",headingTag:"h2"}}),Q=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LWxhcmdlJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, T5ForConditionalGeneration

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-large&quot;</span>)
model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-large&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),S=new u({props:{code:"c291cmNlX2NvbmNlcHQlMjAlM0QlMjAlMjJib3dsJTIyJTBBdGFyZ2V0X2NvbmNlcHQlMjAlM0QlMjAlMjJiYXNrZXQlMjIlMEElMEFzb3VyY2VfdGV4dCUyMCUzRCUyMGYlMjJQcm92aWRlJTIwYSUyMGNhcHRpb24lMjBmb3IlMjBpbWFnZXMlMjBjb250YWluaW5nJTIwYSUyMCU3QnNvdXJjZV9jb25jZXB0JTdELiUyMCUyMiUwQSUyMlRoZSUyMGNhcHRpb25zJTIwc2hvdWxkJTIwYmUlMjBpbiUyMEVuZ2xpc2glMjBhbmQlMjBzaG91bGQlMjBiZSUyMG5vJTIwbG9uZ2VyJTIwdGhhbiUyMDE1MCUyMGNoYXJhY3RlcnMuJTIyJTBBJTBBdGFyZ2V0X3RleHQlMjAlM0QlMjBmJTIyUHJvdmlkZSUyMGElMjBjYXB0aW9uJTIwZm9yJTIwaW1hZ2VzJTIwY29udGFpbmluZyUyMGElMjAlN0J0YXJnZXRfY29uY2VwdCU3RC4lMjAlMjIlMEElMjJUaGUlMjBjYXB0aW9ucyUyMHNob3VsZCUyMGJlJTIwaW4lMjBFbmdsaXNoJTIwYW5kJTIwc2hvdWxkJTIwYmUlMjBubyUyMGxvbmdlciUyMHRoYW4lMjAxNTAlMjBjaGFyYWN0ZXJzLiUyMg==",highlighted:`source_concept = <span class="hljs-string">&quot;bowl&quot;</span>
target_concept = <span class="hljs-string">&quot;basket&quot;</span>

source_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{source_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>

target_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{target_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>`,wrap:!1}}),A=new u({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwZ2VuZXJhdGVfcHJvbXB0cyhpbnB1dF9wcm9tcHQpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3Byb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcy50byglMjJjdWRhJTIyKSUwQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuOCUyQyUyMG51bV9yZXR1cm5fc2VxdWVuY2VzJTNEMTYlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjglMkMlMjB0b3BfayUzRDEwJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQXNvdXJjZV9wcm9tcHRzJTIwJTNEJTIwZ2VuZXJhdGVfcHJvbXB0cyhzb3VyY2VfdGV4dCklMEF0YXJnZXRfcHJvbXB0cyUyMCUzRCUyMGdlbmVyYXRlX3Byb21wdHModGFyZ2V0X3RleHQpJTBBcHJpbnQoc291cmNlX3Byb21wdHMpJTBBcHJpbnQodGFyZ2V0X3Byb21wdHMp",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_prompts</span>(<span class="hljs-params">input_prompt</span>):
    input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids.to(<span class="hljs-string">&quot;cuda&quot;</span>)

    outputs = model.generate(
        input_ids, temperature=<span class="hljs-number">0.8</span>, num_return_sequences=<span class="hljs-number">16</span>, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">128</span>, top_k=<span class="hljs-number">10</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)

source_prompts = generate_prompts(source_text)
target_prompts = generate_prompts(target_text)
<span class="hljs-built_in">print</span>(source_prompts)
<span class="hljs-built_in">print</span>(target_prompts)`,wrap:!1}}),L=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionDiffEditPipeline

pipeline = StableDiffusionDiffEditPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
pipeline.enable_vae_slicing()

<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">embed_prompts</span>(<span class="hljs-params">sentences, tokenizer, text_encoder, device=<span class="hljs-string">&quot;cuda&quot;</span></span>):
    embeddings = []
    <span class="hljs-keyword">for</span> sent <span class="hljs-keyword">in</span> sentences:
        text_inputs = tokenizer(
            sent,
            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
            max_length=tokenizer.model_max_length,
            truncation=<span class="hljs-literal">True</span>,
            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
        )
        text_input_ids = text_inputs.input_ids
        prompt_embeds = text_encoder(text_input_ids.to(device), attention_mask=<span class="hljs-literal">None</span>)[<span class="hljs-number">0</span>]
        embeddings.append(prompt_embeds)
    <span class="hljs-keyword">return</span> torch.concatenate(embeddings, dim=<span class="hljs-number">0</span>).mean(dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)

source_embeds = embed_prompts(source_prompts, pipeline.tokenizer, pipeline.text_encoder)
target_embeds = embed_prompts(target_prompts, pipeline.tokenizer, pipeline.text_encoder)`,wrap:!1}}),K=new u({props:{code:"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",highlighted:`  from diffusers import DDIMInverseScheduler, DDIMScheduler
  from diffusers.utils import load_image, make_image_grid
  from PIL import Image

  pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
  pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)

  img_url = &quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;
  raw_image = load_image(img_url).resize((768, 768))

  mask_image = pipeline.generate_mask(
      image=raw_image,
<span class="hljs-deletion">-     source_prompt=source_prompt,</span>
<span class="hljs-deletion">-     target_prompt=target_prompt,</span>
<span class="hljs-addition">+     source_prompt_embeds=source_embeds,</span>
<span class="hljs-addition">+     target_prompt_embeds=target_embeds,</span>
  )

  inv_latents = pipeline.invert(
<span class="hljs-deletion">-     prompt=source_prompt,</span>
<span class="hljs-addition">+     prompt_embeds=source_embeds,</span>
      image=raw_image,
  ).latents

  output_image = pipeline(
      mask_image=mask_image,
      image_latents=inv_latents,
<span class="hljs-deletion">-     prompt=target_prompt,</span>
<span class="hljs-deletion">-     negative_prompt=source_prompt,</span>
<span class="hljs-addition">+     prompt_embeds=target_embeds,</span>
<span class="hljs-addition">+     negative_prompt_embeds=source_embeds,</span>
  ).images[0]
  mask_image = Image.fromarray((mask_image.squeeze()*255).astype(&quot;uint8&quot;), &quot;L&quot;)
  make_image_grid([raw_image, mask_image, output_image], rows=1, cols=3)`,wrap:!1}}),O=new pt({props:{title:"Generate a caption for inversion",local:"generate-a-caption-for-inversion",headingTag:"h2"}}),le=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQmxpcEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEJsaXBQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBCbGlwUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBCbGlwRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWJhc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BlipForConditionalGeneration, BlipProcessor

processor = BlipProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>)
model = BlipForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>)`,wrap:!1}}),ae=new u({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwZ2VuZXJhdGVfY2FwdGlvbihpbWFnZXMlMkMlMjBjYXB0aW9uX2dlbmVyYXRvciUyQyUyMGNhcHRpb25fcHJvY2Vzc29yKSUzQSUwQSUyMCUyMCUyMCUyMHRleHQlMjAlM0QlMjAlMjJhJTIwcGhvdG9ncmFwaCUyMG9mJTIyJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwY2FwdGlvbl9wcm9jZXNzb3IoaW1hZ2VzJTJDJTIwdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRGNhcHRpb25fZ2VuZXJhdG9yLmR0eXBlKSUwQSUyMCUyMCUyMCUyMGNhcHRpb25fZ2VuZXJhdG9yLnRvKCUyMmN1ZGElMjIpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMGNhcHRpb25fZ2VuZXJhdG9yLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwb2ZmbG9hZCUyMGNhcHRpb24lMjBnZW5lcmF0b3IlMEElMjAlMjAlMjAlMjBjYXB0aW9uX2dlbmVyYXRvci50byglMjJjcHUlMjIpJTBBJTBBJTIwJTIwJTIwJTIwY2FwdGlvbiUyMCUzRCUyMGNhcHRpb25fcHJvY2Vzc29yLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNhcHRpb24=",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_caption</span>(<span class="hljs-params">images, caption_generator, caption_processor</span>):
    text = <span class="hljs-string">&quot;a photograph of&quot;</span>

    inputs = caption_processor(images, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=caption_generator.dtype)
    caption_generator.to(<span class="hljs-string">&quot;cuda&quot;</span>)
    outputs = caption_generator.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)

    <span class="hljs-comment"># offload caption generator</span>
    caption_generator.to(<span class="hljs-string">&quot;cpu&quot;</span>)

    caption = caption_processor.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> caption`,wrap:!1}}),ie=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFjYXB0aW9uJTIwJTNEJTIwZ2VuZXJhdGVfY2FwdGlvbihyYXdfaW1hZ2UlMkMlMjBtb2RlbCUyQyUyMHByb2Nlc3Nvcik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;</span>
raw_image = load_image(img_url).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
caption = generate_caption(raw_image, model, processor)`,wrap:!1}}),oe=new Qt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/diffedit.md"}}),{c(){y=i("meta"),ce=a(),me=i("p"),Me=a(),m(T.$$.fragment),Je=a(),m(h.$$.fragment),ue=a(),m(g.$$.fragment),ye=a(),U=i("p"),U.textContent=mt,fe=a(),j=i("ol"),j.innerHTML=rt,we=a(),Z=i("p"),Z.textContent=dt,be=a(),I=i("p"),I.textContent=ct,Te=a(),m(W.$$.fragment),he=a(),_=i("p"),_.innerHTML=Mt,ge=a(),m(G.$$.fragment),Ue=a(),B=i("p"),B.innerHTML=Jt,je=a(),X=i("p"),X.textContent=ut,Ze=a(),m(C.$$.fragment),Ie=a(),V=i("p"),V.textContent=yt,We=a(),m(R.$$.fragment),_e=a(),k=i("p"),k.innerHTML=ft,Ge=a(),m(v.$$.fragment),Be=a(),Y=i("p"),Y.textContent=wt,Xe=a(),m(E.$$.fragment),Ce=a(),H=i("p"),H.innerHTML=bt,Ve=a(),m($.$$.fragment),Re=a(),f=i("div"),f.innerHTML=Tt,ke=a(),m(x.$$.fragment),ve=a(),N=i("p"),N.innerHTML=ht,Ye=a(),F=i("p"),F.textContent=gt,Ee=a(),m(Q.$$.fragment),He=a(),z=i("p"),z.textContent=Ut,$e=a(),m(S.$$.fragment),xe=a(),D=i("p"),D.textContent=jt,Ne=a(),m(A.$$.fragment),Fe=a(),w=i("blockquote"),w.innerHTML=Zt,Qe=a(),q=i("p"),q.innerHTML=It,ze=a(),m(L.$$.fragment),Se=a(),P=i("p"),P.innerHTML=Wt,De=a(),m(K.$$.fragment),Ae=a(),m(O.$$.fragment),qe=a(),ee=i("p"),ee.innerHTML=_t,Le=a(),te=i("p"),te.textContent=Gt,Pe=a(),m(le.$$.fragment),Ke=a(),se=i("p"),se.textContent=Bt,Oe=a(),m(ae.$$.fragment),et=a(),ne=i("p"),ne.innerHTML=Xt,tt=a(),m(ie.$$.fragment),lt=a(),b=i("div"),b.innerHTML=Ct,st=a(),pe=i("p"),pe.innerHTML=Vt,at=a(),m(oe.$$.fragment),nt=a(),re=i("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);y=p(t,"META",{name:!0,content:!0}),t.forEach(l),ce=n(e),me=p(e,"P",{}),Rt(me).forEach(l),Me=n(e),r(T.$$.fragment,e),Je=n(e),r(h.$$.fragment,e),ue=n(e),r(g.$$.fragment,e),ye=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-9fgb3t"&&(U.textContent=mt),fe=n(e),j=p(e,"OL",{"data-svelte-h":!0}),o(j)!=="svelte-13ofpju"&&(j.innerHTML=rt),we=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-9vh5wh"&&(Z.textContent=dt),be=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-cwruts"&&(I.textContent=ct),Te=n(e),r(W.$$.fragment,e),he=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1rtgewh"&&(_.innerHTML=Mt),ge=n(e),r(G.$$.fragment,e),Ue=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-q1naxr"&&(B.innerHTML=Jt),je=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-19i848b"&&(X.textContent=ut),Ze=n(e),r(C.$$.fragment,e),Ie=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1umymvd"&&(V.textContent=yt),We=n(e),r(R.$$.fragment,e),_e=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-p1ppsn"&&(k.innerHTML=ft),Ge=n(e),r(v.$$.fragment,e),Be=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-58wksg"&&(Y.textContent=wt),Xe=n(e),r(E.$$.fragment,e),Ce=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-949sql"&&(H.innerHTML=bt),Ve=n(e),r($.$$.fragment,e),Re=n(e),f=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-6s9t77"&&(f.innerHTML=Tt),ke=n(e),r(x.$$.fragment,e),ve=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-whlnrh"&&(N.innerHTML=ht),Ye=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1lu7pxc"&&(F.textContent=gt),Ee=n(e),r(Q.$$.fragment,e),He=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1t1js6"&&(z.textContent=Ut),$e=n(e),r(S.$$.fragment,e),xe=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1p4c9jk"&&(D.textContent=jt),Ne=n(e),r(A.$$.fragment,e),Fe=n(e),w=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-3fn58u"&&(w.innerHTML=Zt),Qe=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-wrl4ww"&&(q.innerHTML=It),ze=n(e),r(L.$$.fragment,e),Se=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-dltym8"&&(P.innerHTML=Wt),De=n(e),r(K.$$.fragment,e),Ae=n(e),r(O.$$.fragment,e),qe=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1y9t3by"&&(ee.innerHTML=_t),Le=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-13qc2l3"&&(te.textContent=Gt),Pe=n(e),r(le.$$.fragment,e),Ke=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-16pyjsw"&&(se.textContent=Bt),Oe=n(e),r(ae.$$.fragment,e),et=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-3lbf1j"&&(ne.innerHTML=Xt),tt=n(e),r(ie.$$.fragment,e),lt=n(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1jq3ee2"&&(b.innerHTML=Ct),st=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-14bczqy"&&(pe.innerHTML=Vt),at=n(e),r(oe.$$.fragment,e),nt=n(e),re=p(e,"P",{}),Rt(re).forEach(l),this.h()},h(){de(y,"name","hf:doc:metadata"),de(y,"content",St),de(f,"class","flex gap-4"),de(w,"class","tip"),de(b,"class","flex justify-center")},m(e,t){xt(document.head,y),s(e,ce,t),s(e,me,t),s(e,Me,t),d(T,e,t),s(e,Je,t),d(h,e,t),s(e,ue,t),d(g,e,t),s(e,ye,t),s(e,U,t),s(e,fe,t),s(e,j,t),s(e,we,t),s(e,Z,t),s(e,be,t),s(e,I,t),s(e,Te,t),d(W,e,t),s(e,he,t),s(e,_,t),s(e,ge,t),d(G,e,t),s(e,Ue,t),s(e,B,t),s(e,je,t),s(e,X,t),s(e,Ze,t),d(C,e,t),s(e,Ie,t),s(e,V,t),s(e,We,t),d(R,e,t),s(e,_e,t),s(e,k,t),s(e,Ge,t),d(v,e,t),s(e,Be,t),s(e,Y,t),s(e,Xe,t),d(E,e,t),s(e,Ce,t),s(e,H,t),s(e,Ve,t),d($,e,t),s(e,Re,t),s(e,f,t),s(e,ke,t),d(x,e,t),s(e,ve,t),s(e,N,t),s(e,Ye,t),s(e,F,t),s(e,Ee,t),d(Q,e,t),s(e,He,t),s(e,z,t),s(e,$e,t),d(S,e,t),s(e,xe,t),s(e,D,t),s(e,Ne,t),d(A,e,t),s(e,Fe,t),s(e,w,t),s(e,Qe,t),s(e,q,t),s(e,ze,t),d(L,e,t),s(e,Se,t),s(e,P,t),s(e,De,t),d(K,e,t),s(e,Ae,t),d(O,e,t),s(e,qe,t),s(e,ee,t),s(e,Le,t),s(e,te,t),s(e,Pe,t),d(le,e,t),s(e,Ke,t),s(e,se,t),s(e,Oe,t),d(ae,e,t),s(e,et,t),s(e,ne,t),s(e,tt,t),d(ie,e,t),s(e,lt,t),s(e,b,t),s(e,st,t),s(e,pe,t),s(e,at,t),d(oe,e,t),s(e,nt,t),s(e,re,t),it=!0},p:vt,i(e){it||(c(T.$$.fragment,e),c(h.$$.fragment,e),c(g.$$.fragment,e),c(W.$$.fragment,e),c(G.$$.fragment,e),c(C.$$.fragment,e),c(R.$$.fragment,e),c(v.$$.fragment,e),c(E.$$.fragment,e),c($.$$.fragment,e),c(x.$$.fragment,e),c(Q.$$.fragment,e),c(S.$$.fragment,e),c(A.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),it=!0)},o(e){M(T.$$.fragment,e),M(h.$$.fragment,e),M(g.$$.fragment,e),M(W.$$.fragment,e),M(G.$$.fragment,e),M(C.$$.fragment,e),M(R.$$.fragment,e),M(v.$$.fragment,e),M(E.$$.fragment,e),M($.$$.fragment,e),M(x.$$.fragment,e),M(Q.$$.fragment,e),M(S.$$.fragment,e),M(A.$$.fragment,e),M(L.$$.fragment,e),M(K.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),it=!1},d(e){e&&(l(ce),l(me),l(Me),l(Je),l(ue),l(ye),l(U),l(fe),l(j),l(we),l(Z),l(be),l(I),l(Te),l(he),l(_),l(ge),l(Ue),l(B),l(je),l(X),l(Ze),l(Ie),l(V),l(We),l(_e),l(k),l(Ge),l(Be),l(Y),l(Xe),l(Ce),l(H),l(Ve),l(Re),l(f),l(ke),l(ve),l(N),l(Ye),l(F),l(Ee),l(He),l(z),l($e),l(xe),l(D),l(Ne),l(Fe),l(w),l(Qe),l(q),l(ze),l(Se),l(P),l(De),l(Ae),l(qe),l(ee),l(Le),l(te),l(Pe),l(Ke),l(se),l(Oe),l(et),l(ne),l(tt),l(lt),l(b),l(st),l(pe),l(at),l(nt),l(re)),l(y),J(T,e),J(h,e),J(g,e),J(W,e),J(G,e),J(C,e),J(R,e),J(v,e),J(E,e),J($,e),J(x,e),J(Q,e),J(S,e),J(A,e),J(L,e),J(K,e),J(O,e),J(le,e),J(ae,e),J(ie,e),J(oe,e)}}}const St='{"title":"DiffEdit","local":"diffedit","sections":[{"title":"Generate source and target embeddings","local":"generate-source-and-target-embeddings","sections":[],"depth":2},{"title":"Generate a caption for inversion","local":"generate-a-caption-for-inversion","sections":[],"depth":2}],"depth":1}';function Dt(ot){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Et{constructor(y){super(),Ht(this,y,Dt,zt,kt,{})}}export{el as component};
