import{s as ss,o as as,n as ls}from"../chunks/scheduler.36a0863c.js";import{S as ts,i as ns,g as i,s as t,r as o,A as is,h as p,f as a,c as n,j as es,u as c,x as h,k as Ve,y as ps,a as l,v as m,d,t as u,w as g}from"../chunks/index.f891bdb2.js";import{T as rs}from"../chunks/Tip.a8272f7f.js";import{C as M}from"../chunks/CodeBlock.3ec784ea.js";import{H as ee,E as os}from"../chunks/EditOnGithub.a58e27a9.js";function cs(se){let r,$="Echa un vistazo a la documentación de <code>pipeline()</code> para obtener una lista completa de tareas admitidas.";return{c(){r=i("p"),r.innerHTML=$},l(f){r=p(f,"P",{"data-svelte-h":!0}),h(r)!=="svelte-1daerre"&&(r.innerHTML=$)},m(f,K){l(f,r,K)},p:ls,d(f){f&&a(r)}}}function ms(se){let r,$,f,K,U,ae,b,_e='Un <code>pipeline()</code> simplifica el uso de cualquier modelo del <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a> para la inferencia en una variedad de tareas como la generación de texto, la segmentación de imágenes y la clasificación de audio. Incluso si no tienes experiencia con una modalidad específica o no comprendes el código que alimenta los modelos, ¡aún puedes usarlos con el <code>pipeline()</code>! Este tutorial te enseñará a:',le,T,qe="<li>Utilizar un <code>pipeline()</code> para inferencia.</li> <li>Utilizar un tokenizador o modelo específico.</li> <li>Utilizar un <code>pipeline()</code> para tareas de audio y visión.</li>",te,y,ne,w,ie,x,Le="Si bien cada tarea tiene un <code>pipeline()</code> asociado, es más sencillo usar la abstracción general <code>pipeline()</code> que contiene todos los pipelines de tareas específicas. El <code>pipeline()</code> carga automáticamente un modelo predeterminado y un tokenizador con capacidad de inferencia para tu tarea.",pe,J,Re="<li>Comienza creando un <code>pipeline()</code> y específica una tarea de inferencia:</li>",re,v,oe,j,ze="<li>Pasa tu texto de entrada al <code>pipeline()</code>:</li>",ce,Z,me,k,Ee="Si tienes más de una entrada, pásala como una lista:",de,G,ue,I,Xe="Cualquier parámetro adicional para tu tarea también se puede incluir en el <code>pipeline()</code>. La tarea <code>text-generation</code> tiene un método <code>generate()</code> con varios parámetros para controlar la salida. Por ejemplo, si deseas generar más de una salida, defínelo en el parámetro <code>num_return_sequences</code>:",ge,C,he,W,fe,B,Pe='El <code>pipeline()</code> acepta cualquier modelo del <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>. Hay etiquetas en el Model Hub que te permiten filtrar por el modelo que te gustaría utilizar para tu tarea. Una vez que hayas elegido un modelo apropiado, cárgalo con la clase <code>AutoModelFor</code> y <code>AutoTokenizer</code> correspondientes. Por ejemplo, carga la clase <code>AutoModelForCausalLM</code> para una tarea de modelado de lenguaje causal:',Me,H,ye,V,Se="Crea un <code>pipeline()</code> para tu tarea y específica el modelo y el tokenizador que cargaste:",je,_,$e,q,Fe="Pasa tu texto de entrada a <code>pipeline()</code> para generar algo de texto:",Ue,L,be,R,Te,z,Ye="La flexibilidad de <code>pipeline()</code> significa que también se puede extender a tareas de audio.",we,E,Qe='Por ejemplo, clasifiquemos la emoción de un breve fragmento del famoso discurso de John F. Kennedy <a href="https://en.wikipedia.org/wiki/We_choose_to_go_to_the_Moon" rel="nofollow">“We choose to go to the Moon”</a>. Encuentra un modelo de <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">audio classification</a> para reconocimiento de emociones en el Model Hub y cárgalo en el <code>pipeline()</code>:',xe,X,Je,P,Ne="Pasa el archivo de audio al <code>pipeline()</code>:",ve,S,Ze,F,ke,Y,Ae="Finalmente, utilizar un <code>pipeline()</code> para tareas de visión es prácticamente igual.",Ge,Q,De="Específica tu tarea de visión y pasa tu imagen al clasificador. La imagen puede ser un enlace o una ruta local a la imagen. Por ejemplo, ¿qué especie de gato se muestra a continuación?",Ie,N,Ke='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Ce,A,We,D,Be,O,He;return U=new ee({props:{title:"Pipelines para inferencia",local:"pipelines-para-inferencia",headingTag:"h1"}}),y=new rs({props:{$$slots:{default:[cs]},$$scope:{ctx:se}}}),w=new ee({props:{title:"Uso del pipeline",local:"uso-del-pipeline",headingTag:"h2"}}),v=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)`,wrap:!1}}),Z=new M({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Iron-priests at the door to the east, and thirteen for the Lord Kings at the end of the mountain&#x27;</span>}]`,wrap:!1}}),G=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOaW5lJTIwZm9yJTIwTW9ydGFsJTIwTWVuJTJDJTIwZG9vbWVkJTIwdG8lMjBkaWUlMkMlMjBPbmUlMjBmb3IlMjB0aGUlMjBEYXJrJTIwTG9yZCUyMG9uJTIwaGlzJTIwZGFyayUyMHRocm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Nine for Mortal Men, doomed to die, One for the Dark Lord on his dark throne&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),C=new M({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new ee({props:{title:"Selecciona un modelo y un tokenizador",local:"selecciona-un-modelo-y-un-tokenizador",headingTag:"h3"}}),H=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)`,wrap:!1}}),_=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),L=new M({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Dragon-lords (for them to rule in a world ruled by their rulers, and all who live within the realm&#x27;</span>}]`,wrap:!1}}),R=new ee({props:{title:"Pipeline de audio",local:"pipeline-de-audio",headingTag:"h2"}}),X=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXVkaW9fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZWhjYWxhYnJlcyUyRndhdjJ2ZWMyLWxnLXhsc3ItZW4tc3BlZWNoLWVtb3Rpb24tcmVjb2duaXRpb24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier = pipeline(
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;ehcalabres/wav2vec2-lg-xlsr-en-speech-emotion-recognition&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),S=new M({props:{code:"YXVkaW9fY2xhc3NpZmllciglMjJqZmtfbW9vbl9zcGVlY2gud2F2JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier(<span class="hljs-string">&quot;jfk_moon_speech.wav&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;calm&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13856211304664612</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;disgust&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13148026168346405</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;happy&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12635163962841034</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;angry&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12439591437578201</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fearful&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12404385954141617</span>}]`,wrap:!1}}),F=new ee({props:{title:"Pipeline de visión",local:"pipeline-de-visión",headingTag:"h2"}}),A=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIpJTBBdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4403027892112732</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.03433405980467796</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.032148055732250214</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.02353910356760025</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.023034192621707916</span>}]`,wrap:!1}}),D=new os({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/es/pipeline_tutorial.md"}}),{c(){r=i("meta"),$=t(),f=i("p"),K=t(),o(U.$$.fragment),ae=t(),b=i("p"),b.innerHTML=_e,le=t(),T=i("ul"),T.innerHTML=qe,te=t(),o(y.$$.fragment),ne=t(),o(w.$$.fragment),ie=t(),x=i("p"),x.innerHTML=Le,pe=t(),J=i("ol"),J.innerHTML=Re,re=t(),o(v.$$.fragment),oe=t(),j=i("ol"),j.innerHTML=ze,ce=t(),o(Z.$$.fragment),me=t(),k=i("p"),k.textContent=Ee,de=t(),o(G.$$.fragment),ue=t(),I=i("p"),I.innerHTML=Xe,ge=t(),o(C.$$.fragment),he=t(),o(W.$$.fragment),fe=t(),B=i("p"),B.innerHTML=Pe,Me=t(),o(H.$$.fragment),ye=t(),V=i("p"),V.innerHTML=Se,je=t(),o(_.$$.fragment),$e=t(),q=i("p"),q.innerHTML=Fe,Ue=t(),o(L.$$.fragment),be=t(),o(R.$$.fragment),Te=t(),z=i("p"),z.innerHTML=Ye,we=t(),E=i("p"),E.innerHTML=Qe,xe=t(),o(X.$$.fragment),Je=t(),P=i("p"),P.innerHTML=Ne,ve=t(),o(S.$$.fragment),Ze=t(),o(F.$$.fragment),ke=t(),Y=i("p"),Y.innerHTML=Ae,Ge=t(),Q=i("p"),Q.textContent=De,Ie=t(),N=i("p"),N.innerHTML=Ke,Ce=t(),o(A.$$.fragment),We=t(),o(D.$$.fragment),Be=t(),O=i("p"),this.h()},l(e){const s=is("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(a),$=n(e),f=p(e,"P",{}),es(f).forEach(a),K=n(e),c(U.$$.fragment,e),ae=n(e),b=p(e,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1k5gyag"&&(b.innerHTML=_e),le=n(e),T=p(e,"UL",{"data-svelte-h":!0}),h(T)!=="svelte-7f1ymp"&&(T.innerHTML=qe),te=n(e),c(y.$$.fragment,e),ne=n(e),c(w.$$.fragment,e),ie=n(e),x=p(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-gjt1nl"&&(x.innerHTML=Le),pe=n(e),J=p(e,"OL",{"data-svelte-h":!0}),h(J)!=="svelte-yki1ef"&&(J.innerHTML=Re),re=n(e),c(v.$$.fragment,e),oe=n(e),j=p(e,"OL",{start:!0,"data-svelte-h":!0}),h(j)!=="svelte-1e6diuh"&&(j.innerHTML=ze),ce=n(e),c(Z.$$.fragment,e),me=n(e),k=p(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-wgq0wk"&&(k.textContent=Ee),de=n(e),c(G.$$.fragment,e),ue=n(e),I=p(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-183jawq"&&(I.innerHTML=Xe),ge=n(e),c(C.$$.fragment,e),he=n(e),c(W.$$.fragment,e),fe=n(e),B=p(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-1sfnia5"&&(B.innerHTML=Pe),Me=n(e),c(H.$$.fragment,e),ye=n(e),V=p(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-15my78f"&&(V.innerHTML=Se),je=n(e),c(_.$$.fragment,e),$e=n(e),q=p(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-1qfapyh"&&(q.innerHTML=Fe),Ue=n(e),c(L.$$.fragment,e),be=n(e),c(R.$$.fragment,e),Te=n(e),z=p(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-q0unz9"&&(z.innerHTML=Ye),we=n(e),E=p(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-5ycnhq"&&(E.innerHTML=Qe),xe=n(e),c(X.$$.fragment,e),Je=n(e),P=p(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-1nrtv5e"&&(P.innerHTML=Ne),ve=n(e),c(S.$$.fragment,e),Ze=n(e),c(F.$$.fragment,e),ke=n(e),Y=p(e,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-1na9ujt"&&(Y.innerHTML=Ae),Ge=n(e),Q=p(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-j2gvop"&&(Q.textContent=De),Ie=n(e),N=p(e,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1bks2jw"&&(N.innerHTML=Ke),Ce=n(e),c(A.$$.fragment,e),We=n(e),c(D.$$.fragment,e),Be=n(e),O=p(e,"P",{}),es(O).forEach(a),this.h()},h(){Ve(r,"name","hf:doc:metadata"),Ve(r,"content",ds),Ve(j,"start","2")},m(e,s){ps(document.head,r),l(e,$,s),l(e,f,s),l(e,K,s),m(U,e,s),l(e,ae,s),l(e,b,s),l(e,le,s),l(e,T,s),l(e,te,s),m(y,e,s),l(e,ne,s),m(w,e,s),l(e,ie,s),l(e,x,s),l(e,pe,s),l(e,J,s),l(e,re,s),m(v,e,s),l(e,oe,s),l(e,j,s),l(e,ce,s),m(Z,e,s),l(e,me,s),l(e,k,s),l(e,de,s),m(G,e,s),l(e,ue,s),l(e,I,s),l(e,ge,s),m(C,e,s),l(e,he,s),m(W,e,s),l(e,fe,s),l(e,B,s),l(e,Me,s),m(H,e,s),l(e,ye,s),l(e,V,s),l(e,je,s),m(_,e,s),l(e,$e,s),l(e,q,s),l(e,Ue,s),m(L,e,s),l(e,be,s),m(R,e,s),l(e,Te,s),l(e,z,s),l(e,we,s),l(e,E,s),l(e,xe,s),m(X,e,s),l(e,Je,s),l(e,P,s),l(e,ve,s),m(S,e,s),l(e,Ze,s),m(F,e,s),l(e,ke,s),l(e,Y,s),l(e,Ge,s),l(e,Q,s),l(e,Ie,s),l(e,N,s),l(e,Ce,s),m(A,e,s),l(e,We,s),m(D,e,s),l(e,Be,s),l(e,O,s),He=!0},p(e,[s]){const Oe={};s&2&&(Oe.$$scope={dirty:s,ctx:e}),y.$set(Oe)},i(e){He||(d(U.$$.fragment,e),d(y.$$.fragment,e),d(w.$$.fragment,e),d(v.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d(C.$$.fragment,e),d(W.$$.fragment,e),d(H.$$.fragment,e),d(_.$$.fragment,e),d(L.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(S.$$.fragment,e),d(F.$$.fragment,e),d(A.$$.fragment,e),d(D.$$.fragment,e),He=!0)},o(e){u(U.$$.fragment,e),u(y.$$.fragment,e),u(w.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(C.$$.fragment,e),u(W.$$.fragment,e),u(H.$$.fragment,e),u(_.$$.fragment,e),u(L.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(S.$$.fragment,e),u(F.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),He=!1},d(e){e&&(a($),a(f),a(K),a(ae),a(b),a(le),a(T),a(te),a(ne),a(ie),a(x),a(pe),a(J),a(re),a(oe),a(j),a(ce),a(me),a(k),a(de),a(ue),a(I),a(ge),a(he),a(fe),a(B),a(Me),a(ye),a(V),a(je),a($e),a(q),a(Ue),a(be),a(Te),a(z),a(we),a(E),a(xe),a(Je),a(P),a(ve),a(Ze),a(ke),a(Y),a(Ge),a(Q),a(Ie),a(N),a(Ce),a(We),a(Be),a(O)),a(r),g(U,e),g(y,e),g(w,e),g(v,e),g(Z,e),g(G,e),g(C,e),g(W,e),g(H,e),g(_,e),g(L,e),g(R,e),g(X,e),g(S,e),g(F,e),g(A,e),g(D,e)}}}const ds='{"title":"Pipelines para inferencia","local":"pipelines-para-inferencia","sections":[{"title":"Uso del pipeline","local":"uso-del-pipeline","sections":[{"title":"Selecciona un modelo y un tokenizador","local":"selecciona-un-modelo-y-un-tokenizador","sections":[],"depth":3}],"depth":2},{"title":"Pipeline de audio","local":"pipeline-de-audio","sections":[],"depth":2},{"title":"Pipeline de visión","local":"pipeline-de-visión","sections":[],"depth":2}],"depth":1}';function us(se){return as(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends ts{constructor(r){super(),ns(this,r,us,ms,ss,{})}}export{js as component};
