import{s as Te,n as Me,o as Je}from"../chunks/scheduler.56730f09.js";import{S as ce,i as ue,g as o,s as n,r as i,A as fe,h as p,f as t,c as a,j as ie,u as m,x as r,k as me,y as de,a as s,v as T,d as M,t as J,w as c}from"../chunks/index.1f144517.js";import{C as f}from"../chunks/CodeBlock.738eeccb.js";import{D as Ue}from"../chunks/DocNotebookDropdown.243c3df7.js";import{H as el}from"../chunks/Heading.57d46534.js";function we(Bl){let u,tl,K,sl,d,nl,U,al,w,Al='XLA(Accelerated Linear Algebra)는 TensorFlow 모델의 실행 시간을 가속화하기 위한 컴파일러입니다. <a href="https://www.tensorflow.org/xla" rel="nofollow">공식 문서</a>에 따르면 다음과 같습니다:',ol,y,zl="XLA(Accelerated Linear Algebra)는 선형 대수를 위한 도메인 특화 컴파일러로, TensorFlow 모델을 소스 코드 변경 없이 가속화할 수 있습니다.",pl,b,Ll='TensorFlow에서 XLA를 사용하는 것은 간단합니다. XLA는 <code>tensorflow</code> 라이브러리 내에 패키지로 제공되며, <a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>과 같은 그래프 생성 함수에서 <code>jit_compile</code> 인수를 사용하여 활성화할 수 있습니다. <code>fit()</code> 및 <code>predict()</code>와 같은 Keras 메소드를 사용하는 경우, <code>jit_compile</code> 인수를 <code>model.compile()</code>에 전달하여 XLA를 간단하게 활성화할 수 있습니다. 그러나 XLA는 이러한 메소드에 국한되지 않고 임의의 <code>tf.function</code>을 가속화하는 데에도 사용할 수 있습니다.',rl,h,Nl='🤗 Transformers에서는 <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>, <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>, <a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>와 같은 모델의 텍스트 생성, 그리고 <a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>와 같은 모델의 음성 처리를 포함하여 여러 TensorFlow 메소드가 XLA와 호환되도록 다시 작성되었습니다.',il,g,Hl="정확한 속도 향상은 모델에 따라 다르지만, 🤗 Transformers 내의 TensorFlow 텍스트 생성 모델의 경우 최대 100배의 속도 향상을 확인했습니다. 이 문서에서는 이러한 모델에 대해 XLA를 사용하여 최대 성능을 얻는 방법을 설명합니다. 또한 XLA 통합의 벤치마크 및 디자인 철학에 대한 추가 자료 링크도 제공할 것입니다.",ml,j,Tl,R,Yl="TensorFlow에서 다음과 같은 모델을 고려해 봅시다:",Ml,V,Jl,k,Dl="위 모델은 차원이 <code>(10, )</code>인 입력을 받습니다. 다음과 같이 모델을 사용하여 순전파를 실행할 수 있습니다:",cl,_,ul,C,ql="XLA로 컴파일된 함수로 순전파를 실행하려면 다음과 같이 해야 합니다:",fl,X,dl,Z,Sl="<code>model</code>의 기본 <code>call()</code> 함수는 XLA 그래프를 컴파일하는 데 사용됩니다. 그러나 다른 모델 함수를 XLA로 컴파일하려면 다음과 같이 할 수도 있습니다:",Ul,I,wl,Q,yl,G,Ol="🤗 Transformers에서 XLA로 가속화된 생성을 활성화하려면 최신 버전의 <code>transformers</code>가 설치되어 있어야 합니다. 다음과 같이 설치할 수 있습니다:",bl,F,hl,W,Pl="그리고 다음 코드를 실행할 수 있습니다:",gl,$,jl,v,Kl="알 수 있듯이, <code>generate()</code>에서 XLA를 활성화하는 것은 단 한 줄의 코드입니다. 코드의 나머지 부분은 변경되지 않습니다. 그러나 위 코드 스니펫에서는 XLA에 특정한 몇 가지 주의할 점이 있습니다. XLA가 가져다줄 속도 향상을 실현하기 위해서는 이를 알고 있어야 합니다. 다음 섹션에서 이에 대해 논의합니다.",Rl,x,Vl,E,le='XLA 활성화 함수(<code>xla_generate()</code>와 같은)를 처음 실행할 때 내부적으로 계산 그래프를 추론하려고 하며, 이는 시간이 소요됩니다. 이 과정은 <a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“추적(tracing)”</a>이라고 알려져 있습니다.',kl,B,ee="생성 시간이 빠르지 않다는 것을 알 수 있을 것입니다. <code>xla_generate()</code>(또는 다른 XLA 활성화 함수)의 연속 호출은 함수에 전달된 입력이 초기에 구축된 계산 그래프와 동일한 형태를 따른다면, 계산 그래프를 추론할 필요가 없습니다. 이는 입력 형태가 고정된 모달리티(예: 이미지)에는 문제가 되지 않지만, 가변 입력 형태 모달리티(예: 텍스트)를 사용할 때 주의해야 합니다.",_l,A,te="<code>xla_generate()</code>가 항상 동일한 입력 형태로 동작하도록 하려면, 토크나이저를 호출할 때 <code>padding</code> 인수를 지정할 수 있습니다.",Cl,z,Xl,L,se="이렇게 하면 <code>xla_generate()</code>에 대한 입력이 항상 추적된 형태로 전달되어 생성 시간이 가속화됩니다. 다음 코드로 이를 확인할 수 있습니다:",Zl,N,Il,H,ne="Tesla T4 GPU에서는 다음과 같은 출력을 예상할 수 있습니다:",Ql,Y,Gl,D,ae="<code>xla_generate()</code>의 첫 번째 호출은 추적 때문에 시간이 오래 걸리지만, 연속 호출은 몇 배나 빠릅니다. 생성 옵션에 대한 어떤 변경이든 다시 추적을 유발하므로 생성 시간이 느려질 수 있음을 명심하세요.",Fl,q,oe="이 문서에서는 🤗 Transformers에서 제공하는 모든 텍스트 생성 옵션을 다루지 않았습니다. 고급 사용 사례에 대해 문서를 참조하시기 바랍니다.",Wl,S,$l,O,pe="여기에 🤗 Transformers와 XLA에 대해 더 자세히 알고 싶은 경우 도움이 될 수 있는 몇 가지 추가 자료를 제공합니다.",vl,P,re='<li><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">이 Colab 노트북</a>은 XLA와 호환되는 인코더-디코더(<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>와 같은) 및 디코더 전용(<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>와 같은) 텍스트 생성 모델을 실험해 볼 수 있는 대화형 데모를 제공합니다.</li> <li><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">이 블로그 글</a>은 TensorFlow에서 XLA에 대한 친절한 소개와 함께 XLA와 호환되는 모델의 비교 벤치마크에 대한 개요를 제공합니다.</li> <li><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">이 블로그 글</a>은 🤗 Transformers의 TensorFlow 모델에 XLA 지원을 추가하는 것에 대한 디자인 철학을 논의합니다.</li> <li>XLA와 TensorFlow 그래프에 대해 더 자세히 알고 싶은 경우 추천하는 글:<ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA: 기계 학습을 위한 최적화 컴파일러</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">그래프 및 tf.function 소개</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow">tf.function으로 성능 향상하기</a></li></ul></li>',xl,ll,El;return d=new el({props:{title:"TensorFlow 모델을 위한 XLA 통합",local:"xla-integration-for-tensorflow-models",headingTag:"h1"}}),U=new Ue({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/tf_xla.ipynb"}]}}),j=new el({props:{title:"XLA를 사용하여 TF 함수 실행하기",local:"running-tf-functions-with-xla",headingTag:"h2"}}),V=new f({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`,wrap:!1}}),_=new f({props:{code:"JTIzJTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTk3JTkwJTIwJUVCJThDJTgwJUVEJTk1JTlDJTIwJUVDJTlFJTg0JUVDJTlEJTk4JUVDJTlEJTk4JTIwJUVDJTlFJTg1JUVCJUEwJUE1JUVDJTlEJTg0JTIwJUVDJTgzJTlEJUVDJTg0JUIxJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQWJhdGNoX3NpemUlMjAlM0QlMjAxNiUwQWlucHV0X3ZlY3Rvcl9kaW0lMjAlM0QlMjAxMCUwQXJhbmRvbV9pbnB1dHMlMjAlM0QlMjB0Zi5yYW5kb20ubm9ybWFsKChiYXRjaF9zaXplJTJDJTIwaW5wdXRfdmVjdG9yX2RpbSkpJTBBJTBBJTIzJTIwJUVDJTg4JTlDJUVDJUEwJTg0JUVEJThDJThDJUVCJUE1JUJDJTIwJUVDJThCJUE0JUVEJTk2JTg5JUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQV8lMjAlM0QlMjBtb2RlbChyYW5kb21faW5wdXRzKQ==",highlighted:`<span class="hljs-comment"># 모델에 대한 임의의 입력을 생성합니다.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># 순전파를 실행합니다.</span>
_ = model(random_inputs)`,wrap:!1}}),X=new f({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`,wrap:!1}}),I=new f({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),Q=new el({props:{title:"🤗 Transformers에서 XLA를 사용하여 TF 텍스트 생성 모델 실행하기",local:"running-a-tf-text-generation-model-with-xla-from-transformers",headingTag:"h2"}}),F=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade",wrap:!1}}),$=new f({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjAlRUMlQjUlOUMlRUMlODYlOEMlMjAlRUIlQjIlODQlRUMlQTAlODQlRUMlOUQlOTglMjBUcmFuc2Zvcm1lcnMlRUElQjAlODAlMjAlRUMlODQlQTQlRUMlQjklOTglRUIlOTAlOTglRUMlOTYlQjQlMjAlRUMlOUUlODglRUMlQTclODAlMjAlRUMlOTUlOEElRUIlOEIlQTQlRUIlQTklQjQlMjAlRUMlOTglQTQlRUIlQTUlOTglRUElQjAlODAlMjAlRUIlQjAlOUMlRUMlODMlOUQlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGNoZWNrX21pbl92ZXJzaW9uJTBBJTBBY2hlY2tfbWluX3ZlcnNpb24oJTIyNC4yMS4wJTIyKSUwQSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiUyQyUyMHBhZF90b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFpbnB1dF9zdHJpbmclMjAlM0QlMjAlNUIlMjJUZW5zb3JGbG93JTIwaXMlMjIlNUQlMEElMEElMjMlMjBYTEElMjAlRUMlODMlOUQlRUMlODQlQjElMjAlRUQlOTUlQTglRUMlODglOTglRUIlQTUlQkMlMjAlRUIlQTclOEMlRUIlOTMlQTQlRUElQjglQjAlMjAlRUMlOUMlODQlRUQlOTUlOUMlMjAlRUQlOTUlOUMlMjAlRUMlQTQlODQlMEF4bGFfZ2VuZXJhdGUlMjAlM0QlMjB0Zi5mdW5jdGlvbihtb2RlbC5nZW5lcmF0ZSUyQyUyMGppdF9jb21waWxlJTNEVHJ1ZSklMEElMEF0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEElMEFkZWNvZGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZiUyMkdlbmVyYXRlZCUyMC0tJTIwJTdCZGVjb2RlZF90ZXh0JTdEJTIyKSUwQSUyMyUyMEdlbmVyYXRlZCUyMC0tJTIwVGVuc29yRmxvdyUyMGlzJTIwYW4lMjBvcGVuLXNvdXJjZSUyQyUyMG9wZW4tc291cmNlJTJDJTIwZGlzdHJpYnV0ZWQtc291cmNlJTIwYXBwbGljYXRpb24lMjAlMjMlMjBmcmFtZXdvcmslMjBmb3IlMjB0aGU=",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># 최소 버전의 Transformers가 설치되어 있지 않다면 오류가 발생합니다.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># XLA 생성 함수를 만들기 위한 한 줄</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`,wrap:!1}}),x=new el({props:{title:"주의할 점",local:"gotchas-to-be-aware-of",headingTag:"h2"}}),z=new f({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBaW5wdXRfc3RyaW5nJTIwJTNEJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTVEJTBBJTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBJTIzJTIwJUVDJTk3JUFDJUVBJUI4JUIwJUVDJTg0JTlDJTJDJTIwcGFkZGluZyUyMCVFQyU5OCVCNSVFQyU4NSU5OCVFQyU5RCVCNCUyMCVFQyU5RSU4OCVFQiU4QSU5NCUyMCVFRCU4NiVBMCVFRCU4MSVBQyVFQiU4MiU5OCVFQyU5RCVCNCVFQyVBMCU4MCVFQiVBNSVCQyUyMCVFRCU5OCVCOCVFQyVCNiU5QyVFRCU5NSVBOSVFQiU4QiU4OCVFQiU4QiVBNC4lMEF0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEFkZWNvZGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZiUyMkdlbmVyYXRlZCUyMC0tJTIwJTdCZGVjb2RlZF90ZXh0JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># 여기서, padding 옵션이 있는 토크나이저를 호출합니다.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),N=new f({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQWZvciUyMGlucHV0X3N0cmluZyUyMGluJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTJDJTIwJTIyVGVuc29yRmxvdyUyMGlzJTIwYSUyMiUyQyUyMCUyMlRGTGl0ZSUyMGlzJTIwYSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9zdHJpbmclMkMlMjBwYWRfdG9fbXVsdGlwbGVfb2YlM0Q4JTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUyMCUyMCUyMCUyMHN0YXJ0JTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEElMjAlMjAlMjAlMjBlbmQlMjAlM0QlMjB0aW1lLnRpbWVfbnMoKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJFeGVjdXRpb24lMjB0aW1lJTIwLS0lMjAlN0IoZW5kJTIwLSUyMHN0YXJ0KSUyMCUyRiUyMDFlNiUzQS4xZiU3RCUyMG1zJTVDbiUyMik=",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`,wrap:!1}}),Y=new f({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`,wrap:!1}}),S=new el({props:{title:"추가 자료",local:"additional-resources",headingTag:"h2"}}),{c(){u=o("meta"),tl=n(),K=o("p"),sl=n(),i(d.$$.fragment),nl=n(),i(U.$$.fragment),al=n(),w=o("p"),w.innerHTML=Al,ol=n(),y=o("p"),y.textContent=zl,pl=n(),b=o("p"),b.innerHTML=Ll,rl=n(),h=o("p"),h.innerHTML=Nl,il=n(),g=o("p"),g.textContent=Hl,ml=n(),i(j.$$.fragment),Tl=n(),R=o("p"),R.textContent=Yl,Ml=n(),i(V.$$.fragment),Jl=n(),k=o("p"),k.innerHTML=Dl,cl=n(),i(_.$$.fragment),ul=n(),C=o("p"),C.textContent=ql,fl=n(),i(X.$$.fragment),dl=n(),Z=o("p"),Z.innerHTML=Sl,Ul=n(),i(I.$$.fragment),wl=n(),i(Q.$$.fragment),yl=n(),G=o("p"),G.innerHTML=Ol,bl=n(),i(F.$$.fragment),hl=n(),W=o("p"),W.textContent=Pl,gl=n(),i($.$$.fragment),jl=n(),v=o("p"),v.innerHTML=Kl,Rl=n(),i(x.$$.fragment),Vl=n(),E=o("p"),E.innerHTML=le,kl=n(),B=o("p"),B.innerHTML=ee,_l=n(),A=o("p"),A.innerHTML=te,Cl=n(),i(z.$$.fragment),Xl=n(),L=o("p"),L.innerHTML=se,Zl=n(),i(N.$$.fragment),Il=n(),H=o("p"),H.textContent=ne,Ql=n(),i(Y.$$.fragment),Gl=n(),D=o("p"),D.innerHTML=ae,Fl=n(),q=o("p"),q.textContent=oe,Wl=n(),i(S.$$.fragment),$l=n(),O=o("p"),O.textContent=pe,vl=n(),P=o("ul"),P.innerHTML=re,xl=n(),ll=o("p"),this.h()},l(l){const e=fe("svelte-u9bgzb",document.head);u=p(e,"META",{name:!0,content:!0}),e.forEach(t),tl=a(l),K=p(l,"P",{}),ie(K).forEach(t),sl=a(l),m(d.$$.fragment,l),nl=a(l),m(U.$$.fragment,l),al=a(l),w=p(l,"P",{"data-svelte-h":!0}),r(w)!=="svelte-vhpug6"&&(w.innerHTML=Al),ol=a(l),y=p(l,"P",{"data-svelte-h":!0}),r(y)!=="svelte-mb1ukg"&&(y.textContent=zl),pl=a(l),b=p(l,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1f4n09x"&&(b.innerHTML=Ll),rl=a(l),h=p(l,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1v6brk3"&&(h.innerHTML=Nl),il=a(l),g=p(l,"P",{"data-svelte-h":!0}),r(g)!=="svelte-148xdun"&&(g.textContent=Hl),ml=a(l),m(j.$$.fragment,l),Tl=a(l),R=p(l,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1njozb7"&&(R.textContent=Yl),Ml=a(l),m(V.$$.fragment,l),Jl=a(l),k=p(l,"P",{"data-svelte-h":!0}),r(k)!=="svelte-7f6oar"&&(k.innerHTML=Dl),cl=a(l),m(_.$$.fragment,l),ul=a(l),C=p(l,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1pc9n8q"&&(C.textContent=ql),fl=a(l),m(X.$$.fragment,l),dl=a(l),Z=p(l,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-epruek"&&(Z.innerHTML=Sl),Ul=a(l),m(I.$$.fragment,l),wl=a(l),m(Q.$$.fragment,l),yl=a(l),G=p(l,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1dwvoc4"&&(G.innerHTML=Ol),bl=a(l),m(F.$$.fragment,l),hl=a(l),W=p(l,"P",{"data-svelte-h":!0}),r(W)!=="svelte-183puqa"&&(W.textContent=Pl),gl=a(l),m($.$$.fragment,l),jl=a(l),v=p(l,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ssbrjd"&&(v.innerHTML=Kl),Rl=a(l),m(x.$$.fragment,l),Vl=a(l),E=p(l,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1n4in8p"&&(E.innerHTML=le),kl=a(l),B=p(l,"P",{"data-svelte-h":!0}),r(B)!=="svelte-h9m36e"&&(B.innerHTML=ee),_l=a(l),A=p(l,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1s012xi"&&(A.innerHTML=te),Cl=a(l),m(z.$$.fragment,l),Xl=a(l),L=p(l,"P",{"data-svelte-h":!0}),r(L)!=="svelte-f28hgm"&&(L.innerHTML=se),Zl=a(l),m(N.$$.fragment,l),Il=a(l),H=p(l,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1slt67r"&&(H.textContent=ne),Ql=a(l),m(Y.$$.fragment,l),Gl=a(l),D=p(l,"P",{"data-svelte-h":!0}),r(D)!=="svelte-15kvfy2"&&(D.innerHTML=ae),Fl=a(l),q=p(l,"P",{"data-svelte-h":!0}),r(q)!=="svelte-18p6eo2"&&(q.textContent=oe),Wl=a(l),m(S.$$.fragment,l),$l=a(l),O=p(l,"P",{"data-svelte-h":!0}),r(O)!=="svelte-36wvdw"&&(O.textContent=pe),vl=a(l),P=p(l,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-wv6sfd"&&(P.innerHTML=re),xl=a(l),ll=p(l,"P",{}),ie(ll).forEach(t),this.h()},h(){me(u,"name","hf:doc:metadata"),me(u,"content",ye)},m(l,e){de(document.head,u),s(l,tl,e),s(l,K,e),s(l,sl,e),T(d,l,e),s(l,nl,e),T(U,l,e),s(l,al,e),s(l,w,e),s(l,ol,e),s(l,y,e),s(l,pl,e),s(l,b,e),s(l,rl,e),s(l,h,e),s(l,il,e),s(l,g,e),s(l,ml,e),T(j,l,e),s(l,Tl,e),s(l,R,e),s(l,Ml,e),T(V,l,e),s(l,Jl,e),s(l,k,e),s(l,cl,e),T(_,l,e),s(l,ul,e),s(l,C,e),s(l,fl,e),T(X,l,e),s(l,dl,e),s(l,Z,e),s(l,Ul,e),T(I,l,e),s(l,wl,e),T(Q,l,e),s(l,yl,e),s(l,G,e),s(l,bl,e),T(F,l,e),s(l,hl,e),s(l,W,e),s(l,gl,e),T($,l,e),s(l,jl,e),s(l,v,e),s(l,Rl,e),T(x,l,e),s(l,Vl,e),s(l,E,e),s(l,kl,e),s(l,B,e),s(l,_l,e),s(l,A,e),s(l,Cl,e),T(z,l,e),s(l,Xl,e),s(l,L,e),s(l,Zl,e),T(N,l,e),s(l,Il,e),s(l,H,e),s(l,Ql,e),T(Y,l,e),s(l,Gl,e),s(l,D,e),s(l,Fl,e),s(l,q,e),s(l,Wl,e),T(S,l,e),s(l,$l,e),s(l,O,e),s(l,vl,e),s(l,P,e),s(l,xl,e),s(l,ll,e),El=!0},p:Me,i(l){El||(M(d.$$.fragment,l),M(U.$$.fragment,l),M(j.$$.fragment,l),M(V.$$.fragment,l),M(_.$$.fragment,l),M(X.$$.fragment,l),M(I.$$.fragment,l),M(Q.$$.fragment,l),M(F.$$.fragment,l),M($.$$.fragment,l),M(x.$$.fragment,l),M(z.$$.fragment,l),M(N.$$.fragment,l),M(Y.$$.fragment,l),M(S.$$.fragment,l),El=!0)},o(l){J(d.$$.fragment,l),J(U.$$.fragment,l),J(j.$$.fragment,l),J(V.$$.fragment,l),J(_.$$.fragment,l),J(X.$$.fragment,l),J(I.$$.fragment,l),J(Q.$$.fragment,l),J(F.$$.fragment,l),J($.$$.fragment,l),J(x.$$.fragment,l),J(z.$$.fragment,l),J(N.$$.fragment,l),J(Y.$$.fragment,l),J(S.$$.fragment,l),El=!1},d(l){l&&(t(tl),t(K),t(sl),t(nl),t(al),t(w),t(ol),t(y),t(pl),t(b),t(rl),t(h),t(il),t(g),t(ml),t(Tl),t(R),t(Ml),t(Jl),t(k),t(cl),t(ul),t(C),t(fl),t(dl),t(Z),t(Ul),t(wl),t(yl),t(G),t(bl),t(hl),t(W),t(gl),t(jl),t(v),t(Rl),t(Vl),t(E),t(kl),t(B),t(_l),t(A),t(Cl),t(Xl),t(L),t(Zl),t(Il),t(H),t(Ql),t(Gl),t(D),t(Fl),t(q),t(Wl),t($l),t(O),t(vl),t(P),t(xl),t(ll)),t(u),c(d,l),c(U,l),c(j,l),c(V,l),c(_,l),c(X,l),c(I,l),c(Q,l),c(F,l),c($,l),c(x,l),c(z,l),c(N,l),c(Y,l),c(S,l)}}}const ye='{"title":"TensorFlow 모델을 위한 XLA 통합","local":"xla-integration-for-tensorflow-models","sections":[{"title":"XLA를 사용하여 TF 함수 실행하기","local":"running-tf-functions-with-xla","sections":[],"depth":2},{"title":"🤗 Transformers에서 XLA를 사용하여 TF 텍스트 생성 모델 실행하기","local":"running-a-tf-text-generation-model-with-xla-from-transformers","sections":[],"depth":2},{"title":"주의할 점","local":"gotchas-to-be-aware-of","sections":[],"depth":2},{"title":"추가 자료","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function be(Bl){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ke extends ce{constructor(u){super(),ue(this,u,be,we,Te,{})}}export{ke as component};
