import{s as zs,n as Ws,o as Vs}from"../chunks/scheduler.0219f8bd.js";import{S as Ys,i as Gs,g as s,s as o,r as p,A as Qs,h as r,f as l,c as d,j as a,u as c,x as n,k as u,y as Xs,a as i,v as f,d as h,t as m,w as b}from"../chunks/index.f61edf3b.js";import{H as _,E as Zs}from"../chunks/index.ef6fbf3e.js";function er(Cd){let $,zt,St,Wt,g,Vt,T,Yt,v,Md='Utility functions to interact with the Hugging Face Hub (<a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>)',Gt,P,xd='<li><a href="#module_utils/hub">utils/hub</a><ul><li><em>static</em><ul><li><a href="#module_utils/hub.getFile"><code>.getFile(urlOrPath)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response)&gt;</code></li> <li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path])</code></a> ⇒ <code>Promise.&lt;(string|Uint8Array)&gt;</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li> <li><a href="#module_utils/hub.getModelJSON"><code>.getModelJSON(modelPath, fileName, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response, [progress_callback])</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li> <li><a href="#module_utils/hub..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..isValidUrl"><code>~isValidUrl(string, [protocols], [validHosts])</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..handleError"><code>~handleError(status, remoteURL, fatal)</code></a> ⇒ <code>null</code></li> <li><a href="#module_utils/hub..tryCache"><code>~tryCache(cache, ...names)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code></li> <li><a href="#module_utils/hub..readResponse"><code>~readResponse(response, progress_callback)</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code></li> <li><a href="#module_utils/hub..pathJoin"><code>~pathJoin(...parts)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/hub..ExternalData"><code>~ExternalData</code></a> : <code>boolean</code> | <code>number</code></li> <li><a href="#module_utils/hub..PretrainedOptions"><code>~PretrainedOptions</code></a> : <code>Object</code></li> <li><a href="#module_utils/hub..ModelSpecificPretrainedOptions"><code>~ModelSpecificPretrainedOptions</code></a> : <code>Object</code></li> <li><a href="#module_utils/hub..PretrainedModelOptions"><code>~PretrainedModelOptions</code></a> : <code>*</code></li></ul></li></ul></li>',Qt,Xt,Zt,y,el,R,tl,C,Hd="Helper function to get a file, using either the Fetch API or FileSystem API.",ll,M,Ld='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response)&gt;</code> - A promise that resolves to a FileResponse object (if the file is retrieved using the FileSystem API), or a Response object (if the file is retrieved using the Fetch API).',il,x,Fd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urlOrPath</td><td><code>URL</code> | <code>string</code></td><td><p>The URL/path of the file to get.</p></td></tr></tbody>",ol,dl,sl,H,rl,L,nl,F,wd=`Retrieves a file from either a remote URL using the Fetch API or from the local file system using the FileSystem API.
If the filesystem is available and <code>env.useCache = true</code>, the file will be downloaded and cached.`,ul,w,Ad='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(string|Uint8Array)&gt;</code> - A Promise that resolves with the file content as a Uint8Array if <code>return_path</code> is false, or the file path as a string if <code>return_path</code> is true.<br/> <strong>Throws</strong>:',al,A,Ed="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",pl,E,jd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>path_or_repo_id</td><td><code>string</code></td><td></td><td><p>This can be either:</p> <ul><li>a string, the <em>model id</em> of a model repo on huggingface.co.</li> <li>a path to a <em>directory</em> potentially containing the file.</li></ul></td> </tr><tr><td>filename</td><td><code>string</code></td><td></td><td><p>The name of the file to locate in <code>path_or_repo</code>.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td> </tr><tr><td>[return_path]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the path of the file instead of the file content.</p></td></tr></tbody>",cl,j,Od='<li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path])</code></a> ⇒ <code>Promise.&lt;(string|Uint8Array)&gt;</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li>',fl,hl,ml,O,bl,U,_l,B,Ud='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',$l,gl,Tl,K,vl,k,Pl,q,Bd='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',yl,Rl,Cl,I,Ml,N,xl,D,Kd='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',Hl,Ll,Fl,S,wl,J,Al,z,kd="Fetches a JSON file from a given path and file name.",El,W,qd='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - The JSON data parsed into a JavaScript object.<br/> <strong>Throws</strong>:',jl,V,Id="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",Ol,Y,Nd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>modelPath</td><td><code>string</code></td><td></td><td><p>The path to the directory containing the file.</p></td> </tr><tr><td>fileName</td><td><code>string</code></td><td></td><td><p>The name of the file to fetch.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",Ul,Bl,Kl,G,kl,Q,ql,X,Dd='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Il,Z,Sd='<li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',Nl,Dl,Sl,ee,Jl,te,zl,le,Jd="Creates a new <code>FileResponse</code> object.",Wl,ie,zd="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>filePath</td><td><code>string</code></td></tr></tbody>",Vl,Yl,Gl,oe,Ql,de,Xl,se,Wd=`Updates the ‘content-type’ header property of the response based on the extension of
the file specified by the filePath property of the current object.`,Zl,re,Vd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',ei,ti,li,ne,ii,ue,oi,ae,Yd="Clone the current FileResponse object.",di,pe,Gd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>FileResponse</code> - A new FileResponse object with the same properties as the current object.',si,ri,ni,ce,ui,fe,ai,he,Qd=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with an ArrayBuffer containing the file’s contents.`,pi,me,Xd='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ArrayBuffer&gt;</code> - A Promise that resolves with an ArrayBuffer containing the file’s contents.<br/> <strong>Throws</strong>:',ci,be,Zd="<li><code>Error</code> If the file cannot be read.</li>",fi,hi,mi,_e,bi,$e,_i,ge,es=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a Blob containing the file’s contents.`,$i,Te,ts='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Blob&gt;</code> - A Promise that resolves with a Blob containing the file’s contents.<br/> <strong>Throws</strong>:',gi,ve,ls="<li><code>Error</code> If the file cannot be read.</li>",Ti,vi,Pi,Pe,yi,ye,Ri,Re,is=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a string containing the file’s contents.`,Ci,Ce,os='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;string&gt;</code> - A Promise that resolves with a string containing the file’s contents.<br/> <strong>Throws</strong>:',Mi,Me,ds="<li><code>Error</code> If the file cannot be read.</li>",xi,Hi,Li,xe,Fi,He,wi,Le,ss=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a parsed JavaScript object containing the file’s contents.`,Ai,Fe,rs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves with a parsed JavaScript object containing the file’s contents.<br/> <strong>Throws</strong>:',Ei,we,ns="<li><code>Error</code> If the file cannot be read.</li>",ji,Oi,Ui,Ae,Bi,Ee,Ki,je,us='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',ki,Oe,as='<li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response, [progress_callback])</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li>',qi,Ii,Ni,Ue,Di,Be,Si,Ke,ps="Instantiate a <code>FileCache</code> object.",Ji,ke,cs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td></tr></tbody>",zi,Wi,Vi,qe,Yi,Ie,Gi,Ne,fs="Checks whether the given request is in the cache.",Qi,De,hs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',Xi,Se,ms="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td></tr></tbody>",Zi,eo,to,Je,lo,ze,io,We,bs="Adds the given response to the cache.",oo,Ve,_s='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',so,Ye,$s=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td><td></td> </tr><tr><td>response</td><td><code>Response</code></td><td></td> </tr><tr><td>[progress_callback]</td><td><code>*</code></td><td><p>Optional.
The function to call with progress updates</p></td></tr></tbody>`,ro,no,uo,Ge,ao,Qe,po,Xe,gs="Mapping from file extensions to MIME types.",co,Ze,Ts='<strong>Kind</strong>: inner constant of <a href="#module_utils/hub"><code>utils/hub</code></a>',fo,ho,mo,et,bo,tt,_o,lt,vs="Determines whether the given string is a valid URL.",$o,it,Ps='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid URL, false otherwise.',go,ot,ys="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code> | <code>URL</code></td><td></td><td><p>The string to test for validity as an URL.</p></td> </tr><tr><td>[protocols]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid protocols. If specified, the protocol must be in this list.</p></td> </tr><tr><td>[validHosts]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid hostnames. If specified, the URL&#39;s hostname must be in this list.</p></td></tr></tbody>",To,vo,Po,dt,yo,st,Ro,rt,Rs="Helper method to handle fatal errors that occur while trying to load a file from the Hugging Face Hub.",Co,nt,Cs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>null</code> - Returns <code>null</code> if <code>fatal = true</code>.<br/> <strong>Throws</strong>:',Mo,ut,Ms="<li><code>Error</code> If `fatal = false`.</li>",xo,at,xs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>status</td><td><code>number</code></td><td><p>The HTTP status code of the error.</p></td> </tr><tr><td>remoteURL</td><td><code>string</code></td><td><p>The URL of the file that could not be loaded.</p></td> </tr><tr><td>fatal</td><td><code>boolean</code></td><td><p>Whether to raise an error if the file could not be loaded.</p></td></tr></tbody>",Ho,Lo,Fo,pt,wo,ct,Ao,ft,Hs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code> - The item from the cache, or undefined if not found.',Eo,ht,Ls="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>cache</td><td><code>FileCache</code> | <code>Cache</code></td><td><p>The cache to search</p></td> </tr><tr><td>...names</td><td><code>Array.&lt;string&gt;</code></td><td><p>The names of the item to search for</p></td></tr></tbody>",jo,Oo,Uo,mt,Bo,bt,Ko,_t,Fs="Read and track progress when reading a Response object",ko,$t,ws='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the Uint8Array buffer',qo,gt,As="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>response</td><td><code>Response</code> | <code>FileResponse</code></td><td><p>The Response object to read</p></td> </tr><tr><td>progress_callback</td><td><code>*</code></td><td><p>The function to call with progress updates</p></td></tr></tbody>",Io,No,Do,Tt,So,vt,Jo,Pt,Es="Joins multiple parts of a path into a single path, while handling leading and trailing slashes.",zo,yt,js='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>string</code> - A string representing the joined path.',Wo,Rt,Os="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...parts</td><td><code>string</code></td><td><p>Multiple parts of a path.</p></td></tr></tbody>",Vo,Yo,Go,Ct,Qo,Mt,Xo,xt,Us=`Whether to load the model using the external data format (used for models &gt;= 2GB in size).
If <code>true</code>, the model will be loaded using the external data format.
If a number, this many chunks will be loaded using the external data format (of the form: “model.onnx<em>data[</em>{chunk_number}]”).`,Zo,Ht,Bs='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a>',ed,td,ld,Lt,id,Ft,od,wt,Ks="Options for loading a pretrained model.",dd,At,ks='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',sd,Et,qs=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[progress_callback]</td><td><code>*</code></td><td><code></code></td><td><p>If specified, this function will be called during model construction, to provide the user with progress updates.</p></td> </tr><tr><td>[config]</td><td><code>*</code></td><td><code></code></td><td><p>Configuration for the model to use instead of an automatically loaded configuration. Configuration can be automatically loaded when:</p> <ul><li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained model).</li> <li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a configuration JSON file named <em>config.json</em> is found in the directory.</li></ul></td> </tr><tr><td>[cache_dir]</td><td><code>string</code></td><td><code>null</code></td><td><p>Path to a directory in which a downloaded pretrained model configuration should be cached if the standard cache should not be used.</p></td> </tr><tr><td>[local_files_only]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to only look at local files (e.g., not try downloading the model).</p></td> </tr><tr><td>[revision]</td><td><code>string</code></td><td><code>&quot;&#39;main&#39;&quot;</code></td><td><p>The specific model version to use. It can be a branch name, a tag name, or a commit id,
since we use a git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier allowed by git.
NOTE: This setting is ignored for local requests.</p></td></tr></tbody>`,rd,nd,ud,jt,ad,Ot,pd,Ut,Is="Options for loading a pretrained model.",cd,Bt,Ns='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',fd,Kt,Ds=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[subfolder]</td><td><code>string</code></td><td><code>&quot;&#39;onnx&#39;&quot;</code></td><td><p>In case the relevant files are located inside a subfolder of the model repo on huggingface.co,
you can specify the folder name here.</p></td> </tr><tr><td>[model_file_name]</td><td><code>string</code></td><td><code>null</code></td><td><p>If specified, load the model with this name (excluding the .onnx suffix). Currently only valid for encoder- or decoder-only models.</p></td> </tr><tr><td>[device]</td><td><code>*</code></td><td><code></code></td><td><p>The device to run the model on. If not specified, the device will be chosen from the environment settings.</p></td> </tr><tr><td>[dtype]</td><td><code>*</code></td><td><code></code></td><td><p>The data type to use for the model. If not specified, the data type will be chosen from the environment settings.</p></td> </tr><tr><td>[use_external_data_format]</td><td><code>ExternalData</code> | <code>Record&lt;string, ExternalData&gt;</code></td><td><code>false</code></td><td><p>Whether to load the model using the external data format (used for models &gt;= 2GB in size).</p></td> </tr><tr><td>[session_options]</td><td><code>*</code></td><td></td><td><p>(Optional) User-specified session options passed to the runtime. If not provided, suitable defaults will be chosen.</p></td></tr></tbody>`,hd,md,bd,kt,_d,qt,$d,It,Ss="Options for loading a pretrained model.",gd,Nt,Js='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a>',Td,vd,Pd,Dt,yd,Jt,Rd;return T=new _({props:{title:"utils/hub",local:"utilshub",headingTag:"h1"}}),R=new _({props:{title:"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>",local:"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code",headingTag:"h2"}}),L=new _({props:{title:"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path]) ⇒ <code> Promise. < (string|Uint8Array) > </code>",local:"utilshubgetmodelfilepathorrepoid-filename-fatal-options-returnpath--code-promise--stringuint8array--code",headingTag:"h2"}}),U=new _({props:{title:"getModelFile~cacheKey : <code> string </code>",local:"getmodelfilecachekey--code-string-code",headingTag:"h3"}}),k=new _({props:{title:"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>",local:"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code",headingTag:"h3"}}),N=new _({props:{title:"getModelFile~buffer : <code> Uint8Array </code>",local:"getmodelfilebuffer--code-uint8array-code",headingTag:"h3"}}),J=new _({props:{title:"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>",local:"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code",headingTag:"h2"}}),Q=new _({props:{title:"utils/hub~FileResponse",local:"utilshubfileresponse",headingTag:"h2"}}),te=new _({props:{title:"new FileResponse(filePath)",local:"new-fileresponsefilepath",headingTag:"h3"}}),de=new _({props:{title:"fileResponse.updateContentType() ⇒ <code> void </code>",local:"fileresponseupdatecontenttype--code-void-code",headingTag:"h3"}}),ue=new _({props:{title:"fileResponse.clone() ⇒ <code> FileResponse </code>",local:"fileresponseclone--code-fileresponse-code",headingTag:"h3"}}),fe=new _({props:{title:"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>",local:"fileresponsearraybuffer--code-promise--arraybuffer--code",headingTag:"h3"}}),$e=new _({props:{title:"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>",local:"fileresponseblob--code-promise--blob--code",headingTag:"h3"}}),ye=new _({props:{title:"fileResponse.text() ⇒ <code> Promise. < string > </code>",local:"fileresponsetext--code-promise--string--code",headingTag:"h3"}}),He=new _({props:{title:"fileResponse.json() ⇒ <code> Promise. < Object > </code>",local:"fileresponsejson--code-promise--object--code",headingTag:"h3"}}),Ee=new _({props:{title:"utils/hub~FileCache",local:"utilshubfilecache",headingTag:"h2"}}),Be=new _({props:{title:"new FileCache(path)",local:"new-filecachepath",headingTag:"h3"}}),Ie=new _({props:{title:"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>",local:"filecachematchrequest--code-promise--fileresponseundefined--code",headingTag:"h3"}}),ze=new _({props:{title:"fileCache.put(request, response, [progress_callback]) ⇒ <code> Promise. < void > </code>",local:"filecacheputrequest-response-progresscallback--code-promise--void--code",headingTag:"h3"}}),Qe=new _({props:{title:"utils/hub~CONTENT_TYPE_MAP",local:"utilshubcontenttypemap",headingTag:"h2"}}),tt=new _({props:{title:"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>",local:"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code",headingTag:"h2"}}),st=new _({props:{title:"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>",local:"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code",headingTag:"h2"}}),ct=new _({props:{title:"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>",local:"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code",headingTag:"h2"}}),bt=new _({props:{title:"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code",headingTag:"h2"}}),vt=new _({props:{title:"utils/hub~pathJoin(...parts) ⇒ <code> string </code>",local:"utilshubpathjoinparts--code-string-code",headingTag:"h2"}}),Mt=new _({props:{title:"utils/hub~ExternalData : <code> boolean </code> | <code> number </code>",local:"utilshubexternaldata--code-boolean-code--code-number-code",headingTag:"h2"}}),Ft=new _({props:{title:"utils/hub~PretrainedOptions : <code> Object </code>",local:"utilshubpretrainedoptions--code-object-code",headingTag:"h2"}}),Ot=new _({props:{title:"utils/hub~ModelSpecificPretrainedOptions : <code> Object </code>",local:"utilshubmodelspecificpretrainedoptions--code-object-code",headingTag:"h2"}}),qt=new _({props:{title:"utils/hub~PretrainedModelOptions : <code> * </code>",local:"utilshubpretrainedmodeloptions--code--code",headingTag:"h2"}}),Dt=new Zs({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/hub.md"}}),{c(){$=s("meta"),zt=o(),St=s("p"),Wt=o(),g=s("a"),Vt=o(),p(T.$$.fragment),Yt=o(),v=s("p"),v.innerHTML=Md,Gt=o(),P=s("ul"),P.innerHTML=xd,Qt=o(),Xt=s("hr"),Zt=o(),y=s("a"),el=o(),p(R.$$.fragment),tl=o(),C=s("p"),C.textContent=Hd,ll=o(),M=s("p"),M.innerHTML=Ld,il=o(),x=s("table"),x.innerHTML=Fd,ol=o(),dl=s("hr"),sl=o(),H=s("a"),rl=o(),p(L.$$.fragment),nl=o(),F=s("p"),F.innerHTML=wd,ul=o(),w=s("p"),w.innerHTML=Ad,al=o(),A=s("ul"),A.innerHTML=Ed,pl=o(),E=s("table"),E.innerHTML=jd,cl=o(),j=s("ul"),j.innerHTML=Od,fl=o(),hl=s("hr"),ml=o(),O=s("a"),bl=o(),p(U.$$.fragment),_l=o(),B=s("p"),B.innerHTML=Ud,$l=o(),gl=s("hr"),Tl=o(),K=s("a"),vl=o(),p(k.$$.fragment),Pl=o(),q=s("p"),q.innerHTML=Bd,yl=o(),Rl=s("hr"),Cl=o(),I=s("a"),Ml=o(),p(N.$$.fragment),xl=o(),D=s("p"),D.innerHTML=Kd,Hl=o(),Ll=s("hr"),Fl=o(),S=s("a"),wl=o(),p(J.$$.fragment),Al=o(),z=s("p"),z.textContent=kd,El=o(),W=s("p"),W.innerHTML=qd,jl=o(),V=s("ul"),V.innerHTML=Id,Ol=o(),Y=s("table"),Y.innerHTML=Nd,Ul=o(),Bl=s("hr"),Kl=o(),G=s("a"),kl=o(),p(Q.$$.fragment),ql=o(),X=s("p"),X.innerHTML=Dd,Il=o(),Z=s("ul"),Z.innerHTML=Sd,Nl=o(),Dl=s("hr"),Sl=o(),ee=s("a"),Jl=o(),p(te.$$.fragment),zl=o(),le=s("p"),le.innerHTML=Jd,Wl=o(),ie=s("table"),ie.innerHTML=zd,Vl=o(),Yl=s("hr"),Gl=o(),oe=s("a"),Ql=o(),p(de.$$.fragment),Xl=o(),se=s("p"),se.textContent=Wd,Zl=o(),re=s("p"),re.innerHTML=Vd,ei=o(),ti=s("hr"),li=o(),ne=s("a"),ii=o(),p(ue.$$.fragment),oi=o(),ae=s("p"),ae.textContent=Yd,di=o(),pe=s("p"),pe.innerHTML=Gd,si=o(),ri=s("hr"),ni=o(),ce=s("a"),ui=o(),p(fe.$$.fragment),ai=o(),he=s("p"),he.textContent=Qd,pi=o(),me=s("p"),me.innerHTML=Xd,ci=o(),be=s("ul"),be.innerHTML=Zd,fi=o(),hi=s("hr"),mi=o(),_e=s("a"),bi=o(),p($e.$$.fragment),_i=o(),ge=s("p"),ge.textContent=es,$i=o(),Te=s("p"),Te.innerHTML=ts,gi=o(),ve=s("ul"),ve.innerHTML=ls,Ti=o(),vi=s("hr"),Pi=o(),Pe=s("a"),yi=o(),p(ye.$$.fragment),Ri=o(),Re=s("p"),Re.textContent=is,Ci=o(),Ce=s("p"),Ce.innerHTML=os,Mi=o(),Me=s("ul"),Me.innerHTML=ds,xi=o(),Hi=s("hr"),Li=o(),xe=s("a"),Fi=o(),p(He.$$.fragment),wi=o(),Le=s("p"),Le.textContent=ss,Ai=o(),Fe=s("p"),Fe.innerHTML=rs,Ei=o(),we=s("ul"),we.innerHTML=ns,ji=o(),Oi=s("hr"),Ui=o(),Ae=s("a"),Bi=o(),p(Ee.$$.fragment),Ki=o(),je=s("p"),je.innerHTML=us,ki=o(),Oe=s("ul"),Oe.innerHTML=as,qi=o(),Ii=s("hr"),Ni=o(),Ue=s("a"),Di=o(),p(Be.$$.fragment),Si=o(),Ke=s("p"),Ke.innerHTML=ps,Ji=o(),ke=s("table"),ke.innerHTML=cs,zi=o(),Wi=s("hr"),Vi=o(),qe=s("a"),Yi=o(),p(Ie.$$.fragment),Gi=o(),Ne=s("p"),Ne.textContent=fs,Qi=o(),De=s("p"),De.innerHTML=hs,Xi=o(),Se=s("table"),Se.innerHTML=ms,Zi=o(),eo=s("hr"),to=o(),Je=s("a"),lo=o(),p(ze.$$.fragment),io=o(),We=s("p"),We.textContent=bs,oo=o(),Ve=s("p"),Ve.innerHTML=_s,so=o(),Ye=s("table"),Ye.innerHTML=$s,ro=o(),no=s("hr"),uo=o(),Ge=s("a"),ao=o(),p(Qe.$$.fragment),po=o(),Xe=s("p"),Xe.textContent=gs,co=o(),Ze=s("p"),Ze.innerHTML=Ts,fo=o(),ho=s("hr"),mo=o(),et=s("a"),bo=o(),p(tt.$$.fragment),_o=o(),lt=s("p"),lt.textContent=vs,$o=o(),it=s("p"),it.innerHTML=Ps,go=o(),ot=s("table"),ot.innerHTML=ys,To=o(),vo=s("hr"),Po=o(),dt=s("a"),yo=o(),p(st.$$.fragment),Ro=o(),rt=s("p"),rt.textContent=Rs,Co=o(),nt=s("p"),nt.innerHTML=Cs,Mo=o(),ut=s("ul"),ut.innerHTML=Ms,xo=o(),at=s("table"),at.innerHTML=xs,Ho=o(),Lo=s("hr"),Fo=o(),pt=s("a"),wo=o(),p(ct.$$.fragment),Ao=o(),ft=s("p"),ft.innerHTML=Hs,Eo=o(),ht=s("table"),ht.innerHTML=Ls,jo=o(),Oo=s("hr"),Uo=o(),mt=s("a"),Bo=o(),p(bt.$$.fragment),Ko=o(),_t=s("p"),_t.textContent=Fs,ko=o(),$t=s("p"),$t.innerHTML=ws,qo=o(),gt=s("table"),gt.innerHTML=As,Io=o(),No=s("hr"),Do=o(),Tt=s("a"),So=o(),p(vt.$$.fragment),Jo=o(),Pt=s("p"),Pt.textContent=Es,zo=o(),yt=s("p"),yt.innerHTML=js,Wo=o(),Rt=s("table"),Rt.innerHTML=Os,Vo=o(),Yo=s("hr"),Go=o(),Ct=s("a"),Qo=o(),p(Mt.$$.fragment),Xo=o(),xt=s("p"),xt.innerHTML=Us,Zo=o(),Ht=s("p"),Ht.innerHTML=Bs,ed=o(),td=s("hr"),ld=o(),Lt=s("a"),id=o(),p(Ft.$$.fragment),od=o(),wt=s("p"),wt.textContent=Ks,dd=o(),At=s("p"),At.innerHTML=ks,sd=o(),Et=s("table"),Et.innerHTML=qs,rd=o(),nd=s("hr"),ud=o(),jt=s("a"),ad=o(),p(Ot.$$.fragment),pd=o(),Ut=s("p"),Ut.textContent=Is,cd=o(),Bt=s("p"),Bt.innerHTML=Ns,fd=o(),Kt=s("table"),Kt.innerHTML=Ds,hd=o(),md=s("hr"),bd=o(),kt=s("a"),_d=o(),p(qt.$$.fragment),$d=o(),It=s("p"),It.textContent=Ss,gd=o(),Nt=s("p"),Nt.innerHTML=Js,Td=o(),vd=s("hr"),Pd=o(),p(Dt.$$.fragment),yd=o(),Jt=s("p"),this.h()},l(e){const t=Qs("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(l),zt=d(e),St=r(e,"P",{}),a(St).forEach(l),Wt=d(e),g=r(e,"A",{id:!0,class:!0}),a(g).forEach(l),Vt=d(e),c(T.$$.fragment,e),Yt=d(e),v=r(e,"P",{"data-svelte-h":!0}),n(v)!=="svelte-1jxl61c"&&(v.innerHTML=Md),Gt=d(e),P=r(e,"UL",{"data-svelte-h":!0}),n(P)!=="svelte-1xtqrra"&&(P.innerHTML=xd),Qt=d(e),Xt=r(e,"HR",{}),Zt=d(e),y=r(e,"A",{id:!0,class:!0}),a(y).forEach(l),el=d(e),c(R.$$.fragment,e),tl=d(e),C=r(e,"P",{"data-svelte-h":!0}),n(C)!=="svelte-10mshiw"&&(C.textContent=Hd),ll=d(e),M=r(e,"P",{"data-svelte-h":!0}),n(M)!=="svelte-1jj7eze"&&(M.innerHTML=Ld),il=d(e),x=r(e,"TABLE",{"data-svelte-h":!0}),n(x)!=="svelte-pbwhgs"&&(x.innerHTML=Fd),ol=d(e),dl=r(e,"HR",{}),sl=d(e),H=r(e,"A",{id:!0,class:!0}),a(H).forEach(l),rl=d(e),c(L.$$.fragment,e),nl=d(e),F=r(e,"P",{"data-svelte-h":!0}),n(F)!=="svelte-1l3bjq3"&&(F.innerHTML=wd),ul=d(e),w=r(e,"P",{"data-svelte-h":!0}),n(w)!=="svelte-1j9rqit"&&(w.innerHTML=Ad),al=d(e),A=r(e,"UL",{"data-svelte-h":!0}),n(A)!=="svelte-jl6z4b"&&(A.innerHTML=Ed),pl=d(e),E=r(e,"TABLE",{"data-svelte-h":!0}),n(E)!=="svelte-bcbvl9"&&(E.innerHTML=jd),cl=d(e),j=r(e,"UL",{"data-svelte-h":!0}),n(j)!=="svelte-1g40dlc"&&(j.innerHTML=Od),fl=d(e),hl=r(e,"HR",{}),ml=d(e),O=r(e,"A",{id:!0,class:!0}),a(O).forEach(l),bl=d(e),c(U.$$.fragment,e),_l=d(e),B=r(e,"P",{"data-svelte-h":!0}),n(B)!=="svelte-1ys3w38"&&(B.innerHTML=Ud),$l=d(e),gl=r(e,"HR",{}),Tl=d(e),K=r(e,"A",{id:!0,class:!0}),a(K).forEach(l),vl=d(e),c(k.$$.fragment,e),Pl=d(e),q=r(e,"P",{"data-svelte-h":!0}),n(q)!=="svelte-1ys3w38"&&(q.innerHTML=Bd),yl=d(e),Rl=r(e,"HR",{}),Cl=d(e),I=r(e,"A",{id:!0,class:!0}),a(I).forEach(l),Ml=d(e),c(N.$$.fragment,e),xl=d(e),D=r(e,"P",{"data-svelte-h":!0}),n(D)!=="svelte-1ys3w38"&&(D.innerHTML=Kd),Hl=d(e),Ll=r(e,"HR",{}),Fl=d(e),S=r(e,"A",{id:!0,class:!0}),a(S).forEach(l),wl=d(e),c(J.$$.fragment,e),Al=d(e),z=r(e,"P",{"data-svelte-h":!0}),n(z)!=="svelte-1en2wh4"&&(z.textContent=kd),El=d(e),W=r(e,"P",{"data-svelte-h":!0}),n(W)!=="svelte-1l5qo0i"&&(W.innerHTML=qd),jl=d(e),V=r(e,"UL",{"data-svelte-h":!0}),n(V)!=="svelte-jl6z4b"&&(V.innerHTML=Id),Ol=d(e),Y=r(e,"TABLE",{"data-svelte-h":!0}),n(Y)!=="svelte-1iel3tk"&&(Y.innerHTML=Nd),Ul=d(e),Bl=r(e,"HR",{}),Kl=d(e),G=r(e,"A",{id:!0,class:!0}),a(G).forEach(l),kl=d(e),c(Q.$$.fragment,e),ql=d(e),X=r(e,"P",{"data-svelte-h":!0}),n(X)!=="svelte-16uuos4"&&(X.innerHTML=Dd),Il=d(e),Z=r(e,"UL",{"data-svelte-h":!0}),n(Z)!=="svelte-olh855"&&(Z.innerHTML=Sd),Nl=d(e),Dl=r(e,"HR",{}),Sl=d(e),ee=r(e,"A",{id:!0,class:!0}),a(ee).forEach(l),Jl=d(e),c(te.$$.fragment,e),zl=d(e),le=r(e,"P",{"data-svelte-h":!0}),n(le)!=="svelte-zzl0lp"&&(le.innerHTML=Jd),Wl=d(e),ie=r(e,"TABLE",{"data-svelte-h":!0}),n(ie)!=="svelte-19a8ff4"&&(ie.innerHTML=zd),Vl=d(e),Yl=r(e,"HR",{}),Gl=d(e),oe=r(e,"A",{id:!0,class:!0}),a(oe).forEach(l),Ql=d(e),c(de.$$.fragment,e),Xl=d(e),se=r(e,"P",{"data-svelte-h":!0}),n(se)!=="svelte-1u1tjx3"&&(se.textContent=Wd),Zl=d(e),re=r(e,"P",{"data-svelte-h":!0}),n(re)!=="svelte-1sowe6d"&&(re.innerHTML=Vd),ei=d(e),ti=r(e,"HR",{}),li=d(e),ne=r(e,"A",{id:!0,class:!0}),a(ne).forEach(l),ii=d(e),c(ue.$$.fragment,e),oi=d(e),ae=r(e,"P",{"data-svelte-h":!0}),n(ae)!=="svelte-d8j2xp"&&(ae.textContent=Yd),di=d(e),pe=r(e,"P",{"data-svelte-h":!0}),n(pe)!=="svelte-8jlahc"&&(pe.innerHTML=Gd),si=d(e),ri=r(e,"HR",{}),ni=d(e),ce=r(e,"A",{id:!0,class:!0}),a(ce).forEach(l),ui=d(e),c(fe.$$.fragment,e),ai=d(e),he=r(e,"P",{"data-svelte-h":!0}),n(he)!=="svelte-1a8fecx"&&(he.textContent=Qd),pi=d(e),me=r(e,"P",{"data-svelte-h":!0}),n(me)!=="svelte-v2f2ae"&&(me.innerHTML=Xd),ci=d(e),be=r(e,"UL",{"data-svelte-h":!0}),n(be)!=="svelte-1f4f3jw"&&(be.innerHTML=Zd),fi=d(e),hi=r(e,"HR",{}),mi=d(e),_e=r(e,"A",{id:!0,class:!0}),a(_e).forEach(l),bi=d(e),c($e.$$.fragment,e),_i=d(e),ge=r(e,"P",{"data-svelte-h":!0}),n(ge)!=="svelte-h3zv97"&&(ge.textContent=es),$i=d(e),Te=r(e,"P",{"data-svelte-h":!0}),n(Te)!=="svelte-1e723py"&&(Te.innerHTML=ts),gi=d(e),ve=r(e,"UL",{"data-svelte-h":!0}),n(ve)!=="svelte-1f4f3jw"&&(ve.innerHTML=ls),Ti=d(e),vi=r(e,"HR",{}),Pi=d(e),Pe=r(e,"A",{id:!0,class:!0}),a(Pe).forEach(l),yi=d(e),c(ye.$$.fragment,e),Ri=d(e),Re=r(e,"P",{"data-svelte-h":!0}),n(Re)!=="svelte-jd4zuh"&&(Re.textContent=is),Ci=d(e),Ce=r(e,"P",{"data-svelte-h":!0}),n(Ce)!=="svelte-1ozy582"&&(Ce.innerHTML=os),Mi=d(e),Me=r(e,"UL",{"data-svelte-h":!0}),n(Me)!=="svelte-1f4f3jw"&&(Me.innerHTML=ds),xi=d(e),Hi=r(e,"HR",{}),Li=d(e),xe=r(e,"A",{id:!0,class:!0}),a(xe).forEach(l),Fi=d(e),c(He.$$.fragment,e),wi=d(e),Le=r(e,"P",{"data-svelte-h":!0}),n(Le)!=="svelte-cd4397"&&(Le.textContent=ss),Ai=d(e),Fe=r(e,"P",{"data-svelte-h":!0}),n(Fe)!=="svelte-j83voe"&&(Fe.innerHTML=rs),Ei=d(e),we=r(e,"UL",{"data-svelte-h":!0}),n(we)!=="svelte-1f4f3jw"&&(we.innerHTML=ns),ji=d(e),Oi=r(e,"HR",{}),Ui=d(e),Ae=r(e,"A",{id:!0,class:!0}),a(Ae).forEach(l),Bi=d(e),c(Ee.$$.fragment,e),Ki=d(e),je=r(e,"P",{"data-svelte-h":!0}),n(je)!=="svelte-16uuos4"&&(je.innerHTML=us),ki=d(e),Oe=r(e,"UL",{"data-svelte-h":!0}),n(Oe)!=="svelte-13rgwxm"&&(Oe.innerHTML=as),qi=d(e),Ii=r(e,"HR",{}),Ni=d(e),Ue=r(e,"A",{id:!0,class:!0}),a(Ue).forEach(l),Di=d(e),c(Be.$$.fragment,e),Si=d(e),Ke=r(e,"P",{"data-svelte-h":!0}),n(Ke)!=="svelte-pake4r"&&(Ke.innerHTML=ps),Ji=d(e),ke=r(e,"TABLE",{"data-svelte-h":!0}),n(ke)!=="svelte-f03x1m"&&(ke.innerHTML=cs),zi=d(e),Wi=r(e,"HR",{}),Vi=d(e),qe=r(e,"A",{id:!0,class:!0}),a(qe).forEach(l),Yi=d(e),c(Ie.$$.fragment,e),Gi=d(e),Ne=r(e,"P",{"data-svelte-h":!0}),n(Ne)!=="svelte-13oc2rp"&&(Ne.textContent=fs),Qi=d(e),De=r(e,"P",{"data-svelte-h":!0}),n(De)!=="svelte-1wxlxpn"&&(De.innerHTML=hs),Xi=d(e),Se=r(e,"TABLE",{"data-svelte-h":!0}),n(Se)!=="svelte-2kmk06"&&(Se.innerHTML=ms),Zi=d(e),eo=r(e,"HR",{}),to=d(e),Je=r(e,"A",{id:!0,class:!0}),a(Je).forEach(l),lo=d(e),c(ze.$$.fragment,e),io=d(e),We=r(e,"P",{"data-svelte-h":!0}),n(We)!=="svelte-bwoz3v"&&(We.textContent=bs),oo=d(e),Ve=r(e,"P",{"data-svelte-h":!0}),n(Ve)!=="svelte-1wxlxpn"&&(Ve.innerHTML=_s),so=d(e),Ye=r(e,"TABLE",{"data-svelte-h":!0}),n(Ye)!=="svelte-14il7x7"&&(Ye.innerHTML=$s),ro=d(e),no=r(e,"HR",{}),uo=d(e),Ge=r(e,"A",{id:!0,class:!0}),a(Ge).forEach(l),ao=d(e),c(Qe.$$.fragment,e),po=d(e),Xe=r(e,"P",{"data-svelte-h":!0}),n(Xe)!=="svelte-15u13r6"&&(Xe.textContent=gs),co=d(e),Ze=r(e,"P",{"data-svelte-h":!0}),n(Ze)!=="svelte-1tftvai"&&(Ze.innerHTML=Ts),fo=d(e),ho=r(e,"HR",{}),mo=d(e),et=r(e,"A",{id:!0,class:!0}),a(et).forEach(l),bo=d(e),c(tt.$$.fragment,e),_o=d(e),lt=r(e,"P",{"data-svelte-h":!0}),n(lt)!=="svelte-fkm19c"&&(lt.textContent=vs),$o=d(e),it=r(e,"P",{"data-svelte-h":!0}),n(it)!=="svelte-xyh2rt"&&(it.innerHTML=Ps),go=d(e),ot=r(e,"TABLE",{"data-svelte-h":!0}),n(ot)!=="svelte-mnoe75"&&(ot.innerHTML=ys),To=d(e),vo=r(e,"HR",{}),Po=d(e),dt=r(e,"A",{id:!0,class:!0}),a(dt).forEach(l),yo=d(e),c(st.$$.fragment,e),Ro=d(e),rt=r(e,"P",{"data-svelte-h":!0}),n(rt)!=="svelte-112gzs0"&&(rt.textContent=Rs),Co=d(e),nt=r(e,"P",{"data-svelte-h":!0}),n(nt)!=="svelte-9i72aw"&&(nt.innerHTML=Cs),Mo=d(e),ut=r(e,"UL",{"data-svelte-h":!0}),n(ut)!=="svelte-w7pu3"&&(ut.innerHTML=Ms),xo=d(e),at=r(e,"TABLE",{"data-svelte-h":!0}),n(at)!=="svelte-bpbhxc"&&(at.innerHTML=xs),Ho=d(e),Lo=r(e,"HR",{}),Fo=d(e),pt=r(e,"A",{id:!0,class:!0}),a(pt).forEach(l),wo=d(e),c(ct.$$.fragment,e),Ao=d(e),ft=r(e,"P",{"data-svelte-h":!0}),n(ft)!=="svelte-1h1o1yf"&&(ft.innerHTML=Hs),Eo=d(e),ht=r(e,"TABLE",{"data-svelte-h":!0}),n(ht)!=="svelte-17sk6uf"&&(ht.innerHTML=Ls),jo=d(e),Oo=r(e,"HR",{}),Uo=d(e),mt=r(e,"A",{id:!0,class:!0}),a(mt).forEach(l),Bo=d(e),c(bt.$$.fragment,e),Ko=d(e),_t=r(e,"P",{"data-svelte-h":!0}),n(_t)!=="svelte-1tqccie"&&(_t.textContent=Fs),ko=d(e),$t=r(e,"P",{"data-svelte-h":!0}),n($t)!=="svelte-dyyw29"&&($t.innerHTML=ws),qo=d(e),gt=r(e,"TABLE",{"data-svelte-h":!0}),n(gt)!=="svelte-9lzswd"&&(gt.innerHTML=As),Io=d(e),No=r(e,"HR",{}),Do=d(e),Tt=r(e,"A",{id:!0,class:!0}),a(Tt).forEach(l),So=d(e),c(vt.$$.fragment,e),Jo=d(e),Pt=r(e,"P",{"data-svelte-h":!0}),n(Pt)!=="svelte-7vbcne"&&(Pt.textContent=Es),zo=d(e),yt=r(e,"P",{"data-svelte-h":!0}),n(yt)!=="svelte-wjfx67"&&(yt.innerHTML=js),Wo=d(e),Rt=r(e,"TABLE",{"data-svelte-h":!0}),n(Rt)!=="svelte-61qi9d"&&(Rt.innerHTML=Os),Vo=d(e),Yo=r(e,"HR",{}),Go=d(e),Ct=r(e,"A",{id:!0,class:!0}),a(Ct).forEach(l),Qo=d(e),c(Mt.$$.fragment,e),Xo=d(e),xt=r(e,"P",{"data-svelte-h":!0}),n(xt)!=="svelte-1l14wsh"&&(xt.innerHTML=Us),Zo=d(e),Ht=r(e,"P",{"data-svelte-h":!0}),n(Ht)!=="svelte-ghvp2p"&&(Ht.innerHTML=Bs),ed=d(e),td=r(e,"HR",{}),ld=d(e),Lt=r(e,"A",{id:!0,class:!0}),a(Lt).forEach(l),id=d(e),c(Ft.$$.fragment,e),od=d(e),wt=r(e,"P",{"data-svelte-h":!0}),n(wt)!=="svelte-1oi15lr"&&(wt.textContent=Ks),dd=d(e),At=r(e,"P",{"data-svelte-h":!0}),n(At)!=="svelte-121rdz"&&(At.innerHTML=ks),sd=d(e),Et=r(e,"TABLE",{"data-svelte-h":!0}),n(Et)!=="svelte-lhkacd"&&(Et.innerHTML=qs),rd=d(e),nd=r(e,"HR",{}),ud=d(e),jt=r(e,"A",{id:!0,class:!0}),a(jt).forEach(l),ad=d(e),c(Ot.$$.fragment,e),pd=d(e),Ut=r(e,"P",{"data-svelte-h":!0}),n(Ut)!=="svelte-1oi15lr"&&(Ut.textContent=Is),cd=d(e),Bt=r(e,"P",{"data-svelte-h":!0}),n(Bt)!=="svelte-121rdz"&&(Bt.innerHTML=Ns),fd=d(e),Kt=r(e,"TABLE",{"data-svelte-h":!0}),n(Kt)!=="svelte-3nlj0u"&&(Kt.innerHTML=Ds),hd=d(e),md=r(e,"HR",{}),bd=d(e),kt=r(e,"A",{id:!0,class:!0}),a(kt).forEach(l),_d=d(e),c(qt.$$.fragment,e),$d=d(e),It=r(e,"P",{"data-svelte-h":!0}),n(It)!=="svelte-1oi15lr"&&(It.textContent=Ss),gd=d(e),Nt=r(e,"P",{"data-svelte-h":!0}),n(Nt)!=="svelte-ghvp2p"&&(Nt.innerHTML=Js),Td=d(e),vd=r(e,"HR",{}),Pd=d(e),c(Dt.$$.fragment,e),yd=d(e),Jt=r(e,"P",{}),a(Jt).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",tr),u(g,"id","module_utils/hub"),u(g,"class","group"),u(y,"id","module_utils/hub.getFile"),u(y,"class","group"),u(H,"id","module_utils/hub.getModelFile"),u(H,"class","group"),u(O,"id","module_utils/hub.getModelFile..cacheKey"),u(O,"class","group"),u(K,"id","module_utils/hub.getModelFile..response"),u(K,"class","group"),u(I,"id","module_utils/hub.getModelFile..buffer"),u(I,"class","group"),u(S,"id","module_utils/hub.getModelJSON"),u(S,"class","group"),u(G,"id","module_utils/hub..FileResponse"),u(G,"class","group"),u(ee,"id","new_module_utils/hub..FileResponse_new"),u(ee,"class","group"),u(oe,"id","module_utils/hub..FileResponse+updateContentType"),u(oe,"class","group"),u(ne,"id","module_utils/hub..FileResponse+clone"),u(ne,"class","group"),u(ce,"id","module_utils/hub..FileResponse+arrayBuffer"),u(ce,"class","group"),u(_e,"id","module_utils/hub..FileResponse+blob"),u(_e,"class","group"),u(Pe,"id","module_utils/hub..FileResponse+text"),u(Pe,"class","group"),u(xe,"id","module_utils/hub..FileResponse+json"),u(xe,"class","group"),u(Ae,"id","module_utils/hub..FileCache"),u(Ae,"class","group"),u(Ue,"id","new_module_utils/hub..FileCache_new"),u(Ue,"class","group"),u(qe,"id","module_utils/hub..FileCache+match"),u(qe,"class","group"),u(Je,"id","module_utils/hub..FileCache+put"),u(Je,"class","group"),u(Ge,"id","module_utils/hub..CONTENT_TYPE_MAP"),u(Ge,"class","group"),u(et,"id","module_utils/hub..isValidUrl"),u(et,"class","group"),u(dt,"id","module_utils/hub..handleError"),u(dt,"class","group"),u(pt,"id","module_utils/hub..tryCache"),u(pt,"class","group"),u(mt,"id","module_utils/hub..readResponse"),u(mt,"class","group"),u(Tt,"id","module_utils/hub..pathJoin"),u(Tt,"class","group"),u(Ct,"id","module_utils/hub..ExternalData"),u(Ct,"class","group"),u(Lt,"id","module_utils/hub..PretrainedOptions"),u(Lt,"class","group"),u(jt,"id","module_utils/hub..ModelSpecificPretrainedOptions"),u(jt,"class","group"),u(kt,"id","module_utils/hub..PretrainedModelOptions"),u(kt,"class","group")},m(e,t){Xs(document.head,$),i(e,zt,t),i(e,St,t),i(e,Wt,t),i(e,g,t),i(e,Vt,t),f(T,e,t),i(e,Yt,t),i(e,v,t),i(e,Gt,t),i(e,P,t),i(e,Qt,t),i(e,Xt,t),i(e,Zt,t),i(e,y,t),i(e,el,t),f(R,e,t),i(e,tl,t),i(e,C,t),i(e,ll,t),i(e,M,t),i(e,il,t),i(e,x,t),i(e,ol,t),i(e,dl,t),i(e,sl,t),i(e,H,t),i(e,rl,t),f(L,e,t),i(e,nl,t),i(e,F,t),i(e,ul,t),i(e,w,t),i(e,al,t),i(e,A,t),i(e,pl,t),i(e,E,t),i(e,cl,t),i(e,j,t),i(e,fl,t),i(e,hl,t),i(e,ml,t),i(e,O,t),i(e,bl,t),f(U,e,t),i(e,_l,t),i(e,B,t),i(e,$l,t),i(e,gl,t),i(e,Tl,t),i(e,K,t),i(e,vl,t),f(k,e,t),i(e,Pl,t),i(e,q,t),i(e,yl,t),i(e,Rl,t),i(e,Cl,t),i(e,I,t),i(e,Ml,t),f(N,e,t),i(e,xl,t),i(e,D,t),i(e,Hl,t),i(e,Ll,t),i(e,Fl,t),i(e,S,t),i(e,wl,t),f(J,e,t),i(e,Al,t),i(e,z,t),i(e,El,t),i(e,W,t),i(e,jl,t),i(e,V,t),i(e,Ol,t),i(e,Y,t),i(e,Ul,t),i(e,Bl,t),i(e,Kl,t),i(e,G,t),i(e,kl,t),f(Q,e,t),i(e,ql,t),i(e,X,t),i(e,Il,t),i(e,Z,t),i(e,Nl,t),i(e,Dl,t),i(e,Sl,t),i(e,ee,t),i(e,Jl,t),f(te,e,t),i(e,zl,t),i(e,le,t),i(e,Wl,t),i(e,ie,t),i(e,Vl,t),i(e,Yl,t),i(e,Gl,t),i(e,oe,t),i(e,Ql,t),f(de,e,t),i(e,Xl,t),i(e,se,t),i(e,Zl,t),i(e,re,t),i(e,ei,t),i(e,ti,t),i(e,li,t),i(e,ne,t),i(e,ii,t),f(ue,e,t),i(e,oi,t),i(e,ae,t),i(e,di,t),i(e,pe,t),i(e,si,t),i(e,ri,t),i(e,ni,t),i(e,ce,t),i(e,ui,t),f(fe,e,t),i(e,ai,t),i(e,he,t),i(e,pi,t),i(e,me,t),i(e,ci,t),i(e,be,t),i(e,fi,t),i(e,hi,t),i(e,mi,t),i(e,_e,t),i(e,bi,t),f($e,e,t),i(e,_i,t),i(e,ge,t),i(e,$i,t),i(e,Te,t),i(e,gi,t),i(e,ve,t),i(e,Ti,t),i(e,vi,t),i(e,Pi,t),i(e,Pe,t),i(e,yi,t),f(ye,e,t),i(e,Ri,t),i(e,Re,t),i(e,Ci,t),i(e,Ce,t),i(e,Mi,t),i(e,Me,t),i(e,xi,t),i(e,Hi,t),i(e,Li,t),i(e,xe,t),i(e,Fi,t),f(He,e,t),i(e,wi,t),i(e,Le,t),i(e,Ai,t),i(e,Fe,t),i(e,Ei,t),i(e,we,t),i(e,ji,t),i(e,Oi,t),i(e,Ui,t),i(e,Ae,t),i(e,Bi,t),f(Ee,e,t),i(e,Ki,t),i(e,je,t),i(e,ki,t),i(e,Oe,t),i(e,qi,t),i(e,Ii,t),i(e,Ni,t),i(e,Ue,t),i(e,Di,t),f(Be,e,t),i(e,Si,t),i(e,Ke,t),i(e,Ji,t),i(e,ke,t),i(e,zi,t),i(e,Wi,t),i(e,Vi,t),i(e,qe,t),i(e,Yi,t),f(Ie,e,t),i(e,Gi,t),i(e,Ne,t),i(e,Qi,t),i(e,De,t),i(e,Xi,t),i(e,Se,t),i(e,Zi,t),i(e,eo,t),i(e,to,t),i(e,Je,t),i(e,lo,t),f(ze,e,t),i(e,io,t),i(e,We,t),i(e,oo,t),i(e,Ve,t),i(e,so,t),i(e,Ye,t),i(e,ro,t),i(e,no,t),i(e,uo,t),i(e,Ge,t),i(e,ao,t),f(Qe,e,t),i(e,po,t),i(e,Xe,t),i(e,co,t),i(e,Ze,t),i(e,fo,t),i(e,ho,t),i(e,mo,t),i(e,et,t),i(e,bo,t),f(tt,e,t),i(e,_o,t),i(e,lt,t),i(e,$o,t),i(e,it,t),i(e,go,t),i(e,ot,t),i(e,To,t),i(e,vo,t),i(e,Po,t),i(e,dt,t),i(e,yo,t),f(st,e,t),i(e,Ro,t),i(e,rt,t),i(e,Co,t),i(e,nt,t),i(e,Mo,t),i(e,ut,t),i(e,xo,t),i(e,at,t),i(e,Ho,t),i(e,Lo,t),i(e,Fo,t),i(e,pt,t),i(e,wo,t),f(ct,e,t),i(e,Ao,t),i(e,ft,t),i(e,Eo,t),i(e,ht,t),i(e,jo,t),i(e,Oo,t),i(e,Uo,t),i(e,mt,t),i(e,Bo,t),f(bt,e,t),i(e,Ko,t),i(e,_t,t),i(e,ko,t),i(e,$t,t),i(e,qo,t),i(e,gt,t),i(e,Io,t),i(e,No,t),i(e,Do,t),i(e,Tt,t),i(e,So,t),f(vt,e,t),i(e,Jo,t),i(e,Pt,t),i(e,zo,t),i(e,yt,t),i(e,Wo,t),i(e,Rt,t),i(e,Vo,t),i(e,Yo,t),i(e,Go,t),i(e,Ct,t),i(e,Qo,t),f(Mt,e,t),i(e,Xo,t),i(e,xt,t),i(e,Zo,t),i(e,Ht,t),i(e,ed,t),i(e,td,t),i(e,ld,t),i(e,Lt,t),i(e,id,t),f(Ft,e,t),i(e,od,t),i(e,wt,t),i(e,dd,t),i(e,At,t),i(e,sd,t),i(e,Et,t),i(e,rd,t),i(e,nd,t),i(e,ud,t),i(e,jt,t),i(e,ad,t),f(Ot,e,t),i(e,pd,t),i(e,Ut,t),i(e,cd,t),i(e,Bt,t),i(e,fd,t),i(e,Kt,t),i(e,hd,t),i(e,md,t),i(e,bd,t),i(e,kt,t),i(e,_d,t),f(qt,e,t),i(e,$d,t),i(e,It,t),i(e,gd,t),i(e,Nt,t),i(e,Td,t),i(e,vd,t),i(e,Pd,t),f(Dt,e,t),i(e,yd,t),i(e,Jt,t),Rd=!0},p:Ws,i(e){Rd||(h(T.$$.fragment,e),h(R.$$.fragment,e),h(L.$$.fragment,e),h(U.$$.fragment,e),h(k.$$.fragment,e),h(N.$$.fragment,e),h(J.$$.fragment,e),h(Q.$$.fragment,e),h(te.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h($e.$$.fragment,e),h(ye.$$.fragment,e),h(He.$$.fragment,e),h(Ee.$$.fragment,e),h(Be.$$.fragment,e),h(Ie.$$.fragment,e),h(ze.$$.fragment,e),h(Qe.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),h(ct.$$.fragment,e),h(bt.$$.fragment,e),h(vt.$$.fragment,e),h(Mt.$$.fragment,e),h(Ft.$$.fragment,e),h(Ot.$$.fragment,e),h(qt.$$.fragment,e),h(Dt.$$.fragment,e),Rd=!0)},o(e){m(T.$$.fragment,e),m(R.$$.fragment,e),m(L.$$.fragment,e),m(U.$$.fragment,e),m(k.$$.fragment,e),m(N.$$.fragment,e),m(J.$$.fragment,e),m(Q.$$.fragment,e),m(te.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m($e.$$.fragment,e),m(ye.$$.fragment,e),m(He.$$.fragment,e),m(Ee.$$.fragment,e),m(Be.$$.fragment,e),m(Ie.$$.fragment,e),m(ze.$$.fragment,e),m(Qe.$$.fragment,e),m(tt.$$.fragment,e),m(st.$$.fragment,e),m(ct.$$.fragment,e),m(bt.$$.fragment,e),m(vt.$$.fragment,e),m(Mt.$$.fragment,e),m(Ft.$$.fragment,e),m(Ot.$$.fragment,e),m(qt.$$.fragment,e),m(Dt.$$.fragment,e),Rd=!1},d(e){e&&(l(zt),l(St),l(Wt),l(g),l(Vt),l(Yt),l(v),l(Gt),l(P),l(Qt),l(Xt),l(Zt),l(y),l(el),l(tl),l(C),l(ll),l(M),l(il),l(x),l(ol),l(dl),l(sl),l(H),l(rl),l(nl),l(F),l(ul),l(w),l(al),l(A),l(pl),l(E),l(cl),l(j),l(fl),l(hl),l(ml),l(O),l(bl),l(_l),l(B),l($l),l(gl),l(Tl),l(K),l(vl),l(Pl),l(q),l(yl),l(Rl),l(Cl),l(I),l(Ml),l(xl),l(D),l(Hl),l(Ll),l(Fl),l(S),l(wl),l(Al),l(z),l(El),l(W),l(jl),l(V),l(Ol),l(Y),l(Ul),l(Bl),l(Kl),l(G),l(kl),l(ql),l(X),l(Il),l(Z),l(Nl),l(Dl),l(Sl),l(ee),l(Jl),l(zl),l(le),l(Wl),l(ie),l(Vl),l(Yl),l(Gl),l(oe),l(Ql),l(Xl),l(se),l(Zl),l(re),l(ei),l(ti),l(li),l(ne),l(ii),l(oi),l(ae),l(di),l(pe),l(si),l(ri),l(ni),l(ce),l(ui),l(ai),l(he),l(pi),l(me),l(ci),l(be),l(fi),l(hi),l(mi),l(_e),l(bi),l(_i),l(ge),l($i),l(Te),l(gi),l(ve),l(Ti),l(vi),l(Pi),l(Pe),l(yi),l(Ri),l(Re),l(Ci),l(Ce),l(Mi),l(Me),l(xi),l(Hi),l(Li),l(xe),l(Fi),l(wi),l(Le),l(Ai),l(Fe),l(Ei),l(we),l(ji),l(Oi),l(Ui),l(Ae),l(Bi),l(Ki),l(je),l(ki),l(Oe),l(qi),l(Ii),l(Ni),l(Ue),l(Di),l(Si),l(Ke),l(Ji),l(ke),l(zi),l(Wi),l(Vi),l(qe),l(Yi),l(Gi),l(Ne),l(Qi),l(De),l(Xi),l(Se),l(Zi),l(eo),l(to),l(Je),l(lo),l(io),l(We),l(oo),l(Ve),l(so),l(Ye),l(ro),l(no),l(uo),l(Ge),l(ao),l(po),l(Xe),l(co),l(Ze),l(fo),l(ho),l(mo),l(et),l(bo),l(_o),l(lt),l($o),l(it),l(go),l(ot),l(To),l(vo),l(Po),l(dt),l(yo),l(Ro),l(rt),l(Co),l(nt),l(Mo),l(ut),l(xo),l(at),l(Ho),l(Lo),l(Fo),l(pt),l(wo),l(Ao),l(ft),l(Eo),l(ht),l(jo),l(Oo),l(Uo),l(mt),l(Bo),l(Ko),l(_t),l(ko),l($t),l(qo),l(gt),l(Io),l(No),l(Do),l(Tt),l(So),l(Jo),l(Pt),l(zo),l(yt),l(Wo),l(Rt),l(Vo),l(Yo),l(Go),l(Ct),l(Qo),l(Xo),l(xt),l(Zo),l(Ht),l(ed),l(td),l(ld),l(Lt),l(id),l(od),l(wt),l(dd),l(At),l(sd),l(Et),l(rd),l(nd),l(ud),l(jt),l(ad),l(pd),l(Ut),l(cd),l(Bt),l(fd),l(Kt),l(hd),l(md),l(bd),l(kt),l(_d),l($d),l(It),l(gd),l(Nt),l(Td),l(vd),l(Pd),l(yd),l(Jt)),l($),b(T,e),b(R,e),b(L,e),b(U,e),b(k,e),b(N,e),b(J,e),b(Q,e),b(te,e),b(de,e),b(ue,e),b(fe,e),b($e,e),b(ye,e),b(He,e),b(Ee,e),b(Be,e),b(Ie,e),b(ze,e),b(Qe,e),b(tt,e),b(st,e),b(ct,e),b(bt,e),b(vt,e),b(Mt,e),b(Ft,e),b(Ot,e),b(qt,e),b(Dt,e)}}}const tr='{"title":"utils/hub","local":"utilshub","sections":[{"title":"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>","local":"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code","sections":[],"depth":2},{"title":"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path]) ⇒ <code> Promise. < (string|Uint8Array) > </code>","local":"utilshubgetmodelfilepathorrepoid-filename-fatal-options-returnpath--code-promise--stringuint8array--code","sections":[{"title":"getModelFile~cacheKey : <code> string </code>","local":"getmodelfilecachekey--code-string-code","sections":[],"depth":3},{"title":"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>","local":"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code","sections":[],"depth":3},{"title":"getModelFile~buffer : <code> Uint8Array </code>","local":"getmodelfilebuffer--code-uint8array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>","local":"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code","sections":[],"depth":2},{"title":"utils/hub~FileResponse","local":"utilshubfileresponse","sections":[{"title":"new FileResponse(filePath)","local":"new-fileresponsefilepath","sections":[],"depth":3},{"title":"fileResponse.updateContentType() ⇒ <code> void </code>","local":"fileresponseupdatecontenttype--code-void-code","sections":[],"depth":3},{"title":"fileResponse.clone() ⇒ <code> FileResponse </code>","local":"fileresponseclone--code-fileresponse-code","sections":[],"depth":3},{"title":"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>","local":"fileresponsearraybuffer--code-promise--arraybuffer--code","sections":[],"depth":3},{"title":"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>","local":"fileresponseblob--code-promise--blob--code","sections":[],"depth":3},{"title":"fileResponse.text() ⇒ <code> Promise. < string > </code>","local":"fileresponsetext--code-promise--string--code","sections":[],"depth":3},{"title":"fileResponse.json() ⇒ <code> Promise. < Object > </code>","local":"fileresponsejson--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~FileCache","local":"utilshubfilecache","sections":[{"title":"new FileCache(path)","local":"new-filecachepath","sections":[],"depth":3},{"title":"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>","local":"filecachematchrequest--code-promise--fileresponseundefined--code","sections":[],"depth":3},{"title":"fileCache.put(request, response, [progress_callback]) ⇒ <code> Promise. < void > </code>","local":"filecacheputrequest-response-progresscallback--code-promise--void--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~CONTENT_TYPE_MAP","local":"utilshubcontenttypemap","sections":[],"depth":2},{"title":"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>","local":"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>","local":"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code","sections":[],"depth":2},{"title":"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>","local":"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code","sections":[],"depth":2},{"title":"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code","sections":[],"depth":2},{"title":"utils/hub~pathJoin(...parts) ⇒ <code> string </code>","local":"utilshubpathjoinparts--code-string-code","sections":[],"depth":2},{"title":"utils/hub~ExternalData : <code> boolean </code> | <code> number </code>","local":"utilshubexternaldata--code-boolean-code--code-number-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedOptions : <code> Object </code>","local":"utilshubpretrainedoptions--code-object-code","sections":[],"depth":2},{"title":"utils/hub~ModelSpecificPretrainedOptions : <code> Object </code>","local":"utilshubmodelspecificpretrainedoptions--code-object-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedModelOptions : <code> * </code>","local":"utilshubpretrainedmodeloptions--code--code","sections":[],"depth":2}],"depth":1}';function lr(Cd){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sr extends Ys{constructor($){super(),Gs(this,$,lr,er,zs,{})}}export{sr as component};
