import{s as ye,o as ge,n as Vs}from"../chunks/scheduler.36a0863c.js";import{S as fe,i as Je,g as o,s as n,r as d,A as we,h as m,f as e,c as p,j as ue,u,x as g,k as Me,y as Te,a as t,v as M,d as h,t as j,w as y}from"../chunks/index.f891bdb2.js";import{T as Ga}from"../chunks/Tip.a8272f7f.js";import{Y as be}from"../chunks/Youtube.0cbacd3d.js";import{C as w}from"../chunks/CodeBlock.3ec784ea.js";import{F as he,M as je}from"../chunks/Markdown.4127c891.js";import{H as Bs}from"../chunks/Heading.3fb90772.js";function Ue(C){let l,f='Revisa la <a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">página de la tarea</a> de reconocimiento automático del habla para acceder a más información sobre los modelos, datasets y métricas asociados.';return{c(){l=o("p"),l.innerHTML=f},l(r){l=m(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1fx6n3a"&&(l.innerHTML=f)},m(r,J){t(r,l,J)},p:Vs,d(r){r&&e(l)}}}function $e(C){let l,f='Si no tienes experiencia haciéndole fine-tuning a un modelo con el <code>Trainer</code>, ¡échale un vistazo al tutorial básico <a href="../training#train-with-pytorch-trainer">aquí</a>!';return{c(){l=o("p"),l.innerHTML=f},l(r){l=m(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-llf0wi"&&(l.innerHTML=f)},m(r,J){t(r,l,J)},p:Vs,d(r){r&&e(l)}}}function Ie(C){let l,f,r,J="¡Ya puedes empezar a entrenar tu modelo! Para ello, carga Wav2Vec2 con <code>AutoModelForCTC</code>. Especifica la reducción que quieres aplicar con el parámetro <code>ctc_loss_reduction</code>. A menudo, es mejor usar el promedio en lugar de la sumatoria que se hace por defecto.",T,U,Z,R,v="En este punto, solo quedan tres pasos:",X,$,x="<li>Define tus hiperparámetros de entrenamiento en <code>TrainingArguments</code>. El único parámetro obligatorio es <code>output_dir</code> (carpeta de salida), el cual especifica dónde guardar tu modelo. Puedes subir este modelo al Hub haciendo <code>push_to_hub=True</code> (debes haber iniciado sesión en Hugging Face para subir tu modelo). Al final de cada época, el <code>Trainer</code> evaluará la WER y guardará el punto de control del entrenamiento.</li> <li>Pásale los argumentos del entrenamiento al <code>Trainer</code> junto con el modelo, el dataset, el tokenizer, el collator de datos y la función <code>compute_metrics</code>.</li> <li>Llama el método <code>train()</code> para hacerle fine-tuning a tu modelo.</li>",B,I,W,i,_="Una vez que el entrenamiento haya sido completado, comparte tu modelo en el Hub con el método <code>push_to_hub()</code> para que todo el mundo pueda usar tu modelo:",k,G,V;return l=new Ga({props:{$$slots:{default:[$e]},$$scope:{ctx:C}}}),U=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNUQyUyQyUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UlMjIlMkMlMEElMjAlMjAlMjAlMjBjdGNfbG9zc19yZWR1Y3Rpb24lM0QlMjJtZWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuX2lkJTNEcHJvY2Vzc29yLnRva2VuaXplci5wYWRfdG9rZW5faWQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCTC, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>,
<span class="hljs-meta">... </span>    ctc_loss_reduction=<span class="hljs-string">&quot;mean&quot;</span>,
<span class="hljs-meta">... </span>    pad_token_id=processor.tokenizer.pad_token_id,
<span class="hljs-meta">... </span>)`,wrap:!1}}),I=new w({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJteV9hd2Vzb21lX2Fzcl9taW5kX21vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtNSUyQyUwQSUyMCUyMCUyMCUyMHdhcm11cF9zdGVwcyUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDIwMDAlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9jaGVja3BvaW50aW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JvdXBfYnlfbGVuZ3RoJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpY19mb3JfYmVzdF9tb2RlbCUzRCUyMndlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGVuY29kZWRfbWluZHMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGVuY29kZWRfbWluZHMlNUIlMjJ0ZXN0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_asr_mind_model&quot;</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    gradient_accumulation_steps=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    warmup_steps=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>    max_steps=<span class="hljs-number">2000</span>,
<span class="hljs-meta">... </span>    gradient_checkpointing=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    group_by_length=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    metric_for_best_model=<span class="hljs-string">&quot;wer&quot;</span>,
<span class="hljs-meta">... </span>    greater_is_better=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=encoded_minds[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=encoded_minds[<span class="hljs-string">&quot;test&quot;</span>],
<span class="hljs-meta">... </span>    tokenizer=processor.feature_extractor,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),G=new w({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),{c(){d(l.$$.fragment),f=n(),r=o("p"),r.innerHTML=J,T=n(),d(U.$$.fragment),Z=n(),R=o("p"),R.textContent=v,X=n(),$=o("ol"),$.innerHTML=x,B=n(),d(I.$$.fragment),W=n(),i=o("p"),i.innerHTML=_,k=n(),d(G.$$.fragment)},l(c){u(l.$$.fragment,c),f=p(c),r=m(c,"P",{"data-svelte-h":!0}),g(r)!=="svelte-s5u87n"&&(r.innerHTML=J),T=p(c),u(U.$$.fragment,c),Z=p(c),R=m(c,"P",{"data-svelte-h":!0}),g(R)!=="svelte-bd5x35"&&(R.textContent=v),X=p(c),$=m(c,"OL",{"data-svelte-h":!0}),g($)!=="svelte-19msr18"&&($.innerHTML=x),B=p(c),u(I.$$.fragment,c),W=p(c),i=m(c,"P",{"data-svelte-h":!0}),g(i)!=="svelte-1884cpm"&&(i.innerHTML=_),k=p(c),u(G.$$.fragment,c)},m(c,b){M(l,c,b),t(c,f,b),t(c,r,b),t(c,T,b),M(U,c,b),t(c,Z,b),t(c,R,b),t(c,X,b),t(c,$,b),t(c,B,b),M(I,c,b),t(c,W,b),t(c,i,b),t(c,k,b),M(G,c,b),V=!0},p(c,b){const Y={};b&2&&(Y.$$scope={dirty:b,ctx:c}),l.$set(Y)},i(c){V||(h(l.$$.fragment,c),h(U.$$.fragment,c),h(I.$$.fragment,c),h(G.$$.fragment,c),V=!0)},o(c){j(l.$$.fragment,c),j(U.$$.fragment,c),j(I.$$.fragment,c),j(G.$$.fragment,c),V=!1},d(c){c&&(e(f),e(r),e(T),e(Z),e(R),e(X),e($),e(B),e(W),e(i),e(k)),y(l,c),y(U,c),y(I,c),y(G,c)}}}function _e(C){let l,f;return l=new je({props:{$$slots:{default:[Ie]},$$scope:{ctx:C}}}),{c(){d(l.$$.fragment)},l(r){u(l.$$.fragment,r)},m(r,J){M(l,r,J),f=!0},p(r,J){const T={};J&2&&(T.$$scope={dirty:J,ctx:r}),l.$set(T)},i(r){f||(h(l.$$.fragment,r),f=!0)},o(r){j(l.$$.fragment,r),f=!1},d(r){y(l,r)}}}function Ce(C){let l,f='Para ver un ejemplo más detallado de cómo hacerle fine-tuning a un modelo para reconocimiento automático del habla, échale un vistazo a esta <a href="https://huggingface.co/blog/fine-tune-wav2vec2-english" rel="nofollow">entrada de blog</a> para ASR en inglés y a esta <a href="https://huggingface.co/blog/fine-tune-xlsr-wav2vec2" rel="nofollow">entrada</a> para ASR multilingüe.';return{c(){l=o("p"),l.innerHTML=f},l(r){l=m(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-mtqee0"&&(l.innerHTML=f)},m(r,J){t(r,l,J)},p:Vs,d(r){r&&e(l)}}}function ve(C){let l,f="La transcripción es decente, pero podría ser mejor. ¡Intenta hacerle fine-tuning a tu modelo con más ejemplos para obtener resultados aún mejores!";return{c(){l=o("p"),l.textContent=f},l(r){l=m(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-8zadbm"&&(l.textContent=f)},m(r,J){t(r,l,J)},p:Vs,d(r){r&&e(l)}}}function Re(C){let l,f="Carga un procesador para preprocesar el archivo de audio y la transcripción y devuelve el <code>input</code> como un tensor de PyTorch:",r,J,T,U,Z="Pásale tus entradas al modelo y devuelve los logits:",R,v,X,$,x="Obtén los identificadores de los tokens con mayor probabilidad en las predicciones y usa el procesador para decodificarlos y transformarlos en texto:",B,I,W;return J=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRfbW9kZWwlMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stevhliu/my_awesome_asr_mind_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),v=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNUQyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRfbW9kZWwlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;stevhliu/my_awesome_asr_mind_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits`,wrap:!1}}),I=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwcmVkaWN0ZWRfaWRzJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWRpY3RlZF9pZHMpJTBBdHJhbnNjcmlwdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription
[<span class="hljs-string">&#x27;I WOUL LIKE O SET UP JOINT ACOUNT WTH Y PARTNER&#x27;</span>]`,wrap:!1}}),{c(){l=o("p"),l.innerHTML=f,r=n(),d(J.$$.fragment),T=n(),U=o("p"),U.textContent=Z,R=n(),d(v.$$.fragment),X=n(),$=o("p"),$.textContent=x,B=n(),d(I.$$.fragment)},l(i){l=m(i,"P",{"data-svelte-h":!0}),g(l)!=="svelte-uqabxl"&&(l.innerHTML=f),r=p(i),u(J.$$.fragment,i),T=p(i),U=m(i,"P",{"data-svelte-h":!0}),g(U)!=="svelte-xfmo9s"&&(U.textContent=Z),R=p(i),u(v.$$.fragment,i),X=p(i),$=m(i,"P",{"data-svelte-h":!0}),g($)!=="svelte-ld7ycn"&&($.textContent=x),B=p(i),u(I.$$.fragment,i)},m(i,_){t(i,l,_),t(i,r,_),M(J,i,_),t(i,T,_),t(i,U,_),t(i,R,_),M(v,i,_),t(i,X,_),t(i,$,_),t(i,B,_),M(I,i,_),W=!0},p:Vs,i(i){W||(h(J.$$.fragment,i),h(v.$$.fragment,i),h(I.$$.fragment,i),W=!0)},o(i){j(J.$$.fragment,i),j(v.$$.fragment,i),j(I.$$.fragment,i),W=!1},d(i){i&&(e(l),e(r),e(T),e(U),e(R),e(X),e($),e(B)),y(J,i),y(v,i),y(I,i)}}}function We(C){let l,f;return l=new je({props:{$$slots:{default:[Re]},$$scope:{ctx:C}}}),{c(){d(l.$$.fragment)},l(r){u(l.$$.fragment,r)},m(r,J){M(l,r,J),f=!0},p(r,J){const T={};J&2&&(T.$$scope={dirty:J,ctx:r}),l.$set(T)},i(r){f||(h(l.$$.fragment,r),f=!0)},o(r){j(l.$$.fragment,r),f=!1},d(r){y(l,r)}}}function Ze(C){let l,f,r,J,T,U,Z,R,v,X="El reconocimiento automático del habla (ASR, por sus siglas en inglés) convierte una señal de habla en texto y mapea una secuencia de entradas de audio en salidas en forma de texto. Los asistentes virtuales como Siri y Alexa usan modelos de ASR para ayudar a sus usuarios todos los días. De igual forma, hay muchas otras aplicaciones, como la transcripción de contenidos en vivo y la toma automática de notas durante reuniones.",$,x,B="En esta guía te mostraremos como:",I,W,i='<li>Hacer fine-tuning al modelo <a href="https://huggingface.co/facebook/wav2vec2-base" rel="nofollow">Wav2Vec2</a> con el dataset <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> para transcribir audio a texto.</li> <li>Usar tu modelo ajustado para tareas de inferencia.</li>',_,k,G,V,c="Antes de comenzar, asegúrate de haber instalado todas las librerías necesarias:",b,Y,Ys,q,Va="Te aconsejamos iniciar sesión con tu cuenta de Hugging Face para que puedas subir tu modelo y comartirlo con la comunidad. Cuando te sea solicitado, ingresa tu token para iniciar sesión:",Hs,Q,zs,A,Es,F,Ya='Comencemos cargando un subconjunto más pequeño del dataset <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> desde la biblioteca 🤗 Datasets. De esta forma, tendrás la oportunidad de experimentar y asegurarte de que todo funcione antes de invertir más tiempo entrenando con el dataset entero.',Ns,L,qs,S,Ha="Divide la partición <code>train</code> (entrenamiento) en una partición de entrenamiento y una de prueba usando el método <code>~Dataset.train_test_split</code>:",Qs,P,As,D,za="Ahora échale un vistazo al dataset:",Fs,K,Ls,O,Ea="Aunque el dataset contiene mucha información útil, como los campos <code>lang_id</code> (identificador del lenguaje) y <code>english_transcription</code> (transcripción al inglés), en esta guía nos enfocaremos en los campos <code>audio</code> y <code>transcription</code>. Puedes quitar las otras columnas con el método <code>remove_columns</code>:",Ss,ss,Ps,as,Na="Vuelve a echarle un vistazo al ejemplo:",Ds,es,Ks,ts,qa="Hay dos campos:",Os,ls,Qa="<li><code>audio</code>: un <code>array</code> (arreglo) unidimensional de la señal de habla que debe ser invocado para cargar y re-muestrear el archivo de audio.</li> <li><code>transcription</code>: el texto objetivo.</li>",sa,ns,aa,ps,Aa="El siguiente paso es cargar un procesador Wav2Vec2 para procesar la señal de audio:",ea,rs,ta,cs,Fa='El dataset MInDS-14 tiene una tasa de muestreo de 8000kHz (puedes encontrar esta información en su <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">tarjeta de dataset</a>), lo que significa que tendrás que re-muestrear el dataset a 16000kHz para poder usar el modelo Wav2Vec2 pre-entrenado:',la,is,na,os,La="Como puedes ver en el campo <code>transcription</code>, el texto contiene una mezcla de carácteres en mayúsculas y en minúsculas. El tokenizer Wav2Vec2 fue entrenado únicamente con carácteres en mayúsculas, así que tendrás que asegurarte de que el texto se ajuste al vocabulario del tokenizer:",pa,ms,ra,ds,Sa="Ahora vamos a crear una función de preprocesamiento que:",ca,us,Pa="<li>Invoque la columna <code>audio</code> para cargar y re-muestrear el archivo de audio.</li> <li>Extraiga el campo <code>input_values</code> (valores de entrada) del archivo de audio y haga la tokenización de la columna <code>transcription</code> con el procesador.</li>",ia,Ms,oa,hs,Da="Para aplicar la función de preprocesamiento a todo el dataset, puedes usar la función <code>map</code> de 🤗 Datasets. Para acelerar la función <code>map</code> puedes incrementar el número de procesos con el parámetro <code>num_proc</code>. Quita las columnas que no necesites con el método <code>remove_columns</code>:",ma,js,da,ys,Ka="🤗 Transformers no tiene un collator de datos para la tarea de ASR, así que tendrás que adaptar el <code>DataCollatorWithPadding</code> para crear un lote de ejemplos. El collator también le aplicará padding dinámico a tu texto y etiquetas para que tengan la longitud del elemento más largo en su lote (en vez de la mayor longitud en el dataset entero), de forma que todas las muestras tengan una longitud uniforme. Aunque es posible hacerle padding a tu texto con el <code>tokenizer</code> haciendo <code>padding=True</code>, el padding dinámico es más eficiente.",ua,gs,Oa="A diferencia de otros collators de datos, este tiene que aplicarle un método de padding distinto a los campos <code>input_values</code> (valores de entrada) y <code>labels</code> (etiquetas):",Ma,fs,ha,Js,se="Ahora puedes instanciar tu <code>DataCollatorForCTCWithPadding</code>:",ja,ws,ya,Ts,ga,bs,ae='A menudo es útil incluir una métrica durante el entrenamiento para evaluar el rendimiento de tu modelo. Puedes cargar un método de evaluación rápidamente con la biblioteca 🤗 <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">Evaluate</a>. Para esta tarea, puedes usar la métrica de <a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">tasa de error por palabra</a> (WER, por sus siglas en inglés). Puedes ver la <a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">guía rápida</a> de 🤗 Evaluate para aprender más acerca de cómo cargar y computar una métrica.',fa,Us,Ja,$s,ee="Ahora crea una función que le pase tus predicciones y etiquetas a <code>compute</code> para calcular la WER:",wa,Is,Ta,_s,te="Ahora tu función <code>compute_metrics</code> (computar métricas) está lista y podrás usarla cuando estés preparando tu entrenamiento.",ba,Cs,Ua,H,$a,z,Ia,vs,_a,Rs,le="¡Genial, ahora que le has hecho fine-tuning a un modelo, puedes usarlo para inferencia!",Ca,Ws,ne="Carga el archivo de audio sobre el cual quieras correr la inferencia. ¡Recuerda re-muestrar la tasa de muestreo del archivo de audio para que sea la misma del modelo si es necesario!",va,Zs,Ra,xs,pe="La manera más simple de probar tu modelo para hacer inferencia es usarlo en un <code>pipeline()</code>. Puedes instanciar un <code>pipeline</code> para reconocimiento automático del habla con tu modelo y pasarle tu archivo de audio:",Wa,ks,Za,E,xa,Xs,re="También puedes replicar de forma manual los resultados del <code>pipeline</code> si lo deseas:",ka,N,Xa,Gs,Ba;return T=new Bs({props:{title:"Reconocimiento automático del habla",local:"reconocimiento-automático-del-habla",headingTag:"h1"}}),Z=new be({props:{id:"TksaY_FDgnk"}}),k=new Ga({props:{$$slots:{default:[Ue]},$$scope:{ctx:C}}}),Y=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwZXZhbHVhdGUlMjBqaXdlcg==",highlighted:"pip install transformers datasets evaluate jiwer",wrap:!1}}),Q=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),A=new Bs({props:{title:"Cargar el dataset MInDS-14",local:"cargar-el-dataset-minds-14",headingTag:"h2"}}),L=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwbmFtZSUzRCUyMmVuLVVTJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTEwMCU1RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train[:100]&quot;</span>)`,wrap:!1}}),P=new w({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.train_test_split(test_size=<span class="hljs-number">0.2</span>)',wrap:!1}}),K=new w({props:{code:"bWluZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;transcription&#x27;</span>, <span class="hljs-string">&#x27;english_transcription&#x27;</span>, <span class="hljs-string">&#x27;intent_class&#x27;</span>, <span class="hljs-string">&#x27;lang_id&#x27;</span>],
        num_rows: <span class="hljs-number">16</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;transcription&#x27;</span>, <span class="hljs-string">&#x27;english_transcription&#x27;</span>, <span class="hljs-string">&#x27;intent_class&#x27;</span>, <span class="hljs-string">&#x27;lang_id&#x27;</span>],
        num_rows: <span class="hljs-number">4</span>
    })
})`,wrap:!1}}),ss=new w({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyglNUIlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJsYW5nX2lkJTIyJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.remove_columns([<span class="hljs-string">&quot;english_transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;lang_id&quot;</span>])',wrap:!1}}),es=new w({props:{code:"bWluZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;audio&#x27;</span>: {<span class="hljs-string">&#x27;array&#x27;</span>: array([-<span class="hljs-number">0.00024414</span>,  <span class="hljs-number">0.</span>        ,  <span class="hljs-number">0.</span>        , ...,  <span class="hljs-number">0.00024414</span>,
          <span class="hljs-number">0.00024414</span>,  <span class="hljs-number">0.00024414</span>], dtype=float32),
  <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
  <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">8000</span>},
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
 <span class="hljs-string">&#x27;transcription&#x27;</span>: <span class="hljs-string">&quot;hi I&#x27;m trying to use the banking app on my phone and currently my checking and savings account balance is not refreshing&quot;</span>}`,wrap:!1}}),ns=new Bs({props:{title:"Preprocesamiento",local:"preprocesamiento",headingTag:"h2"}}),rs=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>)`,wrap:!1}}),is=new w({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5jYXN0X2NvbHVtbiglMjJhdWRpbyUyMiUyQyUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0QxNl8wMDApKSUwQW1pbmRzJTVCJTIydHJhaW4lMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>minds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;audio&#x27;</span>: {<span class="hljs-string">&#x27;array&#x27;</span>: array([-<span class="hljs-number">2.38064706e-04</span>, -<span class="hljs-number">1.58618059e-04</span>, -<span class="hljs-number">5.43987835e-06</span>, ...,
          <span class="hljs-number">2.78103951e-04</span>,  <span class="hljs-number">2.38446111e-04</span>,  <span class="hljs-number">1.18740834e-04</span>], dtype=float32),
  <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
  <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>},
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
 <span class="hljs-string">&#x27;transcription&#x27;</span>: <span class="hljs-string">&quot;hi I&#x27;m trying to use the banking app on my phone and currently my checking and savings account balance is not refreshing&quot;</span>}`,wrap:!1}}),ms=new w({props:{code:"ZGVmJTIwdXBwZXJjYXNlKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMGV4YW1wbGUlNUIlMjJ0cmFuc2NyaXB0aW9uJTIyJTVELnVwcGVyKCklN0QlMEElMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLm1hcCh1cHBlcmNhc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">uppercase</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;transcription&quot;</span>: example[<span class="hljs-string">&quot;transcription&quot;</span>].upper()}


<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.<span class="hljs-built_in">map</span>(uppercase)`,wrap:!1}}),Ms=new w({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwYmF0Y2glNUIlMjJhdWRpbyUyMiU1RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwdGV4dCUzRGJhdGNoJTVCJTIydHJhbnNjcmlwdGlvbiUyMiU1RCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmlucHV0X2xlbmd0aCUyMiU1RCUyMCUzRCUyMGxlbihiYXRjaCU1QiUyMmlucHV0X3ZhbHVlcyUyMiU1RCU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    audio = batch[<span class="hljs-string">&quot;audio&quot;</span>]
<span class="hljs-meta">... </span>    batch = processor(audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], text=batch[<span class="hljs-string">&quot;transcription&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(batch[<span class="hljs-string">&quot;input_values&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),js=new w({props:{code:"ZW5jb2RlZF9taW5kcyUyMCUzRCUyMG1pbmRzLm1hcChwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRG1pbmRzLmNvbHVtbl9uYW1lcyU1QiUyMnRyYWluJTIyJTVEJTJDJTIwbnVtX3Byb2MlM0Q0KQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=minds.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">4</span>)',wrap:!1}}),fs=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass, field
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorCTCWithPadding</span>:
<span class="hljs-meta">... </span>    processor: AutoProcessor
<span class="hljs-meta">... </span>    padding: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bool</span>, <span class="hljs-built_in">str</span>] = <span class="hljs-string">&quot;longest&quot;</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># particiona las entradas y las etiquetas ya que tienen que tener longitudes distintas y</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># requieren métodos de padding diferentes</span>
<span class="hljs-meta">... </span>        input_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;input_values&quot;</span>][<span class="hljs-number">0</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

<span class="hljs-meta">... </span>        batch = self.processor.pad(input_features, padding=self.padding, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        labels_batch = self.processor.pad(labels=label_features, padding=self.padding, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># remplaza el padding con -100 para ignorar la pérdida de forma correcta</span>
<span class="hljs-meta">... </span>        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ws=new w({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckNUQ1dpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3NvciUyQyUyMHBhZGRpbmclM0QlMjJsb25nZXN0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DataCollatorCTCWithPadding(processor=processor, padding=<span class="hljs-string">&quot;longest&quot;</span>)',wrap:!1}}),Ts=new Bs({props:{title:"Evaluación",local:"evaluación",headingTag:"h2"}}),Us=new w({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEF3ZXIlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>wer = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`,wrap:!1}}),Is=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKHByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZF9sb2dpdHMlMjAlM0QlMjBwcmVkLnByZWRpY3Rpb25zJTBBJTIwJTIwJTIwJTIwcHJlZF9pZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZF9sb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBJTBBJTIwJTIwJTIwJTIwcHJlZC5sYWJlbF9pZHMlNUJwcmVkLmxhYmVsX2lkcyUyMCUzRCUzRCUyMC0xMDAlNUQlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLnBhZF90b2tlbl9pZCUwQSUwQSUyMCUyMCUyMCUyMHByZWRfc3RyJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkX2lkcyklMEElMjAlMjAlMjAlMjBsYWJlbF9zdHIlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWQubGFiZWxfaWRzJTJDJTIwZ3JvdXBfdG9rZW5zJTNERmFsc2UpJTBBJTBBJTIwJTIwJTIwJTIwd2VyJTIwJTNEJTIwd2VyLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkX3N0ciUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbF9zdHIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyd2VyJTIyJTNBJTIwd2VyJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">pred</span>):
<span class="hljs-meta">... </span>    pred_logits = pred.predictions
<span class="hljs-meta">... </span>    pred_ids = np.argmax(pred_logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">... </span>    pred.label_ids[pred.label_ids == -<span class="hljs-number">100</span>] = processor.tokenizer.pad_token_id

<span class="hljs-meta">... </span>    pred_str = processor.batch_decode(pred_ids)
<span class="hljs-meta">... </span>    label_str = processor.batch_decode(pred.label_ids, group_tokens=<span class="hljs-literal">False</span>)

<span class="hljs-meta">... </span>    wer = wer.compute(predictions=pred_str, references=label_str)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer&quot;</span>: wer}`,wrap:!1}}),Cs=new Bs({props:{title:"Entrenamiento",local:"entrenamiento",headingTag:"h2"}}),H=new he({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[_e]},$$scope:{ctx:C}}}),z=new Ga({props:{$$slots:{default:[Ce]},$$scope:{ctx:C}}}),vs=new Bs({props:{title:"Inferencia",local:"inferencia",headingTag:"h2"}}),Zs=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMlBvbHlBSSUyRm1pbmRzMTQlMjIlMkMlMjAlMjJlbi1VUyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQWF1ZGlvX2ZpbGUlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIycGF0aCUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, <span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_file = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;path&quot;</span>]`,wrap:!1}}),ks=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRzX21vZGVsJTIyKSUwQXRyYW5zY3JpYmVyKGF1ZGlvX2ZpbGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;stevhliu/my_awesome_asr_minds_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(audio_file)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I WOUD LIKE O SET UP JOINT ACOUNT WTH Y PARTNER&#x27;</span>}`,wrap:!1}}),E=new Ga({props:{$$slots:{default:[ve]},$$scope:{ctx:C}}}),N=new he({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[We]},$$scope:{ctx:C}}}),{c(){l=o("meta"),f=n(),r=o("p"),J=n(),d(T.$$.fragment),U=n(),d(Z.$$.fragment),R=n(),v=o("p"),v.textContent=X,$=n(),x=o("p"),x.textContent=B,I=n(),W=o("ol"),W.innerHTML=i,_=n(),d(k.$$.fragment),G=n(),V=o("p"),V.textContent=c,b=n(),d(Y.$$.fragment),Ys=n(),q=o("p"),q.textContent=Va,Hs=n(),d(Q.$$.fragment),zs=n(),d(A.$$.fragment),Es=n(),F=o("p"),F.innerHTML=Ya,Ns=n(),d(L.$$.fragment),qs=n(),S=o("p"),S.innerHTML=Ha,Qs=n(),d(P.$$.fragment),As=n(),D=o("p"),D.textContent=za,Fs=n(),d(K.$$.fragment),Ls=n(),O=o("p"),O.innerHTML=Ea,Ss=n(),d(ss.$$.fragment),Ps=n(),as=o("p"),as.textContent=Na,Ds=n(),d(es.$$.fragment),Ks=n(),ts=o("p"),ts.textContent=qa,Os=n(),ls=o("ul"),ls.innerHTML=Qa,sa=n(),d(ns.$$.fragment),aa=n(),ps=o("p"),ps.textContent=Aa,ea=n(),d(rs.$$.fragment),ta=n(),cs=o("p"),cs.innerHTML=Fa,la=n(),d(is.$$.fragment),na=n(),os=o("p"),os.innerHTML=La,pa=n(),d(ms.$$.fragment),ra=n(),ds=o("p"),ds.textContent=Sa,ca=n(),us=o("ol"),us.innerHTML=Pa,ia=n(),d(Ms.$$.fragment),oa=n(),hs=o("p"),hs.innerHTML=Da,ma=n(),d(js.$$.fragment),da=n(),ys=o("p"),ys.innerHTML=Ka,ua=n(),gs=o("p"),gs.innerHTML=Oa,Ma=n(),d(fs.$$.fragment),ha=n(),Js=o("p"),Js.innerHTML=se,ja=n(),d(ws.$$.fragment),ya=n(),d(Ts.$$.fragment),ga=n(),bs=o("p"),bs.innerHTML=ae,fa=n(),d(Us.$$.fragment),Ja=n(),$s=o("p"),$s.innerHTML=ee,wa=n(),d(Is.$$.fragment),Ta=n(),_s=o("p"),_s.innerHTML=te,ba=n(),d(Cs.$$.fragment),Ua=n(),d(H.$$.fragment),$a=n(),d(z.$$.fragment),Ia=n(),d(vs.$$.fragment),_a=n(),Rs=o("p"),Rs.textContent=le,Ca=n(),Ws=o("p"),Ws.textContent=ne,va=n(),d(Zs.$$.fragment),Ra=n(),xs=o("p"),xs.innerHTML=pe,Wa=n(),d(ks.$$.fragment),Za=n(),d(E.$$.fragment),xa=n(),Xs=o("p"),Xs.innerHTML=re,ka=n(),d(N.$$.fragment),Xa=n(),Gs=o("p"),this.h()},l(s){const a=we("svelte-u9bgzb",document.head);l=m(a,"META",{name:!0,content:!0}),a.forEach(e),f=p(s),r=m(s,"P",{}),ue(r).forEach(e),J=p(s),u(T.$$.fragment,s),U=p(s),u(Z.$$.fragment,s),R=p(s),v=m(s,"P",{"data-svelte-h":!0}),g(v)!=="svelte-epcgmo"&&(v.textContent=X),$=p(s),x=m(s,"P",{"data-svelte-h":!0}),g(x)!=="svelte-cz2yfj"&&(x.textContent=B),I=p(s),W=m(s,"OL",{"data-svelte-h":!0}),g(W)!=="svelte-15cr61c"&&(W.innerHTML=i),_=p(s),u(k.$$.fragment,s),G=p(s),V=m(s,"P",{"data-svelte-h":!0}),g(V)!=="svelte-dzv42z"&&(V.textContent=c),b=p(s),u(Y.$$.fragment,s),Ys=p(s),q=m(s,"P",{"data-svelte-h":!0}),g(q)!=="svelte-1cq1w7n"&&(q.textContent=Va),Hs=p(s),u(Q.$$.fragment,s),zs=p(s),u(A.$$.fragment,s),Es=p(s),F=m(s,"P",{"data-svelte-h":!0}),g(F)!=="svelte-1xjdzog"&&(F.innerHTML=Ya),Ns=p(s),u(L.$$.fragment,s),qs=p(s),S=m(s,"P",{"data-svelte-h":!0}),g(S)!=="svelte-1mkamtr"&&(S.innerHTML=Ha),Qs=p(s),u(P.$$.fragment,s),As=p(s),D=m(s,"P",{"data-svelte-h":!0}),g(D)!=="svelte-1br3wmv"&&(D.textContent=za),Fs=p(s),u(K.$$.fragment,s),Ls=p(s),O=m(s,"P",{"data-svelte-h":!0}),g(O)!=="svelte-17zedvp"&&(O.innerHTML=Ea),Ss=p(s),u(ss.$$.fragment,s),Ps=p(s),as=m(s,"P",{"data-svelte-h":!0}),g(as)!=="svelte-et2cmw"&&(as.textContent=Na),Ds=p(s),u(es.$$.fragment,s),Ks=p(s),ts=m(s,"P",{"data-svelte-h":!0}),g(ts)!=="svelte-1829lf7"&&(ts.textContent=qa),Os=p(s),ls=m(s,"UL",{"data-svelte-h":!0}),g(ls)!=="svelte-1hsf2hk"&&(ls.innerHTML=Qa),sa=p(s),u(ns.$$.fragment,s),aa=p(s),ps=m(s,"P",{"data-svelte-h":!0}),g(ps)!=="svelte-1g0fsgx"&&(ps.textContent=Aa),ea=p(s),u(rs.$$.fragment,s),ta=p(s),cs=m(s,"P",{"data-svelte-h":!0}),g(cs)!=="svelte-1mv5akl"&&(cs.innerHTML=Fa),la=p(s),u(is.$$.fragment,s),na=p(s),os=m(s,"P",{"data-svelte-h":!0}),g(os)!=="svelte-12xa7sk"&&(os.innerHTML=La),pa=p(s),u(ms.$$.fragment,s),ra=p(s),ds=m(s,"P",{"data-svelte-h":!0}),g(ds)!=="svelte-vbsdut"&&(ds.textContent=Sa),ca=p(s),us=m(s,"OL",{"data-svelte-h":!0}),g(us)!=="svelte-1exh166"&&(us.innerHTML=Pa),ia=p(s),u(Ms.$$.fragment,s),oa=p(s),hs=m(s,"P",{"data-svelte-h":!0}),g(hs)!=="svelte-61w3lz"&&(hs.innerHTML=Da),ma=p(s),u(js.$$.fragment,s),da=p(s),ys=m(s,"P",{"data-svelte-h":!0}),g(ys)!=="svelte-162z1az"&&(ys.innerHTML=Ka),ua=p(s),gs=m(s,"P",{"data-svelte-h":!0}),g(gs)!=="svelte-1uop6u5"&&(gs.innerHTML=Oa),Ma=p(s),u(fs.$$.fragment,s),ha=p(s),Js=m(s,"P",{"data-svelte-h":!0}),g(Js)!=="svelte-tdpb5h"&&(Js.innerHTML=se),ja=p(s),u(ws.$$.fragment,s),ya=p(s),u(Ts.$$.fragment,s),ga=p(s),bs=m(s,"P",{"data-svelte-h":!0}),g(bs)!=="svelte-17q3xd7"&&(bs.innerHTML=ae),fa=p(s),u(Us.$$.fragment,s),Ja=p(s),$s=m(s,"P",{"data-svelte-h":!0}),g($s)!=="svelte-yu81ac"&&($s.innerHTML=ee),wa=p(s),u(Is.$$.fragment,s),Ta=p(s),_s=m(s,"P",{"data-svelte-h":!0}),g(_s)!=="svelte-1sl6wg0"&&(_s.innerHTML=te),ba=p(s),u(Cs.$$.fragment,s),Ua=p(s),u(H.$$.fragment,s),$a=p(s),u(z.$$.fragment,s),Ia=p(s),u(vs.$$.fragment,s),_a=p(s),Rs=m(s,"P",{"data-svelte-h":!0}),g(Rs)!=="svelte-1w5qtze"&&(Rs.textContent=le),Ca=p(s),Ws=m(s,"P",{"data-svelte-h":!0}),g(Ws)!=="svelte-1tpt1c6"&&(Ws.textContent=ne),va=p(s),u(Zs.$$.fragment,s),Ra=p(s),xs=m(s,"P",{"data-svelte-h":!0}),g(xs)!=="svelte-1kz9iuo"&&(xs.innerHTML=pe),Wa=p(s),u(ks.$$.fragment,s),Za=p(s),u(E.$$.fragment,s),xa=p(s),Xs=m(s,"P",{"data-svelte-h":!0}),g(Xs)!=="svelte-o5jka0"&&(Xs.innerHTML=re),ka=p(s),u(N.$$.fragment,s),Xa=p(s),Gs=m(s,"P",{}),ue(Gs).forEach(e),this.h()},h(){Me(l,"name","hf:doc:metadata"),Me(l,"content",xe)},m(s,a){Te(document.head,l),t(s,f,a),t(s,r,a),t(s,J,a),M(T,s,a),t(s,U,a),M(Z,s,a),t(s,R,a),t(s,v,a),t(s,$,a),t(s,x,a),t(s,I,a),t(s,W,a),t(s,_,a),M(k,s,a),t(s,G,a),t(s,V,a),t(s,b,a),M(Y,s,a),t(s,Ys,a),t(s,q,a),t(s,Hs,a),M(Q,s,a),t(s,zs,a),M(A,s,a),t(s,Es,a),t(s,F,a),t(s,Ns,a),M(L,s,a),t(s,qs,a),t(s,S,a),t(s,Qs,a),M(P,s,a),t(s,As,a),t(s,D,a),t(s,Fs,a),M(K,s,a),t(s,Ls,a),t(s,O,a),t(s,Ss,a),M(ss,s,a),t(s,Ps,a),t(s,as,a),t(s,Ds,a),M(es,s,a),t(s,Ks,a),t(s,ts,a),t(s,Os,a),t(s,ls,a),t(s,sa,a),M(ns,s,a),t(s,aa,a),t(s,ps,a),t(s,ea,a),M(rs,s,a),t(s,ta,a),t(s,cs,a),t(s,la,a),M(is,s,a),t(s,na,a),t(s,os,a),t(s,pa,a),M(ms,s,a),t(s,ra,a),t(s,ds,a),t(s,ca,a),t(s,us,a),t(s,ia,a),M(Ms,s,a),t(s,oa,a),t(s,hs,a),t(s,ma,a),M(js,s,a),t(s,da,a),t(s,ys,a),t(s,ua,a),t(s,gs,a),t(s,Ma,a),M(fs,s,a),t(s,ha,a),t(s,Js,a),t(s,ja,a),M(ws,s,a),t(s,ya,a),M(Ts,s,a),t(s,ga,a),t(s,bs,a),t(s,fa,a),M(Us,s,a),t(s,Ja,a),t(s,$s,a),t(s,wa,a),M(Is,s,a),t(s,Ta,a),t(s,_s,a),t(s,ba,a),M(Cs,s,a),t(s,Ua,a),M(H,s,a),t(s,$a,a),M(z,s,a),t(s,Ia,a),M(vs,s,a),t(s,_a,a),t(s,Rs,a),t(s,Ca,a),t(s,Ws,a),t(s,va,a),M(Zs,s,a),t(s,Ra,a),t(s,xs,a),t(s,Wa,a),M(ks,s,a),t(s,Za,a),M(E,s,a),t(s,xa,a),t(s,Xs,a),t(s,ka,a),M(N,s,a),t(s,Xa,a),t(s,Gs,a),Ba=!0},p(s,[a]){const ce={};a&2&&(ce.$$scope={dirty:a,ctx:s}),k.$set(ce);const ie={};a&2&&(ie.$$scope={dirty:a,ctx:s}),H.$set(ie);const oe={};a&2&&(oe.$$scope={dirty:a,ctx:s}),z.$set(oe);const me={};a&2&&(me.$$scope={dirty:a,ctx:s}),E.$set(me);const de={};a&2&&(de.$$scope={dirty:a,ctx:s}),N.$set(de)},i(s){Ba||(h(T.$$.fragment,s),h(Z.$$.fragment,s),h(k.$$.fragment,s),h(Y.$$.fragment,s),h(Q.$$.fragment,s),h(A.$$.fragment,s),h(L.$$.fragment,s),h(P.$$.fragment,s),h(K.$$.fragment,s),h(ss.$$.fragment,s),h(es.$$.fragment,s),h(ns.$$.fragment,s),h(rs.$$.fragment,s),h(is.$$.fragment,s),h(ms.$$.fragment,s),h(Ms.$$.fragment,s),h(js.$$.fragment,s),h(fs.$$.fragment,s),h(ws.$$.fragment,s),h(Ts.$$.fragment,s),h(Us.$$.fragment,s),h(Is.$$.fragment,s),h(Cs.$$.fragment,s),h(H.$$.fragment,s),h(z.$$.fragment,s),h(vs.$$.fragment,s),h(Zs.$$.fragment,s),h(ks.$$.fragment,s),h(E.$$.fragment,s),h(N.$$.fragment,s),Ba=!0)},o(s){j(T.$$.fragment,s),j(Z.$$.fragment,s),j(k.$$.fragment,s),j(Y.$$.fragment,s),j(Q.$$.fragment,s),j(A.$$.fragment,s),j(L.$$.fragment,s),j(P.$$.fragment,s),j(K.$$.fragment,s),j(ss.$$.fragment,s),j(es.$$.fragment,s),j(ns.$$.fragment,s),j(rs.$$.fragment,s),j(is.$$.fragment,s),j(ms.$$.fragment,s),j(Ms.$$.fragment,s),j(js.$$.fragment,s),j(fs.$$.fragment,s),j(ws.$$.fragment,s),j(Ts.$$.fragment,s),j(Us.$$.fragment,s),j(Is.$$.fragment,s),j(Cs.$$.fragment,s),j(H.$$.fragment,s),j(z.$$.fragment,s),j(vs.$$.fragment,s),j(Zs.$$.fragment,s),j(ks.$$.fragment,s),j(E.$$.fragment,s),j(N.$$.fragment,s),Ba=!1},d(s){s&&(e(f),e(r),e(J),e(U),e(R),e(v),e($),e(x),e(I),e(W),e(_),e(G),e(V),e(b),e(Ys),e(q),e(Hs),e(zs),e(Es),e(F),e(Ns),e(qs),e(S),e(Qs),e(As),e(D),e(Fs),e(Ls),e(O),e(Ss),e(Ps),e(as),e(Ds),e(Ks),e(ts),e(Os),e(ls),e(sa),e(aa),e(ps),e(ea),e(ta),e(cs),e(la),e(na),e(os),e(pa),e(ra),e(ds),e(ca),e(us),e(ia),e(oa),e(hs),e(ma),e(da),e(ys),e(ua),e(gs),e(Ma),e(ha),e(Js),e(ja),e(ya),e(ga),e(bs),e(fa),e(Ja),e($s),e(wa),e(Ta),e(_s),e(ba),e(Ua),e($a),e(Ia),e(_a),e(Rs),e(Ca),e(Ws),e(va),e(Ra),e(xs),e(Wa),e(Za),e(xa),e(Xs),e(ka),e(Xa),e(Gs)),e(l),y(T,s),y(Z,s),y(k,s),y(Y,s),y(Q,s),y(A,s),y(L,s),y(P,s),y(K,s),y(ss,s),y(es,s),y(ns,s),y(rs,s),y(is,s),y(ms,s),y(Ms,s),y(js,s),y(fs,s),y(ws,s),y(Ts,s),y(Us,s),y(Is,s),y(Cs,s),y(H,s),y(z,s),y(vs,s),y(Zs,s),y(ks,s),y(E,s),y(N,s)}}}const xe='{"title":"Reconocimiento automático del habla","local":"reconocimiento-automático-del-habla","sections":[{"title":"Cargar el dataset MInDS-14","local":"cargar-el-dataset-minds-14","sections":[],"depth":2},{"title":"Preprocesamiento","local":"preprocesamiento","sections":[],"depth":2},{"title":"Evaluación","local":"evaluación","sections":[],"depth":2},{"title":"Entrenamiento","local":"entrenamiento","sections":[],"depth":2},{"title":"Inferencia","local":"inferencia","sections":[],"depth":2}],"depth":1}';function ke(C){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends fe{constructor(l){super(),Je(this,l,ke,Ze,ye,{})}}export{Ee as component};
