import{s as Ms,o as bs,n as Wt}from"../chunks/scheduler.9bc65507.js";import{S as ys,i as vs,g as r,s,r as p,A as Ts,h as i,f as n,c as a,j as Z,u as m,x as d,k as $,y as l,a as o,v as u,d as h,t as g,w as f}from"../chunks/index.707bf1b6.js";import{T as vo}from"../chunks/Tip.c2ecdbf4.js";import{D as X}from"../chunks/Docstring.17db21ae.js";import{C as R}from"../chunks/CodeBlock.54a9f38d.js";import{E as _s}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as U}from"../chunks/Heading.342b1fa6.js";function ws(F){let c,y="Example:",M,b,v;return b=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBNdXNpY2dlbkNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME11c2ljZ2VuRGVjb2RlckNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMFQ1Q29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwRW5jb2RlY0NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRleHQlMjBlbmNvZGVyJTJDJTIwYXVkaW8lMjBlbmNvZGVyJTJDJTIwYW5kJTIwZGVjb2RlciUyMG1vZGVsJTIwY29uZmlndXJhdGlvbnMlMEF0ZXh0X2VuY29kZXJfY29uZmlnJTIwJTNEJTIwVDVDb25maWcoKSUwQWF1ZGlvX2VuY29kZXJfY29uZmlnJTIwJTNEJTIwRW5jb2RlY0NvbmZpZygpJTBBZGVjb2Rlcl9jb25maWclMjAlM0QlMjBNdXNpY2dlbkRlY29kZXJDb25maWcoKSUwQSUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNdXNpY2dlbkNvbmZpZy5mcm9tX3N1Yl9tb2RlbHNfY29uZmlnKCUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl9jb25maWclMkMlMjBhdWRpb19lbmNvZGVyX2NvbmZpZyUyQyUyMGRlY29kZXJfY29uZmlnJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBY29uZmlnX3RleHRfZW5jb2RlciUyMCUzRCUyMG1vZGVsLmNvbmZpZy50ZXh0X2VuY29kZXIlMEFjb25maWdfYXVkaW9fZW5jb2RlciUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyJTBBY29uZmlnX2RlY29kZXIlMjAlM0QlMjBtb2RlbC5jb25maWcuZGVjb2RlciUwQSUwQSUyMyUyMFNhdmluZyUyMHRoZSUyMG1vZGVsJTJDJTIwaW5jbHVkaW5nJTIwaXRzJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiklMEElMEElMjMlMjBsb2FkaW5nJTIwbW9kZWwlMjBhbmQlMjBjb25maWclMjBmcm9tJTIwcHJldHJhaW5lZCUyMGZvbGRlciUwQW11c2ljZ2VuX2NvbmZpZyUyMCUzRCUyME11c2ljZ2VuQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiklMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiUyQyUyMGNvbmZpZyUzRG11c2ljZ2VuX2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MusicgenConfig,
<span class="hljs-meta">... </span>    MusicgenDecoderConfig,
<span class="hljs-meta">... </span>    T5Config,
<span class="hljs-meta">... </span>    EncodecConfig,
<span class="hljs-meta">... </span>    MusicgenForConditionalGeneration,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing text encoder, audio encoder, and decoder model configurations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_config = T5Config()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_encoder_config = EncodecConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = MusicgenDecoderConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MusicgenConfig.from_sub_models_config(
<span class="hljs-meta">... </span>    text_encoder_config, audio_encoder_config, decoder_config
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MusicgenForConditionalGeneration (with random weights) from the facebook/musicgen-small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text_encoder = model.config.text_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_audio_encoder = model.config.audio_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder = model.config.decoder

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>musicgen_config = MusicgenConfig.from_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>, config=musicgen_config)`,wrap:!1}}),{c(){c=r("p"),c.textContent=y,M=s(),p(b.$$.fragment)},l(_){c=i(_,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=y),M=a(_),m(b.$$.fragment,_)},m(_,j){o(_,c,j),o(_,M,j),u(b,_,j),v=!0},p:Wt,i(_){v||(h(b.$$.fragment,_),v=!0)},o(_){g(b.$$.fragment,_),v=!1},d(_){_&&(n(c),n(M)),f(b,_)}}}function ks(F){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=y},l(M){c=i(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(M,b){o(M,c,b)},p:Wt,d(M){M&&n(c)}}}function js(F){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=y},l(M){c=i(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(M,b){o(M,c,b)},p:Wt,d(M){M&&n(c)}}}function Cs(F){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=y},l(M){c=i(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(M,b){o(M,c,b)},p:Wt,d(M){M&&n(c)}}}function Js(F){let c,y="Examples:",M,b,v;return b=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwcG9wJTIwdHJhY2slMjB3aXRoJTIwYmFzc3klMjBkcnVtcyUyMGFuZCUyMHN5bnRoJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQSUwQXBhZF90b2tlbl9pZCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRpb25fY29uZmlnLnBhZF90b2tlbl9pZCUwQWRlY29kZXJfaW5wdXRfaWRzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm9uZXMoKGlucHV0cy5pbnB1dF9pZHMuc2hhcGUlNUIwJTVEJTIwKiUyMG1vZGVsLmRlY29kZXIubnVtX2NvZGVib29rcyUyQyUyMDEpJTJDJTIwZHR5cGUlM0R0b3JjaC5sb25nKSUwQSUyMCUyMCUyMCUyMColMjBwYWRfdG9rZW5faWQlMEEpJTBBJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGRlY29kZXJfaW5wdXRfaWRzKS5sb2dpdHMlMEFsb2dpdHMuc2hhcGUlMjAlMjAlMjMlMjAoYnN6JTIwKiUyMG51bV9jb2RlYm9va3MlMkMlMjB0Z3RfbGVuJTJDJTIwdm9jYWJfc2l6ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pad_token_id = model.generation_config.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = (
<span class="hljs-meta">... </span>    torch.ones((inputs.input_ids.shape[<span class="hljs-number">0</span>] * model.decoder.num_codebooks, <span class="hljs-number">1</span>), dtype=torch.long)
<span class="hljs-meta">... </span>    * pad_token_id
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs, decoder_input_ids=decoder_input_ids).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape  <span class="hljs-comment"># (bsz * num_codebooks, tgt_len, vocab_size)</span>
torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2048</span>])`,wrap:!1}}),{c(){c=r("p"),c.textContent=y,M=s(),p(b.$$.fragment)},l(_){c=i(_,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=y),M=a(_),m(b.$$.fragment,_)},m(_,j){o(_,c,j),o(_,M,j),u(b,_,j),v=!0},p:Wt,i(_){v||(h(b.$$.fragment,_),v=!0)},o(_){g(b.$$.fragment,_),v=!1},d(_){_&&(n(c),n(M)),f(b,_)}}}function Us(F){let c,y,M,b,v,_,j,zt,K,To=`The MusicGen model was proposed in the paper <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a>
by Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi and Alexandre Défossez.`,Nt,ee,wo=`MusicGen is a single stage auto-regressive Transformer model capable of generating high-quality music samples conditioned
on text descriptions or audio prompts. The text descriptions are passed through a frozen text encoder model to obtain a
sequence of hidden-state representations. MusicGen is then trained to predict discrete audio tokens, or <em>audio codes</em>,
conditioned on these hidden-states. These audio tokens are then decoded using an audio compression model, such as EnCodec,
to recover the audio waveform.`,It,te,ko=`Through an efficient token interleaving pattern, MusicGen does not require a self-supervised semantic representation of
the text/audio prompts, thus eliminating the need to cascade multiple models to predict a set of codebooks (e.g.
hierarchically or upsampling). Instead, it is able to generate all the codebooks in a single forward pass.`,Xt,ne,jo="The abstract from the paper is the following:",Rt,oe,Co=`<em>We tackle the task of conditional music generation. We introduce MusicGen, a single Language Model (LM) that operates
over several streams of compressed discrete music representation, i.e., tokens. Unlike prior work, MusicGen is comprised
of a single-stage transformer LM together with efficient token interleaving patterns, which eliminates the need for
cascading several models, e.g., hierarchically or upsampling. Following this approach, we demonstrate how MusicGen
can generate high-quality samples, while being conditioned on textual description or melodic features, allowing better
controls over the generated output. We conduct extensive empirical evaluation, considering both automatic and human
studies, showing the proposed approach is superior to the evaluated baselines on a standard text-to-music benchmark.
Through ablation studies, we shed light over the importance of each of the components comprising MusicGen.</em>`,Bt,se,Jo=`This model was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a>. The original code can be found
<a href="https://github.com/facebookresearch/audiocraft" rel="nofollow">here</a>. The pre-trained checkpoints can be found on the
<a href="https://huggingface.co/models?sort=downloads&amp;search=facebook%2Fmusicgen-" rel="nofollow">Hugging Face Hub</a>.`,qt,ae,Vt,re,Uo=`<li>After downloading the original checkpoints from <a href="https://github.com/facebookresearch/audiocraft/blob/main/docs/MUSICGEN.md#importing--exporting-models" rel="nofollow">here</a> , you can convert them using the <strong>conversion script</strong> available at
<code>src/transformers/models/musicgen/convert_musicgen_transformers.py</code> with the following command:</li>`,Yt,ie,Et,le,Ht,de,Zo=`MusicGen is compatible with two generation modes: greedy and sampling. In practice, sampling leads to significantly
better results than greedy, thus we encourage sampling mode to be used where possible. Sampling is enabled by default,
and can be explicitly specified by setting <code>do_sample=True</code> in the call to <code>MusicgenForConditionalGeneration.generate()</code>,
or by overriding the model’s generation config (see below).`,Lt,ce,$o=`Generation is limited by the sinusoidal positional embeddings to 30 second inputs. Meaning, MusicGen cannot generate more
than 30 seconds of audio (1503 tokens), and input audio passed by Audio-Prompted Generation contributes to this limit so,
given an input of 20 seconds of audio, MusicGen cannot generate more than 10 seconds of additional audio.`,Qt,pe,Go=`Transformers supports both mono (1-channel) and stereo (2-channel) variants of MusicGen. The mono channel versions
generate a single set of codebooks. The stereo versions generate 2 sets of codebooks, 1 for each channel (left/right),
and each set of codebooks is decoded independently through the audio compression model. The audio streams for each
channel are combined to give the final stereo output.`,St,me,Pt,ue,xo=`The inputs for unconditional (or ‘null’) generation can be obtained through the method
<code>MusicgenForConditionalGeneration.get_unconditional_inputs()</code>:`,Dt,he,At,ge,Fo=`The audio outputs are a three-dimensional Torch tensor of shape <code>(batch_size, num_channels, sequence_length)</code>. To listen
to the generated audio samples, you can either play them in an ipynb notebook:`,Ot,fe,Kt,_e,Wo="Or save them as a <code>.wav</code> file using a third-party library, e.g. <code>scipy</code>:",en,Me,tn,be,nn,ye,zo=`The model can generate an audio sample conditioned on a text prompt through use of the <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> to pre-process
the inputs:`,on,ve,sn,Te,No=`The <code>guidance_scale</code> is used in classifier free guidance (CFG), setting the weighting between the conditional logits
(which are predicted from the text prompts) and the unconditional logits (which are predicted from an unconditional or
‘null’ prompt). Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer audio quality. CFG is enabled by setting <code>guidance_scale &gt; 1</code>. For best results,
use <code>guidance_scale=3</code> (default).`,an,we,rn,ke,Io=`The same <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> can be used to pre-process an audio prompt that is used for audio continuation. In the
following example, we load an audio file using the 🤗 Datasets library, which can be pip installed through the command
below:`,ln,je,dn,Ce,cn,Je,Xo=`For batched audio-prompted generation, the generated <code>audio_values</code> can be post-processed to remove padding by using the
<a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> class:`,pn,Ue,mn,Ze,un,$e,Ro=`The default parameters that control the generation process, such as sampling, guidance scale and number of generated
tokens, can be found in the model’s generation config, and updated as desired:`,hn,Ge,gn,xe,Bo=`Note that any arguments passed to the generate method will <strong>supersede</strong> those in the generation config, so setting
<code>do_sample=False</code> in the call to generate will supersede the setting of <code>model.generation_config.do_sample</code> in the
generation config.`,fn,Fe,_n,We,qo="The MusicGen model can be de-composed into three distinct stages:",Mn,ze,Vo="<li>Text encoder: maps the text inputs to a sequence of hidden-state representations. The pre-trained MusicGen models use a frozen text encoder from either T5 or Flan-T5</li> <li>MusicGen decoder: a language model (LM) that auto-regressively generates audio tokens (or codes) conditional on the encoder hidden-state representations</li> <li>Audio encoder/decoder: used to encode an audio prompt to use as prompt tokens, and recover the audio waveform from the audio tokens predicted by the decoder</li>",bn,Ne,Yo=`Thus, the MusicGen model can either be used as a standalone decoder model, corresponding to the class <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a>,
or as a composite model that includes the text encoder and audio encoder/decoder, corresponding to the class
<a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a>. If only the decoder needs to be loaded from the pre-trained checkpoint, it can be loaded by first
specifying the correct config, or be accessed through the <code>.decoder</code> attribute of the composite model:`,yn,Ie,vn,Xe,Eo=`Since the text encoder and audio encoder/decoder models are frozen during training, the MusicGen decoder <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a>
can be trained standalone on a dataset of encoder hidden-states and audio codes. For inference, the trained decoder can
be combined with the frozen text encoder and audio encoder/decoders to recover the composite <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a>
model.`,Tn,Re,Ho="Tips:",wn,Be,Lo="<li>MusicGen is trained on the 32kHz checkpoint of Encodec. You should ensure you use a compatible version of the Encodec model.</li> <li>Sampling mode tends to deliver better results than greedy - you can toggle sampling with the variable <code>do_sample</code> in the call to <code>MusicgenForConditionalGeneration.generate()</code></li>",kn,qe,jn,B,Ve,Rn,it,Qo=`This is the configuration class to store the configuration of an <code>MusicgenDecoder</code>. It is used to instantiate a
MusicGen decoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the MusicGen
<a href="https://huggingface.co/facebook/musicgen-small" rel="nofollow">facebook/musicgen-small</a> architecture.`,Bn,lt,So=`Configuration objects inherit from <a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Cn,Ye,Jn,C,Ee,qn,dt,Po=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenModel">MusicgenModel</a>. It is used to instantiate a
MusicGen model according to the specified arguments, defining the text encoder, audio encoder and MusicGen decoder
configs.`,Vn,ct,Do=`Configuration objects inherit from <a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Yn,E,En,H,He,Hn,pt,Ao=`Instantiate a <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a> (or a derived class) from text encoder, audio encoder and decoder
configurations.`,Un,Le,Zn,J,Qe,Ln,mt,Oo=`Constructs a MusicGen processor which wraps an EnCodec feature extractor and a T5 tokenizer into a single processor
class.`,Qn,ut,Ko=`<a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> offers all the functionalities of <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a> and <code>TTokenizer</code>. See
<code>__call__()</code> and <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenProcessor.decode">decode()</a> for more information.`,Sn,L,Se,Pn,ht,es=`This method is used to decode either batches of audio outputs from the MusicGen model, or batches of token ids
from the tokenizer. In the case of decoding token ids, this method forwards all its arguments to T5Tokenizer’s
<a href="/docs/transformers/v4.36.2/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.batch_decode">batch_decode()</a>. Please refer to the docstring of this method for more information.`,Dn,Q,Pe,An,gt,ts=`This method forwards all its arguments to T5Tokenizer’s <a href="/docs/transformers/v4.36.2/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.decode">decode()</a>. Please refer to the
docstring of this method for more information.`,$n,De,Gn,T,Ae,On,ft,ns="The bare Musicgen decoder model outputting raw hidden-states without any specific head on top.",Kn,_t,os=`The Musicgen model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is an
encoder decoder transformer trained on the task of conditional music generation`,eo,Mt,ss=`This model inherits from <a href="/docs/transformers/v4.36.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,to,bt,as=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,no,q,Oe,oo,yt,rs='The <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenModel">MusicgenModel</a> forward method, overrides the <code>__call__</code> special method.',so,S,xn,Ke,Fn,w,et,ao,vt,is="The MusicGen decoder model with a language modelling head on top.",ro,Tt,ls=`The Musicgen model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is an
encoder decoder transformer trained on the task of conditional music generation`,io,wt,ds=`This model inherits from <a href="/docs/transformers/v4.36.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,lo,kt,cs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,co,V,tt,po,jt,ps='The <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',mo,P,Wn,nt,zn,k,ot,uo,Ct,ms="The composite MusicGen model with a text encoder, audio encoder and Musicgen decoder, for music generation tasks with one or both of text and audio prompts.",ho,Jt,us=`The Musicgen model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is an
encoder decoder transformer trained on the task of conditional music generation`,go,Ut,hs=`This model inherits from <a href="/docs/transformers/v4.36.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,fo,Zt,gs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,_o,W,st,Mo,$t,fs='The <a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',bo,D,yo,A,Nn,Ft,In;return v=new U({props:{title:"MusicGen",local:"musicgen",headingTag:"h1"}}),j=new U({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new U({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ie=new R({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbXVzaWNnZW4lMkZjb252ZXJ0X211c2ljZ2VuX3RyYW5zZm9ybWVycy5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY2hlY2twb2ludCUyMHNtYWxsJTIwLS1weXRvcmNoX2R1bXBfZm9sZGVyJTIwJTJGb3V0cHV0JTJGcGF0aCUyMC0tc2FmZV9zZXJpYWxpemF0aW9uJTIw",highlighted:`python src/transformers/models/musicgen/convert_musicgen_transformers.py \\
    --checkpoint small --pytorch_dump_folder /output/path --safe_serialization `,wrap:!1}}),le=new U({props:{title:"Generation",local:"generation",headingTag:"h2"}}),me=new U({props:{title:"Unconditional Generation",local:"unconditional-generation",headingTag:"h3"}}),he=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEF1bmNvbmRpdGlvbmFsX2lucHV0cyUyMCUzRCUyMG1vZGVsLmdldF91bmNvbmRpdGlvbmFsX2lucHV0cyhudW1fc2FtcGxlcyUzRDEpJTBBJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKip1bmNvbmRpdGlvbmFsX2lucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = model.get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**unconditional_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),fe=new R({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyLnNhbXBsaW5nX3JhdGUlMEFBdWRpbyhhdWRpb192YWx1ZXMlNUIwJTVELm51bXB5KCklMkMlMjByYXRlJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sampling_rate = model.config.audio_encoder.sampling_rate
Audio(audio_values[<span class="hljs-number">0</span>].numpy(), rate=sampling_rate)`,wrap:!1}}),Me=new R({props:{code:"aW1wb3J0JTIwc2NpcHklMEElMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwbW9kZWwuY29uZmlnLmF1ZGlvX2VuY29kZXIuc2FtcGxpbmdfcmF0ZSUwQXNjaXB5LmlvLndhdmZpbGUud3JpdGUoJTIybXVzaWNnZW5fb3V0LndhdiUyMiUyQyUyMHJhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwZGF0YSUzRGF1ZGlvX3ZhbHVlcyU1QjAlMkMlMjAwJTVELm51bXB5KCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy

<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = model.config.audio_encoder.sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;musicgen_out.wav&quot;</span>, rate=sampling_rate, data=audio_values[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].numpy())`,wrap:!1}}),be=new U({props:{title:"Text-Conditional Generation",local:"text-conditional-generation",headingTag:"h3"}}),ve=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),we=new U({props:{title:"Audio-Prompted Generation",local:"audio-prompted-generation",headingTag:"h3"}}),je=new R({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHBpcCUwQXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyU1QmF1ZGlvJTVE",highlighted:`pip <span class="hljs-keyword">install</span> --upgrade pip
pip <span class="hljs-keyword">install</span> datasets[audio]`,wrap:!1}}),Ce=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnNhbmNoaXQtZ2FuZGhpJTJGZ3R6YW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkpJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjMlMjB0YWtlJTIwdGhlJTIwZmlyc3QlMjBoYWxmJTIwb2YlMjB0aGUlMjBhdWRpbyUyMHNhbXBsZSUwQXNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTIwJTNEJTIwc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlNUIlM0ElMjBsZW4oc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTJGJTIwMiU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwYmx1ZXMlMjB0cmFjayUyMHdpdGglMjBncm9vdnklMjBzYXhvcGhvbmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample[<span class="hljs-string">&quot;array&quot;</span>] = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=sample[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Ue=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnNhbmNoaXQtZ2FuZGhpJTJGZ3R6YW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkpJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjMlMjB0YWtlJTIwdGhlJTIwZmlyc3QlMjBxdWFydGVyJTIwb2YlMjB0aGUlMjBhdWRpbyUyMHNhbXBsZSUwQXNhbXBsZV8xJTIwJTNEJTIwc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlNUIlM0ElMjBsZW4oc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTJGJTIwNCU1RCUwQSUwQSUyMyUyMHRha2UlMjB0aGUlMjBmaXJzdCUyMGhhbGYlMjBvZiUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTBBc2FtcGxlXzIlMjAlM0QlMjBzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCU1QiUzQSUyMGxlbihzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCklMjAlMkYlMkYlMjAyJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTNEJTVCc2FtcGxlXzElMkMlMjBzYW1wbGVfMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGUlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMGJsdWVzJTIwdHJhY2slMjB3aXRoJTIwZ3Jvb3Z5JTIwc2F4b3Bob25lJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQWF1ZGlvX3ZhbHVlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KSUwQSUwQSUyMyUyMHBvc3QtcHJvY2VzcyUyMHRvJTIwcmVtb3ZlJTIwcGFkZGluZyUyMGZyb20lMjB0aGUlMjBiYXRjaGVkJTIwYXVkaW8lMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGF1ZGlvX3ZhbHVlcyUyQyUyMHBhZGRpbmdfbWFzayUzRGlucHV0cy5wYWRkaW5nX21hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first quarter of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_1 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">4</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_2 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=[sample_1, sample_2],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># post-process to remove padding from the batched audio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = processor.batch_decode(audio_values, padding_mask=inputs.padding_mask)`,wrap:!1}}),Ze=new U({props:{title:"Generation Configuration",local:"generation-configuration",headingTag:"h3"}}),Ge=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEElMjMlMjBpbnNwZWN0JTIwdGhlJTIwZGVmYXVsdCUyMGdlbmVyYXRpb24lMjBjb25maWclMEFtb2RlbC5nZW5lcmF0aW9uX2NvbmZpZyUwQSUwQSUyMyUyMGluY3JlYXNlJTIwdGhlJTIwZ3VpZGFuY2UlMjBzY2FsZSUyMHRvJTIwNC4wJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZ3VpZGFuY2Vfc2NhbGUlMjAlM0QlMjA0LjAlMEElMEElMjMlMjBkZWNyZWFzZSUyMHRoZSUyMG1heCUyMGxlbmd0aCUyMHRvJTIwMjU2JTIwdG9rZW5zJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcubWF4X2xlbmd0aCUyMCUzRCUyMDI1Ng==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inspect the default generation config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># increase the guidance scale to 4.0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.guidance_scale = <span class="hljs-number">4.0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># decrease the max length to 256 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.max_length = <span class="hljs-number">256</span>`,wrap:!1}}),Fe=new U({props:{title:"Model Structure",local:"model-structure",headingTag:"h2"}}),Ie=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBNdXNpY2dlbkZvckNhdXNhbExNJTJDJTIwTXVzaWNnZW5Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEElMjMlMjBPcHRpb24lMjAxJTNBJTIwZ2V0JTIwZGVjb2RlciUyMGNvbmZpZyUyMGFuZCUyMHBhc3MlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQlNjAlMEFkZWNvZGVyX2NvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpLmRlY29kZXIlMEFkZWNvZGVyJTIwJTNEJTIwTXVzaWNnZW5Gb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiUyQyUyMCoqZGVjb2Rlcl9jb25maWcpJTBBJTBBJTIzJTIwT3B0aW9uJTIwMiUzQSUyMGxvYWQlMjB0aGUlMjBlbnRpcmUlMjBjb21wb3NpdGUlMjBtb2RlbCUyQyUyMGJ1dCUyMG9ubHklMjByZXR1cm4lMjB0aGUlMjBkZWNvZGVyJTBBZGVjb2RlciUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLXNtYWxsJTIyKS5kZWNvZGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, MusicgenForCausalLM, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 1: get decoder config and pass to \`.from_pretrained\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>).decoder
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>, **decoder_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 2: load the entire composite model, but only return the decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>).decoder`,wrap:!1}}),qe=new U({props:{title:"MusicgenDecoderConfig",local:"transformers.MusicgenDecoderConfig",headingTag:"h2"}}),Ve=new X({props:{name:"class transformers.MusicgenDecoderConfig",anchor:"transformers.MusicgenDecoderConfig",parameters:[{name:"vocab_size",val:" = 2048"},{name:"max_position_embeddings",val:" = 2048"},{name:"num_hidden_layers",val:" = 24"},{name:"ffn_dim",val:" = 4096"},{name:"num_attention_heads",val:" = 16"},{name:"layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"activation_function",val:" = 'gelu'"},{name:"hidden_size",val:" = 1024"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"initializer_factor",val:" = 0.02"},{name:"scale_embedding",val:" = False"},{name:"num_codebooks",val:" = 4"},{name:"audio_channels",val:" = 1"},{name:"pad_token_id",val:" = 2048"},{name:"bos_token_id",val:" = 2048"},{name:"eos_token_id",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenDecoderConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Vocabulary size of the MusicgenDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MusicgenDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MusicgenDecoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MusicgenDecoderConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MusicgenDecoderConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer block.`,name:"num_attention_heads"},{anchor:"transformers.MusicgenDecoderConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer block.`,name:"ffn_dim"},{anchor:"transformers.MusicgenDecoderConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.MusicgenDecoderConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, text_encoder, and pooler.`,name:"dropout"},{anchor:"transformers.MusicgenDecoderConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MusicgenDecoderConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.MusicgenDecoderConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MusicgenDecoderConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_factor"},{anchor:"transformers.MusicgenDecoderConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"layerdrop"},{anchor:"transformers.MusicgenDecoderConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Scale embeddings by diving by sqrt(hidden_size).`,name:"scale_embedding"},{anchor:"transformers.MusicgenDecoderConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model should return the last key/values attentions (not used by all models)`,name:"use_cache"},{anchor:"transformers.MusicgenDecoderConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of parallel codebooks forwarded to the model.`,name:"num_codebooks"},{anchor:"transformers.MusicgenDecoderConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether input and output word embeddings should be tied.`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.MusicgenDecoderConfig.audio_channels",description:`<strong>audio_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1 &#x2014;
Number of channels in the audio data. Either 1 for mono or 2 for stereo. Stereo models generate a separate
audio stream for the left/right output channels. Mono models generate a single audio stream output.`,name:"audio_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/configuration_musicgen.py#L30"}}),Ye=new U({props:{title:"MusicgenConfig",local:"transformers.MusicgenConfig",headingTag:"h2"}}),Ee=new X({props:{name:"class transformers.MusicgenConfig",anchor:"transformers.MusicgenConfig",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:</p>
<ul>
<li><strong>text_encoder</strong> (<a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the text encoder config.</li>
<li><strong>audio_encoder</strong> (<a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
<li><strong>decoder</strong> (<a href="/docs/transformers/v4.36.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that defines
the decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/configuration_musicgen.py#L139"}}),E=new _s({props:{anchor:"transformers.MusicgenConfig.example",$$slots:{default:[ws]},$$scope:{ctx:F}}}),He=new X({props:{name:"from_sub_models_config",anchor:"transformers.MusicgenConfig.from_sub_models_config",parameters:[{name:"text_encoder_config",val:": PretrainedConfig"},{name:"audio_encoder_config",val:": PretrainedConfig"},{name:"decoder_config",val:": MusicgenDecoderConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/configuration_musicgen.py#L217",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a></p>
`}}),Le=new U({props:{title:"MusicgenProcessor",local:"transformers.MusicgenProcessor",headingTag:"h2"}}),Qe=new X({props:{name:"class transformers.MusicgenProcessor",anchor:"transformers.MusicgenProcessor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.MusicgenProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>EncodecFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MusicgenProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.36.2/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/processing_musicgen.py#L26"}}),Se=new X({props:{name:"batch_decode",anchor:"transformers.MusicgenProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/processing_musicgen.py#L90"}}),Pe=new X({props:{name:"decode",anchor:"transformers.MusicgenProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/processing_musicgen.py#L108"}}),De=new U({props:{title:"MusicgenModel",local:"transformers.MusicgenModel",headingTag:"h2"}}),Ae=new X({props:{name:"class transformers.MusicgenModel",anchor:"transformers.MusicgenModel",parameters:[{name:"config",val:": MusicgenDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.36.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/modeling_musicgen.py#L837"}}),Oe=new X({props:{name:"forward",anchor:"transformers.MusicgenModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MusicgenModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of
the decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing cross-attention on padding tokens indices of encoder input_ids. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenModel.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder to avoid performing
cross-attention on hidden heads. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>. inputs_embeds (<code>torch.FloatTensor</code> of shape
<code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>): Optionally, instead of passing <code>input_ids</code> you
can choose to directly pass an embedded representation. This is useful if you want more control over how to
convert <code>input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"past_key_values"},{anchor:"transformers.MusicgenModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/modeling_musicgen.py#L853"}}),S=new vo({props:{$$slots:{default:[ks]},$$scope:{ctx:F}}}),Ke=new U({props:{title:"MusicgenForCausalLM",local:"transformers.MusicgenForCausalLM",headingTag:"h2"}}),et=new X({props:{name:"class transformers.MusicgenForCausalLM",anchor:"transformers.MusicgenForCausalLM",parameters:[{name:"config",val:": MusicgenDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.36.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/modeling_musicgen.py#L908"}}),tt=new X({props:{name:"forward",anchor:"transformers.MusicgenForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MusicgenForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of
the decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing cross-attention on padding tokens indices of encoder input_ids. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder to avoid performing
cross-attention on hidden heads. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>. inputs_embeds (<code>torch.FloatTensor</code> of shape
<code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>): Optionally, instead of passing <code>input_ids</code> you
can choose to directly pass an embedded representation. This is useful if you want more control over how to
convert <code>input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"past_key_values"},{anchor:"transformers.MusicgenForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MusicgenForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code></p>
<p>Returns:
<a href="/docs/transformers/v4.36.2/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput">transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code>: A <a href="/docs/transformers/v4.36.2/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput">transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014; Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014; Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014; Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014; Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014; Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014; Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014; Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014; Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014; Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/modeling_musicgen.py#L940"}}),P=new vo({props:{$$slots:{default:[js]},$$scope:{ctx:F}}}),nt=new U({props:{title:"MusicgenForConditionalGeneration",local:"transformers.MusicgenForConditionalGeneration",headingTag:"h2"}}),ot=new X({props:{name:"class transformers.MusicgenForConditionalGeneration",anchor:"transformers.MusicgenForConditionalGeneration",parameters:[{name:"config",val:": typing.Optional[transformers.models.musicgen.configuration_musicgen.MusicgenConfig] = None"},{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"audio_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"decoder",val:": typing.Optional[transformers.models.musicgen.modeling_musicgen.MusicgenForCausalLM] = None"}],parametersDescription:[{anchor:"transformers.MusicgenForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.36.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/modeling_musicgen.py#L1411"}}),st=new X({props:{name:"forward",anchor:"transformers.MusicgenForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"padding_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Tuple[typing.Tuple[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.36.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.36.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.36.2/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>decoder_input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/v4.36.2/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>decoder_input_ids</code>.</p>

					</div>`,name:"decoder_input_ids"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>. inputs_embeds (<code>torch.FloatTensor</code> of shape
<code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>): Optionally, instead of passing <code>input_ids</code> you
can choose to directly pass an embedded representation. This is useful if you want more control over how to
convert <code>input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"past_key_values"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.2/src/transformers/models/musicgen/modeling_musicgen.py#L1762",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.36.2/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.36.2/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.36.2/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new vo({props:{$$slots:{default:[Cs]},$$scope:{ctx:F}}}),A=new _s({props:{anchor:"transformers.MusicgenForConditionalGeneration.forward.example",$$slots:{default:[Js]},$$scope:{ctx:F}}}),{c(){c=r("meta"),y=s(),M=r("p"),b=s(),p(v.$$.fragment),_=s(),p(j.$$.fragment),zt=s(),K=r("p"),K.innerHTML=To,Nt=s(),ee=r("p"),ee.innerHTML=wo,It=s(),te=r("p"),te.textContent=ko,Xt=s(),ne=r("p"),ne.textContent=jo,Rt=s(),oe=r("p"),oe.innerHTML=Co,Bt=s(),se=r("p"),se.innerHTML=Jo,qt=s(),p(ae.$$.fragment),Vt=s(),re=r("ul"),re.innerHTML=Uo,Yt=s(),p(ie.$$.fragment),Et=s(),p(le.$$.fragment),Ht=s(),de=r("p"),de.innerHTML=Zo,Lt=s(),ce=r("p"),ce.textContent=$o,Qt=s(),pe=r("p"),pe.textContent=Go,St=s(),p(me.$$.fragment),Pt=s(),ue=r("p"),ue.innerHTML=xo,Dt=s(),p(he.$$.fragment),At=s(),ge=r("p"),ge.innerHTML=Fo,Ot=s(),p(fe.$$.fragment),Kt=s(),_e=r("p"),_e.innerHTML=Wo,en=s(),p(Me.$$.fragment),tn=s(),p(be.$$.fragment),nn=s(),ye=r("p"),ye.innerHTML=zo,on=s(),p(ve.$$.fragment),sn=s(),Te=r("p"),Te.innerHTML=No,an=s(),p(we.$$.fragment),rn=s(),ke=r("p"),ke.innerHTML=Io,ln=s(),p(je.$$.fragment),dn=s(),p(Ce.$$.fragment),cn=s(),Je=r("p"),Je.innerHTML=Xo,pn=s(),p(Ue.$$.fragment),mn=s(),p(Ze.$$.fragment),un=s(),$e=r("p"),$e.textContent=Ro,hn=s(),p(Ge.$$.fragment),gn=s(),xe=r("p"),xe.innerHTML=Bo,fn=s(),p(Fe.$$.fragment),_n=s(),We=r("p"),We.textContent=qo,Mn=s(),ze=r("ol"),ze.innerHTML=Vo,bn=s(),Ne=r("p"),Ne.innerHTML=Yo,yn=s(),p(Ie.$$.fragment),vn=s(),Xe=r("p"),Xe.innerHTML=Eo,Tn=s(),Re=r("p"),Re.textContent=Ho,wn=s(),Be=r("ul"),Be.innerHTML=Lo,kn=s(),p(qe.$$.fragment),jn=s(),B=r("div"),p(Ve.$$.fragment),Rn=s(),it=r("p"),it.innerHTML=Qo,Bn=s(),lt=r("p"),lt.innerHTML=So,Cn=s(),p(Ye.$$.fragment),Jn=s(),C=r("div"),p(Ee.$$.fragment),qn=s(),dt=r("p"),dt.innerHTML=Po,Vn=s(),ct=r("p"),ct.innerHTML=Do,Yn=s(),p(E.$$.fragment),En=s(),H=r("div"),p(He.$$.fragment),Hn=s(),pt=r("p"),pt.innerHTML=Ao,Un=s(),p(Le.$$.fragment),Zn=s(),J=r("div"),p(Qe.$$.fragment),Ln=s(),mt=r("p"),mt.textContent=Oo,Qn=s(),ut=r("p"),ut.innerHTML=Ko,Sn=s(),L=r("div"),p(Se.$$.fragment),Pn=s(),ht=r("p"),ht.innerHTML=es,Dn=s(),Q=r("div"),p(Pe.$$.fragment),An=s(),gt=r("p"),gt.innerHTML=ts,$n=s(),p(De.$$.fragment),Gn=s(),T=r("div"),p(Ae.$$.fragment),On=s(),ft=r("p"),ft.textContent=ns,Kn=s(),_t=r("p"),_t.innerHTML=os,eo=s(),Mt=r("p"),Mt.innerHTML=ss,to=s(),bt=r("p"),bt.innerHTML=as,no=s(),q=r("div"),p(Oe.$$.fragment),oo=s(),yt=r("p"),yt.innerHTML=rs,so=s(),p(S.$$.fragment),xn=s(),p(Ke.$$.fragment),Fn=s(),w=r("div"),p(et.$$.fragment),ao=s(),vt=r("p"),vt.textContent=is,ro=s(),Tt=r("p"),Tt.innerHTML=ls,io=s(),wt=r("p"),wt.innerHTML=ds,lo=s(),kt=r("p"),kt.innerHTML=cs,co=s(),V=r("div"),p(tt.$$.fragment),po=s(),jt=r("p"),jt.innerHTML=ps,mo=s(),p(P.$$.fragment),Wn=s(),p(nt.$$.fragment),zn=s(),k=r("div"),p(ot.$$.fragment),uo=s(),Ct=r("p"),Ct.textContent=ms,ho=s(),Jt=r("p"),Jt.innerHTML=us,go=s(),Ut=r("p"),Ut.innerHTML=hs,fo=s(),Zt=r("p"),Zt.innerHTML=gs,_o=s(),W=r("div"),p(st.$$.fragment),Mo=s(),$t=r("p"),$t.innerHTML=fs,bo=s(),p(D.$$.fragment),yo=s(),p(A.$$.fragment),Nn=s(),Ft=r("p"),this.h()},l(e){const t=Ts("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(n),y=a(e),M=i(e,"P",{}),Z(M).forEach(n),b=a(e),m(v.$$.fragment,e),_=a(e),m(j.$$.fragment,e),zt=a(e),K=i(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1glsc0y"&&(K.innerHTML=To),Nt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-8d0j4l"&&(ee.innerHTML=wo),It=a(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-cdry7g"&&(te.textContent=ko),Xt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-vfdo9a"&&(ne.textContent=jo),Rt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-6qc9b"&&(oe.innerHTML=Co),Bt=a(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1o040cl"&&(se.innerHTML=Jo),qt=a(e),m(ae.$$.fragment,e),Vt=a(e),re=i(e,"UL",{"data-svelte-h":!0}),d(re)!=="svelte-12e77r4"&&(re.innerHTML=Uo),Yt=a(e),m(ie.$$.fragment,e),Et=a(e),m(le.$$.fragment,e),Ht=a(e),de=i(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1rrub89"&&(de.innerHTML=Zo),Lt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1tppmp9"&&(ce.textContent=$o),Qt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1e09glx"&&(pe.textContent=Go),St=a(e),m(me.$$.fragment,e),Pt=a(e),ue=i(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-hslupw"&&(ue.innerHTML=xo),Dt=a(e),m(he.$$.fragment,e),At=a(e),ge=i(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-c9ap2j"&&(ge.innerHTML=Fo),Ot=a(e),m(fe.$$.fragment,e),Kt=a(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1endcdl"&&(_e.innerHTML=Wo),en=a(e),m(Me.$$.fragment,e),tn=a(e),m(be.$$.fragment,e),nn=a(e),ye=i(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1wbw7bb"&&(ye.innerHTML=zo),on=a(e),m(ve.$$.fragment,e),sn=a(e),Te=i(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-78k595"&&(Te.innerHTML=No),an=a(e),m(we.$$.fragment,e),rn=a(e),ke=i(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1oioaa1"&&(ke.innerHTML=Io),ln=a(e),m(je.$$.fragment,e),dn=a(e),m(Ce.$$.fragment,e),cn=a(e),Je=i(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1a2238c"&&(Je.innerHTML=Xo),pn=a(e),m(Ue.$$.fragment,e),mn=a(e),m(Ze.$$.fragment,e),un=a(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1qo0662"&&($e.textContent=Ro),hn=a(e),m(Ge.$$.fragment,e),gn=a(e),xe=i(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-132s853"&&(xe.innerHTML=Bo),fn=a(e),m(Fe.$$.fragment,e),_n=a(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-52mell"&&(We.textContent=qo),Mn=a(e),ze=i(e,"OL",{"data-svelte-h":!0}),d(ze)!=="svelte-12ipaq0"&&(ze.innerHTML=Vo),bn=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1a2s541"&&(Ne.innerHTML=Yo),yn=a(e),m(Ie.$$.fragment,e),vn=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-9b4zc6"&&(Xe.innerHTML=Eo),Tn=a(e),Re=i(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-axv494"&&(Re.textContent=Ho),wn=a(e),Be=i(e,"UL",{"data-svelte-h":!0}),d(Be)!=="svelte-1upux1z"&&(Be.innerHTML=Lo),kn=a(e),m(qe.$$.fragment,e),jn=a(e),B=i(e,"DIV",{class:!0});var Y=Z(B);m(Ve.$$.fragment,Y),Rn=a(Y),it=i(Y,"P",{"data-svelte-h":!0}),d(it)!=="svelte-13s74fx"&&(it.innerHTML=Qo),Bn=a(Y),lt=i(Y,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-relmed"&&(lt.innerHTML=So),Y.forEach(n),Cn=a(e),m(Ye.$$.fragment,e),Jn=a(e),C=i(e,"DIV",{class:!0});var G=Z(C);m(Ee.$$.fragment,G),qn=a(G),dt=i(G,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1r6oiyt"&&(dt.innerHTML=Po),Vn=a(G),ct=i(G,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-relmed"&&(ct.innerHTML=Do),Yn=a(G),m(E.$$.fragment,G),En=a(G),H=i(G,"DIV",{class:!0});var at=Z(H);m(He.$$.fragment,at),Hn=a(at),pt=i(at,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1vq4tq"&&(pt.innerHTML=Ao),at.forEach(n),G.forEach(n),Un=a(e),m(Le.$$.fragment,e),Zn=a(e),J=i(e,"DIV",{class:!0});var x=Z(J);m(Qe.$$.fragment,x),Ln=a(x),mt=i(x,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-12wttjh"&&(mt.textContent=Oo),Qn=a(x),ut=i(x,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-tz7o9k"&&(ut.innerHTML=Ko),Sn=a(x),L=i(x,"DIV",{class:!0});var rt=Z(L);m(Se.$$.fragment,rt),Pn=a(rt),ht=i(rt,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1ho9dsz"&&(ht.innerHTML=es),rt.forEach(n),Dn=a(x),Q=i(x,"DIV",{class:!0});var Xn=Z(Q);m(Pe.$$.fragment,Xn),An=a(Xn),gt=i(Xn,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1e6fezr"&&(gt.innerHTML=ts),Xn.forEach(n),x.forEach(n),$n=a(e),m(De.$$.fragment,e),Gn=a(e),T=i(e,"DIV",{class:!0});var z=Z(T);m(Ae.$$.fragment,z),On=a(z),ft=i(z,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-kxc9tj"&&(ft.textContent=ns),Kn=a(z),_t=i(z,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-57mglp"&&(_t.innerHTML=os),eo=a(z),Mt=i(z,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1g2rcm0"&&(Mt.innerHTML=ss),to=a(z),bt=i(z,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-hswkmf"&&(bt.innerHTML=as),no=a(z),q=i(z,"DIV",{class:!0});var Gt=Z(q);m(Oe.$$.fragment,Gt),oo=a(Gt),yt=i(Gt,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1lz7igm"&&(yt.innerHTML=rs),so=a(Gt),m(S.$$.fragment,Gt),Gt.forEach(n),z.forEach(n),xn=a(e),m(Ke.$$.fragment,e),Fn=a(e),w=i(e,"DIV",{class:!0});var N=Z(w);m(et.$$.fragment,N),ao=a(N),vt=i(N,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1l370y5"&&(vt.textContent=is),ro=a(N),Tt=i(N,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-57mglp"&&(Tt.innerHTML=ls),io=a(N),wt=i(N,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1g2rcm0"&&(wt.innerHTML=ds),lo=a(N),kt=i(N,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-hswkmf"&&(kt.innerHTML=cs),co=a(N),V=i(N,"DIV",{class:!0});var xt=Z(V);m(tt.$$.fragment,xt),po=a(xt),jt=i(xt,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-hkmg6e"&&(jt.innerHTML=ps),mo=a(xt),m(P.$$.fragment,xt),xt.forEach(n),N.forEach(n),Wn=a(e),m(nt.$$.fragment,e),zn=a(e),k=i(e,"DIV",{class:!0});var I=Z(k);m(ot.$$.fragment,I),uo=a(I),Ct=i(I,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-r0yen0"&&(Ct.textContent=ms),ho=a(I),Jt=i(I,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-57mglp"&&(Jt.innerHTML=us),go=a(I),Ut=i(I,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1g2rcm0"&&(Ut.innerHTML=hs),fo=a(I),Zt=i(I,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-hswkmf"&&(Zt.innerHTML=gs),_o=a(I),W=i(I,"DIV",{class:!0});var O=Z(W);m(st.$$.fragment,O),Mo=a(O),$t=i(O,"P",{"data-svelte-h":!0}),d($t)!=="svelte-166fiui"&&($t.innerHTML=fs),bo=a(O),m(D.$$.fragment,O),yo=a(O),m(A.$$.fragment,O),O.forEach(n),I.forEach(n),Nn=a(e),Ft=i(e,"P",{}),Z(Ft).forEach(n),this.h()},h(){$(c,"name","hf:doc:metadata"),$(c,"content",Zs),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,c),o(e,y,t),o(e,M,t),o(e,b,t),u(v,e,t),o(e,_,t),u(j,e,t),o(e,zt,t),o(e,K,t),o(e,Nt,t),o(e,ee,t),o(e,It,t),o(e,te,t),o(e,Xt,t),o(e,ne,t),o(e,Rt,t),o(e,oe,t),o(e,Bt,t),o(e,se,t),o(e,qt,t),u(ae,e,t),o(e,Vt,t),o(e,re,t),o(e,Yt,t),u(ie,e,t),o(e,Et,t),u(le,e,t),o(e,Ht,t),o(e,de,t),o(e,Lt,t),o(e,ce,t),o(e,Qt,t),o(e,pe,t),o(e,St,t),u(me,e,t),o(e,Pt,t),o(e,ue,t),o(e,Dt,t),u(he,e,t),o(e,At,t),o(e,ge,t),o(e,Ot,t),u(fe,e,t),o(e,Kt,t),o(e,_e,t),o(e,en,t),u(Me,e,t),o(e,tn,t),u(be,e,t),o(e,nn,t),o(e,ye,t),o(e,on,t),u(ve,e,t),o(e,sn,t),o(e,Te,t),o(e,an,t),u(we,e,t),o(e,rn,t),o(e,ke,t),o(e,ln,t),u(je,e,t),o(e,dn,t),u(Ce,e,t),o(e,cn,t),o(e,Je,t),o(e,pn,t),u(Ue,e,t),o(e,mn,t),u(Ze,e,t),o(e,un,t),o(e,$e,t),o(e,hn,t),u(Ge,e,t),o(e,gn,t),o(e,xe,t),o(e,fn,t),u(Fe,e,t),o(e,_n,t),o(e,We,t),o(e,Mn,t),o(e,ze,t),o(e,bn,t),o(e,Ne,t),o(e,yn,t),u(Ie,e,t),o(e,vn,t),o(e,Xe,t),o(e,Tn,t),o(e,Re,t),o(e,wn,t),o(e,Be,t),o(e,kn,t),u(qe,e,t),o(e,jn,t),o(e,B,t),u(Ve,B,null),l(B,Rn),l(B,it),l(B,Bn),l(B,lt),o(e,Cn,t),u(Ye,e,t),o(e,Jn,t),o(e,C,t),u(Ee,C,null),l(C,qn),l(C,dt),l(C,Vn),l(C,ct),l(C,Yn),u(E,C,null),l(C,En),l(C,H),u(He,H,null),l(H,Hn),l(H,pt),o(e,Un,t),u(Le,e,t),o(e,Zn,t),o(e,J,t),u(Qe,J,null),l(J,Ln),l(J,mt),l(J,Qn),l(J,ut),l(J,Sn),l(J,L),u(Se,L,null),l(L,Pn),l(L,ht),l(J,Dn),l(J,Q),u(Pe,Q,null),l(Q,An),l(Q,gt),o(e,$n,t),u(De,e,t),o(e,Gn,t),o(e,T,t),u(Ae,T,null),l(T,On),l(T,ft),l(T,Kn),l(T,_t),l(T,eo),l(T,Mt),l(T,to),l(T,bt),l(T,no),l(T,q),u(Oe,q,null),l(q,oo),l(q,yt),l(q,so),u(S,q,null),o(e,xn,t),u(Ke,e,t),o(e,Fn,t),o(e,w,t),u(et,w,null),l(w,ao),l(w,vt),l(w,ro),l(w,Tt),l(w,io),l(w,wt),l(w,lo),l(w,kt),l(w,co),l(w,V),u(tt,V,null),l(V,po),l(V,jt),l(V,mo),u(P,V,null),o(e,Wn,t),u(nt,e,t),o(e,zn,t),o(e,k,t),u(ot,k,null),l(k,uo),l(k,Ct),l(k,ho),l(k,Jt),l(k,go),l(k,Ut),l(k,fo),l(k,Zt),l(k,_o),l(k,W),u(st,W,null),l(W,Mo),l(W,$t),l(W,bo),u(D,W,null),l(W,yo),u(A,W,null),o(e,Nn,t),o(e,Ft,t),In=!0},p(e,[t]){const Y={};t&2&&(Y.$$scope={dirty:t,ctx:e}),E.$set(Y);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),S.$set(G);const at={};t&2&&(at.$$scope={dirty:t,ctx:e}),P.$set(at);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),D.$set(x);const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),A.$set(rt)},i(e){In||(h(v.$$.fragment,e),h(j.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(le.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(Me.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(we.$$.fragment,e),h(je.$$.fragment,e),h(Ce.$$.fragment,e),h(Ue.$$.fragment,e),h(Ze.$$.fragment,e),h(Ge.$$.fragment,e),h(Fe.$$.fragment,e),h(Ie.$$.fragment,e),h(qe.$$.fragment,e),h(Ve.$$.fragment,e),h(Ye.$$.fragment,e),h(Ee.$$.fragment,e),h(E.$$.fragment,e),h(He.$$.fragment,e),h(Le.$$.fragment,e),h(Qe.$$.fragment,e),h(Se.$$.fragment,e),h(Pe.$$.fragment,e),h(De.$$.fragment,e),h(Ae.$$.fragment,e),h(Oe.$$.fragment,e),h(S.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(P.$$.fragment,e),h(nt.$$.fragment,e),h(ot.$$.fragment,e),h(st.$$.fragment,e),h(D.$$.fragment,e),h(A.$$.fragment,e),In=!0)},o(e){g(v.$$.fragment,e),g(j.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(le.$$.fragment,e),g(me.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(Me.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(je.$$.fragment,e),g(Ce.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),g(Ge.$$.fragment,e),g(Fe.$$.fragment,e),g(Ie.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(Ye.$$.fragment,e),g(Ee.$$.fragment,e),g(E.$$.fragment,e),g(He.$$.fragment,e),g(Le.$$.fragment,e),g(Qe.$$.fragment,e),g(Se.$$.fragment,e),g(Pe.$$.fragment,e),g(De.$$.fragment,e),g(Ae.$$.fragment,e),g(Oe.$$.fragment,e),g(S.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(P.$$.fragment,e),g(nt.$$.fragment,e),g(ot.$$.fragment,e),g(st.$$.fragment,e),g(D.$$.fragment,e),g(A.$$.fragment,e),In=!1},d(e){e&&(n(y),n(M),n(b),n(_),n(zt),n(K),n(Nt),n(ee),n(It),n(te),n(Xt),n(ne),n(Rt),n(oe),n(Bt),n(se),n(qt),n(Vt),n(re),n(Yt),n(Et),n(Ht),n(de),n(Lt),n(ce),n(Qt),n(pe),n(St),n(Pt),n(ue),n(Dt),n(At),n(ge),n(Ot),n(Kt),n(_e),n(en),n(tn),n(nn),n(ye),n(on),n(sn),n(Te),n(an),n(rn),n(ke),n(ln),n(dn),n(cn),n(Je),n(pn),n(mn),n(un),n($e),n(hn),n(gn),n(xe),n(fn),n(_n),n(We),n(Mn),n(ze),n(bn),n(Ne),n(yn),n(vn),n(Xe),n(Tn),n(Re),n(wn),n(Be),n(kn),n(jn),n(B),n(Cn),n(Jn),n(C),n(Un),n(Zn),n(J),n($n),n(Gn),n(T),n(xn),n(Fn),n(w),n(Wn),n(zn),n(k),n(Nn),n(Ft)),n(c),f(v,e),f(j,e),f(ae,e),f(ie,e),f(le,e),f(me,e),f(he,e),f(fe,e),f(Me,e),f(be,e),f(ve,e),f(we,e),f(je,e),f(Ce,e),f(Ue,e),f(Ze,e),f(Ge,e),f(Fe,e),f(Ie,e),f(qe,e),f(Ve),f(Ye,e),f(Ee),f(E),f(He),f(Le,e),f(Qe),f(Se),f(Pe),f(De,e),f(Ae),f(Oe),f(S),f(Ke,e),f(et),f(tt),f(P),f(nt,e),f(ot),f(st),f(D),f(A)}}}const Zs='{"title":"MusicGen","local":"musicgen","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Generation","local":"generation","sections":[{"title":"Unconditional Generation","local":"unconditional-generation","sections":[],"depth":3},{"title":"Text-Conditional Generation","local":"text-conditional-generation","sections":[],"depth":3},{"title":"Audio-Prompted Generation","local":"audio-prompted-generation","sections":[],"depth":3},{"title":"Generation Configuration","local":"generation-configuration","sections":[],"depth":3}],"depth":2},{"title":"Model Structure","local":"model-structure","sections":[],"depth":2},{"title":"MusicgenDecoderConfig","local":"transformers.MusicgenDecoderConfig","sections":[],"depth":2},{"title":"MusicgenConfig","local":"transformers.MusicgenConfig","sections":[],"depth":2},{"title":"MusicgenProcessor","local":"transformers.MusicgenProcessor","sections":[],"depth":2},{"title":"MusicgenModel","local":"transformers.MusicgenModel","sections":[],"depth":2},{"title":"MusicgenForCausalLM","local":"transformers.MusicgenForCausalLM","sections":[],"depth":2},{"title":"MusicgenForConditionalGeneration","local":"transformers.MusicgenForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function $s(F){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends ys{constructor(c){super(),vs(this,c,$s,Us,Ms,{})}}export{Xs as component};
