import{s as Sn,o as Bn,n as Mo}from"../chunks/scheduler.9bc65507.js";import{S as Xn,i as Yn,g as r,s as t,r as h,A as Kn,h as a,f as s,c as n,j as M,u as f,x as m,k as j,y as o,a as c,v as g,d as b,t as _,w as v}from"../chunks/index.707bf1b6.js";import{T as On}from"../chunks/Tip.c2ecdbf4.js";import{D as T}from"../chunks/Docstring.17db21ae.js";import{C as To}from"../chunks/CodeBlock.54a9f38d.js";import{E as Co}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as D}from"../chunks/Heading.342b1fa6.js";function es(E){let d,w="Example:",p,u,x;return u=new To({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEp1a2Vib3hNb2RlbCUyQyUyMEp1a2Vib3hDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwSnVrZWJveCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSnVrZWJveENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEp1a2Vib3hNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JukeboxModel, JukeboxConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Jukebox configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = JukeboxConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = JukeboxModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=r("p"),d.textContent=w,p=t(),h(u.$$.fragment)},l(l){d=a(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=w),p=n(l),f(u.$$.fragment,l)},m(l,J){c(l,d,J),c(l,p,J),g(u,l,J),x=!0},p:Mo,i(l){x||(b(u.$$.fragment,l),x=!0)},o(l){_(u.$$.fragment,l),x=!1},d(l){l&&(s(d),s(p)),v(u,l)}}}function os(E){let d,w;return d=new To({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEp1a2Vib3hUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBKdWtlYm94VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZqdWtlYm94LTFiLWx5cmljcyUyMiklMEF0b2tlbml6ZXIoJTIyQWxhbiUyMEphY2tzb24lMjIlMkMlMjAlMjJDb3VudHJ5JTIwUm9jayUyMiUyQyUyMCUyMm9sZCUyMHRvd24lMjByb2FkJTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JukeboxTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = JukeboxTokenizer.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;Alan Jackson&quot;</span>, <span class="hljs-string">&quot;Country Rock&quot;</span>, <span class="hljs-string">&quot;old town road&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
[tensor([[   <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>, <span class="hljs-number">6785</span>,  <span class="hljs-number">546</span>,   <span class="hljs-number">41</span>,   <span class="hljs-number">38</span>,   <span class="hljs-number">30</span>,   <span class="hljs-number">76</span>,   <span class="hljs-number">46</span>,   <span class="hljs-number">41</span>,   <span class="hljs-number">49</span>,
           <span class="hljs-number">40</span>,   <span class="hljs-number">76</span>,   <span class="hljs-number">44</span>,   <span class="hljs-number">41</span>,   <span class="hljs-number">27</span>,   <span class="hljs-number">30</span>]]), tensor([[  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, <span class="hljs-number">145</span>,   <span class="hljs-number">0</span>]]), tensor([[  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, <span class="hljs-number">145</span>,   <span class="hljs-number">0</span>]])]`,wrap:!1}}),{c(){h(d.$$.fragment)},l(p){f(d.$$.fragment,p)},m(p,u){g(d,p,u),w=!0},p:Mo,i(p){w||(b(d.$$.fragment,p),w=!0)},o(p){_(d.$$.fragment,p),w=!1},d(p){v(d,p)}}}function ts(E){let d,w="If nothing is provided, the genres and the artist will either be selected randomly or set to None";return{c(){d=r("p"),d.textContent=w},l(p){d=a(p,"P",{"data-svelte-h":!0}),m(d)!=="svelte-jodoey"&&(d.textContent=w)},m(p,u){c(p,d,u)},p:Mo,d(p){p&&s(d)}}}function ns(E){let d,w="Example:",p,u,x;return u=new To({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBKdWtlYm94TW9kZWwlMkMlMjBzZXRfc2VlZCUwQSUwQW1vZGVsJTIwJTNEJTIwSnVrZWJveE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZqdWtlYm94LTFiLWx5cmljcyUyMiUyQyUyMG1pbl9kdXJhdGlvbiUzRDApLmV2YWwoKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmp1a2Vib3gtMWItbHlyaWNzJTIyKSUwQSUwQWx5cmljcyUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGF3YWtlJTNGJTIwQ2FuJTIweW91JTIwdGFsayUyMHRvJTIwbWUlM0YlMjIlMEFhcnRpc3QlMjAlM0QlMjAlMjJaYWMlMjBCcm93biUyMEJhbmQlMjIlMEFnZW5yZSUyMCUzRCUyMCUyMkNvdW50cnklMjIlMEFtZXRhcyUyMCUzRCUyMHRva2VuaXplcihhcnRpc3QlM0RhcnRpc3QlMkMlMjBnZW5yZXMlM0RnZW5yZSUyQyUyMGx5cmljcyUzRGx5cmljcyklMEFzZXRfc2VlZCgwKSUwQW11c2ljX3Rva2VucyUyMCUzRCUyMG1vZGVsLmFuY2VzdHJhbF9zYW1wbGUobWV0YXMuaW5wdXRfaWRzJTJDJTIwc2FtcGxlX2xlbmd0aCUzRDQwMCklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwuZGVjb2RlKG11c2ljX3Rva2VucyklNUIlM0ElMkMlMjAlM0ExMCU1RC5zcXVlZXplKC0xKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, JukeboxModel, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = JukeboxModel.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>, min_duration=<span class="hljs-number">0</span>).<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>lyrics = <span class="hljs-string">&quot;Hey, are you awake? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>artist = <span class="hljs-string">&quot;Zac Brown Band&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>genre = <span class="hljs-string">&quot;Country&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metas = tokenizer(artist=artist, genres=genre, lyrics=lyrics)
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>music_tokens = model.ancestral_sample(metas.input_ids, sample_length=<span class="hljs-number">400</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    model.decode(music_tokens)[:, :<span class="hljs-number">10</span>].squeeze(-<span class="hljs-number">1</span>)
tensor([[-<span class="hljs-number">0.0219</span>, -<span class="hljs-number">0.0679</span>, -<span class="hljs-number">0.1050</span>, -<span class="hljs-number">0.1203</span>, -<span class="hljs-number">0.1271</span>, -<span class="hljs-number">0.0936</span>, -<span class="hljs-number">0.0396</span>, -<span class="hljs-number">0.0405</span>,
    -<span class="hljs-number">0.0818</span>, -<span class="hljs-number">0.0697</span>]])`,wrap:!1}}),{c(){d=r("p"),d.textContent=w,p=t(),h(u.$$.fragment)},l(l){d=a(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=w),p=n(l),f(u.$$.fragment,l)},m(l,J){c(l,d,J),c(l,p,J),g(u,l,J),x=!0},p:Mo,i(l){x||(b(u.$$.fragment,l),x=!0)},o(l){_(u.$$.fragment,l),x=!1},d(l){l&&(s(d),s(p)),v(u,l)}}}function ss(E){let d,w="Example:",p,u,x;return u=new To({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBKdWtlYm94TW9kZWwlMkMlMjBzZXRfc2VlZCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbWV0YXMlMjAlM0QlMjBkaWN0KGFydGlzdCUzRCUyMlphYyUyMEJyb3duJTIwQmFuZCUyMiUyQyUyMGdlbnJlcyUzRCUyMkNvdW50cnklMjIlMkMlMjBseXJpY3MlM0QlMjJJJTIwbWV0JTIwYSUyMHRyYXZlbGxlciUyMGZyb20lMjBhbiUyMGFudGlxdWUlMjBsYW5kJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmp1a2Vib3gtMWItbHlyaWNzJTIyKSUwQW1vZGVsJTIwJTNEJTIwSnVrZWJveE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZqdWtlYm94LTFiLWx5cmljcyUyMiUyQyUyMG1pbl9kdXJhdGlvbiUzRDApLmV2YWwoKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRva2VuaXplcigqKm1ldGFzKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQXNldF9zZWVkKDApJTBBenMlMjAlM0QlMjAlNUJ0b3JjaC56ZXJvcygxJTJDJTIwMCUyQyUyMGR0eXBlJTNEdG9yY2gubG9uZyklMjBmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSU1RCUwQXpzJTIwJTNEJTIwbW9kZWwuX3NhbXBsZSh6cyUyQyUyMGxhYmVscyUyQyUyMCU1QjAlNUQlMkMlMjBzYW1wbGVfbGVuZ3RoJTNENDAlMjAqJTIwbW9kZWwucHJpb3JzJTVCMCU1RC5yYXdfdG9fdG9rZW5zJTJDJTIwc2F2ZV9yZXN1bHRzJTNERmFsc2UpJTBBenMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, JukeboxModel, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>metas = <span class="hljs-built_in">dict</span>(artist=<span class="hljs-string">&quot;Zac Brown Band&quot;</span>, genres=<span class="hljs-string">&quot;Country&quot;</span>, lyrics=<span class="hljs-string">&quot;I met a traveller from an antique land&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = JukeboxModel.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>, min_duration=<span class="hljs-number">0</span>).<span class="hljs-built_in">eval</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(**metas)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>zs = [torch.zeros(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, dtype=torch.long) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>)]
<span class="hljs-meta">&gt;&gt;&gt; </span>zs = model._sample(zs, labels, [<span class="hljs-number">0</span>], sample_length=<span class="hljs-number">40</span> * model.priors[<span class="hljs-number">0</span>].raw_to_tokens, save_results=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>zs[<span class="hljs-number">0</span>]
tensor([[<span class="hljs-number">1853</span>, <span class="hljs-number">1369</span>, <span class="hljs-number">1150</span>, <span class="hljs-number">1869</span>, <span class="hljs-number">1379</span>, <span class="hljs-number">1789</span>,  <span class="hljs-number">519</span>,  <span class="hljs-number">710</span>, <span class="hljs-number">1306</span>, <span class="hljs-number">1100</span>, <span class="hljs-number">1229</span>,  <span class="hljs-number">519</span>,
      <span class="hljs-number">353</span>, <span class="hljs-number">1306</span>, <span class="hljs-number">1379</span>, <span class="hljs-number">1053</span>,  <span class="hljs-number">519</span>,  <span class="hljs-number">653</span>, <span class="hljs-number">1631</span>, <span class="hljs-number">1467</span>, <span class="hljs-number">1229</span>, <span class="hljs-number">1229</span>,   <span class="hljs-number">10</span>, <span class="hljs-number">1647</span>,
     <span class="hljs-number">1254</span>, <span class="hljs-number">1229</span>, <span class="hljs-number">1306</span>, <span class="hljs-number">1528</span>, <span class="hljs-number">1789</span>,  <span class="hljs-number">216</span>, <span class="hljs-number">1631</span>, <span class="hljs-number">1434</span>,  <span class="hljs-number">653</span>,  <span class="hljs-number">475</span>, <span class="hljs-number">1150</span>, <span class="hljs-number">1528</span>,
     <span class="hljs-number">1804</span>,  <span class="hljs-number">541</span>, <span class="hljs-number">1804</span>, <span class="hljs-number">1434</span>]])`,wrap:!1}}),{c(){d=r("p"),d.textContent=w,p=t(),h(u.$$.fragment)},l(l){d=a(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=w),p=n(l),f(u.$$.fragment,l)},m(l,J){c(l,d,J),c(l,p,J),g(u,l,J),x=!0},p:Mo,i(l){x||(b(u.$$.fragment,l),x=!0)},o(l){_(u.$$.fragment,l),x=!1},d(l){l&&(s(d),s(p)),v(u,l)}}}function rs(E){let d,w="Example:",p,u,x;return u=new To({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEp1a2Vib3hWUVZBRSUyQyUyMHNldF9zZWVkJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMEp1a2Vib3hWUVZBRS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGanVrZWJveC0xYi1seXJpY3MlMjIpLmV2YWwoKSUwQXNldF9zZWVkKDApJTBBenMlMjAlM0QlMjAlNUJ0b3JjaC5yYW5kaW50KDEwMCUyQyUyMCg0JTJDJTIwMSkpJTVEJTBBbW9kZWwuZGVjb2RlKHpzKS5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JukeboxVQVAE, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = JukeboxVQVAE.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>).<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>zs = [torch.randint(<span class="hljs-number">100</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">1</span>))]
<span class="hljs-meta">&gt;&gt;&gt; </span>model.decode(zs).shape
torch.Size([<span class="hljs-number">4</span>, <span class="hljs-number">8</span>, <span class="hljs-number">1</span>])`,wrap:!1}}),{c(){d=r("p"),d.textContent=w,p=t(),h(u.$$.fragment)},l(l){d=a(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=w),p=n(l),f(u.$$.fragment,l)},m(l,J){c(l,d,J),c(l,p,J),g(u,l,J),x=!0},p:Mo,i(l){x||(b(u.$$.fragment,l),x=!0)},o(l){_(u.$$.fragment,l),x=!1},d(l){l&&(s(d),s(p)),v(u,l)}}}function as(E){let d,w,p,u,x,l,J,Vo,ie,rn=`The Jukebox model was proposed in <a href="https://arxiv.org/pdf/2005.00341.pdf" rel="nofollow">Jukebox: A generative model for music</a>
by Prafulla Dhariwal, Heewoo Jun, Christine Payne, Jong Wook Kim, Alec Radford,
Ilya Sutskever. It introduces a generative music model which can produce minute long samples that can be conditioned on
an artist, genres and lyrics.`,Po,le,an="The abstract from the paper is the following:",Uo,de,ln="<em>We introduce Jukebox, a model that generates music with singing in the raw audio domain. We tackle the long context of raw audio using a multiscale VQ-VAE to compress it to discrete codes, and modeling those using autoregressive Transformers. We show that the combined model at scale can generate high-fidelity and diverse songs with coherence up to multiple minutes. We can condition on artist and genre to steer the musical and vocal style, and on unaligned lyrics to make the singing more controllable. We are releasing thousands of non cherry-picked samples, along with model weights and code.</em>",Eo,ce,dn=`As shown on the following figure, Jukebox is made of 3 <code>priors</code> which are decoder only models. They follow the architecture described in <a href="https://arxiv.org/abs/1904.10509" rel="nofollow">Generating Long Sequences with Sparse Transformers</a>, modified to support longer context length.
First, a autoencoder is used to encode the text lyrics. Next, the first (also called <code>top_prior</code>) prior attends to the last hidden states extracted from the lyrics encoder. The priors are linked to the previous priors respectively via an <code>AudioConditionner</code> module. The<code>AudioConditioner</code> upsamples the outputs of the previous prior to raw tokens at a certain audio frame per second resolution.
The metadata such as <em>artist, genre and timing</em> are passed to each prior, in the form of a start token and positional embedding for the timing data.  The hidden states are mapped to the closest codebook vector from the VQVAE in order to convert them to raw audio.`,zo,me,cn='<img src="https://gist.githubusercontent.com/ArthurZucker/92c1acaae62ebf1b6a951710bdd8b6af/raw/c9c517bf4eff61393f6c7dec9366ef02bdd059a3/jukebox.svg" alt="JukeboxModel"/>',Lo,pe,mn="Tips:",Ao,ue,pn="<li>This model only supports inference. This is for a few reasons, mostly because it requires a crazy amount of memory to train. Feel free to open a PR and add what’s missing to have a full integration with the hugging face traineer!</li> <li>This model is very slow, and takes 8h to generate a minute long audio using the 5b top prior on a V100 GPU. In order automaticallay handle the device on which the model should execute, use <code>accelerate</code>.</li> <li>Contrary to the paper, the order of the priors goes from <code>0</code> to <code>1</code> as it felt more intuitive : we sample starting from <code>0</code>.</li> <li>Primed sampling (conditioning the sampling on raw audio) requires more memory than ancestral sampling and should be used with <code>fp16</code> set to <code>True</code>.</li>",Wo,he,un=`This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a>.
The original code can be found <a href="https://github.com/openai/jukebox" rel="nofollow">here</a>.`,Qo,fe,Io,P,ge,it,De,hn='This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.2/en/model_doc/jukebox#transformers.JukeboxModel">JukeboxModel</a>.',lt,Re,fn=`Configuration objects inherit from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information. Instantiating a configuration with the defaults will
yield a similar configuration to that of
<a href="https://huggingface.co/openai/jukebox-1b-lyrics" rel="nofollow">openai/jukebox-1b-lyrics</a> architecture.`,dt,Ne,gn=`The downsampling and stride are used to determine downsampling of the input sequence. For example, downsampling =
(5,3), and strides = (2, 2) will downsample the audio by 2^5 = 32 to get the first level of codes, and 2**8 = 256
to get the second level codes. This is mostly true for training the top level prior and the upsamplers.`,ct,R,mt,N,be,pt,Ge,bn=`Instantiate a <a href="/docs/transformers/v4.35.2/en/model_doc/jukebox#transformers.JukeboxConfig">JukeboxConfig</a> (or a derived class) from clip text model configuration and clip vision model
configuration.`,qo,_e,Zo,W,ve,ut,Fe,_n=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.2/en/model_doc/jukebox#transformers.JukeboxPrior">JukeboxPrior</a>. It is used to instantiate a
<code>JukeboxPrior</code> according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the top level prior from the
[openai/jukebox-1b-lyrics](<a href="https://huggingface.co/openai/jukebox" rel="nofollow">https://huggingface.co/openai/jukebox</a>
-1b-lyrics) architecture.`,ht,Se,vn=`Configuration objects inherit from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ho,xe,Do,Q,ke,ft,Be,xn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.2/en/model_doc/jukebox#transformers.JukeboxVQVAE">JukeboxVQVAE</a>. It is used to instantiate a
<code>JukeboxVQVAE</code> according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the VQVAE from
<a href="https://huggingface.co/openai/jukebox-1b-lyrics" rel="nofollow">openai/jukebox-1b-lyrics</a> architecture.`,gt,Xe,kn=`Configuration objects inherit from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ro,ye,No,k,we,bt,Ye,yn="Constructs a Jukebox tokenizer. Jukebox can be conditioned on 3 different inputs :",_t,Ke,wn=`<li>Artists, unique ids are associated to each artist from the provided dictionary.</li> <li>Genres, unique ids are associated to each genre from the provided dictionary.</li> <li>Lyrics, character based tokenization. Must be initialized with the list of characters that are inside the
vocabulary.</li>`,vt,Oe,Jn=`This tokenizer does not require training. It should be able to process a different number of inputs:
as the conditioning of the model can be done on the three different queries. If None is provided, defaults values will be used.:`,xt,eo,$n="Depending on the number of genres on which the model should be conditioned (<code>n_genres</code>).",kt,G,yt,oo,Mn=`You can get around that behavior by passing <code>add_prefix_space=True</code> when instantiating this tokenizer or when you
call it on some text, but since the model was not pretrained this way, it might yield a decrease in performance.`,wt,F,Jt,to,jn=`This tokenizer inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to:
this superclass for more information regarding those methods.`,$t,no,Cn="However the code does not allow that and only supports composing from various genres.",Mt,S,Je,jt,so,Tn="Saves the tokenizer’s vocabulary dictionary to the provided save_directory.",Go,$e,Fo,$,Me,Ct,ro,Vn=`The bare JUKEBOX Model used for music generation. 4 sampling techniques are supported : <code>primed_sample</code>, <code>upsample</code>,
<code>continue_sample</code> and <code>ancestral_sample</code>. It does not have a <code>forward</code> method as the training is not end to end. If
you want to fine-tune the model, it is recommended to use the <code>JukeboxPrior</code> class and train each prior
individually.`,Tt,ao,Pn=`This model inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vt,io,Un=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pt,I,je,Ut,lo,En="Generates music tokens based on the provided <code>labels. Will start at the desired prior level and automatically upsample the sequence. If you want to create the audio, you should call </code>model.decode(tokens)`, which will use\nthe VQ-VAE decoder to convert the music tokens to raw audio.",Et,B,zt,X,Ce,Lt,co,zn=`Generate a raw audio conditioned on the provided <code>raw_audio</code> which is used as conditioning at each of the
generation levels. The audio is encoded to music tokens using the 3 levels of the VQ-VAE. These tokens are
used: as conditioning for each level, which means that no ancestral sampling is required.`,At,Y,Te,Wt,mo,Ln="Generates a continuation of the previously generated tokens.",Qt,K,Ve,It,po,An="Upsamples a sequence of music tokens using the prior at level <code>level</code>.",qt,A,Pe,Zt,uo,Wn=`Core sampling function used to generate music tokens. Iterates over the provided list of levels, while saving
the generated raw audio at each step.`,Ht,ho,Qn="Returns: torch.Tensor",Dt,O,So,Ue,Bo,L,Ee,Rt,fo,In=`The JukeboxPrior class, which is a wrapper around the various conditioning and the transformer. JukeboxPrior can be
seen as language models trained on music. They model the next <code>music token</code> prediction task. If a (lyric) <code>encoderù is defined, it also models the </code>next character\` prediction on the lyrics. Can be conditionned on timing, artist,
genre, lyrics and codes from lower-levels Priors.`,Nt,ee,ze,Gt,go,qn="Ancestral/Prime sampling a window of tokens using the provided conditioning and metadatas.",Ft,oe,Le,St,bo,Zn=`Encode the hidden states using the <code>vqvae</code> encoder, and then predicts the next token in the <code>forward_tokens</code>
function. The loss is the sum of the <code>encoder</code> loss and the <code>decoder</code> loss.`,Xo,Ae,Yo,C,We,Bt,_o,Hn=`The Hierarchical VQ-VAE model used in Jukebox. This model follows the Hierarchical VQVAE paper from <a href="https://arxiv.org/abs/2002.08111" rel="nofollow">Will Williams, Sam
Ringer, Tom Ash, John Hughes, David MacLeod, Jamie Dougherty</a>.`,Xt,vo,Dn=`This model inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Yt,xo,Rn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Kt,q,Qe,Ot,ko,Nn=`Forward pass of the VQ-VAE, encodes the <code>raw_audio</code> to latent states, which are then decoded for each level.
The commit loss, which ensure that the encoder’s computed embeddings are close to the codebook vectors, is
computed.`,en,te,on,ne,Ie,tn,yo,Gn="Transforms the <code>input_audio</code> to a discrete representation made out of <code>music_tokens</code>.",nn,se,qe,sn,wo,Fn="Transforms the input <code>music_tokens</code> to their <code>raw_audio</code> representation.",Ko,jo,Oo;return x=new D({props:{title:"Jukebox",local:"jukebox",headingTag:"h1"}}),J=new D({props:{title:"Overview",local:"overview",headingTag:"h2"}}),fe=new D({props:{title:"JukeboxConfig",local:"transformers.JukeboxConfig",headingTag:"h2"}}),ge=new T({props:{name:"class transformers.JukeboxConfig",anchor:"transformers.JukeboxConfig",parameters:[{name:"vqvae_config",val:" = None"},{name:"prior_config_list",val:" = None"},{name:"nb_priors",val:" = 3"},{name:"sampling_rate",val:" = 44100"},{name:"timing_dims",val:" = 64"},{name:"min_duration",val:" = 0"},{name:"max_duration",val:" = 600.0"},{name:"max_nb_genres",val:" = 5"},{name:"metadata_conditioning",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxConfig.vqvae_config",description:`<strong>vqvae_config</strong> (<code>JukeboxVQVAEConfig</code>, <em>optional</em>) &#x2014;
Configuration for the <code>JukeboxVQVAE</code> model.`,name:"vqvae_config"},{anchor:"transformers.JukeboxConfig.prior_config_list",description:`<strong>prior_config_list</strong> (<code>List[JukeboxPriorConfig]</code>, <em>optional</em>) &#x2014;
List of the configs for each of the <code>JukeboxPrior</code> of the model. The original architecture uses 3 priors.`,name:"prior_config_list"},{anchor:"transformers.JukeboxConfig.nb_priors",description:`<strong>nb_priors</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of prior models that will sequentially sample tokens. Each prior is conditional auto regressive
(decoder) model, apart from the top prior, which can include a lyric encoder. The available models were
trained using a top prior and 2 upsampler priors.`,name:"nb_priors"},{anchor:"transformers.JukeboxConfig.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 44100) &#x2014;
Sampling rate of the raw audio.`,name:"sampling_rate"},{anchor:"transformers.JukeboxConfig.timing_dims",description:`<strong>timing_dims</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensions of the JukeboxRangeEmbedding layer which is equivalent to traditional positional embedding
layer. The timing embedding layer converts the absolute and relative position in the currently sampled
audio to a tensor of length <code>timing_dims</code> that will be added to the music tokens.`,name:"timing_dims"},{anchor:"transformers.JukeboxConfig.min_duration",description:`<strong>min_duration</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Minimum duration of the audios to generate`,name:"min_duration"},{anchor:"transformers.JukeboxConfig.max_duration",description:`<strong>max_duration</strong> (<code>float</code>, <em>optional</em>, defaults to 600.0) &#x2014;
Maximum duration of the audios to generate`,name:"max_duration"},{anchor:"transformers.JukeboxConfig.max_nb_genres",description:`<strong>max_nb_genres</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Maximum number of genres that can be used to condition a single sample.`,name:"max_nb_genres"},{anchor:"transformers.JukeboxConfig.metadata_conditioning",description:`<strong>metadata_conditioning</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use metadata conditioning, corresponding to the artist, the genre and the min/maximum
duration.`,name:"metadata_conditioning"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/configuration_jukebox.py#L495"}}),R=new Co({props:{anchor:"transformers.JukeboxConfig.example",$$slots:{default:[es]},$$scope:{ctx:E}}}),be=new T({props:{name:"from_configs",anchor:"transformers.JukeboxConfig.from_configs",parameters:[{name:"prior_configs",val:": typing.List[transformers.models.jukebox.configuration_jukebox.JukeboxPriorConfig]"},{name:"vqvae_config",val:": JukeboxVQVAEConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/configuration_jukebox.py#L598",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/model_doc/jukebox#transformers.JukeboxConfig"
>JukeboxConfig</a></p>
`}}),_e=new D({props:{title:"JukeboxPriorConfig",local:"transformers.JukeboxPriorConfig",headingTag:"h2"}}),ve=new T({props:{name:"class transformers.JukeboxPriorConfig",anchor:"transformers.JukeboxPriorConfig",parameters:[{name:"act_fn",val:" = 'quick_gelu'"},{name:"level",val:" = 0"},{name:"alignment_head",val:" = 2"},{name:"alignment_layer",val:" = 68"},{name:"attention_multiplier",val:" = 0.25"},{name:"attention_pattern",val:" = 'enc_dec_with_lyrics'"},{name:"attn_dropout",val:" = 0"},{name:"attn_res_scale",val:" = False"},{name:"blocks",val:" = 64"},{name:"conv_res_scale",val:" = None"},{name:"num_layers",val:" = 72"},{name:"emb_dropout",val:" = 0"},{name:"encoder_config",val:" = None"},{name:"encoder_loss_fraction",val:" = 0.4"},{name:"hidden_size",val:" = 2048"},{name:"init_scale",val:" = 0.2"},{name:"is_encoder_decoder",val:" = True"},{name:"lyric_vocab_size",val:" = 80"},{name:"mask",val:" = False"},{name:"max_duration",val:" = 600"},{name:"max_nb_genres",val:" = 1"},{name:"merged_decoder",val:" = True"},{name:"metadata_conditioning",val:" = True"},{name:"metadata_dims",val:" = [604, 7898]"},{name:"min_duration",val:" = 0"},{name:"mlp_multiplier",val:" = 1.0"},{name:"music_vocab_size",val:" = 2048"},{name:"n_ctx",val:" = 6144"},{name:"n_heads",val:" = 2"},{name:"nb_relevant_lyric_tokens",val:" = 384"},{name:"res_conv_depth",val:" = 3"},{name:"res_conv_width",val:" = 128"},{name:"res_convolution_multiplier",val:" = 1"},{name:"res_dilation_cycle",val:" = None"},{name:"res_dilation_growth_rate",val:" = 1"},{name:"res_downs_t",val:" = [3, 2, 2]"},{name:"res_strides_t",val:" = [2, 2, 2]"},{name:"resid_dropout",val:" = 0"},{name:"sampling_rate",val:" = 44100"},{name:"spread",val:" = None"},{name:"timing_dims",val:" = 64"},{name:"zero_out",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxPriorConfig.act_fn",description:`<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
Activation function.`,name:"act_fn"},{anchor:"transformers.JukeboxPriorConfig.alignment_head",description:`<strong>alignment_head</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Head that is responsible of the alignment between lyrics and music. Only used to compute the lyric to audio
alignment`,name:"alignment_head"},{anchor:"transformers.JukeboxPriorConfig.alignment_layer",description:`<strong>alignment_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 68) &#x2014;
Index of the layer that is responsible of the alignment between lyrics and music. Only used to compute the
lyric to audio alignment`,name:"alignment_layer"},{anchor:"transformers.JukeboxPriorConfig.attention_multiplier",description:`<strong>attention_multiplier</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Multiplier coefficient used to define the hidden dimension of the attention layers. 0.25 means that
0.25*width of the model will be used.`,name:"attention_multiplier"},{anchor:"transformers.JukeboxPriorConfig.attention_pattern",description:`<strong>attention_pattern</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;enc_dec_with_lyrics&quot;</code>) &#x2014;
Which attention pattern to use for the decoder/`,name:"attention_pattern"},{anchor:"transformers.JukeboxPriorConfig.attn_dropout",description:`<strong>attn_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Dropout probability for the post-attention layer dropout in the decoder.`,name:"attn_dropout"},{anchor:"transformers.JukeboxPriorConfig.attn_res_scale",description:`<strong>attn_res_scale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to scale the residuals in the attention conditioner block.`,name:"attn_res_scale"},{anchor:"transformers.JukeboxPriorConfig.blocks",description:`<strong>blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of blocks used in the <code>block_attn</code>. A sequence of length seq_len is factored as <code>[blocks, seq_len // blocks]</code> in the <code>JukeboxAttention</code> layer.`,name:"blocks"},{anchor:"transformers.JukeboxPriorConfig.conv_res_scale",description:`<strong>conv_res_scale</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Whether or not to scale the residuals in the conditioner block. Since the top level prior does not have a
conditioner, the default value is to None and should not be modified.`,name:"conv_res_scale"},{anchor:"transformers.JukeboxPriorConfig.num_layers",description:`<strong>num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 72) &#x2014;
Number of layers of the transformer architecture.`,name:"num_layers"},{anchor:"transformers.JukeboxPriorConfig.emb_dropout",description:`<strong>emb_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Embedding dropout used in the lyric decoder.`,name:"emb_dropout"},{anchor:"transformers.JukeboxPriorConfig.encoder_config",description:`<strong>encoder_config</strong> (<code>JukeboxPriorConfig</code>, <em>optional</em>)  &#x2014;
Configuration of the encoder which models the prior on the lyrics.`,name:"encoder_config"},{anchor:"transformers.JukeboxPriorConfig.encoder_loss_fraction",description:`<strong>encoder_loss_fraction</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
Multiplication factor used in front of the lyric encoder loss.`,name:"encoder_loss_fraction"},{anchor:"transformers.JukeboxPriorConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Hidden dimension of the attention layers.`,name:"hidden_size"},{anchor:"transformers.JukeboxPriorConfig.init_scale",description:`<strong>init_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
Initialization scales for the prior modules.`,name:"init_scale"},{anchor:"transformers.JukeboxPriorConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the prior is an encoder-decoder model. In case it is not, and <code>nb_relevant_lyric_tokens</code> is
greater than 0, the <code>encoder</code> args should be specified for the lyric encoding.`,name:"is_encoder_decoder"},{anchor:"transformers.JukeboxPriorConfig.mask",description:`<strong>mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to mask the previous positions in the attention.`,name:"mask"},{anchor:"transformers.JukeboxPriorConfig.max_duration",description:`<strong>max_duration</strong> (<code>int</code>, <em>optional</em>, defaults to 600) &#x2014;
Maximum supported duration of the generated song in seconds.`,name:"max_duration"},{anchor:"transformers.JukeboxPriorConfig.max_nb_genres",description:`<strong>max_nb_genres</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Maximum number of genres that can be used to condition the model.`,name:"max_nb_genres"},{anchor:"transformers.JukeboxPriorConfig.merged_decoder",description:`<strong>merged_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the decoder and the encoder inputs are merged. This is used for the separated
encoder-decoder architecture`,name:"merged_decoder"},{anchor:"transformers.JukeboxPriorConfig.metadata_conditioning",description:`<strong>metadata_conditioning</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True)</code> &#x2014;
Whether or not to condition on the artist and genre metadata.`,name:"metadata_conditioning"},{anchor:"transformers.JukeboxPriorConfig.metadata_dims",description:`<strong>metadata_dims</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[604, 7898]</code>) &#x2014;
Number of genres and the number of artists that were used to train the embedding layers of the prior
models.`,name:"metadata_dims"},{anchor:"transformers.JukeboxPriorConfig.min_duration",description:`<strong>min_duration</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Minimum duration of the generated audio on which the model was trained.`,name:"min_duration"},{anchor:"transformers.JukeboxPriorConfig.mlp_multiplier",description:`<strong>mlp_multiplier</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Multiplier coefficient used to define the hidden dimension of the MLP layers. 0.25 means that 0.25*width of
the model will be used.`,name:"mlp_multiplier"},{anchor:"transformers.JukeboxPriorConfig.music_vocab_size",description:`<strong>music_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Number of different music tokens. Should be similar to the <code>JukeboxVQVAEConfig.nb_discrete_codes</code>.`,name:"music_vocab_size"},{anchor:"transformers.JukeboxPriorConfig.n_ctx",description:`<strong>n_ctx</strong> (<code>int</code>, <em>optional</em>, defaults to 6144) &#x2014;
Number of context tokens for each prior. The context tokens are the music tokens that are attended to when
generating music tokens.`,name:"n_ctx"},{anchor:"transformers.JukeboxPriorConfig.n_heads",description:`<strong>n_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of attention heads.`,name:"n_heads"},{anchor:"transformers.JukeboxPriorConfig.nb_relevant_lyric_tokens",description:`<strong>nb_relevant_lyric_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
Number of lyric tokens that are used when sampling a single window of length <code>n_ctx</code>`,name:"nb_relevant_lyric_tokens"},{anchor:"transformers.JukeboxPriorConfig.res_conv_depth",description:`<strong>res_conv_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Depth of the <code>JukeboxDecoderConvBock</code> used to upsample the previously sampled audio in the
<code>JukeboxMusicTokenConditioner</code>.`,name:"res_conv_depth"},{anchor:"transformers.JukeboxPriorConfig.res_conv_width",description:`<strong>res_conv_width</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Width of the <code>JukeboxDecoderConvBock</code> used to upsample the previously sampled audio in the
<code>JukeboxMusicTokenConditioner</code>.`,name:"res_conv_width"},{anchor:"transformers.JukeboxPriorConfig.res_convolution_multiplier",description:`<strong>res_convolution_multiplier</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Multiplier used to scale the <code>hidden_dim</code> of the <code>JukeboxResConv1DBlock</code>.`,name:"res_convolution_multiplier"},{anchor:"transformers.JukeboxPriorConfig.res_dilation_cycle",description:`<strong>res_dilation_cycle</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dilation cycle used to define the <code>JukeboxMusicTokenConditioner</code>. Usually similar to the ones used in the
corresponding level of the VQVAE. The first prior does not use it as it is not conditioned on upper level
tokens.`,name:"res_dilation_cycle"},{anchor:"transformers.JukeboxPriorConfig.res_dilation_growth_rate",description:`<strong>res_dilation_growth_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dilation grow rate used between each convolutionnal block of the <code>JukeboxMusicTokenConditioner</code>`,name:"res_dilation_growth_rate"},{anchor:"transformers.JukeboxPriorConfig.res_downs_t",description:`<strong>res_downs_t</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 2, 2]</code>) &#x2014;
Downsampling rates used in the audio conditioning network`,name:"res_downs_t"},{anchor:"transformers.JukeboxPriorConfig.res_strides_t",description:`<strong>res_strides_t</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 2, 2]</code>) &#x2014;
Striding used in the audio conditioning network`,name:"res_strides_t"},{anchor:"transformers.JukeboxPriorConfig.resid_dropout",description:`<strong>resid_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Residual dropout used in the attention pattern.`,name:"resid_dropout"},{anchor:"transformers.JukeboxPriorConfig.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 44100) &#x2014;
Sampling rate used for training.`,name:"sampling_rate"},{anchor:"transformers.JukeboxPriorConfig.spread",description:`<strong>spread</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Spread used in the <code>summary_spread_attention</code> pattern`,name:"spread"},{anchor:"transformers.JukeboxPriorConfig.timing_dims",description:`<strong>timing_dims</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimension of the timing embedding.`,name:"timing_dims"},{anchor:"transformers.JukeboxPriorConfig.zero_out",description:`<strong>zero_out</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to zero out convolution weights when initializing.`,name:"zero_out"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/configuration_jukebox.py#L143"}}),xe=new D({props:{title:"JukeboxVQVAEConfig",local:"transformers.JukeboxVQVAEConfig",headingTag:"h2"}}),ke=new T({props:{name:"class transformers.JukeboxVQVAEConfig",anchor:"transformers.JukeboxVQVAEConfig",parameters:[{name:"act_fn",val:" = 'relu'"},{name:"nb_discrete_codes",val:" = 2048"},{name:"commit",val:" = 0.02"},{name:"conv_input_shape",val:" = 1"},{name:"conv_res_scale",val:" = False"},{name:"embed_dim",val:" = 64"},{name:"hop_fraction",val:" = [0.125, 0.5, 0.5]"},{name:"levels",val:" = 3"},{name:"lmu",val:" = 0.99"},{name:"multipliers",val:" = [2, 1, 1]"},{name:"res_conv_depth",val:" = 4"},{name:"res_conv_width",val:" = 32"},{name:"res_convolution_multiplier",val:" = 1"},{name:"res_dilation_cycle",val:" = None"},{name:"res_dilation_growth_rate",val:" = 3"},{name:"res_downs_t",val:" = [3, 2, 2]"},{name:"res_strides_t",val:" = [2, 2, 2]"},{name:"sample_length",val:" = 1058304"},{name:"init_scale",val:" = 0.2"},{name:"zero_out",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxVQVAEConfig.act_fn",description:`<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
Activation function of the model.`,name:"act_fn"},{anchor:"transformers.JukeboxVQVAEConfig.nb_discrete_codes",description:`<strong>nb_discrete_codes</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Number of codes of the VQVAE.`,name:"nb_discrete_codes"},{anchor:"transformers.JukeboxVQVAEConfig.commit",description:`<strong>commit</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
Commit loss multiplier.`,name:"commit"},{anchor:"transformers.JukeboxVQVAEConfig.conv_input_shape",description:`<strong>conv_input_shape</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of audio channels.`,name:"conv_input_shape"},{anchor:"transformers.JukeboxVQVAEConfig.conv_res_scale",description:`<strong>conv_res_scale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to scale the residuals of the <code>JukeboxResConv1DBlock</code>.`,name:"conv_res_scale"},{anchor:"transformers.JukeboxVQVAEConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Embedding dimension of the codebook vectors.`,name:"embed_dim"},{anchor:"transformers.JukeboxVQVAEConfig.hop_fraction",description:`<strong>hop_fraction</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[0.125, 0.5, 0.5]</code>) &#x2014;
Fraction of non-intersecting window used when continuing the sampling process.`,name:"hop_fraction"},{anchor:"transformers.JukeboxVQVAEConfig.levels",description:`<strong>levels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of hierarchical levels that used in the VQVAE.`,name:"levels"},{anchor:"transformers.JukeboxVQVAEConfig.lmu",description:`<strong>lmu</strong> (<code>float</code>, <em>optional</em>, defaults to 0.99) &#x2014;
Used in the codebook update, exponential moving average coefficient. For more detail refer to Appendix A.1
of the original <a href="https://arxiv.org/pdf/1711.00937v2.pdf" rel="nofollow">VQVAE paper</a>`,name:"lmu"},{anchor:"transformers.JukeboxVQVAEConfig.multipliers",description:`<strong>multipliers</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 1, 1]</code>) &#x2014;
Depth and width multipliers used for each level. Used on the <code>res_conv_width</code> and <code>res_conv_depth</code>`,name:"multipliers"},{anchor:"transformers.JukeboxVQVAEConfig.res_conv_depth",description:`<strong>res_conv_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Depth of the encoder and decoder block. If no <code>multipliers</code> are used, this is the same for each level.`,name:"res_conv_depth"},{anchor:"transformers.JukeboxVQVAEConfig.res_conv_width",description:`<strong>res_conv_width</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Width of the encoder and decoder block. If no <code>multipliers</code> are used, this is the same for each level.`,name:"res_conv_width"},{anchor:"transformers.JukeboxVQVAEConfig.res_convolution_multiplier",description:`<strong>res_convolution_multiplier</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Scaling factor of the hidden dimension used in the <code>JukeboxResConv1DBlock</code>.`,name:"res_convolution_multiplier"},{anchor:"transformers.JukeboxVQVAEConfig.res_dilation_cycle",description:`<strong>res_dilation_cycle</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dilation cycle value used in the <code>JukeboxResnet</code>. If an int is used, each new Conv1 block will have a depth
reduced by a power of <code>res_dilation_cycle</code>.`,name:"res_dilation_cycle"},{anchor:"transformers.JukeboxVQVAEConfig.res_dilation_growth_rate",description:`<strong>res_dilation_growth_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Resnet dilation growth rate used in the VQVAE (dilation_growth_rate ** depth)`,name:"res_dilation_growth_rate"},{anchor:"transformers.JukeboxVQVAEConfig.res_downs_t",description:`<strong>res_downs_t</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 2, 2]</code>) &#x2014;
Downsampling rate for each level of the hierarchical VQ-VAE.`,name:"res_downs_t"},{anchor:"transformers.JukeboxVQVAEConfig.res_strides_t",description:`<strong>res_strides_t</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 2, 2]</code>) &#x2014;
Stride used for each level of the hierarchical VQ-VAE.`,name:"res_strides_t"},{anchor:"transformers.JukeboxVQVAEConfig.sample_length",description:`<strong>sample_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1058304) &#x2014;
Provides the max input shape of the VQVAE. Is used to compute the input shape of each level.`,name:"sample_length"},{anchor:"transformers.JukeboxVQVAEConfig.init_scale",description:`<strong>init_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
Initialization scale.`,name:"init_scale"},{anchor:"transformers.JukeboxVQVAEConfig.zero_out",description:`<strong>zero_out</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to zero out convolution weights when initializing.`,name:"zero_out"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/configuration_jukebox.py#L372"}}),ye=new D({props:{title:"JukeboxTokenizer",local:"transformers.JukeboxTokenizer",headingTag:"h2"}}),we=new T({props:{name:"class transformers.JukeboxTokenizer",anchor:"transformers.JukeboxTokenizer",parameters:[{name:"artists_file",val:""},{name:"genres_file",val:""},{name:"lyrics_file",val:""},{name:"version",val:" = ['v3', 'v2', 'v2']"},{name:"max_n_lyric_tokens",val:" = 512"},{name:"n_genres",val:" = 5"},{name:"unk_token",val:" = '<|endoftext|>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxTokenizer.artists_file",description:`<strong>artists_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file which contains a mapping between artists and ids. The default file supports
both &#x201C;v2&#x201D; and &#x201C;v3&#x201D;`,name:"artists_file"},{anchor:"transformers.JukeboxTokenizer.genres_file",description:`<strong>genres_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file which contain a mapping between genres and ids.`,name:"genres_file"},{anchor:"transformers.JukeboxTokenizer.lyrics_file",description:`<strong>lyrics_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file which contains the accepted characters for the lyrics tokenization.`,name:"lyrics_file"},{anchor:"transformers.JukeboxTokenizer.version",description:`<strong>version</strong> (<code>List[str]</code>, <code>optional</code>, default to <code>[&quot;v3&quot;, &quot;v2&quot;, &quot;v2&quot;]</code>)  &#x2014;
List of the tokenizer versions. The <code>5b-lyrics</code>&#x2019;s top level prior model was trained using <code>v3</code> instead of
<code>v2</code>.`,name:"version"},{anchor:"transformers.JukeboxTokenizer.n_genres",description:`<strong>n_genres</strong> (<code>int</code>, <code>optional</code>, defaults to 1) &#x2014;
Maximum number of genres to use for composition.`,name:"n_genres"},{anchor:"transformers.JukeboxTokenizer.max_n_lyric_tokens",description:`<strong>max_n_lyric_tokens</strong> (<code>int</code>, <code>optional</code>, defaults to 512) &#x2014;
Maximum number of lyric tokens to keep.`,name:"max_n_lyric_tokens"},{anchor:"transformers.JukeboxTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|endoftext|&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/tokenization_jukebox.py#L59"}}),G=new Co({props:{anchor:"transformers.JukeboxTokenizer.example",$$slots:{default:[os]},$$scope:{ctx:E}}}),F=new On({props:{$$slots:{default:[ts]},$$scope:{ctx:E}}}),Je=new T({props:{name:"save_vocabulary",anchor:"transformers.JukeboxTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.JukeboxTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
A path to the directory where to saved. It will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"transformers.JukeboxTokenizer.save_vocabulary.filename_prefix",description:`<strong>filename_prefix</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
A prefix to add to the names of the files saved by the tokenizer.`,name:"filename_prefix"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/tokenization_jukebox.py#L372"}}),$e=new D({props:{title:"JukeboxModel",local:"transformers.JukeboxModel",headingTag:"h2"}}),Me=new T({props:{name:"class transformers.JukeboxModel",anchor:"transformers.JukeboxModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.JukeboxModel.config",description:`<strong>config</strong> (<code>JukeboxConfig</code>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L2299"}}),je=new T({props:{name:"ancestral_sample",anchor:"transformers.JukeboxModel.ancestral_sample",parameters:[{name:"labels",val:""},{name:"n_samples",val:" = 1"},{name:"**sampling_kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxModel.ancestral_sample.labels",description:`<strong>labels</strong> (<code>List[torch.LongTensor]</code>)  &#x2014;
List of length <code>n_sample</code>, and shape <code>(self.levels, 4 + self.config.max_nb_genre + lyric_sequence_length)</code> metadata such as <code>artist_id</code>, <code>genre_id</code> and the full list of lyric tokens
which are used to condition the generation.`,name:"labels"},{anchor:"transformers.JukeboxModel.ancestral_sample.n_samples",description:`<strong>n_samples</strong> (<code>int</code>, <em>optional</em>, default to 1)  &#x2014;
Number of samples to be generated in parallel.`,name:"n_samples"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L2573"}}),B=new Co({props:{anchor:"transformers.JukeboxModel.ancestral_sample.example",$$slots:{default:[ns]},$$scope:{ctx:E}}}),Ce=new T({props:{name:"primed_sample",anchor:"transformers.JukeboxModel.primed_sample",parameters:[{name:"raw_audio",val:""},{name:"labels",val:""},{name:"**sampling_kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxModel.primed_sample.raw_audio",description:`<strong>raw_audio</strong> (<code>List[torch.Tensor]</code> of length <code>n_samples</code> )  &#x2014;
A list of raw audio that will be used as conditioning information for each samples that will be
generated.`,name:"raw_audio"},{anchor:"transformers.JukeboxModel.primed_sample.labels",description:`<strong>labels</strong> (<code>List[torch.LongTensor]</code> of length <code>n_sample</code>, and shape <code>(self.levels, self.config.max_nb_genre + lyric_sequence_length)</code>  &#x2014;
List of metadata such as <code>artist_id</code>, <code>genre_id</code> and the full list of lyric tokens which are used to
condition the generation.`,name:"labels"},{anchor:"transformers.JukeboxModel.primed_sample.sampling_kwargs",description:`<strong>sampling_kwargs</strong> (<code>Dict[Any]</code>) &#x2014;
Various additional sampling arguments that are used by the <code>_sample</code> function. A detail list of the
arguments can bee seen in the <code>_sample</code> function documentation.`,name:"sampling_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L2649"}}),Te=new T({props:{name:"continue_sample",anchor:"transformers.JukeboxModel.continue_sample",parameters:[{name:"music_tokens",val:""},{name:"labels",val:""},{name:"**sampling_kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxModel.continue_sample.music_tokens",description:`<strong>music_tokens</strong> (<code>List[torch.LongTensor]</code> of length <code>self.levels</code> )  &#x2014;
A sequence of music tokens which will be used as context to continue the sampling process. Should have
<code>self.levels</code> tensors, each corresponding to the generation at a certain level.`,name:"music_tokens"},{anchor:"transformers.JukeboxModel.continue_sample.labels",description:`<strong>labels</strong> (<code>List[torch.LongTensor]</code> of length <code>n_sample</code>, and shape <code>(self.levels, self.config.max_nb_genre + lyric_sequence_length)</code>  &#x2014;
List of metadata such as <code>artist_id</code>, <code>genre_id</code> and the full list of lyric tokens which are used to
condition the generation.`,name:"labels"},{anchor:"transformers.JukeboxModel.continue_sample.sampling_kwargs",description:`<strong>sampling_kwargs</strong> (<code>Dict[Any]</code>) &#x2014;
Various additional sampling arguments that are used by the <code>_sample</code> function. A detail list of the
arguments can bee seen in the <code>_sample</code> function documentation.`,name:"sampling_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L2619"}}),Ve=new T({props:{name:"upsample",anchor:"transformers.JukeboxModel.upsample",parameters:[{name:"music_tokens",val:""},{name:"labels",val:""},{name:"**sampling_kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxModel.upsample.music_tokens",description:`<strong>music_tokens</strong> (<code>List[torch.LongTensor]</code> of length <code>self.levels</code> )  &#x2014;
A sequence of music tokens which will be used as context to continue the sampling process. Should have
<code>self.levels</code> tensors, each corresponding to the generation at a certain level.`,name:"music_tokens"},{anchor:"transformers.JukeboxModel.upsample.labels",description:`<strong>labels</strong> (<code>List[torch.LongTensor]</code> of length <code>n_sample</code>, and shape <code>(self.levels, self.config.max_nb_genre + lyric_sequence_length)</code>  &#x2014;
List of metadata such as <code>artist_id</code>, <code>genre_id</code> and the full list of lyric tokens which are used to
condition the generation.`,name:"labels"},{anchor:"transformers.JukeboxModel.upsample.sampling_kwargs",description:`<strong>sampling_kwargs</strong> (<code>Dict[Any]</code>) &#x2014;
Various additional sampling arguments that are used by the <code>_sample</code> function. A detail list of the
arguments can bee seen in the <code>_sample</code> function documentation.`,name:"sampling_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L2634"}}),Pe=new T({props:{name:"_sample",anchor:"transformers.JukeboxModel._sample",parameters:[{name:"music_tokens",val:""},{name:"labels",val:""},{name:"sample_levels",val:""},{name:"metas",val:" = None"},{name:"chunk_size",val:" = 32"},{name:"sampling_temperature",val:" = 0.98"},{name:"lower_batch_size",val:" = 16"},{name:"max_batch_size",val:" = 16"},{name:"sample_length_in_seconds",val:" = 24"},{name:"compute_alignments",val:" = False"},{name:"sample_tokens",val:" = None"},{name:"offset",val:" = 0"},{name:"save_results",val:" = True"},{name:"sample_length",val:" = None"}],parametersDescription:[{anchor:"transformers.JukeboxModel._sample.music_tokens",description:`<strong>music_tokens</strong> (<code>List[torch.LongTensor]</code>) &#x2014;
A sequence of music tokens of length <code>self.levels</code> which will be used as context to continue the
sampling process. Should have <code>self.levels</code> tensors, each corresponding to the generation at a certain
level.`,name:"music_tokens"},{anchor:"transformers.JukeboxModel._sample.labels",description:`<strong>labels</strong> (<code>List[torch.LongTensor]</code>) &#x2014;
List of length <code>n_sample</code>, and shape <code>(self.levels, 4 + self.config.max_nb_genre + lyric_sequence_length)</code> metadata such as <code>artist_id</code>, <code>genre_id</code> and the full list of lyric tokens
which are used to condition the generation.`,name:"labels"},{anchor:"transformers.JukeboxModel._sample.sample_levels",description:`<strong>sample_levels</strong> (<code>List[int]</code>) &#x2014;
List of the desired levels at which the sampling will be done. A level is equivalent to the index of
the prior in the list of priors`,name:"sample_levels"},{anchor:"transformers.JukeboxModel._sample.metas",description:`<strong>metas</strong> (<code>List[Any]</code>, <em>optional</em>) &#x2014;
Metadatas used to generate the <code>labels</code>`,name:"metas"},{anchor:"transformers.JukeboxModel._sample.chunk_size",description:`<strong>chunk_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Size of a chunk of audio, used to fill up the memory in chuncks to prevent OOM erros. Bigger chunks
means faster memory filling but more consumption.`,name:"chunk_size"},{anchor:"transformers.JukeboxModel._sample.sampling_temperature",description:`<strong>sampling_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 0.98) &#x2014;
Temperature used to ajust the randomness of the sampling.`,name:"sampling_temperature"},{anchor:"transformers.JukeboxModel._sample.lower_batch_size",description:`<strong>lower_batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Maximum batch size for the lower level priors`,name:"lower_batch_size"},{anchor:"transformers.JukeboxModel._sample.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Maximum batch size for the top level priors`,name:"max_batch_size"},{anchor:"transformers.JukeboxModel._sample.sample_length_in_seconds",description:`<strong>sample_length_in_seconds</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Desired length of the generation in seconds`,name:"sample_length_in_seconds"},{anchor:"transformers.JukeboxModel._sample.compute_alignments",description:`<strong>compute_alignments</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to compute the alignment between the lyrics and the audio using the top_prior`,name:"compute_alignments"},{anchor:"transformers.JukeboxModel._sample.sample_tokens",description:`<strong>sample_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Precise number of tokens that should be sampled at each level. This is mostly useful for running dummy
experiments`,name:"sample_tokens"},{anchor:"transformers.JukeboxModel._sample.offset",description:`<strong>offset</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Audio offset used as conditioning, corresponds to the starting sample in the music. If the offset is
greater than 0, the lyrics will be shifted take that intoaccount`,name:"offset"},{anchor:"transformers.JukeboxModel._sample.save_results",description:`<strong>save_results</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to save the intermediate results. If <code>True</code>, will generate a folder named with the start
time.`,name:"save_results"},{anchor:"transformers.JukeboxModel._sample.sample_length",description:`<strong>sample_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Desired length of the generation in samples.`,name:"sample_length"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L2434"}}),O=new Co({props:{anchor:"transformers.JukeboxModel._sample.example",$$slots:{default:[ss]},$$scope:{ctx:E}}}),Ue=new D({props:{title:"JukeboxPrior",local:"transformers.JukeboxPrior",headingTag:"h2"}}),Ee=new T({props:{name:"class transformers.JukeboxPrior",anchor:"transformers.JukeboxPrior",parameters:[{name:"config",val:": JukeboxPriorConfig"},{name:"level",val:" = None"},{name:"nb_priors",val:" = 3"},{name:"vqvae_encoder",val:" = None"},{name:"vqvae_decoder",val:" = None"}],parametersDescription:[{anchor:"transformers.JukeboxPrior.config",description:`<strong>config</strong> (<code>JukeboxPriorConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.JukeboxPrior.level",description:`<strong>level</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Current level of the Prior. Should be in range <code>[0,nb_priors]</code>.`,name:"level"},{anchor:"transformers.JukeboxPrior.nb_priors",description:`<strong>nb_priors</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Total number of priors.`,name:"nb_priors"},{anchor:"transformers.JukeboxPrior.vqvae_encoder",description:`<strong>vqvae_encoder</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Encoding method of the VQVAE encoder used in the forward pass of the model. Passing functions instead of
the vqvae module to avoid getting the parameters.`,name:"vqvae_encoder"},{anchor:"transformers.JukeboxPrior.vqvae_decoder",description:`<strong>vqvae_decoder</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Decoding method of the VQVAE decoder used in the forward pass of the model. Passing functions instead of
the vqvae module to avoid getting the parameters.`,name:"vqvae_decoder"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L1769"}}),ze=new T({props:{name:"sample",anchor:"transformers.JukeboxPrior.sample",parameters:[{name:"n_samples",val:""},{name:"music_tokens",val:" = None"},{name:"music_tokens_conds",val:" = None"},{name:"metadata",val:" = None"},{name:"temp",val:" = 1.0"},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 0.0"},{name:"chunk_size",val:" = None"},{name:"sample_tokens",val:" = None"}],parametersDescription:[{anchor:"transformers.JukeboxPrior.sample.n_samples",description:`<strong>n_samples</strong> (<code>int</code>) &#x2014;
Number of samples to generate.`,name:"n_samples"},{anchor:"transformers.JukeboxPrior.sample.music_tokens",description:`<strong>music_tokens</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
Previously gemerated tokens at the current level. Used as context for the generation.`,name:"music_tokens"},{anchor:"transformers.JukeboxPrior.sample.music_tokens_conds",description:`<strong>music_tokens_conds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Upper-level music tokens generated by the previous prior model. Is <code>None</code> if the generation is not
conditionned on the upper-level tokens.`,name:"music_tokens_conds"},{anchor:"transformers.JukeboxPrior.sample.metadata",description:`<strong>metadata</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
List containing the metatdata tensor with the artist, genre and the lyric tokens.`,name:"metadata"},{anchor:"transformers.JukeboxPrior.sample.temp",description:`<strong>temp</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Sampling temperature.`,name:"temp"},{anchor:"transformers.JukeboxPrior.sample.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Top k probabilities used for filtering.`,name:"top_k"},{anchor:"transformers.JukeboxPrior.sample.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Top p probabilities used for filtering.`,name:"top_p"},{anchor:"transformers.JukeboxPrior.sample.chunk_size",description:`<strong>chunk_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Size of the chunks used to prepare the cache of the transformer.`,name:"chunk_size"},{anchor:"transformers.JukeboxPrior.sample.sample_tokens",description:`<strong>sample_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of tokens to sample.`,name:"sample_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L2059"}}),Le=new T({props:{name:"forward",anchor:"transformers.JukeboxPrior.forward",parameters:[{name:"hidden_states",val:": Tensor"},{name:"metadata",val:": typing.Optional[typing.List[torch.LongTensor]]"},{name:"decode",val:": typing.Optional[bool] = False"},{name:"get_preds",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.JukeboxPrior.forward.hidden_states",description:`<strong>hidden_states</strong> (<code>torch.Tensor</code>) &#x2014;
Hidden states which should be raw audio`,name:"hidden_states"},{anchor:"transformers.JukeboxPrior.forward.metadata",description:`<strong>metadata</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
List containing the metadata conditioning tensorwith the lyric and the metadata tokens.`,name:"metadata"},{anchor:"transformers.JukeboxPrior.forward.decode",description:`<strong>decode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decode the encoded to tokens.`,name:"decode"},{anchor:"transformers.JukeboxPrior.forward.get_preds",description:`<strong>get_preds</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the actual predicitons of the model.`,name:"get_preds"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L2227"}}),Ae=new D({props:{title:"JukeboxVQVAE",local:"transformers.JukeboxVQVAE",headingTag:"h2"}}),We=new T({props:{name:"class transformers.JukeboxVQVAE",anchor:"transformers.JukeboxVQVAE",parameters:[{name:"config",val:": JukeboxVQVAEConfig"}],parametersDescription:[{anchor:"transformers.JukeboxVQVAE.config",description:`<strong>config</strong> (<code>JukeboxConfig</code>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L602"}}),Qe=new T({props:{name:"forward",anchor:"transformers.JukeboxVQVAE.forward",parameters:[{name:"raw_audio",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.JukeboxVQVAE.forward.raw_audio",description:`<strong>raw_audio</strong> (<code>torch.FloatTensor</code>) &#x2014;
Audio input which will be encoded and decoded.`,name:"raw_audio"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L739",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[torch.Tensor, torch.Tensor]</code></p>
`}}),te=new Co({props:{anchor:"transformers.JukeboxVQVAE.forward.example",$$slots:{default:[rs]},$$scope:{ctx:E}}}),Ie=new T({props:{name:"encode",anchor:"transformers.JukeboxVQVAE.encode",parameters:[{name:"input_audio",val:""},{name:"start_level",val:" = 0"},{name:"end_level",val:" = None"},{name:"bs_chunks",val:" = 1"}],parametersDescription:[{anchor:"transformers.JukeboxVQVAE.encode.input_audio",description:`<strong>input_audio</strong> (<code>torch.Tensor</code>) &#x2014;
Raw audio which will be encoded to its discrete representation using the codebook. The closest <code>code</code>
form the codebook will be computed for each sequence of samples.`,name:"input_audio"},{anchor:"transformers.JukeboxVQVAE.encode.start_level",description:`<strong>start_level</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Level at which the encoding process will start. Default to 0.`,name:"start_level"},{anchor:"transformers.JukeboxVQVAE.encode.end_level",description:`<strong>end_level</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Level at which the encoding process will start. Default to None.`,name:"end_level"},{anchor:"transformers.JukeboxVQVAE.encode.bs_chunks",description:`<strong>bs_chunks</strong> (int, <em>optional</em>, defaults to 1) &#x2014;
Number of chunks of raw audio to process at the same time.`,name:"bs_chunks"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L709"}}),qe=new T({props:{name:"decode",anchor:"transformers.JukeboxVQVAE.decode",parameters:[{name:"music_tokens",val:""},{name:"start_level",val:" = 0"},{name:"end_level",val:" = None"},{name:"bs_chunks",val:" = 1"}],parametersDescription:[{anchor:"transformers.JukeboxVQVAE.decode.music_tokens",description:`<strong>music_tokens</strong> (<code>torch.LongTensor</code>) &#x2014;
Tensor of music tokens which will be decoded to raw audio by using the codebook. Each music token
should be an index to a corresponding <code>code</code> vector in the codebook.`,name:"music_tokens"},{anchor:"transformers.JukeboxVQVAE.decode.start_level",description:`<strong>start_level</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Level at which the decoding process will start. Default to 0.`,name:"start_level"},{anchor:"transformers.JukeboxVQVAE.decode.end_level",description:`<strong>end_level</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Level at which the decoding process will start. Default to None.`,name:"end_level"},{anchor:"transformers.JukeboxVQVAE.decode.bs_chunks",description:`<strong>bs_chunks</strong> (int, <em>optional</em>) &#x2014;
Number of chunks to process at the same time.`,name:"bs_chunks"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/jukebox/modeling_jukebox.py#L673"}}),{c(){d=r("meta"),w=t(),p=r("p"),u=t(),h(x.$$.fragment),l=t(),h(J.$$.fragment),Vo=t(),ie=r("p"),ie.innerHTML=rn,Po=t(),le=r("p"),le.textContent=an,Uo=t(),de=r("p"),de.innerHTML=ln,Eo=t(),ce=r("p"),ce.innerHTML=dn,zo=t(),me=r("p"),me.innerHTML=cn,Lo=t(),pe=r("p"),pe.textContent=mn,Ao=t(),ue=r("ul"),ue.innerHTML=pn,Wo=t(),he=r("p"),he.innerHTML=un,Qo=t(),h(fe.$$.fragment),Io=t(),P=r("div"),h(ge.$$.fragment),it=t(),De=r("p"),De.innerHTML=hn,lt=t(),Re=r("p"),Re.innerHTML=fn,dt=t(),Ne=r("p"),Ne.textContent=gn,ct=t(),h(R.$$.fragment),mt=t(),N=r("div"),h(be.$$.fragment),pt=t(),Ge=r("p"),Ge.innerHTML=bn,qo=t(),h(_e.$$.fragment),Zo=t(),W=r("div"),h(ve.$$.fragment),ut=t(),Fe=r("p"),Fe.innerHTML=_n,ht=t(),Se=r("p"),Se.innerHTML=vn,Ho=t(),h(xe.$$.fragment),Do=t(),Q=r("div"),h(ke.$$.fragment),ft=t(),Be=r("p"),Be.innerHTML=xn,gt=t(),Xe=r("p"),Xe.innerHTML=kn,Ro=t(),h(ye.$$.fragment),No=t(),k=r("div"),h(we.$$.fragment),bt=t(),Ye=r("p"),Ye.textContent=yn,_t=t(),Ke=r("ul"),Ke.innerHTML=wn,vt=t(),Oe=r("p"),Oe.textContent=Jn,xt=t(),eo=r("p"),eo.innerHTML=$n,kt=t(),h(G.$$.fragment),yt=t(),oo=r("p"),oo.innerHTML=Mn,wt=t(),h(F.$$.fragment),Jt=t(),to=r("p"),to.innerHTML=jn,$t=t(),no=r("p"),no.textContent=Cn,Mt=t(),S=r("div"),h(Je.$$.fragment),jt=t(),so=r("p"),so.textContent=Tn,Go=t(),h($e.$$.fragment),Fo=t(),$=r("div"),h(Me.$$.fragment),Ct=t(),ro=r("p"),ro.innerHTML=Vn,Tt=t(),ao=r("p"),ao.innerHTML=Pn,Vt=t(),io=r("p"),io.innerHTML=Un,Pt=t(),I=r("div"),h(je.$$.fragment),Ut=t(),lo=r("p"),lo.innerHTML=En,Et=t(),h(B.$$.fragment),zt=t(),X=r("div"),h(Ce.$$.fragment),Lt=t(),co=r("p"),co.innerHTML=zn,At=t(),Y=r("div"),h(Te.$$.fragment),Wt=t(),mo=r("p"),mo.textContent=Ln,Qt=t(),K=r("div"),h(Ve.$$.fragment),It=t(),po=r("p"),po.innerHTML=An,qt=t(),A=r("div"),h(Pe.$$.fragment),Zt=t(),uo=r("p"),uo.textContent=Wn,Ht=t(),ho=r("p"),ho.textContent=Qn,Dt=t(),h(O.$$.fragment),So=t(),h(Ue.$$.fragment),Bo=t(),L=r("div"),h(Ee.$$.fragment),Rt=t(),fo=r("p"),fo.innerHTML=In,Nt=t(),ee=r("div"),h(ze.$$.fragment),Gt=t(),go=r("p"),go.textContent=qn,Ft=t(),oe=r("div"),h(Le.$$.fragment),St=t(),bo=r("p"),bo.innerHTML=Zn,Xo=t(),h(Ae.$$.fragment),Yo=t(),C=r("div"),h(We.$$.fragment),Bt=t(),_o=r("p"),_o.innerHTML=Hn,Xt=t(),vo=r("p"),vo.innerHTML=Dn,Yt=t(),xo=r("p"),xo.innerHTML=Rn,Kt=t(),q=r("div"),h(Qe.$$.fragment),Ot=t(),ko=r("p"),ko.innerHTML=Nn,en=t(),h(te.$$.fragment),on=t(),ne=r("div"),h(Ie.$$.fragment),tn=t(),yo=r("p"),yo.innerHTML=Gn,nn=t(),se=r("div"),h(qe.$$.fragment),sn=t(),wo=r("p"),wo.innerHTML=Fn,Ko=t(),jo=r("p"),this.h()},l(e){const i=Kn("svelte-u9bgzb",document.head);d=a(i,"META",{name:!0,content:!0}),i.forEach(s),w=n(e),p=a(e,"P",{}),M(p).forEach(s),u=n(e),f(x.$$.fragment,e),l=n(e),f(J.$$.fragment,e),Vo=n(e),ie=a(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1ax856a"&&(ie.innerHTML=rn),Po=n(e),le=a(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-vfdo9a"&&(le.textContent=an),Uo=n(e),de=a(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-nitrj1"&&(de.innerHTML=ln),Eo=n(e),ce=a(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1uxolic"&&(ce.innerHTML=dn),zo=n(e),me=a(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-10w2oqd"&&(me.innerHTML=cn),Lo=n(e),pe=a(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-axv494"&&(pe.textContent=mn),Ao=n(e),ue=a(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-15yvdpa"&&(ue.innerHTML=pn),Wo=n(e),he=a(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-i0ky6l"&&(he.innerHTML=un),Qo=n(e),f(fe.$$.fragment,e),Io=n(e),P=a(e,"DIV",{class:!0});var U=M(P);f(ge.$$.fragment,U),it=n(U),De=a(U,"P",{"data-svelte-h":!0}),m(De)!=="svelte-x3mtiy"&&(De.innerHTML=hn),lt=n(U),Re=a(U,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1eh1tso"&&(Re.innerHTML=fn),dt=n(U),Ne=a(U,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1ge4jf0"&&(Ne.textContent=gn),ct=n(U),f(R.$$.fragment,U),mt=n(U),N=a(U,"DIV",{class:!0});var Ze=M(N);f(be.$$.fragment,Ze),pt=n(Ze),Ge=a(Ze,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1kmvw3p"&&(Ge.innerHTML=bn),Ze.forEach(s),U.forEach(s),qo=n(e),f(_e.$$.fragment,e),Zo=n(e),W=a(e,"DIV",{class:!0});var Z=M(W);f(ve.$$.fragment,Z),ut=n(Z),Fe=a(Z,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-1dz77qw"&&(Fe.innerHTML=_n),ht=n(Z),Se=a(Z,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-1g275hz"&&(Se.innerHTML=vn),Z.forEach(s),Ho=n(e),f(xe.$$.fragment,e),Do=n(e),Q=a(e,"DIV",{class:!0});var H=M(Q);f(ke.$$.fragment,H),ft=n(H),Be=a(H,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-5kfefk"&&(Be.innerHTML=xn),gt=n(H),Xe=a(H,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-1g275hz"&&(Xe.innerHTML=kn),H.forEach(s),Ro=n(e),f(ye.$$.fragment,e),No=n(e),k=a(e,"DIV",{class:!0});var y=M(k);f(we.$$.fragment,y),bt=n(y),Ye=a(y,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-g45kr3"&&(Ye.textContent=yn),_t=n(y),Ke=a(y,"UL",{"data-svelte-h":!0}),m(Ke)!=="svelte-1275agq"&&(Ke.innerHTML=wn),vt=n(y),Oe=a(y,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-1ohtqdr"&&(Oe.textContent=Jn),xt=n(y),eo=a(y,"P",{"data-svelte-h":!0}),m(eo)!=="svelte-1p2f8vn"&&(eo.innerHTML=$n),kt=n(y),f(G.$$.fragment,y),yt=n(y),oo=a(y,"P",{"data-svelte-h":!0}),m(oo)!=="svelte-1jfcabo"&&(oo.innerHTML=Mn),wt=n(y),f(F.$$.fragment,y),Jt=n(y),to=a(y,"P",{"data-svelte-h":!0}),m(to)!=="svelte-saowa9"&&(to.innerHTML=jn),$t=n(y),no=a(y,"P",{"data-svelte-h":!0}),m(no)!=="svelte-ocbpqr"&&(no.textContent=Cn),Mt=n(y),S=a(y,"DIV",{class:!0});var He=M(S);f(Je.$$.fragment,He),jt=n(He),so=a(He,"P",{"data-svelte-h":!0}),m(so)!=="svelte-1ht6cxs"&&(so.textContent=Tn),He.forEach(s),y.forEach(s),Go=n(e),f($e.$$.fragment,e),Fo=n(e),$=a(e,"DIV",{class:!0});var V=M($);f(Me.$$.fragment,V),Ct=n(V),ro=a(V,"P",{"data-svelte-h":!0}),m(ro)!=="svelte-1fljc29"&&(ro.innerHTML=Vn),Tt=n(V),ao=a(V,"P",{"data-svelte-h":!0}),m(ao)!=="svelte-1ku9owf"&&(ao.innerHTML=Pn),Vt=n(V),io=a(V,"P",{"data-svelte-h":!0}),m(io)!=="svelte-hswkmf"&&(io.innerHTML=Un),Pt=n(V),I=a(V,"DIV",{class:!0});var Jo=M(I);f(je.$$.fragment,Jo),Ut=n(Jo),lo=a(Jo,"P",{"data-svelte-h":!0}),m(lo)!=="svelte-1ah1sdk"&&(lo.innerHTML=En),Et=n(Jo),f(B.$$.fragment,Jo),Jo.forEach(s),zt=n(V),X=a(V,"DIV",{class:!0});var et=M(X);f(Ce.$$.fragment,et),Lt=n(et),co=a(et,"P",{"data-svelte-h":!0}),m(co)!=="svelte-awu8ei"&&(co.innerHTML=zn),et.forEach(s),At=n(V),Y=a(V,"DIV",{class:!0});var ot=M(Y);f(Te.$$.fragment,ot),Wt=n(ot),mo=a(ot,"P",{"data-svelte-h":!0}),m(mo)!=="svelte-130urlt"&&(mo.textContent=Ln),ot.forEach(s),Qt=n(V),K=a(V,"DIV",{class:!0});var tt=M(K);f(Ve.$$.fragment,tt),It=n(tt),po=a(tt,"P",{"data-svelte-h":!0}),m(po)!=="svelte-19aywgj"&&(po.innerHTML=An),tt.forEach(s),qt=n(V),A=a(V,"DIV",{class:!0});var re=M(A);f(Pe.$$.fragment,re),Zt=n(re),uo=a(re,"P",{"data-svelte-h":!0}),m(uo)!=="svelte-1nmq94k"&&(uo.textContent=Wn),Ht=n(re),ho=a(re,"P",{"data-svelte-h":!0}),m(ho)!=="svelte-1c3z8g4"&&(ho.textContent=Qn),Dt=n(re),f(O.$$.fragment,re),re.forEach(s),V.forEach(s),So=n(e),f(Ue.$$.fragment,e),Bo=n(e),L=a(e,"DIV",{class:!0});var ae=M(L);f(Ee.$$.fragment,ae),Rt=n(ae),fo=a(ae,"P",{"data-svelte-h":!0}),m(fo)!=="svelte-1ewbg8g"&&(fo.innerHTML=In),Nt=n(ae),ee=a(ae,"DIV",{class:!0});var nt=M(ee);f(ze.$$.fragment,nt),Gt=n(nt),go=a(nt,"P",{"data-svelte-h":!0}),m(go)!=="svelte-1tv9c3k"&&(go.textContent=qn),nt.forEach(s),Ft=n(ae),oe=a(ae,"DIV",{class:!0});var st=M(oe);f(Le.$$.fragment,st),St=n(st),bo=a(st,"P",{"data-svelte-h":!0}),m(bo)!=="svelte-6kqsha"&&(bo.innerHTML=Zn),st.forEach(s),ae.forEach(s),Xo=n(e),f(Ae.$$.fragment,e),Yo=n(e),C=a(e,"DIV",{class:!0});var z=M(C);f(We.$$.fragment,z),Bt=n(z),_o=a(z,"P",{"data-svelte-h":!0}),m(_o)!=="svelte-ltbxkh"&&(_o.innerHTML=Hn),Xt=n(z),vo=a(z,"P",{"data-svelte-h":!0}),m(vo)!=="svelte-1ku9owf"&&(vo.innerHTML=Dn),Yt=n(z),xo=a(z,"P",{"data-svelte-h":!0}),m(xo)!=="svelte-hswkmf"&&(xo.innerHTML=Rn),Kt=n(z),q=a(z,"DIV",{class:!0});var $o=M(q);f(Qe.$$.fragment,$o),Ot=n($o),ko=a($o,"P",{"data-svelte-h":!0}),m(ko)!=="svelte-1bropk3"&&(ko.innerHTML=Nn),en=n($o),f(te.$$.fragment,$o),$o.forEach(s),on=n(z),ne=a(z,"DIV",{class:!0});var rt=M(ne);f(Ie.$$.fragment,rt),tn=n(rt),yo=a(rt,"P",{"data-svelte-h":!0}),m(yo)!=="svelte-14si36p"&&(yo.innerHTML=Gn),rt.forEach(s),nn=n(z),se=a(z,"DIV",{class:!0});var at=M(se);f(qe.$$.fragment,at),sn=n(at),wo=a(at,"P",{"data-svelte-h":!0}),m(wo)!=="svelte-dyifa7"&&(wo.innerHTML=Fn),at.forEach(s),z.forEach(s),Ko=n(e),jo=a(e,"P",{}),M(jo).forEach(s),this.h()},h(){j(d,"name","hf:doc:metadata"),j(d,"content",is),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){o(document.head,d),c(e,w,i),c(e,p,i),c(e,u,i),g(x,e,i),c(e,l,i),g(J,e,i),c(e,Vo,i),c(e,ie,i),c(e,Po,i),c(e,le,i),c(e,Uo,i),c(e,de,i),c(e,Eo,i),c(e,ce,i),c(e,zo,i),c(e,me,i),c(e,Lo,i),c(e,pe,i),c(e,Ao,i),c(e,ue,i),c(e,Wo,i),c(e,he,i),c(e,Qo,i),g(fe,e,i),c(e,Io,i),c(e,P,i),g(ge,P,null),o(P,it),o(P,De),o(P,lt),o(P,Re),o(P,dt),o(P,Ne),o(P,ct),g(R,P,null),o(P,mt),o(P,N),g(be,N,null),o(N,pt),o(N,Ge),c(e,qo,i),g(_e,e,i),c(e,Zo,i),c(e,W,i),g(ve,W,null),o(W,ut),o(W,Fe),o(W,ht),o(W,Se),c(e,Ho,i),g(xe,e,i),c(e,Do,i),c(e,Q,i),g(ke,Q,null),o(Q,ft),o(Q,Be),o(Q,gt),o(Q,Xe),c(e,Ro,i),g(ye,e,i),c(e,No,i),c(e,k,i),g(we,k,null),o(k,bt),o(k,Ye),o(k,_t),o(k,Ke),o(k,vt),o(k,Oe),o(k,xt),o(k,eo),o(k,kt),g(G,k,null),o(k,yt),o(k,oo),o(k,wt),g(F,k,null),o(k,Jt),o(k,to),o(k,$t),o(k,no),o(k,Mt),o(k,S),g(Je,S,null),o(S,jt),o(S,so),c(e,Go,i),g($e,e,i),c(e,Fo,i),c(e,$,i),g(Me,$,null),o($,Ct),o($,ro),o($,Tt),o($,ao),o($,Vt),o($,io),o($,Pt),o($,I),g(je,I,null),o(I,Ut),o(I,lo),o(I,Et),g(B,I,null),o($,zt),o($,X),g(Ce,X,null),o(X,Lt),o(X,co),o($,At),o($,Y),g(Te,Y,null),o(Y,Wt),o(Y,mo),o($,Qt),o($,K),g(Ve,K,null),o(K,It),o(K,po),o($,qt),o($,A),g(Pe,A,null),o(A,Zt),o(A,uo),o(A,Ht),o(A,ho),o(A,Dt),g(O,A,null),c(e,So,i),g(Ue,e,i),c(e,Bo,i),c(e,L,i),g(Ee,L,null),o(L,Rt),o(L,fo),o(L,Nt),o(L,ee),g(ze,ee,null),o(ee,Gt),o(ee,go),o(L,Ft),o(L,oe),g(Le,oe,null),o(oe,St),o(oe,bo),c(e,Xo,i),g(Ae,e,i),c(e,Yo,i),c(e,C,i),g(We,C,null),o(C,Bt),o(C,_o),o(C,Xt),o(C,vo),o(C,Yt),o(C,xo),o(C,Kt),o(C,q),g(Qe,q,null),o(q,Ot),o(q,ko),o(q,en),g(te,q,null),o(C,on),o(C,ne),g(Ie,ne,null),o(ne,tn),o(ne,yo),o(C,nn),o(C,se),g(qe,se,null),o(se,sn),o(se,wo),c(e,Ko,i),c(e,jo,i),Oo=!0},p(e,[i]){const U={};i&2&&(U.$$scope={dirty:i,ctx:e}),R.$set(U);const Ze={};i&2&&(Ze.$$scope={dirty:i,ctx:e}),G.$set(Ze);const Z={};i&2&&(Z.$$scope={dirty:i,ctx:e}),F.$set(Z);const H={};i&2&&(H.$$scope={dirty:i,ctx:e}),B.$set(H);const y={};i&2&&(y.$$scope={dirty:i,ctx:e}),O.$set(y);const He={};i&2&&(He.$$scope={dirty:i,ctx:e}),te.$set(He)},i(e){Oo||(b(x.$$.fragment,e),b(J.$$.fragment,e),b(fe.$$.fragment,e),b(ge.$$.fragment,e),b(R.$$.fragment,e),b(be.$$.fragment,e),b(_e.$$.fragment,e),b(ve.$$.fragment,e),b(xe.$$.fragment,e),b(ke.$$.fragment,e),b(ye.$$.fragment,e),b(we.$$.fragment,e),b(G.$$.fragment,e),b(F.$$.fragment,e),b(Je.$$.fragment,e),b($e.$$.fragment,e),b(Me.$$.fragment,e),b(je.$$.fragment,e),b(B.$$.fragment,e),b(Ce.$$.fragment,e),b(Te.$$.fragment,e),b(Ve.$$.fragment,e),b(Pe.$$.fragment,e),b(O.$$.fragment,e),b(Ue.$$.fragment,e),b(Ee.$$.fragment,e),b(ze.$$.fragment,e),b(Le.$$.fragment,e),b(Ae.$$.fragment,e),b(We.$$.fragment,e),b(Qe.$$.fragment,e),b(te.$$.fragment,e),b(Ie.$$.fragment,e),b(qe.$$.fragment,e),Oo=!0)},o(e){_(x.$$.fragment,e),_(J.$$.fragment,e),_(fe.$$.fragment,e),_(ge.$$.fragment,e),_(R.$$.fragment,e),_(be.$$.fragment,e),_(_e.$$.fragment,e),_(ve.$$.fragment,e),_(xe.$$.fragment,e),_(ke.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(G.$$.fragment,e),_(F.$$.fragment,e),_(Je.$$.fragment,e),_($e.$$.fragment,e),_(Me.$$.fragment,e),_(je.$$.fragment,e),_(B.$$.fragment,e),_(Ce.$$.fragment,e),_(Te.$$.fragment,e),_(Ve.$$.fragment,e),_(Pe.$$.fragment,e),_(O.$$.fragment,e),_(Ue.$$.fragment,e),_(Ee.$$.fragment,e),_(ze.$$.fragment,e),_(Le.$$.fragment,e),_(Ae.$$.fragment,e),_(We.$$.fragment,e),_(Qe.$$.fragment,e),_(te.$$.fragment,e),_(Ie.$$.fragment,e),_(qe.$$.fragment,e),Oo=!1},d(e){e&&(s(w),s(p),s(u),s(l),s(Vo),s(ie),s(Po),s(le),s(Uo),s(de),s(Eo),s(ce),s(zo),s(me),s(Lo),s(pe),s(Ao),s(ue),s(Wo),s(he),s(Qo),s(Io),s(P),s(qo),s(Zo),s(W),s(Ho),s(Do),s(Q),s(Ro),s(No),s(k),s(Go),s(Fo),s($),s(So),s(Bo),s(L),s(Xo),s(Yo),s(C),s(Ko),s(jo)),s(d),v(x,e),v(J,e),v(fe,e),v(ge),v(R),v(be),v(_e,e),v(ve),v(xe,e),v(ke),v(ye,e),v(we),v(G),v(F),v(Je),v($e,e),v(Me),v(je),v(B),v(Ce),v(Te),v(Ve),v(Pe),v(O),v(Ue,e),v(Ee),v(ze),v(Le),v(Ae,e),v(We),v(Qe),v(te),v(Ie),v(qe)}}}const is='{"title":"Jukebox","local":"jukebox","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"JukeboxConfig","local":"transformers.JukeboxConfig","sections":[],"depth":2},{"title":"JukeboxPriorConfig","local":"transformers.JukeboxPriorConfig","sections":[],"depth":2},{"title":"JukeboxVQVAEConfig","local":"transformers.JukeboxVQVAEConfig","sections":[],"depth":2},{"title":"JukeboxTokenizer","local":"transformers.JukeboxTokenizer","sections":[],"depth":2},{"title":"JukeboxModel","local":"transformers.JukeboxModel","sections":[],"depth":2},{"title":"JukeboxPrior","local":"transformers.JukeboxPrior","sections":[],"depth":2},{"title":"JukeboxVQVAE","local":"transformers.JukeboxVQVAE","sections":[],"depth":2}],"depth":1}';function ls(E){return Bn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gs extends Xn{constructor(d){super(),Yn(this,d,ls,as,Sn,{})}}export{gs as component};
